// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7072__auto__ = (((obj == null))?null:obj);
var m__7073__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__7073__auto__.call(null,obj));
} else {
var m__7073__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__7073__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__39623 = millis;
if((G__39623 == null)){
return null;
} else {
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__39623) : goog.date.UtcDateTime.fromTimestamp.call(null,G__39623));
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first((function (){var iter__7189__auto__ = (function cljs_time$coerce$from_string_$_iter__39634(s__39635){
return (new cljs.core.LazySeq(null,(function (){
var s__39635__$1 = s__39635;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39635__$1);
if(temp__4657__auto__){
var s__39635__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39635__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39635__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39637 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39636 = (0);
while(true){
if((i__39636 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39636);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e39642){if((e39642 instanceof Error)){
var _ = e39642;
return null;
} else {
throw e39642;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__39637,d);

var G__39644 = (i__39636 + (1));
i__39636 = G__39644;
continue;
} else {
var G__39645 = (i__39636 + (1));
i__39636 = G__39645;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39637),cljs_time$coerce$from_string_$_iter__39634(cljs.core.chunk_rest(s__39635__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39637),null);
}
} else {
var f = cljs.core.first(s__39635__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e39643){if((e39643 instanceof Error)){
var _ = e39643;
return null;
} else {
throw e39643;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__39634(cljs.core.rest(s__39635__$2)));
} else {
var G__39646 = cljs.core.rest(s__39635__$2);
s__39635__$1 = G__39646;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__39648 = date;
var G__39648__$1 = (((G__39648 == null))?null:G__39648.getTime());
if((G__39648__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long(G__39648__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__39650 = obj;
var G__39650__$1 = (((G__39650 == null))?null:cljs_time.coerce.to_date_time(G__39650));
if((G__39650__$1 == null)){
return null;
} else {
return G__39650__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var G__39652 = obj;
var G__39652__$1 = (((G__39652 == null))?null:cljs_time.coerce.to_long(G__39652));
if((G__39652__$1 == null)){
return null;
} else {
return (G__39652__$1 / (1000));
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__39654 = obj;
var G__39654__$1 = (((G__39654 == null))?null:cljs_time.coerce.to_date_time(G__39654));
var G__39654__$2 = (((G__39654__$1 == null))?null:G__39654__$1.getTime());
if((G__39654__$2 == null)){
return null;
} else {
return (new Date(G__39654__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__39656 = obj;
var G__39656__$1 = (((G__39656 == null))?null:cljs_time.coerce.to_date_time(G__39656));
if((G__39656__$1 == null)){
return null;
} else {
return cljs_time.format.unparse(cljs.core.cst$kw$date_DASH_time.cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__39656__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__39658 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__39658.setHours(dt.getHours());

G__39658.setMinutes(dt.getMinutes());

G__39658.setSeconds(dt.getSeconds());

G__39658.setMilliseconds(dt.getMilliseconds());

return G__39658;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
var G__39659 = (new goog.date.UtcDateTime());
G__39659.set(local_date__$1);

return G__39659;
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
var G__39660 = (new goog.date.UtcDateTime());
G__39660.setTime(local_date_time__$1.getTime());

return G__39660;
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long(long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string(string);
}));
