// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"user-guide","user-guide",774875009),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"map","map",1371690461)],[new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"user-guide","user-guide",774875009),new cljs.core.Keyword(null,"label","label",1718410804),"User Guide",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036),new cljs.core.Keyword(null,"label","label",1718410804),"Table",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"report-view","report-view",-1592707414),new cljs.core.Keyword(null,"label","label",1718410804),"Reports",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),new cljs.core.Keyword(null,"label","label",1718410804),"Dashboard",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"label","label",1718410804),"Settings",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"overview","overview",-435037267),new cljs.core.Keyword(null,"label","label",1718410804),"Overview",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.Keyword(null,"label","label",1718410804),"Charts",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"photos","photos",11691538),new cljs.core.Keyword(null,"label","label",1718410804),"Photos",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"map","map",1371690461),new cljs.core.Keyword(null,"label","label",1718410804),"Map",new cljs.core.Keyword(null,"component","component",1555936782),hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return cljs.core.atom.call(null,hatti.views.dataview.dataview_map);
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews.call(null);
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.inactive","a.inactive",1325252702),[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tooltip","span.tooltip",-934616418),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info.tooltip","span.tip-info.tooltip",498786549),(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__25984 = cljs.core._EQ_;
var expr__25985 = view;
if(cljs.core.truth_(pred__25984.call(null,new cljs.core.Keyword(null,"map","map",1371690461),expr__25985))){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_(pred__25984.call(null,new cljs.core.Keyword(null,"photos","photos",11691538),expr__25985))){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_(pred__25984.call(null,new cljs.core.Keyword(null,"table","table",-564943036),expr__25985))){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_(pred__25984.call(null,new cljs.core.Keyword(null,"chart","chart",1173225425),expr__25985))){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_(pred__25984.call(null,new cljs.core.Keyword(null,"saved-charts","saved-charts",2129251691),expr__25985))){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-question","span.tip-question",1059090371),"?"], null)], null)], null);
});
cljs.core._add_method.call(null,hatti.views.dataview_actions,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview25987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview25987 = (function (cursor,owner,meta25988){
this.cursor = cursor;
this.owner = owner;
this.meta25988 = meta25988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview25987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25989,meta25988__$1){
var self__ = this;
var _25989__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview25987(self__.cursor,self__.owner,meta25988__$1));
});

hatti.views.dataview.t_hatti$views$dataview25987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25989){
var self__ = this;
var _25989__$1 = this;
return self__.meta25988;
});

hatti.views.dataview.t_hatti$views$dataview25987.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview25987.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview25987.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25988","meta25988",833678394,null)], null);
});

hatti.views.dataview.t_hatti$views$dataview25987.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview25987.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview25987";

hatti.views.dataview.t_hatti$views$dataview25987.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview25987");
});

hatti.views.dataview.__GT_t_hatti$views$dataview25987 = (function hatti$views$dataview$__GT_t_hatti$views$dataview25987(cursor__$1,owner__$1,meta25988){
return (new hatti.views.dataview.t_hatti$views$dataview25987(cursor__$1,owner__$1,meta25988));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview25987(cursor,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.dataview_infobar,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__25990,owner){
var map__25991 = p__25990;
var map__25991__$1 = ((((!((map__25991 == null)))?((((map__25991.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25991.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25991):map__25991);
var dataset_info = cljs.core.get.call(null,map__25991__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var status = cljs.core.get.call(null,map__25991__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
if(typeof hatti.views.dataview.t_hatti$views$dataview25993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview25993 = (function (p__25990,owner,map__25991,dataset_info,status,meta25994){
this.p__25990 = p__25990;
this.owner = owner;
this.map__25991 = map__25991;
this.dataset_info = dataset_info;
this.status = status;
this.meta25994 = meta25994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview25993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function (_25995,meta25994__$1){
var self__ = this;
var _25995__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview25993(self__.p__25990,self__.owner,self__.map__25991,self__.dataset_info,self__.status,meta25994__$1));
});})(map__25991,map__25991__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview25993.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function (_25995){
var self__ = this;
var _25995__$1 = this;
return self__.meta25994;
});})(map__25991,map__25991__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview25993.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview25993.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_.call(null,om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)));
});})(map__25991,map__25991__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview25993.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview25993.prototype.om$core$IRender$render$arity$1 = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var map__25996 = self__.dataset_info;
var map__25996__$1 = ((((!((map__25996 == null)))?((((map__25996.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25996.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25996):map__25996);
var num_of_submissions = cljs.core.get.call(null,map__25996__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var formid = cljs.core.get.call(null,map__25996__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var map__25997 = self__.status;
var map__25997__$1 = ((((!((map__25997 == null)))?((((map__25997.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25997.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25997):map__25997);
var loading_QMARK_ = cljs.core.get.call(null,map__25997__$1,new cljs.core.Keyword(null,"loading?","loading?",1905707049));
var total_records = cljs.core.get.call(null,map__25997__$1,new cljs.core.Keyword(null,"total-records","total-records",-1940276645));
return React.DOM.div(({"className": "right rec-summary rec-margin"}),(function (){var attrs26000 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_.call(null,form))?om.core.build.call(null,hatti.shared.language_selector,null):null);
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs26000))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),"language-selector"], null),attrs26000)):({"id": "language-selector"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26000))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26000)], null))));
})(),React.DOM.div(({"id": "data-status"}),(function (){var attrs26001 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null):null);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs26001))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs26001)):({"className": "rec"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26001))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,hatti.utils.pluralize_number.call(null,num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26001),sablono.interpreter.interpret.call(null,hatti.utils.pluralize_number.call(null,num_of_submissions," Record"))], null))));
})()),React.DOM.div(({"className": "divider"})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_actions,formid)));
});})(map__25991,map__25991__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview25993.getBasis = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__25990","p__25990",2050170022,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__25991","map__25991",-113753139,null),new cljs.core.Symbol(null,"dataset-info","dataset-info",443531964,null),new cljs.core.Symbol(null,"status","status",-357266886,null),new cljs.core.Symbol(null,"meta25994","meta25994",-458379103,null)], null);
});})(map__25991,map__25991__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview25993.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview25993.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview25993";

hatti.views.dataview.t_hatti$views$dataview25993.cljs$lang$ctorPrWriter = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview25993");
});})(map__25991,map__25991__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview25993 = ((function (map__25991,map__25991__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview25993(p__25990__$1,owner__$1,map__25991__$2,dataset_info__$1,status__$1,meta25994){
return (new hatti.views.dataview.t_hatti$views$dataview25993(p__25990__$1,owner__$1,map__25991__$2,dataset_info__$1,status__$1,meta25994));
});})(map__25991,map__25991__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview25993(p__25990,owner,map__25991__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.call(null,(function (){var or__6409__auto__ = cljs.core.last.call(null,cljs.core.re_find.call(null,/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),view__$1], null));

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.call(null,view);
var settings_section__$1 = cljs.core.keyword.call(null,settings_section);
var views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var settings_views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"active-tab","active-tab",1102432568),settings_section__$1], null));

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.call(null,view);
var settings_section__$1 = cljs.core.keyword.call(null,settings_section);
var settings_views = new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"selected","selected",574897764)], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"active-tab","active-tab",1102432568)], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610),new cljs.core.Keyword(null,"active-section","active-section",1090779410)], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.call(null,app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"views","views",1450155487),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"integrated-apps","integrated-apps",2094952610)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"add?","add?",1263018409),true], null));
} else {
}

return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"re-render","re-render",1133553258),view__$1], null));
} else {
return null;
}
});
cljs.core._add_method.call(null,hatti.views.tabbed_dataview,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview26007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview26007 = (function (app_state,owner,opts,meta26008){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta26008 = meta26008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview26007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26009,meta26008__$1){
var self__ = this;
var _26009__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview26007(self__.app_state,self__.owner,self__.opts,meta26008__$1));
});

hatti.views.dataview.t_hatti$views$dataview26007.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26009){
var self__ = this;
var _26009__$1 = this;
return self__.meta26008;
});

hatti.views.dataview.t_hatti$views$dataview26007.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview26007.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__26010 = self__.app_state;
var map__26010__$1 = ((((!((map__26010 == null)))?((((map__26010.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26010.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26010):map__26010);
var map__26011 = cljs.core.get.call(null,map__26010__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26011__$1 = ((((!((map__26011 == null)))?((((map__26011.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26011.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26011):map__26011);
var active = cljs.core.get.call(null,map__26011__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var disabled = cljs.core.get.call(null,map__26011__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var selected = cljs.core.get.call(null,map__26011__$1,new cljs.core.Keyword(null,"selected","selected",574897764));
var is_encrypted_QMARK_ = cljs.core.get.call(null,map__26010__$1,new cljs.core.Keyword(null,"is-encrypted?","is-encrypted?",-1801018432));
var is_within_pricing_limits_QMARK_ = cljs.core.get.call(null,map__26010__$1,new cljs.core.Keyword(null,"is-within-pricing-limits?","is-within-pricing-limits?",1028371005));
var view__GT_display = ((function (map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__26004_SHARP_){
if(cljs.core._EQ_.call(null,selected,p1__26004_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__26005_SHARP_){
if(cljs.core._EQ_.call(null,selected,p1__26005_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,cljs.core.deref.call(null,hatti.views.dataview.view_state),new cljs.core.Keyword(null,"all","all",892129742).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"views","views",1450155487).cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__26014){
var map__26015 = p__26014;
var map__26015__$1 = ((((!((map__26015 == null)))?((((map__26015.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26015.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26015):map__26015);
var view = cljs.core.get.call(null,map__26015__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var label = cljs.core.get.call(null,map__26015__$1,new cljs.core.Keyword(null,"label","label",1718410804));
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some.call(null,((function (map__26015,map__26015__$1,view,label,map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__26006_SHARP_){
return cljs.core._EQ_.call(null,view,p1__26006_SHARP_);
});})(map__26015,map__26015__$1,view,label,map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not.call(null,chimera.seq.in_QMARK_.call(null,disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),view__GT_cls.call(null,view),new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("#/"),cljs.core.str(cljs.core.name.call(null,view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab.call(null,view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
return React.DOM.div(({"className": "tab-container dataset-tabs"}),(function (){var attrs26017 = cljs.core.map.call(null,dv__GT_link,dataviews);
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs26017))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs26017)):({"className": "tab-bar"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs26017))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs26017),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563),new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(self__.app_state),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})(),cljs.core.into_array.call(null,(function (){var iter__7189__auto__ = ((function (map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__26018(s__26019){
return (new cljs.core.LazySeq(null,((function (map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__26019__$1 = s__26019;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__26019__$1);
if(temp__4657__auto__){
var s__26019__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__26019__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__26019__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__26021 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__26020 = (0);
while(true){
if((i__26020 < size__7188__auto__)){
var map__26026 = cljs.core._nth.call(null,c__7187__auto__,i__26020);
var map__26026__$1 = ((((!((map__26026 == null)))?((((map__26026.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26026.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26026):map__26026);
var component = cljs.core.get.call(null,map__26026__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var view = cljs.core.get.call(null,map__26026__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var view_name = cljs.core.name.call(null,view);
cljs.core.chunk_append.call(null,b__26021,React.DOM.div(({"style": ({"display": view__GT_display.call(null,view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')}),sablono.interpreter.interpret.call(null,((cljs.core._EQ_.call(null,selected,view))?(function (){
chimera.metrics.send_event.call(null,new cljs.core.Keyword(null,"Dataview","Dataview",873494025),[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tab-content","div.tab-content",255119102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.call(null,component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null))], null);
})()
:null))));

var G__26030 = (i__26020 + (1));
i__26020 = G__26030;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26021),hatti$views$dataview$iter__26018.call(null,cljs.core.chunk_rest.call(null,s__26019__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__26021),null);
}
} else {
var map__26028 = cljs.core.first.call(null,s__26019__$2);
var map__26028__$1 = ((((!((map__26028 == null)))?((((map__26028.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26028.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26028):map__26028);
var component = cljs.core.get.call(null,map__26028__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var view = cljs.core.get.call(null,map__26028__$1,new cljs.core.Keyword(null,"view","view",1247994814));
var view_name = cljs.core.name.call(null,view);
return cljs.core.cons.call(null,React.DOM.div(({"style": ({"display": view__GT_display.call(null,view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')}),sablono.interpreter.interpret.call(null,((cljs.core._EQ_.call(null,selected,view))?(function (){
chimera.metrics.send_event.call(null,new cljs.core.Keyword(null,"Dataview","Dataview",873494025),[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tab-content","div.tab-content",255119102),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.call(null,component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts], null))], null);
})()
:null))),hatti$views$dataview$iter__26018.call(null,cljs.core.rest.call(null,s__26019__$2)));
}
} else {
return null;
}
break;
}
});})(map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(map__26010,map__26010__$1,map__26011,map__26011__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__.call(null,dataviews);
})()));
});

hatti.views.dataview.t_hatti$views$dataview26007.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"app-state","app-state",130568249,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26008","meta26008",-129502563,null)], null);
});

hatti.views.dataview.t_hatti$views$dataview26007.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview26007.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview26007";

hatti.views.dataview.t_hatti$views$dataview26007.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview26007");
});

hatti.views.dataview.__GT_t_hatti$views$dataview26007 = (function hatti$views$dataview$__GT_t_hatti$views$dataview26007(app_state__$1,owner__$1,opts__$1,meta26008){
return (new hatti.views.dataview.t_hatti$views$dataview26007(app_state__$1,owner__$1,opts__$1,meta26008));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview26007(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
