// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('c2.layout.histogram');
goog.require('chimera.date');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
hatti.charting.parse_date = (function hatti$charting$parse_date(date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor.call(null,(cljs_time.coerce.to_long.call(null,(new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
/**
 * Remove the colon in a time string
 *   String -> String
 */
hatti.charting.parse_time = (function hatti$charting$parse_time(time_string){
if(cljs.core.truth_(time_string)){
return hatti.charting.parse_int.call(null,clojure.string.replace.call(null,time_string,/:/,""));
} else {
return null;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__21923 = typ;
switch (G__21923) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return hatti.charting.parse_date;

break;
case "time":
return hatti.charting.parse_time;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
hatti.charting.time__GT_string = (function hatti$charting$time__GT_string(time){
return clojure.string.replace.call(null,[cljs.core.str(time)].join(''),/..$/,(function (p1__21925_SHARP_){
return [cljs.core.str(":"),cljs.core.str(p1__21925_SHARP_)].join('');
}));
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21936 = arguments.length;
var i__7485__auto___21937 = (0);
while(true){
if((i__7485__auto___21937 < len__7484__auto___21936)){
args__7491__auto__.push((arguments[i__7485__auto___21937]));

var G__21938 = (i__7485__auto___21937 + (1));
i__7485__auto___21937 = G__21938;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__21932){
var map__21933 = p__21932;
var map__21933__$1 = ((((!((map__21933 == null)))?((((map__21933.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21933.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21933):map__21933);
var digits = cljs.core.get.call(null,map__21933__$1,new cljs.core.Keyword(null,"digits","digits",-1134635061),(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__21933,map__21933__$1,digits){
return (function (p1__21926_SHARP_){
return (hatti.charting.millis_in_day * p1__21926_SHARP_);
});})(int_fmt_s,map__21933,map__21933__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__21933,map__21933__$1,digits){
return (function (p1__21927_SHARP_){
if(cljs.core.truth_(p1__21927_SHARP_)){
return chimera.date.format_date.call(null,p1__21927_SHARP_);
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__21933,map__21933__$1,digits))
;
var G__21935 = typ;
switch (G__21935) {
case "int":
return ((function (G__21935,int_fmt_s,d__GT_millis,date__GT_str,map__21933,map__21933__$1,digits){
return (function (p1__21928_SHARP_){
return chimera.js_interop.format.call(null,int_fmt_s,p1__21928_SHARP_);
});
;})(G__21935,int_fmt_s,d__GT_millis,date__GT_str,map__21933,map__21933__$1,digits))

break;
case "date":
return ((function (G__21935,int_fmt_s,d__GT_millis,date__GT_str,map__21933,map__21933__$1,digits){
return (function (p1__21929_SHARP_){
return date__GT_str.call(null,d__GT_millis.call(null,p1__21929_SHARP_));
});
;})(G__21935,int_fmt_s,d__GT_millis,date__GT_str,map__21933,map__21933__$1,digits))

break;
case "time":
return hatti.charting.time__GT_string;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq21930){
var G__21931 = cljs.core.first.call(null,seq21930);
var seq21930__$1 = cljs.core.next.call(null,seq21930);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__21931,seq21930__$1);
});

/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__21940,typ){
var vec__21947 = p__21940;
var minimum = cljs.core.nth.call(null,vec__21947,(0),null);
var maximum = cljs.core.nth.call(null,vec__21947,(1),null);
var vec__21950 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil.call(null,minimum),hatti.maths.floor.call(null,maximum)], null);
var minimum__$1 = cljs.core.nth.call(null,vec__21950,(0),null);
var maximum__$1 = cljs.core.nth.call(null,vec__21950,(1),null);
var fmt = hatti.charting.int__GT_str.call(null,typ,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
if((maximum__$1 <= minimum__$1)){
return fmt.call(null,minimum__$1);
} else {
return clojure.string.join.call(null," to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fmt.call(null,minimum__$1),fmt.call(null,maximum__$1)], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,type_STAR_){
var numbers = cljs.core.map.call(null,hatti.charting.str__GT_int.call(null,type_STAR_),answers);
var mx = cljs.core.reduce.call(null,cljs.core.max,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null));
var is = cljs.core.map.call(null,hatti.maths.floor,cljs.core.map.call(null,((function (numbers,mx,mn,s){
return (function (p1__21953_SHARP_){
if(cljs.core.truth_(p1__21953_SHARP_)){
return s.call(null,p1__21953_SHARP_);
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null));
var lbounds = cljs.core.distinct.call(null,cljs.core.map.call(null,cljs.core.float$,cljs.core.map.call(null,t,cljs.core.range.call(null,bins))));
var ubounds = cljs.core.conj.call(null,cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__21954_SHARP_){
if(cljs.core._EQ_.call(null,p1__21954_SHARP_,hatti.maths.floor.call(null,p1__21954_SHARP_))){
return (p1__21954_SHARP_ - (1));
} else {
return p1__21954_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.call(null,(1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.call(null,type_STAR_,new cljs.core.Keyword(null,"digits","digits",-1134635061),(0));
var strings = cljs.core.mapv.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__21955_SHARP_,p2__21956_SHARP_){
return hatti.charting.range__GT_str.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__21955_SHARP_,p2__21956_SHARP_], null),type_STAR_);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.call(null,((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.call(null,strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec.call(null,cljs.core.distinct.call(null,strings));
return cljs.core.with_meta.call(null,results,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),((cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,answers),null))?cljs.core.conj.call(null,strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args21959 = [];
var len__7484__auto___21968 = arguments.length;
var i__7485__auto___21969 = (0);
while(true){
if((i__7485__auto___21969 < len__7484__auto___21968)){
args21959.push((arguments[i__7485__auto___21969]));

var G__21970 = (i__7485__auto___21969 + (1));
i__7485__auto___21969 = G__21970;
continue;
} else {
}
break;
}

var G__21961 = args21959.length;
switch (G__21961) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21959.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.call(null,chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__21962 = chart_data;
var map__21962__$1 = ((((!((map__21962 == null)))?((((map__21962.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21962.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21962):map__21962);
var data = cljs.core.get.call(null,map__21962__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__21962__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var unboxed = (function (){var iter__7189__auto__ = ((function (map__21962,map__21962__$1,data,field_xpath){
return (function hatti$charting$iter__21964(s__21965){
return (new cljs.core.LazySeq(null,((function (map__21962,map__21962__$1,data,field_xpath){
return (function (){
var s__21965__$1 = s__21965;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21965__$1);
if(temp__4657__auto__){
var s__21965__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21965__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21965__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21967 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21966 = (0);
while(true){
if((i__21966 < size__7188__auto__)){
var data_item = cljs.core._nth.call(null,c__7187__auto__,i__21966);
cljs.core.chunk_append.call(null,b__21967,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__21966,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__21967,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath){
return (function (p1__21957_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__21957_SHARP_], null),language);
});})(i__21966,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__21967,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (i__21966,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__21967,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath){
return (function (p1__21958_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__21958_SHARP_)],[count]);
});})(i__21966,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__21967,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath))
,labels);
})());

var G__21972 = (i__21966 + (1));
i__21966 = G__21972;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21967),hatti$charting$iter__21964.call(null,cljs.core.chunk_rest.call(null,s__21965__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21967),null);
}
} else {
var data_item = cljs.core.first.call(null,s__21965__$2);
return cljs.core.cons.call(null,(function (){var labels = cljs.core.keyword.call(null,field_xpath).call(null,data_item);
var count = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath){
return (function (p1__21957_SHARP_){
return hatti.ona.forms.get_label.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),p1__21957_SHARP_], null),language);
});})(labels,count,data_item,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath))
;
return cljs.core.map.call(null,((function (labels,count,labelify,data_item,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath){
return (function (p1__21958_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify.call(null,p1__21958_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__21965__$2,temp__4657__auto__,map__21962,map__21962__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__21964.call(null,cljs.core.rest.call(null,s__21965__$2)));
}
} else {
return null;
}
break;
}
});})(map__21962,map__21962__$1,data,field_xpath))
,null,null));
});})(map__21962,map__21962__$1,data,field_xpath))
;
return iter__7189__auto__.call(null,data);
})();
return cljs.core.sort_by.call(null,cljs.core.last,cljs.core._GT_,cljs.core.apply.call(null,cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten.call(null,unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;

/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21978 = arguments.length;
var i__7485__auto___21979 = (0);
while(true){
if((i__7485__auto___21979 < len__7484__auto___21978)){
args__7491__auto__.push((arguments[i__7485__auto___21979]));

var G__21980 = (i__7485__auto___21979 + (1));
i__7485__auto___21979 = G__21980;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__21975){
var map__21976 = p__21975;
var map__21976__$1 = ((((!((map__21976 == null)))?((((map__21976.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21976.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21976):map__21976);
var data_type = cljs.core.get.call(null,map__21976__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.call(null,rough_min,rough_max);
var best_guess = cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.call(null,cljs.core.partial.call(null,cljs.core.min,real_max,n),cljs.core.map.call(null,cljs.core.partial.call(null,hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq21973){
var G__21974 = cljs.core.first.call(null,seq21973);
var seq21973__$1 = cljs.core.next.call(null,seq21973);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__21974,seq21973__$1);
});

/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21992 = arguments.length;
var i__7485__auto___21993 = (0);
while(true){
if((i__7485__auto___21993 < len__7484__auto___21992)){
args__7491__auto__.push((arguments[i__7485__auto___21993]));

var G__21994 = (i__7485__auto___21993 + (1));
i__7485__auto___21993 = G__21994;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__21983){
var map__21984 = p__21983;
var map__21984__$1 = ((((!((map__21984 == null)))?((((map__21984.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21984.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21984):map__21984);
var data_type = cljs.core.get.call(null,map__21984__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var map__21986 = chart_data;
var map__21986__$1 = ((((!((map__21986 == null)))?((((map__21986.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21986.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21986):map__21986);
var data = cljs.core.get.call(null,map__21986__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var field_xpath = cljs.core.get.call(null,map__21986__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var retype_fn = hatti.charting.str__GT_int.call(null,data_type);
var qn_key = cljs.core.keyword.call(null,field_xpath);
var retyped_data = cljs.core.map.call(null,((function (map__21986,map__21986__$1,data,field_xpath,retype_fn,qn_key,map__21984,map__21984__$1,data_type){
return (function (el){
return cljs.core.update_in.call(null,el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__21986,map__21986__$1,data,field_xpath,retype_fn,qn_key,map__21984,map__21984__$1,data_type))
,data);
var data_range = (cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,qn_key,retyped_data)) - cljs.core.apply.call(null,cljs.core.min,cljs.core.map.call(null,qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.call(null,data_range,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type));
var binned_data = c2.layout.histogram.histogram.call(null,retyped_data,new cljs.core.Keyword(null,"value","value",305978217),qn_key,new cljs.core.Keyword(null,"bins","bins",1670395210),bins);
return cljs.core.with_meta.call(null,(function (){var iter__7189__auto__ = ((function (map__21986,map__21986__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__21984,map__21984__$1,data_type){
return (function hatti$charting$iter__21988(s__21989){
return (new cljs.core.LazySeq(null,((function (map__21986,map__21986__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__21984,map__21984__$1,data_type){
return (function (){
var s__21989__$1 = s__21989;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21989__$1);
if(temp__4657__auto__){
var s__21989__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21989__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21989__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21991 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21990 = (0);
while(true){
if((i__21990 < size__7188__auto__)){
var data_item = cljs.core._nth.call(null,c__7187__auto__,i__21990);
cljs.core.chunk_append.call(null,b__21991,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null));

var G__21995 = (i__21990 + (1));
i__21990 = G__21995;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21991),hatti$charting$iter__21988.call(null,cljs.core.chunk_rest.call(null,s__21989__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21991),null);
}
} else {
var data_item = cljs.core.first.call(null,s__21989__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),new cljs.core.Keyword(null,"dx","dx",-381796732).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,data_item)),cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data_item))], null),hatti$charting$iter__21988.call(null,cljs.core.rest.call(null,s__21989__$2)));
}
} else {
return null;
}
break;
}
});})(map__21986,map__21986__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__21984,map__21984__$1,data_type))
,null,null));
});})(map__21986,map__21986__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__21984,map__21984__$1,data_type))
;
return iter__7189__auto__.call(null,binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bins","bins",1670395210),bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq21981){
var G__21982 = cljs.core.first.call(null,seq21981);
var seq21981__$1 = cljs.core.next.call(null,seq21981);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__21982,seq21981__$1);
});

/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22002 = arguments.length;
var i__7485__auto___22003 = (0);
while(true){
if((i__7485__auto___22003 < len__7484__auto___22002)){
args__7491__auto__.push((arguments[i__7485__auto___22003]));

var G__22004 = (i__7485__auto___22003 + (1));
i__7485__auto___22003 = G__22004;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__21999){
var map__22000 = p__21999;
var map__22000__$1 = ((((!((map__22000 == null)))?((((map__22000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22000):map__22000);
var total_as_max_QMARK_ = cljs.core.get.call(null,map__22000__$1,new cljs.core.Keyword(null,"total-as-max?","total-as-max?",-1709426453));
var datamin_as_min_QMARK_ = cljs.core.get.call(null,map__22000__$1,new cljs.core.Keyword(null,"datamin-as-min?","datamin-as-min?",1074079715));
var counts = cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.call(null,cljs.core._PLUS_,(0),counts):cljs.core.reduce.call(null,cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.call(null,cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null));
return cljs.core.map.call(null,scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq21996){
var G__21997 = cljs.core.first.call(null,seq21996);
var seq21996__$1 = cljs.core.next.call(null,seq21996);
var G__21998 = cljs.core.first.call(null,seq21996__$1);
var seq21996__$2 = cljs.core.next.call(null,seq21996__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__21997,G__21998,seq21996__$2);
});

hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.t-right.t-grey","div.t-right.t-grey",-2075084293),[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22047 = arguments.length;
var i__7485__auto___22048 = (0);
while(true){
if((i__7485__auto___22048 < len__7484__auto___22047)){
args__7491__auto__.push((arguments[i__7485__auto___22048]));

var G__22049 = (i__7485__auto___22048 + (1));
i__7485__auto___22048 = G__22049;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__22007){
var map__22008 = p__22007;
var map__22008__$1 = ((((!((map__22008 == null)))?((((map__22008.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22008.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22008):map__22008);
var data_type = cljs.core.get.call(null,map__22008__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.call(null,chart_data,new cljs.core.Keyword(null,"data-type","data-type",-326421468),data_type);
var map__22010 = cljs.core.meta.call(null,chart_data);
var map__22010__$1 = ((((!((map__22010 == null)))?((((map__22010.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22010.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22010):map__22010);
var nil_count = cljs.core.get.call(null,map__22010__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__22010__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var bins = new cljs.core.Keyword(null,"bins","bins",1670395210).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,extracted_data));
var x_series = cljs.core.map.call(null,cljs.core.first,extracted_data);
var dx_series = cljs.core.map.call(null,cljs.core.second,extracted_data);
var y_series = cljs.core.map.call(null,cljs.core.last,extracted_data);
var xmin = cljs.core.apply.call(null,cljs.core.min,x_series);
var xmax = (cljs.core.apply.call(null,cljs.core.max,x_series) + cljs.core.last.call(null,dx_series));
var x_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null));
var y_scale = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.call(null,cljs.core.max,y_series)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null));
var bin_width = hatti.maths.floor.call(null,((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.call(null,(2),cljs.core.rest.call(null,x_series));
var fmt = hatti.charting.int__GT_str.call(null,data_type);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,extracted_data))){
var vec__22012 = cljs.core.first.call(null,extracted_data);
var value = cljs.core.nth.call(null,vec__22012,(0),null);
var _ = cljs.core.nth.call(null,vec__22012,(1),null);
var total = cljs.core.nth.call(null,vec__22012,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),total," records have identical value: ",fmt.call(null,value)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),(margin + chart_width),new cljs.core.Keyword(null,"height","height",1025178622),(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.chart","g.chart",376683303),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type){
return (function hatti$charting$iter__22015(s__22016){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type){
return (function (){
var s__22016__$1 = s__22016;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22016__$1);
if(temp__4657__auto__){
var s__22016__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22016__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22016__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22018 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22017 = (0);
while(true){
if((i__22017 < size__7188__auto__)){
var vec__22031 = cljs.core._nth.call(null,c__7187__auto__,i__22017);
var x = cljs.core.nth.call(null,vec__22031,(0),null);
var dx = cljs.core.nth.call(null,vec__22031,(1),null);
var y = cljs.core.nth.call(null,vec__22031,(2),null);
cljs.core.chunk_append.call(null,b__22018,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__22034 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__22034,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__22034,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__22034,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})());

var G__22050 = (i__22017 + (1));
i__22017 = G__22050;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22018),hatti$charting$iter__22015.call(null,cljs.core.chunk_rest.call(null,s__22016__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22018),null);
}
} else {
var vec__22037 = cljs.core.first.call(null,s__22016__$2);
var x = cljs.core.nth.call(null,vec__22037,(0),null);
var dx = cljs.core.nth.call(null,vec__22037,(1),null);
var y = cljs.core.nth.call(null,vec__22037,(2),null);
return cljs.core.cons.call(null,(function (){var x_scaled = x_scale.call(null,x);
var y_scaled = y_scale.call(null,y);
var vec__22040 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.call(null,vec__22040,(0),null);
var txt_ht = cljs.core.nth.call(null,vec__22040,(1),null);
var txt_cls = cljs.core.nth.call(null,vec__22040,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.bars","g.bars",-1370310225),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rect","rect",-108902628),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),(1),new cljs.core.Keyword(null,"height","height",1025178622),y_scaled__$1,new cljs.core.Keyword(null,"width","width",-384071477),bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"y","y",-1757859776),txt_ht,new cljs.core.Keyword(null,"x","x",2099068185),(bin_width / 2.0),new cljs.core.Keyword(null,"dy","dy",1719547243),"1em",new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__22015.call(null,cljs.core.rest.call(null,s__22016__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type))
;
return iter__7189__auto__.call(null,extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.axis","g.axis",837167470),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"x1","x1",-1863922247),(0),new cljs.core.Keyword(null,"x2","x2",-1362513475),chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g","g",1738089905),(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type){
return (function hatti$charting$iter__22043(s__22044){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type){
return (function (){
var s__22044__$1 = s__22044;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22044__$1);
if(temp__4657__auto__){
var s__22044__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22044__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22044__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22046 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22045 = (0);
while(true){
if((i__22045 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__22045);
cljs.core.chunk_append.call(null,b__22046,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null));

var G__22051 = (i__22045 + (1));
i__22045 = G__22051;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22046),hatti$charting$iter__22043.call(null,cljs.core.chunk_rest.call(null,s__22044__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22046),null);
}
} else {
var x = cljs.core.first.call(null,s__22044__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"g.tick","g.tick",368840735),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),c2.svg.translate.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scale.call(null,x),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),(25),new cljs.core.Keyword(null,"text-anchor","text-anchor",585613696),"middle",new cljs.core.Keyword(null,"class","class",-2030961996),data_type], null),fmt.call(null,x)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),"tick",new cljs.core.Keyword(null,"y2","y2",-718691301),(10),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0)], null)], null)], null),hatti$charting$iter__22043.call(null,cljs.core.rest.call(null,s__22044__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__22010,map__22010__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__22008,map__22008__$1,data_type))
;
return iter__7189__auto__.call(null,x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq22005){
var G__22006 = cljs.core.first.call(null,seq22005);
var seq22005__$1 = cljs.core.next.call(null,seq22005);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__22006,seq22005__$1);
});

/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.call(null,cljs.core.max,cljs.core.vals.call(null,data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null));
return [cljs.core.str(chimera.js_interop.format.call(null,"%.1f",s.call(null,n))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.call(null,field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?new cljs.core.Keyword(null,"div.bars.select-mult","div.bars.select-mult",514551318):new cljs.core.Keyword(null,"div.bars.select-one","div.bars.select-one",-235690381));
var tdr = new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table#bar-chart.table","table#bar-chart.table",-82390780),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.t-right","th.t-right",-959248017),"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tfoot","tfoot",-701599890),((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(4)], null),hatti.charting.response_count_message.call(null,non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.t-grey","tr.t-grey",1706085529),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353)], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),(function (){var iter__7189__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__22068(s__22069){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__22069__$1 = s__22069;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22069__$1);
if(temp__4657__auto__){
var s__22069__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22069__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22069__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22071 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22070 = (0);
while(true){
if((i__22070 < size__7188__auto__)){
var vec__22078 = cljs.core._nth.call(null,c__7187__auto__,i__22070);
var label = cljs.core.nth.call(null,vec__22078,(0),null);
var val = cljs.core.nth.call(null,vec__22078,(1),null);
cljs.core.chunk_append.call(null,b__22071,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null));

var G__22084 = (i__22070 + (1));
i__22070 = G__22084;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22071),hatti$charting$table_chart_h_$_iter__22068.call(null,cljs.core.chunk_rest.call(null,s__22069__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22071),null);
}
} else {
var vec__22081 = cljs.core.first.call(null,s__22069__$2);
var label = cljs.core.nth.call(null,vec__22081,(0),null);
var val = cljs.core.nth.call(null,vec__22081,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),percent_s.call(null,val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.t-right","td.t-right",809111218),percent_s.call(null,val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__22068.call(null,cljs.core.rest.call(null,s__22069__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__7189__auto__.call(null,data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__22090 = chart_data;
var map__22090__$1 = ((((!((map__22090 == null)))?((((map__22090.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22090.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22090):map__22090);
var field_xpath = cljs.core.get.call(null,map__22090__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var data = cljs.core.get.call(null,map__22090__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var na_QMARK_ = ((function (map__22090,map__22090__$1,field_xpath,data){
return (function (p1__22085_SHARP_){
return ((p1__22085_SHARP_ == null)) || (cljs.core._EQ_.call(null,cljs.core.PersistentVector.EMPTY,p1__22085_SHARP_));
});})(map__22090,map__22090__$1,field_xpath,data))
;
var nil_data = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__22090,map__22090__$1,field_xpath,data,na_QMARK_){
return (function (p1__22086_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__22086_SHARP_));
});})(map__22090,map__22090__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.call(null,((function (map__22090,map__22090__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__22087_SHARP_){
return na_QMARK_.call(null,cljs.core.keyword.call(null,field_xpath).call(null,p1__22087_SHARP_));
});})(map__22090,map__22090__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.call(null,cljs.core._PLUS_,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),non_nil_data));
return cljs.core.with_meta.call(null,cljs.core.assoc.call(null,chart_data,new cljs.core.Keyword(null,"data","data",-232669377),non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"nil-count","nil-count",785567731),nil_count,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457),non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args22093 = [];
var len__7484__auto___22101 = arguments.length;
var i__7485__auto___22102 = (0);
while(true){
if((i__7485__auto___22102 < len__7484__auto___22101)){
args22093.push((arguments[i__7485__auto___22102]));

var G__22103 = (i__7485__auto___22102 + (1));
i__7485__auto___22102 = G__22103;
continue;
} else {
}
break;
}

var G__22095 = args22093.length;
switch (G__22095) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22093.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.call(null,chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__22096 = chart_data;
var map__22096__$1 = ((((!((map__22096 == null)))?((((map__22096.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22096.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22096):map__22096);
var field_label = cljs.core.get.call(null,map__22096__$1,new cljs.core.Keyword(null,"field_label","field_label",-690619633));
var data_type = cljs.core.get.call(null,map__22096__$1,new cljs.core.Keyword(null,"data_type","data_type",1391137078));
var field_xpath = cljs.core.get.call(null,map__22096__$1,new cljs.core.Keyword(null,"field_xpath","field_xpath",1282029284));
var field_type = cljs.core.get.call(null,map__22096__$1,new cljs.core.Keyword(null,"field_type","field_type",1135193526));
var chart_data__$1 = hatti.charting.extract_nil.call(null,chart_data);
var map__22097 = cljs.core.meta.call(null,chart_data__$1);
var map__22097__$1 = ((((!((map__22097 == null)))?((((map__22097.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22097.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22097):map__22097);
var nil_count = cljs.core.get.call(null,map__22097__$1,new cljs.core.Keyword(null,"nil-count","nil-count",785567731));
var non_nil_count = cljs.core.get.call(null,map__22097__$1,new cljs.core.Keyword(null,"non-nil-count","non-nil-count",-593781457));
var not_supported = ((function (map__22096,map__22096__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__22097,map__22097__$1,nil_count,non_nil_count){
return (function (p1__22092_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"div.t-red","div.t-red",-489419212),[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__22092_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__22096,map__22096__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__22097,map__22097__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"No data"], null):(function (){var G__22100 = data_type;
switch (G__22100) {
case "categorized":
return hatti.charting.table_chart_h.call(null,hatti.charting.label_count_pairs.call(null,chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.call(null,chart_data__$1,new cljs.core.Keyword(null,"data-type","data-type",-326421468),"date");

break;
case "numeric":
return hatti.charting.numeric_chart.call(null,chart_data__$1);

break;
default:
return not_supported.call(null,data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1718410804),field_label,new cljs.core.Keyword(null,"name","name",1843675177),field_xpath,new cljs.core.Keyword(null,"chart","chart",1173225425),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;

