// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args12354 = [];
var len__7484__auto___12360 = arguments.length;
var i__7485__auto___12361 = (0);
while(true){
if((i__7485__auto___12361 < len__7484__auto___12360)){
args12354.push((arguments[i__7485__auto___12361]));

var G__12362 = (i__7485__auto___12361 + (1));
i__7485__auto___12361 = G__12362;
continue;
} else {
}
break;
}

var G__12356 = args12354.length;
switch (G__12356) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12354.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async12357 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12357 = (function (f,blockable,meta12358){
this.f = f;
this.blockable = blockable;
this.meta12358 = meta12358;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12357.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12359,meta12358__$1){
var self__ = this;
var _12359__$1 = this;
return (new cljs.core.async.t_cljs$core$async12357(self__.f,self__.blockable,meta12358__$1));
});

cljs.core.async.t_cljs$core$async12357.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12359){
var self__ = this;
var _12359__$1 = this;
return self__.meta12358;
});

cljs.core.async.t_cljs$core$async12357.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12357.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12357.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async12357.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async12357.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12358","meta12358",-80545155,null)], null);
});

cljs.core.async.t_cljs$core$async12357.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12357.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12357";

cljs.core.async.t_cljs$core$async12357.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12357");
});

cljs.core.async.__GT_t_cljs$core$async12357 = (function cljs$core$async$__GT_t_cljs$core$async12357(f__$1,blockable__$1,meta12358){
return (new cljs.core.async.t_cljs$core$async12357(f__$1,blockable__$1,meta12358));
});

}

return (new cljs.core.async.t_cljs$core$async12357(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args12366 = [];
var len__7484__auto___12369 = arguments.length;
var i__7485__auto___12370 = (0);
while(true){
if((i__7485__auto___12370 < len__7484__auto___12369)){
args12366.push((arguments[i__7485__auto___12370]));

var G__12371 = (i__7485__auto___12370 + (1));
i__7485__auto___12370 = G__12371;
continue;
} else {
}
break;
}

var G__12368 = args12366.length;
switch (G__12368) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12366.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args12373 = [];
var len__7484__auto___12376 = arguments.length;
var i__7485__auto___12377 = (0);
while(true){
if((i__7485__auto___12377 < len__7484__auto___12376)){
args12373.push((arguments[i__7485__auto___12377]));

var G__12378 = (i__7485__auto___12377 + (1));
i__7485__auto___12377 = G__12378;
continue;
} else {
}
break;
}

var G__12375 = args12373.length;
switch (G__12375) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12373.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args12380 = [];
var len__7484__auto___12383 = arguments.length;
var i__7485__auto___12384 = (0);
while(true){
if((i__7485__auto___12384 < len__7484__auto___12383)){
args12380.push((arguments[i__7485__auto___12384]));

var G__12385 = (i__7485__auto___12384 + (1));
i__7485__auto___12384 = G__12385;
continue;
} else {
}
break;
}

var G__12382 = args12380.length;
switch (G__12382) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12380.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12387 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12387);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12387,ret){
return (function (){
return fn1.call(null,val_12387);
});})(val_12387,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args12388 = [];
var len__7484__auto___12391 = arguments.length;
var i__7485__auto___12392 = (0);
while(true){
if((i__7485__auto___12392 < len__7484__auto___12391)){
args12388.push((arguments[i__7485__auto___12392]));

var G__12393 = (i__7485__auto___12392 + (1));
i__7485__auto___12392 = G__12393;
continue;
} else {
}
break;
}

var G__12390 = args12388.length;
switch (G__12390) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12388.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___12395 = n;
var x_12396 = (0);
while(true){
if((x_12396 < n__7324__auto___12395)){
(a[x_12396] = (0));

var G__12397 = (x_12396 + (1));
x_12396 = G__12397;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12398 = (i + (1));
i = G__12398;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async12402 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12402 = (function (alt_flag,flag,meta12403){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta12403 = meta12403;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12402.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12404,meta12403__$1){
var self__ = this;
var _12404__$1 = this;
return (new cljs.core.async.t_cljs$core$async12402(self__.alt_flag,self__.flag,meta12403__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async12402.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12404){
var self__ = this;
var _12404__$1 = this;
return self__.meta12403;
});})(flag))
;

cljs.core.async.t_cljs$core$async12402.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12402.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async12402.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12402.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12402.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12403","meta12403",1374658691,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async12402.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12402.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12402";

cljs.core.async.t_cljs$core$async12402.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12402");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async12402 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12402(alt_flag__$1,flag__$1,meta12403){
return (new cljs.core.async.t_cljs$core$async12402(alt_flag__$1,flag__$1,meta12403));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async12402(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async12408 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12408 = (function (alt_handler,flag,cb,meta12409){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta12409 = meta12409;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12408.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12410,meta12409__$1){
var self__ = this;
var _12410__$1 = this;
return (new cljs.core.async.t_cljs$core$async12408(self__.alt_handler,self__.flag,self__.cb,meta12409__$1));
});

cljs.core.async.t_cljs$core$async12408.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12410){
var self__ = this;
var _12410__$1 = this;
return self__.meta12409;
});

cljs.core.async.t_cljs$core$async12408.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12408.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async12408.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12408.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async12408.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12409","meta12409",-1464937541,null)], null);
});

cljs.core.async.t_cljs$core$async12408.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12408.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12408";

cljs.core.async.t_cljs$core$async12408.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12408");
});

cljs.core.async.__GT_t_cljs$core$async12408 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12408(alt_handler__$1,flag__$1,cb__$1,meta12409){
return (new cljs.core.async.t_cljs$core$async12408(alt_handler__$1,flag__$1,cb__$1,meta12409));
});

}

return (new cljs.core.async.t_cljs$core$async12408(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12411_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12411_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12412_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12412_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12413 = (i + (1));
i = G__12413;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___12419 = arguments.length;
var i__7485__auto___12420 = (0);
while(true){
if((i__7485__auto___12420 < len__7484__auto___12419)){
args__7491__auto__.push((arguments[i__7485__auto___12420]));

var G__12421 = (i__7485__auto___12420 + (1));
i__7485__auto___12420 = G__12421;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12416){
var map__12417 = p__12416;
var map__12417__$1 = ((((!((map__12417 == null)))?((((map__12417.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12417.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12417):map__12417);
var opts = map__12417__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12414){
var G__12415 = cljs.core.first.call(null,seq12414);
var seq12414__$1 = cljs.core.next.call(null,seq12414);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12415,seq12414__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args12422 = [];
var len__7484__auto___12472 = arguments.length;
var i__7485__auto___12473 = (0);
while(true){
if((i__7485__auto___12473 < len__7484__auto___12472)){
args12422.push((arguments[i__7485__auto___12473]));

var G__12474 = (i__7485__auto___12473 + (1));
i__7485__auto___12473 = G__12474;
continue;
} else {
}
break;
}

var G__12424 = args12422.length;
switch (G__12424) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12422.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12309__auto___12476 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___12476){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___12476){
return (function (state_12448){
var state_val_12449 = (state_12448[(1)]);
if((state_val_12449 === (7))){
var inst_12444 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
var statearr_12450_12477 = state_12448__$1;
(statearr_12450_12477[(2)] = inst_12444);

(statearr_12450_12477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (1))){
var state_12448__$1 = state_12448;
var statearr_12451_12478 = state_12448__$1;
(statearr_12451_12478[(2)] = null);

(statearr_12451_12478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (4))){
var inst_12427 = (state_12448[(7)]);
var inst_12427__$1 = (state_12448[(2)]);
var inst_12428 = (inst_12427__$1 == null);
var state_12448__$1 = (function (){var statearr_12452 = state_12448;
(statearr_12452[(7)] = inst_12427__$1);

return statearr_12452;
})();
if(cljs.core.truth_(inst_12428)){
var statearr_12453_12479 = state_12448__$1;
(statearr_12453_12479[(1)] = (5));

} else {
var statearr_12454_12480 = state_12448__$1;
(statearr_12454_12480[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (13))){
var state_12448__$1 = state_12448;
var statearr_12455_12481 = state_12448__$1;
(statearr_12455_12481[(2)] = null);

(statearr_12455_12481[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (6))){
var inst_12427 = (state_12448[(7)]);
var state_12448__$1 = state_12448;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12448__$1,(11),to,inst_12427);
} else {
if((state_val_12449 === (3))){
var inst_12446 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12448__$1,inst_12446);
} else {
if((state_val_12449 === (12))){
var state_12448__$1 = state_12448;
var statearr_12456_12482 = state_12448__$1;
(statearr_12456_12482[(2)] = null);

(statearr_12456_12482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (2))){
var state_12448__$1 = state_12448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12448__$1,(4),from);
} else {
if((state_val_12449 === (11))){
var inst_12437 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
if(cljs.core.truth_(inst_12437)){
var statearr_12457_12483 = state_12448__$1;
(statearr_12457_12483[(1)] = (12));

} else {
var statearr_12458_12484 = state_12448__$1;
(statearr_12458_12484[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (9))){
var state_12448__$1 = state_12448;
var statearr_12459_12485 = state_12448__$1;
(statearr_12459_12485[(2)] = null);

(statearr_12459_12485[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (5))){
var state_12448__$1 = state_12448;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12460_12486 = state_12448__$1;
(statearr_12460_12486[(1)] = (8));

} else {
var statearr_12461_12487 = state_12448__$1;
(statearr_12461_12487[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (14))){
var inst_12442 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
var statearr_12462_12488 = state_12448__$1;
(statearr_12462_12488[(2)] = inst_12442);

(statearr_12462_12488[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (10))){
var inst_12434 = (state_12448[(2)]);
var state_12448__$1 = state_12448;
var statearr_12463_12489 = state_12448__$1;
(statearr_12463_12489[(2)] = inst_12434);

(statearr_12463_12489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12449 === (8))){
var inst_12431 = cljs.core.async.close_BANG_.call(null,to);
var state_12448__$1 = state_12448;
var statearr_12464_12490 = state_12448__$1;
(statearr_12464_12490[(2)] = inst_12431);

(statearr_12464_12490[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___12476))
;
return ((function (switch__12197__auto__,c__12309__auto___12476){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_12468 = [null,null,null,null,null,null,null,null];
(statearr_12468[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_12468[(1)] = (1));

return statearr_12468;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_12448){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12469){if((e12469 instanceof Object)){
var ex__12201__auto__ = e12469;
var statearr_12470_12491 = state_12448;
(statearr_12470_12491[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12448);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12469;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12492 = state_12448;
state_12448 = G__12492;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_12448){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_12448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___12476))
})();
var state__12311__auto__ = (function (){var statearr_12471 = f__12310__auto__.call(null);
(statearr_12471[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___12476);

return statearr_12471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___12476))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12680){
var vec__12681 = p__12680;
var v = cljs.core.nth.call(null,vec__12681,(0),null);
var p = cljs.core.nth.call(null,vec__12681,(1),null);
var job = vec__12681;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__12309__auto___12867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___12867,res,vec__12681,v,p,job,jobs,results){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___12867,res,vec__12681,v,p,job,jobs,results){
return (function (state_12688){
var state_val_12689 = (state_12688[(1)]);
if((state_val_12689 === (1))){
var state_12688__$1 = state_12688;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12688__$1,(2),res,v);
} else {
if((state_val_12689 === (2))){
var inst_12685 = (state_12688[(2)]);
var inst_12686 = cljs.core.async.close_BANG_.call(null,res);
var state_12688__$1 = (function (){var statearr_12690 = state_12688;
(statearr_12690[(7)] = inst_12685);

return statearr_12690;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12688__$1,inst_12686);
} else {
return null;
}
}
});})(c__12309__auto___12867,res,vec__12681,v,p,job,jobs,results))
;
return ((function (switch__12197__auto__,c__12309__auto___12867,res,vec__12681,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_12694 = [null,null,null,null,null,null,null,null];
(statearr_12694[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_12694[(1)] = (1));

return statearr_12694;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_12688){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12695){if((e12695 instanceof Object)){
var ex__12201__auto__ = e12695;
var statearr_12696_12868 = state_12688;
(statearr_12696_12868[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12688);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12695;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12869 = state_12688;
state_12688 = G__12869;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_12688){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_12688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___12867,res,vec__12681,v,p,job,jobs,results))
})();
var state__12311__auto__ = (function (){var statearr_12697 = f__12310__auto__.call(null);
(statearr_12697[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___12867);

return statearr_12697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___12867,res,vec__12681,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12698){
var vec__12699 = p__12698;
var v = cljs.core.nth.call(null,vec__12699,(0),null);
var p = cljs.core.nth.call(null,vec__12699,(1),null);
var job = vec__12699;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___12870 = n;
var __12871 = (0);
while(true){
if((__12871 < n__7324__auto___12870)){
var G__12702_12872 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12702_12872) {
case "compute":
var c__12309__auto___12874 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12871,c__12309__auto___12874,G__12702_12872,n__7324__auto___12870,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (__12871,c__12309__auto___12874,G__12702_12872,n__7324__auto___12870,jobs,results,process,async){
return (function (state_12715){
var state_val_12716 = (state_12715[(1)]);
if((state_val_12716 === (1))){
var state_12715__$1 = state_12715;
var statearr_12717_12875 = state_12715__$1;
(statearr_12717_12875[(2)] = null);

(statearr_12717_12875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12716 === (2))){
var state_12715__$1 = state_12715;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12715__$1,(4),jobs);
} else {
if((state_val_12716 === (3))){
var inst_12713 = (state_12715[(2)]);
var state_12715__$1 = state_12715;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12715__$1,inst_12713);
} else {
if((state_val_12716 === (4))){
var inst_12705 = (state_12715[(2)]);
var inst_12706 = process.call(null,inst_12705);
var state_12715__$1 = state_12715;
if(cljs.core.truth_(inst_12706)){
var statearr_12718_12876 = state_12715__$1;
(statearr_12718_12876[(1)] = (5));

} else {
var statearr_12719_12877 = state_12715__$1;
(statearr_12719_12877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12716 === (5))){
var state_12715__$1 = state_12715;
var statearr_12720_12878 = state_12715__$1;
(statearr_12720_12878[(2)] = null);

(statearr_12720_12878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12716 === (6))){
var state_12715__$1 = state_12715;
var statearr_12721_12879 = state_12715__$1;
(statearr_12721_12879[(2)] = null);

(statearr_12721_12879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12716 === (7))){
var inst_12711 = (state_12715[(2)]);
var state_12715__$1 = state_12715;
var statearr_12722_12880 = state_12715__$1;
(statearr_12722_12880[(2)] = inst_12711);

(statearr_12722_12880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12871,c__12309__auto___12874,G__12702_12872,n__7324__auto___12870,jobs,results,process,async))
;
return ((function (__12871,switch__12197__auto__,c__12309__auto___12874,G__12702_12872,n__7324__auto___12870,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_12726 = [null,null,null,null,null,null,null];
(statearr_12726[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_12726[(1)] = (1));

return statearr_12726;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_12715){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12727){if((e12727 instanceof Object)){
var ex__12201__auto__ = e12727;
var statearr_12728_12881 = state_12715;
(statearr_12728_12881[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12715);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12727;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12882 = state_12715;
state_12715 = G__12882;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_12715){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_12715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(__12871,switch__12197__auto__,c__12309__auto___12874,G__12702_12872,n__7324__auto___12870,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_12729 = f__12310__auto__.call(null);
(statearr_12729[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___12874);

return statearr_12729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(__12871,c__12309__auto___12874,G__12702_12872,n__7324__auto___12870,jobs,results,process,async))
);


break;
case "async":
var c__12309__auto___12883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12871,c__12309__auto___12883,G__12702_12872,n__7324__auto___12870,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (__12871,c__12309__auto___12883,G__12702_12872,n__7324__auto___12870,jobs,results,process,async){
return (function (state_12742){
var state_val_12743 = (state_12742[(1)]);
if((state_val_12743 === (1))){
var state_12742__$1 = state_12742;
var statearr_12744_12884 = state_12742__$1;
(statearr_12744_12884[(2)] = null);

(statearr_12744_12884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12743 === (2))){
var state_12742__$1 = state_12742;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12742__$1,(4),jobs);
} else {
if((state_val_12743 === (3))){
var inst_12740 = (state_12742[(2)]);
var state_12742__$1 = state_12742;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12742__$1,inst_12740);
} else {
if((state_val_12743 === (4))){
var inst_12732 = (state_12742[(2)]);
var inst_12733 = async.call(null,inst_12732);
var state_12742__$1 = state_12742;
if(cljs.core.truth_(inst_12733)){
var statearr_12745_12885 = state_12742__$1;
(statearr_12745_12885[(1)] = (5));

} else {
var statearr_12746_12886 = state_12742__$1;
(statearr_12746_12886[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12743 === (5))){
var state_12742__$1 = state_12742;
var statearr_12747_12887 = state_12742__$1;
(statearr_12747_12887[(2)] = null);

(statearr_12747_12887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12743 === (6))){
var state_12742__$1 = state_12742;
var statearr_12748_12888 = state_12742__$1;
(statearr_12748_12888[(2)] = null);

(statearr_12748_12888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12743 === (7))){
var inst_12738 = (state_12742[(2)]);
var state_12742__$1 = state_12742;
var statearr_12749_12889 = state_12742__$1;
(statearr_12749_12889[(2)] = inst_12738);

(statearr_12749_12889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12871,c__12309__auto___12883,G__12702_12872,n__7324__auto___12870,jobs,results,process,async))
;
return ((function (__12871,switch__12197__auto__,c__12309__auto___12883,G__12702_12872,n__7324__auto___12870,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_12753 = [null,null,null,null,null,null,null];
(statearr_12753[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_12753[(1)] = (1));

return statearr_12753;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_12742){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12742);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12754){if((e12754 instanceof Object)){
var ex__12201__auto__ = e12754;
var statearr_12755_12890 = state_12742;
(statearr_12755_12890[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12742);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12754;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12891 = state_12742;
state_12742 = G__12891;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_12742){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_12742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(__12871,switch__12197__auto__,c__12309__auto___12883,G__12702_12872,n__7324__auto___12870,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_12756 = f__12310__auto__.call(null);
(statearr_12756[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___12883);

return statearr_12756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(__12871,c__12309__auto___12883,G__12702_12872,n__7324__auto___12870,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12892 = (__12871 + (1));
__12871 = G__12892;
continue;
} else {
}
break;
}

var c__12309__auto___12893 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___12893,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___12893,jobs,results,process,async){
return (function (state_12778){
var state_val_12779 = (state_12778[(1)]);
if((state_val_12779 === (1))){
var state_12778__$1 = state_12778;
var statearr_12780_12894 = state_12778__$1;
(statearr_12780_12894[(2)] = null);

(statearr_12780_12894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (2))){
var state_12778__$1 = state_12778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12778__$1,(4),from);
} else {
if((state_val_12779 === (3))){
var inst_12776 = (state_12778[(2)]);
var state_12778__$1 = state_12778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12778__$1,inst_12776);
} else {
if((state_val_12779 === (4))){
var inst_12759 = (state_12778[(7)]);
var inst_12759__$1 = (state_12778[(2)]);
var inst_12760 = (inst_12759__$1 == null);
var state_12778__$1 = (function (){var statearr_12781 = state_12778;
(statearr_12781[(7)] = inst_12759__$1);

return statearr_12781;
})();
if(cljs.core.truth_(inst_12760)){
var statearr_12782_12895 = state_12778__$1;
(statearr_12782_12895[(1)] = (5));

} else {
var statearr_12783_12896 = state_12778__$1;
(statearr_12783_12896[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (5))){
var inst_12762 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12778__$1 = state_12778;
var statearr_12784_12897 = state_12778__$1;
(statearr_12784_12897[(2)] = inst_12762);

(statearr_12784_12897[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (6))){
var inst_12764 = (state_12778[(8)]);
var inst_12759 = (state_12778[(7)]);
var inst_12764__$1 = cljs.core.async.chan.call(null,(1));
var inst_12765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12766 = [inst_12759,inst_12764__$1];
var inst_12767 = (new cljs.core.PersistentVector(null,2,(5),inst_12765,inst_12766,null));
var state_12778__$1 = (function (){var statearr_12785 = state_12778;
(statearr_12785[(8)] = inst_12764__$1);

return statearr_12785;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12778__$1,(8),jobs,inst_12767);
} else {
if((state_val_12779 === (7))){
var inst_12774 = (state_12778[(2)]);
var state_12778__$1 = state_12778;
var statearr_12786_12898 = state_12778__$1;
(statearr_12786_12898[(2)] = inst_12774);

(statearr_12786_12898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12779 === (8))){
var inst_12764 = (state_12778[(8)]);
var inst_12769 = (state_12778[(2)]);
var state_12778__$1 = (function (){var statearr_12787 = state_12778;
(statearr_12787[(9)] = inst_12769);

return statearr_12787;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12778__$1,(9),results,inst_12764);
} else {
if((state_val_12779 === (9))){
var inst_12771 = (state_12778[(2)]);
var state_12778__$1 = (function (){var statearr_12788 = state_12778;
(statearr_12788[(10)] = inst_12771);

return statearr_12788;
})();
var statearr_12789_12899 = state_12778__$1;
(statearr_12789_12899[(2)] = null);

(statearr_12789_12899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___12893,jobs,results,process,async))
;
return ((function (switch__12197__auto__,c__12309__auto___12893,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_12793 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12793[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_12793[(1)] = (1));

return statearr_12793;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_12778){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12794){if((e12794 instanceof Object)){
var ex__12201__auto__ = e12794;
var statearr_12795_12900 = state_12778;
(statearr_12795_12900[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12778);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12901 = state_12778;
state_12778 = G__12901;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_12778){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_12778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___12893,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_12796 = f__12310__auto__.call(null);
(statearr_12796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___12893);

return statearr_12796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___12893,jobs,results,process,async))
);


var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__,jobs,results,process,async){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,jobs,results,process,async){
return (function (state_12834){
var state_val_12835 = (state_12834[(1)]);
if((state_val_12835 === (7))){
var inst_12830 = (state_12834[(2)]);
var state_12834__$1 = state_12834;
var statearr_12836_12902 = state_12834__$1;
(statearr_12836_12902[(2)] = inst_12830);

(statearr_12836_12902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (20))){
var state_12834__$1 = state_12834;
var statearr_12837_12903 = state_12834__$1;
(statearr_12837_12903[(2)] = null);

(statearr_12837_12903[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (1))){
var state_12834__$1 = state_12834;
var statearr_12838_12904 = state_12834__$1;
(statearr_12838_12904[(2)] = null);

(statearr_12838_12904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (4))){
var inst_12799 = (state_12834[(7)]);
var inst_12799__$1 = (state_12834[(2)]);
var inst_12800 = (inst_12799__$1 == null);
var state_12834__$1 = (function (){var statearr_12839 = state_12834;
(statearr_12839[(7)] = inst_12799__$1);

return statearr_12839;
})();
if(cljs.core.truth_(inst_12800)){
var statearr_12840_12905 = state_12834__$1;
(statearr_12840_12905[(1)] = (5));

} else {
var statearr_12841_12906 = state_12834__$1;
(statearr_12841_12906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (15))){
var inst_12812 = (state_12834[(8)]);
var state_12834__$1 = state_12834;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12834__$1,(18),to,inst_12812);
} else {
if((state_val_12835 === (21))){
var inst_12825 = (state_12834[(2)]);
var state_12834__$1 = state_12834;
var statearr_12842_12907 = state_12834__$1;
(statearr_12842_12907[(2)] = inst_12825);

(statearr_12842_12907[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (13))){
var inst_12827 = (state_12834[(2)]);
var state_12834__$1 = (function (){var statearr_12843 = state_12834;
(statearr_12843[(9)] = inst_12827);

return statearr_12843;
})();
var statearr_12844_12908 = state_12834__$1;
(statearr_12844_12908[(2)] = null);

(statearr_12844_12908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (6))){
var inst_12799 = (state_12834[(7)]);
var state_12834__$1 = state_12834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12834__$1,(11),inst_12799);
} else {
if((state_val_12835 === (17))){
var inst_12820 = (state_12834[(2)]);
var state_12834__$1 = state_12834;
if(cljs.core.truth_(inst_12820)){
var statearr_12845_12909 = state_12834__$1;
(statearr_12845_12909[(1)] = (19));

} else {
var statearr_12846_12910 = state_12834__$1;
(statearr_12846_12910[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (3))){
var inst_12832 = (state_12834[(2)]);
var state_12834__$1 = state_12834;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12834__$1,inst_12832);
} else {
if((state_val_12835 === (12))){
var inst_12809 = (state_12834[(10)]);
var state_12834__$1 = state_12834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12834__$1,(14),inst_12809);
} else {
if((state_val_12835 === (2))){
var state_12834__$1 = state_12834;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12834__$1,(4),results);
} else {
if((state_val_12835 === (19))){
var state_12834__$1 = state_12834;
var statearr_12847_12911 = state_12834__$1;
(statearr_12847_12911[(2)] = null);

(statearr_12847_12911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (11))){
var inst_12809 = (state_12834[(2)]);
var state_12834__$1 = (function (){var statearr_12848 = state_12834;
(statearr_12848[(10)] = inst_12809);

return statearr_12848;
})();
var statearr_12849_12912 = state_12834__$1;
(statearr_12849_12912[(2)] = null);

(statearr_12849_12912[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (9))){
var state_12834__$1 = state_12834;
var statearr_12850_12913 = state_12834__$1;
(statearr_12850_12913[(2)] = null);

(statearr_12850_12913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (5))){
var state_12834__$1 = state_12834;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12851_12914 = state_12834__$1;
(statearr_12851_12914[(1)] = (8));

} else {
var statearr_12852_12915 = state_12834__$1;
(statearr_12852_12915[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (14))){
var inst_12812 = (state_12834[(8)]);
var inst_12814 = (state_12834[(11)]);
var inst_12812__$1 = (state_12834[(2)]);
var inst_12813 = (inst_12812__$1 == null);
var inst_12814__$1 = cljs.core.not.call(null,inst_12813);
var state_12834__$1 = (function (){var statearr_12853 = state_12834;
(statearr_12853[(8)] = inst_12812__$1);

(statearr_12853[(11)] = inst_12814__$1);

return statearr_12853;
})();
if(inst_12814__$1){
var statearr_12854_12916 = state_12834__$1;
(statearr_12854_12916[(1)] = (15));

} else {
var statearr_12855_12917 = state_12834__$1;
(statearr_12855_12917[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (16))){
var inst_12814 = (state_12834[(11)]);
var state_12834__$1 = state_12834;
var statearr_12856_12918 = state_12834__$1;
(statearr_12856_12918[(2)] = inst_12814);

(statearr_12856_12918[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (10))){
var inst_12806 = (state_12834[(2)]);
var state_12834__$1 = state_12834;
var statearr_12857_12919 = state_12834__$1;
(statearr_12857_12919[(2)] = inst_12806);

(statearr_12857_12919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (18))){
var inst_12817 = (state_12834[(2)]);
var state_12834__$1 = state_12834;
var statearr_12858_12920 = state_12834__$1;
(statearr_12858_12920[(2)] = inst_12817);

(statearr_12858_12920[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12835 === (8))){
var inst_12803 = cljs.core.async.close_BANG_.call(null,to);
var state_12834__$1 = state_12834;
var statearr_12859_12921 = state_12834__$1;
(statearr_12859_12921[(2)] = inst_12803);

(statearr_12859_12921[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,jobs,results,process,async))
;
return ((function (switch__12197__auto__,c__12309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_12863 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12863[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__);

(statearr_12863[(1)] = (1));

return statearr_12863;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1 = (function (state_12834){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12834);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12864){if((e12864 instanceof Object)){
var ex__12201__auto__ = e12864;
var statearr_12865_12922 = state_12834;
(statearr_12865_12922[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12834);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12923 = state_12834;
state_12834 = G__12923;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__ = function(state_12834){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1.call(this,state_12834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,jobs,results,process,async))
})();
var state__12311__auto__ = (function (){var statearr_12866 = f__12310__auto__.call(null);
(statearr_12866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_12866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__,jobs,results,process,async))
);

return c__12309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12924 = [];
var len__7484__auto___12927 = arguments.length;
var i__7485__auto___12928 = (0);
while(true){
if((i__7485__auto___12928 < len__7484__auto___12927)){
args12924.push((arguments[i__7485__auto___12928]));

var G__12929 = (i__7485__auto___12928 + (1));
i__7485__auto___12928 = G__12929;
continue;
} else {
}
break;
}

var G__12926 = args12924.length;
switch (G__12926) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12924.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12931 = [];
var len__7484__auto___12934 = arguments.length;
var i__7485__auto___12935 = (0);
while(true){
if((i__7485__auto___12935 < len__7484__auto___12934)){
args12931.push((arguments[i__7485__auto___12935]));

var G__12936 = (i__7485__auto___12935 + (1));
i__7485__auto___12935 = G__12936;
continue;
} else {
}
break;
}

var G__12933 = args12931.length;
switch (G__12933) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12931.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12938 = [];
var len__7484__auto___12991 = arguments.length;
var i__7485__auto___12992 = (0);
while(true){
if((i__7485__auto___12992 < len__7484__auto___12991)){
args12938.push((arguments[i__7485__auto___12992]));

var G__12993 = (i__7485__auto___12992 + (1));
i__7485__auto___12992 = G__12993;
continue;
} else {
}
break;
}

var G__12940 = args12938.length;
switch (G__12940) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12938.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__12309__auto___12995 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___12995,tc,fc){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___12995,tc,fc){
return (function (state_12966){
var state_val_12967 = (state_12966[(1)]);
if((state_val_12967 === (7))){
var inst_12962 = (state_12966[(2)]);
var state_12966__$1 = state_12966;
var statearr_12968_12996 = state_12966__$1;
(statearr_12968_12996[(2)] = inst_12962);

(statearr_12968_12996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (1))){
var state_12966__$1 = state_12966;
var statearr_12969_12997 = state_12966__$1;
(statearr_12969_12997[(2)] = null);

(statearr_12969_12997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (4))){
var inst_12943 = (state_12966[(7)]);
var inst_12943__$1 = (state_12966[(2)]);
var inst_12944 = (inst_12943__$1 == null);
var state_12966__$1 = (function (){var statearr_12970 = state_12966;
(statearr_12970[(7)] = inst_12943__$1);

return statearr_12970;
})();
if(cljs.core.truth_(inst_12944)){
var statearr_12971_12998 = state_12966__$1;
(statearr_12971_12998[(1)] = (5));

} else {
var statearr_12972_12999 = state_12966__$1;
(statearr_12972_12999[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (13))){
var state_12966__$1 = state_12966;
var statearr_12973_13000 = state_12966__$1;
(statearr_12973_13000[(2)] = null);

(statearr_12973_13000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (6))){
var inst_12943 = (state_12966[(7)]);
var inst_12949 = p.call(null,inst_12943);
var state_12966__$1 = state_12966;
if(cljs.core.truth_(inst_12949)){
var statearr_12974_13001 = state_12966__$1;
(statearr_12974_13001[(1)] = (9));

} else {
var statearr_12975_13002 = state_12966__$1;
(statearr_12975_13002[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (3))){
var inst_12964 = (state_12966[(2)]);
var state_12966__$1 = state_12966;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12966__$1,inst_12964);
} else {
if((state_val_12967 === (12))){
var state_12966__$1 = state_12966;
var statearr_12976_13003 = state_12966__$1;
(statearr_12976_13003[(2)] = null);

(statearr_12976_13003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (2))){
var state_12966__$1 = state_12966;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12966__$1,(4),ch);
} else {
if((state_val_12967 === (11))){
var inst_12943 = (state_12966[(7)]);
var inst_12953 = (state_12966[(2)]);
var state_12966__$1 = state_12966;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12966__$1,(8),inst_12953,inst_12943);
} else {
if((state_val_12967 === (9))){
var state_12966__$1 = state_12966;
var statearr_12977_13004 = state_12966__$1;
(statearr_12977_13004[(2)] = tc);

(statearr_12977_13004[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (5))){
var inst_12946 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12947 = cljs.core.async.close_BANG_.call(null,fc);
var state_12966__$1 = (function (){var statearr_12978 = state_12966;
(statearr_12978[(8)] = inst_12946);

return statearr_12978;
})();
var statearr_12979_13005 = state_12966__$1;
(statearr_12979_13005[(2)] = inst_12947);

(statearr_12979_13005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (14))){
var inst_12960 = (state_12966[(2)]);
var state_12966__$1 = state_12966;
var statearr_12980_13006 = state_12966__$1;
(statearr_12980_13006[(2)] = inst_12960);

(statearr_12980_13006[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (10))){
var state_12966__$1 = state_12966;
var statearr_12981_13007 = state_12966__$1;
(statearr_12981_13007[(2)] = fc);

(statearr_12981_13007[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12967 === (8))){
var inst_12955 = (state_12966[(2)]);
var state_12966__$1 = state_12966;
if(cljs.core.truth_(inst_12955)){
var statearr_12982_13008 = state_12966__$1;
(statearr_12982_13008[(1)] = (12));

} else {
var statearr_12983_13009 = state_12966__$1;
(statearr_12983_13009[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___12995,tc,fc))
;
return ((function (switch__12197__auto__,c__12309__auto___12995,tc,fc){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_12987 = [null,null,null,null,null,null,null,null,null];
(statearr_12987[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_12987[(1)] = (1));

return statearr_12987;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_12966){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_12966);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e12988){if((e12988 instanceof Object)){
var ex__12201__auto__ = e12988;
var statearr_12989_13010 = state_12966;
(statearr_12989_13010[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12966);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12988;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13011 = state_12966;
state_12966 = G__13011;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_12966){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_12966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___12995,tc,fc))
})();
var state__12311__auto__ = (function (){var statearr_12990 = f__12310__auto__.call(null);
(statearr_12990[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___12995);

return statearr_12990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___12995,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_13075){
var state_val_13076 = (state_13075[(1)]);
if((state_val_13076 === (7))){
var inst_13071 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13077_13098 = state_13075__$1;
(statearr_13077_13098[(2)] = inst_13071);

(statearr_13077_13098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (1))){
var inst_13055 = init;
var state_13075__$1 = (function (){var statearr_13078 = state_13075;
(statearr_13078[(7)] = inst_13055);

return statearr_13078;
})();
var statearr_13079_13099 = state_13075__$1;
(statearr_13079_13099[(2)] = null);

(statearr_13079_13099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (4))){
var inst_13058 = (state_13075[(8)]);
var inst_13058__$1 = (state_13075[(2)]);
var inst_13059 = (inst_13058__$1 == null);
var state_13075__$1 = (function (){var statearr_13080 = state_13075;
(statearr_13080[(8)] = inst_13058__$1);

return statearr_13080;
})();
if(cljs.core.truth_(inst_13059)){
var statearr_13081_13100 = state_13075__$1;
(statearr_13081_13100[(1)] = (5));

} else {
var statearr_13082_13101 = state_13075__$1;
(statearr_13082_13101[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (6))){
var inst_13058 = (state_13075[(8)]);
var inst_13055 = (state_13075[(7)]);
var inst_13062 = (state_13075[(9)]);
var inst_13062__$1 = f.call(null,inst_13055,inst_13058);
var inst_13063 = cljs.core.reduced_QMARK_.call(null,inst_13062__$1);
var state_13075__$1 = (function (){var statearr_13083 = state_13075;
(statearr_13083[(9)] = inst_13062__$1);

return statearr_13083;
})();
if(inst_13063){
var statearr_13084_13102 = state_13075__$1;
(statearr_13084_13102[(1)] = (8));

} else {
var statearr_13085_13103 = state_13075__$1;
(statearr_13085_13103[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (3))){
var inst_13073 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13075__$1,inst_13073);
} else {
if((state_val_13076 === (2))){
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13075__$1,(4),ch);
} else {
if((state_val_13076 === (9))){
var inst_13062 = (state_13075[(9)]);
var inst_13055 = inst_13062;
var state_13075__$1 = (function (){var statearr_13086 = state_13075;
(statearr_13086[(7)] = inst_13055);

return statearr_13086;
})();
var statearr_13087_13104 = state_13075__$1;
(statearr_13087_13104[(2)] = null);

(statearr_13087_13104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (5))){
var inst_13055 = (state_13075[(7)]);
var state_13075__$1 = state_13075;
var statearr_13088_13105 = state_13075__$1;
(statearr_13088_13105[(2)] = inst_13055);

(statearr_13088_13105[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (10))){
var inst_13069 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13089_13106 = state_13075__$1;
(statearr_13089_13106[(2)] = inst_13069);

(statearr_13089_13106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (8))){
var inst_13062 = (state_13075[(9)]);
var inst_13065 = cljs.core.deref.call(null,inst_13062);
var state_13075__$1 = state_13075;
var statearr_13090_13107 = state_13075__$1;
(statearr_13090_13107[(2)] = inst_13065);

(statearr_13090_13107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12198__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12198__auto____0 = (function (){
var statearr_13094 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13094[(0)] = cljs$core$async$reduce_$_state_machine__12198__auto__);

(statearr_13094[(1)] = (1));

return statearr_13094;
});
var cljs$core$async$reduce_$_state_machine__12198__auto____1 = (function (state_13075){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_13075);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e13095){if((e13095 instanceof Object)){
var ex__12201__auto__ = e13095;
var statearr_13096_13108 = state_13075;
(statearr_13096_13108[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13075);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13095;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13109 = state_13075;
state_13075 = G__13109;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12198__auto__ = function(state_13075){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12198__auto____1.call(this,state_13075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12198__auto____0;
cljs$core$async$reduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12198__auto____1;
return cljs$core$async$reduce_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_13097 = f__12310__auto__.call(null);
(statearr_13097[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_13097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__,f__$1){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,f__$1){
return (function (state_13129){
var state_val_13130 = (state_13129[(1)]);
if((state_val_13130 === (1))){
var inst_13124 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_13129__$1 = state_13129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13129__$1,(2),inst_13124);
} else {
if((state_val_13130 === (2))){
var inst_13126 = (state_13129[(2)]);
var inst_13127 = f__$1.call(null,inst_13126);
var state_13129__$1 = state_13129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13129__$1,inst_13127);
} else {
return null;
}
}
});})(c__12309__auto__,f__$1))
;
return ((function (switch__12197__auto__,c__12309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12198__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12198__auto____0 = (function (){
var statearr_13134 = [null,null,null,null,null,null,null];
(statearr_13134[(0)] = cljs$core$async$transduce_$_state_machine__12198__auto__);

(statearr_13134[(1)] = (1));

return statearr_13134;
});
var cljs$core$async$transduce_$_state_machine__12198__auto____1 = (function (state_13129){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_13129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e13135){if((e13135 instanceof Object)){
var ex__12201__auto__ = e13135;
var statearr_13136_13138 = state_13129;
(statearr_13136_13138[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13129);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13135;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13139 = state_13129;
state_13129 = G__13139;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12198__auto__ = function(state_13129){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12198__auto____1.call(this,state_13129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12198__auto____0;
cljs$core$async$transduce_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12198__auto____1;
return cljs$core$async$transduce_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,f__$1))
})();
var state__12311__auto__ = (function (){var statearr_13137 = f__12310__auto__.call(null);
(statearr_13137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_13137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__,f__$1))
);

return c__12309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args13140 = [];
var len__7484__auto___13192 = arguments.length;
var i__7485__auto___13193 = (0);
while(true){
if((i__7485__auto___13193 < len__7484__auto___13192)){
args13140.push((arguments[i__7485__auto___13193]));

var G__13194 = (i__7485__auto___13193 + (1));
i__7485__auto___13193 = G__13194;
continue;
} else {
}
break;
}

var G__13142 = args13140.length;
switch (G__13142) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13140.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_13167){
var state_val_13168 = (state_13167[(1)]);
if((state_val_13168 === (7))){
var inst_13149 = (state_13167[(2)]);
var state_13167__$1 = state_13167;
var statearr_13169_13196 = state_13167__$1;
(statearr_13169_13196[(2)] = inst_13149);

(statearr_13169_13196[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (1))){
var inst_13143 = cljs.core.seq.call(null,coll);
var inst_13144 = inst_13143;
var state_13167__$1 = (function (){var statearr_13170 = state_13167;
(statearr_13170[(7)] = inst_13144);

return statearr_13170;
})();
var statearr_13171_13197 = state_13167__$1;
(statearr_13171_13197[(2)] = null);

(statearr_13171_13197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (4))){
var inst_13144 = (state_13167[(7)]);
var inst_13147 = cljs.core.first.call(null,inst_13144);
var state_13167__$1 = state_13167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13167__$1,(7),ch,inst_13147);
} else {
if((state_val_13168 === (13))){
var inst_13161 = (state_13167[(2)]);
var state_13167__$1 = state_13167;
var statearr_13172_13198 = state_13167__$1;
(statearr_13172_13198[(2)] = inst_13161);

(statearr_13172_13198[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (6))){
var inst_13152 = (state_13167[(2)]);
var state_13167__$1 = state_13167;
if(cljs.core.truth_(inst_13152)){
var statearr_13173_13199 = state_13167__$1;
(statearr_13173_13199[(1)] = (8));

} else {
var statearr_13174_13200 = state_13167__$1;
(statearr_13174_13200[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (3))){
var inst_13165 = (state_13167[(2)]);
var state_13167__$1 = state_13167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13167__$1,inst_13165);
} else {
if((state_val_13168 === (12))){
var state_13167__$1 = state_13167;
var statearr_13175_13201 = state_13167__$1;
(statearr_13175_13201[(2)] = null);

(statearr_13175_13201[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (2))){
var inst_13144 = (state_13167[(7)]);
var state_13167__$1 = state_13167;
if(cljs.core.truth_(inst_13144)){
var statearr_13176_13202 = state_13167__$1;
(statearr_13176_13202[(1)] = (4));

} else {
var statearr_13177_13203 = state_13167__$1;
(statearr_13177_13203[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (11))){
var inst_13158 = cljs.core.async.close_BANG_.call(null,ch);
var state_13167__$1 = state_13167;
var statearr_13178_13204 = state_13167__$1;
(statearr_13178_13204[(2)] = inst_13158);

(statearr_13178_13204[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (9))){
var state_13167__$1 = state_13167;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13179_13205 = state_13167__$1;
(statearr_13179_13205[(1)] = (11));

} else {
var statearr_13180_13206 = state_13167__$1;
(statearr_13180_13206[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (5))){
var inst_13144 = (state_13167[(7)]);
var state_13167__$1 = state_13167;
var statearr_13181_13207 = state_13167__$1;
(statearr_13181_13207[(2)] = inst_13144);

(statearr_13181_13207[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (10))){
var inst_13163 = (state_13167[(2)]);
var state_13167__$1 = state_13167;
var statearr_13182_13208 = state_13167__$1;
(statearr_13182_13208[(2)] = inst_13163);

(statearr_13182_13208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13168 === (8))){
var inst_13144 = (state_13167[(7)]);
var inst_13154 = cljs.core.next.call(null,inst_13144);
var inst_13144__$1 = inst_13154;
var state_13167__$1 = (function (){var statearr_13183 = state_13167;
(statearr_13183[(7)] = inst_13144__$1);

return statearr_13183;
})();
var statearr_13184_13209 = state_13167__$1;
(statearr_13184_13209[(2)] = null);

(statearr_13184_13209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_13188 = [null,null,null,null,null,null,null,null];
(statearr_13188[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_13188[(1)] = (1));

return statearr_13188;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_13167){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_13167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e13189){if((e13189 instanceof Object)){
var ex__12201__auto__ = e13189;
var statearr_13190_13210 = state_13167;
(statearr_13190_13210[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13167);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13189;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13211 = state_13167;
state_13167 = G__13211;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_13167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_13167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_13191 = f__12310__auto__.call(null);
(statearr_13191[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_13191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13437 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13437 = (function (mult,ch,cs,meta13438){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta13438 = meta13438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13439,meta13438__$1){
var self__ = this;
var _13439__$1 = this;
return (new cljs.core.async.t_cljs$core$async13437(self__.mult,self__.ch,self__.cs,meta13438__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13439){
var self__ = this;
var _13439__$1 = this;
return self__.meta13438;
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13438","meta13438",1709496444,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async13437.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13437.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13437";

cljs.core.async.t_cljs$core$async13437.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13437");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async13437 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async13437(mult__$1,ch__$1,cs__$1,meta13438){
return (new cljs.core.async.t_cljs$core$async13437(mult__$1,ch__$1,cs__$1,meta13438));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async13437(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12309__auto___13662 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___13662,cs,m,dchan,dctr,done){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___13662,cs,m,dchan,dctr,done){
return (function (state_13574){
var state_val_13575 = (state_13574[(1)]);
if((state_val_13575 === (7))){
var inst_13570 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13576_13663 = state_13574__$1;
(statearr_13576_13663[(2)] = inst_13570);

(statearr_13576_13663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (20))){
var inst_13473 = (state_13574[(7)]);
var inst_13485 = cljs.core.first.call(null,inst_13473);
var inst_13486 = cljs.core.nth.call(null,inst_13485,(0),null);
var inst_13487 = cljs.core.nth.call(null,inst_13485,(1),null);
var state_13574__$1 = (function (){var statearr_13577 = state_13574;
(statearr_13577[(8)] = inst_13486);

return statearr_13577;
})();
if(cljs.core.truth_(inst_13487)){
var statearr_13578_13664 = state_13574__$1;
(statearr_13578_13664[(1)] = (22));

} else {
var statearr_13579_13665 = state_13574__$1;
(statearr_13579_13665[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (27))){
var inst_13522 = (state_13574[(9)]);
var inst_13517 = (state_13574[(10)]);
var inst_13515 = (state_13574[(11)]);
var inst_13442 = (state_13574[(12)]);
var inst_13522__$1 = cljs.core._nth.call(null,inst_13515,inst_13517);
var inst_13523 = cljs.core.async.put_BANG_.call(null,inst_13522__$1,inst_13442,done);
var state_13574__$1 = (function (){var statearr_13580 = state_13574;
(statearr_13580[(9)] = inst_13522__$1);

return statearr_13580;
})();
if(cljs.core.truth_(inst_13523)){
var statearr_13581_13666 = state_13574__$1;
(statearr_13581_13666[(1)] = (30));

} else {
var statearr_13582_13667 = state_13574__$1;
(statearr_13582_13667[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (1))){
var state_13574__$1 = state_13574;
var statearr_13583_13668 = state_13574__$1;
(statearr_13583_13668[(2)] = null);

(statearr_13583_13668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (24))){
var inst_13473 = (state_13574[(7)]);
var inst_13492 = (state_13574[(2)]);
var inst_13493 = cljs.core.next.call(null,inst_13473);
var inst_13451 = inst_13493;
var inst_13452 = null;
var inst_13453 = (0);
var inst_13454 = (0);
var state_13574__$1 = (function (){var statearr_13584 = state_13574;
(statearr_13584[(13)] = inst_13454);

(statearr_13584[(14)] = inst_13451);

(statearr_13584[(15)] = inst_13492);

(statearr_13584[(16)] = inst_13453);

(statearr_13584[(17)] = inst_13452);

return statearr_13584;
})();
var statearr_13585_13669 = state_13574__$1;
(statearr_13585_13669[(2)] = null);

(statearr_13585_13669[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (39))){
var state_13574__$1 = state_13574;
var statearr_13589_13670 = state_13574__$1;
(statearr_13589_13670[(2)] = null);

(statearr_13589_13670[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (4))){
var inst_13442 = (state_13574[(12)]);
var inst_13442__$1 = (state_13574[(2)]);
var inst_13443 = (inst_13442__$1 == null);
var state_13574__$1 = (function (){var statearr_13590 = state_13574;
(statearr_13590[(12)] = inst_13442__$1);

return statearr_13590;
})();
if(cljs.core.truth_(inst_13443)){
var statearr_13591_13671 = state_13574__$1;
(statearr_13591_13671[(1)] = (5));

} else {
var statearr_13592_13672 = state_13574__$1;
(statearr_13592_13672[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (15))){
var inst_13454 = (state_13574[(13)]);
var inst_13451 = (state_13574[(14)]);
var inst_13453 = (state_13574[(16)]);
var inst_13452 = (state_13574[(17)]);
var inst_13469 = (state_13574[(2)]);
var inst_13470 = (inst_13454 + (1));
var tmp13586 = inst_13451;
var tmp13587 = inst_13453;
var tmp13588 = inst_13452;
var inst_13451__$1 = tmp13586;
var inst_13452__$1 = tmp13588;
var inst_13453__$1 = tmp13587;
var inst_13454__$1 = inst_13470;
var state_13574__$1 = (function (){var statearr_13593 = state_13574;
(statearr_13593[(13)] = inst_13454__$1);

(statearr_13593[(18)] = inst_13469);

(statearr_13593[(14)] = inst_13451__$1);

(statearr_13593[(16)] = inst_13453__$1);

(statearr_13593[(17)] = inst_13452__$1);

return statearr_13593;
})();
var statearr_13594_13673 = state_13574__$1;
(statearr_13594_13673[(2)] = null);

(statearr_13594_13673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (21))){
var inst_13496 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13598_13674 = state_13574__$1;
(statearr_13598_13674[(2)] = inst_13496);

(statearr_13598_13674[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (31))){
var inst_13522 = (state_13574[(9)]);
var inst_13526 = done.call(null,null);
var inst_13527 = cljs.core.async.untap_STAR_.call(null,m,inst_13522);
var state_13574__$1 = (function (){var statearr_13599 = state_13574;
(statearr_13599[(19)] = inst_13526);

return statearr_13599;
})();
var statearr_13600_13675 = state_13574__$1;
(statearr_13600_13675[(2)] = inst_13527);

(statearr_13600_13675[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (32))){
var inst_13517 = (state_13574[(10)]);
var inst_13514 = (state_13574[(20)]);
var inst_13515 = (state_13574[(11)]);
var inst_13516 = (state_13574[(21)]);
var inst_13529 = (state_13574[(2)]);
var inst_13530 = (inst_13517 + (1));
var tmp13595 = inst_13514;
var tmp13596 = inst_13515;
var tmp13597 = inst_13516;
var inst_13514__$1 = tmp13595;
var inst_13515__$1 = tmp13596;
var inst_13516__$1 = tmp13597;
var inst_13517__$1 = inst_13530;
var state_13574__$1 = (function (){var statearr_13601 = state_13574;
(statearr_13601[(10)] = inst_13517__$1);

(statearr_13601[(20)] = inst_13514__$1);

(statearr_13601[(11)] = inst_13515__$1);

(statearr_13601[(22)] = inst_13529);

(statearr_13601[(21)] = inst_13516__$1);

return statearr_13601;
})();
var statearr_13602_13676 = state_13574__$1;
(statearr_13602_13676[(2)] = null);

(statearr_13602_13676[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (40))){
var inst_13542 = (state_13574[(23)]);
var inst_13546 = done.call(null,null);
var inst_13547 = cljs.core.async.untap_STAR_.call(null,m,inst_13542);
var state_13574__$1 = (function (){var statearr_13603 = state_13574;
(statearr_13603[(24)] = inst_13546);

return statearr_13603;
})();
var statearr_13604_13677 = state_13574__$1;
(statearr_13604_13677[(2)] = inst_13547);

(statearr_13604_13677[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (33))){
var inst_13533 = (state_13574[(25)]);
var inst_13535 = cljs.core.chunked_seq_QMARK_.call(null,inst_13533);
var state_13574__$1 = state_13574;
if(inst_13535){
var statearr_13605_13678 = state_13574__$1;
(statearr_13605_13678[(1)] = (36));

} else {
var statearr_13606_13679 = state_13574__$1;
(statearr_13606_13679[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (13))){
var inst_13463 = (state_13574[(26)]);
var inst_13466 = cljs.core.async.close_BANG_.call(null,inst_13463);
var state_13574__$1 = state_13574;
var statearr_13607_13680 = state_13574__$1;
(statearr_13607_13680[(2)] = inst_13466);

(statearr_13607_13680[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (22))){
var inst_13486 = (state_13574[(8)]);
var inst_13489 = cljs.core.async.close_BANG_.call(null,inst_13486);
var state_13574__$1 = state_13574;
var statearr_13608_13681 = state_13574__$1;
(statearr_13608_13681[(2)] = inst_13489);

(statearr_13608_13681[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (36))){
var inst_13533 = (state_13574[(25)]);
var inst_13537 = cljs.core.chunk_first.call(null,inst_13533);
var inst_13538 = cljs.core.chunk_rest.call(null,inst_13533);
var inst_13539 = cljs.core.count.call(null,inst_13537);
var inst_13514 = inst_13538;
var inst_13515 = inst_13537;
var inst_13516 = inst_13539;
var inst_13517 = (0);
var state_13574__$1 = (function (){var statearr_13609 = state_13574;
(statearr_13609[(10)] = inst_13517);

(statearr_13609[(20)] = inst_13514);

(statearr_13609[(11)] = inst_13515);

(statearr_13609[(21)] = inst_13516);

return statearr_13609;
})();
var statearr_13610_13682 = state_13574__$1;
(statearr_13610_13682[(2)] = null);

(statearr_13610_13682[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (41))){
var inst_13533 = (state_13574[(25)]);
var inst_13549 = (state_13574[(2)]);
var inst_13550 = cljs.core.next.call(null,inst_13533);
var inst_13514 = inst_13550;
var inst_13515 = null;
var inst_13516 = (0);
var inst_13517 = (0);
var state_13574__$1 = (function (){var statearr_13611 = state_13574;
(statearr_13611[(10)] = inst_13517);

(statearr_13611[(27)] = inst_13549);

(statearr_13611[(20)] = inst_13514);

(statearr_13611[(11)] = inst_13515);

(statearr_13611[(21)] = inst_13516);

return statearr_13611;
})();
var statearr_13612_13683 = state_13574__$1;
(statearr_13612_13683[(2)] = null);

(statearr_13612_13683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (43))){
var state_13574__$1 = state_13574;
var statearr_13613_13684 = state_13574__$1;
(statearr_13613_13684[(2)] = null);

(statearr_13613_13684[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (29))){
var inst_13558 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13614_13685 = state_13574__$1;
(statearr_13614_13685[(2)] = inst_13558);

(statearr_13614_13685[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (44))){
var inst_13567 = (state_13574[(2)]);
var state_13574__$1 = (function (){var statearr_13615 = state_13574;
(statearr_13615[(28)] = inst_13567);

return statearr_13615;
})();
var statearr_13616_13686 = state_13574__$1;
(statearr_13616_13686[(2)] = null);

(statearr_13616_13686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (6))){
var inst_13506 = (state_13574[(29)]);
var inst_13505 = cljs.core.deref.call(null,cs);
var inst_13506__$1 = cljs.core.keys.call(null,inst_13505);
var inst_13507 = cljs.core.count.call(null,inst_13506__$1);
var inst_13508 = cljs.core.reset_BANG_.call(null,dctr,inst_13507);
var inst_13513 = cljs.core.seq.call(null,inst_13506__$1);
var inst_13514 = inst_13513;
var inst_13515 = null;
var inst_13516 = (0);
var inst_13517 = (0);
var state_13574__$1 = (function (){var statearr_13617 = state_13574;
(statearr_13617[(30)] = inst_13508);

(statearr_13617[(10)] = inst_13517);

(statearr_13617[(29)] = inst_13506__$1);

(statearr_13617[(20)] = inst_13514);

(statearr_13617[(11)] = inst_13515);

(statearr_13617[(21)] = inst_13516);

return statearr_13617;
})();
var statearr_13618_13687 = state_13574__$1;
(statearr_13618_13687[(2)] = null);

(statearr_13618_13687[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (28))){
var inst_13514 = (state_13574[(20)]);
var inst_13533 = (state_13574[(25)]);
var inst_13533__$1 = cljs.core.seq.call(null,inst_13514);
var state_13574__$1 = (function (){var statearr_13619 = state_13574;
(statearr_13619[(25)] = inst_13533__$1);

return statearr_13619;
})();
if(inst_13533__$1){
var statearr_13620_13688 = state_13574__$1;
(statearr_13620_13688[(1)] = (33));

} else {
var statearr_13621_13689 = state_13574__$1;
(statearr_13621_13689[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (25))){
var inst_13517 = (state_13574[(10)]);
var inst_13516 = (state_13574[(21)]);
var inst_13519 = (inst_13517 < inst_13516);
var inst_13520 = inst_13519;
var state_13574__$1 = state_13574;
if(cljs.core.truth_(inst_13520)){
var statearr_13622_13690 = state_13574__$1;
(statearr_13622_13690[(1)] = (27));

} else {
var statearr_13623_13691 = state_13574__$1;
(statearr_13623_13691[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (34))){
var state_13574__$1 = state_13574;
var statearr_13624_13692 = state_13574__$1;
(statearr_13624_13692[(2)] = null);

(statearr_13624_13692[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (17))){
var state_13574__$1 = state_13574;
var statearr_13625_13693 = state_13574__$1;
(statearr_13625_13693[(2)] = null);

(statearr_13625_13693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (3))){
var inst_13572 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13574__$1,inst_13572);
} else {
if((state_val_13575 === (12))){
var inst_13501 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13626_13694 = state_13574__$1;
(statearr_13626_13694[(2)] = inst_13501);

(statearr_13626_13694[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (2))){
var state_13574__$1 = state_13574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13574__$1,(4),ch);
} else {
if((state_val_13575 === (23))){
var state_13574__$1 = state_13574;
var statearr_13627_13695 = state_13574__$1;
(statearr_13627_13695[(2)] = null);

(statearr_13627_13695[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (35))){
var inst_13556 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13628_13696 = state_13574__$1;
(statearr_13628_13696[(2)] = inst_13556);

(statearr_13628_13696[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (19))){
var inst_13473 = (state_13574[(7)]);
var inst_13477 = cljs.core.chunk_first.call(null,inst_13473);
var inst_13478 = cljs.core.chunk_rest.call(null,inst_13473);
var inst_13479 = cljs.core.count.call(null,inst_13477);
var inst_13451 = inst_13478;
var inst_13452 = inst_13477;
var inst_13453 = inst_13479;
var inst_13454 = (0);
var state_13574__$1 = (function (){var statearr_13629 = state_13574;
(statearr_13629[(13)] = inst_13454);

(statearr_13629[(14)] = inst_13451);

(statearr_13629[(16)] = inst_13453);

(statearr_13629[(17)] = inst_13452);

return statearr_13629;
})();
var statearr_13630_13697 = state_13574__$1;
(statearr_13630_13697[(2)] = null);

(statearr_13630_13697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (11))){
var inst_13451 = (state_13574[(14)]);
var inst_13473 = (state_13574[(7)]);
var inst_13473__$1 = cljs.core.seq.call(null,inst_13451);
var state_13574__$1 = (function (){var statearr_13631 = state_13574;
(statearr_13631[(7)] = inst_13473__$1);

return statearr_13631;
})();
if(inst_13473__$1){
var statearr_13632_13698 = state_13574__$1;
(statearr_13632_13698[(1)] = (16));

} else {
var statearr_13633_13699 = state_13574__$1;
(statearr_13633_13699[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (9))){
var inst_13503 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13634_13700 = state_13574__$1;
(statearr_13634_13700[(2)] = inst_13503);

(statearr_13634_13700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (5))){
var inst_13449 = cljs.core.deref.call(null,cs);
var inst_13450 = cljs.core.seq.call(null,inst_13449);
var inst_13451 = inst_13450;
var inst_13452 = null;
var inst_13453 = (0);
var inst_13454 = (0);
var state_13574__$1 = (function (){var statearr_13635 = state_13574;
(statearr_13635[(13)] = inst_13454);

(statearr_13635[(14)] = inst_13451);

(statearr_13635[(16)] = inst_13453);

(statearr_13635[(17)] = inst_13452);

return statearr_13635;
})();
var statearr_13636_13701 = state_13574__$1;
(statearr_13636_13701[(2)] = null);

(statearr_13636_13701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (14))){
var state_13574__$1 = state_13574;
var statearr_13637_13702 = state_13574__$1;
(statearr_13637_13702[(2)] = null);

(statearr_13637_13702[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (45))){
var inst_13564 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13638_13703 = state_13574__$1;
(statearr_13638_13703[(2)] = inst_13564);

(statearr_13638_13703[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (26))){
var inst_13506 = (state_13574[(29)]);
var inst_13560 = (state_13574[(2)]);
var inst_13561 = cljs.core.seq.call(null,inst_13506);
var state_13574__$1 = (function (){var statearr_13639 = state_13574;
(statearr_13639[(31)] = inst_13560);

return statearr_13639;
})();
if(inst_13561){
var statearr_13640_13704 = state_13574__$1;
(statearr_13640_13704[(1)] = (42));

} else {
var statearr_13641_13705 = state_13574__$1;
(statearr_13641_13705[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (16))){
var inst_13473 = (state_13574[(7)]);
var inst_13475 = cljs.core.chunked_seq_QMARK_.call(null,inst_13473);
var state_13574__$1 = state_13574;
if(inst_13475){
var statearr_13642_13706 = state_13574__$1;
(statearr_13642_13706[(1)] = (19));

} else {
var statearr_13643_13707 = state_13574__$1;
(statearr_13643_13707[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (38))){
var inst_13553 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13644_13708 = state_13574__$1;
(statearr_13644_13708[(2)] = inst_13553);

(statearr_13644_13708[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (30))){
var state_13574__$1 = state_13574;
var statearr_13645_13709 = state_13574__$1;
(statearr_13645_13709[(2)] = null);

(statearr_13645_13709[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (10))){
var inst_13454 = (state_13574[(13)]);
var inst_13452 = (state_13574[(17)]);
var inst_13462 = cljs.core._nth.call(null,inst_13452,inst_13454);
var inst_13463 = cljs.core.nth.call(null,inst_13462,(0),null);
var inst_13464 = cljs.core.nth.call(null,inst_13462,(1),null);
var state_13574__$1 = (function (){var statearr_13646 = state_13574;
(statearr_13646[(26)] = inst_13463);

return statearr_13646;
})();
if(cljs.core.truth_(inst_13464)){
var statearr_13647_13710 = state_13574__$1;
(statearr_13647_13710[(1)] = (13));

} else {
var statearr_13648_13711 = state_13574__$1;
(statearr_13648_13711[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (18))){
var inst_13499 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13649_13712 = state_13574__$1;
(statearr_13649_13712[(2)] = inst_13499);

(statearr_13649_13712[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (42))){
var state_13574__$1 = state_13574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13574__$1,(45),dchan);
} else {
if((state_val_13575 === (37))){
var inst_13542 = (state_13574[(23)]);
var inst_13533 = (state_13574[(25)]);
var inst_13442 = (state_13574[(12)]);
var inst_13542__$1 = cljs.core.first.call(null,inst_13533);
var inst_13543 = cljs.core.async.put_BANG_.call(null,inst_13542__$1,inst_13442,done);
var state_13574__$1 = (function (){var statearr_13650 = state_13574;
(statearr_13650[(23)] = inst_13542__$1);

return statearr_13650;
})();
if(cljs.core.truth_(inst_13543)){
var statearr_13651_13713 = state_13574__$1;
(statearr_13651_13713[(1)] = (39));

} else {
var statearr_13652_13714 = state_13574__$1;
(statearr_13652_13714[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (8))){
var inst_13454 = (state_13574[(13)]);
var inst_13453 = (state_13574[(16)]);
var inst_13456 = (inst_13454 < inst_13453);
var inst_13457 = inst_13456;
var state_13574__$1 = state_13574;
if(cljs.core.truth_(inst_13457)){
var statearr_13653_13715 = state_13574__$1;
(statearr_13653_13715[(1)] = (10));

} else {
var statearr_13654_13716 = state_13574__$1;
(statearr_13654_13716[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___13662,cs,m,dchan,dctr,done))
;
return ((function (switch__12197__auto__,c__12309__auto___13662,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12198__auto__ = null;
var cljs$core$async$mult_$_state_machine__12198__auto____0 = (function (){
var statearr_13658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13658[(0)] = cljs$core$async$mult_$_state_machine__12198__auto__);

(statearr_13658[(1)] = (1));

return statearr_13658;
});
var cljs$core$async$mult_$_state_machine__12198__auto____1 = (function (state_13574){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_13574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e13659){if((e13659 instanceof Object)){
var ex__12201__auto__ = e13659;
var statearr_13660_13717 = state_13574;
(statearr_13660_13717[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13574);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13718 = state_13574;
state_13574 = G__13718;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12198__auto__ = function(state_13574){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12198__auto____1.call(this,state_13574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12198__auto____0;
cljs$core$async$mult_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12198__auto____1;
return cljs$core$async$mult_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___13662,cs,m,dchan,dctr,done))
})();
var state__12311__auto__ = (function (){var statearr_13661 = f__12310__auto__.call(null);
(statearr_13661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___13662);

return statearr_13661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___13662,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13719 = [];
var len__7484__auto___13722 = arguments.length;
var i__7485__auto___13723 = (0);
while(true){
if((i__7485__auto___13723 < len__7484__auto___13722)){
args13719.push((arguments[i__7485__auto___13723]));

var G__13724 = (i__7485__auto___13723 + (1));
i__7485__auto___13723 = G__13724;
continue;
} else {
}
break;
}

var G__13721 = args13719.length;
switch (G__13721) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13719.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13736 = arguments.length;
var i__7485__auto___13737 = (0);
while(true){
if((i__7485__auto___13737 < len__7484__auto___13736)){
args__7491__auto__.push((arguments[i__7485__auto___13737]));

var G__13738 = (i__7485__auto___13737 + (1));
i__7485__auto___13737 = G__13738;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13730){
var map__13731 = p__13730;
var map__13731__$1 = ((((!((map__13731 == null)))?((((map__13731.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13731.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13731):map__13731);
var opts = map__13731__$1;
var statearr_13733_13739 = state;
(statearr_13733_13739[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13731,map__13731__$1,opts){
return (function (val){
var statearr_13734_13740 = state;
(statearr_13734_13740[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13731,map__13731__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13735_13741 = state;
(statearr_13735_13741[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13726){
var G__13727 = cljs.core.first.call(null,seq13726);
var seq13726__$1 = cljs.core.next.call(null,seq13726);
var G__13728 = cljs.core.first.call(null,seq13726__$1);
var seq13726__$2 = cljs.core.next.call(null,seq13726__$1);
var G__13729 = cljs.core.first.call(null,seq13726__$2);
var seq13726__$3 = cljs.core.next.call(null,seq13726__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13727,G__13728,G__13729,seq13726__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13907 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13907 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13908){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13908 = meta13908;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13909,meta13908__$1){
var self__ = this;
var _13909__$1 = this;
return (new cljs.core.async.t_cljs$core$async13907(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13908__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13909){
var self__ = this;
var _13909__$1 = this;
return self__.meta13908;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13908","meta13908",1219038846,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13907.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13907.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13907";

cljs.core.async.t_cljs$core$async13907.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13907");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13907 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13907(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13908){
return (new cljs.core.async.t_cljs$core$async13907(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13908));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13907(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12309__auto___14072 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14072,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14072,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_14009){
var state_val_14010 = (state_14009[(1)]);
if((state_val_14010 === (7))){
var inst_13925 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14011_14073 = state_14009__$1;
(statearr_14011_14073[(2)] = inst_13925);

(statearr_14011_14073[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (20))){
var inst_13937 = (state_14009[(7)]);
var state_14009__$1 = state_14009;
var statearr_14012_14074 = state_14009__$1;
(statearr_14012_14074[(2)] = inst_13937);

(statearr_14012_14074[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (27))){
var state_14009__$1 = state_14009;
var statearr_14013_14075 = state_14009__$1;
(statearr_14013_14075[(2)] = null);

(statearr_14013_14075[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (1))){
var inst_13913 = (state_14009[(8)]);
var inst_13913__$1 = calc_state.call(null);
var inst_13915 = (inst_13913__$1 == null);
var inst_13916 = cljs.core.not.call(null,inst_13915);
var state_14009__$1 = (function (){var statearr_14014 = state_14009;
(statearr_14014[(8)] = inst_13913__$1);

return statearr_14014;
})();
if(inst_13916){
var statearr_14015_14076 = state_14009__$1;
(statearr_14015_14076[(1)] = (2));

} else {
var statearr_14016_14077 = state_14009__$1;
(statearr_14016_14077[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (24))){
var inst_13960 = (state_14009[(9)]);
var inst_13969 = (state_14009[(10)]);
var inst_13983 = (state_14009[(11)]);
var inst_13983__$1 = inst_13960.call(null,inst_13969);
var state_14009__$1 = (function (){var statearr_14017 = state_14009;
(statearr_14017[(11)] = inst_13983__$1);

return statearr_14017;
})();
if(cljs.core.truth_(inst_13983__$1)){
var statearr_14018_14078 = state_14009__$1;
(statearr_14018_14078[(1)] = (29));

} else {
var statearr_14019_14079 = state_14009__$1;
(statearr_14019_14079[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (4))){
var inst_13928 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13928)){
var statearr_14020_14080 = state_14009__$1;
(statearr_14020_14080[(1)] = (8));

} else {
var statearr_14021_14081 = state_14009__$1;
(statearr_14021_14081[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (15))){
var inst_13954 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13954)){
var statearr_14022_14082 = state_14009__$1;
(statearr_14022_14082[(1)] = (19));

} else {
var statearr_14023_14083 = state_14009__$1;
(statearr_14023_14083[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (21))){
var inst_13959 = (state_14009[(12)]);
var inst_13959__$1 = (state_14009[(2)]);
var inst_13960 = cljs.core.get.call(null,inst_13959__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13961 = cljs.core.get.call(null,inst_13959__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13962 = cljs.core.get.call(null,inst_13959__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_14009__$1 = (function (){var statearr_14024 = state_14009;
(statearr_14024[(9)] = inst_13960);

(statearr_14024[(12)] = inst_13959__$1);

(statearr_14024[(13)] = inst_13961);

return statearr_14024;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14009__$1,(22),inst_13962);
} else {
if((state_val_14010 === (31))){
var inst_13991 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13991)){
var statearr_14025_14084 = state_14009__$1;
(statearr_14025_14084[(1)] = (32));

} else {
var statearr_14026_14085 = state_14009__$1;
(statearr_14026_14085[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (32))){
var inst_13968 = (state_14009[(14)]);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14009__$1,(35),out,inst_13968);
} else {
if((state_val_14010 === (33))){
var inst_13959 = (state_14009[(12)]);
var inst_13937 = inst_13959;
var state_14009__$1 = (function (){var statearr_14027 = state_14009;
(statearr_14027[(7)] = inst_13937);

return statearr_14027;
})();
var statearr_14028_14086 = state_14009__$1;
(statearr_14028_14086[(2)] = null);

(statearr_14028_14086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (13))){
var inst_13937 = (state_14009[(7)]);
var inst_13944 = inst_13937.cljs$lang$protocol_mask$partition0$;
var inst_13945 = (inst_13944 & (64));
var inst_13946 = inst_13937.cljs$core$ISeq$;
var inst_13947 = (inst_13945) || (inst_13946);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13947)){
var statearr_14029_14087 = state_14009__$1;
(statearr_14029_14087[(1)] = (16));

} else {
var statearr_14030_14088 = state_14009__$1;
(statearr_14030_14088[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (22))){
var inst_13969 = (state_14009[(10)]);
var inst_13968 = (state_14009[(14)]);
var inst_13967 = (state_14009[(2)]);
var inst_13968__$1 = cljs.core.nth.call(null,inst_13967,(0),null);
var inst_13969__$1 = cljs.core.nth.call(null,inst_13967,(1),null);
var inst_13970 = (inst_13968__$1 == null);
var inst_13971 = cljs.core._EQ_.call(null,inst_13969__$1,change);
var inst_13972 = (inst_13970) || (inst_13971);
var state_14009__$1 = (function (){var statearr_14031 = state_14009;
(statearr_14031[(10)] = inst_13969__$1);

(statearr_14031[(14)] = inst_13968__$1);

return statearr_14031;
})();
if(cljs.core.truth_(inst_13972)){
var statearr_14032_14089 = state_14009__$1;
(statearr_14032_14089[(1)] = (23));

} else {
var statearr_14033_14090 = state_14009__$1;
(statearr_14033_14090[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (36))){
var inst_13959 = (state_14009[(12)]);
var inst_13937 = inst_13959;
var state_14009__$1 = (function (){var statearr_14034 = state_14009;
(statearr_14034[(7)] = inst_13937);

return statearr_14034;
})();
var statearr_14035_14091 = state_14009__$1;
(statearr_14035_14091[(2)] = null);

(statearr_14035_14091[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (29))){
var inst_13983 = (state_14009[(11)]);
var state_14009__$1 = state_14009;
var statearr_14036_14092 = state_14009__$1;
(statearr_14036_14092[(2)] = inst_13983);

(statearr_14036_14092[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (6))){
var state_14009__$1 = state_14009;
var statearr_14037_14093 = state_14009__$1;
(statearr_14037_14093[(2)] = false);

(statearr_14037_14093[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (28))){
var inst_13979 = (state_14009[(2)]);
var inst_13980 = calc_state.call(null);
var inst_13937 = inst_13980;
var state_14009__$1 = (function (){var statearr_14038 = state_14009;
(statearr_14038[(7)] = inst_13937);

(statearr_14038[(15)] = inst_13979);

return statearr_14038;
})();
var statearr_14039_14094 = state_14009__$1;
(statearr_14039_14094[(2)] = null);

(statearr_14039_14094[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (25))){
var inst_14005 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14040_14095 = state_14009__$1;
(statearr_14040_14095[(2)] = inst_14005);

(statearr_14040_14095[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (34))){
var inst_14003 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14041_14096 = state_14009__$1;
(statearr_14041_14096[(2)] = inst_14003);

(statearr_14041_14096[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (17))){
var state_14009__$1 = state_14009;
var statearr_14042_14097 = state_14009__$1;
(statearr_14042_14097[(2)] = false);

(statearr_14042_14097[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (3))){
var state_14009__$1 = state_14009;
var statearr_14043_14098 = state_14009__$1;
(statearr_14043_14098[(2)] = false);

(statearr_14043_14098[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (12))){
var inst_14007 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14009__$1,inst_14007);
} else {
if((state_val_14010 === (2))){
var inst_13913 = (state_14009[(8)]);
var inst_13918 = inst_13913.cljs$lang$protocol_mask$partition0$;
var inst_13919 = (inst_13918 & (64));
var inst_13920 = inst_13913.cljs$core$ISeq$;
var inst_13921 = (inst_13919) || (inst_13920);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13921)){
var statearr_14044_14099 = state_14009__$1;
(statearr_14044_14099[(1)] = (5));

} else {
var statearr_14045_14100 = state_14009__$1;
(statearr_14045_14100[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (23))){
var inst_13968 = (state_14009[(14)]);
var inst_13974 = (inst_13968 == null);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13974)){
var statearr_14046_14101 = state_14009__$1;
(statearr_14046_14101[(1)] = (26));

} else {
var statearr_14047_14102 = state_14009__$1;
(statearr_14047_14102[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (35))){
var inst_13994 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
if(cljs.core.truth_(inst_13994)){
var statearr_14048_14103 = state_14009__$1;
(statearr_14048_14103[(1)] = (36));

} else {
var statearr_14049_14104 = state_14009__$1;
(statearr_14049_14104[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (19))){
var inst_13937 = (state_14009[(7)]);
var inst_13956 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13937);
var state_14009__$1 = state_14009;
var statearr_14050_14105 = state_14009__$1;
(statearr_14050_14105[(2)] = inst_13956);

(statearr_14050_14105[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (11))){
var inst_13937 = (state_14009[(7)]);
var inst_13941 = (inst_13937 == null);
var inst_13942 = cljs.core.not.call(null,inst_13941);
var state_14009__$1 = state_14009;
if(inst_13942){
var statearr_14051_14106 = state_14009__$1;
(statearr_14051_14106[(1)] = (13));

} else {
var statearr_14052_14107 = state_14009__$1;
(statearr_14052_14107[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (9))){
var inst_13913 = (state_14009[(8)]);
var state_14009__$1 = state_14009;
var statearr_14053_14108 = state_14009__$1;
(statearr_14053_14108[(2)] = inst_13913);

(statearr_14053_14108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (5))){
var state_14009__$1 = state_14009;
var statearr_14054_14109 = state_14009__$1;
(statearr_14054_14109[(2)] = true);

(statearr_14054_14109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (14))){
var state_14009__$1 = state_14009;
var statearr_14055_14110 = state_14009__$1;
(statearr_14055_14110[(2)] = false);

(statearr_14055_14110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (26))){
var inst_13969 = (state_14009[(10)]);
var inst_13976 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13969);
var state_14009__$1 = state_14009;
var statearr_14056_14111 = state_14009__$1;
(statearr_14056_14111[(2)] = inst_13976);

(statearr_14056_14111[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (16))){
var state_14009__$1 = state_14009;
var statearr_14057_14112 = state_14009__$1;
(statearr_14057_14112[(2)] = true);

(statearr_14057_14112[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (38))){
var inst_13999 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14058_14113 = state_14009__$1;
(statearr_14058_14113[(2)] = inst_13999);

(statearr_14058_14113[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (30))){
var inst_13960 = (state_14009[(9)]);
var inst_13969 = (state_14009[(10)]);
var inst_13961 = (state_14009[(13)]);
var inst_13986 = cljs.core.empty_QMARK_.call(null,inst_13960);
var inst_13987 = inst_13961.call(null,inst_13969);
var inst_13988 = cljs.core.not.call(null,inst_13987);
var inst_13989 = (inst_13986) && (inst_13988);
var state_14009__$1 = state_14009;
var statearr_14059_14114 = state_14009__$1;
(statearr_14059_14114[(2)] = inst_13989);

(statearr_14059_14114[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (10))){
var inst_13913 = (state_14009[(8)]);
var inst_13933 = (state_14009[(2)]);
var inst_13934 = cljs.core.get.call(null,inst_13933,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13935 = cljs.core.get.call(null,inst_13933,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13936 = cljs.core.get.call(null,inst_13933,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13937 = inst_13913;
var state_14009__$1 = (function (){var statearr_14060 = state_14009;
(statearr_14060[(16)] = inst_13936);

(statearr_14060[(7)] = inst_13937);

(statearr_14060[(17)] = inst_13935);

(statearr_14060[(18)] = inst_13934);

return statearr_14060;
})();
var statearr_14061_14115 = state_14009__$1;
(statearr_14061_14115[(2)] = null);

(statearr_14061_14115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (18))){
var inst_13951 = (state_14009[(2)]);
var state_14009__$1 = state_14009;
var statearr_14062_14116 = state_14009__$1;
(statearr_14062_14116[(2)] = inst_13951);

(statearr_14062_14116[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (37))){
var state_14009__$1 = state_14009;
var statearr_14063_14117 = state_14009__$1;
(statearr_14063_14117[(2)] = null);

(statearr_14063_14117[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14010 === (8))){
var inst_13913 = (state_14009[(8)]);
var inst_13930 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13913);
var state_14009__$1 = state_14009;
var statearr_14064_14118 = state_14009__$1;
(statearr_14064_14118[(2)] = inst_13930);

(statearr_14064_14118[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14072,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12197__auto__,c__12309__auto___14072,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12198__auto__ = null;
var cljs$core$async$mix_$_state_machine__12198__auto____0 = (function (){
var statearr_14068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14068[(0)] = cljs$core$async$mix_$_state_machine__12198__auto__);

(statearr_14068[(1)] = (1));

return statearr_14068;
});
var cljs$core$async$mix_$_state_machine__12198__auto____1 = (function (state_14009){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14069){if((e14069 instanceof Object)){
var ex__12201__auto__ = e14069;
var statearr_14070_14119 = state_14009;
(statearr_14070_14119[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14009);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14120 = state_14009;
state_14009 = G__14120;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12198__auto__ = function(state_14009){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12198__auto____1.call(this,state_14009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12198__auto____0;
cljs$core$async$mix_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12198__auto____1;
return cljs$core$async$mix_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14072,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12311__auto__ = (function (){var statearr_14071 = f__12310__auto__.call(null);
(statearr_14071[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14072);

return statearr_14071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14072,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args14121 = [];
var len__7484__auto___14124 = arguments.length;
var i__7485__auto___14125 = (0);
while(true){
if((i__7485__auto___14125 < len__7484__auto___14124)){
args14121.push((arguments[i__7485__auto___14125]));

var G__14126 = (i__7485__auto___14125 + (1));
i__7485__auto___14125 = G__14126;
continue;
} else {
}
break;
}

var G__14123 = args14121.length;
switch (G__14123) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14121.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args14129 = [];
var len__7484__auto___14254 = arguments.length;
var i__7485__auto___14255 = (0);
while(true){
if((i__7485__auto___14255 < len__7484__auto___14254)){
args14129.push((arguments[i__7485__auto___14255]));

var G__14256 = (i__7485__auto___14255 + (1));
i__7485__auto___14255 = G__14256;
continue;
} else {
}
break;
}

var G__14131 = args14129.length;
switch (G__14131) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14129.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__14128_SHARP_){
if(cljs.core.truth_(p1__14128_SHARP_.call(null,topic))){
return p1__14128_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__14128_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async14132 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14132 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta14133){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta14133 = meta14133;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_14134,meta14133__$1){
var self__ = this;
var _14134__$1 = this;
return (new cljs.core.async.t_cljs$core$async14132(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta14133__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_14134){
var self__ = this;
var _14134__$1 = this;
return self__.meta14133;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta14133","meta14133",1416102609,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14132.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14132.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14132";

cljs.core.async.t_cljs$core$async14132.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14132");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async14132 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async14132(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14133){
return (new cljs.core.async.t_cljs$core$async14132(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14133));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async14132(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12309__auto___14258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14258,mults,ensure_mult,p){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14258,mults,ensure_mult,p){
return (function (state_14206){
var state_val_14207 = (state_14206[(1)]);
if((state_val_14207 === (7))){
var inst_14202 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14208_14259 = state_14206__$1;
(statearr_14208_14259[(2)] = inst_14202);

(statearr_14208_14259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (20))){
var state_14206__$1 = state_14206;
var statearr_14209_14260 = state_14206__$1;
(statearr_14209_14260[(2)] = null);

(statearr_14209_14260[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (1))){
var state_14206__$1 = state_14206;
var statearr_14210_14261 = state_14206__$1;
(statearr_14210_14261[(2)] = null);

(statearr_14210_14261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (24))){
var inst_14185 = (state_14206[(7)]);
var inst_14194 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_14185);
var state_14206__$1 = state_14206;
var statearr_14211_14262 = state_14206__$1;
(statearr_14211_14262[(2)] = inst_14194);

(statearr_14211_14262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (4))){
var inst_14137 = (state_14206[(8)]);
var inst_14137__$1 = (state_14206[(2)]);
var inst_14138 = (inst_14137__$1 == null);
var state_14206__$1 = (function (){var statearr_14212 = state_14206;
(statearr_14212[(8)] = inst_14137__$1);

return statearr_14212;
})();
if(cljs.core.truth_(inst_14138)){
var statearr_14213_14263 = state_14206__$1;
(statearr_14213_14263[(1)] = (5));

} else {
var statearr_14214_14264 = state_14206__$1;
(statearr_14214_14264[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (15))){
var inst_14179 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14215_14265 = state_14206__$1;
(statearr_14215_14265[(2)] = inst_14179);

(statearr_14215_14265[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (21))){
var inst_14199 = (state_14206[(2)]);
var state_14206__$1 = (function (){var statearr_14216 = state_14206;
(statearr_14216[(9)] = inst_14199);

return statearr_14216;
})();
var statearr_14217_14266 = state_14206__$1;
(statearr_14217_14266[(2)] = null);

(statearr_14217_14266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (13))){
var inst_14161 = (state_14206[(10)]);
var inst_14163 = cljs.core.chunked_seq_QMARK_.call(null,inst_14161);
var state_14206__$1 = state_14206;
if(inst_14163){
var statearr_14218_14267 = state_14206__$1;
(statearr_14218_14267[(1)] = (16));

} else {
var statearr_14219_14268 = state_14206__$1;
(statearr_14219_14268[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (22))){
var inst_14191 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
if(cljs.core.truth_(inst_14191)){
var statearr_14220_14269 = state_14206__$1;
(statearr_14220_14269[(1)] = (23));

} else {
var statearr_14221_14270 = state_14206__$1;
(statearr_14221_14270[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (6))){
var inst_14137 = (state_14206[(8)]);
var inst_14187 = (state_14206[(11)]);
var inst_14185 = (state_14206[(7)]);
var inst_14185__$1 = topic_fn.call(null,inst_14137);
var inst_14186 = cljs.core.deref.call(null,mults);
var inst_14187__$1 = cljs.core.get.call(null,inst_14186,inst_14185__$1);
var state_14206__$1 = (function (){var statearr_14222 = state_14206;
(statearr_14222[(11)] = inst_14187__$1);

(statearr_14222[(7)] = inst_14185__$1);

return statearr_14222;
})();
if(cljs.core.truth_(inst_14187__$1)){
var statearr_14223_14271 = state_14206__$1;
(statearr_14223_14271[(1)] = (19));

} else {
var statearr_14224_14272 = state_14206__$1;
(statearr_14224_14272[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (25))){
var inst_14196 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14225_14273 = state_14206__$1;
(statearr_14225_14273[(2)] = inst_14196);

(statearr_14225_14273[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (17))){
var inst_14161 = (state_14206[(10)]);
var inst_14170 = cljs.core.first.call(null,inst_14161);
var inst_14171 = cljs.core.async.muxch_STAR_.call(null,inst_14170);
var inst_14172 = cljs.core.async.close_BANG_.call(null,inst_14171);
var inst_14173 = cljs.core.next.call(null,inst_14161);
var inst_14147 = inst_14173;
var inst_14148 = null;
var inst_14149 = (0);
var inst_14150 = (0);
var state_14206__$1 = (function (){var statearr_14226 = state_14206;
(statearr_14226[(12)] = inst_14147);

(statearr_14226[(13)] = inst_14172);

(statearr_14226[(14)] = inst_14149);

(statearr_14226[(15)] = inst_14148);

(statearr_14226[(16)] = inst_14150);

return statearr_14226;
})();
var statearr_14227_14274 = state_14206__$1;
(statearr_14227_14274[(2)] = null);

(statearr_14227_14274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (3))){
var inst_14204 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14206__$1,inst_14204);
} else {
if((state_val_14207 === (12))){
var inst_14181 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14228_14275 = state_14206__$1;
(statearr_14228_14275[(2)] = inst_14181);

(statearr_14228_14275[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (2))){
var state_14206__$1 = state_14206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14206__$1,(4),ch);
} else {
if((state_val_14207 === (23))){
var state_14206__$1 = state_14206;
var statearr_14229_14276 = state_14206__$1;
(statearr_14229_14276[(2)] = null);

(statearr_14229_14276[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (19))){
var inst_14137 = (state_14206[(8)]);
var inst_14187 = (state_14206[(11)]);
var inst_14189 = cljs.core.async.muxch_STAR_.call(null,inst_14187);
var state_14206__$1 = state_14206;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14206__$1,(22),inst_14189,inst_14137);
} else {
if((state_val_14207 === (11))){
var inst_14161 = (state_14206[(10)]);
var inst_14147 = (state_14206[(12)]);
var inst_14161__$1 = cljs.core.seq.call(null,inst_14147);
var state_14206__$1 = (function (){var statearr_14230 = state_14206;
(statearr_14230[(10)] = inst_14161__$1);

return statearr_14230;
})();
if(inst_14161__$1){
var statearr_14231_14277 = state_14206__$1;
(statearr_14231_14277[(1)] = (13));

} else {
var statearr_14232_14278 = state_14206__$1;
(statearr_14232_14278[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (9))){
var inst_14183 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14233_14279 = state_14206__$1;
(statearr_14233_14279[(2)] = inst_14183);

(statearr_14233_14279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (5))){
var inst_14144 = cljs.core.deref.call(null,mults);
var inst_14145 = cljs.core.vals.call(null,inst_14144);
var inst_14146 = cljs.core.seq.call(null,inst_14145);
var inst_14147 = inst_14146;
var inst_14148 = null;
var inst_14149 = (0);
var inst_14150 = (0);
var state_14206__$1 = (function (){var statearr_14234 = state_14206;
(statearr_14234[(12)] = inst_14147);

(statearr_14234[(14)] = inst_14149);

(statearr_14234[(15)] = inst_14148);

(statearr_14234[(16)] = inst_14150);

return statearr_14234;
})();
var statearr_14235_14280 = state_14206__$1;
(statearr_14235_14280[(2)] = null);

(statearr_14235_14280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (14))){
var state_14206__$1 = state_14206;
var statearr_14239_14281 = state_14206__$1;
(statearr_14239_14281[(2)] = null);

(statearr_14239_14281[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (16))){
var inst_14161 = (state_14206[(10)]);
var inst_14165 = cljs.core.chunk_first.call(null,inst_14161);
var inst_14166 = cljs.core.chunk_rest.call(null,inst_14161);
var inst_14167 = cljs.core.count.call(null,inst_14165);
var inst_14147 = inst_14166;
var inst_14148 = inst_14165;
var inst_14149 = inst_14167;
var inst_14150 = (0);
var state_14206__$1 = (function (){var statearr_14240 = state_14206;
(statearr_14240[(12)] = inst_14147);

(statearr_14240[(14)] = inst_14149);

(statearr_14240[(15)] = inst_14148);

(statearr_14240[(16)] = inst_14150);

return statearr_14240;
})();
var statearr_14241_14282 = state_14206__$1;
(statearr_14241_14282[(2)] = null);

(statearr_14241_14282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (10))){
var inst_14147 = (state_14206[(12)]);
var inst_14149 = (state_14206[(14)]);
var inst_14148 = (state_14206[(15)]);
var inst_14150 = (state_14206[(16)]);
var inst_14155 = cljs.core._nth.call(null,inst_14148,inst_14150);
var inst_14156 = cljs.core.async.muxch_STAR_.call(null,inst_14155);
var inst_14157 = cljs.core.async.close_BANG_.call(null,inst_14156);
var inst_14158 = (inst_14150 + (1));
var tmp14236 = inst_14147;
var tmp14237 = inst_14149;
var tmp14238 = inst_14148;
var inst_14147__$1 = tmp14236;
var inst_14148__$1 = tmp14238;
var inst_14149__$1 = tmp14237;
var inst_14150__$1 = inst_14158;
var state_14206__$1 = (function (){var statearr_14242 = state_14206;
(statearr_14242[(12)] = inst_14147__$1);

(statearr_14242[(17)] = inst_14157);

(statearr_14242[(14)] = inst_14149__$1);

(statearr_14242[(15)] = inst_14148__$1);

(statearr_14242[(16)] = inst_14150__$1);

return statearr_14242;
})();
var statearr_14243_14283 = state_14206__$1;
(statearr_14243_14283[(2)] = null);

(statearr_14243_14283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (18))){
var inst_14176 = (state_14206[(2)]);
var state_14206__$1 = state_14206;
var statearr_14244_14284 = state_14206__$1;
(statearr_14244_14284[(2)] = inst_14176);

(statearr_14244_14284[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14207 === (8))){
var inst_14149 = (state_14206[(14)]);
var inst_14150 = (state_14206[(16)]);
var inst_14152 = (inst_14150 < inst_14149);
var inst_14153 = inst_14152;
var state_14206__$1 = state_14206;
if(cljs.core.truth_(inst_14153)){
var statearr_14245_14285 = state_14206__$1;
(statearr_14245_14285[(1)] = (10));

} else {
var statearr_14246_14286 = state_14206__$1;
(statearr_14246_14286[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14258,mults,ensure_mult,p))
;
return ((function (switch__12197__auto__,c__12309__auto___14258,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_14250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14250[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_14250[(1)] = (1));

return statearr_14250;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14206){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14251){if((e14251 instanceof Object)){
var ex__12201__auto__ = e14251;
var statearr_14252_14287 = state_14206;
(statearr_14252_14287[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14288 = state_14206;
state_14206 = G__14288;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14206){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14258,mults,ensure_mult,p))
})();
var state__12311__auto__ = (function (){var statearr_14253 = f__12310__auto__.call(null);
(statearr_14253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14258);

return statearr_14253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14258,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args14289 = [];
var len__7484__auto___14292 = arguments.length;
var i__7485__auto___14293 = (0);
while(true){
if((i__7485__auto___14293 < len__7484__auto___14292)){
args14289.push((arguments[i__7485__auto___14293]));

var G__14294 = (i__7485__auto___14293 + (1));
i__7485__auto___14293 = G__14294;
continue;
} else {
}
break;
}

var G__14291 = args14289.length;
switch (G__14291) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14289.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args14296 = [];
var len__7484__auto___14299 = arguments.length;
var i__7485__auto___14300 = (0);
while(true){
if((i__7485__auto___14300 < len__7484__auto___14299)){
args14296.push((arguments[i__7485__auto___14300]));

var G__14301 = (i__7485__auto___14300 + (1));
i__7485__auto___14300 = G__14301;
continue;
} else {
}
break;
}

var G__14298 = args14296.length;
switch (G__14298) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14296.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args14303 = [];
var len__7484__auto___14374 = arguments.length;
var i__7485__auto___14375 = (0);
while(true){
if((i__7485__auto___14375 < len__7484__auto___14374)){
args14303.push((arguments[i__7485__auto___14375]));

var G__14376 = (i__7485__auto___14375 + (1));
i__7485__auto___14375 = G__14376;
continue;
} else {
}
break;
}

var G__14305 = args14303.length;
switch (G__14305) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14303.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__12309__auto___14378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14378,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14378,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14344){
var state_val_14345 = (state_14344[(1)]);
if((state_val_14345 === (7))){
var state_14344__$1 = state_14344;
var statearr_14346_14379 = state_14344__$1;
(statearr_14346_14379[(2)] = null);

(statearr_14346_14379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (1))){
var state_14344__$1 = state_14344;
var statearr_14347_14380 = state_14344__$1;
(statearr_14347_14380[(2)] = null);

(statearr_14347_14380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (4))){
var inst_14308 = (state_14344[(7)]);
var inst_14310 = (inst_14308 < cnt);
var state_14344__$1 = state_14344;
if(cljs.core.truth_(inst_14310)){
var statearr_14348_14381 = state_14344__$1;
(statearr_14348_14381[(1)] = (6));

} else {
var statearr_14349_14382 = state_14344__$1;
(statearr_14349_14382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (15))){
var inst_14340 = (state_14344[(2)]);
var state_14344__$1 = state_14344;
var statearr_14350_14383 = state_14344__$1;
(statearr_14350_14383[(2)] = inst_14340);

(statearr_14350_14383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (13))){
var inst_14333 = cljs.core.async.close_BANG_.call(null,out);
var state_14344__$1 = state_14344;
var statearr_14351_14384 = state_14344__$1;
(statearr_14351_14384[(2)] = inst_14333);

(statearr_14351_14384[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (6))){
var state_14344__$1 = state_14344;
var statearr_14352_14385 = state_14344__$1;
(statearr_14352_14385[(2)] = null);

(statearr_14352_14385[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (3))){
var inst_14342 = (state_14344[(2)]);
var state_14344__$1 = state_14344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14344__$1,inst_14342);
} else {
if((state_val_14345 === (12))){
var inst_14330 = (state_14344[(8)]);
var inst_14330__$1 = (state_14344[(2)]);
var inst_14331 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14330__$1);
var state_14344__$1 = (function (){var statearr_14353 = state_14344;
(statearr_14353[(8)] = inst_14330__$1);

return statearr_14353;
})();
if(cljs.core.truth_(inst_14331)){
var statearr_14354_14386 = state_14344__$1;
(statearr_14354_14386[(1)] = (13));

} else {
var statearr_14355_14387 = state_14344__$1;
(statearr_14355_14387[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (2))){
var inst_14307 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14308 = (0);
var state_14344__$1 = (function (){var statearr_14356 = state_14344;
(statearr_14356[(9)] = inst_14307);

(statearr_14356[(7)] = inst_14308);

return statearr_14356;
})();
var statearr_14357_14388 = state_14344__$1;
(statearr_14357_14388[(2)] = null);

(statearr_14357_14388[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (11))){
var inst_14308 = (state_14344[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14344,(10),Object,null,(9));
var inst_14317 = chs__$1.call(null,inst_14308);
var inst_14318 = done.call(null,inst_14308);
var inst_14319 = cljs.core.async.take_BANG_.call(null,inst_14317,inst_14318);
var state_14344__$1 = state_14344;
var statearr_14358_14389 = state_14344__$1;
(statearr_14358_14389[(2)] = inst_14319);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14344__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (9))){
var inst_14308 = (state_14344[(7)]);
var inst_14321 = (state_14344[(2)]);
var inst_14322 = (inst_14308 + (1));
var inst_14308__$1 = inst_14322;
var state_14344__$1 = (function (){var statearr_14359 = state_14344;
(statearr_14359[(10)] = inst_14321);

(statearr_14359[(7)] = inst_14308__$1);

return statearr_14359;
})();
var statearr_14360_14390 = state_14344__$1;
(statearr_14360_14390[(2)] = null);

(statearr_14360_14390[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (5))){
var inst_14328 = (state_14344[(2)]);
var state_14344__$1 = (function (){var statearr_14361 = state_14344;
(statearr_14361[(11)] = inst_14328);

return statearr_14361;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14344__$1,(12),dchan);
} else {
if((state_val_14345 === (14))){
var inst_14330 = (state_14344[(8)]);
var inst_14335 = cljs.core.apply.call(null,f,inst_14330);
var state_14344__$1 = state_14344;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14344__$1,(16),out,inst_14335);
} else {
if((state_val_14345 === (16))){
var inst_14337 = (state_14344[(2)]);
var state_14344__$1 = (function (){var statearr_14362 = state_14344;
(statearr_14362[(12)] = inst_14337);

return statearr_14362;
})();
var statearr_14363_14391 = state_14344__$1;
(statearr_14363_14391[(2)] = null);

(statearr_14363_14391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (10))){
var inst_14312 = (state_14344[(2)]);
var inst_14313 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14344__$1 = (function (){var statearr_14364 = state_14344;
(statearr_14364[(13)] = inst_14312);

return statearr_14364;
})();
var statearr_14365_14392 = state_14344__$1;
(statearr_14365_14392[(2)] = inst_14313);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14344__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14345 === (8))){
var inst_14326 = (state_14344[(2)]);
var state_14344__$1 = state_14344;
var statearr_14366_14393 = state_14344__$1;
(statearr_14366_14393[(2)] = inst_14326);

(statearr_14366_14393[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14378,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12197__auto__,c__12309__auto___14378,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_14370 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14370[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_14370[(1)] = (1));

return statearr_14370;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14344){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14371){if((e14371 instanceof Object)){
var ex__12201__auto__ = e14371;
var statearr_14372_14394 = state_14344;
(statearr_14372_14394[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14371;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14395 = state_14344;
state_14344 = G__14395;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14344){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14378,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12311__auto__ = (function (){var statearr_14373 = f__12310__auto__.call(null);
(statearr_14373[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14378);

return statearr_14373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14378,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args14397 = [];
var len__7484__auto___14455 = arguments.length;
var i__7485__auto___14456 = (0);
while(true){
if((i__7485__auto___14456 < len__7484__auto___14455)){
args14397.push((arguments[i__7485__auto___14456]));

var G__14457 = (i__7485__auto___14456 + (1));
i__7485__auto___14456 = G__14457;
continue;
} else {
}
break;
}

var G__14399 = args14397.length;
switch (G__14399) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14397.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12309__auto___14459 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14459,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14459,out){
return (function (state_14431){
var state_val_14432 = (state_14431[(1)]);
if((state_val_14432 === (7))){
var inst_14410 = (state_14431[(7)]);
var inst_14411 = (state_14431[(8)]);
var inst_14410__$1 = (state_14431[(2)]);
var inst_14411__$1 = cljs.core.nth.call(null,inst_14410__$1,(0),null);
var inst_14412 = cljs.core.nth.call(null,inst_14410__$1,(1),null);
var inst_14413 = (inst_14411__$1 == null);
var state_14431__$1 = (function (){var statearr_14433 = state_14431;
(statearr_14433[(7)] = inst_14410__$1);

(statearr_14433[(9)] = inst_14412);

(statearr_14433[(8)] = inst_14411__$1);

return statearr_14433;
})();
if(cljs.core.truth_(inst_14413)){
var statearr_14434_14460 = state_14431__$1;
(statearr_14434_14460[(1)] = (8));

} else {
var statearr_14435_14461 = state_14431__$1;
(statearr_14435_14461[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (1))){
var inst_14400 = cljs.core.vec.call(null,chs);
var inst_14401 = inst_14400;
var state_14431__$1 = (function (){var statearr_14436 = state_14431;
(statearr_14436[(10)] = inst_14401);

return statearr_14436;
})();
var statearr_14437_14462 = state_14431__$1;
(statearr_14437_14462[(2)] = null);

(statearr_14437_14462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (4))){
var inst_14401 = (state_14431[(10)]);
var state_14431__$1 = state_14431;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14431__$1,(7),inst_14401);
} else {
if((state_val_14432 === (6))){
var inst_14427 = (state_14431[(2)]);
var state_14431__$1 = state_14431;
var statearr_14438_14463 = state_14431__$1;
(statearr_14438_14463[(2)] = inst_14427);

(statearr_14438_14463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (3))){
var inst_14429 = (state_14431[(2)]);
var state_14431__$1 = state_14431;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14431__$1,inst_14429);
} else {
if((state_val_14432 === (2))){
var inst_14401 = (state_14431[(10)]);
var inst_14403 = cljs.core.count.call(null,inst_14401);
var inst_14404 = (inst_14403 > (0));
var state_14431__$1 = state_14431;
if(cljs.core.truth_(inst_14404)){
var statearr_14440_14464 = state_14431__$1;
(statearr_14440_14464[(1)] = (4));

} else {
var statearr_14441_14465 = state_14431__$1;
(statearr_14441_14465[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (11))){
var inst_14401 = (state_14431[(10)]);
var inst_14420 = (state_14431[(2)]);
var tmp14439 = inst_14401;
var inst_14401__$1 = tmp14439;
var state_14431__$1 = (function (){var statearr_14442 = state_14431;
(statearr_14442[(11)] = inst_14420);

(statearr_14442[(10)] = inst_14401__$1);

return statearr_14442;
})();
var statearr_14443_14466 = state_14431__$1;
(statearr_14443_14466[(2)] = null);

(statearr_14443_14466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (9))){
var inst_14411 = (state_14431[(8)]);
var state_14431__$1 = state_14431;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14431__$1,(11),out,inst_14411);
} else {
if((state_val_14432 === (5))){
var inst_14425 = cljs.core.async.close_BANG_.call(null,out);
var state_14431__$1 = state_14431;
var statearr_14444_14467 = state_14431__$1;
(statearr_14444_14467[(2)] = inst_14425);

(statearr_14444_14467[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (10))){
var inst_14423 = (state_14431[(2)]);
var state_14431__$1 = state_14431;
var statearr_14445_14468 = state_14431__$1;
(statearr_14445_14468[(2)] = inst_14423);

(statearr_14445_14468[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14432 === (8))){
var inst_14401 = (state_14431[(10)]);
var inst_14410 = (state_14431[(7)]);
var inst_14412 = (state_14431[(9)]);
var inst_14411 = (state_14431[(8)]);
var inst_14415 = (function (){var cs = inst_14401;
var vec__14406 = inst_14410;
var v = inst_14411;
var c = inst_14412;
return ((function (cs,vec__14406,v,c,inst_14401,inst_14410,inst_14412,inst_14411,state_val_14432,c__12309__auto___14459,out){
return (function (p1__14396_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14396_SHARP_);
});
;})(cs,vec__14406,v,c,inst_14401,inst_14410,inst_14412,inst_14411,state_val_14432,c__12309__auto___14459,out))
})();
var inst_14416 = cljs.core.filterv.call(null,inst_14415,inst_14401);
var inst_14401__$1 = inst_14416;
var state_14431__$1 = (function (){var statearr_14446 = state_14431;
(statearr_14446[(10)] = inst_14401__$1);

return statearr_14446;
})();
var statearr_14447_14469 = state_14431__$1;
(statearr_14447_14469[(2)] = null);

(statearr_14447_14469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14459,out))
;
return ((function (switch__12197__auto__,c__12309__auto___14459,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_14451 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14451[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_14451[(1)] = (1));

return statearr_14451;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14431){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14452){if((e14452 instanceof Object)){
var ex__12201__auto__ = e14452;
var statearr_14453_14470 = state_14431;
(statearr_14453_14470[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14431);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14452;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14471 = state_14431;
state_14431 = G__14471;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14431){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14459,out))
})();
var state__12311__auto__ = (function (){var statearr_14454 = f__12310__auto__.call(null);
(statearr_14454[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14459);

return statearr_14454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14459,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args14472 = [];
var len__7484__auto___14521 = arguments.length;
var i__7485__auto___14522 = (0);
while(true){
if((i__7485__auto___14522 < len__7484__auto___14521)){
args14472.push((arguments[i__7485__auto___14522]));

var G__14523 = (i__7485__auto___14522 + (1));
i__7485__auto___14522 = G__14523;
continue;
} else {
}
break;
}

var G__14474 = args14472.length;
switch (G__14474) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14472.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12309__auto___14525 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14525,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14525,out){
return (function (state_14498){
var state_val_14499 = (state_14498[(1)]);
if((state_val_14499 === (7))){
var inst_14480 = (state_14498[(7)]);
var inst_14480__$1 = (state_14498[(2)]);
var inst_14481 = (inst_14480__$1 == null);
var inst_14482 = cljs.core.not.call(null,inst_14481);
var state_14498__$1 = (function (){var statearr_14500 = state_14498;
(statearr_14500[(7)] = inst_14480__$1);

return statearr_14500;
})();
if(inst_14482){
var statearr_14501_14526 = state_14498__$1;
(statearr_14501_14526[(1)] = (8));

} else {
var statearr_14502_14527 = state_14498__$1;
(statearr_14502_14527[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (1))){
var inst_14475 = (0);
var state_14498__$1 = (function (){var statearr_14503 = state_14498;
(statearr_14503[(8)] = inst_14475);

return statearr_14503;
})();
var statearr_14504_14528 = state_14498__$1;
(statearr_14504_14528[(2)] = null);

(statearr_14504_14528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (4))){
var state_14498__$1 = state_14498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14498__$1,(7),ch);
} else {
if((state_val_14499 === (6))){
var inst_14493 = (state_14498[(2)]);
var state_14498__$1 = state_14498;
var statearr_14505_14529 = state_14498__$1;
(statearr_14505_14529[(2)] = inst_14493);

(statearr_14505_14529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (3))){
var inst_14495 = (state_14498[(2)]);
var inst_14496 = cljs.core.async.close_BANG_.call(null,out);
var state_14498__$1 = (function (){var statearr_14506 = state_14498;
(statearr_14506[(9)] = inst_14495);

return statearr_14506;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14498__$1,inst_14496);
} else {
if((state_val_14499 === (2))){
var inst_14475 = (state_14498[(8)]);
var inst_14477 = (inst_14475 < n);
var state_14498__$1 = state_14498;
if(cljs.core.truth_(inst_14477)){
var statearr_14507_14530 = state_14498__$1;
(statearr_14507_14530[(1)] = (4));

} else {
var statearr_14508_14531 = state_14498__$1;
(statearr_14508_14531[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (11))){
var inst_14475 = (state_14498[(8)]);
var inst_14485 = (state_14498[(2)]);
var inst_14486 = (inst_14475 + (1));
var inst_14475__$1 = inst_14486;
var state_14498__$1 = (function (){var statearr_14509 = state_14498;
(statearr_14509[(8)] = inst_14475__$1);

(statearr_14509[(10)] = inst_14485);

return statearr_14509;
})();
var statearr_14510_14532 = state_14498__$1;
(statearr_14510_14532[(2)] = null);

(statearr_14510_14532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (9))){
var state_14498__$1 = state_14498;
var statearr_14511_14533 = state_14498__$1;
(statearr_14511_14533[(2)] = null);

(statearr_14511_14533[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (5))){
var state_14498__$1 = state_14498;
var statearr_14512_14534 = state_14498__$1;
(statearr_14512_14534[(2)] = null);

(statearr_14512_14534[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (10))){
var inst_14490 = (state_14498[(2)]);
var state_14498__$1 = state_14498;
var statearr_14513_14535 = state_14498__$1;
(statearr_14513_14535[(2)] = inst_14490);

(statearr_14513_14535[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14499 === (8))){
var inst_14480 = (state_14498[(7)]);
var state_14498__$1 = state_14498;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14498__$1,(11),out,inst_14480);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14525,out))
;
return ((function (switch__12197__auto__,c__12309__auto___14525,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_14517 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14517[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_14517[(1)] = (1));

return statearr_14517;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14498){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14518){if((e14518 instanceof Object)){
var ex__12201__auto__ = e14518;
var statearr_14519_14536 = state_14498;
(statearr_14519_14536[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14498);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14518;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14537 = state_14498;
state_14498 = G__14537;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14498){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14525,out))
})();
var state__12311__auto__ = (function (){var statearr_14520 = f__12310__auto__.call(null);
(statearr_14520[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14525);

return statearr_14520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14525,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14545 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14545 = (function (map_LT_,f,ch,meta14546){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14546 = meta14546;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14547,meta14546__$1){
var self__ = this;
var _14547__$1 = this;
return (new cljs.core.async.t_cljs$core$async14545(self__.map_LT_,self__.f,self__.ch,meta14546__$1));
});

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14547){
var self__ = this;
var _14547__$1 = this;
return self__.meta14546;
});

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14548 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14548 = (function (map_LT_,f,ch,meta14546,_,fn1,meta14549){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14546 = meta14546;
this._ = _;
this.fn1 = fn1;
this.meta14549 = meta14549;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14548.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14550,meta14549__$1){
var self__ = this;
var _14550__$1 = this;
return (new cljs.core.async.t_cljs$core$async14548(self__.map_LT_,self__.f,self__.ch,self__.meta14546,self__._,self__.fn1,meta14549__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14548.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14550){
var self__ = this;
var _14550__$1 = this;
return self__.meta14549;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14548.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14548.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14548.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14548.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14538_SHARP_){
return f1.call(null,(((p1__14538_SHARP_ == null))?null:self__.f.call(null,p1__14538_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14548.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14546","meta14546",-1742636322,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14545","cljs.core.async/t_cljs$core$async14545",130578215,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14549","meta14549",299967132,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14548.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14548.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14548";

cljs.core.async.t_cljs$core$async14548.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14548");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14548 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14548(map_LT___$1,f__$1,ch__$1,meta14546__$1,___$2,fn1__$1,meta14549){
return (new cljs.core.async.t_cljs$core$async14548(map_LT___$1,f__$1,ch__$1,meta14546__$1,___$2,fn1__$1,meta14549));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14548(self__.map_LT_,self__.f,self__.ch,self__.meta14546,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14545.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14545.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14546","meta14546",-1742636322,null)], null);
});

cljs.core.async.t_cljs$core$async14545.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14545.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14545";

cljs.core.async.t_cljs$core$async14545.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14545");
});

cljs.core.async.__GT_t_cljs$core$async14545 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14545(map_LT___$1,f__$1,ch__$1,meta14546){
return (new cljs.core.async.t_cljs$core$async14545(map_LT___$1,f__$1,ch__$1,meta14546));
});

}

return (new cljs.core.async.t_cljs$core$async14545(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14554 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14554 = (function (map_GT_,f,ch,meta14555){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta14555 = meta14555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14556,meta14555__$1){
var self__ = this;
var _14556__$1 = this;
return (new cljs.core.async.t_cljs$core$async14554(self__.map_GT_,self__.f,self__.ch,meta14555__$1));
});

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14556){
var self__ = this;
var _14556__$1 = this;
return self__.meta14555;
});

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14554.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14554.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14555","meta14555",-1179902739,null)], null);
});

cljs.core.async.t_cljs$core$async14554.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14554";

cljs.core.async.t_cljs$core$async14554.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14554");
});

cljs.core.async.__GT_t_cljs$core$async14554 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14554(map_GT___$1,f__$1,ch__$1,meta14555){
return (new cljs.core.async.t_cljs$core$async14554(map_GT___$1,f__$1,ch__$1,meta14555));
});

}

return (new cljs.core.async.t_cljs$core$async14554(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14560 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14560 = (function (filter_GT_,p,ch,meta14561){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta14561 = meta14561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14562,meta14561__$1){
var self__ = this;
var _14562__$1 = this;
return (new cljs.core.async.t_cljs$core$async14560(self__.filter_GT_,self__.p,self__.ch,meta14561__$1));
});

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14562){
var self__ = this;
var _14562__$1 = this;
return self__.meta14561;
});

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14560.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14561","meta14561",-537907070,null)], null);
});

cljs.core.async.t_cljs$core$async14560.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14560.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14560";

cljs.core.async.t_cljs$core$async14560.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14560");
});

cljs.core.async.__GT_t_cljs$core$async14560 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14560(filter_GT___$1,p__$1,ch__$1,meta14561){
return (new cljs.core.async.t_cljs$core$async14560(filter_GT___$1,p__$1,ch__$1,meta14561));
});

}

return (new cljs.core.async.t_cljs$core$async14560(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14563 = [];
var len__7484__auto___14607 = arguments.length;
var i__7485__auto___14608 = (0);
while(true){
if((i__7485__auto___14608 < len__7484__auto___14607)){
args14563.push((arguments[i__7485__auto___14608]));

var G__14609 = (i__7485__auto___14608 + (1));
i__7485__auto___14608 = G__14609;
continue;
} else {
}
break;
}

var G__14565 = args14563.length;
switch (G__14565) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14563.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12309__auto___14611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14611,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14611,out){
return (function (state_14586){
var state_val_14587 = (state_14586[(1)]);
if((state_val_14587 === (7))){
var inst_14582 = (state_14586[(2)]);
var state_14586__$1 = state_14586;
var statearr_14588_14612 = state_14586__$1;
(statearr_14588_14612[(2)] = inst_14582);

(statearr_14588_14612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (1))){
var state_14586__$1 = state_14586;
var statearr_14589_14613 = state_14586__$1;
(statearr_14589_14613[(2)] = null);

(statearr_14589_14613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (4))){
var inst_14568 = (state_14586[(7)]);
var inst_14568__$1 = (state_14586[(2)]);
var inst_14569 = (inst_14568__$1 == null);
var state_14586__$1 = (function (){var statearr_14590 = state_14586;
(statearr_14590[(7)] = inst_14568__$1);

return statearr_14590;
})();
if(cljs.core.truth_(inst_14569)){
var statearr_14591_14614 = state_14586__$1;
(statearr_14591_14614[(1)] = (5));

} else {
var statearr_14592_14615 = state_14586__$1;
(statearr_14592_14615[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (6))){
var inst_14568 = (state_14586[(7)]);
var inst_14573 = p.call(null,inst_14568);
var state_14586__$1 = state_14586;
if(cljs.core.truth_(inst_14573)){
var statearr_14593_14616 = state_14586__$1;
(statearr_14593_14616[(1)] = (8));

} else {
var statearr_14594_14617 = state_14586__$1;
(statearr_14594_14617[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (3))){
var inst_14584 = (state_14586[(2)]);
var state_14586__$1 = state_14586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14586__$1,inst_14584);
} else {
if((state_val_14587 === (2))){
var state_14586__$1 = state_14586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14586__$1,(4),ch);
} else {
if((state_val_14587 === (11))){
var inst_14576 = (state_14586[(2)]);
var state_14586__$1 = state_14586;
var statearr_14595_14618 = state_14586__$1;
(statearr_14595_14618[(2)] = inst_14576);

(statearr_14595_14618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (9))){
var state_14586__$1 = state_14586;
var statearr_14596_14619 = state_14586__$1;
(statearr_14596_14619[(2)] = null);

(statearr_14596_14619[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (5))){
var inst_14571 = cljs.core.async.close_BANG_.call(null,out);
var state_14586__$1 = state_14586;
var statearr_14597_14620 = state_14586__$1;
(statearr_14597_14620[(2)] = inst_14571);

(statearr_14597_14620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (10))){
var inst_14579 = (state_14586[(2)]);
var state_14586__$1 = (function (){var statearr_14598 = state_14586;
(statearr_14598[(8)] = inst_14579);

return statearr_14598;
})();
var statearr_14599_14621 = state_14586__$1;
(statearr_14599_14621[(2)] = null);

(statearr_14599_14621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14587 === (8))){
var inst_14568 = (state_14586[(7)]);
var state_14586__$1 = state_14586;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14586__$1,(11),out,inst_14568);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14611,out))
;
return ((function (switch__12197__auto__,c__12309__auto___14611,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_14603 = [null,null,null,null,null,null,null,null,null];
(statearr_14603[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_14603[(1)] = (1));

return statearr_14603;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14586){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14604){if((e14604 instanceof Object)){
var ex__12201__auto__ = e14604;
var statearr_14605_14622 = state_14586;
(statearr_14605_14622[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14604;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14623 = state_14586;
state_14586 = G__14623;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14611,out))
})();
var state__12311__auto__ = (function (){var statearr_14606 = f__12310__auto__.call(null);
(statearr_14606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14611);

return statearr_14606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14611,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14624 = [];
var len__7484__auto___14627 = arguments.length;
var i__7485__auto___14628 = (0);
while(true){
if((i__7485__auto___14628 < len__7484__auto___14627)){
args14624.push((arguments[i__7485__auto___14628]));

var G__14629 = (i__7485__auto___14628 + (1));
i__7485__auto___14628 = G__14629;
continue;
} else {
}
break;
}

var G__14626 = args14624.length;
switch (G__14626) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14624.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_14796){
var state_val_14797 = (state_14796[(1)]);
if((state_val_14797 === (7))){
var inst_14792 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14798_14839 = state_14796__$1;
(statearr_14798_14839[(2)] = inst_14792);

(statearr_14798_14839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (20))){
var inst_14762 = (state_14796[(7)]);
var inst_14773 = (state_14796[(2)]);
var inst_14774 = cljs.core.next.call(null,inst_14762);
var inst_14748 = inst_14774;
var inst_14749 = null;
var inst_14750 = (0);
var inst_14751 = (0);
var state_14796__$1 = (function (){var statearr_14799 = state_14796;
(statearr_14799[(8)] = inst_14750);

(statearr_14799[(9)] = inst_14749);

(statearr_14799[(10)] = inst_14751);

(statearr_14799[(11)] = inst_14748);

(statearr_14799[(12)] = inst_14773);

return statearr_14799;
})();
var statearr_14800_14840 = state_14796__$1;
(statearr_14800_14840[(2)] = null);

(statearr_14800_14840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (1))){
var state_14796__$1 = state_14796;
var statearr_14801_14841 = state_14796__$1;
(statearr_14801_14841[(2)] = null);

(statearr_14801_14841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (4))){
var inst_14737 = (state_14796[(13)]);
var inst_14737__$1 = (state_14796[(2)]);
var inst_14738 = (inst_14737__$1 == null);
var state_14796__$1 = (function (){var statearr_14802 = state_14796;
(statearr_14802[(13)] = inst_14737__$1);

return statearr_14802;
})();
if(cljs.core.truth_(inst_14738)){
var statearr_14803_14842 = state_14796__$1;
(statearr_14803_14842[(1)] = (5));

} else {
var statearr_14804_14843 = state_14796__$1;
(statearr_14804_14843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (15))){
var state_14796__$1 = state_14796;
var statearr_14808_14844 = state_14796__$1;
(statearr_14808_14844[(2)] = null);

(statearr_14808_14844[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (21))){
var state_14796__$1 = state_14796;
var statearr_14809_14845 = state_14796__$1;
(statearr_14809_14845[(2)] = null);

(statearr_14809_14845[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (13))){
var inst_14750 = (state_14796[(8)]);
var inst_14749 = (state_14796[(9)]);
var inst_14751 = (state_14796[(10)]);
var inst_14748 = (state_14796[(11)]);
var inst_14758 = (state_14796[(2)]);
var inst_14759 = (inst_14751 + (1));
var tmp14805 = inst_14750;
var tmp14806 = inst_14749;
var tmp14807 = inst_14748;
var inst_14748__$1 = tmp14807;
var inst_14749__$1 = tmp14806;
var inst_14750__$1 = tmp14805;
var inst_14751__$1 = inst_14759;
var state_14796__$1 = (function (){var statearr_14810 = state_14796;
(statearr_14810[(8)] = inst_14750__$1);

(statearr_14810[(9)] = inst_14749__$1);

(statearr_14810[(10)] = inst_14751__$1);

(statearr_14810[(14)] = inst_14758);

(statearr_14810[(11)] = inst_14748__$1);

return statearr_14810;
})();
var statearr_14811_14846 = state_14796__$1;
(statearr_14811_14846[(2)] = null);

(statearr_14811_14846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (22))){
var state_14796__$1 = state_14796;
var statearr_14812_14847 = state_14796__$1;
(statearr_14812_14847[(2)] = null);

(statearr_14812_14847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (6))){
var inst_14737 = (state_14796[(13)]);
var inst_14746 = f.call(null,inst_14737);
var inst_14747 = cljs.core.seq.call(null,inst_14746);
var inst_14748 = inst_14747;
var inst_14749 = null;
var inst_14750 = (0);
var inst_14751 = (0);
var state_14796__$1 = (function (){var statearr_14813 = state_14796;
(statearr_14813[(8)] = inst_14750);

(statearr_14813[(9)] = inst_14749);

(statearr_14813[(10)] = inst_14751);

(statearr_14813[(11)] = inst_14748);

return statearr_14813;
})();
var statearr_14814_14848 = state_14796__$1;
(statearr_14814_14848[(2)] = null);

(statearr_14814_14848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (17))){
var inst_14762 = (state_14796[(7)]);
var inst_14766 = cljs.core.chunk_first.call(null,inst_14762);
var inst_14767 = cljs.core.chunk_rest.call(null,inst_14762);
var inst_14768 = cljs.core.count.call(null,inst_14766);
var inst_14748 = inst_14767;
var inst_14749 = inst_14766;
var inst_14750 = inst_14768;
var inst_14751 = (0);
var state_14796__$1 = (function (){var statearr_14815 = state_14796;
(statearr_14815[(8)] = inst_14750);

(statearr_14815[(9)] = inst_14749);

(statearr_14815[(10)] = inst_14751);

(statearr_14815[(11)] = inst_14748);

return statearr_14815;
})();
var statearr_14816_14849 = state_14796__$1;
(statearr_14816_14849[(2)] = null);

(statearr_14816_14849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (3))){
var inst_14794 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14796__$1,inst_14794);
} else {
if((state_val_14797 === (12))){
var inst_14782 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14817_14850 = state_14796__$1;
(statearr_14817_14850[(2)] = inst_14782);

(statearr_14817_14850[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (2))){
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14796__$1,(4),in$);
} else {
if((state_val_14797 === (23))){
var inst_14790 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14818_14851 = state_14796__$1;
(statearr_14818_14851[(2)] = inst_14790);

(statearr_14818_14851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (19))){
var inst_14777 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14819_14852 = state_14796__$1;
(statearr_14819_14852[(2)] = inst_14777);

(statearr_14819_14852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (11))){
var inst_14762 = (state_14796[(7)]);
var inst_14748 = (state_14796[(11)]);
var inst_14762__$1 = cljs.core.seq.call(null,inst_14748);
var state_14796__$1 = (function (){var statearr_14820 = state_14796;
(statearr_14820[(7)] = inst_14762__$1);

return statearr_14820;
})();
if(inst_14762__$1){
var statearr_14821_14853 = state_14796__$1;
(statearr_14821_14853[(1)] = (14));

} else {
var statearr_14822_14854 = state_14796__$1;
(statearr_14822_14854[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (9))){
var inst_14784 = (state_14796[(2)]);
var inst_14785 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14796__$1 = (function (){var statearr_14823 = state_14796;
(statearr_14823[(15)] = inst_14784);

return statearr_14823;
})();
if(cljs.core.truth_(inst_14785)){
var statearr_14824_14855 = state_14796__$1;
(statearr_14824_14855[(1)] = (21));

} else {
var statearr_14825_14856 = state_14796__$1;
(statearr_14825_14856[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (5))){
var inst_14740 = cljs.core.async.close_BANG_.call(null,out);
var state_14796__$1 = state_14796;
var statearr_14826_14857 = state_14796__$1;
(statearr_14826_14857[(2)] = inst_14740);

(statearr_14826_14857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (14))){
var inst_14762 = (state_14796[(7)]);
var inst_14764 = cljs.core.chunked_seq_QMARK_.call(null,inst_14762);
var state_14796__$1 = state_14796;
if(inst_14764){
var statearr_14827_14858 = state_14796__$1;
(statearr_14827_14858[(1)] = (17));

} else {
var statearr_14828_14859 = state_14796__$1;
(statearr_14828_14859[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (16))){
var inst_14780 = (state_14796[(2)]);
var state_14796__$1 = state_14796;
var statearr_14829_14860 = state_14796__$1;
(statearr_14829_14860[(2)] = inst_14780);

(statearr_14829_14860[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14797 === (10))){
var inst_14749 = (state_14796[(9)]);
var inst_14751 = (state_14796[(10)]);
var inst_14756 = cljs.core._nth.call(null,inst_14749,inst_14751);
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14796__$1,(13),out,inst_14756);
} else {
if((state_val_14797 === (18))){
var inst_14762 = (state_14796[(7)]);
var inst_14771 = cljs.core.first.call(null,inst_14762);
var state_14796__$1 = state_14796;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14796__$1,(20),out,inst_14771);
} else {
if((state_val_14797 === (8))){
var inst_14750 = (state_14796[(8)]);
var inst_14751 = (state_14796[(10)]);
var inst_14753 = (inst_14751 < inst_14750);
var inst_14754 = inst_14753;
var state_14796__$1 = state_14796;
if(cljs.core.truth_(inst_14754)){
var statearr_14830_14861 = state_14796__$1;
(statearr_14830_14861[(1)] = (10));

} else {
var statearr_14831_14862 = state_14796__$1;
(statearr_14831_14862[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0 = (function (){
var statearr_14835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14835[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__);

(statearr_14835[(1)] = (1));

return statearr_14835;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1 = (function (state_14796){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14796);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14836){if((e14836 instanceof Object)){
var ex__12201__auto__ = e14836;
var statearr_14837_14863 = state_14796;
(statearr_14837_14863[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14796);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14836;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14864 = state_14796;
state_14796 = G__14864;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__ = function(state_14796){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1.call(this,state_14796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12198__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_14838 = f__12310__auto__.call(null);
(statearr_14838[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_14838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14865 = [];
var len__7484__auto___14868 = arguments.length;
var i__7485__auto___14869 = (0);
while(true){
if((i__7485__auto___14869 < len__7484__auto___14868)){
args14865.push((arguments[i__7485__auto___14869]));

var G__14870 = (i__7485__auto___14869 + (1));
i__7485__auto___14869 = G__14870;
continue;
} else {
}
break;
}

var G__14867 = args14865.length;
switch (G__14867) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14865.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14872 = [];
var len__7484__auto___14875 = arguments.length;
var i__7485__auto___14876 = (0);
while(true){
if((i__7485__auto___14876 < len__7484__auto___14875)){
args14872.push((arguments[i__7485__auto___14876]));

var G__14877 = (i__7485__auto___14876 + (1));
i__7485__auto___14876 = G__14877;
continue;
} else {
}
break;
}

var G__14874 = args14872.length;
switch (G__14874) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14872.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14879 = [];
var len__7484__auto___14930 = arguments.length;
var i__7485__auto___14931 = (0);
while(true){
if((i__7485__auto___14931 < len__7484__auto___14930)){
args14879.push((arguments[i__7485__auto___14931]));

var G__14932 = (i__7485__auto___14931 + (1));
i__7485__auto___14931 = G__14932;
continue;
} else {
}
break;
}

var G__14881 = args14879.length;
switch (G__14881) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14879.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12309__auto___14934 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___14934,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___14934,out){
return (function (state_14905){
var state_val_14906 = (state_14905[(1)]);
if((state_val_14906 === (7))){
var inst_14900 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14907_14935 = state_14905__$1;
(statearr_14907_14935[(2)] = inst_14900);

(statearr_14907_14935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (1))){
var inst_14882 = null;
var state_14905__$1 = (function (){var statearr_14908 = state_14905;
(statearr_14908[(7)] = inst_14882);

return statearr_14908;
})();
var statearr_14909_14936 = state_14905__$1;
(statearr_14909_14936[(2)] = null);

(statearr_14909_14936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (4))){
var inst_14885 = (state_14905[(8)]);
var inst_14885__$1 = (state_14905[(2)]);
var inst_14886 = (inst_14885__$1 == null);
var inst_14887 = cljs.core.not.call(null,inst_14886);
var state_14905__$1 = (function (){var statearr_14910 = state_14905;
(statearr_14910[(8)] = inst_14885__$1);

return statearr_14910;
})();
if(inst_14887){
var statearr_14911_14937 = state_14905__$1;
(statearr_14911_14937[(1)] = (5));

} else {
var statearr_14912_14938 = state_14905__$1;
(statearr_14912_14938[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (6))){
var state_14905__$1 = state_14905;
var statearr_14913_14939 = state_14905__$1;
(statearr_14913_14939[(2)] = null);

(statearr_14913_14939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (3))){
var inst_14902 = (state_14905[(2)]);
var inst_14903 = cljs.core.async.close_BANG_.call(null,out);
var state_14905__$1 = (function (){var statearr_14914 = state_14905;
(statearr_14914[(9)] = inst_14902);

return statearr_14914;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14905__$1,inst_14903);
} else {
if((state_val_14906 === (2))){
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14905__$1,(4),ch);
} else {
if((state_val_14906 === (11))){
var inst_14885 = (state_14905[(8)]);
var inst_14894 = (state_14905[(2)]);
var inst_14882 = inst_14885;
var state_14905__$1 = (function (){var statearr_14915 = state_14905;
(statearr_14915[(7)] = inst_14882);

(statearr_14915[(10)] = inst_14894);

return statearr_14915;
})();
var statearr_14916_14940 = state_14905__$1;
(statearr_14916_14940[(2)] = null);

(statearr_14916_14940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (9))){
var inst_14885 = (state_14905[(8)]);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14905__$1,(11),out,inst_14885);
} else {
if((state_val_14906 === (5))){
var inst_14882 = (state_14905[(7)]);
var inst_14885 = (state_14905[(8)]);
var inst_14889 = cljs.core._EQ_.call(null,inst_14885,inst_14882);
var state_14905__$1 = state_14905;
if(inst_14889){
var statearr_14918_14941 = state_14905__$1;
(statearr_14918_14941[(1)] = (8));

} else {
var statearr_14919_14942 = state_14905__$1;
(statearr_14919_14942[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (10))){
var inst_14897 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14920_14943 = state_14905__$1;
(statearr_14920_14943[(2)] = inst_14897);

(statearr_14920_14943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (8))){
var inst_14882 = (state_14905[(7)]);
var tmp14917 = inst_14882;
var inst_14882__$1 = tmp14917;
var state_14905__$1 = (function (){var statearr_14921 = state_14905;
(statearr_14921[(7)] = inst_14882__$1);

return statearr_14921;
})();
var statearr_14922_14944 = state_14905__$1;
(statearr_14922_14944[(2)] = null);

(statearr_14922_14944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___14934,out))
;
return ((function (switch__12197__auto__,c__12309__auto___14934,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_14926 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14926[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_14926[(1)] = (1));

return statearr_14926;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14905){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e14927){if((e14927 instanceof Object)){
var ex__12201__auto__ = e14927;
var statearr_14928_14945 = state_14905;
(statearr_14928_14945[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14946 = state_14905;
state_14905 = G__14946;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14905){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___14934,out))
})();
var state__12311__auto__ = (function (){var statearr_14929 = f__12310__auto__.call(null);
(statearr_14929[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___14934);

return statearr_14929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___14934,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14947 = [];
var len__7484__auto___15017 = arguments.length;
var i__7485__auto___15018 = (0);
while(true){
if((i__7485__auto___15018 < len__7484__auto___15017)){
args14947.push((arguments[i__7485__auto___15018]));

var G__15019 = (i__7485__auto___15018 + (1));
i__7485__auto___15018 = G__15019;
continue;
} else {
}
break;
}

var G__14949 = args14947.length;
switch (G__14949) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14947.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12309__auto___15021 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___15021,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___15021,out){
return (function (state_14987){
var state_val_14988 = (state_14987[(1)]);
if((state_val_14988 === (7))){
var inst_14983 = (state_14987[(2)]);
var state_14987__$1 = state_14987;
var statearr_14989_15022 = state_14987__$1;
(statearr_14989_15022[(2)] = inst_14983);

(statearr_14989_15022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (1))){
var inst_14950 = (new Array(n));
var inst_14951 = inst_14950;
var inst_14952 = (0);
var state_14987__$1 = (function (){var statearr_14990 = state_14987;
(statearr_14990[(7)] = inst_14951);

(statearr_14990[(8)] = inst_14952);

return statearr_14990;
})();
var statearr_14991_15023 = state_14987__$1;
(statearr_14991_15023[(2)] = null);

(statearr_14991_15023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (4))){
var inst_14955 = (state_14987[(9)]);
var inst_14955__$1 = (state_14987[(2)]);
var inst_14956 = (inst_14955__$1 == null);
var inst_14957 = cljs.core.not.call(null,inst_14956);
var state_14987__$1 = (function (){var statearr_14992 = state_14987;
(statearr_14992[(9)] = inst_14955__$1);

return statearr_14992;
})();
if(inst_14957){
var statearr_14993_15024 = state_14987__$1;
(statearr_14993_15024[(1)] = (5));

} else {
var statearr_14994_15025 = state_14987__$1;
(statearr_14994_15025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (15))){
var inst_14977 = (state_14987[(2)]);
var state_14987__$1 = state_14987;
var statearr_14995_15026 = state_14987__$1;
(statearr_14995_15026[(2)] = inst_14977);

(statearr_14995_15026[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (13))){
var state_14987__$1 = state_14987;
var statearr_14996_15027 = state_14987__$1;
(statearr_14996_15027[(2)] = null);

(statearr_14996_15027[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (6))){
var inst_14952 = (state_14987[(8)]);
var inst_14973 = (inst_14952 > (0));
var state_14987__$1 = state_14987;
if(cljs.core.truth_(inst_14973)){
var statearr_14997_15028 = state_14987__$1;
(statearr_14997_15028[(1)] = (12));

} else {
var statearr_14998_15029 = state_14987__$1;
(statearr_14998_15029[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (3))){
var inst_14985 = (state_14987[(2)]);
var state_14987__$1 = state_14987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14987__$1,inst_14985);
} else {
if((state_val_14988 === (12))){
var inst_14951 = (state_14987[(7)]);
var inst_14975 = cljs.core.vec.call(null,inst_14951);
var state_14987__$1 = state_14987;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14987__$1,(15),out,inst_14975);
} else {
if((state_val_14988 === (2))){
var state_14987__$1 = state_14987;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14987__$1,(4),ch);
} else {
if((state_val_14988 === (11))){
var inst_14967 = (state_14987[(2)]);
var inst_14968 = (new Array(n));
var inst_14951 = inst_14968;
var inst_14952 = (0);
var state_14987__$1 = (function (){var statearr_14999 = state_14987;
(statearr_14999[(7)] = inst_14951);

(statearr_14999[(10)] = inst_14967);

(statearr_14999[(8)] = inst_14952);

return statearr_14999;
})();
var statearr_15000_15030 = state_14987__$1;
(statearr_15000_15030[(2)] = null);

(statearr_15000_15030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (9))){
var inst_14951 = (state_14987[(7)]);
var inst_14965 = cljs.core.vec.call(null,inst_14951);
var state_14987__$1 = state_14987;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14987__$1,(11),out,inst_14965);
} else {
if((state_val_14988 === (5))){
var inst_14951 = (state_14987[(7)]);
var inst_14955 = (state_14987[(9)]);
var inst_14960 = (state_14987[(11)]);
var inst_14952 = (state_14987[(8)]);
var inst_14959 = (inst_14951[inst_14952] = inst_14955);
var inst_14960__$1 = (inst_14952 + (1));
var inst_14961 = (inst_14960__$1 < n);
var state_14987__$1 = (function (){var statearr_15001 = state_14987;
(statearr_15001[(11)] = inst_14960__$1);

(statearr_15001[(12)] = inst_14959);

return statearr_15001;
})();
if(cljs.core.truth_(inst_14961)){
var statearr_15002_15031 = state_14987__$1;
(statearr_15002_15031[(1)] = (8));

} else {
var statearr_15003_15032 = state_14987__$1;
(statearr_15003_15032[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (14))){
var inst_14980 = (state_14987[(2)]);
var inst_14981 = cljs.core.async.close_BANG_.call(null,out);
var state_14987__$1 = (function (){var statearr_15005 = state_14987;
(statearr_15005[(13)] = inst_14980);

return statearr_15005;
})();
var statearr_15006_15033 = state_14987__$1;
(statearr_15006_15033[(2)] = inst_14981);

(statearr_15006_15033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (10))){
var inst_14971 = (state_14987[(2)]);
var state_14987__$1 = state_14987;
var statearr_15007_15034 = state_14987__$1;
(statearr_15007_15034[(2)] = inst_14971);

(statearr_15007_15034[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14988 === (8))){
var inst_14951 = (state_14987[(7)]);
var inst_14960 = (state_14987[(11)]);
var tmp15004 = inst_14951;
var inst_14951__$1 = tmp15004;
var inst_14952 = inst_14960;
var state_14987__$1 = (function (){var statearr_15008 = state_14987;
(statearr_15008[(7)] = inst_14951__$1);

(statearr_15008[(8)] = inst_14952);

return statearr_15008;
})();
var statearr_15009_15035 = state_14987__$1;
(statearr_15009_15035[(2)] = null);

(statearr_15009_15035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___15021,out))
;
return ((function (switch__12197__auto__,c__12309__auto___15021,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_15013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15013[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_15013[(1)] = (1));

return statearr_15013;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_14987){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_14987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e15014){if((e15014 instanceof Object)){
var ex__12201__auto__ = e15014;
var statearr_15015_15036 = state_14987;
(statearr_15015_15036[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14987);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15037 = state_14987;
state_14987 = G__15037;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_14987){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_14987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___15021,out))
})();
var state__12311__auto__ = (function (){var statearr_15016 = f__12310__auto__.call(null);
(statearr_15016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___15021);

return statearr_15016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___15021,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args15038 = [];
var len__7484__auto___15112 = arguments.length;
var i__7485__auto___15113 = (0);
while(true){
if((i__7485__auto___15113 < len__7484__auto___15112)){
args15038.push((arguments[i__7485__auto___15113]));

var G__15114 = (i__7485__auto___15113 + (1));
i__7485__auto___15113 = G__15114;
continue;
} else {
}
break;
}

var G__15040 = args15038.length;
switch (G__15040) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15038.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12309__auto___15116 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto___15116,out){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto___15116,out){
return (function (state_15082){
var state_val_15083 = (state_15082[(1)]);
if((state_val_15083 === (7))){
var inst_15078 = (state_15082[(2)]);
var state_15082__$1 = state_15082;
var statearr_15084_15117 = state_15082__$1;
(statearr_15084_15117[(2)] = inst_15078);

(statearr_15084_15117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (1))){
var inst_15041 = [];
var inst_15042 = inst_15041;
var inst_15043 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15082__$1 = (function (){var statearr_15085 = state_15082;
(statearr_15085[(7)] = inst_15042);

(statearr_15085[(8)] = inst_15043);

return statearr_15085;
})();
var statearr_15086_15118 = state_15082__$1;
(statearr_15086_15118[(2)] = null);

(statearr_15086_15118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (4))){
var inst_15046 = (state_15082[(9)]);
var inst_15046__$1 = (state_15082[(2)]);
var inst_15047 = (inst_15046__$1 == null);
var inst_15048 = cljs.core.not.call(null,inst_15047);
var state_15082__$1 = (function (){var statearr_15087 = state_15082;
(statearr_15087[(9)] = inst_15046__$1);

return statearr_15087;
})();
if(inst_15048){
var statearr_15088_15119 = state_15082__$1;
(statearr_15088_15119[(1)] = (5));

} else {
var statearr_15089_15120 = state_15082__$1;
(statearr_15089_15120[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (15))){
var inst_15072 = (state_15082[(2)]);
var state_15082__$1 = state_15082;
var statearr_15090_15121 = state_15082__$1;
(statearr_15090_15121[(2)] = inst_15072);

(statearr_15090_15121[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (13))){
var state_15082__$1 = state_15082;
var statearr_15091_15122 = state_15082__$1;
(statearr_15091_15122[(2)] = null);

(statearr_15091_15122[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (6))){
var inst_15042 = (state_15082[(7)]);
var inst_15067 = inst_15042.length;
var inst_15068 = (inst_15067 > (0));
var state_15082__$1 = state_15082;
if(cljs.core.truth_(inst_15068)){
var statearr_15092_15123 = state_15082__$1;
(statearr_15092_15123[(1)] = (12));

} else {
var statearr_15093_15124 = state_15082__$1;
(statearr_15093_15124[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (3))){
var inst_15080 = (state_15082[(2)]);
var state_15082__$1 = state_15082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15082__$1,inst_15080);
} else {
if((state_val_15083 === (12))){
var inst_15042 = (state_15082[(7)]);
var inst_15070 = cljs.core.vec.call(null,inst_15042);
var state_15082__$1 = state_15082;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15082__$1,(15),out,inst_15070);
} else {
if((state_val_15083 === (2))){
var state_15082__$1 = state_15082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15082__$1,(4),ch);
} else {
if((state_val_15083 === (11))){
var inst_15046 = (state_15082[(9)]);
var inst_15050 = (state_15082[(10)]);
var inst_15060 = (state_15082[(2)]);
var inst_15061 = [];
var inst_15062 = inst_15061.push(inst_15046);
var inst_15042 = inst_15061;
var inst_15043 = inst_15050;
var state_15082__$1 = (function (){var statearr_15094 = state_15082;
(statearr_15094[(11)] = inst_15060);

(statearr_15094[(7)] = inst_15042);

(statearr_15094[(12)] = inst_15062);

(statearr_15094[(8)] = inst_15043);

return statearr_15094;
})();
var statearr_15095_15125 = state_15082__$1;
(statearr_15095_15125[(2)] = null);

(statearr_15095_15125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (9))){
var inst_15042 = (state_15082[(7)]);
var inst_15058 = cljs.core.vec.call(null,inst_15042);
var state_15082__$1 = state_15082;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15082__$1,(11),out,inst_15058);
} else {
if((state_val_15083 === (5))){
var inst_15046 = (state_15082[(9)]);
var inst_15050 = (state_15082[(10)]);
var inst_15043 = (state_15082[(8)]);
var inst_15050__$1 = f.call(null,inst_15046);
var inst_15051 = cljs.core._EQ_.call(null,inst_15050__$1,inst_15043);
var inst_15052 = cljs.core.keyword_identical_QMARK_.call(null,inst_15043,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15053 = (inst_15051) || (inst_15052);
var state_15082__$1 = (function (){var statearr_15096 = state_15082;
(statearr_15096[(10)] = inst_15050__$1);

return statearr_15096;
})();
if(cljs.core.truth_(inst_15053)){
var statearr_15097_15126 = state_15082__$1;
(statearr_15097_15126[(1)] = (8));

} else {
var statearr_15098_15127 = state_15082__$1;
(statearr_15098_15127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (14))){
var inst_15075 = (state_15082[(2)]);
var inst_15076 = cljs.core.async.close_BANG_.call(null,out);
var state_15082__$1 = (function (){var statearr_15100 = state_15082;
(statearr_15100[(13)] = inst_15075);

return statearr_15100;
})();
var statearr_15101_15128 = state_15082__$1;
(statearr_15101_15128[(2)] = inst_15076);

(statearr_15101_15128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (10))){
var inst_15065 = (state_15082[(2)]);
var state_15082__$1 = state_15082;
var statearr_15102_15129 = state_15082__$1;
(statearr_15102_15129[(2)] = inst_15065);

(statearr_15102_15129[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15083 === (8))){
var inst_15046 = (state_15082[(9)]);
var inst_15042 = (state_15082[(7)]);
var inst_15050 = (state_15082[(10)]);
var inst_15055 = inst_15042.push(inst_15046);
var tmp15099 = inst_15042;
var inst_15042__$1 = tmp15099;
var inst_15043 = inst_15050;
var state_15082__$1 = (function (){var statearr_15103 = state_15082;
(statearr_15103[(7)] = inst_15042__$1);

(statearr_15103[(8)] = inst_15043);

(statearr_15103[(14)] = inst_15055);

return statearr_15103;
})();
var statearr_15104_15130 = state_15082__$1;
(statearr_15104_15130[(2)] = null);

(statearr_15104_15130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto___15116,out))
;
return ((function (switch__12197__auto__,c__12309__auto___15116,out){
return (function() {
var cljs$core$async$state_machine__12198__auto__ = null;
var cljs$core$async$state_machine__12198__auto____0 = (function (){
var statearr_15108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15108[(0)] = cljs$core$async$state_machine__12198__auto__);

(statearr_15108[(1)] = (1));

return statearr_15108;
});
var cljs$core$async$state_machine__12198__auto____1 = (function (state_15082){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_15082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e15109){if((e15109 instanceof Object)){
var ex__12201__auto__ = e15109;
var statearr_15110_15131 = state_15082;
(statearr_15110_15131[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15109;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15132 = state_15082;
state_15082 = G__15132;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
cljs$core$async$state_machine__12198__auto__ = function(state_15082){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12198__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12198__auto____1.call(this,state_15082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12198__auto____0;
cljs$core$async$state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12198__auto____1;
return cljs$core$async$state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto___15116,out))
})();
var state__12311__auto__ = (function (){var statearr_15111 = f__12310__auto__.call(null);
(statearr_15111[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto___15116);

return statearr_15111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto___15116,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

