// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__44182_SHARP_){
if(typeof p1__44182_SHARP_ === 'string'){
return clojure.string.lower_case(p1__44182_SHARP_);
} else {
return p1__44182_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__44188){
var vec__44189 = p__44188;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44189,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44189,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__44183_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__44183_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__44192 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__44192__$1 = ((((!((map__44192 == null)))?((((map__44192.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44192.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44192):map__44192);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44192__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44192__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44192__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___44225 = arguments.length;
var i__7485__auto___44226 = (0);
while(true){
if((i__7485__auto___44226 < len__7484__auto___44225)){
args__7491__auto__.push((arguments[i__7485__auto___44226]));

var G__44227 = (i__7485__auto___44226 + (1));
i__7485__auto___44226 = G__44227;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__44197){
var map__44198 = p__44197;
var map__44198__$1 = ((((!((map__44198 == null)))?((((map__44198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44198):map__44198);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44198__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44198__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44198__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44198__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__44200 = cljs.core.false_QMARK_;
var G__44201 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__44200,map__44198,map__44198__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__44194_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__44194_SHARP_)) == null);
});})(G__44200,map__44198,map__44198__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__44200,G__44201) : chimera.core.any_QMARK_.call(null,G__44200,G__44201));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__44198,map__44198__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__44202(s__44203){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__44198,map__44198__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__44203__$1 = s__44203;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44203__$1);
if(temp__4657__auto__){
var s__44203__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44203__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44203__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44205 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44204 = (0);
while(true){
if((i__44204 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44204);
cljs.core.chunk_append(b__44205,(function (){var map__44216 = field;
var map__44216__$1 = ((((!((map__44216 == null)))?((((map__44216.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44216.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44216):map__44216);
var map__44217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44216__$1,cljs.core.cst$kw$instance);
var map__44217__$1 = ((((!((map__44217 == null)))?((((map__44217.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44217.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44217):map__44217);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44217__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44216__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44216__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44216__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__44228 = (i__44204 + (1));
i__44204 = G__44228;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44205),hatti$views$table$iter__44202(cljs.core.chunk_rest(s__44203__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44205),null);
}
} else {
var field = cljs.core.first(s__44203__$2);
return cljs.core.cons((function (){var map__44220 = field;
var map__44220__$1 = ((((!((map__44220 == null)))?((((map__44220.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44220.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44220):map__44220);
var map__44221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44220__$1,cljs.core.cst$kw$instance);
var map__44221__$1 = ((((!((map__44221 == null)))?((((map__44221.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44221.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44221):map__44221);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44221__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44220__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44220__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44220__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__44202(cljs.core.rest(s__44203__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__44198,map__44198__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__44198,map__44198__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__44224 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__44224,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__44224;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq44195){
var G__44196 = cljs.core.first(seq44195);
var seq44195__$1 = cljs.core.next(seq44195);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__44196,seq44195__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__44230 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__44230);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44249(s__44250){
return (new cljs.core.LazySeq(null,(function (){
var s__44250__$1 = s__44250;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44250__$1);
if(temp__4657__auto__){
var s__44250__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44250__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44250__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44252 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44251 = (0);
while(true){
if((i__44251 < size__7188__auto__)){
var vec__44261 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44251);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44261,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44261,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__44252,event.subscribe(handler_function));

var G__44267 = (i__44251 + (1));
i__44251 = G__44267;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44252),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44249(cljs.core.chunk_rest(s__44250__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44252),null);
}
} else {
var vec__44264 = cljs.core.first(s__44250__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44264,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44264,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44249(cljs.core.rest(s__44250__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44286(s__44287){
return (new cljs.core.LazySeq(null,(function (){
var s__44287__$1 = s__44287;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44287__$1);
if(temp__4657__auto__){
var s__44287__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44287__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44287__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44289 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44288 = (0);
while(true){
if((i__44288 < size__7188__auto__)){
var vec__44298 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44288);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44298,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44298,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__44289,event.subscribe(handler_function));

var G__44304 = (i__44288 + (1));
i__44288 = G__44304;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44289),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44286(cljs.core.chunk_rest(s__44287__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44289),null);
}
} else {
var vec__44301 = cljs.core.first(s__44287__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44301,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44301,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44286(cljs.core.rest(s__44287__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__44305){
var map__44317 = p__44305;
var map__44317__$1 = ((((!((map__44317 == null)))?((((map__44317.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44317.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44317):map__44317);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44317__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44317__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__44319 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__44319__$1 = ((((!((map__44319 == null)))?((((map__44319.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44319.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44319):map__44319);
var map__44320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44319__$1,cljs.core.cst$kw$table_DASH_page);
var map__44320__$1 = ((((!((map__44320 == null)))?((((map__44320.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44320.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44320):map__44320);
var map__44321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44320__$1,cljs.core.cst$kw$paging);
var map__44321__$1 = ((((!((map__44321 == null)))?((((map__44321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44321):map__44321);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44321__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44321__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44320__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var _ = (function (){var G__44325 = ">>> columns: ";
var G__44326 = cljs.core.clj__GT_js(columns);
return console.log(G__44325,G__44326);
})();
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__44327 = elem.getAttribute("data-id");
return parseInt(G__44327);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(map__44319,map__44319__$1,map__44320,map__44320__$1,map__44321,map__44321__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,_,SlickGrid,DataView,dataview,grid,map__44317,map__44317__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,event_chan){
return (function (state_44589){
var state_val_44590 = (state_44589[(1)]);
if((state_val_44590 === (7))){
var inst_44498 = (state_44589[(7)]);
var inst_44498__$1 = (state_44589[(2)]);
var inst_44500 = (inst_44498__$1 == null);
var inst_44501 = cljs.core.not(inst_44500);
var state_44589__$1 = (function (){var statearr_44591 = state_44589;
(statearr_44591[(7)] = inst_44498__$1);

return statearr_44591;
})();
if(inst_44501){
var statearr_44592_44659 = state_44589__$1;
(statearr_44592_44659[(1)] = (8));

} else {
var statearr_44593_44660 = state_44589__$1;
(statearr_44593_44660[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (20))){
var inst_44528 = (state_44589[(8)]);
var inst_44520 = (state_44589[(9)]);
var inst_44537 = (inst_44528.cljs$core$IFn$_invoke$arity$1 ? inst_44528.cljs$core$IFn$_invoke$arity$1(inst_44520) : inst_44528.call(null,inst_44520));
var state_44589__$1 = state_44589;
var statearr_44594_44661 = state_44589__$1;
(statearr_44594_44661[(2)] = inst_44537);

(statearr_44594_44661[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (27))){
var state_44589__$1 = state_44589;
var statearr_44595_44662 = state_44589__$1;
(statearr_44595_44662[(2)] = null);

(statearr_44595_44662[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (1))){
var state_44589__$1 = state_44589;
var statearr_44596_44663 = state_44589__$1;
(statearr_44596_44663[(2)] = null);

(statearr_44596_44663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (24))){
var state_44589__$1 = state_44589;
var statearr_44597_44664 = state_44589__$1;
(statearr_44597_44664[(2)] = null);

(statearr_44597_44664[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (4))){
var state_44589__$1 = state_44589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44589__$1,(7),event_chan);
} else {
if((state_val_44590 === (15))){
var inst_44498 = (state_44589[(7)]);
var state_44589__$1 = state_44589;
var statearr_44598_44665 = state_44589__$1;
(statearr_44598_44665[(2)] = inst_44498);

(statearr_44598_44665[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (21))){
var state_44589__$1 = state_44589;
var statearr_44599_44666 = state_44589__$1;
(statearr_44599_44666[(2)] = null);

(statearr_44599_44666[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (31))){
var inst_44524 = (state_44589[(10)]);
var inst_44562 = (state_44589[(2)]);
var inst_44563 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_44524,cljs.core.cst$kw$table);
var state_44589__$1 = (function (){var statearr_44600 = state_44589;
(statearr_44600[(11)] = inst_44562);

return statearr_44600;
})();
if(inst_44563){
var statearr_44601_44667 = state_44589__$1;
(statearr_44601_44667[(1)] = (32));

} else {
var statearr_44602_44668 = state_44589__$1;
(statearr_44602_44668[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (32))){
var inst_44519 = (state_44589[(12)]);
var inst_44529 = (state_44589[(13)]);
var inst_44524 = (state_44589[(10)]);
var inst_44522 = (state_44589[(14)]);
var inst_44518 = (state_44589[(15)]);
var inst_44523 = (state_44589[(16)]);
var inst_44528 = (state_44589[(8)]);
var inst_44520 = (state_44589[(9)]);
var inst_44521 = (state_44589[(17)]);
var inst_44576 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44577 = (function (){var new_columns = inst_44523;
var submission_clicked = inst_44520;
var submission_unclicked = inst_44521;
var get_submission_data = inst_44529;
var map__44496 = inst_44518;
var c__12309__auto____$1 = inst_44576;
var re_render = inst_44524;
var update_data_BANG_ = inst_44528;
var submission_to_rank = inst_44519;
var filter_by = inst_44522;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__44496,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_44519,inst_44529,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44576,state_val_44590,c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,map__44496,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_44519,inst_44529,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44576,state_val_44590,c__12309__auto__,event_chan){
return (function (state_44574){
var state_val_44575 = (state_44574[(1)]);
if((state_val_44575 === (1))){
var inst_44565 = cljs.core.async.timeout((20));
var state_44574__$1 = state_44574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44574__$1,(2),inst_44565);
} else {
if((state_val_44575 === (2))){
var inst_44567 = (state_44574[(2)]);
var inst_44568 = grid.resizeCanvas();
var inst_44569 = grid.invalidateAllRows();
var inst_44570 = hatti.views.table.resizeColumns(grid);
var inst_44571 = grid.render();
var inst_44572 = hatti.views.table.init_sg_pager(grid,dataview);
var state_44574__$1 = (function (){var statearr_44603 = state_44574;
(statearr_44603[(7)] = inst_44568);

(statearr_44603[(8)] = inst_44567);

(statearr_44603[(9)] = inst_44571);

(statearr_44603[(10)] = inst_44570);

(statearr_44603[(11)] = inst_44569);

return statearr_44603;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44574__$1,inst_44572);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__44496,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_44519,inst_44529,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44576,state_val_44590,c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__44496,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_44519,inst_44529,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44576,state_val_44590,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_44607 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44607[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_44607[(1)] = (1));

return statearr_44607;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_44574){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_44574);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e44608){if((e44608 instanceof Object)){
var ex__12201__auto__ = e44608;
var statearr_44609_44669 = state_44574;
(statearr_44609_44669[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44574);

return cljs.core.cst$kw$recur;
} else {
throw e44608;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__44670 = state_44574;
state_44574 = G__44670;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_44574){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_44574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,map__44496,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_44519,inst_44529,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44576,state_val_44590,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_44610 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_44610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto____$1);

return statearr_44610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,map__44496,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_44519,inst_44529,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44576,state_val_44590,c__12309__auto__,event_chan))
})();
var inst_44578 = cljs.core.async.impl.dispatch.run(inst_44577);
var state_44589__$1 = (function (){var statearr_44611 = state_44589;
(statearr_44611[(18)] = inst_44578);

return statearr_44611;
})();
var statearr_44612_44671 = state_44589__$1;
(statearr_44612_44671[(2)] = inst_44576);

(statearr_44612_44671[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (33))){
var state_44589__$1 = state_44589;
var statearr_44613_44672 = state_44589__$1;
(statearr_44613_44672[(2)] = null);

(statearr_44613_44672[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (13))){
var inst_44510 = (state_44589[(2)]);
var state_44589__$1 = state_44589;
var statearr_44614_44673 = state_44589__$1;
(statearr_44614_44673[(2)] = inst_44510);

(statearr_44614_44673[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (22))){
var inst_44521 = (state_44589[(17)]);
var inst_44540 = (state_44589[(2)]);
var state_44589__$1 = (function (){var statearr_44615 = state_44589;
(statearr_44615[(19)] = inst_44540);

return statearr_44615;
})();
if(cljs.core.truth_(inst_44521)){
var statearr_44616_44674 = state_44589__$1;
(statearr_44616_44674[(1)] = (23));

} else {
var statearr_44617_44675 = state_44589__$1;
(statearr_44617_44675[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (29))){
var inst_44522 = (state_44589[(14)]);
var inst_44554 = [cljs.core.cst$kw$query];
var inst_44555 = [inst_44522];
var inst_44556 = cljs.core.PersistentHashMap.fromArrays(inst_44554,inst_44555);
var inst_44557 = cljs.core.clj__GT_js(inst_44556);
var inst_44558 = dataview.setFilterArgs(inst_44557);
var inst_44559 = dataview.refresh();
var state_44589__$1 = (function (){var statearr_44618 = state_44589;
(statearr_44618[(20)] = inst_44558);

return statearr_44618;
})();
var statearr_44619_44676 = state_44589__$1;
(statearr_44619_44676[(2)] = inst_44559);

(statearr_44619_44676[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (6))){
var inst_44585 = (state_44589[(2)]);
var state_44589__$1 = state_44589;
var statearr_44620_44677 = state_44589__$1;
(statearr_44620_44677[(2)] = inst_44585);

(statearr_44620_44677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (28))){
var inst_44522 = (state_44589[(14)]);
var inst_44552 = (state_44589[(2)]);
var state_44589__$1 = (function (){var statearr_44621 = state_44589;
(statearr_44621[(21)] = inst_44552);

return statearr_44621;
})();
if(cljs.core.truth_(inst_44522)){
var statearr_44622_44678 = state_44589__$1;
(statearr_44622_44678[(1)] = (29));

} else {
var statearr_44623_44679 = state_44589__$1;
(statearr_44623_44679[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (25))){
var inst_44523 = (state_44589[(16)]);
var inst_44545 = (state_44589[(2)]);
var state_44589__$1 = (function (){var statearr_44624 = state_44589;
(statearr_44624[(22)] = inst_44545);

return statearr_44624;
})();
if(cljs.core.truth_(inst_44523)){
var statearr_44625_44680 = state_44589__$1;
(statearr_44625_44680[(1)] = (26));

} else {
var statearr_44626_44681 = state_44589__$1;
(statearr_44626_44681[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (34))){
var inst_44581 = (state_44589[(2)]);
var state_44589__$1 = (function (){var statearr_44627 = state_44589;
(statearr_44627[(23)] = inst_44581);

return statearr_44627;
})();
var statearr_44628_44682 = state_44589__$1;
(statearr_44628_44682[(2)] = null);

(statearr_44628_44682[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (17))){
var inst_44519 = (state_44589[(12)]);
var inst_44529 = (state_44589[(13)]);
var inst_44528 = (state_44589[(8)]);
var inst_44531 = (inst_44529.cljs$core$IFn$_invoke$arity$2 ? inst_44529.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_44519) : inst_44529.call(null,hatti.constants._rank,inst_44519));
var inst_44532 = (inst_44528.cljs$core$IFn$_invoke$arity$1 ? inst_44528.cljs$core$IFn$_invoke$arity$1(inst_44531) : inst_44528.call(null,inst_44531));
var state_44589__$1 = state_44589;
var statearr_44629_44683 = state_44589__$1;
(statearr_44629_44683[(2)] = inst_44532);

(statearr_44629_44683[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (3))){
var inst_44587 = (state_44589[(2)]);
var state_44589__$1 = state_44589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44589__$1,inst_44587);
} else {
if((state_val_44590 === (12))){
var state_44589__$1 = state_44589;
var statearr_44630_44684 = state_44589__$1;
(statearr_44630_44684[(2)] = false);

(statearr_44630_44684[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (2))){
var state_44589__$1 = state_44589;
var statearr_44631_44685 = state_44589__$1;
(statearr_44631_44685[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (23))){
var inst_44528 = (state_44589[(8)]);
var inst_44542 = (inst_44528.cljs$core$IFn$_invoke$arity$1 ? inst_44528.cljs$core$IFn$_invoke$arity$1(null) : inst_44528.call(null,null));
var state_44589__$1 = state_44589;
var statearr_44633_44686 = state_44589__$1;
(statearr_44633_44686[(2)] = inst_44542);

(statearr_44633_44686[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (19))){
var inst_44520 = (state_44589[(9)]);
var inst_44535 = (state_44589[(2)]);
var state_44589__$1 = (function (){var statearr_44634 = state_44589;
(statearr_44634[(24)] = inst_44535);

return statearr_44634;
})();
if(cljs.core.truth_(inst_44520)){
var statearr_44635_44687 = state_44589__$1;
(statearr_44635_44687[(1)] = (20));

} else {
var statearr_44636_44688 = state_44589__$1;
(statearr_44636_44688[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (11))){
var state_44589__$1 = state_44589;
var statearr_44637_44689 = state_44589__$1;
(statearr_44637_44689[(2)] = true);

(statearr_44637_44689[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (9))){
var state_44589__$1 = state_44589;
var statearr_44638_44690 = state_44589__$1;
(statearr_44638_44690[(2)] = false);

(statearr_44638_44690[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (5))){
var state_44589__$1 = state_44589;
var statearr_44639_44691 = state_44589__$1;
(statearr_44639_44691[(2)] = null);

(statearr_44639_44691[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (14))){
var inst_44498 = (state_44589[(7)]);
var inst_44515 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_44498);
var state_44589__$1 = state_44589;
var statearr_44640_44692 = state_44589__$1;
(statearr_44640_44692[(2)] = inst_44515);

(statearr_44640_44692[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (26))){
var inst_44523 = (state_44589[(16)]);
var inst_44547 = grid.setColumns(inst_44523);
var inst_44548 = hatti.views.table.resizeColumns(grid);
var inst_44549 = grid.render();
var state_44589__$1 = (function (){var statearr_44641 = state_44589;
(statearr_44641[(25)] = inst_44547);

(statearr_44641[(26)] = inst_44548);

return statearr_44641;
})();
var statearr_44642_44693 = state_44589__$1;
(statearr_44642_44693[(2)] = inst_44549);

(statearr_44642_44693[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (16))){
var inst_44519 = (state_44589[(12)]);
var inst_44524 = (state_44589[(10)]);
var inst_44522 = (state_44589[(14)]);
var inst_44518 = (state_44589[(15)]);
var inst_44523 = (state_44589[(16)]);
var inst_44528 = (state_44589[(8)]);
var inst_44520 = (state_44589[(9)]);
var inst_44521 = (state_44589[(17)]);
var inst_44518__$1 = (state_44589[(2)]);
var inst_44519__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44518__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_44520__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44518__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_44521__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44518__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_44522__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44518__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_44523__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44518__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_44524__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44518__$1,cljs.core.cst$kw$re_DASH_render);
var inst_44525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44526 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_44527 = (new cljs.core.PersistentVector(null,3,(5),inst_44525,inst_44526,null));
var inst_44528__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_44527);
var inst_44529 = (function (){var map__44496 = inst_44518__$1;
var submission_to_rank = inst_44519__$1;
var submission_clicked = inst_44520__$1;
var submission_unclicked = inst_44521__$1;
var filter_by = inst_44522__$1;
var new_columns = inst_44523__$1;
var re_render = inst_44524__$1;
var update_data_BANG_ = inst_44528__$1;
return ((function (map__44496,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44519,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44518__$1,inst_44519__$1,inst_44520__$1,inst_44521__$1,inst_44522__$1,inst_44523__$1,inst_44524__$1,inst_44525,inst_44526,inst_44527,inst_44528__$1,state_val_44590,c__12309__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__44496,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44519,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44518__$1,inst_44519__$1,inst_44520__$1,inst_44521__$1,inst_44522__$1,inst_44523__$1,inst_44524__$1,inst_44525,inst_44526,inst_44527,inst_44528__$1,state_val_44590,c__12309__auto__,event_chan){
return (function (p1__44328_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__44328_SHARP_,field));
});})(map__44496,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44519,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44518__$1,inst_44519__$1,inst_44520__$1,inst_44521__$1,inst_44522__$1,inst_44523__$1,inst_44524__$1,inst_44525,inst_44526,inst_44527,inst_44528__$1,state_val_44590,c__12309__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__44496,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44519,inst_44524,inst_44522,inst_44518,inst_44523,inst_44528,inst_44520,inst_44521,inst_44518__$1,inst_44519__$1,inst_44520__$1,inst_44521__$1,inst_44522__$1,inst_44523__$1,inst_44524__$1,inst_44525,inst_44526,inst_44527,inst_44528__$1,state_val_44590,c__12309__auto__,event_chan))
})();
var state_44589__$1 = (function (){var statearr_44643 = state_44589;
(statearr_44643[(12)] = inst_44519__$1);

(statearr_44643[(13)] = inst_44529);

(statearr_44643[(10)] = inst_44524__$1);

(statearr_44643[(14)] = inst_44522__$1);

(statearr_44643[(15)] = inst_44518__$1);

(statearr_44643[(16)] = inst_44523__$1);

(statearr_44643[(8)] = inst_44528__$1);

(statearr_44643[(9)] = inst_44520__$1);

(statearr_44643[(17)] = inst_44521__$1);

return statearr_44643;
})();
if(cljs.core.truth_(inst_44519__$1)){
var statearr_44644_44694 = state_44589__$1;
(statearr_44644_44694[(1)] = (17));

} else {
var statearr_44645_44695 = state_44589__$1;
(statearr_44645_44695[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (30))){
var state_44589__$1 = state_44589;
var statearr_44646_44696 = state_44589__$1;
(statearr_44646_44696[(2)] = null);

(statearr_44646_44696[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (10))){
var inst_44513 = (state_44589[(2)]);
var state_44589__$1 = state_44589;
if(cljs.core.truth_(inst_44513)){
var statearr_44647_44697 = state_44589__$1;
(statearr_44647_44697[(1)] = (14));

} else {
var statearr_44648_44698 = state_44589__$1;
(statearr_44648_44698[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (18))){
var state_44589__$1 = state_44589;
var statearr_44649_44699 = state_44589__$1;
(statearr_44649_44699[(2)] = null);

(statearr_44649_44699[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44590 === (8))){
var inst_44498 = (state_44589[(7)]);
var inst_44503 = inst_44498.cljs$lang$protocol_mask$partition0$;
var inst_44504 = (inst_44503 & (64));
var inst_44505 = inst_44498.cljs$core$ISeq$;
var inst_44506 = (inst_44504) || (inst_44505);
var state_44589__$1 = state_44589;
if(cljs.core.truth_(inst_44506)){
var statearr_44650_44700 = state_44589__$1;
(statearr_44650_44700[(1)] = (11));

} else {
var statearr_44651_44701 = state_44589__$1;
(statearr_44651_44701[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_44655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44655[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_44655[(1)] = (1));

return statearr_44655;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_44589){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_44589);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e44656){if((e44656 instanceof Object)){
var ex__12201__auto__ = e44656;
var statearr_44657_44702 = state_44589;
(statearr_44657_44702[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44589);

return cljs.core.cst$kw$recur;
} else {
throw e44656;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__44703 = state_44589;
state_44589 = G__44703;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_44589){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_44589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_44658 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_44658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_44658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,event_chan))
);

return c__12309__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__44722(s__44723){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__44723__$1 = s__44723;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44723__$1);
if(temp__4657__auto__){
var s__44723__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44723__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44723__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44725 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44724 = (0);
while(true){
if((i__44724 < size__7188__auto__)){
var vec__44734 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44724);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(1),null);
cljs.core.chunk_append(b__44725,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__44724,vec__44734,k,v,c__7187__auto__,size__7188__auto__,b__44725,s__44723__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__44724,vec__44734,k,v,c__7187__auto__,size__7188__auto__,b__44725,s__44723__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__44740 = (i__44724 + (1));
i__44724 = G__44740;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44725),hatti$views$table$render_options_$_iter__44722(cljs.core.chunk_rest(s__44723__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44725),null);
}
} else {
var vec__44737 = cljs.core.first(s__44723__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44737,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44737,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__44737,k,v,s__44723__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__44737,k,v,s__44723__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__44722(cljs.core.rest(s__44723__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table44742 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44742 = (function (_,owner,meta44743){
this._ = _;
this.owner = owner;
this.meta44743 = meta44743;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44742.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44744,meta44743__$1){
var self__ = this;
var _44744__$1 = this;
return (new hatti.views.table.t_hatti$views$table44742(self__._,self__.owner,meta44743__$1));
});

hatti.views.table.t_hatti$views$table44742.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44744){
var self__ = this;
var _44744__$1 = this;
return self__.meta44743;
});

hatti.views.table.t_hatti$views$table44742.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table44742.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table44742.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table44742.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__44745){
var self__ = this;
var map__44746 = p__44745;
var map__44746__$1 = ((((!((map__44746 == null)))?((((map__44746.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44746.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44746):map__44746);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44746__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44746__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__44748 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__44748__$1 = ((((!((map__44748 == null)))?((((map__44748.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44748.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44748):map__44748);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44748__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__44748,map__44748__$1,flat_form,new_language,___$2,map__44746,map__44746__$1,field_key,language){
return (function (p1__44741_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__44741_SHARP_),cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__44748,map__44748__$1,flat_form,new_language,___$2,map__44746,map__44746__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__44758 = ({"className": "label-changer"});
var G__44759 = (function (){var G__44761 = ({"className": "label-changer-label"});
var G__44762 = "Show:";
return React.DOM.span(G__44761,G__44762);
})();
var G__44760 = (function (){var G__44763 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__44764 = (function (){var attrs44752 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs44752))?sablono.interpreter.attributes(attrs44752):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs44752))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__44766 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__44766);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs44752),(function (){var G__44767 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__44767);
})()], null))));
})();
var G__44765 = (function (){var attrs44757 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs44757))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs44757], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs44757))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs44757)], null))));
})();
return React.DOM.div(G__44763,G__44764,G__44765);
})();
return React.DOM.div(G__44758,G__44759,G__44760);
});

hatti.views.table.t_hatti$views$table44742.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44743], null);
});

hatti.views.table.t_hatti$views$table44742.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44742.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44742";

hatti.views.table.t_hatti$views$table44742.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44742");
});

hatti.views.table.__GT_t_hatti$views$table44742 = (function hatti$views$table$__GT_t_hatti$views$table44742(___$1,owner__$1,meta44743){
return (new hatti.views.table.t_hatti$views$table44742(___$1,owner__$1,meta44743));
});

}

return (new hatti.views.table.t_hatti$views$table44742(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,query){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,query){
return (function (state_44810){
var state_val_44811 = (state_44810[(1)]);
if((state_val_44811 === (1))){
var inst_44796 = cljs.core.async.timeout((150));
var state_44810__$1 = state_44810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44810__$1,(2),inst_44796);
} else {
if((state_val_44811 === (2))){
var inst_44798 = (state_44810[(2)]);
var inst_44799 = input.value;
var inst_44800 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_44799);
var state_44810__$1 = (function (){var statearr_44812 = state_44810;
(statearr_44812[(7)] = inst_44798);

return statearr_44812;
})();
if(inst_44800){
var statearr_44813_44824 = state_44810__$1;
(statearr_44813_44824[(1)] = (3));

} else {
var statearr_44814_44825 = state_44810__$1;
(statearr_44814_44825[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44811 === (3))){
var inst_44802 = [query_event_key];
var inst_44803 = [query];
var inst_44804 = cljs.core.PersistentHashMap.fromArrays(inst_44802,inst_44803);
var inst_44805 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_44804);
var state_44810__$1 = state_44810;
var statearr_44815_44826 = state_44810__$1;
(statearr_44815_44826[(2)] = inst_44805);

(statearr_44815_44826[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44811 === (4))){
var state_44810__$1 = state_44810;
var statearr_44816_44827 = state_44810__$1;
(statearr_44816_44827[(2)] = null);

(statearr_44816_44827[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44811 === (5))){
var inst_44808 = (state_44810[(2)]);
var state_44810__$1 = state_44810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44810__$1,inst_44808);
} else {
return null;
}
}
}
}
}
});})(c__12309__auto__,query))
;
return ((function (switch__12197__auto__,c__12309__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12198__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12198__auto____0 = (function (){
var statearr_44820 = [null,null,null,null,null,null,null,null];
(statearr_44820[(0)] = hatti$views$table$delayed_search_$_state_machine__12198__auto__);

(statearr_44820[(1)] = (1));

return statearr_44820;
});
var hatti$views$table$delayed_search_$_state_machine__12198__auto____1 = (function (state_44810){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_44810);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e44821){if((e44821 instanceof Object)){
var ex__12201__auto__ = e44821;
var statearr_44822_44828 = state_44810;
(statearr_44822_44828[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44810);

return cljs.core.cst$kw$recur;
} else {
throw e44821;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__44829 = state_44810;
state_44810 = G__44829;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12198__auto__ = function(state_44810){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____1.call(this,state_44810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12198__auto____0;
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12198__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,query))
})();
var state__12311__auto__ = (function (){var statearr_44823 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_44823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_44823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,query))
);

return c__12309__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table44831 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44831 = (function (_,owner,meta44832){
this._ = _;
this.owner = owner;
this.meta44832 = meta44832;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44831.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44833,meta44832__$1){
var self__ = this;
var _44833__$1 = this;
return (new hatti.views.table.t_hatti$views$table44831(self__._,self__.owner,meta44832__$1));
});

hatti.views.table.t_hatti$views$table44831.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44833){
var self__ = this;
var _44833__$1 = this;
return self__.meta44832;
});

hatti.views.table.t_hatti$views$table44831.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table44831.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
var G__44836 = ({"className": "table-search"});
var G__44837 = (function (){var G__44839 = ({"className": "fa fa-search"});
return React.DOM.i(G__44839);
})();
var G__44838 = (function (){var G__44840 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__44836,G__44837,this__18254__auto____$1){
return (function (p1__44830_SHARP_){
return hatti.views.table.delayed_search(p1__44830_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__44836,G__44837,this__18254__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__44840) : sablono.interpreter.input.call(null,G__44840));
})();
return React.DOM.div(G__44836,G__44837,G__44838);
});

hatti.views.table.t_hatti$views$table44831.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44832], null);
});

hatti.views.table.t_hatti$views$table44831.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44831.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44831";

hatti.views.table.t_hatti$views$table44831.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44831");
});

hatti.views.table.__GT_t_hatti$views$table44831 = (function hatti$views$table$__GT_t_hatti$views$table44831(___$1,owner__$1,meta44832){
return (new hatti.views.table.t_hatti$views$table44831(___$1,owner__$1,meta44832));
});

}

return (new hatti.views.table.t_hatti$views$table44831(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table44841 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44841 = (function (cursor,owner,meta44842){
this.cursor = cursor;
this.owner = owner;
this.meta44842 = meta44842;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44841.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44843,meta44842__$1){
var self__ = this;
var _44843__$1 = this;
return (new hatti.views.table.t_hatti$views$table44841(self__.cursor,self__.owner,meta44842__$1));
});

hatti.views.table.t_hatti$views$table44841.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44843){
var self__ = this;
var _44843__$1 = this;
return self__.meta44842;
});

hatti.views.table.t_hatti$views$table44841.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table44841.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
var G__44846 = ({"className": "topbar"});
var G__44847 = (function (){var G__44851 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__44851);
})();
var G__44848 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__44849 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__44850 = (function (){var G__44852 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__44852);
})();
return React.DOM.div(G__44846,G__44847,G__44848,G__44849,G__44850);
});

hatti.views.table.t_hatti$views$table44841.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44842], null);
});

hatti.views.table.t_hatti$views$table44841.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44841.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44841";

hatti.views.table.t_hatti$views$table44841.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44841");
});

hatti.views.table.__GT_t_hatti$views$table44841 = (function hatti$views$table$__GT_t_hatti$views$table44841(cursor__$1,owner__$1,meta44842){
return (new hatti.views.table.t_hatti$views$table44841(cursor__$1,owner__$1,meta44842));
});

}

return (new hatti.views.table.t_hatti$views$table44841(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__44858 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__44858__$1 = ((((!((map__44858 == null)))?((((map__44858.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44858.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44858):map__44858);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44858__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__44859 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44859,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44859,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__44864,owner,p__44865){
var map__44866 = p__44864;
var map__44866__$1 = ((((!((map__44866 == null)))?((((map__44866.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44866.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44866):map__44866);
var cursor = map__44866__$1;
var map__44867 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44866__$1,cljs.core.cst$kw$views);
var map__44867__$1 = ((((!((map__44867 == null)))?((((map__44867.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44867.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44867):map__44867);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44867__$1,cljs.core.cst$kw$active);
var map__44868 = p__44865;
var map__44868__$1 = ((((!((map__44868 == null)))?((((map__44868.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44868.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44868):map__44868);
var opts = map__44868__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44868__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table44872 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44872 = (function (p__44864,owner,active_QMARK_,slick_grid_event_handlers,map__44866,cursor,map__44867,map__44868,active,opts,p__44865,meta44873){
this.p__44864 = p__44864;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__44866 = map__44866;
this.cursor = cursor;
this.map__44867 = map__44867;
this.map__44868 = map__44868;
this.active = active;
this.opts = opts;
this.p__44865 = p__44865;
this.meta44873 = meta44873;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44872.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (_44874,meta44873__$1){
var self__ = this;
var _44874__$1 = this;
return (new hatti.views.table.t_hatti$views$table44872(self__.p__44864,self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.map__44866,self__.cursor,self__.map__44867,self__.map__44868,self__.active,self__.opts,self__.p__44865,meta44873__$1));
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (_44874){
var self__ = this;
var _44874__$1 = this;
return self__.meta44873;
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (_,p__44875){
var self__ = this;
var map__44876 = p__44875;
var map__44876__$1 = ((((!((map__44876 == null)))?((((map__44876.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44876.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44876):map__44876);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44876__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__44878 = self__.cursor;
var map__44878__$1 = ((((!((map__44878 == null)))?((((map__44878.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44878.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44878):map__44878);
var map__44879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44878__$1,cljs.core.cst$kw$table_DASH_page);
var map__44879__$1 = ((((!((map__44879 == null)))?((((map__44879.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44879.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44879):map__44879);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44879__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44879__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44878__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44878__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__44880 = dataset_info;
var map__44880__$1 = ((((!((map__44880 == null)))?((((map__44880.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44880.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44880):map__44880);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44880__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__44878,map__44878__$1,map__44879,map__44879__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__44880,map__44880__$1,num_of_submissions,no_data_QMARK_,___$1,map__44876,map__44876__$1,table_view_height,active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (p1__44863_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__44863_SHARP_], 0));
});})(map__44878,map__44878__$1,map__44879,map__44879__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__44880,map__44880__$1,num_of_submissions,no_data_QMARK_,___$1,map__44876,map__44876__$1,table_view_height,active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__44884 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__44885 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__44886 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__44887 = (function (){var G__44888 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__44889 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__44894 = ({"className": "alert alert-warning"});
var G__44895 = "No data";
return React.DOM.p(G__44894,G__44895);
})():(function (){var G__44896 = null;
var G__44897 = (function (){var G__44899 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__44899);
})();
var G__44898 = "Loading...";
return React.DOM.span(G__44896,G__44897,G__44898);
})());
return React.DOM.div(G__44888,G__44889);
})();
return React.DOM.div(G__44884,G__44885,G__44886,G__44887);
} else {
return null;
}
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44900 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44900,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44900,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table44872.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__44903 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__44903__$1 = ((((!((map__44903 == null)))?((((map__44903.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44903.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44903):map__44903);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44903__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44903__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44905 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44905,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44905,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.getBasis = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__44864,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__44866,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__44867,cljs.core.cst$sym$map__44868,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$p__44865,cljs.core.cst$sym$meta44873], null);
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44872.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44872.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44872";

hatti.views.table.t_hatti$views$table44872.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44872");
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table44872 = ((function (active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table44872(p__44864__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__44866__$2,cursor__$1,map__44867__$2,map__44868__$2,active__$1,opts__$1,p__44865__$1,meta44873){
return (new hatti.views.table.t_hatti$views$table44872(p__44864__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__44866__$2,cursor__$1,map__44867__$2,map__44868__$2,active__$1,opts__$1,p__44865__$1,meta44873));
});})(active_QMARK_,map__44866,map__44866__$1,cursor,map__44867,map__44867__$1,active,map__44868,map__44868__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table44872(p__44864,owner,active_QMARK_,slick_grid_event_handlers,map__44866__$1,cursor,map__44867__$1,map__44868__$1,active,opts,p__44865,cljs.core.PersistentArrayMap.EMPTY));
}));
