// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.map.utils');
goog.require('chimera.seq');
goog.require('hatti.utils.style');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('clojure.string');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id(marker);
var geotype = hatti.map.utils.marker__GT_geotype(marker);
var color_key = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$line,geotype))?cljs.core.cst$kw$color:cljs.core.cst$kw$fillColor);
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(id) : id_selected_QMARK_.call(null,id)))?(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(id) : id_color.call(null,id)):hatti.utils.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,no_nil)){
return s;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null)], 0));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),(cljs.core.truth_(cljs.core.re_find(/^..:..$/,cljs.core.first(raw_answers)))?"time":"date"));
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40436_SHARP_){
if(cljs.core.truth_(p1__40436_SHARP_)){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__40436_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
hatti.map.viewby.has_geolocation_QMARK_ = (function hatti$map$viewby$has_geolocation_QMARK_(p__40437){
var map__40443 = p__40437;
var map__40443__$1 = ((((!((map__40443 == null)))?((((map__40443.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40443.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40443):map__40443);
var vec__40444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40443__$1,"_geolocation");
var lattitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40444,(0),null);
var longitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40444,(1),null);
var and__6397__auto__ = lattitude;
if(cljs.core.truth_(and__6397__auto__)){
return lattitude;
} else {
return and__6397__auto__;
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(p__40451,data){
var map__40454 = p__40451;
var map__40454__$1 = ((((!((map__40454 == null)))?((((map__40454.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40454.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40454):map__40454);
var field = map__40454__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40454__$1,cljs.core.cst$kw$full_DASH_name);
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__40454,map__40454__$1,field,full_name){
return (function (p1__40448_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40448_SHARP_,hatti.constants._id);
});})(map__40454,map__40454__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__40454,map__40454__$1,field,full_name){
return (function (p1__40449_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40449_SHARP_,full_name);
});})(ids,map__40454,map__40454__$1,field,full_name))
,data);
var submissions_with_geolocation = cljs.core.filterv(hatti.map.viewby.has_geolocation_QMARK_,data);
var raw_answers_with_geolocation = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,raw_answers,submissions_with_geolocation,map__40454,map__40454__$1,field,full_name){
return (function (p1__40450_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40450_SHARP_,full_name);
});})(ids,raw_answers,submissions_with_geolocation,map__40454,map__40454__$1,field,full_name))
,submissions_with_geolocation);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var answer__GT_count_with_geolocations = cljs.core.frequencies(cljs.core.flatten(hatti.map.viewby.preprocess_answers(field,raw_answers_with_geolocation)));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_count_DASH_with_DASH_geolocations,answer__GT_count_with_geolocations,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__40454,map__40454__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__40454,map__40454__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_data = (function hatti$map$viewby$viewby_data(p__40458,data){
var map__40461 = p__40458;
var map__40461__$1 = ((((!((map__40461 == null)))?((((map__40461.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40461.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40461):map__40461);
var field = map__40461__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40461__$1,cljs.core.cst$kw$full_DASH_name);
if(cljs.core.seq_QMARK_(cljs.core.seq(data))){
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__40461,map__40461__$1,field,full_name){
return (function (p1__40456_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40456_SHARP_,hatti.constants._id);
});})(map__40461,map__40461__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__40461,map__40461__$1,field,full_name){
return (function (p1__40457_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40457_SHARP_,full_name);
});})(ids,map__40461,map__40461__$1,field,full_name))
,data);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$ids,ids,cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__40461,map__40461__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__40461,map__40461__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
} else {
return null;
}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__40465){
var map__40471 = p__40465;
var map__40471__$1 = ((((!((map__40471 == null)))?((((map__40471.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40471.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40471):map__40471);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40471__$1,cljs.core.cst$kw$field);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40471__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40471__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40471__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var G__40473 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
switch (G__40473) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(id) : id__GT_answers.call(null,id));
if((answers == null)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers));
}
});})(G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__40463_SHARP_){
var G__40474 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__40463_SHARP_) : id__GT_answers.call(null,p1__40463_SHARP_));
return (answer__GT_color.cljs$core$IFn$_invoke$arity$1 ? answer__GT_color.cljs$core$IFn$_invoke$arity$1(G__40474) : answer__GT_color.call(null,G__40474));
});})(G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__40464_SHARP_){
var G__40475 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__40464_SHARP_) : id__GT_answers.call(null,p1__40464_SHARP_));
return (answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__40475) : answer__GT_selected_QMARK_.call(null,G__40475));
});})(G__40473,map__40471,map__40471__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__40483 = hatti.map.viewby.id_color_selected(view_by_info);
var map__40483__$1 = ((((!((map__40483 == null)))?((((map__40483.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40483.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40483):map__40483);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40483__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40483__$1,cljs.core.cst$kw$id_DASH_color);
var m__GT_s = hatti.map.viewby.marker_styler(id_color,id_selected_QMARK_);
var seq__40485 = cljs.core.seq(markers);
var chunk__40486 = null;
var count__40487 = (0);
var i__40488 = (0);
while(true){
if((i__40488 < count__40487)){
var marker = chunk__40486.cljs$core$IIndexed$_nth$arity$2(null,i__40488);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__40489 = seq__40485;
var G__40490 = chunk__40486;
var G__40491 = count__40487;
var G__40492 = (i__40488 + (1));
seq__40485 = G__40489;
chunk__40486 = G__40490;
count__40487 = G__40491;
i__40488 = G__40492;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__40485);
if(temp__4657__auto__){
var seq__40485__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40485__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__40485__$1);
var G__40493 = cljs.core.chunk_rest(seq__40485__$1);
var G__40494 = c__7220__auto__;
var G__40495 = cljs.core.count(c__7220__auto__);
var G__40496 = (0);
seq__40485 = G__40493;
chunk__40486 = G__40494;
count__40487 = G__40495;
i__40488 = G__40496;
continue;
} else {
var marker = cljs.core.first(seq__40485__$1);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__40497 = cljs.core.next(seq__40485__$1);
var G__40498 = null;
var G__40499 = (0);
var G__40500 = (0);
seq__40485 = G__40497;
chunk__40486 = G__40498;
count__40487 = G__40499;
i__40488 = G__40500;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.viewby.apply_view_by_BANG_ = (function hatti$map$viewby$apply_view_by_BANG_(p__40502,owner){
var map__40507 = p__40502;
var map__40507__$1 = ((((!((map__40507 == null)))?((((map__40507.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40507.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40507):map__40507);
var view_by_info = map__40507__$1;
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40507__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var map__40509 = hatti.map.viewby.id_color_selected(view_by_info);
var map__40509__$1 = ((((!((map__40509 == null)))?((((map__40509.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40509.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40509):map__40509);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40509__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40509__$1,cljs.core.cst$kw$id_DASH_color);
var ids = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(id__GT_answers));
var stops = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__40509,map__40509__$1,id_selected_QMARK_,id_color,ids,map__40507,map__40507__$1,view_by_info,id__GT_answers){
return (function (p1__40501_SHARP_){
if(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(p1__40501_SHARP_) : id_selected_QMARK_.call(null,p1__40501_SHARP_)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__40501_SHARP_,(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(p1__40501_SHARP_) : id_color.call(null,p1__40501_SHARP_))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__40501_SHARP_,hatti.utils.style.grey], null);
}
});})(map__40509,map__40509__$1,id_selected_QMARK_,id_color,ids,map__40507,map__40507__$1,view_by_info,id__GT_answers))
,ids);
var id_string = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$id_string], null));
var style = om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$style], null));
if(cljs.core.seq_QMARK_(cljs.core.seq(stops))){
hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$stops,stops);
} else {
return null;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,ans,cljs.core.array_seq([cljs.core.cst$kw$language,language], 0)));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_answers,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers),cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,cljs.core.zipmap(answers,cljs.core.map.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals(answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(visible),cljs.core.set(cljs.core.keys(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_(answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false)], 0));
} else {
var toggled = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_(cljs.core.false_QMARK_,cljs.core.vals(toggled))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),hatti.map.viewby.all_but_nil_selected(visible_answers)], 0));
} else {
return toggled;
}
}
}
});
/**
 * Returns selected ids from view-by data
 */
hatti.map.viewby.get_selected_ids = (function hatti$map$viewby$get_selected_ids(view_by){
var map__40522 = view_by;
var map__40522__$1 = ((((!((map__40522 == null)))?((((map__40522.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40522.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40522):map__40522);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40522__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40522__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40522__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var into_map = ((function (map__40522,map__40522__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color){
return (function (p1__40511_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,p1__40511_SHARP_);
});})(map__40522,map__40522__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color))
;
var selected_answers = cljs.core.keys(into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__40522,map__40522__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map){
return (function (p__40524){
var vec__40525 = p__40524;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40525,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40525,(1),null);
return v;
});})(map__40522,map__40522__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map))
,answer__GT_selected_QMARK_)));
var selected_ids = cljs.core.keys(into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__40522,map__40522__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers){
return (function (p__40528){
var vec__40529 = p__40528;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40529,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40529,(1),null);
return chimera.seq.in_QMARK_(selected_answers,v);
});})(map__40522,map__40522__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers))
,id__GT_answers)));
var color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(selected_answers)))?cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_color,cljs.core.first(selected_answers)):null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$selected_DASH_ids,selected_ids,cljs.core.cst$kw$cell_DASH_color,color], null);
});
