// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var extra_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"id",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
return extra_field;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(extra_field,hatti.ona.forms.submission_time_field);
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39152 = arguments.length;
var i__7485__auto___39153 = (0);
while(true){
if((i__7485__auto___39153 < len__7484__auto___39152)){
args__7491__auto__.push((arguments[i__7485__auto___39153]));

var G__39154 = (i__7485__auto___39153 + (1));
i__7485__auto___39153 = G__39154;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__39149){
var map__39150 = p__39149;
var map__39150__$1 = ((((!((map__39150 == null)))?((((map__39150.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39150.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39150):map__39150);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39150__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq39147){
var G__39148 = cljs.core.first(seq39147);
var seq39147__$1 = cljs.core.next(seq39147);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__39148,seq39147__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__39155_SHARP_){
if(typeof p1__39155_SHARP_ === 'string'){
return clojure.string.lower_case(p1__39155_SHARP_);
} else {
return p1__39155_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__39161){
var vec__39162 = p__39161;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39162,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39162,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,null,true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__39156_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__39156_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4(field,clj_value,language,true);
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__39165 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__39165__$1 = ((((!((map__39165 == null)))?((((map__39165.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39165.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39165):map__39165);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39165__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39165__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39165__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$right,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args39168 = [];
var len__7484__auto___39200 = arguments.length;
var i__7485__auto___39201 = (0);
while(true){
if((i__7485__auto___39201 < len__7484__auto___39200)){
args39168.push((arguments[i__7485__auto___39201]));

var G__39202 = (i__7485__auto___39201 + (1));
i__7485__auto___39201 = G__39202;
continue;
} else {
}
break;
}

var G__39174 = args39168.length;
switch (G__39174) {
case 1:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args39168.slice((3)),(0),null));
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7503__auto__);

}
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$1 = (function (form){
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2(form,true);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$2 = (function (form,get_label_QMARK_){
return hatti.views.table.flat_form__GT_sg_columns(form,get_label_QMARK_,null);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,get_label_QMARK_,language,p__39175){
var map__39176 = p__39175;
var map__39176__$1 = ((((!((map__39176 == null)))?((((map__39176.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39176.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39176):map__39176);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39176__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39176__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = cljs.core.any_QMARK_(cljs.core.false_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__39176,map__39176__$1,is_filtered_dataview_QMARK_,owner){
return (function (p1__39167_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__39167_SHARP_)) == null);
});})(map__39176,map__39176__$1,is_filtered_dataview_QMARK_,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__39176,map__39176__$1,is_filtered_dataview_QMARK_,owner){
return (function hatti$views$table$iter__39178(s__39179){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__39176,map__39176__$1,is_filtered_dataview_QMARK_,owner){
return (function (){
var s__39179__$1 = s__39179;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39179__$1);
if(temp__4657__auto__){
var s__39179__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39179__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39179__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39181 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39180 = (0);
while(true){
if((i__39180 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39180);
cljs.core.chunk_append(b__39181,(function (){var map__39192 = field;
var map__39192__$1 = ((((!((map__39192 == null)))?((((map__39192.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39192.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39192):map__39192);
var map__39193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39192__$1,cljs.core.cst$kw$instance);
var map__39193__$1 = ((((!((map__39193 == null)))?((((map__39193.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39193.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39193):map__39193);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39193__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39192__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39192__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39192__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,((has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__39204 = (i__39180 + (1));
i__39180 = G__39204;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39181),hatti$views$table$iter__39178(cljs.core.chunk_rest(s__39179__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39181),null);
}
} else {
var field = cljs.core.first(s__39179__$2);
return cljs.core.cons((function (){var map__39196 = field;
var map__39196__$1 = ((((!((map__39196 == null)))?((((map__39196.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39196.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39196):map__39196);
var map__39197 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39196__$1,cljs.core.cst$kw$instance);
var map__39197__$1 = ((((!((map__39197 == null)))?((((map__39197.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39197.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39197):map__39197);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39197__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39196__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39196__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39196__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,((has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__39178(cljs.core.rest(s__39179__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__39176,map__39176__$1,is_filtered_dataview_QMARK_,owner))
,null,null));
});})(has_hxl_QMARK_,map__39176,map__39176__$1,is_filtered_dataview_QMARK_,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(columns,hatti.views.table.actions_column(owner,has_hxl_QMARK_)));
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq39169){
var G__39170 = cljs.core.first(seq39169);
var seq39169__$1 = cljs.core.next(seq39169);
var G__39171 = cljs.core.first(seq39169__$1);
var seq39169__$2 = cljs.core.next(seq39169__$1);
var G__39172 = cljs.core.first(seq39169__$2);
var seq39169__$3 = cljs.core.next(seq39169__$2);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__39170,G__39171,G__39172,seq39169__$3);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (3);

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__39206 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__39206);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
/**
 * Fixes the first column on slick table on horizontal scroll
 */
hatti.views.table.freeze_action_column_BANG_ = (function hatti$views$table$freeze_action_column_BANG_(){
var actions = document.getElementsByClassName("record-actions");
var sg_viewport = cljs.core.first(document.getElementsByClassName("slick-viewport"));
var seq__39214 = cljs.core.seq(actions);
var chunk__39215 = null;
var count__39216 = (0);
var i__39217 = (0);
while(true){
if((i__39217 < count__39216)){
var action = chunk__39215.cljs$core$IIndexed$_nth$arity$2(null,i__39217);
var leftOffset_39220 = (function (){var G__39218 = action.offsetLeft;
return parseInt(G__39218);
})();
sg_viewport.addEventListener("scroll",((function (seq__39214,chunk__39215,count__39216,i__39217,leftOffset_39220,action,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__39214,chunk__39215,count__39216,i__39217,sl,leftOffset_39220,action,actions,sg_viewport){
return (function (p1__39207_SHARP_){
return action.style.borderRight = p1__39207_SHARP_;
});})(seq__39214,chunk__39215,count__39216,i__39217,sl,leftOffset_39220,action,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_39220)),cljs.core.str("px")].join('');
});})(seq__39214,chunk__39215,count__39216,i__39217,leftOffset_39220,action,actions,sg_viewport))
);

var G__39221 = seq__39214;
var G__39222 = chunk__39215;
var G__39223 = count__39216;
var G__39224 = (i__39217 + (1));
seq__39214 = G__39221;
chunk__39215 = G__39222;
count__39216 = G__39223;
i__39217 = G__39224;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__39214);
if(temp__4657__auto__){
var seq__39214__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39214__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__39214__$1);
var G__39225 = cljs.core.chunk_rest(seq__39214__$1);
var G__39226 = c__7220__auto__;
var G__39227 = cljs.core.count(c__7220__auto__);
var G__39228 = (0);
seq__39214 = G__39225;
chunk__39215 = G__39226;
count__39216 = G__39227;
i__39217 = G__39228;
continue;
} else {
var action = cljs.core.first(seq__39214__$1);
var leftOffset_39229 = (function (){var G__39219 = action.offsetLeft;
return parseInt(G__39219);
})();
sg_viewport.addEventListener("scroll",((function (seq__39214,chunk__39215,count__39216,i__39217,leftOffset_39229,action,seq__39214__$1,temp__4657__auto__,actions,sg_viewport){
return (function (){
var sl = sg_viewport.scrollLeft;
var set_border_BANG_ = ((function (seq__39214,chunk__39215,count__39216,i__39217,sl,leftOffset_39229,action,seq__39214__$1,temp__4657__auto__,actions,sg_viewport){
return (function (p1__39207_SHARP_){
return action.style.borderRight = p1__39207_SHARP_;
});})(seq__39214,chunk__39215,count__39216,i__39217,sl,leftOffset_39229,action,seq__39214__$1,temp__4657__auto__,actions,sg_viewport))
;
if((sl === (0))){
set_border_BANG_("1px dotted #ededed");
} else {
set_border_BANG_("1px solid silver");
}

return action.style.left = [cljs.core.str((sl + leftOffset_39229)),cljs.core.str("px")].join('');
});})(seq__39214,chunk__39215,count__39216,i__39217,leftOffset_39229,action,seq__39214__$1,temp__4657__auto__,actions,sg_viewport))
);

var G__39230 = cljs.core.next(seq__39214__$1);
var G__39231 = null;
var G__39232 = (0);
var G__39233 = (0);
seq__39214 = G__39230;
chunk__39215 = G__39231;
count__39216 = G__39232;
i__39217 = G__39233;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__39252(s__39253){
return (new cljs.core.LazySeq(null,(function (){
var s__39253__$1 = s__39253;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39253__$1);
if(temp__4657__auto__){
var s__39253__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39253__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39253__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39255 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39254 = (0);
while(true){
if((i__39254 < size__7188__auto__)){
var vec__39264 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39254);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39264,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39264,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__39255,event.subscribe(handler_function));

var G__39270 = (i__39254 + (1));
i__39254 = G__39270;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39255),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__39252(cljs.core.chunk_rest(s__39253__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39255),null);
}
} else {
var vec__39267 = cljs.core.first(s__39253__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39267,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39267,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__39252(cljs.core.rest(s__39253__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__39289(s__39290){
return (new cljs.core.LazySeq(null,(function (){
var s__39290__$1 = s__39290;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39290__$1);
if(temp__4657__auto__){
var s__39290__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39290__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39290__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39292 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39291 = (0);
while(true){
if((i__39291 < size__7188__auto__)){
var vec__39301 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39291);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39301,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39301,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__39292,event.subscribe(handler_function));

var G__39307 = (i__39291 + (1));
i__39291 = G__39307;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39292),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__39289(cljs.core.chunk_rest(s__39290__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39292),null);
}
} else {
var vec__39304 = cljs.core.first(s__39290__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39304,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39304,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__39289(cljs.core.rest(s__39290__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__39308){
var map__39318 = p__39308;
var map__39318__$1 = ((((!((map__39318 == null)))?((((map__39318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39318):map__39318);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39318__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39318__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,true,current_language,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
var map__39320 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__39320__$1 = ((((!((map__39320 == null)))?((((map__39320.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39320.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39320):map__39320);
var map__39321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39320__$1,cljs.core.cst$kw$table_DASH_page);
var map__39321__$1 = ((((!((map__39321 == null)))?((((map__39321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39321):map__39321);
var map__39322 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39321__$1,cljs.core.cst$kw$paging);
var map__39322__$1 = ((((!((map__39322 == null)))?((((map__39322.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39322.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39322):map__39322);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39322__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39322__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__39326 = elem.getAttribute("data-id");
return parseInt(G__39326);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(columns,SlickGrid,DataView,dataview,grid,map__39320,map__39320__$1,map__39321,map__39321__$1,map__39322,map__39322__$1,num_displayed_records,total_page_count,map__39318,map__39318__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,event_chan){
return (function (state_39588){
var state_val_39589 = (state_39588[(1)]);
if((state_val_39589 === (7))){
var inst_39497 = (state_39588[(7)]);
var inst_39497__$1 = (state_39588[(2)]);
var inst_39499 = (inst_39497__$1 == null);
var inst_39500 = cljs.core.not(inst_39499);
var state_39588__$1 = (function (){var statearr_39590 = state_39588;
(statearr_39590[(7)] = inst_39497__$1);

return statearr_39590;
})();
if(inst_39500){
var statearr_39591_39658 = state_39588__$1;
(statearr_39591_39658[(1)] = (8));

} else {
var statearr_39592_39659 = state_39588__$1;
(statearr_39592_39659[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (20))){
var inst_39519 = (state_39588[(8)]);
var inst_39527 = (state_39588[(9)]);
var inst_39536 = (inst_39527.cljs$core$IFn$_invoke$arity$1 ? inst_39527.cljs$core$IFn$_invoke$arity$1(inst_39519) : inst_39527.call(null,inst_39519));
var state_39588__$1 = state_39588;
var statearr_39593_39660 = state_39588__$1;
(statearr_39593_39660[(2)] = inst_39536);

(statearr_39593_39660[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (27))){
var state_39588__$1 = state_39588;
var statearr_39594_39661 = state_39588__$1;
(statearr_39594_39661[(2)] = null);

(statearr_39594_39661[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (1))){
var state_39588__$1 = state_39588;
var statearr_39595_39662 = state_39588__$1;
(statearr_39595_39662[(2)] = null);

(statearr_39595_39662[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (24))){
var state_39588__$1 = state_39588;
var statearr_39596_39663 = state_39588__$1;
(statearr_39596_39663[(2)] = null);

(statearr_39596_39663[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (4))){
var state_39588__$1 = state_39588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39588__$1,(7),event_chan);
} else {
if((state_val_39589 === (15))){
var inst_39497 = (state_39588[(7)]);
var state_39588__$1 = state_39588;
var statearr_39597_39664 = state_39588__$1;
(statearr_39597_39664[(2)] = inst_39497);

(statearr_39597_39664[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (21))){
var state_39588__$1 = state_39588;
var statearr_39598_39665 = state_39588__$1;
(statearr_39598_39665[(2)] = null);

(statearr_39598_39665[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (31))){
var inst_39523 = (state_39588[(10)]);
var inst_39561 = (state_39588[(2)]);
var inst_39562 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39523,cljs.core.cst$kw$table);
var state_39588__$1 = (function (){var statearr_39599 = state_39588;
(statearr_39599[(11)] = inst_39561);

return statearr_39599;
})();
if(inst_39562){
var statearr_39600_39666 = state_39588__$1;
(statearr_39600_39666[(1)] = (32));

} else {
var statearr_39601_39667 = state_39588__$1;
(statearr_39601_39667[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (32))){
var inst_39522 = (state_39588[(12)]);
var inst_39520 = (state_39588[(13)]);
var inst_39523 = (state_39588[(10)]);
var inst_39519 = (state_39588[(8)]);
var inst_39521 = (state_39588[(14)]);
var inst_39527 = (state_39588[(9)]);
var inst_39517 = (state_39588[(15)]);
var inst_39528 = (state_39588[(16)]);
var inst_39497 = (state_39588[(7)]);
var inst_39518 = (state_39588[(17)]);
var inst_39575 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_39576 = (function (){var new_columns = inst_39522;
var submission_clicked = inst_39519;
var submission_unclicked = inst_39520;
var get_submission_data = inst_39528;
var re_render = inst_39523;
var update_data_BANG_ = inst_39527;
var map__39495 = inst_39517;
var c__12139__auto____$1 = inst_39575;
var submission_to_rank = inst_39518;
var e = inst_39497;
var filter_by = inst_39521;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__39495,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39528,inst_39497,inst_39518,inst_39575,state_val_39589,c__12139__auto__,event_chan){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__39495,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39528,inst_39497,inst_39518,inst_39575,state_val_39589,c__12139__auto__,event_chan){
return (function (state_39573){
var state_val_39574 = (state_39573[(1)]);
if((state_val_39574 === (1))){
var inst_39564 = cljs.core.async.timeout((20));
var state_39573__$1 = state_39573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39573__$1,(2),inst_39564);
} else {
if((state_val_39574 === (2))){
var inst_39566 = (state_39573[(2)]);
var inst_39567 = grid.resizeCanvas();
var inst_39568 = grid.invalidateAllRows();
var inst_39569 = hatti.views.table.resizeColumns(grid);
var inst_39570 = grid.render();
var inst_39571 = hatti.views.table.init_sg_pager(grid,dataview);
var state_39573__$1 = (function (){var statearr_39602 = state_39573;
(statearr_39602[(7)] = inst_39567);

(statearr_39602[(8)] = inst_39566);

(statearr_39602[(9)] = inst_39570);

(statearr_39602[(10)] = inst_39568);

(statearr_39602[(11)] = inst_39569);

return statearr_39602;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39573__$1,inst_39571);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__39495,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39528,inst_39497,inst_39518,inst_39575,state_val_39589,c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__39495,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39528,inst_39497,inst_39518,inst_39575,state_val_39589,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_39606 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39606[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_39606[(1)] = (1));

return statearr_39606;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_39573){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_39573);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e39607){if((e39607 instanceof Object)){
var ex__12031__auto__ = e39607;
var statearr_39608_39668 = state_39573;
(statearr_39608_39668[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39573);

return cljs.core.cst$kw$recur;
} else {
throw e39607;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__39669 = state_39573;
state_39573 = G__39669;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_39573){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_39573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__39495,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39528,inst_39497,inst_39518,inst_39575,state_val_39589,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_39609 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_39609[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto____$1);

return statearr_39609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__39495,c__12139__auto____$1,submission_to_rank,e,filter_by,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39528,inst_39497,inst_39518,inst_39575,state_val_39589,c__12139__auto__,event_chan))
})();
var inst_39577 = cljs.core.async.impl.dispatch.run(inst_39576);
var state_39588__$1 = (function (){var statearr_39610 = state_39588;
(statearr_39610[(18)] = inst_39577);

return statearr_39610;
})();
var statearr_39611_39670 = state_39588__$1;
(statearr_39611_39670[(2)] = inst_39575);

(statearr_39611_39670[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (33))){
var state_39588__$1 = state_39588;
var statearr_39612_39671 = state_39588__$1;
(statearr_39612_39671[(2)] = null);

(statearr_39612_39671[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (13))){
var inst_39509 = (state_39588[(2)]);
var state_39588__$1 = state_39588;
var statearr_39613_39672 = state_39588__$1;
(statearr_39613_39672[(2)] = inst_39509);

(statearr_39613_39672[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (22))){
var inst_39520 = (state_39588[(13)]);
var inst_39539 = (state_39588[(2)]);
var state_39588__$1 = (function (){var statearr_39614 = state_39588;
(statearr_39614[(19)] = inst_39539);

return statearr_39614;
})();
if(cljs.core.truth_(inst_39520)){
var statearr_39615_39673 = state_39588__$1;
(statearr_39615_39673[(1)] = (23));

} else {
var statearr_39616_39674 = state_39588__$1;
(statearr_39616_39674[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (29))){
var inst_39521 = (state_39588[(14)]);
var inst_39553 = [cljs.core.cst$kw$query];
var inst_39554 = [inst_39521];
var inst_39555 = cljs.core.PersistentHashMap.fromArrays(inst_39553,inst_39554);
var inst_39556 = cljs.core.clj__GT_js(inst_39555);
var inst_39557 = dataview.setFilterArgs(inst_39556);
var inst_39558 = dataview.refresh();
var state_39588__$1 = (function (){var statearr_39617 = state_39588;
(statearr_39617[(20)] = inst_39557);

return statearr_39617;
})();
var statearr_39618_39675 = state_39588__$1;
(statearr_39618_39675[(2)] = inst_39558);

(statearr_39618_39675[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (6))){
var inst_39584 = (state_39588[(2)]);
var state_39588__$1 = state_39588;
var statearr_39619_39676 = state_39588__$1;
(statearr_39619_39676[(2)] = inst_39584);

(statearr_39619_39676[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (28))){
var inst_39521 = (state_39588[(14)]);
var inst_39551 = (state_39588[(2)]);
var state_39588__$1 = (function (){var statearr_39620 = state_39588;
(statearr_39620[(21)] = inst_39551);

return statearr_39620;
})();
if(cljs.core.truth_(inst_39521)){
var statearr_39621_39677 = state_39588__$1;
(statearr_39621_39677[(1)] = (29));

} else {
var statearr_39622_39678 = state_39588__$1;
(statearr_39622_39678[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (25))){
var inst_39522 = (state_39588[(12)]);
var inst_39544 = (state_39588[(2)]);
var state_39588__$1 = (function (){var statearr_39623 = state_39588;
(statearr_39623[(22)] = inst_39544);

return statearr_39623;
})();
if(cljs.core.truth_(inst_39522)){
var statearr_39624_39679 = state_39588__$1;
(statearr_39624_39679[(1)] = (26));

} else {
var statearr_39625_39680 = state_39588__$1;
(statearr_39625_39680[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (34))){
var inst_39580 = (state_39588[(2)]);
var state_39588__$1 = (function (){var statearr_39626 = state_39588;
(statearr_39626[(23)] = inst_39580);

return statearr_39626;
})();
var statearr_39627_39681 = state_39588__$1;
(statearr_39627_39681[(2)] = null);

(statearr_39627_39681[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (17))){
var inst_39527 = (state_39588[(9)]);
var inst_39528 = (state_39588[(16)]);
var inst_39518 = (state_39588[(17)]);
var inst_39530 = (inst_39528.cljs$core$IFn$_invoke$arity$2 ? inst_39528.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_39518) : inst_39528.call(null,hatti.constants._rank,inst_39518));
var inst_39531 = (inst_39527.cljs$core$IFn$_invoke$arity$1 ? inst_39527.cljs$core$IFn$_invoke$arity$1(inst_39530) : inst_39527.call(null,inst_39530));
var state_39588__$1 = state_39588;
var statearr_39628_39682 = state_39588__$1;
(statearr_39628_39682[(2)] = inst_39531);

(statearr_39628_39682[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (3))){
var inst_39586 = (state_39588[(2)]);
var state_39588__$1 = state_39588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39588__$1,inst_39586);
} else {
if((state_val_39589 === (12))){
var state_39588__$1 = state_39588;
var statearr_39629_39683 = state_39588__$1;
(statearr_39629_39683[(2)] = false);

(statearr_39629_39683[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (2))){
var state_39588__$1 = state_39588;
var statearr_39630_39684 = state_39588__$1;
(statearr_39630_39684[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (23))){
var inst_39527 = (state_39588[(9)]);
var inst_39541 = (inst_39527.cljs$core$IFn$_invoke$arity$1 ? inst_39527.cljs$core$IFn$_invoke$arity$1(null) : inst_39527.call(null,null));
var state_39588__$1 = state_39588;
var statearr_39632_39685 = state_39588__$1;
(statearr_39632_39685[(2)] = inst_39541);

(statearr_39632_39685[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (19))){
var inst_39519 = (state_39588[(8)]);
var inst_39534 = (state_39588[(2)]);
var state_39588__$1 = (function (){var statearr_39633 = state_39588;
(statearr_39633[(24)] = inst_39534);

return statearr_39633;
})();
if(cljs.core.truth_(inst_39519)){
var statearr_39634_39686 = state_39588__$1;
(statearr_39634_39686[(1)] = (20));

} else {
var statearr_39635_39687 = state_39588__$1;
(statearr_39635_39687[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (11))){
var state_39588__$1 = state_39588;
var statearr_39636_39688 = state_39588__$1;
(statearr_39636_39688[(2)] = true);

(statearr_39636_39688[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (9))){
var state_39588__$1 = state_39588;
var statearr_39637_39689 = state_39588__$1;
(statearr_39637_39689[(2)] = false);

(statearr_39637_39689[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (5))){
var state_39588__$1 = state_39588;
var statearr_39638_39690 = state_39588__$1;
(statearr_39638_39690[(2)] = null);

(statearr_39638_39690[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (14))){
var inst_39497 = (state_39588[(7)]);
var inst_39514 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39497);
var state_39588__$1 = state_39588;
var statearr_39639_39691 = state_39588__$1;
(statearr_39639_39691[(2)] = inst_39514);

(statearr_39639_39691[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (26))){
var inst_39522 = (state_39588[(12)]);
var inst_39546 = grid.setColumns(inst_39522);
var inst_39547 = hatti.views.table.resizeColumns(grid);
var inst_39548 = grid.render();
var state_39588__$1 = (function (){var statearr_39640 = state_39588;
(statearr_39640[(25)] = inst_39547);

(statearr_39640[(26)] = inst_39546);

return statearr_39640;
})();
var statearr_39641_39692 = state_39588__$1;
(statearr_39641_39692[(2)] = inst_39548);

(statearr_39641_39692[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (16))){
var inst_39522 = (state_39588[(12)]);
var inst_39520 = (state_39588[(13)]);
var inst_39523 = (state_39588[(10)]);
var inst_39519 = (state_39588[(8)]);
var inst_39521 = (state_39588[(14)]);
var inst_39527 = (state_39588[(9)]);
var inst_39517 = (state_39588[(15)]);
var inst_39497 = (state_39588[(7)]);
var inst_39518 = (state_39588[(17)]);
var inst_39517__$1 = (state_39588[(2)]);
var inst_39518__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39517__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_39519__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39517__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_39520__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39517__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_39521__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39517__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_39522__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39517__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_39523__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39517__$1,cljs.core.cst$kw$re_DASH_render);
var inst_39524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39525 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_39526 = (new cljs.core.PersistentVector(null,3,(5),inst_39524,inst_39525,null));
var inst_39527__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_39526);
var inst_39528 = (function (){var e = inst_39497;
var map__39495 = inst_39517__$1;
var submission_to_rank = inst_39518__$1;
var submission_clicked = inst_39519__$1;
var submission_unclicked = inst_39520__$1;
var filter_by = inst_39521__$1;
var new_columns = inst_39522__$1;
var re_render = inst_39523__$1;
var update_data_BANG_ = inst_39527__$1;
return ((function (e,map__39495,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39497,inst_39518,inst_39517__$1,inst_39518__$1,inst_39519__$1,inst_39520__$1,inst_39521__$1,inst_39522__$1,inst_39523__$1,inst_39524,inst_39525,inst_39526,inst_39527__$1,state_val_39589,c__12139__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (e,map__39495,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39497,inst_39518,inst_39517__$1,inst_39518__$1,inst_39519__$1,inst_39520__$1,inst_39521__$1,inst_39522__$1,inst_39523__$1,inst_39524,inst_39525,inst_39526,inst_39527__$1,state_val_39589,c__12139__auto__,event_chan){
return (function (p1__39327_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__39327_SHARP_,field));
});})(e,map__39495,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39497,inst_39518,inst_39517__$1,inst_39518__$1,inst_39519__$1,inst_39520__$1,inst_39521__$1,inst_39522__$1,inst_39523__$1,inst_39524,inst_39525,inst_39526,inst_39527__$1,state_val_39589,c__12139__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(e,map__39495,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_39522,inst_39520,inst_39523,inst_39519,inst_39521,inst_39527,inst_39517,inst_39497,inst_39518,inst_39517__$1,inst_39518__$1,inst_39519__$1,inst_39520__$1,inst_39521__$1,inst_39522__$1,inst_39523__$1,inst_39524,inst_39525,inst_39526,inst_39527__$1,state_val_39589,c__12139__auto__,event_chan))
})();
var state_39588__$1 = (function (){var statearr_39642 = state_39588;
(statearr_39642[(12)] = inst_39522__$1);

(statearr_39642[(13)] = inst_39520__$1);

(statearr_39642[(10)] = inst_39523__$1);

(statearr_39642[(8)] = inst_39519__$1);

(statearr_39642[(14)] = inst_39521__$1);

(statearr_39642[(9)] = inst_39527__$1);

(statearr_39642[(15)] = inst_39517__$1);

(statearr_39642[(16)] = inst_39528);

(statearr_39642[(17)] = inst_39518__$1);

return statearr_39642;
})();
if(cljs.core.truth_(inst_39518__$1)){
var statearr_39643_39693 = state_39588__$1;
(statearr_39643_39693[(1)] = (17));

} else {
var statearr_39644_39694 = state_39588__$1;
(statearr_39644_39694[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (30))){
var state_39588__$1 = state_39588;
var statearr_39645_39695 = state_39588__$1;
(statearr_39645_39695[(2)] = null);

(statearr_39645_39695[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (10))){
var inst_39512 = (state_39588[(2)]);
var state_39588__$1 = state_39588;
if(cljs.core.truth_(inst_39512)){
var statearr_39646_39696 = state_39588__$1;
(statearr_39646_39696[(1)] = (14));

} else {
var statearr_39647_39697 = state_39588__$1;
(statearr_39647_39697[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (18))){
var state_39588__$1 = state_39588;
var statearr_39648_39698 = state_39588__$1;
(statearr_39648_39698[(2)] = null);

(statearr_39648_39698[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39589 === (8))){
var inst_39497 = (state_39588[(7)]);
var inst_39502 = inst_39497.cljs$lang$protocol_mask$partition0$;
var inst_39503 = (inst_39502 & (64));
var inst_39504 = inst_39497.cljs$core$ISeq$;
var inst_39505 = (inst_39503) || (inst_39504);
var state_39588__$1 = state_39588;
if(cljs.core.truth_(inst_39505)){
var statearr_39649_39699 = state_39588__$1;
(statearr_39649_39699[(1)] = (11));

} else {
var statearr_39650_39700 = state_39588__$1;
(statearr_39650_39700[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,event_chan))
;
return ((function (switch__12027__auto__,c__12139__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____0 = (function (){
var statearr_39654 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39654[(0)] = hatti$views$table$handle_table_events_$_state_machine__12028__auto__);

(statearr_39654[(1)] = (1));

return statearr_39654;
});
var hatti$views$table$handle_table_events_$_state_machine__12028__auto____1 = (function (state_39588){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_39588);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e39655){if((e39655 instanceof Object)){
var ex__12031__auto__ = e39655;
var statearr_39656_39701 = state_39588;
(statearr_39656_39701[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39588);

return cljs.core.cst$kw$recur;
} else {
throw e39655;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__39702 = state_39588;
state_39588 = G__39702;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12028__auto__ = function(state_39588){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12028__auto____1.call(this,state_39588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12028__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,event_chan))
})();
var state__12141__auto__ = (function (){var statearr_39657 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_39657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_39657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,event_chan))
);

return c__12139__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39721(s__39722){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39722__$1 = s__39722;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39722__$1);
if(temp__4657__auto__){
var s__39722__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39722__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39722__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39724 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39723 = (0);
while(true){
if((i__39723 < size__7188__auto__)){
var vec__39733 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39723);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39733,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39733,(1),null);
cljs.core.chunk_append(b__39724,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39723,vec__39733,k,v,c__7187__auto__,size__7188__auto__,b__39724,s__39722__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39723,vec__39733,k,v,c__7187__auto__,size__7188__auto__,b__39724,s__39722__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39739 = (i__39723 + (1));
i__39723 = G__39739;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39724),hatti$views$table$render_options_$_iter__39721(cljs.core.chunk_rest(s__39722__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39724),null);
}
} else {
var vec__39736 = cljs.core.first(s__39722__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39736,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39736,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39736,k,v,s__39722__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39736,k,v,s__39722__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39721(cljs.core.rest(s__39722__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39741 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39741 = (function (_,owner,meta39742){
this._ = _;
this.owner = owner;
this.meta39742 = meta39742;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39741.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39743,meta39742__$1){
var self__ = this;
var _39743__$1 = this;
return (new hatti.views.table.t_hatti$views$table39741(self__._,self__.owner,meta39742__$1));
});

hatti.views.table.t_hatti$views$table39741.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39743){
var self__ = this;
var _39743__$1 = this;
return self__.meta39742;
});

hatti.views.table.t_hatti$views$table39741.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39741.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39741.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39741.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39744){
var self__ = this;
var map__39745 = p__39744;
var map__39745__$1 = ((((!((map__39745 == null)))?((((map__39745.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39745.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39745):map__39745);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39745__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39745__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39747 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39747__$1 = ((((!((map__39747 == null)))?((((map__39747.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39747.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39747):map__39747);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39747__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__39747,map__39747__$1,flat_form,new_language,___$2,map__39745,map__39745__$1,name_or_label,language){
return (function (p1__39740_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns(flat_form,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39740_SHARP_),new_language)], null));
});})(options,map__39747,map__39747__$1,flat_form,new_language,___$2,map__39745,map__39745__$1,name_or_label,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__39756 = ({"className": "label-changer"});
var G__39757 = (function (){var G__39759 = ({"className": "label-changer-label"});
var G__39760 = "Show:";
return React.DOM.span(G__39759,G__39760);
})();
var G__39758 = (function (){var G__39761 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39762 = (function (){var attrs39751 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39751))?sablono.interpreter.attributes(attrs39751):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39751))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39764 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39764);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39751),(function (){var G__39765 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39765);
})()], null))));
})();
var G__39763 = (function (){var G__39766 = ({"className": "submenu no-dot"});
var G__39767 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__39766,G__39767);
})();
return React.DOM.div(G__39761,G__39762,G__39763);
})();
return React.DOM.div(G__39756,G__39757,G__39758);
});

hatti.views.table.t_hatti$views$table39741.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39742], null);
});

hatti.views.table.t_hatti$views$table39741.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39741.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39741";

hatti.views.table.t_hatti$views$table39741.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39741");
});

hatti.views.table.__GT_t_hatti$views$table39741 = (function hatti$views$table$__GT_t_hatti$views$table39741(___$1,owner__$1,meta39742){
return (new hatti.views.table.t_hatti$views$table39741(___$1,owner__$1,meta39742));
});

}

return (new hatti.views.table.t_hatti$views$table39741(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,query){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,query){
return (function (state_39810){
var state_val_39811 = (state_39810[(1)]);
if((state_val_39811 === (1))){
var inst_39796 = cljs.core.async.timeout((150));
var state_39810__$1 = state_39810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39810__$1,(2),inst_39796);
} else {
if((state_val_39811 === (2))){
var inst_39798 = (state_39810[(2)]);
var inst_39799 = input.value;
var inst_39800 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39799);
var state_39810__$1 = (function (){var statearr_39812 = state_39810;
(statearr_39812[(7)] = inst_39798);

return statearr_39812;
})();
if(inst_39800){
var statearr_39813_39824 = state_39810__$1;
(statearr_39813_39824[(1)] = (3));

} else {
var statearr_39814_39825 = state_39810__$1;
(statearr_39814_39825[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39811 === (3))){
var inst_39802 = [query_event_key];
var inst_39803 = [query];
var inst_39804 = cljs.core.PersistentHashMap.fromArrays(inst_39802,inst_39803);
var inst_39805 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39804);
var state_39810__$1 = state_39810;
var statearr_39815_39826 = state_39810__$1;
(statearr_39815_39826[(2)] = inst_39805);

(statearr_39815_39826[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39811 === (4))){
var state_39810__$1 = state_39810;
var statearr_39816_39827 = state_39810__$1;
(statearr_39816_39827[(2)] = null);

(statearr_39816_39827[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39811 === (5))){
var inst_39808 = (state_39810[(2)]);
var state_39810__$1 = state_39810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39810__$1,inst_39808);
} else {
return null;
}
}
}
}
}
});})(c__12139__auto__,query))
;
return ((function (switch__12027__auto__,c__12139__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12028__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12028__auto____0 = (function (){
var statearr_39820 = [null,null,null,null,null,null,null,null];
(statearr_39820[(0)] = hatti$views$table$delayed_search_$_state_machine__12028__auto__);

(statearr_39820[(1)] = (1));

return statearr_39820;
});
var hatti$views$table$delayed_search_$_state_machine__12028__auto____1 = (function (state_39810){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_39810);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e39821){if((e39821 instanceof Object)){
var ex__12031__auto__ = e39821;
var statearr_39822_39828 = state_39810;
(statearr_39822_39828[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39810);

return cljs.core.cst$kw$recur;
} else {
throw e39821;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__39829 = state_39810;
state_39810 = G__39829;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12028__auto__ = function(state_39810){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12028__auto____1.call(this,state_39810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12028__auto____0;
hatti$views$table$delayed_search_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12028__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,query))
})();
var state__12141__auto__ = (function (){var statearr_39823 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_39823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_39823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,query))
);

return c__12139__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39831 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39831 = (function (_,owner,meta39832){
this._ = _;
this.owner = owner;
this.meta39832 = meta39832;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39831.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39833,meta39832__$1){
var self__ = this;
var _39833__$1 = this;
return (new hatti.views.table.t_hatti$views$table39831(self__._,self__.owner,meta39832__$1));
});

hatti.views.table.t_hatti$views$table39831.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39833){
var self__ = this;
var _39833__$1 = this;
return self__.meta39832;
});

hatti.views.table.t_hatti$views$table39831.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39831.prototype.om$core$IRender$render$arity$1 = (function (this__17298__auto__){
var self__ = this;
var this__17298__auto____$1 = this;
var G__39836 = ({"className": "table-search"});
var G__39837 = (function (){var G__39839 = ({"className": "fa fa-search"});
return React.DOM.i(G__39839);
})();
var G__39838 = (function (){var G__39840 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39836,G__39837,this__17298__auto____$1){
return (function (p1__39830_SHARP_){
return hatti.views.table.delayed_search(p1__39830_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39836,G__39837,this__17298__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39840) : sablono.interpreter.input.call(null,G__39840));
})();
return React.DOM.div(G__39836,G__39837,G__39838);
});

hatti.views.table.t_hatti$views$table39831.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39832], null);
});

hatti.views.table.t_hatti$views$table39831.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39831.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39831";

hatti.views.table.t_hatti$views$table39831.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39831");
});

hatti.views.table.__GT_t_hatti$views$table39831 = (function hatti$views$table$__GT_t_hatti$views$table39831(___$1,owner__$1,meta39832){
return (new hatti.views.table.t_hatti$views$table39831(___$1,owner__$1,meta39832));
});

}

return (new hatti.views.table.t_hatti$views$table39831(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner){
if(typeof hatti.views.table.t_hatti$views$table39841 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39841 = (function (app_state,owner,meta39842){
this.app_state = app_state;
this.owner = owner;
this.meta39842 = meta39842;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39841.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39843,meta39842__$1){
var self__ = this;
var _39843__$1 = this;
return (new hatti.views.table.t_hatti$views$table39841(self__.app_state,self__.owner,meta39842__$1));
});

hatti.views.table.t_hatti$views$table39841.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39843){
var self__ = this;
var _39843__$1 = this;
return self__.meta39842;
});

hatti.views.table.t_hatti$views$table39841.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39841.prototype.om$core$IRender$render$arity$1 = (function (this__17298__auto__){
var self__ = this;
var this__17298__auto____$1 = this;
var G__39846 = ({"className": "topbar"});
var G__39847 = (function (){var G__39851 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39851);
})();
var G__39848 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,null));
var G__39849 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.app_state));
var G__39850 = (function (){var G__39852 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39852);
})();
return React.DOM.div(G__39846,G__39847,G__39848,G__39849,G__39850);
});

hatti.views.table.t_hatti$views$table39841.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39842], null);
});

hatti.views.table.t_hatti$views$table39841.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39841.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39841";

hatti.views.table.t_hatti$views$table39841.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39841");
});

hatti.views.table.__GT_t_hatti$views$table39841 = (function hatti$views$table$__GT_t_hatti$views$table39841(app_state__$1,owner__$1,meta39842){
return (new hatti.views.table.t_hatti$views$table39841(app_state__$1,owner__$1,meta39842));
});

}

return (new hatti.views.table.t_hatti$views$table39841(app_state,owner,null));
}));
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){

if(cljs.core.seq(data)){
var map__39858 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39858__$1 = ((((!((map__39858 == null)))?((((map__39858.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39858.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39858):map__39858);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39858__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39858__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39859 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39859,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39859,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39864,owner,p__39865){
var map__39866 = p__39864;
var map__39866__$1 = ((((!((map__39866 == null)))?((((map__39866.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39866.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39866):map__39866);
var app_state = map__39866__$1;
var map__39867 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39866__$1,cljs.core.cst$kw$views);
var map__39867__$1 = ((((!((map__39867 == null)))?((((map__39867.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39867.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39867):map__39867);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39867__$1,cljs.core.cst$kw$active);
var map__39868 = p__39865;
var map__39868__$1 = ((((!((map__39868 == null)))?((((map__39868.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39868.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39868):map__39868);
var opts = map__39868__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39868__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39872 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39872 = (function (owner,active_QMARK_,map__39867,p__39865,slick_grid_event_handlers,map__39866,app_state,active,map__39868,p__39864,opts,meta39873){
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.map__39867 = map__39867;
this.p__39865 = p__39865;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__39866 = map__39866;
this.app_state = app_state;
this.active = active;
this.map__39868 = map__39868;
this.p__39864 = p__39864;
this.opts = opts;
this.meta39873 = meta39873;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39872.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (_39874,meta39873__$1){
var self__ = this;
var _39874__$1 = this;
return (new hatti.views.table.t_hatti$views$table39872(self__.owner,self__.active_QMARK_,self__.map__39867,self__.p__39865,self__.slick_grid_event_handlers,self__.map__39866,self__.app_state,self__.active,self__.map__39868,self__.p__39864,self__.opts,meta39873__$1));
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39872.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (_39874){
var self__ = this;
var _39874__$1 = this;
return self__.meta39873;
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39872.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39872.prototype.om$core$IRender$render$arity$1 = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
var no_data_QMARK_ = cljs.core.empty_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null)));
var map__39875 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state);
var map__39875__$1 = ((((!((map__39875 == null)))?((((map__39875.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39875.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39875):map__39875);
var dataset_info = map__39875__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39875__$1,cljs.core.cst$kw$num_of_submissions);
var with_info = ((function (no_data_QMARK_,map__39875,map__39875__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (p1__39863_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__39863_SHARP_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dataset_DASH_info,dataset_info], null)], 0));
});})(no_data_QMARK_,map__39875,map__39875__$1,dataset_info,num_of_submissions,___$1,active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var attrs39877 = om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked], null))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39877))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["table-view"], null)], null),attrs39877], 0))):({"className": "table-view"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39877))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__39878 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39879 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39884 = ({"className": "empty-state"});
var G__39885 = "No data";
return React.DOM.span(G__39884,G__39885);
})():(function (){var G__39886 = null;
var G__39887 = (function (){var G__39889 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39889);
})();
var G__39888 = "Loading...";
return React.DOM.span(G__39886,G__39887,G__39888);
})());
return React.DOM.div(G__39878,G__39879);
})()], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39877),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.app_state)),(function (){var G__39890 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39891 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39896 = ({"className": "empty-state"});
var G__39897 = "No data";
return React.DOM.span(G__39896,G__39897);
})():(function (){var G__39898 = null;
var G__39899 = (function (){var G__39901 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39901);
})();
var G__39900 = "Loading...";
return React.DOM.span(G__39898,G__39899,G__39900);
})());
return React.DOM.div(G__39890,G__39891);
})()], null))));
} else {
return null;
}
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39872.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39872.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39902 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39902,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39902,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39872.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39872.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39905 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39905__$1 = ((((!((map__39905 == null)))?((((map__39905.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39905.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39905):map__39905);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39905__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39905__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39907 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39907,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39907,(1),null);
return hatti.views.table.handle_table_events(self__.app_state,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39872.getBasis = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$map__39867,cljs.core.cst$sym$p__39865,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__39866,cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$active,cljs.core.cst$sym$map__39868,cljs.core.cst$sym$p__39864,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39873], null);
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39872.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39872.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39872";

hatti.views.table.t_hatti$views$table39872.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39872");
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39872 = ((function (active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39872(owner__$1,active_QMARK___$1,map__39867__$2,p__39865__$1,slick_grid_event_handlers__$1,map__39866__$2,app_state__$1,active__$1,map__39868__$2,p__39864__$1,opts__$1,meta39873){
return (new hatti.views.table.t_hatti$views$table39872(owner__$1,active_QMARK___$1,map__39867__$2,p__39865__$1,slick_grid_event_handlers__$1,map__39866__$2,app_state__$1,active__$1,map__39868__$2,p__39864__$1,opts__$1,meta39873));
});})(active_QMARK_,map__39866,map__39866__$1,app_state,map__39867,map__39867__$1,active,map__39868,map__39868__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39872(owner,active_QMARK_,map__39867__$1,p__39865,slick_grid_event_handlers,map__39866__$1,app_state,active,map__39868__$1,p__39864,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
