// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.scale');
goog.require('cljs.core');
goog.require('c2.maths');

/**
 * @interface
 */
c2.scale.IInvertable = function(){};

/**
 * Inverted scale
 */
c2.scale.invert = (function c2$scale$invert(scale){
if((!((scale == null))) && (!((scale.c2$scale$IInvertable$invert$arity$1 == null)))){
return scale.c2$scale$IInvertable$invert$arity$1(scale);
} else {
var x__7072__auto__ = (((scale == null))?null:scale);
var m__7073__auto__ = (c2.scale.invert[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,scale);
} else {
var m__7073__auto____$1 = (c2.scale.invert["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,scale);
} else {
throw cljs.core.missing_protocol.call(null,"IInvertable.invert",scale);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {c2.scale.IInvertable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._linear = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.call(null,this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k19736,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__19739 = (((k19736 instanceof cljs.core.Keyword))?k19736.fqn:null);
switch (G__19739) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19736,else__7034__auto__);

}
});

c2.scale._linear.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._linear{",", ","}",opts__7047__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IIterable$ = true;

c2.scale._linear.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19735){
var self__ = this;
var G__19735__$1 = this;
return (new cljs.core.RecordIter((0),G__19735__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

c2.scale._linear.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._linear.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap.call(null,this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._linear.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map.call(null,this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._linear.prototype.c2$scale$IInvertable$ = true;

c2.scale._linear.prototype.c2$scale$IInvertable$invert$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"domain","domain",1847214937),self__.range,new cljs.core.Keyword(null,"range","range",1639692286),self__.domain);
});

c2.scale._linear.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__7041__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._linear.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__19735){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__19740 = cljs.core.keyword_identical_QMARK_;
var expr__19741 = k__7039__auto__;
if(cljs.core.truth_(pred__19740.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),expr__19741))){
return (new c2.scale._linear(G__19735,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19740.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__19741))){
return (new c2.scale._linear(self__.domain,G__19735,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7039__auto__,G__19735),null));
}
}
});

c2.scale._linear.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__19735){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,G__19735,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7037__auto__)){
return cljs.core._assoc.call(null,this__7036__auto____$1,cljs.core._nth.call(null,entry__7037__auto__,(0)),cljs.core._nth.call(null,entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._linear.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var domain_length = (cljs.core.last.call(null,self__.domain) - cljs.core.first.call(null,self__.domain));
var range_length = (cljs.core.last.call(null,self__.range) - cljs.core.first.call(null,self__.range));
return (cljs.core.first.call(null,self__.range) + (range_length * ((x - cljs.core.first.call(null,self__.domain)) / domain_length)));
});

c2.scale._linear.prototype.apply = (function (self__,args19738){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args19738)));
});

c2.scale._linear.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
var domain_length = (cljs.core.last.call(null,self__.domain) - cljs.core.first.call(null,self__.domain));
var range_length = (cljs.core.last.call(null,self__.range) - cljs.core.first.call(null,self__.range));
return (cljs.core.first.call(null,self__.range) + (range_length * ((x - cljs.core.first.call(null,self__.domain)) / domain_length)));
});

c2.scale._linear.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain","domain",-807220832,null),new cljs.core.Symbol(null,"range","range",-1014743483,null)], null);
});

c2.scale._linear.cljs$lang$type = true;

c2.scale._linear.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"c2.scale/_linear");
});

c2.scale._linear.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write.call(null,writer__7066__auto__,"c2.scale/_linear");
});

c2.scale.__GT__linear = (function c2$scale$__GT__linear(domain,range){
return (new c2.scale._linear(domain,range,null,null,null));
});

c2.scale.map__GT__linear = (function c2$scale$map__GT__linear(G__19737){
return (new c2.scale._linear(new cljs.core.Keyword(null,"domain","domain",1847214937).cljs$core$IFn$_invoke$arity$1(G__19737),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__19737),null,cljs.core.dissoc.call(null,G__19737,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)),null));
});


c2.scale.linear = (function c2$scale$linear(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19745 = arguments.length;
var i__7485__auto___19746 = (0);
while(true){
if((i__7485__auto___19746 < len__7484__auto___19745)){
args__7491__auto__.push((arguments[i__7485__auto___19746]));

var G__19747 = (i__7485__auto___19746 + (1));
i__7485__auto___19746 = G__19747;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__linear.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.call(null,cljs.core.hash_map,kwargs)));
});

c2.scale.linear.cljs$lang$maxFixedArity = (0);

c2.scale.linear.cljs$lang$applyTo = (function (seq19743){
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19743));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._power = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.call(null,this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k19749,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__19752 = (((k19749 instanceof cljs.core.Keyword))?k19749.fqn:null);
switch (G__19752) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19749,else__7034__auto__);

}
});

c2.scale._power.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._power{",", ","}",opts__7047__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IIterable$ = true;

c2.scale._power.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19748){
var self__ = this;
var G__19748__$1 = this;
return (new cljs.core.RecordIter((0),G__19748__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

c2.scale._power.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._power.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap.call(null,this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._power.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map.call(null,this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._power.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__7041__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._power.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__19748){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__19753 = cljs.core.keyword_identical_QMARK_;
var expr__19754 = k__7039__auto__;
if(cljs.core.truth_(pred__19753.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),expr__19754))){
return (new c2.scale._power(G__19748,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19753.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__19754))){
return (new c2.scale._power(self__.domain,G__19748,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7039__auto__,G__19748),null));
}
}
});

c2.scale._power.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__19748){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,G__19748,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7037__auto__)){
return cljs.core._assoc.call(null,this__7036__auto____$1,cljs.core._nth.call(null,entry__7037__auto__,(0)),cljs.core._nth.call(null,entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._power.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.expt,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.expt).call(null,x);
});

c2.scale._power.prototype.apply = (function (self__,args19751){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args19751)));
});

c2.scale._power.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.expt,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.expt).call(null,x);
});

c2.scale._power.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain","domain",-807220832,null),new cljs.core.Symbol(null,"range","range",-1014743483,null)], null);
});

c2.scale._power.cljs$lang$type = true;

c2.scale._power.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"c2.scale/_power");
});

c2.scale._power.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write.call(null,writer__7066__auto__,"c2.scale/_power");
});

c2.scale.__GT__power = (function c2$scale$__GT__power(domain,range){
return (new c2.scale._power(domain,range,null,null,null));
});

c2.scale.map__GT__power = (function c2$scale$map__GT__power(G__19750){
return (new c2.scale._power(new cljs.core.Keyword(null,"domain","domain",1847214937).cljs$core$IFn$_invoke$arity$1(G__19750),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__19750),null,cljs.core.dissoc.call(null,G__19750,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)),null));
});


c2.scale.power = (function c2$scale$power(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19758 = arguments.length;
var i__7485__auto___19759 = (0);
while(true){
if((i__7485__auto___19759 < len__7484__auto___19758)){
args__7491__auto__.push((arguments[i__7485__auto___19759]));

var G__19760 = (i__7485__auto___19759 + (1));
i__7485__auto___19759 = G__19760;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.power.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__power.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.call(null,cljs.core.hash_map,kwargs)));
});

c2.scale.power.cljs$lang$maxFixedArity = (0);

c2.scale.power.cljs$lang$applyTo = (function (seq19756){
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19756));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._log = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.call(null,this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k19762,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__19765 = (((k19762 instanceof cljs.core.Keyword))?k19762.fqn:null);
switch (G__19765) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19762,else__7034__auto__);

}
});

c2.scale._log.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._log{",", ","}",opts__7047__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IIterable$ = true;

c2.scale._log.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19761){
var self__ = this;
var G__19761__$1 = this;
return (new cljs.core.RecordIter((0),G__19761__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

c2.scale._log.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._log.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap.call(null,this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._log.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map.call(null,this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._log.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),null,new cljs.core.Keyword(null,"range","range",1639692286),null], null), null),k__7041__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._log.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__19761){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__19766 = cljs.core.keyword_identical_QMARK_;
var expr__19767 = k__7039__auto__;
if(cljs.core.truth_(pred__19766.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),expr__19767))){
return (new c2.scale._log(G__19761,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19766.call(null,new cljs.core.Keyword(null,"range","range",1639692286),expr__19767))){
return (new c2.scale._log(self__.domain,G__19761,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7039__auto__,G__19761),null));
}
}
});

c2.scale._log.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"domain","domain",1847214937),self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"range","range",1639692286),self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__19761){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,G__19761,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7037__auto__)){
return cljs.core._assoc.call(null,this__7036__auto____$1,cljs.core._nth.call(null,entry__7037__auto__,(0)),cljs.core._nth.call(null,entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._log.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.log,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.log).call(null,x);
});

c2.scale._log.prototype.apply = (function (self__,args19764){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args19764)));
});

c2.scale._log.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.call(null,c2.scale.linear.call(null,new cljs.core.Keyword(null,"domain","domain",1847214937),cljs.core.map.call(null,c2.maths.log,self__.domain),new cljs.core.Keyword(null,"range","range",1639692286),self__.range),c2.maths.log).call(null,x);
});

c2.scale._log.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"domain","domain",-807220832,null),new cljs.core.Symbol(null,"range","range",-1014743483,null)], null);
});

c2.scale._log.cljs$lang$type = true;

c2.scale._log.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"c2.scale/_log");
});

c2.scale._log.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write.call(null,writer__7066__auto__,"c2.scale/_log");
});

c2.scale.__GT__log = (function c2$scale$__GT__log(domain,range){
return (new c2.scale._log(domain,range,null,null,null));
});

c2.scale.map__GT__log = (function c2$scale$map__GT__log(G__19763){
return (new c2.scale._log(new cljs.core.Keyword(null,"domain","domain",1847214937).cljs$core$IFn$_invoke$arity$1(G__19763),new cljs.core.Keyword(null,"range","range",1639692286).cljs$core$IFn$_invoke$arity$1(G__19763),null,cljs.core.dissoc.call(null,G__19763,new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.Keyword(null,"range","range",1639692286)),null));
});


c2.scale.log = (function c2$scale$log(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19771 = arguments.length;
var i__7485__auto___19772 = (0);
while(true){
if((i__7485__auto___19772 < len__7484__auto___19771)){
args__7491__auto__.push((arguments[i__7485__auto___19772]));

var G__19773 = (i__7485__auto___19772 + (1));
i__7485__auto___19772 = G__19773;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.log.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__log.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"domain","domain",1847214937),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(10)], null),new cljs.core.Keyword(null,"range","range",1639692286),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.call(null,cljs.core.hash_map,kwargs)));
});

c2.scale.log.cljs$lang$maxFixedArity = (0);

c2.scale.log.cljs$lang$applyTo = (function (seq19769){
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19769));
});

