// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__36443(s__36444){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__36444__$1 = s__36444;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36444__$1);
if(temp__4657__auto__){
var s__36444__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36444__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__36444__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__36446 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__36445 = (0);
while(true){
if((i__36445 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__36445);
cljs.core.chunk_append(b__36446,(function (){var iter__7189__auto__ = ((function (i__36445,datum,c__7187__auto__,size__7188__auto__,b__36446,s__36444__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__36443_$_iter__36461(s__36462){
return (new cljs.core.LazySeq(null,((function (i__36445,datum,c__7187__auto__,size__7188__auto__,b__36446,s__36444__$2,temp__4657__auto__,osmfields){
return (function (){
var s__36462__$1 = s__36462;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__36462__$1);
if(temp__4657__auto____$1){
var s__36462__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__36462__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__36462__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__36464 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__36463 = (0);
while(true){
if((i__36463 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__36463);
cljs.core.chunk_append(b__36464,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__36473 = (i__36463 + (1));
i__36463 = G__36473;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36464),hatti$ona$post_process$ona_osm_link_$_iter__36443_$_iter__36461(cljs.core.chunk_rest(s__36462__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36464),null);
}
} else {
var field = cljs.core.first(s__36462__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__36443_$_iter__36461(cljs.core.rest(s__36462__$2)));
}
} else {
return null;
}
break;
}
});})(i__36445,datum,c__7187__auto__,size__7188__auto__,b__36446,s__36444__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__36445,datum,c__7187__auto__,size__7188__auto__,b__36446,s__36444__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__36474 = (i__36445 + (1));
i__36445 = G__36474;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36446),hatti$ona$post_process$ona_osm_link_$_iter__36443(cljs.core.chunk_rest(s__36444__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36446),null);
}
} else {
var datum = cljs.core.first(s__36444__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__36444__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__36443_$_iter__36467(s__36468){
return (new cljs.core.LazySeq(null,((function (datum,s__36444__$2,temp__4657__auto__,osmfields){
return (function (){
var s__36468__$1 = s__36468;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__36468__$1);
if(temp__4657__auto____$1){
var s__36468__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__36468__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__36468__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__36470 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__36469 = (0);
while(true){
if((i__36469 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__36469);
cljs.core.chunk_append(b__36470,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__36475 = (i__36469 + (1));
i__36469 = G__36475;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36470),hatti$ona$post_process$ona_osm_link_$_iter__36443_$_iter__36467(cljs.core.chunk_rest(s__36468__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36470),null);
}
} else {
var field = cljs.core.first(s__36468__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__36443_$_iter__36467(cljs.core.rest(s__36468__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__36444__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__36444__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__36443(cljs.core.rest(s__36444__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__36477 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__36477);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__36501 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__36501) : osmgeo.call(null,G__36501));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__36502(s__36503){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__36503__$1 = s__36503;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36503__$1);
if(temp__4657__auto__){
var s__36503__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36503__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__36503__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__36505 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__36504 = (0);
while(true){
if((i__36504 < size__7188__auto__)){
var map__36516 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__36504);
var map__36516__$1 = ((((!((map__36516 == null)))?((((map__36516.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36516.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36516):map__36516);
var feature = map__36516__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36516__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36516__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36516__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__36505,(function (){var map__36518 = properties;
var map__36518__$1 = ((((!((map__36518 == null)))?((((map__36518.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36518.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36518):map__36518);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36518__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36518__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36518__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__36524 = (i__36504 + (1));
i__36504 = G__36524;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36505),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__36502(cljs.core.chunk_rest(s__36503__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36505),null);
}
} else {
var map__36520 = cljs.core.first(s__36503__$2);
var map__36520__$1 = ((((!((map__36520 == null)))?((((map__36520.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36520.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36520):map__36520);
var feature = map__36520__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36520__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36520__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36520__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__36522 = properties;
var map__36522__$1 = ((((!((map__36522 == null)))?((((map__36522.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36522.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36522):map__36522);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36522__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36522__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36522__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__36502(cljs.core.rest(s__36503__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__36525_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__36525_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__36537(s__36538){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__36538__$1 = s__36538;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36538__$1);
if(temp__4657__auto__){
var s__36538__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36538__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__36538__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__36540 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__36539 = (0);
while(true){
if((i__36539 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__36539);
cljs.core.chunk_append(b__36540,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__36539,osm_id,datum,c__7187__auto__,size__7188__auto__,b__36540,s__36538__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__36526_SHARP_){
return osm_val__GT_osm_data(p1__36526_SHARP_,osm_id);
});})(i__36539,osm_id,datum,c__7187__auto__,size__7188__auto__,b__36540,s__36538__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__36547 = (i__36539 + (1));
i__36539 = G__36547;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36540),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__36537(cljs.core.chunk_rest(s__36538__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36540),null);
}
} else {
var datum = cljs.core.first(s__36538__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__36538__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__36526_SHARP_){
return osm_val__GT_osm_data(p1__36526_SHARP_,osm_id);
});})(osm_id,datum,s__36538__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__36537(cljs.core.rest(s__36538__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__36543 = cljs.core.seq(osm_fields);
var chunk__36544 = null;
var count__36545 = (0);
var i__36546 = (0);
while(true){
if((i__36546 < count__36545)){
var osm_field = chunk__36544.cljs$core$IIndexed$_nth$arity$2(null,i__36546);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__36548 = seq__36543;
var G__36549 = chunk__36544;
var G__36550 = count__36545;
var G__36551 = (i__36546 + (1));
seq__36543 = G__36548;
chunk__36544 = G__36549;
count__36545 = G__36550;
i__36546 = G__36551;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__36543);
if(temp__4657__auto__){
var seq__36543__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__36543__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__36543__$1);
var G__36552 = cljs.core.chunk_rest(seq__36543__$1);
var G__36553 = c__7220__auto__;
var G__36554 = cljs.core.count(c__7220__auto__);
var G__36555 = (0);
seq__36543 = G__36552;
chunk__36544 = G__36553;
count__36545 = G__36554;
i__36546 = G__36555;
continue;
} else {
var osm_field = cljs.core.first(seq__36543__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__36556 = cljs.core.next(seq__36543__$1);
var G__36557 = null;
var G__36558 = (0);
var G__36559 = (0);
seq__36543 = G__36556;
chunk__36544 = G__36557;
count__36545 = G__36558;
i__36546 = G__36559;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments");
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__36560_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__36560_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___36573 = arguments.length;
var i__7485__auto___36574 = (0);
while(true){
if((i__7485__auto___36574 < len__7484__auto___36573)){
args__7491__auto__.push((arguments[i__7485__auto___36574]));

var G__36575 = (i__7485__auto___36574 + (1));
i__7485__auto___36574 = G__36575;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__36564){
var map__36565 = p__36564;
var map__36565__$1 = ((((!((map__36565 == null)))?((((map__36565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36565):map__36565);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36565__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__7189__auto__ = ((function (image_fields,map__36565,map__36565__$1,attachments){
return (function hatti$ona$post_process$iter__36567(s__36568){
return (new cljs.core.LazySeq(null,((function (image_fields,map__36565,map__36565__$1,attachments){
return (function (){
var s__36568__$1 = s__36568;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36568__$1);
if(temp__4657__auto__){
var s__36568__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36568__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__36568__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__36570 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__36569 = (0);
while(true){
if((i__36569 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__36569);
cljs.core.chunk_append(b__36570,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__36569,attach_map,record,c__7187__auto__,size__7188__auto__,b__36570,s__36568__$2,temp__4657__auto__,image_fields,map__36565,map__36565__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__36569,attach_map,record,c__7187__auto__,size__7188__auto__,b__36570,s__36568__$2,temp__4657__auto__,image_fields,map__36565,map__36565__$1,attachments))
,record,image_fields);
})());

var G__36576 = (i__36569 + (1));
i__36569 = G__36576;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36570),hatti$ona$post_process$iter__36567(cljs.core.chunk_rest(s__36568__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36570),null);
}
} else {
var record = cljs.core.first(s__36568__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__36568__$2,temp__4657__auto__,image_fields,map__36565,map__36565__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__36568__$2,temp__4657__auto__,image_fields,map__36565,map__36565__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__36567(cljs.core.rest(s__36568__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__36565,map__36565__$1,attachments))
,null,null));
});})(image_fields,map__36565,map__36565__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq36561){
var G__36562 = cljs.core.first(seq36561);
var seq36561__$1 = cljs.core.next(seq36561);
var G__36563 = cljs.core.first(seq36561__$1);
var seq36561__$2 = cljs.core.next(seq36561__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__36562,G__36563,seq36561__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,"_attachments")], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__36583(s__36584){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__36584__$1 = s__36584;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36584__$1);
if(temp__4657__auto__){
var s__36584__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36584__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__36584__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__36586 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__36585 = (0);
while(true){
if((i__36585 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__36585);
cljs.core.chunk_append(b__36586,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__36589 = (i__36585 + (1));
i__36585 = G__36589;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36586),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__36583(cljs.core.chunk_rest(s__36584__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36586),null);
}
} else {
var record = cljs.core.first(s__36584__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__36583(cljs.core.rest(s__36584__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___36597 = arguments.length;
var i__7485__auto___36598 = (0);
while(true){
if((i__7485__auto___36598 < len__7484__auto___36597)){
args__7491__auto__.push((arguments[i__7485__auto___36598]));

var G__36599 = (i__7485__auto___36598 + (1));
i__7485__auto___36598 = G__36599;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__36594){
var map__36595 = p__36594;
var map__36595__$1 = ((((!((map__36595 == null)))?((((map__36595.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36595.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36595):map__36595);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__36595__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__36595,map__36595__$1,app_data_keys){
return (function (p1__36590_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__36590_SHARP_));
});})(map__36595,map__36595__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq36591){
var G__36592 = cljs.core.first(seq36591);
var seq36591__$1 = cljs.core.next(seq36591);
var G__36593 = cljs.core.first(seq36591__$1);
var seq36591__$2 = cljs.core.next(seq36591__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36592,G__36593,seq36591__$2);
});

