// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12139__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_21168){
var state_val_21169 = (state_21168[(1)]);
if((state_val_21169 === (7))){
var inst_21125 = (state_21168[(7)]);
var inst_21125__$1 = (state_21168[(2)]);
var inst_21127 = (inst_21125__$1 == null);
var inst_21128 = cljs.core.not.call(null,inst_21127);
var state_21168__$1 = (function (){var statearr_21170 = state_21168;
(statearr_21170[(7)] = inst_21125__$1);

return statearr_21170;
})();
if(inst_21128){
var statearr_21171_21208 = state_21168__$1;
(statearr_21171_21208[(1)] = (8));

} else {
var statearr_21172_21209 = state_21168__$1;
(statearr_21172_21209[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (20))){
var inst_21147 = (state_21168[(8)]);
var inst_21155 = (state_21168[(2)]);
var state_21168__$1 = (function (){var statearr_21173 = state_21168;
(statearr_21173[(9)] = inst_21155);

return statearr_21173;
})();
if(cljs.core.truth_(inst_21147)){
var statearr_21174_21210 = state_21168__$1;
(statearr_21174_21210[(1)] = (21));

} else {
var statearr_21175_21211 = state_21168__$1;
(statearr_21175_21211[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (1))){
var state_21168__$1 = state_21168;
var statearr_21176_21212 = state_21168__$1;
(statearr_21176_21212[(2)] = null);

(statearr_21176_21212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (4))){
var state_21168__$1 = state_21168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21168__$1,(7),agg_data_channel);
} else {
if((state_val_21169 === (15))){
var inst_21125 = (state_21168[(7)]);
var state_21168__$1 = state_21168;
var statearr_21177_21213 = state_21168__$1;
(statearr_21177_21213[(2)] = inst_21125);

(statearr_21177_21213[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (21))){
var inst_21157 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_21168__$1 = state_21168;
var statearr_21178_21214 = state_21168__$1;
(statearr_21178_21214[(2)] = inst_21157);

(statearr_21178_21214[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (13))){
var inst_21137 = (state_21168[(2)]);
var state_21168__$1 = state_21168;
var statearr_21179_21215 = state_21168__$1;
(statearr_21179_21215[(2)] = inst_21137);

(statearr_21179_21215[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (22))){
var state_21168__$1 = state_21168;
var statearr_21180_21216 = state_21168__$1;
(statearr_21180_21216[(2)] = null);

(statearr_21180_21216[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (6))){
var inst_21164 = (state_21168[(2)]);
var state_21168__$1 = state_21168;
var statearr_21181_21217 = state_21168__$1;
(statearr_21181_21217[(2)] = inst_21164);

(statearr_21181_21217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (17))){
var inst_21146 = (state_21168[(10)]);
var inst_21147 = (state_21168[(8)]);
var inst_21149 = callback.call(null,inst_21146,inst_21147);
var state_21168__$1 = state_21168;
var statearr_21182_21218 = state_21168__$1;
(statearr_21182_21218[(2)] = inst_21149);

(statearr_21182_21218[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (3))){
var inst_21166 = (state_21168[(2)]);
var state_21168__$1 = state_21168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21168__$1,inst_21166);
} else {
if((state_val_21169 === (12))){
var state_21168__$1 = state_21168;
var statearr_21183_21219 = state_21168__$1;
(statearr_21183_21219[(2)] = false);

(statearr_21183_21219[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (2))){
var state_21168__$1 = state_21168;
var statearr_21184_21220 = state_21168__$1;
(statearr_21184_21220[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (23))){
var inst_21160 = (state_21168[(2)]);
var state_21168__$1 = (function (){var statearr_21186 = state_21168;
(statearr_21186[(11)] = inst_21160);

return statearr_21186;
})();
var statearr_21187_21221 = state_21168__$1;
(statearr_21187_21221[(2)] = null);

(statearr_21187_21221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (19))){
var inst_21152 = (state_21168[(2)]);
var inst_21153 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_21168__$1 = (function (){var statearr_21188 = state_21168;
(statearr_21188[(12)] = inst_21152);

return statearr_21188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21168__$1,(20),inst_21153);
} else {
if((state_val_21169 === (11))){
var state_21168__$1 = state_21168;
var statearr_21189_21222 = state_21168__$1;
(statearr_21189_21222[(2)] = true);

(statearr_21189_21222[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (9))){
var state_21168__$1 = state_21168;
var statearr_21190_21223 = state_21168__$1;
(statearr_21190_21223[(2)] = false);

(statearr_21190_21223[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (5))){
var state_21168__$1 = state_21168;
var statearr_21191_21224 = state_21168__$1;
(statearr_21191_21224[(2)] = null);

(statearr_21191_21224[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (14))){
var inst_21125 = (state_21168[(7)]);
var inst_21142 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21125);
var state_21168__$1 = state_21168;
var statearr_21192_21225 = state_21168__$1;
(statearr_21192_21225[(2)] = inst_21142);

(statearr_21192_21225[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (16))){
var inst_21146 = (state_21168[(10)]);
var inst_21145 = (state_21168[(2)]);
var inst_21146__$1 = cljs.core.get.call(null,inst_21145,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_21147 = cljs.core.get.call(null,inst_21145,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_21168__$1 = (function (){var statearr_21193 = state_21168;
(statearr_21193[(10)] = inst_21146__$1);

(statearr_21193[(8)] = inst_21147);

return statearr_21193;
})();
if(cljs.core.truth_(inst_21146__$1)){
var statearr_21194_21226 = state_21168__$1;
(statearr_21194_21226[(1)] = (17));

} else {
var statearr_21195_21227 = state_21168__$1;
(statearr_21195_21227[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (10))){
var inst_21140 = (state_21168[(2)]);
var state_21168__$1 = state_21168;
if(cljs.core.truth_(inst_21140)){
var statearr_21196_21228 = state_21168__$1;
(statearr_21196_21228[(1)] = (14));

} else {
var statearr_21197_21229 = state_21168__$1;
(statearr_21197_21229[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (18))){
var state_21168__$1 = state_21168;
var statearr_21198_21230 = state_21168__$1;
(statearr_21198_21230[(2)] = null);

(statearr_21198_21230[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21169 === (8))){
var inst_21125 = (state_21168[(7)]);
var inst_21130 = inst_21125.cljs$lang$protocol_mask$partition0$;
var inst_21131 = (inst_21130 & (64));
var inst_21132 = inst_21125.cljs$core$ISeq$;
var inst_21133 = (inst_21131) || (inst_21132);
var state_21168__$1 = state_21168;
if(cljs.core.truth_(inst_21133)){
var statearr_21199_21231 = state_21168__$1;
(statearr_21199_21231[(1)] = (11));

} else {
var statearr_21200_21232 = state_21168__$1;
(statearr_21200_21232[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0 = (function (){
var statearr_21204 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21204[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__);

(statearr_21204[(1)] = (1));

return statearr_21204;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1 = (function (state_21168){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__.call(null,state_21168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12030__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e21205){if((e21205 instanceof Object)){
var ex__12031__auto__ = e21205;
var statearr_21206_21233 = state_21168;
(statearr_21206_21233[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21168);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21205;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12029__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21234 = state_21168;
state_21168 = G__21234;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = function(state_21168){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1.call(this,state_21168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_21207 = f__12140__auto__.call(null);
(statearr_21207[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_21207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21241 = arguments.length;
var i__7485__auto___21242 = (0);
while(true){
if((i__7485__auto___21242 < len__7484__auto___21241)){
args__7491__auto__.push((arguments[i__7485__auto___21242]));

var G__21243 = (i__7485__auto___21242 + (1));
i__7485__auto___21242 = G__21243;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__21238){
var map__21239 = p__21238;
var map__21239__$1 = ((((!((map__21239 == null)))?((((map__21239.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21239.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21239):map__21239);
var oboe_headers = cljs.core.get.call(null,map__21239__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__21239,map__21239__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__21239,map__21239__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__21239,map__21239__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__21239,map__21239__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq21235){
var G__21236 = cljs.core.first.call(null,seq21235);
var seq21235__$1 = cljs.core.next.call(null,seq21235);
var G__21237 = cljs.core.first.call(null,seq21235__$1);
var seq21235__$2 = cljs.core.next.call(null,seq21235__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21236,G__21237,seq21235__$2);
});

