// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('hatti.constants');
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._submission_time,new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._submission_time,new cljs.core.Keyword(null,"label","label",1718410804),"Submission Time",new cljs.core.Keyword(null,"type","type",1174270348),"dateTime"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._submitted_by,new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._submitted_by,new cljs.core.Keyword(null,"label","label",1718410804),"Submitted by",new cljs.core.Keyword(null,"type","type",1174270348),"text"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field], null);
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_.call(null,types,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
var map__17999 = field;
var map__17999__$1 = ((((!((map__17999 == null)))?((((map__17999.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17999.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17999):map__17999);
var children = cljs.core.get.call(null,map__17999__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.some.call(null,hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
var map__18003 = field;
var map__18003__$1 = ((((!((map__18003 == null)))?((((map__18003.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18003.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18003):map__18003);
var children = cljs.core.get.call(null,map__18003__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.some.call(null,hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not.call(null,(function (){var or__6409__auto__ = hatti.ona.forms.note_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.group_QMARK_.call(null,field);
}
})());
});
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_.call(null,field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
return "column-string";
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_.call(null,field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_.call(null,field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_.call(null,field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_.call(null,field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args18005 = [];
var len__7484__auto___18017 = arguments.length;
var i__7485__auto___18018 = (0);
while(true){
if((i__7485__auto___18018 < len__7484__auto___18017)){
args18005.push((arguments[i__7485__auto___18018]));

var G__18019 = (i__7485__auto___18018 + (1));
i__7485__auto___18018 = G__18019;
continue;
} else {
}
break;
}

var G__18009 = args18005.length;
switch (G__18009) {
case 1:
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7503__auto__ = (new cljs.core.IndexedSeq(args18005.slice((1)),(0),null));
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7503__auto__);

}
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$1 = (function (labelled_obj){
return hatti.ona.forms.get_label.call(null,labelled_obj,null);
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__18010,p__18011){
var map__18012 = p__18010;
var map__18012__$1 = ((((!((map__18012 == null)))?((((map__18012.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18012.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18012):map__18012);
var label = cljs.core.get.call(null,map__18012__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var name = cljs.core.get.call(null,map__18012__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var vec__18013 = p__18011;
var language = cljs.core.nth.call(null,vec__18013,(0),null);
if(!(cljs.core.map_QMARK_.call(null,label))){
var or__6409__auto__ = label;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,label)),language)){
return label.call(null,language);
} else {
return label.call(null,cljs.core.first.call(null,cljs.core.sort.call(null,cljs.core.keys.call(null,label))));
}
}
});

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq18006){
var G__18007 = cljs.core.first.call(null,seq18006);
var seq18006__$1 = cljs.core.next.call(null,seq18006);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__18007,seq18006__$1);
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);

/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args18024 = [];
var len__7484__auto___18034 = arguments.length;
var i__7485__auto___18035 = (0);
while(true){
if((i__7485__auto___18035 < len__7484__auto___18034)){
args18024.push((arguments[i__7485__auto___18035]));

var G__18036 = (i__7485__auto___18035 + (1));
i__7485__auto___18035 = G__18036;
continue;
} else {
}
break;
}

var G__18026 = args18024.length;
switch (G__18026) {
case 2:
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18024.length)].join('')));

}
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$2 = (function (field,answer){
return hatti.ona.forms.format_answer.call(null,field,answer,null);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3 = (function (field,answer,language){
return hatti.ona.forms.format_answer.call(null,field,answer,language,false);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$4 = (function (field,answer,language,compact_QMARK_){
var which = (cljs.core.truth_(hatti.ona.forms.image_QMARK_.call(null,field))?new cljs.core.Keyword(null,"img","img",1442687358):(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,field))?new cljs.core.Keyword(null,"osm","osm",855693280):(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))?new cljs.core.Keyword(null,"rpt","rpt",596328309):(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))?new cljs.core.Keyword(null,"sel1","sel1",-989581477):(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))?new cljs.core.Keyword(null,"selm","selm",1619526583):new cljs.core.Keyword(null,"else","else",-1508377146)
)))));
var G__18027 = (((which instanceof cljs.core.Keyword))?which.fqn:null);
switch (G__18027) {
case "sel1":
if(cljs.core.not.call(null,answer)){
return hatti.ona.forms.no_answer;
} else {
var option = cljs.core.first.call(null,cljs.core.filter.call(null,((function (G__18027,which){
return (function (p1__18021_SHARP_){
return cljs.core._EQ_.call(null,answer,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p1__18021_SHARP_));
});})(G__18027,which))
,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.call(null,option,language);
var or__6409__auto__ = formatted;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return answer;
}
}

break;
case "selm":
if(clojure.string.blank_QMARK_.call(null,answer)){
return hatti.ona.forms.no_answer;
} else {
var names = cljs.core.set.call(null,clojure.string.split.call(null,answer,/ /));
return clojure.string.join.call(null,cljs.core.map.call(null,((function (names,G__18027,which){
return (function (p1__18023_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.call(null,p1__18023_SHARP_,language)),cljs.core.str(" ")].join('');
});})(names,G__18027,which))
,cljs.core.filter.call(null,((function (names,G__18027,which){
return (function (p1__18022_SHARP_){
return cljs.core.contains_QMARK_.call(null,names,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p1__18022_SHARP_));
});})(names,G__18027,which))
,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field))));
}

break;
case "img":
var image = new cljs.core.Keyword(null,"download_url","download_url",-2115471203).cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__6409__auto__ = new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565).cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return image;
}
})();
var fname = chimera.urls.last_url_param.call(null,new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(answer));
if(((answer == null)) || (typeof answer === 'string')){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return chimera.js_interop.format.call(null,"<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                      %s </a>",image,fname);
} else {
if((thumb == null)){
return answer;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),image,new cljs.core.Keyword(null,"target","target",253001721),"_blank"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),"80px",new cljs.core.Keyword(null,"src","src",-1651076051),thumb], null)], null)], null);

}
}
}

break;
case "osm":
if(cljs.core.truth_(answer)){
var kw__GT_name = cljs.core.name;
var map__18028 = answer;
var map__18028__$1 = ((((!((map__18028 == null)))?((((map__18028.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18028.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18028):map__18028);
var name = cljs.core.get.call(null,map__18028__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__18028__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var osm_id = cljs.core.get.call(null,map__18028__$1,new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420));
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize.call(null,type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.osm-data","table.osm-data",-2112963294),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),cljs.core.map.call(null,((function (kw__GT_name,map__18028,map__18028__$1,name,type,osm_id,type_cap,title,G__18027,which){
return (function (p__18030){
var vec__18031 = p__18030;
var tk = cljs.core.nth.call(null,vec__18031,(0),null);
var tv = cljs.core.nth.call(null,vec__18031,(1),null);
if(clojure.string.blank_QMARK_.call(null,tv)){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.question","td.question",-381922608),kw__GT_name.call(null,tk)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.answer","td.answer",1235375692),tv], null)], null);
}
});})(kw__GT_name,map__18028,map__18028__$1,name,type,osm_id,type_cap,title,G__18027,which))
,new cljs.core.Keyword(null,"tags","tags",1771418977).cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
return null;
}

break;
case "rpt":
if(cljs.core.empty_QMARK_.call(null,answer)){
return "";
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count.call(null,answer)),cljs.core.str(" answers.")].join('');
}

break;
case "else":
return answer;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(which)].join('')));

}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = 4;

/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(field){
var label = (function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core.truth_(temp__4655__auto__)){
var type = temp__4655__auto__;
var G__18041 = type;
switch (G__18041) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
default:
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(field);

}
} else {
var G__18042 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"_submission_time","_submission_time",83724637,null),G__18042)){
return "Submission time";
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"_submitted_by","_submitted_by",1753216498,null),G__18042)){
return "Submitted by";
} else {
return "";

}
}
}
})();
if(cljs.core.truth_(new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(field))){
return field;
} else {
return cljs.core.assoc.call(null,field,new cljs.core.Keyword(null,"label","label",1718410804),label);
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18060 = arguments.length;
var i__7485__auto___18061 = (0);
while(true){
if((i__7485__auto___18061 < len__7484__auto___18060)){
args__7491__auto__.push((arguments[i__7485__auto___18061]));

var G__18062 = (i__7485__auto___18061 + (1));
i__7485__auto___18061 = G__18062;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__18049){
var map__18050 = p__18049;
var map__18050__$1 = ((((!((map__18050 == null)))?((((map__18050.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18050.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18050):map__18050);
var flatten_repeats_QMARK_ = cljs.core.get.call(null,map__18050__$1,new cljs.core.Keyword(null,"flatten-repeats?","flatten-repeats?",2012911394));
var name_label_map = ((function (map__18050,map__18050__$1,flatten_repeats_QMARK_){
return (function hatti$ona$forms$name_label_map(nd,prefix,acc){
var map__18058 = nd;
var map__18058__$1 = ((((!((map__18058 == null)))?((((map__18058.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18058.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18058):map__18058);
var type = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var children = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var name = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var label = cljs.core.get.call(null,map__18058__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_.call(null,label))?cljs.core.keys.call(null,label):null);
var nd__$1 = cljs.core.with_meta.call(null,cljs.core.assoc.call(null,nd,new cljs.core.Keyword(null,"full-name","full-name",408178550),full_name),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"langs","langs",1700794362),langs], null));
var mini_nd = cljs.core.dissoc.call(null,nd__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var new_children = cljs.core.map.call(null,((function (map__18058,map__18058__$1,type,children,name,label,full_name,langs,nd__$1,mini_nd,map__18050,map__18050__$1,flatten_repeats_QMARK_){
return (function (p1__18044_SHARP_){
return hatti$ona$forms$name_label_map.call(null,p1__18044_SHARP_,full_name,cljs.core.PersistentVector.EMPTY);
});})(map__18058,map__18058__$1,type,children,name,label,full_name,langs,nd__$1,mini_nd,map__18050,map__18050__$1,flatten_repeats_QMARK_))
,children);
if(cljs.core.truth_(hatti.ona.forms.group_QMARK_.call(null,nd__$1))){
return cljs.core.concat.call(null,cljs.core.conj.call(null,acc,mini_nd),new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,nd__$1))){
if(cljs.core.truth_(flatten_repeats_QMARK_)){
return cljs.core.concat.call(null,cljs.core.conj.call(null,acc,mini_nd),new_children);
} else {
return cljs.core.conj.call(null,acc,cljs.core.assoc.call(null,nd__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.flatten.call(null,cljs.core.apply.call(null,cljs.core.concat,new_children))));
}
} else {
return cljs.core.conj.call(null,acc,nd__$1);

}
}
});})(map__18050,map__18050__$1,flatten_repeats_QMARK_))
;
var nodes = cljs.core.flatten.call(null,cljs.core.map.call(null,((function (map__18050,map__18050__$1,flatten_repeats_QMARK_){
return (function (p1__18045_SHARP_){
return name_label_map.call(null,p1__18045_SHARP_,null,cljs.core.PersistentVector.EMPTY);
});})(map__18050,map__18050__$1,flatten_repeats_QMARK_))
,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(form)));
var langs = cljs.core.distinct.call(null,cljs.core.flatten.call(null,cljs.core.map.call(null,((function (nodes,map__18050,map__18050__$1,flatten_repeats_QMARK_){
return (function (p1__18046_SHARP_){
return new cljs.core.Keyword(null,"langs","langs",1700794362).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__18046_SHARP_));
});})(nodes,map__18050,map__18050__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta.call(null,nodes,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"languages","languages",1471910331),cljs.core.remove.call(null,cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq18047){
var G__18048 = cljs.core.first.call(null,seq18047);
var seq18047__$1 = cljs.core.next.call(null,seq18047);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__18048,seq18047__$1);
});

/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18069 = arguments.length;
var i__7485__auto___18070 = (0);
while(true){
if((i__7485__auto___18070 < len__7484__auto___18069)){
args__7491__auto__.push((arguments[i__7485__auto___18070]));

var G__18071 = (i__7485__auto___18070 + (1));
i__7485__auto___18070 = G__18071;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__18066){
var map__18067 = p__18066;
var map__18067__$1 = ((((!((map__18067 == null)))?((((map__18067.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18067.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18067):map__18067);
var relabel_QMARK_ = cljs.core.get.call(null,map__18067__$1,new cljs.core.Keyword(null,"relabel?","relabel?",898608477),true);
var with_submission_details_QMARK_ = cljs.core.get.call(null,map__18067__$1,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549));
var meta_fields = cljs.core.filter.call(null,hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__18067,map__18067__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__18063_SHARP_){
return cljs.core.into.call(null,cljs.core.vec.call(null,p1__18063_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__18067,map__18067__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
return include_extra_sub_details.call(null,cljs.core.map.call(null,relabel,meta_fields));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq18064){
var G__18065 = cljs.core.first.call(null,seq18064);
var seq18064__$1 = cljs.core.next.call(null,seq18064);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__18065,seq18064__$1);
});

/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.call(null,hatti.ona.forms.meta_QMARK_,flat_form);
});
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){

return cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,flat_form);
});
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){

var repeats = cljs.core.flatten.call(null,cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields.call(null,cljs.core.concat.call(null,flat_form,repeats));
var geoshapes = cljs.core.filter.call(null,hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.call(null,hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq.call(null,geoshapes)){
return cljs.core.first.call(null,geoshapes);
} else {
if(cljs.core.seq.call(null,geopoints)){
return cljs.core.first.call(null,geopoints);
} else {
return cljs.core.first.call(null,geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find.call(null,/english/i,[cljs.core.str(language)].join(''));
});
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){

return new cljs.core.Keyword(null,"languages","languages",1471910331).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
});
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){

return cljs.core.seq.call(null,hatti.ona.forms.get_languages.call(null,form));
});
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){

var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4655__auto__)){
var eng = temp__4655__auto__;
return eng;
} else {
return cljs.core.first.call(null,cljs.core.sort.call(null,languages));
}
});
