// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__21268(s__21269){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__21269__$1 = s__21269;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21269__$1);
if(temp__4657__auto__){
var s__21269__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21269__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21269__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21271 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21270 = (0);
while(true){
if((i__21270 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__21270);
cljs.core.chunk_append.call(null,b__21271,(function (){var iter__7189__auto__ = ((function (i__21270,datum,c__7187__auto__,size__7188__auto__,b__21271,s__21269__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__21268_$_iter__21280(s__21281){
return (new cljs.core.LazySeq(null,((function (i__21270,datum,c__7187__auto__,size__7188__auto__,b__21271,s__21269__$2,temp__4657__auto__,osmfields){
return (function (){
var s__21281__$1 = s__21281;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__21281__$1);
if(temp__4657__auto____$1){
var s__21281__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21281__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__21281__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__21283 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__21282 = (0);
while(true){
if((i__21282 < size__7188__auto____$1)){
var field = cljs.core._nth.call(null,c__7187__auto____$1,i__21282);
cljs.core.chunk_append.call(null,b__21283,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__21288 = (i__21282 + (1));
i__21282 = G__21288;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21283),hatti$ona$post_process$ona_osm_link_$_iter__21268_$_iter__21280.call(null,cljs.core.chunk_rest.call(null,s__21281__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21283),null);
}
} else {
var field = cljs.core.first.call(null,s__21281__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__21268_$_iter__21280.call(null,cljs.core.rest.call(null,s__21281__$2)));
}
} else {
return null;
}
break;
}
});})(i__21270,datum,c__7187__auto__,size__7188__auto__,b__21271,s__21269__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__21270,datum,c__7187__auto__,size__7188__auto__,b__21271,s__21269__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})());

var G__21289 = (i__21270 + (1));
i__21270 = G__21289;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21271),hatti$ona$post_process$ona_osm_link_$_iter__21268.call(null,cljs.core.chunk_rest.call(null,s__21269__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21271),null);
}
} else {
var datum = cljs.core.first.call(null,s__21269__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (datum,s__21269__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__21268_$_iter__21284(s__21285){
return (new cljs.core.LazySeq(null,((function (datum,s__21269__$2,temp__4657__auto__,osmfields){
return (function (){
var s__21285__$1 = s__21285;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__21285__$1);
if(temp__4657__auto____$1){
var s__21285__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21285__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21285__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21287 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21286 = (0);
while(true){
if((i__21286 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__21286);
cljs.core.chunk_append.call(null,b__21287,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__21290 = (i__21286 + (1));
i__21286 = G__21290;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21287),hatti$ona$post_process$ona_osm_link_$_iter__21268_$_iter__21284.call(null,cljs.core.chunk_rest.call(null,s__21285__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21287),null);
}
} else {
var field = cljs.core.first.call(null,s__21285__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__21268_$_iter__21284.call(null,cljs.core.rest.call(null,s__21285__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__21269__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__21269__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__21268.call(null,cljs.core.rest.call(null,s__21269__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__21311(s__21312){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__21312__$1 = s__21312;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21312__$1);
if(temp__4657__auto__){
var s__21312__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21312__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21312__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21314 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21313 = (0);
while(true){
if((i__21313 < size__7188__auto__)){
var map__21323 = cljs.core._nth.call(null,c__7187__auto__,i__21313);
var map__21323__$1 = ((((!((map__21323 == null)))?((((map__21323.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21323.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21323):map__21323);
var feature = map__21323__$1;
var type = cljs.core.get.call(null,map__21323__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__21323__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__21323__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__21314,(function (){var map__21325 = properties;
var map__21325__$1 = ((((!((map__21325 == null)))?((((map__21325.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21325.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21325):map__21325);
var type__$1 = cljs.core.get.call(null,map__21325__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__21325__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__21325__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__21331 = (i__21313 + (1));
i__21313 = G__21331;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21314),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__21311.call(null,cljs.core.chunk_rest.call(null,s__21312__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21314),null);
}
} else {
var map__21327 = cljs.core.first.call(null,s__21312__$2);
var map__21327__$1 = ((((!((map__21327 == null)))?((((map__21327.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21327.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21327):map__21327);
var feature = map__21327__$1;
var type = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__21329 = properties;
var map__21329__$1 = ((((!((map__21329 == null)))?((((map__21329.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21329.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21329):map__21329);
var type__$1 = cljs.core.get.call(null,map__21329__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__21329__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__21329__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__21311.call(null,cljs.core.rest.call(null,s__21312__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__21332_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__21332_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = osm_data.call(null,osm_id);
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__21342(s__21343){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__21343__$1 = s__21343;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21343__$1);
if(temp__4657__auto__){
var s__21343__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21343__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21343__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21345 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21344 = (0);
while(true){
if((i__21344 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__21344);
cljs.core.chunk_append.call(null,b__21345,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__21344,osm_id,datum,c__7187__auto__,size__7188__auto__,b__21345,s__21343__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__21333_SHARP_){
return osm_val__GT_osm_data.call(null,p1__21333_SHARP_,osm_id);
});})(i__21344,osm_id,datum,c__7187__auto__,size__7188__auto__,b__21345,s__21343__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__21350 = (i__21344 + (1));
i__21344 = G__21350;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21345),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__21342.call(null,cljs.core.chunk_rest.call(null,s__21343__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21345),null);
}
} else {
var datum = cljs.core.first.call(null,s__21343__$2);
return cljs.core.cons.call(null,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__21343__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__21333_SHARP_){
return osm_val__GT_osm_data.call(null,p1__21333_SHARP_,osm_id);
});})(osm_id,datum,s__21343__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__21342.call(null,cljs.core.rest.call(null,s__21343__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__21346 = cljs.core.seq.call(null,osm_fields);
var chunk__21347 = null;
var count__21348 = (0);
var i__21349 = (0);
while(true){
if((i__21349 < count__21348)){
var osm_field = cljs.core._nth.call(null,chunk__21347,i__21349);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__21351 = seq__21346;
var G__21352 = chunk__21347;
var G__21353 = count__21348;
var G__21354 = (i__21349 + (1));
seq__21346 = G__21351;
chunk__21347 = G__21352;
count__21348 = G__21353;
i__21349 = G__21354;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__21346);
if(temp__4657__auto__){
var seq__21346__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21346__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__21346__$1);
var G__21355 = cljs.core.chunk_rest.call(null,seq__21346__$1);
var G__21356 = c__7220__auto__;
var G__21357 = cljs.core.count.call(null,c__7220__auto__);
var G__21358 = (0);
seq__21346 = G__21355;
chunk__21347 = G__21356;
count__21348 = G__21357;
i__21349 = G__21358;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__21346__$1);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__21359 = cljs.core.next.call(null,seq__21346__$1);
var G__21360 = null;
var G__21361 = (0);
var G__21362 = (0);
seq__21346 = G__21359;
chunk__21347 = G__21360;
count__21348 = G__21361;
i__21349 = G__21362;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,record,"_attachments");
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__21363_SHARP_){
return chimera.urls.last_url_param.call(null,cljs.core.get.call(null,p1__21363_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21374 = arguments.length;
var i__7485__auto___21375 = (0);
while(true){
if((i__7485__auto___21375 < len__7484__auto___21374)){
args__7491__auto__.push((arguments[i__7485__auto___21375]));

var G__21376 = (i__7485__auto___21375 + (1));
i__7485__auto___21375 = G__21376;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__21367){
var map__21368 = p__21367;
var map__21368__$1 = ((((!((map__21368 == null)))?((((map__21368.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21368.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21368):map__21368);
var attachments = cljs.core.get.call(null,map__21368__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = cljs.core.filter.call(null,hatti.ona.forms.image_QMARK_,flat_form);
var iter__7189__auto__ = ((function (image_fields,map__21368,map__21368__$1,attachments){
return (function hatti$ona$post_process$iter__21370(s__21371){
return (new cljs.core.LazySeq(null,((function (image_fields,map__21368,map__21368__$1,attachments){
return (function (){
var s__21371__$1 = s__21371;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21371__$1);
if(temp__4657__auto__){
var s__21371__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21371__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21371__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21373 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21372 = (0);
while(true){
if((i__21372 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__21372);
cljs.core.chunk_append.call(null,b__21373,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__21372,attach_map,record,c__7187__auto__,size__7188__auto__,b__21373,s__21371__$2,temp__4657__auto__,image_fields,map__21368,map__21368__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__21372,attach_map,record,c__7187__auto__,size__7188__auto__,b__21373,s__21371__$2,temp__4657__auto__,image_fields,map__21368,map__21368__$1,attachments))
,record,image_fields);
})());

var G__21377 = (i__21372 + (1));
i__21372 = G__21377;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21373),hatti$ona$post_process$iter__21370.call(null,cljs.core.chunk_rest.call(null,s__21371__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21373),null);
}
} else {
var record = cljs.core.first.call(null,s__21371__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__21371__$2,temp__4657__auto__,image_fields,map__21368,map__21368__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__21371__$2,temp__4657__auto__,image_fields,map__21368,map__21368__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__21370.call(null,cljs.core.rest.call(null,s__21371__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__21368,map__21368__$1,attachments))
,null,null));
});})(image_fields,map__21368,map__21368__$1,attachments))
;
return iter__7189__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq21364){
var G__21365 = cljs.core.first.call(null,seq21364);
var seq21364__$1 = cljs.core.next.call(null,seq21364);
var G__21366 = cljs.core.first.call(null,seq21364__$1);
var seq21364__$2 = cljs.core.next.call(null,seq21364__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__21365,G__21366,seq21364__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,"_attachments")));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__21382(s__21383){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__21383__$1 = s__21383;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21383__$1);
if(temp__4657__auto__){
var s__21383__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21383__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21383__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21385 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21384 = (0);
while(true){
if((i__21384 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__21384);
cljs.core.chunk_append.call(null,b__21385,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__21386 = (i__21384 + (1));
i__21384 = G__21386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21385),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__21382.call(null,cljs.core.chunk_rest.call(null,s__21383__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21385),null);
}
} else {
var record = cljs.core.first.call(null,s__21383__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__21382.call(null,cljs.core.rest.call(null,s__21383__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__.call(null,data);
});
/**
 * Inlines data from within _atatchments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___21394 = arguments.length;
var i__7485__auto___21395 = (0);
while(true){
if((i__7485__auto___21395 < len__7484__auto___21394)){
args__7491__auto__.push((arguments[i__7485__auto___21395]));

var G__21396 = (i__7485__auto___21395 + (1));
i__7485__auto___21395 = G__21396;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__21391){
var map__21392 = p__21391;
var map__21392__$1 = ((((!((map__21392 == null)))?((((map__21392.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21392.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21392):map__21392);
var app_data_keys = cljs.core.get.call(null,map__21392__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return chimera.om.state.transact_BANG_.call(null,app_state,app_data_keys,((function (map__21392,map__21392__$1,app_data_keys){
return (function (p1__21387_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__21387_SHARP_));
});})(map__21392,map__21392__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq21388){
var G__21389 = cljs.core.first.call(null,seq21388);
var seq21388__$1 = cljs.core.next.call(null,seq21388);
var G__21390 = cljs.core.first.call(null,seq21388__$1);
var seq21388__$2 = cljs.core.next.call(null,seq21388__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21389,G__21390,seq21388__$2);
});

