// Compiled by ClojureScript 1.7.145 {}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('hatti.constants');
goog.require('hatti.ona.forms');
goog.require('hatti.utils');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"radius": (6), "fillColor": "#f30", "reset": {"fillColor": "#f30"}, "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9},new cljs.core.Keyword(null,"hover","hover",-341141711),{"fillColor": "#631400"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"fillColor": "#ad2300"}], null),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8},new cljs.core.Keyword(null,"hover","hover",-341141711),{"fillColor": "#631400", "color": "#222"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"fillColor": "#ad2300", "color": "#222"}], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),{"color": "#f30", "opacity": (1), "weight": (6), "reset": {"color": "#f30"}},new cljs.core.Keyword(null,"hover","hover",-341141711),{"color": "#631400"},new cljs.core.Keyword(null,"clicked","clicked",114423720),{"color": "#ad2300"}], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(marker_or_keyword,style_type){
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype.call(null,marker_or_keyword));
return style_type.call(null,kw.call(null,hatti.map.utils.ona_styles));
});
hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.call(null,s);
var tc = cljs.core.js__GT_clj.call(null,t);
return cljs.core._EQ_.call(null,cljs.core.select_keys.call(null,sc,cljs.core.keys.call(null,tc)),cljs.core.select_keys.call(null,tc,cljs.core.keys.call(null,sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args11476 = [];
var len__5627__auto___11479 = arguments.length;
var i__5628__auto___11480 = (0);
while(true){
if((i__5628__auto___11480 < len__5627__auto___11479)){
args11476.push((arguments[i__5628__auto___11480]));

var G__11481 = (i__5628__auto___11480 + (1));
i__5628__auto___11480 = G__11481;
continue;
} else {
}
break;
}

var G__11478 = args11476.length;
switch (G__11478) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11476.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
return kw.call(null,cljs.core.js__GT_clj.call(null,hatti.map.utils.get_style.call(null,marker)));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;
/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style.call(null,hatti.map.utils.get_style.call(null,marker),hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = marker__GT_style.call(null,marker);
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return marker.setStyle(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reset","reset",-800929946),style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,style,new cljs.core.Keyword(null,"reset","reset",-800929946),style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4423__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4423__auto__)){
var rstyle = temp__4423__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__4569__auto__ = hatti.map.utils.is_clicked_QMARK_.call(null,marker);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return id_selected_QMARK_.call(null,hatti.map.utils.get_id.call(null,marker));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style.call(null,marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"hover","hover",-341141711)));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11492 = arguments.length;
var i__5628__auto___11493 = (0);
while(true){
if((i__5628__auto___11493 < len__5627__auto___11492)){
args__5634__auto__.push((arguments[i__5628__auto___11493]));

var G__11494 = (i__5628__auto___11493 + (1));
i__5628__auto___11493 = G__11494;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__11485){
var map__11486 = p__11485;
var map__11486__$1 = ((((!((map__11486 == null)))?((((map__11486.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11486.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11486):map__11486);
var preserve_clicked_QMARK_ = cljs.core.get.call(null,map__11486__$1,new cljs.core.Keyword(null,"preserve-clicked?","preserve-clicked?",-727263842),true);
var seq__11488 = cljs.core.seq.call(null,markers);
var chunk__11489 = null;
var count__11490 = (0);
var i__11491 = (0);
while(true){
if((i__11491 < count__11490)){
var marker = cljs.core._nth.call(null,chunk__11489,i__11491);
if(cljs.core.not.call(null,(function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__11495 = seq__11488;
var G__11496 = chunk__11489;
var G__11497 = count__11490;
var G__11498 = (i__11491 + (1));
seq__11488 = G__11495;
chunk__11489 = G__11496;
count__11490 = G__11497;
i__11491 = G__11498;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__11488);
if(temp__4425__auto__){
var seq__11488__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11488__$1)){
var c__5372__auto__ = cljs.core.chunk_first.call(null,seq__11488__$1);
var G__11499 = cljs.core.chunk_rest.call(null,seq__11488__$1);
var G__11500 = c__5372__auto__;
var G__11501 = cljs.core.count.call(null,c__5372__auto__);
var G__11502 = (0);
seq__11488 = G__11499;
chunk__11489 = G__11500;
count__11490 = G__11501;
i__11491 = G__11502;
continue;
} else {
var marker = cljs.core.first.call(null,seq__11488__$1);
if(cljs.core.not.call(null,(function (){var and__4557__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__4557__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__11503 = cljs.core.next.call(null,seq__11488__$1);
var G__11504 = null;
var G__11505 = (0);
var G__11506 = (0);
seq__11488 = G__11503;
chunk__11489 = G__11504;
count__11490 = G__11505;
i__11491 = G__11506;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq11483){
var G__11484 = cljs.core.first.call(null,seq11483);
var seq11483__$1 = cljs.core.next.call(null,seq11483);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__11484,seq11483__$1);
});
hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string.call(null,maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(index + (1)),cljs.core.keyword.call(null,hatti.constants._id),record_id], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__5482__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5483__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5484__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5485__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5486__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hatti.map.utils","get-as-geom"),((function (method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__){
return (function() { 
var G__11509__delegate = function (record,field,p__11507){
var vec__11508 = p__11507;
var repeat_child_index = cljs.core.nth.call(null,vec__11508,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return new cljs.core.Keyword(null,"repeat","repeat",832692087);
} else {
return new cljs.core.Keyword(null,"default","default",-1987822328);

}
};
var G__11509 = function (record,field,var_args){
var p__11507 = null;
if (arguments.length > 2) {
var G__11510__i = 0, G__11510__a = new Array(arguments.length -  2);
while (G__11510__i < G__11510__a.length) {G__11510__a[G__11510__i] = arguments[G__11510__i + 2]; ++G__11510__i;}
  p__11507 = new cljs.core.IndexedSeq(G__11510__a,0);
} 
return G__11509__delegate.call(this,record,field,p__11507);};
G__11509.cljs$lang$maxFixedArity = 2;
G__11509.cljs$lang$applyTo = (function (arglist__11511){
var record = cljs.core.first(arglist__11511);
arglist__11511 = cljs.core.next(arglist__11511);
var field = cljs.core.first(arglist__11511);
var p__11507 = cljs.core.rest(arglist__11511);
return G__11509__delegate(record,field,p__11507);
});
G__11509.cljs$core$IFn$_invoke$arity$variadic = G__11509__delegate;
return G__11509;
})()
;})(method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__,hierarchy__5486__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5486__auto__,method_table__5482__auto__,prefer_table__5483__auto__,method_cache__5484__auto__,cached_hierarchy__5485__auto__));
})();
}
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"repeat","repeat",832692087),(function (record,p__11512){
var map__11513 = p__11512;
var map__11513__$1 = ((((!((map__11513 == null)))?((((map__11513.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11513.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11513):map__11513);
var field = map__11513__$1;
var children = cljs.core.get.call(null,map__11513__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var full_name = cljs.core.get.call(null,map__11513__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var iter__5341__auto__ = ((function (map__11513,map__11513__$1,field,children,full_name){
return (function hatti$map$utils$iter__11515(s__11516){
return (new cljs.core.LazySeq(null,((function (map__11513,map__11513__$1,field,children,full_name){
return (function (){
var s__11516__$1 = s__11516;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11516__$1);
if(temp__4425__auto__){
var s__11516__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11516__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11516__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11518 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11517 = (0);
while(true){
if((i__11517 < size__5340__auto__)){
var child_record = cljs.core._nth.call(null,c__5339__auto__,i__11517);
cljs.core.chunk_append.call(null,b__11518,(function (){var iter__5341__auto__ = ((function (i__11517,child_record,c__5339__auto__,size__5340__auto__,b__11518,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name){
return (function hatti$map$utils$iter__11515_$_iter__11527(s__11528){
return (new cljs.core.LazySeq(null,((function (i__11517,child_record,c__5339__auto__,size__5340__auto__,b__11518,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name){
return (function (){
var s__11528__$1 = s__11528;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__11528__$1);
if(temp__4425__auto____$1){
var s__11528__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11528__$2)){
var c__5339__auto____$1 = cljs.core.chunk_first.call(null,s__11528__$2);
var size__5340__auto____$1 = cljs.core.count.call(null,c__5339__auto____$1);
var b__11530 = cljs.core.chunk_buffer.call(null,size__5340__auto____$1);
if((function (){var i__11529 = (0);
while(true){
if((i__11529 < size__5340__auto____$1)){
var child = cljs.core._nth.call(null,c__5339__auto____$1,i__11529);
cljs.core.chunk_append.call(null,b__11530,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__11535 = (i__11529 + (1));
i__11529 = G__11535;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11530),hatti$map$utils$iter__11515_$_iter__11527.call(null,cljs.core.chunk_rest.call(null,s__11528__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11530),null);
}
} else {
var child = cljs.core.first.call(null,s__11528__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__11515_$_iter__11527.call(null,cljs.core.rest.call(null,s__11528__$2)));
}
} else {
return null;
}
break;
}
});})(i__11517,child_record,c__5339__auto__,size__5340__auto__,b__11518,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name))
,null,null));
});})(i__11517,child_record,c__5339__auto__,size__5340__auto__,b__11518,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name))
;
return iter__5341__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})());

var G__11536 = (i__11517 + (1));
i__11517 = G__11536;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11518),hatti$map$utils$iter__11515.call(null,cljs.core.chunk_rest.call(null,s__11516__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11518),null);
}
} else {
var child_record = cljs.core.first.call(null,s__11516__$2);
return cljs.core.cons.call(null,(function (){var iter__5341__auto__ = ((function (child_record,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name){
return (function hatti$map$utils$iter__11515_$_iter__11531(s__11532){
return (new cljs.core.LazySeq(null,((function (child_record,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name){
return (function (){
var s__11532__$1 = s__11532;
while(true){
var temp__4425__auto____$1 = cljs.core.seq.call(null,s__11532__$1);
if(temp__4425__auto____$1){
var s__11532__$2 = temp__4425__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11532__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11532__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11534 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11533 = (0);
while(true){
if((i__11533 < size__5340__auto__)){
var child = cljs.core._nth.call(null,c__5339__auto__,i__11533);
cljs.core.chunk_append.call(null,b__11534,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__11537 = (i__11533 + (1));
i__11533 = G__11537;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11534),hatti$map$utils$iter__11515_$_iter__11531.call(null,cljs.core.chunk_rest.call(null,s__11532__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11534),null);
}
} else {
var child = cljs.core.first.call(null,s__11532__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__11515_$_iter__11531.call(null,cljs.core.rest.call(null,s__11532__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name))
,null,null));
});})(child_record,s__11516__$2,temp__4425__auto__,map__11513,map__11513__$1,field,children,full_name))
;
return iter__5341__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__11515.call(null,cljs.core.rest.call(null,s__11516__$2)));
}
} else {
return null;
}
break;
}
});})(map__11513,map__11513__$1,field,children,full_name))
,null,null));
});})(map__11513,map__11513__$1,field,children,full_name))
;
return iter__5341__auto__.call(null,cljs.core.get.call(null,record,full_name));
}));
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"default","default",-1987822328),(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq.call(null,s)) && (cljs.core.not_EQ_.call(null,s,"n/a"))){
var iter__5341__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__11540(s__11541){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__11541__$1 = s__11541;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11541__$1);
if(temp__4425__auto__){
var s__11541__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11541__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11541__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11543 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11542 = (0);
while(true){
if((i__11542 < size__5340__auto__)){
var coord_string = cljs.core._nth.call(null,c__5339__auto__,i__11542);
cljs.core.chunk_append.call(null,b__11543,(function (){var vec__11546 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__11546,(0),null);
var lng = cljs.core.nth.call(null,vec__11546,(1),null);
var _ = cljs.core.nth.call(null,vec__11546,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__11546,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})());

var G__11549 = (i__11542 + (1));
i__11542 = G__11549;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11543),hatti$map$utils$iter__11540.call(null,cljs.core.chunk_rest.call(null,s__11541__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11543),null);
}
} else {
var coord_string = cljs.core.first.call(null,s__11541__$2);
return cljs.core.cons.call(null,(function (){var vec__11547 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__11547,(0),null);
var lng = cljs.core.nth.call(null,vec__11547,(1),null);
var _ = cljs.core.nth.call(null,vec__11547,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__11547,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})(),hatti$map$utils$iter__11540.call(null,cljs.core.rest.call(null,s__11541__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__5341__auto__.call(null,clojure.string.split.call(null,s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__11548 = geotype;
switch (G__11548) {
case "Point":
return ((function (G__11548,geotype,parse){
return (function (p1__11538_SHARP_){
return cljs.core.first.call(null,parse.call(null,p1__11538_SHARP_));
});
;})(G__11548,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__11548,geotype,parse){
return (function (p1__11539_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse.call(null,p1__11539_SHARP_)],null));
});
;})(G__11548,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.call(null,record,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield));
var coords = coordfn.call(null,value);
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,geofield))){
return new cljs.core.Keyword(null,"geom","geom",1207084371).cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__4569__auto__ = (coords == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.some.call(null,cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),geotype,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args11552 = [];
var len__5627__auto___11563 = arguments.length;
var i__5628__auto___11564 = (0);
while(true){
if((i__5628__auto___11564 < len__5627__auto___11563)){
args11552.push((arguments[i__5628__auto___11564]));

var G__11565 = (i__5628__auto___11564 + (1));
i__5628__auto___11564 = G__11565;
continue;
} else {
}
break;
}

var G__11554 = args11552.length;
switch (G__11554) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11552.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.call(null,dataset,form,hatti.ona.forms.default_geofield.call(null,form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__5341__auto__ = (function hatti$map$utils$iter__11555(s__11556){
return (new cljs.core.LazySeq(null,(function (){
var s__11556__$1 = s__11556;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__11556__$1);
if(temp__4425__auto__){
var s__11556__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11556__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__11556__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__11558 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__11557 = (0);
while(true){
if((i__11557 < size__5340__auto__)){
var vec__11561 = cljs.core._nth.call(null,c__5339__auto__,i__11557);
var idx = cljs.core.nth.call(null,vec__11561,(0),null);
var record = cljs.core.nth.call(null,vec__11561,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append.call(null,b__11558,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (i__11557,s__11556__$1,geom_or_geoms,vec__11561,idx,record,c__5339__auto__,size__5340__auto__,b__11558,s__11556__$2,temp__4425__auto__){
return (function (p1__11551_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__11551_SHARP_,record.call(null,hatti.constants._id),idx);
});})(i__11557,s__11556__$1,geom_or_geoms,vec__11561,idx,record,c__5339__auto__,size__5340__auto__,b__11558,s__11556__$2,temp__4425__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))));

var G__11567 = (i__11557 + (1));
i__11557 = G__11567;
continue;
} else {
var G__11568 = (i__11557 + (1));
i__11557 = G__11568;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11558),hatti$map$utils$iter__11555.call(null,cljs.core.chunk_rest.call(null,s__11556__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11558),null);
}
} else {
var vec__11562 = cljs.core.first.call(null,s__11556__$2);
var idx = cljs.core.nth.call(null,vec__11562,(0),null);
var record = cljs.core.nth.call(null,vec__11562,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons.call(null,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (s__11556__$1,geom_or_geoms,vec__11562,idx,record,s__11556__$2,temp__4425__auto__){
return (function (p1__11551_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__11551_SHARP_,record.call(null,hatti.constants._id),idx);
});})(s__11556__$1,geom_or_geoms,vec__11562,idx,record,s__11556__$2,temp__4425__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))),hatti$map$utils$iter__11555.call(null,cljs.core.rest.call(null,s__11556__$2)));
} else {
var G__11569 = cljs.core.rest.call(null,s__11556__$2);
s__11556__$1 = G__11569;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,hatti.utils.indexed.call(null,dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),cljs.core.flatten.call(null,features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;
/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__11571){
var map__11574 = p__11571;
var map__11574__$1 = ((((!((map__11574 == null)))?((((map__11574.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11574.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11574):map__11574);
var mapbox_tiles = cljs.core.get.call(null,map__11574__$1,new cljs.core.Keyword(null,"mapbox-tiles","mapbox-tiles",69952469));
var include_google_maps_QMARK_ = cljs.core.get.call(null,map__11574__$1,new cljs.core.Keyword(null,"include-google-maps?","include-google-maps?",1820261665));
var layers = cljs.core.map.call(null,((function (map__11574,map__11574__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__11570_SHARP_){
return L.tileLayer(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(p1__11570_SHARP_));
});})(map__11574,map__11574__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js.call(null,nlayers));
var m = L.map(id,{"layers": cljs.core.first.call(null,layers), "zoomControl": false});
var z = L.control.zoom.call(null,{"position": "bottomleft"});
z.addTo(m);

L.control.layers.call(null,named_layers,null,{"position": "bottomleft"}).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361),((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style.call(null,marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style.call(null,marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not.call(null,layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__5634__auto__ = [];
var len__5627__auto___11588 = arguments.length;
var i__5628__auto___11589 = (0);
while(true){
if((i__5628__auto___11589 < len__5627__auto___11588)){
args__5634__auto__.push((arguments[i__5628__auto___11589]));

var G__11590 = (i__5628__auto___11589 + (1));
i__5628__auto___11589 = G__11590;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((3) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((3)),(0))):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5635__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__11585){
var map__11586 = p__11585;
var map__11586__$1 = ((((!((map__11586 == null)))?((((map__11586.cljs$lang$protocol_mask$partition0$ & (64))) || (map__11586.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11586):map__11586);
var rezoom_QMARK_ = cljs.core.get.call(null,map__11586__$1,new cljs.core.Keyword(null,"rezoom?","rezoom?",746240707));
var on_events = ((function (map__11586,map__11586__$1,rezoom_QMARK_){
return (function (p1__11576_SHARP_,p2__11577_SHARP_){
return hatti.map.utils.register_mouse_events.call(null,p1__11576_SHARP_,p2__11577_SHARP_,event_chan);
});})(map__11586,map__11586__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__11586,map__11586__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style.call(null,geometry_type,new cljs.core.Keyword(null,"normal","normal",-1519123858));
});})(on_events,geometry_type,map__11586,map__11586__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__11586,map__11586__$1,rezoom_QMARK_){
return (function (p1__11579_SHARP_,p2__11578_SHARP_){
return L.circleMarker(p2__11578_SHARP_);
});})(on_events,geometry_type,stylefn,map__11586,map__11586__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js.call(null,geojson),{"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn});
var ids = cljs.core.map.call(null,((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__11586,map__11586__$1,rezoom_QMARK_){
return (function (p1__11580_SHARP_){
return cljs.core.get_in.call(null,p1__11580_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.keyword.call(null,hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__11586,map__11586__$1,rezoom_QMARK_))
,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"feature-layer","feature-layer",2086639246),feature_layer,new cljs.core.Keyword(null,"markers","markers",-246919693),markers,new cljs.core.Keyword(null,"id->marker","id->marker",-1702427771),cljs.core.zipmap.call(null,ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq11581){
var G__11582 = cljs.core.first.call(null,seq11581);
var seq11581__$1 = cljs.core.next.call(null,seq11581);
var G__11583 = cljs.core.first.call(null,seq11581__$1);
var seq11581__$2 = cljs.core.next.call(null,seq11581__$1);
var G__11584 = cljs.core.first.call(null,seq11581__$2);
var seq11581__$3 = cljs.core.next.call(null,seq11581__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__11582,G__11583,G__11584,seq11581__$3);
});
