// Compiled by ClojureScript 1.7.145 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__23363__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__23362 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag = cljs.core.nth.call(null,vec__23362,(0),null);
var body = cljs.core.nthnext.call(null,vec__23362,(1));
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__23363 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__23364__i = 0, G__23364__a = new Array(arguments.length -  0);
while (G__23364__i < G__23364__a.length) {G__23364__a[G__23364__i] = arguments[G__23364__i + 0]; ++G__23364__i;}
  args = new cljs.core.IndexedSeq(G__23364__a,0);
} 
return G__23363__delegate.call(this,args);};
G__23363.cljs$lang$maxFixedArity = 0;
G__23363.cljs$lang$applyTo = (function (arglist__23365){
var args = cljs.core.seq(arglist__23365);
return G__23363__delegate(args);
});
G__23363.cljs$core$IFn$_invoke$arity$variadic = G__23363__delegate;
return G__23363;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__5341__auto__ = (function sablono$core$update_arglists_$_iter__23370(s__23371){
return (new cljs.core.LazySeq(null,(function (){
var s__23371__$1 = s__23371;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23371__$1);
if(temp__4425__auto__){
var s__23371__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23371__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23371__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23373 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23372 = (0);
while(true){
if((i__23372 < size__5340__auto__)){
var args = cljs.core._nth.call(null,c__5339__auto__,i__23372);
cljs.core.chunk_append.call(null,b__23373,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__23374 = (i__23372 + (1));
i__23372 = G__23374;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23373),sablono$core$update_arglists_$_iter__23370.call(null,cljs.core.chunk_rest.call(null,s__23371__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23373),null);
}
} else {
var args = cljs.core.first.call(null,s__23371__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__23370.call(null,cljs.core.rest.call(null,s__23371__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23380 = arguments.length;
var i__5628__auto___23381 = (0);
while(true){
if((i__5628__auto___23381 < len__5627__auto___23380)){
args__5634__auto__.push((arguments[i__5628__auto___23381]));

var G__23382 = (i__5628__auto___23381 + (1));
i__5628__auto___23381 = G__23382;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__5341__auto__ = (function sablono$core$iter__23376(s__23377){
return (new cljs.core.LazySeq(null,(function (){
var s__23377__$1 = s__23377;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23377__$1);
if(temp__4425__auto__){
var s__23377__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23377__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23377__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23379 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23378 = (0);
while(true){
if((i__23378 < size__5340__auto__)){
var style = cljs.core._nth.call(null,c__5339__auto__,i__23378);
cljs.core.chunk_append.call(null,b__23379,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__23383 = (i__23378 + (1));
i__23378 = G__23383;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23379),sablono$core$iter__23376.call(null,cljs.core.chunk_rest.call(null,s__23377__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23379),null);
}
} else {
var style = cljs.core.first.call(null,s__23377__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__23376.call(null,cljs.core.rest.call(null,s__23377__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq23375){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23375));
});
/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to23384 = (function sablono$core$link_to23384(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23387 = arguments.length;
var i__5628__auto___23388 = (0);
while(true){
if((i__5628__auto___23388 < len__5627__auto___23387)){
args__5634__auto__.push((arguments[i__5628__auto___23388]));

var G__23389 = (i__5628__auto___23388 + (1));
i__5628__auto___23388 = G__23389;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.link_to23384.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.link_to23384.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to23384.cljs$lang$maxFixedArity = (1);

sablono.core.link_to23384.cljs$lang$applyTo = (function (seq23385){
var G__23386 = cljs.core.first.call(null,seq23385);
var seq23385__$1 = cljs.core.next.call(null,seq23385);
return sablono.core.link_to23384.cljs$core$IFn$_invoke$arity$variadic(G__23386,seq23385__$1);
});

sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to23384);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to23390 = (function sablono$core$mail_to23390(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23395 = arguments.length;
var i__5628__auto___23396 = (0);
while(true){
if((i__5628__auto___23396 < len__5627__auto___23395)){
args__5634__auto__.push((arguments[i__5628__auto___23396]));

var G__23397 = (i__5628__auto___23396 + (1));
i__5628__auto___23396 = G__23397;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.mail_to23390.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.mail_to23390.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__23393){
var vec__23394 = p__23393;
var content = cljs.core.nth.call(null,vec__23394,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__4569__auto__ = content;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to23390.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to23390.cljs$lang$applyTo = (function (seq23391){
var G__23392 = cljs.core.first.call(null,seq23391);
var seq23391__$1 = cljs.core.next.call(null,seq23391);
return sablono.core.mail_to23390.cljs$core$IFn$_invoke$arity$variadic(G__23392,seq23391__$1);
});

sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to23390);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list23398 = (function sablono$core$unordered_list23398(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__5341__auto__ = (function sablono$core$unordered_list23398_$_iter__23403(s__23404){
return (new cljs.core.LazySeq(null,(function (){
var s__23404__$1 = s__23404;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23404__$1);
if(temp__4425__auto__){
var s__23404__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23404__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23404__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23406 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23405 = (0);
while(true){
if((i__23405 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23405);
cljs.core.chunk_append.call(null,b__23406,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23407 = (i__23405 + (1));
i__23405 = G__23407;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23406),sablono$core$unordered_list23398_$_iter__23403.call(null,cljs.core.chunk_rest.call(null,s__23404__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23406),null);
}
} else {
var x = cljs.core.first.call(null,s__23404__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list23398_$_iter__23403.call(null,cljs.core.rest.call(null,s__23404__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list23398);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list23408 = (function sablono$core$ordered_list23408(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__5341__auto__ = (function sablono$core$ordered_list23408_$_iter__23413(s__23414){
return (new cljs.core.LazySeq(null,(function (){
var s__23414__$1 = s__23414;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23414__$1);
if(temp__4425__auto__){
var s__23414__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23414__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23414__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23416 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23415 = (0);
while(true){
if((i__23415 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23415);
cljs.core.chunk_append.call(null,b__23416,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__23417 = (i__23415 + (1));
i__23415 = G__23417;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23416),sablono$core$ordered_list23408_$_iter__23413.call(null,cljs.core.chunk_rest.call(null,s__23414__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23416),null);
}
} else {
var x = cljs.core.first.call(null,s__23414__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list23408_$_iter__23413.call(null,cljs.core.rest.call(null,s__23414__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list23408);
/**
 * Create an image element.
 */
sablono.core.image23418 = (function sablono$core$image23418(var_args){
var args23419 = [];
var len__5627__auto___23422 = arguments.length;
var i__5628__auto___23423 = (0);
while(true){
if((i__5628__auto___23423 < len__5627__auto___23422)){
args23419.push((arguments[i__5628__auto___23423]));

var G__23424 = (i__5628__auto___23423 + (1));
i__5628__auto___23423 = G__23424;
continue;
} else {
}
break;
}

var G__23421 = args23419.length;
switch (G__23421) {
case 1:
return sablono.core.image23418.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image23418.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23419.length)].join('')));

}
});

sablono.core.image23418.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image23418.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image23418.cljs$lang$maxFixedArity = 2;

sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image23418);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__23426_SHARP_,p2__23427_SHARP_){
return [cljs.core.str(p1__23426_SHARP_),cljs.core.str("["),cljs.core.str(p2__23427_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__23428_SHARP_,p2__23429_SHARP_){
return [cljs.core.str(p1__23428_SHARP_),cljs.core.str("-"),cljs.core.str(p2__23429_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field23430 = (function sablono$core$color_field23430(var_args){
var args23431 = [];
var len__5627__auto___23498 = arguments.length;
var i__5628__auto___23499 = (0);
while(true){
if((i__5628__auto___23499 < len__5627__auto___23498)){
args23431.push((arguments[i__5628__auto___23499]));

var G__23500 = (i__5628__auto___23499 + (1));
i__5628__auto___23499 = G__23500;
continue;
} else {
}
break;
}

var G__23433 = args23431.length;
switch (G__23433) {
case 1:
return sablono.core.color_field23430.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field23430.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23431.length)].join('')));

}
});

sablono.core.color_field23430.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.color_field23430.call(null,name__7494__auto__,null);
});

sablono.core.color_field23430.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.color_field23430.cljs$lang$maxFixedArity = 2;

sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field23430);

/**
 * Creates a date input field.
 */
sablono.core.date_field23434 = (function sablono$core$date_field23434(var_args){
var args23435 = [];
var len__5627__auto___23502 = arguments.length;
var i__5628__auto___23503 = (0);
while(true){
if((i__5628__auto___23503 < len__5627__auto___23502)){
args23435.push((arguments[i__5628__auto___23503]));

var G__23504 = (i__5628__auto___23503 + (1));
i__5628__auto___23503 = G__23504;
continue;
} else {
}
break;
}

var G__23437 = args23435.length;
switch (G__23437) {
case 1:
return sablono.core.date_field23434.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field23434.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23435.length)].join('')));

}
});

sablono.core.date_field23434.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.date_field23434.call(null,name__7494__auto__,null);
});

sablono.core.date_field23434.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.date_field23434.cljs$lang$maxFixedArity = 2;

sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field23434);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field23438 = (function sablono$core$datetime_field23438(var_args){
var args23439 = [];
var len__5627__auto___23506 = arguments.length;
var i__5628__auto___23507 = (0);
while(true){
if((i__5628__auto___23507 < len__5627__auto___23506)){
args23439.push((arguments[i__5628__auto___23507]));

var G__23508 = (i__5628__auto___23507 + (1));
i__5628__auto___23507 = G__23508;
continue;
} else {
}
break;
}

var G__23441 = args23439.length;
switch (G__23441) {
case 1:
return sablono.core.datetime_field23438.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field23438.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23439.length)].join('')));

}
});

sablono.core.datetime_field23438.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.datetime_field23438.call(null,name__7494__auto__,null);
});

sablono.core.datetime_field23438.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.datetime_field23438.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field23438);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field23442 = (function sablono$core$datetime_local_field23442(var_args){
var args23443 = [];
var len__5627__auto___23510 = arguments.length;
var i__5628__auto___23511 = (0);
while(true){
if((i__5628__auto___23511 < len__5627__auto___23510)){
args23443.push((arguments[i__5628__auto___23511]));

var G__23512 = (i__5628__auto___23511 + (1));
i__5628__auto___23511 = G__23512;
continue;
} else {
}
break;
}

var G__23445 = args23443.length;
switch (G__23445) {
case 1:
return sablono.core.datetime_local_field23442.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field23442.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23443.length)].join('')));

}
});

sablono.core.datetime_local_field23442.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.datetime_local_field23442.call(null,name__7494__auto__,null);
});

sablono.core.datetime_local_field23442.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.datetime_local_field23442.cljs$lang$maxFixedArity = 2;

sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field23442);

/**
 * Creates a email input field.
 */
sablono.core.email_field23446 = (function sablono$core$email_field23446(var_args){
var args23447 = [];
var len__5627__auto___23514 = arguments.length;
var i__5628__auto___23515 = (0);
while(true){
if((i__5628__auto___23515 < len__5627__auto___23514)){
args23447.push((arguments[i__5628__auto___23515]));

var G__23516 = (i__5628__auto___23515 + (1));
i__5628__auto___23515 = G__23516;
continue;
} else {
}
break;
}

var G__23449 = args23447.length;
switch (G__23449) {
case 1:
return sablono.core.email_field23446.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field23446.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23447.length)].join('')));

}
});

sablono.core.email_field23446.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.email_field23446.call(null,name__7494__auto__,null);
});

sablono.core.email_field23446.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.email_field23446.cljs$lang$maxFixedArity = 2;

sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field23446);

/**
 * Creates a file input field.
 */
sablono.core.file_field23450 = (function sablono$core$file_field23450(var_args){
var args23451 = [];
var len__5627__auto___23518 = arguments.length;
var i__5628__auto___23519 = (0);
while(true){
if((i__5628__auto___23519 < len__5627__auto___23518)){
args23451.push((arguments[i__5628__auto___23519]));

var G__23520 = (i__5628__auto___23519 + (1));
i__5628__auto___23519 = G__23520;
continue;
} else {
}
break;
}

var G__23453 = args23451.length;
switch (G__23453) {
case 1:
return sablono.core.file_field23450.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field23450.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23451.length)].join('')));

}
});

sablono.core.file_field23450.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.file_field23450.call(null,name__7494__auto__,null);
});

sablono.core.file_field23450.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.file_field23450.cljs$lang$maxFixedArity = 2;

sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field23450);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field23454 = (function sablono$core$hidden_field23454(var_args){
var args23455 = [];
var len__5627__auto___23522 = arguments.length;
var i__5628__auto___23523 = (0);
while(true){
if((i__5628__auto___23523 < len__5627__auto___23522)){
args23455.push((arguments[i__5628__auto___23523]));

var G__23524 = (i__5628__auto___23523 + (1));
i__5628__auto___23523 = G__23524;
continue;
} else {
}
break;
}

var G__23457 = args23455.length;
switch (G__23457) {
case 1:
return sablono.core.hidden_field23454.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field23454.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23455.length)].join('')));

}
});

sablono.core.hidden_field23454.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.hidden_field23454.call(null,name__7494__auto__,null);
});

sablono.core.hidden_field23454.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.hidden_field23454.cljs$lang$maxFixedArity = 2;

sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field23454);

/**
 * Creates a month input field.
 */
sablono.core.month_field23458 = (function sablono$core$month_field23458(var_args){
var args23459 = [];
var len__5627__auto___23526 = arguments.length;
var i__5628__auto___23527 = (0);
while(true){
if((i__5628__auto___23527 < len__5627__auto___23526)){
args23459.push((arguments[i__5628__auto___23527]));

var G__23528 = (i__5628__auto___23527 + (1));
i__5628__auto___23527 = G__23528;
continue;
} else {
}
break;
}

var G__23461 = args23459.length;
switch (G__23461) {
case 1:
return sablono.core.month_field23458.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field23458.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23459.length)].join('')));

}
});

sablono.core.month_field23458.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.month_field23458.call(null,name__7494__auto__,null);
});

sablono.core.month_field23458.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.month_field23458.cljs$lang$maxFixedArity = 2;

sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field23458);

/**
 * Creates a number input field.
 */
sablono.core.number_field23462 = (function sablono$core$number_field23462(var_args){
var args23463 = [];
var len__5627__auto___23530 = arguments.length;
var i__5628__auto___23531 = (0);
while(true){
if((i__5628__auto___23531 < len__5627__auto___23530)){
args23463.push((arguments[i__5628__auto___23531]));

var G__23532 = (i__5628__auto___23531 + (1));
i__5628__auto___23531 = G__23532;
continue;
} else {
}
break;
}

var G__23465 = args23463.length;
switch (G__23465) {
case 1:
return sablono.core.number_field23462.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field23462.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23463.length)].join('')));

}
});

sablono.core.number_field23462.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.number_field23462.call(null,name__7494__auto__,null);
});

sablono.core.number_field23462.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.number_field23462.cljs$lang$maxFixedArity = 2;

sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field23462);

/**
 * Creates a password input field.
 */
sablono.core.password_field23466 = (function sablono$core$password_field23466(var_args){
var args23467 = [];
var len__5627__auto___23534 = arguments.length;
var i__5628__auto___23535 = (0);
while(true){
if((i__5628__auto___23535 < len__5627__auto___23534)){
args23467.push((arguments[i__5628__auto___23535]));

var G__23536 = (i__5628__auto___23535 + (1));
i__5628__auto___23535 = G__23536;
continue;
} else {
}
break;
}

var G__23469 = args23467.length;
switch (G__23469) {
case 1:
return sablono.core.password_field23466.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field23466.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23467.length)].join('')));

}
});

sablono.core.password_field23466.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.password_field23466.call(null,name__7494__auto__,null);
});

sablono.core.password_field23466.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.password_field23466.cljs$lang$maxFixedArity = 2;

sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field23466);

/**
 * Creates a range input field.
 */
sablono.core.range_field23470 = (function sablono$core$range_field23470(var_args){
var args23471 = [];
var len__5627__auto___23538 = arguments.length;
var i__5628__auto___23539 = (0);
while(true){
if((i__5628__auto___23539 < len__5627__auto___23538)){
args23471.push((arguments[i__5628__auto___23539]));

var G__23540 = (i__5628__auto___23539 + (1));
i__5628__auto___23539 = G__23540;
continue;
} else {
}
break;
}

var G__23473 = args23471.length;
switch (G__23473) {
case 1:
return sablono.core.range_field23470.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field23470.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23471.length)].join('')));

}
});

sablono.core.range_field23470.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.range_field23470.call(null,name__7494__auto__,null);
});

sablono.core.range_field23470.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.range_field23470.cljs$lang$maxFixedArity = 2;

sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field23470);

/**
 * Creates a search input field.
 */
sablono.core.search_field23474 = (function sablono$core$search_field23474(var_args){
var args23475 = [];
var len__5627__auto___23542 = arguments.length;
var i__5628__auto___23543 = (0);
while(true){
if((i__5628__auto___23543 < len__5627__auto___23542)){
args23475.push((arguments[i__5628__auto___23543]));

var G__23544 = (i__5628__auto___23543 + (1));
i__5628__auto___23543 = G__23544;
continue;
} else {
}
break;
}

var G__23477 = args23475.length;
switch (G__23477) {
case 1:
return sablono.core.search_field23474.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field23474.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23475.length)].join('')));

}
});

sablono.core.search_field23474.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.search_field23474.call(null,name__7494__auto__,null);
});

sablono.core.search_field23474.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.search_field23474.cljs$lang$maxFixedArity = 2;

sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field23474);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field23478 = (function sablono$core$tel_field23478(var_args){
var args23479 = [];
var len__5627__auto___23546 = arguments.length;
var i__5628__auto___23547 = (0);
while(true){
if((i__5628__auto___23547 < len__5627__auto___23546)){
args23479.push((arguments[i__5628__auto___23547]));

var G__23548 = (i__5628__auto___23547 + (1));
i__5628__auto___23547 = G__23548;
continue;
} else {
}
break;
}

var G__23481 = args23479.length;
switch (G__23481) {
case 1:
return sablono.core.tel_field23478.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field23478.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23479.length)].join('')));

}
});

sablono.core.tel_field23478.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.tel_field23478.call(null,name__7494__auto__,null);
});

sablono.core.tel_field23478.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.tel_field23478.cljs$lang$maxFixedArity = 2;

sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field23478);

/**
 * Creates a text input field.
 */
sablono.core.text_field23482 = (function sablono$core$text_field23482(var_args){
var args23483 = [];
var len__5627__auto___23550 = arguments.length;
var i__5628__auto___23551 = (0);
while(true){
if((i__5628__auto___23551 < len__5627__auto___23550)){
args23483.push((arguments[i__5628__auto___23551]));

var G__23552 = (i__5628__auto___23551 + (1));
i__5628__auto___23551 = G__23552;
continue;
} else {
}
break;
}

var G__23485 = args23483.length;
switch (G__23485) {
case 1:
return sablono.core.text_field23482.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field23482.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23483.length)].join('')));

}
});

sablono.core.text_field23482.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.text_field23482.call(null,name__7494__auto__,null);
});

sablono.core.text_field23482.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.text_field23482.cljs$lang$maxFixedArity = 2;

sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field23482);

/**
 * Creates a time input field.
 */
sablono.core.time_field23486 = (function sablono$core$time_field23486(var_args){
var args23487 = [];
var len__5627__auto___23554 = arguments.length;
var i__5628__auto___23555 = (0);
while(true){
if((i__5628__auto___23555 < len__5627__auto___23554)){
args23487.push((arguments[i__5628__auto___23555]));

var G__23556 = (i__5628__auto___23555 + (1));
i__5628__auto___23555 = G__23556;
continue;
} else {
}
break;
}

var G__23489 = args23487.length;
switch (G__23489) {
case 1:
return sablono.core.time_field23486.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field23486.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23487.length)].join('')));

}
});

sablono.core.time_field23486.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.time_field23486.call(null,name__7494__auto__,null);
});

sablono.core.time_field23486.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.time_field23486.cljs$lang$maxFixedArity = 2;

sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field23486);

/**
 * Creates a url input field.
 */
sablono.core.url_field23490 = (function sablono$core$url_field23490(var_args){
var args23491 = [];
var len__5627__auto___23558 = arguments.length;
var i__5628__auto___23559 = (0);
while(true){
if((i__5628__auto___23559 < len__5627__auto___23558)){
args23491.push((arguments[i__5628__auto___23559]));

var G__23560 = (i__5628__auto___23559 + (1));
i__5628__auto___23559 = G__23560;
continue;
} else {
}
break;
}

var G__23493 = args23491.length;
switch (G__23493) {
case 1:
return sablono.core.url_field23490.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field23490.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23491.length)].join('')));

}
});

sablono.core.url_field23490.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.url_field23490.call(null,name__7494__auto__,null);
});

sablono.core.url_field23490.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.url_field23490.cljs$lang$maxFixedArity = 2;

sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field23490);

/**
 * Creates a week input field.
 */
sablono.core.week_field23494 = (function sablono$core$week_field23494(var_args){
var args23495 = [];
var len__5627__auto___23562 = arguments.length;
var i__5628__auto___23563 = (0);
while(true){
if((i__5628__auto___23563 < len__5627__auto___23562)){
args23495.push((arguments[i__5628__auto___23563]));

var G__23564 = (i__5628__auto___23563 + (1));
i__5628__auto___23563 = G__23564;
continue;
} else {
}
break;
}

var G__23497 = args23495.length;
switch (G__23497) {
case 1:
return sablono.core.week_field23494.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field23494.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23495.length)].join('')));

}
});

sablono.core.week_field23494.cljs$core$IFn$_invoke$arity$1 = (function (name__7494__auto__){
return sablono.core.week_field23494.call(null,name__7494__auto__,null);
});

sablono.core.week_field23494.cljs$core$IFn$_invoke$arity$2 = (function (name__7494__auto__,value__7495__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__7494__auto__,value__7495__auto__);
});

sablono.core.week_field23494.cljs$lang$maxFixedArity = 2;

sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field23494);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box23566 = (function sablono$core$check_box23566(var_args){
var args23567 = [];
var len__5627__auto___23570 = arguments.length;
var i__5628__auto___23571 = (0);
while(true){
if((i__5628__auto___23571 < len__5627__auto___23570)){
args23567.push((arguments[i__5628__auto___23571]));

var G__23572 = (i__5628__auto___23571 + (1));
i__5628__auto___23571 = G__23572;
continue;
} else {
}
break;
}

var G__23569 = args23567.length;
switch (G__23569) {
case 1:
return sablono.core.check_box23566.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box23566.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box23566.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23567.length)].join('')));

}
});

sablono.core.check_box23566.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box23566.call(null,name,null);
});

sablono.core.check_box23566.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box23566.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box23566.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box23566.cljs$lang$maxFixedArity = 3;

sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box23566);
/**
 * Creates a radio button.
 */
sablono.core.radio_button23574 = (function sablono$core$radio_button23574(var_args){
var args23575 = [];
var len__5627__auto___23578 = arguments.length;
var i__5628__auto___23579 = (0);
while(true){
if((i__5628__auto___23579 < len__5627__auto___23578)){
args23575.push((arguments[i__5628__auto___23579]));

var G__23580 = (i__5628__auto___23579 + (1));
i__5628__auto___23579 = G__23580;
continue;
} else {
}
break;
}

var G__23577 = args23575.length;
switch (G__23577) {
case 1:
return sablono.core.radio_button23574.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button23574.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button23574.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23575.length)].join('')));

}
});

sablono.core.radio_button23574.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button23574.call(null,group,null);
});

sablono.core.radio_button23574.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button23574.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button23574.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button23574.cljs$lang$maxFixedArity = 3;

sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button23574);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options23582 = (function sablono$core$select_options23582(var_args){
var args23583 = [];
var len__5627__auto___23594 = arguments.length;
var i__5628__auto___23595 = (0);
while(true){
if((i__5628__auto___23595 < len__5627__auto___23594)){
args23583.push((arguments[i__5628__auto___23595]));

var G__23596 = (i__5628__auto___23595 + (1));
i__5628__auto___23595 = G__23596;
continue;
} else {
}
break;
}

var G__23585 = args23583.length;
switch (G__23585) {
case 1:
return sablono.core.select_options23582.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options23582.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23583.length)].join('')));

}
});

sablono.core.select_options23582.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options23582.call(null,coll,null);
});

sablono.core.select_options23582.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__5341__auto__ = (function sablono$core$iter__23586(s__23587){
return (new cljs.core.LazySeq(null,(function (){
var s__23587__$1 = s__23587;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__23587__$1);
if(temp__4425__auto__){
var s__23587__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23587__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__23587__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__23589 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__23588 = (0);
while(true){
if((i__23588 < size__5340__auto__)){
var x = cljs.core._nth.call(null,c__5339__auto__,i__23588);
cljs.core.chunk_append.call(null,b__23589,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23592 = x;
var text = cljs.core.nth.call(null,vec__23592,(0),null);
var val = cljs.core.nth.call(null,vec__23592,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23592,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options23582.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__23598 = (i__23588 + (1));
i__23588 = G__23598;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23589),sablono$core$iter__23586.call(null,cljs.core.chunk_rest.call(null,s__23587__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23589),null);
}
} else {
var x = cljs.core.first.call(null,s__23587__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__23593 = x;
var text = cljs.core.nth.call(null,vec__23593,(0),null);
var val = cljs.core.nth.call(null,vec__23593,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__23593,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options23582.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__23586.call(null,cljs.core.rest.call(null,s__23587__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5341__auto__.call(null,coll);
});

sablono.core.select_options23582.cljs$lang$maxFixedArity = 2;

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options23582);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down23599 = (function sablono$core$drop_down23599(var_args){
var args23600 = [];
var len__5627__auto___23603 = arguments.length;
var i__5628__auto___23604 = (0);
while(true){
if((i__5628__auto___23604 < len__5627__auto___23603)){
args23600.push((arguments[i__5628__auto___23604]));

var G__23605 = (i__5628__auto___23604 + (1));
i__5628__auto___23604 = G__23605;
continue;
} else {
}
break;
}

var G__23602 = args23600.length;
switch (G__23602) {
case 2:
return sablono.core.drop_down23599.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down23599.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23600.length)].join('')));

}
});

sablono.core.drop_down23599.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down23599.call(null,name,options,null);
});

sablono.core.drop_down23599.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down23599.cljs$lang$maxFixedArity = 3;

sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down23599);
/**
 * Creates a text area element.
 */
sablono.core.text_area23607 = (function sablono$core$text_area23607(var_args){
var args23608 = [];
var len__5627__auto___23611 = arguments.length;
var i__5628__auto___23612 = (0);
while(true){
if((i__5628__auto___23612 < len__5627__auto___23611)){
args23608.push((arguments[i__5628__auto___23612]));

var G__23613 = (i__5628__auto___23612 + (1));
i__5628__auto___23612 = G__23613;
continue;
} else {
}
break;
}

var G__23610 = args23608.length;
switch (G__23610) {
case 1:
return sablono.core.text_area23607.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area23607.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23608.length)].join('')));

}
});

sablono.core.text_area23607.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area23607.call(null,name,null);
});

sablono.core.text_area23607.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area23607.cljs$lang$maxFixedArity = 2;

sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area23607);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label23615 = (function sablono$core$label23615(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label23615);
/**
 * Creates a submit button.
 */
sablono.core.submit_button23616 = (function sablono$core$submit_button23616(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button23616);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button23617 = (function sablono$core$reset_button23617(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button23617);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to23618 = (function sablono$core$form_to23618(var_args){
var args__5634__auto__ = [];
var len__5627__auto___23623 = arguments.length;
var i__5628__auto___23624 = (0);
while(true){
if((i__5628__auto___23624 < len__5627__auto___23623)){
args__5634__auto__.push((arguments[i__5628__auto___23624]));

var G__23625 = (i__5628__auto___23624 + (1));
i__5628__auto___23624 = G__23625;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return sablono.core.form_to23618.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

sablono.core.form_to23618.cljs$core$IFn$_invoke$arity$variadic = (function (p__23621,body){
var vec__23622 = p__23621;
var method = cljs.core.nth.call(null,vec__23622,(0),null);
var action = cljs.core.nth.call(null,vec__23622,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to23618.cljs$lang$maxFixedArity = (1);

sablono.core.form_to23618.cljs$lang$applyTo = (function (seq23619){
var G__23620 = cljs.core.first.call(null,seq23619);
var seq23619__$1 = cljs.core.next.call(null,seq23619);
return sablono.core.form_to23618.cljs$core$IFn$_invoke$arity$variadic(G__23620,seq23619__$1);
});

sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to23618);
