// Compiled by ClojureScript 1.8.51 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__6873__auto__ = (((x == null))?null:x);
var m__6874__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__6873__auto__)]);
if(!((m__6874__auto__ == null))){
return m__6874__auto__.call(null,x);
} else {
var m__6874__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__6874__auto____$1 == null))){
return m__6874__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args17029 = [];
var len__7280__auto___17032 = arguments.length;
var i__7281__auto___17033 = (0);
while(true){
if((i__7281__auto___17033 < len__7280__auto___17032)){
args17029.push((arguments[i__7281__auto___17033]));

var G__17034 = (i__7281__auto___17033 + (1));
i__7281__auto___17033 = G__17034;
continue;
} else {
}
break;
}

var G__17031 = args17029.length;
switch (G__17031) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17029.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args17036 = [];
var len__7280__auto___17039 = arguments.length;
var i__7281__auto___17040 = (0);
while(true){
if((i__7281__auto___17040 < len__7280__auto___17039)){
args17036.push((arguments[i__7281__auto___17040]));

var G__17041 = (i__7281__auto___17040 + (1));
i__7281__auto___17040 = G__17041;
continue;
} else {
}
break;
}

var G__17038 = args17036.length;
switch (G__17038) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17036.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args17043 = [];
var len__7280__auto___17052 = arguments.length;
var i__7281__auto___17053 = (0);
while(true){
if((i__7281__auto___17053 < len__7280__auto___17052)){
args17043.push((arguments[i__7281__auto___17053]));

var G__17054 = (i__7281__auto___17053 + (1));
i__7281__auto___17053 = G__17054;
continue;
} else {
}
break;
}

var G__17045 = args17043.length;
switch (G__17045) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17043.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__17046_17056 = cljs.core.seq.call(null,x);
var chunk__17047_17057 = null;
var count__17048_17058 = (0);
var i__17049_17059 = (0);
while(true){
if((i__17049_17059 < count__17048_17058)){
var vec__17050_17060 = cljs.core._nth.call(null,chunk__17047_17057,i__17049_17059);
var k_17061 = cljs.core.nth.call(null,vec__17050_17060,(0),null);
var v_17062 = cljs.core.nth.call(null,vec__17050_17060,(1),null);
c2.dom.style.call(null,el__$1,k_17061,v_17062);

var G__17063 = seq__17046_17056;
var G__17064 = chunk__17047_17057;
var G__17065 = count__17048_17058;
var G__17066 = (i__17049_17059 + (1));
seq__17046_17056 = G__17063;
chunk__17047_17057 = G__17064;
count__17048_17058 = G__17065;
i__17049_17059 = G__17066;
continue;
} else {
var temp__4657__auto___17067 = cljs.core.seq.call(null,seq__17046_17056);
if(temp__4657__auto___17067){
var seq__17046_17068__$1 = temp__4657__auto___17067;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17046_17068__$1)){
var c__7021__auto___17069 = cljs.core.chunk_first.call(null,seq__17046_17068__$1);
var G__17070 = cljs.core.chunk_rest.call(null,seq__17046_17068__$1);
var G__17071 = c__7021__auto___17069;
var G__17072 = cljs.core.count.call(null,c__7021__auto___17069);
var G__17073 = (0);
seq__17046_17056 = G__17070;
chunk__17047_17057 = G__17071;
count__17048_17058 = G__17072;
i__17049_17059 = G__17073;
continue;
} else {
var vec__17051_17074 = cljs.core.first.call(null,seq__17046_17068__$1);
var k_17075 = cljs.core.nth.call(null,vec__17051_17074,(0),null);
var v_17076 = cljs.core.nth.call(null,vec__17051_17074,(1),null);
c2.dom.style.call(null,el__$1,k_17075,v_17076);

var G__17077 = cljs.core.next.call(null,seq__17046_17068__$1);
var G__17078 = null;
var G__17079 = (0);
var G__17080 = (0);
seq__17046_17056 = G__17077;
chunk__17047_17057 = G__17078;
count__17048_17058 = G__17079;
i__17049_17059 = G__17080;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args17081 = [];
var len__7280__auto___17094 = arguments.length;
var i__7281__auto___17095 = (0);
while(true){
if((i__7281__auto___17095 < len__7280__auto___17094)){
args17081.push((arguments[i__7281__auto___17095]));

var G__17096 = (i__7281__auto___17095 + (1));
i__7281__auto___17095 = G__17096;
continue;
} else {
}
break;
}

var G__17083 = args17081.length;
switch (G__17083) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17081.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6990__auto__ = ((function (attrs){
return (function c2$dom$iter__17084(s__17085){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__17085__$1 = s__17085;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17085__$1);
if(temp__4657__auto__){
var s__17085__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17085__$2)){
var c__6988__auto__ = cljs.core.chunk_first.call(null,s__17085__$2);
var size__6989__auto__ = cljs.core.count.call(null,c__6988__auto__);
var b__17087 = cljs.core.chunk_buffer.call(null,size__6989__auto__);
if((function (){var i__17086 = (0);
while(true){
if((i__17086 < size__6989__auto__)){
var i = cljs.core._nth.call(null,c__6988__auto__,i__17086);
cljs.core.chunk_append.call(null,b__17087,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__17098 = (i__17086 + (1));
i__17086 = G__17098;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17087),c2$dom$iter__17084.call(null,cljs.core.chunk_rest.call(null,s__17085__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17087),null);
}
} else {
var i = cljs.core.first.call(null,s__17085__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__17084.call(null,cljs.core.rest.call(null,s__17085__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__6990__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__17088_17099 = cljs.core.seq.call(null,x);
var chunk__17089_17100 = null;
var count__17090_17101 = (0);
var i__17091_17102 = (0);
while(true){
if((i__17091_17102 < count__17090_17101)){
var vec__17092_17103 = cljs.core._nth.call(null,chunk__17089_17100,i__17091_17102);
var k_17104 = cljs.core.nth.call(null,vec__17092_17103,(0),null);
var v_17105 = cljs.core.nth.call(null,vec__17092_17103,(1),null);
c2.dom.attr.call(null,el__$1,k_17104,v_17105);

var G__17106 = seq__17088_17099;
var G__17107 = chunk__17089_17100;
var G__17108 = count__17090_17101;
var G__17109 = (i__17091_17102 + (1));
seq__17088_17099 = G__17106;
chunk__17089_17100 = G__17107;
count__17090_17101 = G__17108;
i__17091_17102 = G__17109;
continue;
} else {
var temp__4657__auto___17110 = cljs.core.seq.call(null,seq__17088_17099);
if(temp__4657__auto___17110){
var seq__17088_17111__$1 = temp__4657__auto___17110;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17088_17111__$1)){
var c__7021__auto___17112 = cljs.core.chunk_first.call(null,seq__17088_17111__$1);
var G__17113 = cljs.core.chunk_rest.call(null,seq__17088_17111__$1);
var G__17114 = c__7021__auto___17112;
var G__17115 = cljs.core.count.call(null,c__7021__auto___17112);
var G__17116 = (0);
seq__17088_17099 = G__17113;
chunk__17089_17100 = G__17114;
count__17090_17101 = G__17115;
i__17091_17102 = G__17116;
continue;
} else {
var vec__17093_17117 = cljs.core.first.call(null,seq__17088_17111__$1);
var k_17118 = cljs.core.nth.call(null,vec__17093_17117,(0),null);
var v_17119 = cljs.core.nth.call(null,vec__17093_17117,(1),null);
c2.dom.attr.call(null,el__$1,k_17118,v_17119);

var G__17120 = cljs.core.next.call(null,seq__17088_17111__$1);
var G__17121 = null;
var G__17122 = (0);
var G__17123 = (0);
seq__17088_17099 = G__17120;
chunk__17089_17100 = G__17121;
count__17090_17101 = G__17122;
i__17091_17102 = G__17123;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args17124 = [];
var len__7280__auto___17127 = arguments.length;
var i__7281__auto___17128 = (0);
while(true){
if((i__7281__auto___17128 < len__7280__auto___17127)){
args17124.push((arguments[i__7281__auto___17128]));

var G__17129 = (i__7281__auto___17128 + (1));
i__7281__auto___17128 = G__17129;
continue;
} else {
}
break;
}

var G__17126 = args17124.length;
switch (G__17126) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17124.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args17131 = [];
var len__7280__auto___17134 = arguments.length;
var i__7281__auto___17135 = (0);
while(true){
if((i__7281__auto___17135 < len__7280__auto___17134)){
args17131.push((arguments[i__7281__auto___17135]));

var G__17136 = (i__7281__auto___17135 + (1));
i__7281__auto___17135 = G__17136;
continue;
} else {
}
break;
}

var G__17133 = args17131.length;
switch (G__17133) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17131.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6210__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
var or__6210__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6210__auto____$1)){
return or__6210__auto____$1;
} else {
return ((function (or__6210__auto____$1,or__6210__auto__){
return (function (p1__17138_SHARP_){
return setTimeout(((function (or__6210__auto____$1,or__6210__auto__){
return (function (){
return p1__17138_SHARP_.call(null);
});})(or__6210__auto____$1,or__6210__auto__))
,(10));
});
;})(or__6210__auto____$1,or__6210__auto__))
}
}
})();
