// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19452__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19449 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__19450 = cljs.core.seq.call(null,vec__19449);
var first__19451 = cljs.core.first.call(null,seq__19450);
var seq__19450__$1 = cljs.core.next.call(null,seq__19450);
var tag = first__19451;
var body = seq__19450__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19452 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19453__i = 0, G__19453__a = new Array(arguments.length -  0);
while (G__19453__i < G__19453__a.length) {G__19453__a[G__19453__i] = arguments[G__19453__i + 0]; ++G__19453__i;}
  args = new cljs.core.IndexedSeq(G__19453__a,0);
} 
return G__19452__delegate.call(this,args);};
G__19452.cljs$lang$maxFixedArity = 0;
G__19452.cljs$lang$applyTo = (function (arglist__19454){
var args = cljs.core.seq(arglist__19454);
return G__19452__delegate(args);
});
G__19452.cljs$core$IFn$_invoke$arity$variadic = G__19452__delegate;
return G__19452;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__19459(s__19460){
return (new cljs.core.LazySeq(null,(function (){
var s__19460__$1 = s__19460;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19460__$1);
if(temp__4657__auto__){
var s__19460__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19460__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19460__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19462 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19461 = (0);
while(true){
if((i__19461 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__19461);
cljs.core.chunk_append.call(null,b__19462,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19463 = (i__19461 + (1));
i__19461 = G__19463;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19462),sablono$core$update_arglists_$_iter__19459.call(null,cljs.core.chunk_rest.call(null,s__19460__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19462),null);
}
} else {
var args = cljs.core.first.call(null,s__19460__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19459.call(null,cljs.core.rest.call(null,s__19460__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19469 = arguments.length;
var i__7485__auto___19470 = (0);
while(true){
if((i__7485__auto___19470 < len__7484__auto___19469)){
args__7491__auto__.push((arguments[i__7485__auto___19470]));

var G__19471 = (i__7485__auto___19470 + (1));
i__7485__auto___19470 = G__19471;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__19465(s__19466){
return (new cljs.core.LazySeq(null,(function (){
var s__19466__$1 = s__19466;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19466__$1);
if(temp__4657__auto__){
var s__19466__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19466__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19466__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19468 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19467 = (0);
while(true){
if((i__19467 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__19467);
cljs.core.chunk_append.call(null,b__19468,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19472 = (i__19467 + (1));
i__19467 = G__19472;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19468),sablono$core$iter__19465.call(null,cljs.core.chunk_rest.call(null,s__19466__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19468),null);
}
} else {
var style = cljs.core.first.call(null,s__19466__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19465.call(null,cljs.core.rest.call(null,s__19466__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19464){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19464));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19473 = (function sablono$core$link_to19473(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19476 = arguments.length;
var i__7485__auto___19477 = (0);
while(true){
if((i__7485__auto___19477 < len__7484__auto___19476)){
args__7491__auto__.push((arguments[i__7485__auto___19477]));

var G__19478 = (i__7485__auto___19477 + (1));
i__7485__auto___19477 = G__19478;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to19473.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to19473.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19473.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19473.cljs$lang$applyTo = (function (seq19474){
var G__19475 = cljs.core.first.call(null,seq19474);
var seq19474__$1 = cljs.core.next.call(null,seq19474);
return sablono.core.link_to19473.cljs$core$IFn$_invoke$arity$variadic(G__19475,seq19474__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19473);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19479 = (function sablono$core$mail_to19479(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19486 = arguments.length;
var i__7485__auto___19487 = (0);
while(true){
if((i__7485__auto___19487 < len__7484__auto___19486)){
args__7491__auto__.push((arguments[i__7485__auto___19487]));

var G__19488 = (i__7485__auto___19487 + (1));
i__7485__auto___19487 = G__19488;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to19479.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to19479.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19482){
var vec__19483 = p__19482;
var content = cljs.core.nth.call(null,vec__19483,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19479.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19479.cljs$lang$applyTo = (function (seq19480){
var G__19481 = cljs.core.first.call(null,seq19480);
var seq19480__$1 = cljs.core.next.call(null,seq19480);
return sablono.core.mail_to19479.cljs$core$IFn$_invoke$arity$variadic(G__19481,seq19480__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19479);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19489 = (function sablono$core$unordered_list19489(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list19489_$_iter__19494(s__19495){
return (new cljs.core.LazySeq(null,(function (){
var s__19495__$1 = s__19495;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19495__$1);
if(temp__4657__auto__){
var s__19495__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19495__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19495__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19497 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19496 = (0);
while(true){
if((i__19496 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19496);
cljs.core.chunk_append.call(null,b__19497,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19498 = (i__19496 + (1));
i__19496 = G__19498;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19497),sablono$core$unordered_list19489_$_iter__19494.call(null,cljs.core.chunk_rest.call(null,s__19495__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19497),null);
}
} else {
var x = cljs.core.first.call(null,s__19495__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19489_$_iter__19494.call(null,cljs.core.rest.call(null,s__19495__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19489);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19499 = (function sablono$core$ordered_list19499(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list19499_$_iter__19504(s__19505){
return (new cljs.core.LazySeq(null,(function (){
var s__19505__$1 = s__19505;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19505__$1);
if(temp__4657__auto__){
var s__19505__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19505__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19505__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19507 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19506 = (0);
while(true){
if((i__19506 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19506);
cljs.core.chunk_append.call(null,b__19507,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19508 = (i__19506 + (1));
i__19506 = G__19508;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19507),sablono$core$ordered_list19499_$_iter__19504.call(null,cljs.core.chunk_rest.call(null,s__19505__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19507),null);
}
} else {
var x = cljs.core.first.call(null,s__19505__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19499_$_iter__19504.call(null,cljs.core.rest.call(null,s__19505__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19499);
/**
 * Create an image element.
 */
sablono.core.image19509 = (function sablono$core$image19509(var_args){
var args19510 = [];
var len__7484__auto___19513 = arguments.length;
var i__7485__auto___19514 = (0);
while(true){
if((i__7485__auto___19514 < len__7484__auto___19513)){
args19510.push((arguments[i__7485__auto___19514]));

var G__19515 = (i__7485__auto___19514 + (1));
i__7485__auto___19514 = G__19515;
continue;
} else {
}
break;
}

var G__19512 = args19510.length;
switch (G__19512) {
case 1:
return sablono.core.image19509.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19509.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19510.length)].join('')));

}
});

sablono.core.image19509.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19509.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19509.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19509);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19517_SHARP_,p2__19518_SHARP_){
return [cljs.core.str(p1__19517_SHARP_),cljs.core.str("["),cljs.core.str(p2__19518_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19519_SHARP_,p2__19520_SHARP_){
return [cljs.core.str(p1__19519_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19520_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19521 = (function sablono$core$color_field19521(var_args){
var args19522 = [];
var len__7484__auto___19589 = arguments.length;
var i__7485__auto___19590 = (0);
while(true){
if((i__7485__auto___19590 < len__7484__auto___19589)){
args19522.push((arguments[i__7485__auto___19590]));

var G__19591 = (i__7485__auto___19590 + (1));
i__7485__auto___19590 = G__19591;
continue;
} else {
}
break;
}

var G__19524 = args19522.length;
switch (G__19524) {
case 1:
return sablono.core.color_field19521.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19521.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19522.length)].join('')));

}
});

sablono.core.color_field19521.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.color_field19521.call(null,name__19366__auto__,null);
});

sablono.core.color_field19521.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.color_field19521.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19521);

/**
 * Creates a date input field.
 */
sablono.core.date_field19525 = (function sablono$core$date_field19525(var_args){
var args19526 = [];
var len__7484__auto___19593 = arguments.length;
var i__7485__auto___19594 = (0);
while(true){
if((i__7485__auto___19594 < len__7484__auto___19593)){
args19526.push((arguments[i__7485__auto___19594]));

var G__19595 = (i__7485__auto___19594 + (1));
i__7485__auto___19594 = G__19595;
continue;
} else {
}
break;
}

var G__19528 = args19526.length;
switch (G__19528) {
case 1:
return sablono.core.date_field19525.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19525.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19526.length)].join('')));

}
});

sablono.core.date_field19525.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.date_field19525.call(null,name__19366__auto__,null);
});

sablono.core.date_field19525.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.date_field19525.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19525);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19529 = (function sablono$core$datetime_field19529(var_args){
var args19530 = [];
var len__7484__auto___19597 = arguments.length;
var i__7485__auto___19598 = (0);
while(true){
if((i__7485__auto___19598 < len__7484__auto___19597)){
args19530.push((arguments[i__7485__auto___19598]));

var G__19599 = (i__7485__auto___19598 + (1));
i__7485__auto___19598 = G__19599;
continue;
} else {
}
break;
}

var G__19532 = args19530.length;
switch (G__19532) {
case 1:
return sablono.core.datetime_field19529.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19529.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19530.length)].join('')));

}
});

sablono.core.datetime_field19529.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.datetime_field19529.call(null,name__19366__auto__,null);
});

sablono.core.datetime_field19529.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.datetime_field19529.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19529);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19533 = (function sablono$core$datetime_local_field19533(var_args){
var args19534 = [];
var len__7484__auto___19601 = arguments.length;
var i__7485__auto___19602 = (0);
while(true){
if((i__7485__auto___19602 < len__7484__auto___19601)){
args19534.push((arguments[i__7485__auto___19602]));

var G__19603 = (i__7485__auto___19602 + (1));
i__7485__auto___19602 = G__19603;
continue;
} else {
}
break;
}

var G__19536 = args19534.length;
switch (G__19536) {
case 1:
return sablono.core.datetime_local_field19533.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19533.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19534.length)].join('')));

}
});

sablono.core.datetime_local_field19533.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.datetime_local_field19533.call(null,name__19366__auto__,null);
});

sablono.core.datetime_local_field19533.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.datetime_local_field19533.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19533);

/**
 * Creates a email input field.
 */
sablono.core.email_field19537 = (function sablono$core$email_field19537(var_args){
var args19538 = [];
var len__7484__auto___19605 = arguments.length;
var i__7485__auto___19606 = (0);
while(true){
if((i__7485__auto___19606 < len__7484__auto___19605)){
args19538.push((arguments[i__7485__auto___19606]));

var G__19607 = (i__7485__auto___19606 + (1));
i__7485__auto___19606 = G__19607;
continue;
} else {
}
break;
}

var G__19540 = args19538.length;
switch (G__19540) {
case 1:
return sablono.core.email_field19537.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19537.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19538.length)].join('')));

}
});

sablono.core.email_field19537.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.email_field19537.call(null,name__19366__auto__,null);
});

sablono.core.email_field19537.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.email_field19537.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19537);

/**
 * Creates a file input field.
 */
sablono.core.file_field19541 = (function sablono$core$file_field19541(var_args){
var args19542 = [];
var len__7484__auto___19609 = arguments.length;
var i__7485__auto___19610 = (0);
while(true){
if((i__7485__auto___19610 < len__7484__auto___19609)){
args19542.push((arguments[i__7485__auto___19610]));

var G__19611 = (i__7485__auto___19610 + (1));
i__7485__auto___19610 = G__19611;
continue;
} else {
}
break;
}

var G__19544 = args19542.length;
switch (G__19544) {
case 1:
return sablono.core.file_field19541.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19541.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19542.length)].join('')));

}
});

sablono.core.file_field19541.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.file_field19541.call(null,name__19366__auto__,null);
});

sablono.core.file_field19541.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.file_field19541.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19541);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19545 = (function sablono$core$hidden_field19545(var_args){
var args19546 = [];
var len__7484__auto___19613 = arguments.length;
var i__7485__auto___19614 = (0);
while(true){
if((i__7485__auto___19614 < len__7484__auto___19613)){
args19546.push((arguments[i__7485__auto___19614]));

var G__19615 = (i__7485__auto___19614 + (1));
i__7485__auto___19614 = G__19615;
continue;
} else {
}
break;
}

var G__19548 = args19546.length;
switch (G__19548) {
case 1:
return sablono.core.hidden_field19545.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19545.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19546.length)].join('')));

}
});

sablono.core.hidden_field19545.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.hidden_field19545.call(null,name__19366__auto__,null);
});

sablono.core.hidden_field19545.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.hidden_field19545.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19545);

/**
 * Creates a month input field.
 */
sablono.core.month_field19549 = (function sablono$core$month_field19549(var_args){
var args19550 = [];
var len__7484__auto___19617 = arguments.length;
var i__7485__auto___19618 = (0);
while(true){
if((i__7485__auto___19618 < len__7484__auto___19617)){
args19550.push((arguments[i__7485__auto___19618]));

var G__19619 = (i__7485__auto___19618 + (1));
i__7485__auto___19618 = G__19619;
continue;
} else {
}
break;
}

var G__19552 = args19550.length;
switch (G__19552) {
case 1:
return sablono.core.month_field19549.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19549.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19550.length)].join('')));

}
});

sablono.core.month_field19549.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.month_field19549.call(null,name__19366__auto__,null);
});

sablono.core.month_field19549.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.month_field19549.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19549);

/**
 * Creates a number input field.
 */
sablono.core.number_field19553 = (function sablono$core$number_field19553(var_args){
var args19554 = [];
var len__7484__auto___19621 = arguments.length;
var i__7485__auto___19622 = (0);
while(true){
if((i__7485__auto___19622 < len__7484__auto___19621)){
args19554.push((arguments[i__7485__auto___19622]));

var G__19623 = (i__7485__auto___19622 + (1));
i__7485__auto___19622 = G__19623;
continue;
} else {
}
break;
}

var G__19556 = args19554.length;
switch (G__19556) {
case 1:
return sablono.core.number_field19553.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19553.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19554.length)].join('')));

}
});

sablono.core.number_field19553.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.number_field19553.call(null,name__19366__auto__,null);
});

sablono.core.number_field19553.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.number_field19553.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19553);

/**
 * Creates a password input field.
 */
sablono.core.password_field19557 = (function sablono$core$password_field19557(var_args){
var args19558 = [];
var len__7484__auto___19625 = arguments.length;
var i__7485__auto___19626 = (0);
while(true){
if((i__7485__auto___19626 < len__7484__auto___19625)){
args19558.push((arguments[i__7485__auto___19626]));

var G__19627 = (i__7485__auto___19626 + (1));
i__7485__auto___19626 = G__19627;
continue;
} else {
}
break;
}

var G__19560 = args19558.length;
switch (G__19560) {
case 1:
return sablono.core.password_field19557.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19557.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19558.length)].join('')));

}
});

sablono.core.password_field19557.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.password_field19557.call(null,name__19366__auto__,null);
});

sablono.core.password_field19557.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.password_field19557.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19557);

/**
 * Creates a range input field.
 */
sablono.core.range_field19561 = (function sablono$core$range_field19561(var_args){
var args19562 = [];
var len__7484__auto___19629 = arguments.length;
var i__7485__auto___19630 = (0);
while(true){
if((i__7485__auto___19630 < len__7484__auto___19629)){
args19562.push((arguments[i__7485__auto___19630]));

var G__19631 = (i__7485__auto___19630 + (1));
i__7485__auto___19630 = G__19631;
continue;
} else {
}
break;
}

var G__19564 = args19562.length;
switch (G__19564) {
case 1:
return sablono.core.range_field19561.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19561.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19562.length)].join('')));

}
});

sablono.core.range_field19561.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.range_field19561.call(null,name__19366__auto__,null);
});

sablono.core.range_field19561.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.range_field19561.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19561);

/**
 * Creates a search input field.
 */
sablono.core.search_field19565 = (function sablono$core$search_field19565(var_args){
var args19566 = [];
var len__7484__auto___19633 = arguments.length;
var i__7485__auto___19634 = (0);
while(true){
if((i__7485__auto___19634 < len__7484__auto___19633)){
args19566.push((arguments[i__7485__auto___19634]));

var G__19635 = (i__7485__auto___19634 + (1));
i__7485__auto___19634 = G__19635;
continue;
} else {
}
break;
}

var G__19568 = args19566.length;
switch (G__19568) {
case 1:
return sablono.core.search_field19565.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19565.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19566.length)].join('')));

}
});

sablono.core.search_field19565.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.search_field19565.call(null,name__19366__auto__,null);
});

sablono.core.search_field19565.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.search_field19565.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19565);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19569 = (function sablono$core$tel_field19569(var_args){
var args19570 = [];
var len__7484__auto___19637 = arguments.length;
var i__7485__auto___19638 = (0);
while(true){
if((i__7485__auto___19638 < len__7484__auto___19637)){
args19570.push((arguments[i__7485__auto___19638]));

var G__19639 = (i__7485__auto___19638 + (1));
i__7485__auto___19638 = G__19639;
continue;
} else {
}
break;
}

var G__19572 = args19570.length;
switch (G__19572) {
case 1:
return sablono.core.tel_field19569.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19569.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19570.length)].join('')));

}
});

sablono.core.tel_field19569.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.tel_field19569.call(null,name__19366__auto__,null);
});

sablono.core.tel_field19569.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.tel_field19569.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19569);

/**
 * Creates a text input field.
 */
sablono.core.text_field19573 = (function sablono$core$text_field19573(var_args){
var args19574 = [];
var len__7484__auto___19641 = arguments.length;
var i__7485__auto___19642 = (0);
while(true){
if((i__7485__auto___19642 < len__7484__auto___19641)){
args19574.push((arguments[i__7485__auto___19642]));

var G__19643 = (i__7485__auto___19642 + (1));
i__7485__auto___19642 = G__19643;
continue;
} else {
}
break;
}

var G__19576 = args19574.length;
switch (G__19576) {
case 1:
return sablono.core.text_field19573.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19573.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19574.length)].join('')));

}
});

sablono.core.text_field19573.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.text_field19573.call(null,name__19366__auto__,null);
});

sablono.core.text_field19573.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.text_field19573.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19573);

/**
 * Creates a time input field.
 */
sablono.core.time_field19577 = (function sablono$core$time_field19577(var_args){
var args19578 = [];
var len__7484__auto___19645 = arguments.length;
var i__7485__auto___19646 = (0);
while(true){
if((i__7485__auto___19646 < len__7484__auto___19645)){
args19578.push((arguments[i__7485__auto___19646]));

var G__19647 = (i__7485__auto___19646 + (1));
i__7485__auto___19646 = G__19647;
continue;
} else {
}
break;
}

var G__19580 = args19578.length;
switch (G__19580) {
case 1:
return sablono.core.time_field19577.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19577.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19578.length)].join('')));

}
});

sablono.core.time_field19577.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.time_field19577.call(null,name__19366__auto__,null);
});

sablono.core.time_field19577.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.time_field19577.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19577);

/**
 * Creates a url input field.
 */
sablono.core.url_field19581 = (function sablono$core$url_field19581(var_args){
var args19582 = [];
var len__7484__auto___19649 = arguments.length;
var i__7485__auto___19650 = (0);
while(true){
if((i__7485__auto___19650 < len__7484__auto___19649)){
args19582.push((arguments[i__7485__auto___19650]));

var G__19651 = (i__7485__auto___19650 + (1));
i__7485__auto___19650 = G__19651;
continue;
} else {
}
break;
}

var G__19584 = args19582.length;
switch (G__19584) {
case 1:
return sablono.core.url_field19581.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19581.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19582.length)].join('')));

}
});

sablono.core.url_field19581.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.url_field19581.call(null,name__19366__auto__,null);
});

sablono.core.url_field19581.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.url_field19581.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19581);

/**
 * Creates a week input field.
 */
sablono.core.week_field19585 = (function sablono$core$week_field19585(var_args){
var args19586 = [];
var len__7484__auto___19653 = arguments.length;
var i__7485__auto___19654 = (0);
while(true){
if((i__7485__auto___19654 < len__7484__auto___19653)){
args19586.push((arguments[i__7485__auto___19654]));

var G__19655 = (i__7485__auto___19654 + (1));
i__7485__auto___19654 = G__19655;
continue;
} else {
}
break;
}

var G__19588 = args19586.length;
switch (G__19588) {
case 1:
return sablono.core.week_field19585.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19585.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19586.length)].join('')));

}
});

sablono.core.week_field19585.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.week_field19585.call(null,name__19366__auto__,null);
});

sablono.core.week_field19585.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.week_field19585.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19585);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19657 = (function sablono$core$check_box19657(var_args){
var args19658 = [];
var len__7484__auto___19661 = arguments.length;
var i__7485__auto___19662 = (0);
while(true){
if((i__7485__auto___19662 < len__7484__auto___19661)){
args19658.push((arguments[i__7485__auto___19662]));

var G__19663 = (i__7485__auto___19662 + (1));
i__7485__auto___19662 = G__19663;
continue;
} else {
}
break;
}

var G__19660 = args19658.length;
switch (G__19660) {
case 1:
return sablono.core.check_box19657.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19657.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19657.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19658.length)].join('')));

}
});

sablono.core.check_box19657.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19657.call(null,name,null);
});

sablono.core.check_box19657.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19657.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19657.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19657.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19657);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19665 = (function sablono$core$radio_button19665(var_args){
var args19666 = [];
var len__7484__auto___19669 = arguments.length;
var i__7485__auto___19670 = (0);
while(true){
if((i__7485__auto___19670 < len__7484__auto___19669)){
args19666.push((arguments[i__7485__auto___19670]));

var G__19671 = (i__7485__auto___19670 + (1));
i__7485__auto___19670 = G__19671;
continue;
} else {
}
break;
}

var G__19668 = args19666.length;
switch (G__19668) {
case 1:
return sablono.core.radio_button19665.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19665.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19665.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19666.length)].join('')));

}
});

sablono.core.radio_button19665.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19665.call(null,group,null);
});

sablono.core.radio_button19665.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19665.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19665.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19665.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19665);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19673 = (function sablono$core$select_options19673(var_args){
var args19674 = [];
var len__7484__auto___19693 = arguments.length;
var i__7485__auto___19694 = (0);
while(true){
if((i__7485__auto___19694 < len__7484__auto___19693)){
args19674.push((arguments[i__7485__auto___19694]));

var G__19695 = (i__7485__auto___19694 + (1));
i__7485__auto___19694 = G__19695;
continue;
} else {
}
break;
}

var G__19676 = args19674.length;
switch (G__19676) {
case 1:
return sablono.core.select_options19673.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19673.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19674.length)].join('')));

}
});

sablono.core.select_options19673.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19673.call(null,coll,null);
});

sablono.core.select_options19673.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__19677(s__19678){
return (new cljs.core.LazySeq(null,(function (){
var s__19678__$1 = s__19678;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19678__$1);
if(temp__4657__auto__){
var s__19678__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19678__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19678__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19680 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19679 = (0);
while(true){
if((i__19679 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19679);
cljs.core.chunk_append.call(null,b__19680,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19687 = x;
var text = cljs.core.nth.call(null,vec__19687,(0),null);
var val = cljs.core.nth.call(null,vec__19687,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19687,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19673.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19697 = (i__19679 + (1));
i__19679 = G__19697;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19680),sablono$core$iter__19677.call(null,cljs.core.chunk_rest.call(null,s__19678__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19680),null);
}
} else {
var x = cljs.core.first.call(null,s__19678__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19690 = x;
var text = cljs.core.nth.call(null,vec__19690,(0),null);
var val = cljs.core.nth.call(null,vec__19690,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19690,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19673.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19677.call(null,cljs.core.rest.call(null,s__19678__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options19673.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19673);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19698 = (function sablono$core$drop_down19698(var_args){
var args19699 = [];
var len__7484__auto___19702 = arguments.length;
var i__7485__auto___19703 = (0);
while(true){
if((i__7485__auto___19703 < len__7484__auto___19702)){
args19699.push((arguments[i__7485__auto___19703]));

var G__19704 = (i__7485__auto___19703 + (1));
i__7485__auto___19703 = G__19704;
continue;
} else {
}
break;
}

var G__19701 = args19699.length;
switch (G__19701) {
case 2:
return sablono.core.drop_down19698.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19698.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19699.length)].join('')));

}
});

sablono.core.drop_down19698.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19698.call(null,name,options,null);
});

sablono.core.drop_down19698.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19698.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19698);
/**
 * Creates a text area element.
 */
sablono.core.text_area19706 = (function sablono$core$text_area19706(var_args){
var args19707 = [];
var len__7484__auto___19710 = arguments.length;
var i__7485__auto___19711 = (0);
while(true){
if((i__7485__auto___19711 < len__7484__auto___19710)){
args19707.push((arguments[i__7485__auto___19711]));

var G__19712 = (i__7485__auto___19711 + (1));
i__7485__auto___19711 = G__19712;
continue;
} else {
}
break;
}

var G__19709 = args19707.length;
switch (G__19709) {
case 1:
return sablono.core.text_area19706.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19706.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19707.length)].join('')));

}
});

sablono.core.text_area19706.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19706.call(null,name,null);
});

sablono.core.text_area19706.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19706.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19706);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label19714 = (function sablono$core$label19714(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label19714);
/**
 * Creates a submit button.
 */
sablono.core.submit_button19715 = (function sablono$core$submit_button19715(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button19715);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button19716 = (function sablono$core$reset_button19716(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button19716);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to19717 = (function sablono$core$form_to19717(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19724 = arguments.length;
var i__7485__auto___19725 = (0);
while(true){
if((i__7485__auto___19725 < len__7484__auto___19724)){
args__7491__auto__.push((arguments[i__7485__auto___19725]));

var G__19726 = (i__7485__auto___19725 + (1));
i__7485__auto___19725 = G__19726;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to19717.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to19717.cljs$core$IFn$_invoke$arity$variadic = (function (p__19720,body){
var vec__19721 = p__19720;
var method = cljs.core.nth.call(null,vec__19721,(0),null);
var action = cljs.core.nth.call(null,vec__19721,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to19717.cljs$lang$maxFixedArity = (1);

sablono.core.form_to19717.cljs$lang$applyTo = (function (seq19718){
var G__19719 = cljs.core.first.call(null,seq19718);
var seq19718__$1 = cljs.core.next.call(null,seq19718);
return sablono.core.form_to19717.cljs$core$IFn$_invoke$arity$variadic(G__19719,seq19718__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to19717);
