// Compiled by ClojureScript 1.9.229 {}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.urls');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"temp-token","temp-token",2129400071),null,new cljs.core.Keyword(null,"token","token",-1211463215),null,new cljs.core.Keyword(null,"username","username",1605666410),null,new cljs.core.Keyword(null,"password","password",417022471),null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"client","client",-1323448117),"zebra.ona.io",new cljs.core.Keyword(null,"data","data",-232669377),"stage-api.ona.io",new cljs.core.Keyword(null,"j2x","j2x",2112415912),"j2x.ona.io",new cljs.core.Keyword(null,"request-protocol","request-protocol",1273151787),"https"], null));
/**
 * Store customizable timeouts to use in the http libraries. In milliseconds.
 */
milia.utils.remote.timeouts = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn-timeout","conn-timeout",2119298951),(30000),new cljs.core.Keyword(null,"socket-timeout","socket-timeout",-877740564),(30000)], null));
/**
 * Swap values into hosts atom, requires data-host, other args are option but
 * must be provided in order. If an option arg is nil it is ignored, and not
 * swapped into hosts.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_hosts = (function milia$utils$remote$set_hosts(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22717 = arguments.length;
var i__7485__auto___22718 = (0);
while(true){
if((i__7485__auto___22718 < len__7484__auto___22717)){
args__7491__auto__.push((arguments[i__7485__auto___22718]));

var G__22719 = (i__7485__auto___22718 + (1));
i__7485__auto___22718 = G__22719;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_hosts', milia.utils.remote.set_hosts);

milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic = (function (data_host,p__22712){
var vec__22713 = p__22712;
var client_host = cljs.core.nth.call(null,vec__22713,(0),null);
var j2x_host = cljs.core.nth.call(null,vec__22713,(1),null);
var request_protocol = cljs.core.nth.call(null,vec__22713,(2),null);
return cljs.core.swap_BANG_.call(null,milia.utils.remote.hosts,cljs.core.merge,(function (){var G__22716 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data_host], null);
var G__22716__$1 = ((cljs.core.some_QMARK_.call(null,client_host))?cljs.core.assoc.call(null,G__22716,new cljs.core.Keyword(null,"client","client",-1323448117),client_host):G__22716);
var G__22716__$2 = ((cljs.core.some_QMARK_.call(null,j2x_host))?cljs.core.assoc.call(null,G__22716__$1,new cljs.core.Keyword(null,"j2x","j2x",2112415912),j2x_host):G__22716__$1);
if(cljs.core.some_QMARK_.call(null,request_protocol)){
return cljs.core.assoc.call(null,G__22716__$2,new cljs.core.Keyword(null,"request-protocol","request-protocol",1273151787),request_protocol);
} else {
return G__22716__$2;
}
})());
});

milia.utils.remote.set_hosts.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_hosts.cljs$lang$applyTo = (function (seq22710){
var G__22711 = cljs.core.first.call(null,seq22710);
var seq22710__$1 = cljs.core.next.call(null,seq22710);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic(G__22711,seq22710__$1);
});

/**
 * Set the dynamic credentials to include the username and optionally
 * any other arguments that are passed. If an argument is nil or not passed
 * it will be set to nil in the credentials.
 * 
 * Calling this from Clojure will break if not done from within a previous
 * binding of the *credentials* variable.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_credentials = (function milia$utils$remote$set_credentials(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22726 = arguments.length;
var i__7485__auto___22727 = (0);
while(true){
if((i__7485__auto___22727 < len__7484__auto___22726)){
args__7491__auto__.push((arguments[i__7485__auto___22727]));

var G__22728 = (i__7485__auto___22727 + (1));
i__7485__auto___22727 = G__22728;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_credentials', milia.utils.remote.set_credentials);

milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__22722){
var vec__22723 = p__22722;
var password = cljs.core.nth.call(null,vec__22723,(0),null);
var temp_token = cljs.core.nth.call(null,vec__22723,(1),null);
var token = cljs.core.nth.call(null,vec__22723,(2),null);
return milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"password","password",417022471),password,new cljs.core.Keyword(null,"temp-token","temp-token",2129400071),temp_token,new cljs.core.Keyword(null,"token","token",-1211463215),token], null);
});

milia.utils.remote.set_credentials.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_credentials.cljs$lang$applyTo = (function (seq22720){
var G__22721 = cljs.core.first.call(null,seq22720);
var seq22720__$1 = cljs.core.next.call(null,seq22720);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic(G__22721,seq22720__$1);
});

/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.call(null,cljs.core.flatten.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"request-protocol","request-protocol",1273151787).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)),"://",resources], null)));
});
milia.utils.remote.thumbor_host = "images.ona.io";
milia.utils.remote.thumbor_server = milia.utils.remote.protocol_prefixed.call(null,milia.utils.remote.thumbor_host);
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.call(null,cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.call(null,chimera.urls.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22730 = arguments.length;
var i__7485__auto___22731 = (0);
while(true){
if((i__7485__auto___22731 < len__7484__auto___22730)){
args__7491__auto__.push((arguments[i__7485__auto___22731]));

var G__22732 = (i__7485__auto___22731 + (1));
i__7485__auto___22731 = G__22732;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,[cljs.core.str(milia.utils.remote.protocol_prefixed.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts)))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq22729){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22729));
});

/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22734 = arguments.length;
var i__7485__auto___22735 = (0);
while(true){
if((i__7485__auto___22735 < len__7484__auto___22734)){
args__7491__auto__.push((arguments[i__7485__auto___22735]));

var G__22736 = (i__7485__auto___22735 + (1));
i__7485__auto___22735 = G__22736;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join.call(null,client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq22733){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22733));
});

/**
 * Like make-url, but ensures an ending in .json
 */
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22738 = arguments.length;
var i__7485__auto___22739 = (0);
while(true){
if((i__7485__auto___22739 < len__7484__auto___22738)){
args__7491__auto__.push((arguments[i__7485__auto___22739]));

var G__22740 = (i__7485__auto___22739 + (1));
i__7485__auto___22739 = G__22740;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str(cljs.core.apply.call(null,milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq22737){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22737));
});

/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22742 = arguments.length;
var i__7485__auto___22743 = (0);
while(true){
if((i__7485__auto___22743 < len__7484__auto___22742)){
args__7491__auto__.push((arguments[i__7485__auto___22743]));

var G__22744 = (i__7485__auto___22743 + (1));
i__7485__auto___22743 = G__22744;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join.call(null,milia.utils.remote.protocol_prefixed.call(null,new cljs.core.Keyword(null,"j2x","j2x",2112415912).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,milia.utils.remote.hosts))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq22741){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22741));
});

