// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var id_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"ID",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null)], null);
var G__25219 = id_field;
if(cljs.core.not.call(null,is_filtered_dataview_QMARK_)){
return cljs.core.conj.call(null,G__25219,hatti.ona.forms.submission_time_field);
} else {
return G__25219;
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25225 = arguments.length;
var i__7485__auto___25226 = (0);
while(true){
if((i__7485__auto___25226 < len__7484__auto___25225)){
args__7491__auto__.push((arguments[i__7485__auto___25226]));

var G__25227 = (i__7485__auto___25226 + (1));
i__7485__auto___25226 = G__25227;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25222){
var map__25223 = p__25222;
var map__25223__$1 = ((((!((map__25223 == null)))?((((map__25223.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25223.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25223):map__25223);
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__25223__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,hatti.views.table.get_extra_fields.call(null,is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),cljs.core.not.call(null,is_filtered_dataview_QMARK_)))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq25220){
var G__25221 = cljs.core.first.call(null,seq25220);
var seq25220__$1 = cljs.core.next.call(null,seq25220);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__25221,seq25220__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25228_SHARP_){
if(typeof p1__25228_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25228_SHARP_);
} else {
return p1__25228_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25234){
var vec__25235 = p__25234;
var fname = cljs.core.nth.call(null,vec__25235,(0),null);
var answer = cljs.core.nth.call(null,vec__25235,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25229_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25229_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,clj_value,new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25238 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25238__$1 = ((((!((map__25238 == null)))?((((map__25238.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25238.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25238):map__25238);
var owner__$1 = cljs.core.get.call(null,map__25238__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25238__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25238__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-clone","i.fa.fa-clone",1946695810),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil-square-o","i.fa.fa-pencil-square-o",1550650091)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25267 = arguments.length;
var i__7485__auto___25268 = (0);
while(true){
if((i__7485__auto___25268 < len__7484__auto___25267)){
args__7491__auto__.push((arguments[i__7485__auto___25268]));

var G__25269 = (i__7485__auto___25268 + (1));
i__7485__auto___25268 = G__25269;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25243){
var map__25244 = p__25243;
var map__25244__$1 = ((((!((map__25244 == null)))?((((map__25244.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25244.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25244):map__25244);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25244__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__25244__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var get_label_QMARK_ = cljs.core.get.call(null,map__25244__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25244__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25244__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25244,map__25244__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25240_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25240_SHARP_)) == null);
});})(map__25244,map__25244__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25244,map__25244__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25246(s__25247){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25244,map__25244__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25247__$1 = s__25247;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25247__$1);
if(temp__4657__auto__){
var s__25247__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25247__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25247__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25249 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25248 = (0);
while(true){
if((i__25248 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25248);
cljs.core.chunk_append.call(null,b__25249,(function (){var map__25258 = field;
var map__25258__$1 = ((((!((map__25258 == null)))?((((map__25258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25258):map__25258);
var map__25259 = cljs.core.get.call(null,map__25258__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25259__$1 = ((((!((map__25259 == null)))?((((map__25259.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25259.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25259):map__25259);
var hxl = cljs.core.get.call(null,map__25259__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25258__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25258__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25258__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__25270 = (i__25248 + (1));
i__25248 = G__25270;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25249),hatti$views$table$iter__25246.call(null,cljs.core.chunk_rest.call(null,s__25247__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25249),null);
}
} else {
var field = cljs.core.first.call(null,s__25247__$2);
return cljs.core.cons.call(null,(function (){var map__25262 = field;
var map__25262__$1 = ((((!((map__25262 == null)))?((((map__25262.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25262.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25262):map__25262);
var map__25263 = cljs.core.get.call(null,map__25262__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25263__$1 = ((((!((map__25263 == null)))?((((map__25263.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25263.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25263):map__25263);
var hxl = cljs.core.get.call(null,map__25263__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25262__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25262__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25262__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25246.call(null,cljs.core.rest.call(null,s__25247__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25244,map__25244__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25244,map__25244__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25266 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25266,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25266;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25241){
var G__25242 = cljs.core.first.call(null,seq25241);
var seq25241__$1 = cljs.core.next.call(null,seq25241);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25242,seq25241__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25287(s__25288){
return (new cljs.core.LazySeq(null,(function (){
var s__25288__$1 = s__25288;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25288__$1);
if(temp__4657__auto__){
var s__25288__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25288__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25288__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25290 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25289 = (0);
while(true){
if((i__25289 < size__7188__auto__)){
var vec__25297 = cljs.core._nth.call(null,c__7187__auto__,i__25289);
var handler_key = cljs.core.nth.call(null,vec__25297,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25297,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25290,event.subscribe(handler_function));

var G__25303 = (i__25289 + (1));
i__25289 = G__25303;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25290),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25287.call(null,cljs.core.chunk_rest.call(null,s__25288__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25290),null);
}
} else {
var vec__25300 = cljs.core.first.call(null,s__25288__$2);
var handler_key = cljs.core.nth.call(null,vec__25300,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25300,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25287.call(null,cljs.core.rest.call(null,s__25288__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25320(s__25321){
return (new cljs.core.LazySeq(null,(function (){
var s__25321__$1 = s__25321;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25321__$1);
if(temp__4657__auto__){
var s__25321__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25321__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25321__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25323 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25322 = (0);
while(true){
if((i__25322 < size__7188__auto__)){
var vec__25330 = cljs.core._nth.call(null,c__7187__auto__,i__25322);
var handler_key = cljs.core.nth.call(null,vec__25330,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25330,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25323,event.subscribe(handler_function));

var G__25336 = (i__25322 + (1));
i__25322 = G__25336;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25323),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25320.call(null,cljs.core.chunk_rest.call(null,s__25321__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25323),null);
}
} else {
var vec__25333 = cljs.core.first.call(null,s__25321__$2);
var handler_key = cljs.core.nth.call(null,vec__25333,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25333,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25320.call(null,cljs.core.rest.call(null,s__25321__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__25337){
var map__25346 = p__25337;
var map__25346__$1 = ((((!((map__25346 == null)))?((((map__25346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25346):map__25346);
var grid_event_handlers = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25348 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25348__$1 = ((((!((map__25348 == null)))?((((map__25348.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25348.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25348):map__25348);
var map__25349 = cljs.core.get.call(null,map__25348__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25349__$1 = ((((!((map__25349 == null)))?((((map__25349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25349):map__25349);
var map__25350 = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25350__$1 = ((((!((map__25350 == null)))?((((map__25350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25350):map__25350);
var num_displayed_records = cljs.core.get.call(null,map__25350__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25350__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746),is_filtered_dataview_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
});})(map__25348,map__25348__$1,map__25349,map__25349__$1,map__25350,map__25350__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25346,map__25346__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__,event_chan){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,event_chan){
return (function (state_25615){
var state_val_25616 = (state_25615[(1)]);
if((state_val_25616 === (7))){
var inst_25524 = (state_25615[(7)]);
var inst_25524__$1 = (state_25615[(2)]);
var inst_25526 = (inst_25524__$1 == null);
var inst_25527 = cljs.core.not.call(null,inst_25526);
var state_25615__$1 = (function (){var statearr_25617 = state_25615;
(statearr_25617[(7)] = inst_25524__$1);

return statearr_25617;
})();
if(inst_25527){
var statearr_25618_25685 = state_25615__$1;
(statearr_25618_25685[(1)] = (8));

} else {
var statearr_25619_25686 = state_25615__$1;
(statearr_25619_25686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (20))){
var inst_25546 = (state_25615[(8)]);
var inst_25554 = (state_25615[(9)]);
var inst_25563 = inst_25554.call(null,inst_25546);
var state_25615__$1 = state_25615;
var statearr_25620_25687 = state_25615__$1;
(statearr_25620_25687[(2)] = inst_25563);

(statearr_25620_25687[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (27))){
var state_25615__$1 = state_25615;
var statearr_25621_25688 = state_25615__$1;
(statearr_25621_25688[(2)] = null);

(statearr_25621_25688[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (1))){
var state_25615__$1 = state_25615;
var statearr_25622_25689 = state_25615__$1;
(statearr_25622_25689[(2)] = null);

(statearr_25622_25689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (24))){
var state_25615__$1 = state_25615;
var statearr_25623_25690 = state_25615__$1;
(statearr_25623_25690[(2)] = null);

(statearr_25623_25690[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (4))){
var state_25615__$1 = state_25615;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25615__$1,(7),event_chan);
} else {
if((state_val_25616 === (15))){
var inst_25524 = (state_25615[(7)]);
var state_25615__$1 = state_25615;
var statearr_25624_25691 = state_25615__$1;
(statearr_25624_25691[(2)] = inst_25524);

(statearr_25624_25691[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (21))){
var state_25615__$1 = state_25615;
var statearr_25625_25692 = state_25615__$1;
(statearr_25625_25692[(2)] = null);

(statearr_25625_25692[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (31))){
var inst_25550 = (state_25615[(10)]);
var inst_25588 = (state_25615[(2)]);
var inst_25589 = cljs.core._EQ_.call(null,inst_25550,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25615__$1 = (function (){var statearr_25626 = state_25615;
(statearr_25626[(11)] = inst_25588);

return statearr_25626;
})();
if(inst_25589){
var statearr_25627_25693 = state_25615__$1;
(statearr_25627_25693[(1)] = (32));

} else {
var statearr_25628_25694 = state_25615__$1;
(statearr_25628_25694[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (32))){
var inst_25544 = (state_25615[(12)]);
var inst_25555 = (state_25615[(13)]);
var inst_25546 = (state_25615[(8)]);
var inst_25545 = (state_25615[(14)]);
var inst_25550 = (state_25615[(10)]);
var inst_25549 = (state_25615[(15)]);
var inst_25554 = (state_25615[(9)]);
var inst_25548 = (state_25615[(16)]);
var inst_25547 = (state_25615[(17)]);
var inst_25602 = cljs.core.async.chan.call(null,(1));
var inst_25603 = (function (){var new_columns = inst_25549;
var submission_clicked = inst_25546;
var submission_unclicked = inst_25547;
var c__12301__auto____$1 = inst_25602;
var get_submission_data = inst_25555;
var map__25522 = inst_25544;
var re_render = inst_25550;
var update_data_BANG_ = inst_25554;
var submission_to_rank = inst_25545;
var filter_by = inst_25548;
return ((function (new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,map__25522,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_25544,inst_25555,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25602,state_val_25616,c__12301__auto__,event_chan){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,map__25522,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_25544,inst_25555,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25602,state_val_25616,c__12301__auto__,event_chan){
return (function (state_25600){
var state_val_25601 = (state_25600[(1)]);
if((state_val_25601 === (1))){
var inst_25591 = cljs.core.async.timeout.call(null,(20));
var state_25600__$1 = state_25600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25600__$1,(2),inst_25591);
} else {
if((state_val_25601 === (2))){
var inst_25593 = (state_25600[(2)]);
var inst_25594 = grid.resizeCanvas();
var inst_25595 = grid.invalidateAllRows();
var inst_25596 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25597 = grid.render();
var inst_25598 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25600__$1 = (function (){var statearr_25629 = state_25600;
(statearr_25629[(7)] = inst_25595);

(statearr_25629[(8)] = inst_25593);

(statearr_25629[(9)] = inst_25597);

(statearr_25629[(10)] = inst_25594);

(statearr_25629[(11)] = inst_25596);

return statearr_25629;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25600__$1,inst_25598);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,map__25522,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_25544,inst_25555,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25602,state_val_25616,c__12301__auto__,event_chan))
;
return ((function (switch__12189__auto__,new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,map__25522,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_25544,inst_25555,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25602,state_val_25616,c__12301__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____0 = (function (){
var statearr_25633 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25633[(0)] = hatti$views$table$handle_table_events_$_state_machine__12190__auto__);

(statearr_25633[(1)] = (1));

return statearr_25633;
});
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____1 = (function (state_25600){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_25600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e25634){if((e25634 instanceof Object)){
var ex__12193__auto__ = e25634;
var statearr_25635_25695 = state_25600;
(statearr_25635_25695[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25696 = state_25600;
state_25600 = G__25696;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = function(state_25600){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____1.call(this,state_25600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,map__25522,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_25544,inst_25555,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25602,state_val_25616,c__12301__auto__,event_chan))
})();
var state__12303__auto__ = (function (){var statearr_25636 = f__12302__auto__.call(null);
(statearr_25636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto____$1);

return statearr_25636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,map__25522,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_25544,inst_25555,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25602,state_val_25616,c__12301__auto__,event_chan))
})();
var inst_25604 = cljs.core.async.impl.dispatch.run.call(null,inst_25603);
var state_25615__$1 = (function (){var statearr_25637 = state_25615;
(statearr_25637[(18)] = inst_25604);

return statearr_25637;
})();
var statearr_25638_25697 = state_25615__$1;
(statearr_25638_25697[(2)] = inst_25602);

(statearr_25638_25697[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (33))){
var state_25615__$1 = state_25615;
var statearr_25639_25698 = state_25615__$1;
(statearr_25639_25698[(2)] = null);

(statearr_25639_25698[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (13))){
var inst_25536 = (state_25615[(2)]);
var state_25615__$1 = state_25615;
var statearr_25640_25699 = state_25615__$1;
(statearr_25640_25699[(2)] = inst_25536);

(statearr_25640_25699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (22))){
var inst_25547 = (state_25615[(17)]);
var inst_25566 = (state_25615[(2)]);
var state_25615__$1 = (function (){var statearr_25641 = state_25615;
(statearr_25641[(19)] = inst_25566);

return statearr_25641;
})();
if(cljs.core.truth_(inst_25547)){
var statearr_25642_25700 = state_25615__$1;
(statearr_25642_25700[(1)] = (23));

} else {
var statearr_25643_25701 = state_25615__$1;
(statearr_25643_25701[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (29))){
var inst_25548 = (state_25615[(16)]);
var inst_25580 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25581 = [inst_25548];
var inst_25582 = cljs.core.PersistentHashMap.fromArrays(inst_25580,inst_25581);
var inst_25583 = cljs.core.clj__GT_js.call(null,inst_25582);
var inst_25584 = dataview.setFilterArgs(inst_25583);
var inst_25585 = dataview.refresh();
var state_25615__$1 = (function (){var statearr_25644 = state_25615;
(statearr_25644[(20)] = inst_25584);

return statearr_25644;
})();
var statearr_25645_25702 = state_25615__$1;
(statearr_25645_25702[(2)] = inst_25585);

(statearr_25645_25702[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (6))){
var inst_25611 = (state_25615[(2)]);
var state_25615__$1 = state_25615;
var statearr_25646_25703 = state_25615__$1;
(statearr_25646_25703[(2)] = inst_25611);

(statearr_25646_25703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (28))){
var inst_25548 = (state_25615[(16)]);
var inst_25578 = (state_25615[(2)]);
var state_25615__$1 = (function (){var statearr_25647 = state_25615;
(statearr_25647[(21)] = inst_25578);

return statearr_25647;
})();
if(cljs.core.truth_(inst_25548)){
var statearr_25648_25704 = state_25615__$1;
(statearr_25648_25704[(1)] = (29));

} else {
var statearr_25649_25705 = state_25615__$1;
(statearr_25649_25705[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (25))){
var inst_25549 = (state_25615[(15)]);
var inst_25571 = (state_25615[(2)]);
var state_25615__$1 = (function (){var statearr_25650 = state_25615;
(statearr_25650[(22)] = inst_25571);

return statearr_25650;
})();
if(cljs.core.truth_(inst_25549)){
var statearr_25651_25706 = state_25615__$1;
(statearr_25651_25706[(1)] = (26));

} else {
var statearr_25652_25707 = state_25615__$1;
(statearr_25652_25707[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (34))){
var inst_25607 = (state_25615[(2)]);
var state_25615__$1 = (function (){var statearr_25653 = state_25615;
(statearr_25653[(23)] = inst_25607);

return statearr_25653;
})();
var statearr_25654_25708 = state_25615__$1;
(statearr_25654_25708[(2)] = null);

(statearr_25654_25708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (17))){
var inst_25555 = (state_25615[(13)]);
var inst_25545 = (state_25615[(14)]);
var inst_25554 = (state_25615[(9)]);
var inst_25557 = inst_25555.call(null,hatti.constants._rank,inst_25545);
var inst_25558 = inst_25554.call(null,inst_25557);
var state_25615__$1 = state_25615;
var statearr_25655_25709 = state_25615__$1;
(statearr_25655_25709[(2)] = inst_25558);

(statearr_25655_25709[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (3))){
var inst_25613 = (state_25615[(2)]);
var state_25615__$1 = state_25615;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25615__$1,inst_25613);
} else {
if((state_val_25616 === (12))){
var state_25615__$1 = state_25615;
var statearr_25656_25710 = state_25615__$1;
(statearr_25656_25710[(2)] = false);

(statearr_25656_25710[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (2))){
var state_25615__$1 = state_25615;
var statearr_25657_25711 = state_25615__$1;
(statearr_25657_25711[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (23))){
var inst_25554 = (state_25615[(9)]);
var inst_25568 = inst_25554.call(null,null);
var state_25615__$1 = state_25615;
var statearr_25659_25712 = state_25615__$1;
(statearr_25659_25712[(2)] = inst_25568);

(statearr_25659_25712[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (19))){
var inst_25546 = (state_25615[(8)]);
var inst_25561 = (state_25615[(2)]);
var state_25615__$1 = (function (){var statearr_25660 = state_25615;
(statearr_25660[(24)] = inst_25561);

return statearr_25660;
})();
if(cljs.core.truth_(inst_25546)){
var statearr_25661_25713 = state_25615__$1;
(statearr_25661_25713[(1)] = (20));

} else {
var statearr_25662_25714 = state_25615__$1;
(statearr_25662_25714[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (11))){
var state_25615__$1 = state_25615;
var statearr_25663_25715 = state_25615__$1;
(statearr_25663_25715[(2)] = true);

(statearr_25663_25715[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (9))){
var state_25615__$1 = state_25615;
var statearr_25664_25716 = state_25615__$1;
(statearr_25664_25716[(2)] = false);

(statearr_25664_25716[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (5))){
var state_25615__$1 = state_25615;
var statearr_25665_25717 = state_25615__$1;
(statearr_25665_25717[(2)] = null);

(statearr_25665_25717[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (14))){
var inst_25524 = (state_25615[(7)]);
var inst_25541 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25524);
var state_25615__$1 = state_25615;
var statearr_25666_25718 = state_25615__$1;
(statearr_25666_25718[(2)] = inst_25541);

(statearr_25666_25718[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (26))){
var inst_25549 = (state_25615[(15)]);
var inst_25573 = grid.setColumns(inst_25549);
var inst_25574 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25575 = grid.render();
var state_25615__$1 = (function (){var statearr_25667 = state_25615;
(statearr_25667[(25)] = inst_25573);

(statearr_25667[(26)] = inst_25574);

return statearr_25667;
})();
var statearr_25668_25719 = state_25615__$1;
(statearr_25668_25719[(2)] = inst_25575);

(statearr_25668_25719[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (16))){
var inst_25544 = (state_25615[(12)]);
var inst_25546 = (state_25615[(8)]);
var inst_25545 = (state_25615[(14)]);
var inst_25550 = (state_25615[(10)]);
var inst_25549 = (state_25615[(15)]);
var inst_25554 = (state_25615[(9)]);
var inst_25548 = (state_25615[(16)]);
var inst_25547 = (state_25615[(17)]);
var inst_25544__$1 = (state_25615[(2)]);
var inst_25545__$1 = cljs.core.get.call(null,inst_25544__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25546__$1 = cljs.core.get.call(null,inst_25544__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25547__$1 = cljs.core.get.call(null,inst_25544__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25548__$1 = cljs.core.get.call(null,inst_25544__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25549__$1 = cljs.core.get.call(null,inst_25544__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25550__$1 = cljs.core.get.call(null,inst_25544__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25552 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25553 = (new cljs.core.PersistentVector(null,3,(5),inst_25551,inst_25552,null));
var inst_25554__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25553);
var inst_25555 = (function (){var map__25522 = inst_25544__$1;
var submission_to_rank = inst_25545__$1;
var submission_clicked = inst_25546__$1;
var submission_unclicked = inst_25547__$1;
var filter_by = inst_25548__$1;
var new_columns = inst_25549__$1;
var re_render = inst_25550__$1;
var update_data_BANG_ = inst_25554__$1;
return ((function (map__25522,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25544,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25544__$1,inst_25545__$1,inst_25546__$1,inst_25547__$1,inst_25548__$1,inst_25549__$1,inst_25550__$1,inst_25551,inst_25552,inst_25553,inst_25554__$1,state_val_25616,c__12301__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25522,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25544,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25544__$1,inst_25545__$1,inst_25546__$1,inst_25547__$1,inst_25548__$1,inst_25549__$1,inst_25550__$1,inst_25551,inst_25552,inst_25553,inst_25554__$1,state_val_25616,c__12301__auto__,event_chan){
return (function (p1__25354_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25354_SHARP_,field));
});})(map__25522,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25544,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25544__$1,inst_25545__$1,inst_25546__$1,inst_25547__$1,inst_25548__$1,inst_25549__$1,inst_25550__$1,inst_25551,inst_25552,inst_25553,inst_25554__$1,state_val_25616,c__12301__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25522,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25544,inst_25546,inst_25545,inst_25550,inst_25549,inst_25554,inst_25548,inst_25547,inst_25544__$1,inst_25545__$1,inst_25546__$1,inst_25547__$1,inst_25548__$1,inst_25549__$1,inst_25550__$1,inst_25551,inst_25552,inst_25553,inst_25554__$1,state_val_25616,c__12301__auto__,event_chan))
})();
var state_25615__$1 = (function (){var statearr_25669 = state_25615;
(statearr_25669[(12)] = inst_25544__$1);

(statearr_25669[(13)] = inst_25555);

(statearr_25669[(8)] = inst_25546__$1);

(statearr_25669[(14)] = inst_25545__$1);

(statearr_25669[(10)] = inst_25550__$1);

(statearr_25669[(15)] = inst_25549__$1);

(statearr_25669[(9)] = inst_25554__$1);

(statearr_25669[(16)] = inst_25548__$1);

(statearr_25669[(17)] = inst_25547__$1);

return statearr_25669;
})();
if(cljs.core.truth_(inst_25545__$1)){
var statearr_25670_25720 = state_25615__$1;
(statearr_25670_25720[(1)] = (17));

} else {
var statearr_25671_25721 = state_25615__$1;
(statearr_25671_25721[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (30))){
var state_25615__$1 = state_25615;
var statearr_25672_25722 = state_25615__$1;
(statearr_25672_25722[(2)] = null);

(statearr_25672_25722[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (10))){
var inst_25539 = (state_25615[(2)]);
var state_25615__$1 = state_25615;
if(cljs.core.truth_(inst_25539)){
var statearr_25673_25723 = state_25615__$1;
(statearr_25673_25723[(1)] = (14));

} else {
var statearr_25674_25724 = state_25615__$1;
(statearr_25674_25724[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (18))){
var state_25615__$1 = state_25615;
var statearr_25675_25725 = state_25615__$1;
(statearr_25675_25725[(2)] = null);

(statearr_25675_25725[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25616 === (8))){
var inst_25524 = (state_25615[(7)]);
var inst_25529 = inst_25524.cljs$lang$protocol_mask$partition0$;
var inst_25530 = (inst_25529 & (64));
var inst_25531 = inst_25524.cljs$core$ISeq$;
var inst_25532 = (inst_25530) || (inst_25531);
var state_25615__$1 = state_25615;
if(cljs.core.truth_(inst_25532)){
var statearr_25676_25726 = state_25615__$1;
(statearr_25676_25726[(1)] = (11));

} else {
var statearr_25677_25727 = state_25615__$1;
(statearr_25677_25727[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__,event_chan))
;
return ((function (switch__12189__auto__,c__12301__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____0 = (function (){
var statearr_25681 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25681[(0)] = hatti$views$table$handle_table_events_$_state_machine__12190__auto__);

(statearr_25681[(1)] = (1));

return statearr_25681;
});
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____1 = (function (state_25615){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_25615);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e25682){if((e25682 instanceof Object)){
var ex__12193__auto__ = e25682;
var statearr_25683_25728 = state_25615;
(statearr_25683_25728[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25615);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25682;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25729 = state_25615;
state_25615 = G__25729;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = function(state_25615){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____1.call(this,state_25615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,event_chan))
})();
var state__12303__auto__ = (function (){var statearr_25684 = f__12302__auto__.call(null);
(statearr_25684[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_25684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__,event_chan))
);

return c__12301__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25746(s__25747){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25747__$1 = s__25747;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25747__$1);
if(temp__4657__auto__){
var s__25747__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25747__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25747__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25749 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25748 = (0);
while(true){
if((i__25748 < size__7188__auto__)){
var vec__25756 = cljs.core._nth.call(null,c__7187__auto__,i__25748);
var k = cljs.core.nth.call(null,vec__25756,(0),null);
var v = cljs.core.nth.call(null,vec__25756,(1),null);
cljs.core.chunk_append.call(null,b__25749,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25748,vec__25756,k,v,c__7187__auto__,size__7188__auto__,b__25749,s__25747__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25748,vec__25756,k,v,c__7187__auto__,size__7188__auto__,b__25749,s__25747__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25762 = (i__25748 + (1));
i__25748 = G__25762;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25749),hatti$views$table$render_options_$_iter__25746.call(null,cljs.core.chunk_rest.call(null,s__25747__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25749),null);
}
} else {
var vec__25759 = cljs.core.first.call(null,s__25747__$2);
var k = cljs.core.nth.call(null,vec__25759,(0),null);
var v = cljs.core.nth.call(null,vec__25759,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25759,k,v,s__25747__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25759,k,v,s__25747__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25746.call(null,cljs.core.rest.call(null,s__25747__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__25764,owner){
var map__25765 = p__25764;
var map__25765__$1 = ((((!((map__25765 == null)))?((((map__25765.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25765.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25765):map__25765);
var cursor = map__25765__$1;
var map__25766 = cljs.core.get.call(null,map__25765__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25766__$1 = ((((!((map__25766 == null)))?((((map__25766.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25766.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25766):map__25766);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25766__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
if(typeof hatti.views.table.t_hatti$views$table25769 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25769 = (function (p__25764,owner,map__25765,cursor,map__25766,hide_actions_column_QMARK_,meta25770){
this.p__25764 = p__25764;
this.owner = owner;
this.map__25765 = map__25765;
this.cursor = cursor;
this.map__25766 = map__25766;
this.hide_actions_column_QMARK_ = hide_actions_column_QMARK_;
this.meta25770 = meta25770;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25769.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (_25771,meta25770__$1){
var self__ = this;
var _25771__$1 = this;
return (new hatti.views.table.t_hatti$views$table25769(self__.p__25764,self__.owner,self__.map__25765,self__.cursor,self__.map__25766,self__.hide_actions_column_QMARK_,meta25770__$1));
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25769.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (_25771){
var self__ = this;
var _25771__$1 = this;
return self__.meta25770;
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25769.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25769.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25769.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25769.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (_,p__25772){
var self__ = this;
var map__25773 = p__25772;
var map__25773__$1 = ((((!((map__25773 == null)))?((((map__25773.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25773.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25773):map__25773);
var name_or_label = cljs.core.get.call(null,map__25773__$1,new cljs.core.Keyword(null,"name-or-label","name-or-label",-520034208));
var language = cljs.core.get.call(null,map__25773__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$1 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25775 = om.core.get_shared.call(null,self__.owner);
var map__25775__$1 = ((((!((map__25775 == null)))?((((map__25775.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25775.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25775):map__25775);
var flat_form = cljs.core.get.call(null,map__25775__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25775,map__25775__$1,flat_form,new_language,___$1,map__25773,map__25773__$1,name_or_label,language,map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (p1__25763_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25763_SHARP_),new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),self__.hide_actions_column_QMARK_,new cljs.core.Keyword(null,"language","language",-1591107564),new_language)], null));
});})(options,map__25775,map__25775__$1,flat_form,new_language,___$1,map__25773,map__25773__$1,name_or_label,language,map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,name_or_label);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25779 = options.call(null,name_or_label);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25779))?sablono.interpreter.attributes.call(null,attrs25779):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25779))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25779),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),React.DOM.ul(({"className": "submenu no-dot"}),sablono.interpreter.interpret.call(null,hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_)))));
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25769.getBasis = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__25764","p__25764",417757819,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__25765","map__25765",-732035568,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"map__25766","map__25766",2021737079,null),new cljs.core.Symbol(null,"hide-actions-column?","hide-actions-column?",1609886773,null),new cljs.core.Symbol(null,"meta25770","meta25770",892903172,null)], null);
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table25769.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25769.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25769";

hatti.views.table.t_hatti$views$table25769.cljs$lang$ctorPrWriter = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25769");
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

hatti.views.table.__GT_t_hatti$views$table25769 = ((function (map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_){
return (function hatti$views$table$__GT_t_hatti$views$table25769(p__25764__$1,owner__$1,map__25765__$2,cursor__$1,map__25766__$2,hide_actions_column_QMARK___$1,meta25770){
return (new hatti.views.table.t_hatti$views$table25769(p__25764__$1,owner__$1,map__25765__$2,cursor__$1,map__25766__$2,hide_actions_column_QMARK___$1,meta25770));
});})(map__25765,map__25765__$1,cursor,map__25766,map__25766__$1,hide_actions_column_QMARK_))
;

}

return (new hatti.views.table.t_hatti$views$table25769(p__25764,owner,map__25765__$1,cursor,map__25766__$1,hide_actions_column_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__,query){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,query){
return (function (state_25826){
var state_val_25827 = (state_25826[(1)]);
if((state_val_25827 === (1))){
var inst_25812 = cljs.core.async.timeout.call(null,(150));
var state_25826__$1 = state_25826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25826__$1,(2),inst_25812);
} else {
if((state_val_25827 === (2))){
var inst_25814 = (state_25826[(2)]);
var inst_25815 = input.value;
var inst_25816 = cljs.core._EQ_.call(null,query,inst_25815);
var state_25826__$1 = (function (){var statearr_25828 = state_25826;
(statearr_25828[(7)] = inst_25814);

return statearr_25828;
})();
if(inst_25816){
var statearr_25829_25840 = state_25826__$1;
(statearr_25829_25840[(1)] = (3));

} else {
var statearr_25830_25841 = state_25826__$1;
(statearr_25830_25841[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25827 === (3))){
var inst_25818 = [query_event_key];
var inst_25819 = [query];
var inst_25820 = cljs.core.PersistentHashMap.fromArrays(inst_25818,inst_25819);
var inst_25821 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_25820);
var state_25826__$1 = state_25826;
var statearr_25831_25842 = state_25826__$1;
(statearr_25831_25842[(2)] = inst_25821);

(statearr_25831_25842[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25827 === (4))){
var state_25826__$1 = state_25826;
var statearr_25832_25843 = state_25826__$1;
(statearr_25832_25843[(2)] = null);

(statearr_25832_25843[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25827 === (5))){
var inst_25824 = (state_25826[(2)]);
var state_25826__$1 = state_25826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25826__$1,inst_25824);
} else {
return null;
}
}
}
}
}
});})(c__12301__auto__,query))
;
return ((function (switch__12189__auto__,c__12301__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12190__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12190__auto____0 = (function (){
var statearr_25836 = [null,null,null,null,null,null,null,null];
(statearr_25836[(0)] = hatti$views$table$delayed_search_$_state_machine__12190__auto__);

(statearr_25836[(1)] = (1));

return statearr_25836;
});
var hatti$views$table$delayed_search_$_state_machine__12190__auto____1 = (function (state_25826){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_25826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e25837){if((e25837 instanceof Object)){
var ex__12193__auto__ = e25837;
var statearr_25838_25844 = state_25826;
(statearr_25838_25844[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25837;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25845 = state_25826;
state_25826 = G__25845;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12190__auto__ = function(state_25826){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12190__auto____1.call(this,state_25826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12190__auto____0;
hatti$views$table$delayed_search_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12190__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,query))
})();
var state__12303__auto__ = (function (){var statearr_25839 = f__12302__auto__.call(null);
(statearr_25839[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_25839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__,query))
);

return c__12301__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25847 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25847 = (function (_,owner,meta25848){
this._ = _;
this.owner = owner;
this.meta25848 = meta25848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25849,meta25848__$1){
var self__ = this;
var _25849__$1 = this;
return (new hatti.views.table.t_hatti$views$table25847(self__._,self__.owner,meta25848__$1));
});

hatti.views.table.t_hatti$views$table25847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25849){
var self__ = this;
var _25849__$1 = this;
return self__.meta25848;
});

hatti.views.table.t_hatti$views$table25847.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table25847.prototype.om$core$IRender$render$arity$1 = (function (this__18161__auto__){
var self__ = this;
var this__18161__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18161__auto____$1){
return (function (p1__25846_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__25846_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18161__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table25847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25848","meta25848",-899230785,null)], null);
});

hatti.views.table.t_hatti$views$table25847.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25847.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25847";

hatti.views.table.t_hatti$views$table25847.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25847");
});

hatti.views.table.__GT_t_hatti$views$table25847 = (function hatti$views$table$__GT_t_hatti$views$table25847(___$1,owner__$1,meta25848){
return (new hatti.views.table.t_hatti$views$table25847(___$1,owner__$1,meta25848));
});

}

return (new hatti.views.table.t_hatti$views$table25847(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table25852 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25852 = (function (cursor,owner,meta25853){
this.cursor = cursor;
this.owner = owner;
this.meta25853 = meta25853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25854,meta25853__$1){
var self__ = this;
var _25854__$1 = this;
return (new hatti.views.table.t_hatti$views$table25852(self__.cursor,self__.owner,meta25853__$1));
});

hatti.views.table.t_hatti$views$table25852.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25854){
var self__ = this;
var _25854__$1 = this;
return self__.meta25853;
});

hatti.views.table.t_hatti$views$table25852.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table25852.prototype.om$core$IRender$render$arity$1 = (function (this__18161__auto__){
var self__ = this;
var this__18161__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table25852.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25853","meta25853",-1434159370,null)], null);
});

hatti.views.table.t_hatti$views$table25852.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25852.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25852";

hatti.views.table.t_hatti$views$table25852.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25852");
});

hatti.views.table.__GT_t_hatti$views$table25852 = (function hatti$views$table$__GT_t_hatti$views$table25852(cursor__$1,owner__$1,meta25853){
return (new hatti.views.table.t_hatti$views$table25852(cursor__$1,owner__$1,meta25853));
});

}

return (new hatti.views.table.t_hatti$views$table25852(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__25862 = om.core.get_shared.call(null,owner);
var map__25862__$1 = ((((!((map__25862 == null)))?((((map__25862.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25862.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25862):map__25862);
var flat_form = cljs.core.get.call(null,map__25862__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var is_filtered_dataview_QMARK_ = cljs.core.get.call(null,map__25862__$1,new cljs.core.Keyword(null,"is-filtered-dataview?","is-filtered-dataview?",456678746));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__25863 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__25863,(0),null);
var dataview = cljs.core.nth.call(null,vec__25863,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__25868,owner,p__25869){
var map__25870 = p__25868;
var map__25870__$1 = ((((!((map__25870 == null)))?((((map__25870.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25870.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25870):map__25870);
var cursor = map__25870__$1;
var map__25871 = cljs.core.get.call(null,map__25870__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__25871__$1 = ((((!((map__25871 == null)))?((((map__25871.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25871.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25871):map__25871);
var active = cljs.core.get.call(null,map__25871__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__25872 = p__25869;
var map__25872__$1 = ((((!((map__25872 == null)))?((((map__25872.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25872.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25872):map__25872);
var opts = map__25872__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__25872__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table25876 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25876 = (function (p__25869,owner,p__25868,active_QMARK_,slick_grid_event_handlers,cursor,map__25870,map__25871,active,opts,map__25872,meta25877){
this.p__25869 = p__25869;
this.owner = owner;
this.p__25868 = p__25868;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.map__25870 = map__25870;
this.map__25871 = map__25871;
this.active = active;
this.opts = opts;
this.map__25872 = map__25872;
this.meta25877 = meta25877;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25876.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (_25878,meta25877__$1){
var self__ = this;
var _25878__$1 = this;
return (new hatti.views.table.t_hatti$views$table25876(self__.p__25869,self__.owner,self__.p__25868,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.cursor,self__.map__25870,self__.map__25871,self__.active,self__.opts,self__.map__25872,meta25877__$1));
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (_25878){
var self__ = this;
var _25878__$1 = this;
return self__.meta25877;
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (_,p__25879){
var self__ = this;
var map__25880 = p__25879;
var map__25880__$1 = ((((!((map__25880 == null)))?((((map__25880.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25880.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25880):map__25880);
var table_view_height = cljs.core.get.call(null,map__25880__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__25882 = self__.cursor;
var map__25882__$1 = ((((!((map__25882 == null)))?((((map__25882.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25882.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25882):map__25882);
var map__25883 = cljs.core.get.call(null,map__25882__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25883__$1 = ((((!((map__25883 == null)))?((((map__25883.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25883.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25883):map__25883);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__25883__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__25883__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__25882__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__25882__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__25884 = dataset_info;
var map__25884__$1 = ((((!((map__25884 == null)))?((((map__25884.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25884.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25884):map__25884);
var num_of_submissions = cljs.core.get.call(null,map__25884__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__25882,map__25882__$1,map__25883,map__25883__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__25884,map__25884__$1,num_of_submissions,no_data_QMARK_,___$1,map__25880,map__25880__$1,table_view_height,active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (p1__25867_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__25867_SHARP_);
});})(map__25882,map__25882__$1,map__25883,map__25883__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__25884,map__25884__$1,num_of_submissions,no_data_QMARK_,___$1,map__25880,map__25880__$1,table_view_height,active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25892 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__25892,(0),null);
var dataview = cljs.core.nth.call(null,vec__25892,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table25876.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__25895 = om.core.get_state.call(null,self__.owner);
var map__25895__$1 = ((((!((map__25895 == null)))?((((map__25895.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25895.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25895):map__25895);
var grid = cljs.core.get.call(null,map__25895__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__25895__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25897 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__25897,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__25897,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.getBasis = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__25869","p__25869",-1942143038,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"p__25868","p__25868",1896993031,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"map__25870","map__25870",-447538379,null),new cljs.core.Symbol(null,"map__25871","map__25871",142834073,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"map__25872","map__25872",-1103977603,null),new cljs.core.Symbol(null,"meta25877","meta25877",-911963821,null)], null);
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table25876.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25876.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25876";

hatti.views.table.t_hatti$views$table25876.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25876");
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table25876 = ((function (active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table25876(p__25869__$1,owner__$1,p__25868__$1,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,map__25870__$2,map__25871__$2,active__$1,opts__$1,map__25872__$2,meta25877){
return (new hatti.views.table.t_hatti$views$table25876(p__25869__$1,owner__$1,p__25868__$1,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,map__25870__$2,map__25871__$2,active__$1,opts__$1,map__25872__$2,meta25877));
});})(active_QMARK_,map__25870,map__25870__$1,cursor,map__25871,map__25871__$1,active,map__25872,map__25872__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table25876(p__25869,owner,p__25868,active_QMARK_,slick_grid_event_handlers,cursor,map__25870__$1,map__25871__$1,active,opts,map__25872__$1,cljs.core.PersistentArrayMap.EMPTY));
}));
