// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.photos');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.constants');
goog.require('milia.utils.remote');
goog.require('sablono.core');
goog.require('hatti.shared');
goog.require('hatti.views');
goog.require('om.core');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.photos.data_pswp_id = "data-pswp-id";
hatti.views.photos.pswp_gallery_class = "pswp";
hatti.views.photos.width_px = (1024);
hatti.views.photos.thumb_width_px = (180);
hatti.views.photos.thumb_width_px_str = [cljs.core.str(hatti.views.photos.thumb_width_px),cljs.core.str("px")].join('');
hatti.views.photos.num_columns = (3);
/**
 * Return a URL for this image resized.
 */
hatti.views.photos.resize_image = (function hatti$views$photos$resize_image(image_url,edge_px){
return [cljs.core.str(milia.utils.remote.thumbor_server),cljs.core.str(chimera.urls.url.call(null,"unsafe","fit-in",[cljs.core.str(edge_px),cljs.core.str("x"),cljs.core.str(edge_px)].join(''),"smart","filters:fill(000)",image_url))].join('');
});
/**
 * If not a fully qualified URL, remove the API namespace prefix from a URI
 * string and convert to a fully qualified URL.
 */
hatti.views.photos.make_url = (function hatti$views$photos$make_url(s){
if(cljs.core._EQ_.call(null,cljs.core.subs.call(null,s,(0),(4)),"http")){
return s;
} else {
return milia.utils.remote.make_url.call(null,clojure.string.replace.call(null,s,/\/api\/v1/,""));
}
});
hatti.views.photos.build_caption = (function hatti$views$photos$build_caption(item){
var datetime = item.date;
var date = moment(datetime).format("MMM D, YYYY");
var time = moment(datetime).format("h:mm A");
return chimera.js_interop.format.call(null,"%s <br/><small>Submitted at %s on %s</small>",item.title,time,date);
});
hatti.views.photos.full_url_from_active_image = (function hatti$views$photos$full_url_from_active_image(){
return cljs.core.last.call(null,cljs.core.re_find.call(null,/\/(http.*)/,document.querySelector("#active-image .pswp__img").getAttribute("src")));
});
/**
 * Initiate photoswipe using the index of the image that was just clicked on.
 */
hatti.views.photos.open_photoswipe = (function hatti$views$photos$open_photoswipe(index,photos){
var pswp_element = cljs.core.first.call(null,document.querySelectorAll([cljs.core.str("."),cljs.core.str(hatti.views.photos.pswp_gallery_class)].join('')));
var options = (function (){var obj22752 = {"index":(index | (0)),"getThumbBoundsFn":((function (pswp_element){
return (function (index__$1){
var thumbnail = document.querySelector(chimera.js_interop.format.call(null,"[%s='%s']",hatti.views.photos.data_pswp_id,index__$1));
var page_y_scroll = (window.pageYOffset + document.documentElement.scrollTop);
var rect = thumbnail.getBoundingClientRect();
var obj22754 = {"x":rect.left,"y":(rect.top + page_y_scroll),"w":rect.width};
return obj22754;
});})(pswp_element))
,"getImageURLForShare":((function (pswp_element){
return (function (share_button_data){
return hatti.views.photos.full_url_from_active_image.call(null);
});})(pswp_element))
,"addCaptionHTMLFn":((function (pswp_element){
return (function (item,caption_el,is_fake){
return cljs.core.first.call(null,caption_el.children).innerHTML = hatti.views.photos.build_caption.call(null,item);
});})(pswp_element))
};
return obj22752;
})();
var gallery = (new PhotoSwipe(pswp_element,PhotoSwipeUI_Default,cljs.core.clj__GT_js.call(null,photos),options));
return gallery.init();
});
/**
 * Actions to perform on thumbnail click.
 */
hatti.views.photos.on_thumbnail_click = (function hatti$views$photos$on_thumbnail_click(event,photos){
event.preventDefault();

return hatti.views.photos.open_photoswipe.call(null,event.target.getAttribute(hatti.views.photos.data_pswp_id),photos);
});
/**
 * Return True if no mimetype or the mimetype begins with image. Otherwise
 * return nil.
 */
hatti.views.photos.image_or_no_mimetype_QMARK_ = (function hatti$views$photos$image_or_no_mimetype_QMARK_(attachment){
var mimetype = cljs.core.get.call(null,attachment,hatti.constants.mimetype);
var or__6409__auto__ = cljs.core.not.call(null,mimetype);
if(or__6409__auto__){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core._EQ_.call(null,"image",cljs.core.subs.call(null,mimetype,(0),(5)));
if(or__6409__auto____$1){
return or__6409__auto____$1;
} else {
return null;
}
}
});
/**
 * Take a datum and return the datum with a new key :attachements that has a
 * list of download URLs for all the attachments.
 */
hatti.views.photos.extract_images = (function hatti$views$photos$extract_images(datum,photo_columns){
var download_url_kw = cljs.core.keyword.call(null,hatti.constants.download_url);
var attachments = (function (){var or__6409__auto__ = (function (){var G__22763 = datum;
var G__22763__$1 = (((G__22763 == null))?null:cljs.core.get.call(null,G__22763,hatti.constants.photo));
var G__22763__$2 = (((G__22763__$1 == null))?null:download_url_kw.call(null,G__22763__$1));
if((G__22763__$2 == null)){
return null;
} else {
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[G__22763__$2],null));
}
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core.reduce.call(null,((function (or__6409__auto__,download_url_kw){
return (function (p1__22756_SHARP_,p2__22755_SHARP_){
var G__22765 = cljs.core.get.call(null,datum,p2__22755_SHARP_);
var G__22765__$1 = (((G__22765 == null))?null:download_url_kw.call(null,G__22765));
var G__22765__$2 = (((G__22765__$1 == null))?null:cljs.core.conj.call(null,p1__22756_SHARP_,G__22765__$1));
if((G__22765__$2 == null)){
return null;
} else {
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,G__22765__$2);
}
});})(or__6409__auto__,download_url_kw))
,null,photo_columns);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.keep.call(null,((function (or__6409__auto____$1,or__6409__auto__,download_url_kw){
return (function (p1__22757_SHARP_){
var and__6397__auto__ = hatti.views.photos.image_or_no_mimetype_QMARK_.call(null,p1__22757_SHARP_);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.get.call(null,p1__22757_SHARP_,hatti.constants.download_url);
} else {
return and__6397__auto__;
}
});})(or__6409__auto____$1,or__6409__auto__,download_url_kw))
,cljs.core.get.call(null,datum,hatti.constants._attachments));
}
}
})();
var and__6397__auto__ = cljs.core.seq.call(null,attachments);
if(and__6397__auto__){
return cljs.core.assoc.call(null,datum,new cljs.core.Keyword(null,"attachments","attachments",-1535547830),attachments);
} else {
return and__6397__auto__;
}
});
/**
 * Build photos for photoswipe from a set of form data. Ignore submissions that
 * do not have a photo attached. If the photo info is attached directly to the
 * submission and not to the attachments list, use the information attached
 * directly to the submission.
 */
hatti.views.photos.build_photos = (function hatti$views$photos$build_photos(data,photo_columns){
var data_with_attachments = cljs.core.keep.call(null,(function (p1__22766_SHARP_){
return hatti.views.photos.extract_images.call(null,p1__22766_SHARP_,photo_columns);
}),data);
var attachment_totals = cljs.core.reductions.call(null,((function (data_with_attachments){
return (function (p1__22767_SHARP_,p2__22768_SHARP_){
return (p1__22767_SHARP_ + cljs.core.count.call(null,cljs.core.get.call(null,p2__22768_SHARP_,new cljs.core.Keyword(null,"attachments","attachments",-1535547830))));
});})(data_with_attachments))
,(0),data_with_attachments);
var total = cljs.core.last.call(null,attachment_totals);
return cljs.core.flatten.call(null,(function (){var iter__7189__auto__ = ((function (data_with_attachments,attachment_totals,total){
return (function hatti$views$photos$build_photos_$_iter__22781(s__22782){
return (new cljs.core.LazySeq(null,((function (data_with_attachments,attachment_totals,total){
return (function (){
var s__22782__$1 = s__22782;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22782__$1);
if(temp__4657__auto__){
var s__22782__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22782__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22782__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22784 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22783 = (0);
while(true){
if((i__22783 < size__7188__auto__)){
var photo_index = cljs.core._nth.call(null,c__7187__auto__,i__22783);
var map__22789 = cljs.core.nth.call(null,data_with_attachments,photo_index);
var map__22789__$1 = ((((!((map__22789 == null)))?((((map__22789.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22789.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22789):map__22789);
var datum = map__22789__$1;
var attachments = cljs.core.get.call(null,map__22789__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var cumulative_sum = cljs.core.nth.call(null,attachment_totals,photo_index);
var date = cljs.core.get.call(null,datum,hatti.constants._submission_time);
var id = cljs.core.get.call(null,datum,hatti.constants._id);
var photo = cljs.core.get.call(null,datum,hatti.constants.photo);
var rank = cljs.core.get.call(null,datum,hatti.constants._rank);
cljs.core.chunk_append.call(null,b__22784,cljs.core.map_indexed.call(null,((function (i__22783,map__22789,map__22789__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,c__7187__auto__,size__7188__auto__,b__22784,s__22782__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total){
return (function (j,attachment){
var download_url = hatti.views.photos.make_url.call(null,attachment);
var thumbnail = hatti.views.photos.resize_image.call(null,download_url,hatti.views.photos.thumb_width_px);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"thumb","thumb",1718947232),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"rank","rank",-1706728502),new cljs.core.Keyword(null,"msrc","msrc",251791403),new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"original-src","original-src",442698331)],[thumbnail,date,hatti.views.photos.width_px,rank,thumbnail,hatti.views.photos.resize_image.call(null,hatti.views.photos.make_url.call(null,download_url),hatti.views.photos.width_px),chimera.js_interop.format.call(null,"%s/%s | ID: %s",(((1) + cumulative_sum) + j),total,id),hatti.views.photos.width_px,id,download_url]);
});})(i__22783,map__22789,map__22789__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,c__7187__auto__,size__7188__auto__,b__22784,s__22782__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total))
,attachments));

var G__22793 = (i__22783 + (1));
i__22783 = G__22793;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22784),hatti$views$photos$build_photos_$_iter__22781.call(null,cljs.core.chunk_rest.call(null,s__22782__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22784),null);
}
} else {
var photo_index = cljs.core.first.call(null,s__22782__$2);
var map__22791 = cljs.core.nth.call(null,data_with_attachments,photo_index);
var map__22791__$1 = ((((!((map__22791 == null)))?((((map__22791.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22791.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22791):map__22791);
var datum = map__22791__$1;
var attachments = cljs.core.get.call(null,map__22791__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var cumulative_sum = cljs.core.nth.call(null,attachment_totals,photo_index);
var date = cljs.core.get.call(null,datum,hatti.constants._submission_time);
var id = cljs.core.get.call(null,datum,hatti.constants._id);
var photo = cljs.core.get.call(null,datum,hatti.constants.photo);
var rank = cljs.core.get.call(null,datum,hatti.constants._rank);
return cljs.core.cons.call(null,cljs.core.map_indexed.call(null,((function (map__22791,map__22791__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,s__22782__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total){
return (function (j,attachment){
var download_url = hatti.views.photos.make_url.call(null,attachment);
var thumbnail = hatti.views.photos.resize_image.call(null,download_url,hatti.views.photos.thumb_width_px);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"thumb","thumb",1718947232),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"rank","rank",-1706728502),new cljs.core.Keyword(null,"msrc","msrc",251791403),new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"original-src","original-src",442698331)],[thumbnail,date,hatti.views.photos.width_px,rank,thumbnail,hatti.views.photos.resize_image.call(null,hatti.views.photos.make_url.call(null,download_url),hatti.views.photos.width_px),chimera.js_interop.format.call(null,"%s/%s | ID: %s",(((1) + cumulative_sum) + j),total,id),hatti.views.photos.width_px,id,download_url]);
});})(map__22791,map__22791__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,s__22782__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total))
,attachments),hatti$views$photos$build_photos_$_iter__22781.call(null,cljs.core.rest.call(null,s__22782__$2)));
}
} else {
return null;
}
break;
}
});})(data_with_attachments,attachment_totals,total))
,null,null));
});})(data_with_attachments,attachment_totals,total))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,cljs.core.count.call(null,data_with_attachments)));
})());
});
/**
 * Return the full-names of all columns with photo type.
 */
hatti.views.photos.get_photo_columns = (function hatti$views$photos$get_photo_columns(form){
return cljs.core.keep.call(null,(function (p1__22794_SHARP_){
var and__6397__auto__ = (function (){var or__6409__auto__ = cljs.core._EQ_.call(null,"photo",new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(p1__22794_SHARP_));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return null;
}
})();
if(cljs.core.truth_(and__6397__auto__)){
return new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(p1__22794_SHARP_);
} else {
return and__6397__auto__;
}
}),form);
});
/**
 * Build markup with actions for a photo gallery.
 */
hatti.views.photos.build_photo_gallery = (function hatti$views$photos$build_photo_gallery(photos,owner){
var iter__7189__auto__ = (function hatti$views$photos$build_photo_gallery_$_iter__22808(s__22809){
return (new cljs.core.LazySeq(null,(function (){
var s__22809__$1 = s__22809;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22809__$1);
if(temp__4657__auto__){
var s__22809__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22809__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22809__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22811 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22810 = (0);
while(true){
if((i__22810 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__22810);
var map__22816 = cljs.core.nth.call(null,photos,i);
var map__22816__$1 = ((((!((map__22816 == null)))?((((map__22816.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22816.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22816):map__22816);
var photo = map__22816__$1;
var title = cljs.core.get.call(null,map__22816__$1,new cljs.core.Keyword(null,"title","title",636505583));
cljs.core.chunk_append.call(null,b__22811,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"figure","figure",-561394079),new cljs.core.PersistentArrayMap(null, 3, ["itemProp","associatedMedia","itemScope","","itemType","http://schema.org/ImageObject"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"href","href",-793805698),new cljs.core.Keyword(null,"src","src",-1651076051).cljs$core$IFn$_invoke$arity$1(photo),"itemProp","contentUrl",new cljs.core.Keyword(null,"data-size","data-size",-1468859869),chimera.js_interop.format.call(null,"%sx%s",hatti.views.photos.width_px,hatti.views.photos.width_px),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (i__22810,map__22816,map__22816__$1,photo,title,i,c__7187__auto__,size__7188__auto__,b__22811,s__22809__$2,temp__4657__auto__){
return (function (p1__22795_SHARP_){
return hatti.views.photos.on_thumbnail_click.call(null,p1__22795_SHARP_,photos);
});})(i__22810,map__22816,map__22816__$1,photo,title,i,c__7187__auto__,size__7188__auto__,b__22811,s__22809__$2,temp__4657__auto__))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"width","width",-384071477),hatti.views.photos.thumb_width_px_str,new cljs.core.Keyword(null,"height","height",1025178622),hatti.views.photos.thumb_width_px_str,new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"thumb","thumb",1718947232).cljs$core$IFn$_invoke$arity$1(photo),"itemProp","thumbnail",cljs.core.keyword.call(null,hatti.views.photos.data_pswp_id),i,new cljs.core.Keyword(null,"alt","alt",-3214426),title], true, false)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"figcaption","figcaption",-1790122047),new cljs.core.PersistentArrayMap(null, 1, ["itemProp","caption description"], null),title], null)], null));

var G__22820 = (i__22810 + (1));
i__22810 = G__22820;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22811),hatti$views$photos$build_photo_gallery_$_iter__22808.call(null,cljs.core.chunk_rest.call(null,s__22809__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22811),null);
}
} else {
var i = cljs.core.first.call(null,s__22809__$2);
var map__22818 = cljs.core.nth.call(null,photos,i);
var map__22818__$1 = ((((!((map__22818 == null)))?((((map__22818.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22818.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22818):map__22818);
var photo = map__22818__$1;
var title = cljs.core.get.call(null,map__22818__$1,new cljs.core.Keyword(null,"title","title",636505583));
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"figure","figure",-561394079),new cljs.core.PersistentArrayMap(null, 3, ["itemProp","associatedMedia","itemScope","","itemType","http://schema.org/ImageObject"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"href","href",-793805698),new cljs.core.Keyword(null,"src","src",-1651076051).cljs$core$IFn$_invoke$arity$1(photo),"itemProp","contentUrl",new cljs.core.Keyword(null,"data-size","data-size",-1468859869),chimera.js_interop.format.call(null,"%sx%s",hatti.views.photos.width_px,hatti.views.photos.width_px),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__22818,map__22818__$1,photo,title,i,s__22809__$2,temp__4657__auto__){
return (function (p1__22795_SHARP_){
return hatti.views.photos.on_thumbnail_click.call(null,p1__22795_SHARP_,photos);
});})(map__22818,map__22818__$1,photo,title,i,s__22809__$2,temp__4657__auto__))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"width","width",-384071477),hatti.views.photos.thumb_width_px_str,new cljs.core.Keyword(null,"height","height",1025178622),hatti.views.photos.thumb_width_px_str,new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"thumb","thumb",1718947232).cljs$core$IFn$_invoke$arity$1(photo),"itemProp","thumbnail",cljs.core.keyword.call(null,hatti.views.photos.data_pswp_id),i,new cljs.core.Keyword(null,"alt","alt",-3214426),title], true, false)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"figcaption","figcaption",-1790122047),new cljs.core.PersistentArrayMap(null, 1, ["itemProp","caption description"], null),title], null)], null),hatti$views$photos$build_photo_gallery_$_iter__22808.call(null,cljs.core.rest.call(null,s__22809__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,cljs.core.range.call(null,cljs.core.count.call(null,photos)));
});
cljs.core._add_method.call(null,hatti.views.photos_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__22821,owner){
var map__22822 = p__22821;
var map__22822__$1 = ((((!((map__22822 == null)))?((((map__22822.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22822.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22822):map__22822);
var map__22823 = cljs.core.get.call(null,map__22822__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__22823__$1 = ((((!((map__22823 == null)))?((((map__22823.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22823.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22823):map__22823);
var dataset_info = map__22823__$1;
var num_of_submissions = cljs.core.get.call(null,map__22823__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));

if(typeof hatti.views.photos.t_hatti$views$photos22826 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.photos.t_hatti$views$photos22826 = (function (p__22821,owner,map__22822,map__22823,dataset_info,num_of_submissions,meta22827){
this.p__22821 = p__22821;
this.owner = owner;
this.map__22822 = map__22822;
this.map__22823 = map__22823;
this.dataset_info = dataset_info;
this.num_of_submissions = num_of_submissions;
this.meta22827 = meta22827;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.photos.t_hatti$views$photos22826.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (_22828,meta22827__$1){
var self__ = this;
var _22828__$1 = this;
return (new hatti.views.photos.t_hatti$views$photos22826(self__.p__22821,self__.owner,self__.map__22822,self__.map__22823,self__.dataset_info,self__.num_of_submissions,meta22827__$1));
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos22826.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (_22828){
var self__ = this;
var _22828__$1 = this;
return self__.meta22827;
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos22826.prototype.om$core$IInitState$ = true;

hatti.views.photos.t_hatti$views$photos22826.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.assoc.call(null,cljs.core.select_keys.call(null,cljs.core.deref.call(null,hatti.shared.app_state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"data","data",-232669377)], null)),new cljs.core.Keyword(null,"photo-columns","photo-columns",-916714301),hatti.views.photos.get_photo_columns.call(null,om.core.get_shared.call(null,self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)], null))));
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos22826.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.photos.t_hatti$views$photos22826.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;
return om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"map-page","map-page",108547100).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos22826.prototype.om$core$IRenderState$ = true;

hatti.views.photos.t_hatti$views$photos22826.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (_,p__22829){
var self__ = this;
var map__22830 = p__22829;
var map__22830__$1 = ((((!((map__22830 == null)))?((((map__22830.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22830.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22830):map__22830);
var data = cljs.core.get.call(null,map__22830__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var photo_columns = cljs.core.get.call(null,map__22830__$1,new cljs.core.Keyword(null,"photo-columns","photo-columns",-916714301));
var ___$1 = this;
var form = om.core.get_shared.call(null,self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flat-form","flat-form",-468858211)], null));
var photos = hatti.views.photos.build_photos.call(null,data,photo_columns);
var attrs22832 = ((((self__.num_of_submissions === (0))) || ((cljs.core.seq.call(null,data)) && (cljs.core.empty_QMARK_.call(null,photos))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p.alert.alert-warning.alert-photos","p.alert.alert-warning.alert-photos",-657175475),"There are no photos in this dataset yet."], null):((cljs.core.seq.call(null,photos))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"role","role",-736691072),"dialog",new cljs.core.Keyword(null,"aria-hidden","aria-hidden",399337029),"true",new cljs.core.Keyword(null,"tab-index","tab-index",895755393),"-1",new cljs.core.Keyword(null,"class","class",-2030961996),hatti.views.photos.pswp_gallery_class], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__bg","div.pswp__bg",1669805982)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__scroll-wrap","div.pswp__scroll-wrap",1877488723),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__container","div.pswp__container",-126857170),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__item","div.pswp__item",-939569134)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__item#active-image","div.pswp__item#active-image",1508385310)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__item","div.pswp__item",-939569134)], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__ui.pswp__ui--hidden","div.pswp__ui.pswp__ui--hidden",1077730658),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__top-bar","div.pswp__top-bar",-914890044),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__counter","div.pswp__counter",-781104003)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.pswp__button.pswp__button--close","button.pswp__button.pswp__button--close",-979514797),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),"Close (Esc)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.pswp__button.pswp__button--share","button.pswp__button.pswp__button--share",2058146350),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),"Share"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.pswp__button.pswp__button--fs","button.pswp__button.pswp__button--fs",-479010560),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),"Toggle fullscreen"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.pswp__button.pswp__button--zoom","button.pswp__button.pswp__button--zoom",-38289765),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),"Zoom in/out"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__preloader","div.pswp__preloader",408520552),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__preloader__icn","div.pswp__preloader__icn",-844032322),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__preloader__cut","div.pswp__preloader__cut",1843580006),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__preloader__donut","div.pswp__preloader__donut",1396225650)], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__share-modal.pswp__share-modal--hidden","div.pswp__share-modal.pswp__share-modal--hidden",-754956526),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"pswp__single-tap"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__share-tooltip","div.pswp__share-tooltip",-1834925015)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.pswp__button.pswp__button--arrow--left","button.pswp__button.pswp__button--arrow--left",983762009),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),"Previous (arrow left)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.pswp__button.pswp__button--arrow--right","button.pswp__button.pswp__button--arrow--right",-1908670289),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),"Next (arrow right)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__caption","div.pswp__caption",-531230195),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pswp__caption__center","div.pswp__caption__center",487765957)], null)], null)], null)], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p.alert.alert-photos","p.alert.alert-photos",-861098252),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-spinner.fa-pulse","i.fa.fa-spinner.fa-pulse",869871146)], null),"Loading photos ..."], null)
));
return cljs.core.apply.call(null,React.DOM.div,((cljs.core.map_QMARK_.call(null,attrs22832))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-content"], null)], null),attrs22832)):({"className": "tab-content"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs22832))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.div(({"itemScope": "", "itemType": "http://schema.org/ImageGallery", "className": "gallery"}),(function (){var attrs22833 = hatti.views.photos.build_photo_gallery.call(null,photos,self__.owner);
return cljs.core.apply.call(null,React.DOM.table,((cljs.core.map_QMARK_.call(null,attrs22833))?sablono.interpreter.attributes.call(null,attrs22833):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs22833))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs22833)], null))));
})())], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs22832),React.DOM.div(({"itemScope": "", "itemType": "http://schema.org/ImageGallery", "className": "gallery"}),(function (){var attrs22834 = hatti.views.photos.build_photo_gallery.call(null,photos,self__.owner);
return cljs.core.apply.call(null,React.DOM.table,((cljs.core.map_QMARK_.call(null,attrs22834))?sablono.interpreter.attributes.call(null,attrs22834):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs22834))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs22834)], null))));
})())], null))));
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos22826.getBasis = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__22821","p__22821",1485703645,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__22822","map__22822",208604065,null),new cljs.core.Symbol(null,"map__22823","map__22823",1981583002,null),new cljs.core.Symbol(null,"dataset-info","dataset-info",443531964,null),new cljs.core.Symbol(null,"num_of_submissions","num_of_submissions",-80411564,null),new cljs.core.Symbol(null,"meta22827","meta22827",-1082078699,null)], null);
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos22826.cljs$lang$type = true;

hatti.views.photos.t_hatti$views$photos22826.cljs$lang$ctorStr = "hatti.views.photos/t_hatti$views$photos22826";

hatti.views.photos.t_hatti$views$photos22826.cljs$lang$ctorPrWriter = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.photos/t_hatti$views$photos22826");
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.__GT_t_hatti$views$photos22826 = ((function (map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions){
return (function hatti$views$photos$__GT_t_hatti$views$photos22826(p__22821__$1,owner__$1,map__22822__$2,map__22823__$2,dataset_info__$1,num_of_submissions__$1,meta22827){
return (new hatti.views.photos.t_hatti$views$photos22826(p__22821__$1,owner__$1,map__22822__$2,map__22823__$2,dataset_info__$1,num_of_submissions__$1,meta22827));
});})(map__22822,map__22822__$1,map__22823,map__22823__$1,dataset_info,num_of_submissions))
;

}

return (new hatti.views.photos.t_hatti$views$photos22826(p__22821,owner,map__22822__$1,map__22823__$1,dataset_info,num_of_submissions,cljs.core.PersistentArrayMap.EMPTY));
}));
