// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten.call(null,(function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__22577(s__22578){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__22578__$1 = s__22578;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22578__$1);
if(temp__4657__auto__){
var s__22578__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22578__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22578__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22580 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22579 = (0);
while(true){
if((i__22579 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__22579);
cljs.core.chunk_append.call(null,b__22580,(function (){var iter__7189__auto__ = ((function (i__22579,datum,c__7187__auto__,size__7188__auto__,b__22580,s__22578__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__22577_$_iter__22589(s__22590){
return (new cljs.core.LazySeq(null,((function (i__22579,datum,c__7187__auto__,size__7188__auto__,b__22580,s__22578__$2,temp__4657__auto__,osmfields){
return (function (){
var s__22590__$1 = s__22590;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__22590__$1);
if(temp__4657__auto____$1){
var s__22590__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22590__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__22590__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__22592 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__22591 = (0);
while(true){
if((i__22591 < size__7188__auto____$1)){
var field = cljs.core._nth.call(null,c__7187__auto____$1,i__22591);
cljs.core.chunk_append.call(null,b__22592,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__22597 = (i__22591 + (1));
i__22591 = G__22597;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22592),hatti$ona$post_process$ona_osm_link_$_iter__22577_$_iter__22589.call(null,cljs.core.chunk_rest.call(null,s__22590__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22592),null);
}
} else {
var field = cljs.core.first.call(null,s__22590__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__22577_$_iter__22589.call(null,cljs.core.rest.call(null,s__22590__$2)));
}
} else {
return null;
}
break;
}
});})(i__22579,datum,c__7187__auto__,size__7188__auto__,b__22580,s__22578__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__22579,datum,c__7187__auto__,size__7188__auto__,b__22580,s__22578__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})());

var G__22598 = (i__22579 + (1));
i__22579 = G__22598;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22580),hatti$ona$post_process$ona_osm_link_$_iter__22577.call(null,cljs.core.chunk_rest.call(null,s__22578__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22580),null);
}
} else {
var datum = cljs.core.first.call(null,s__22578__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (datum,s__22578__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__22577_$_iter__22593(s__22594){
return (new cljs.core.LazySeq(null,((function (datum,s__22578__$2,temp__4657__auto__,osmfields){
return (function (){
var s__22594__$1 = s__22594;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__22594__$1);
if(temp__4657__auto____$1){
var s__22594__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22594__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22594__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22596 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22595 = (0);
while(true){
if((i__22595 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__22595);
cljs.core.chunk_append.call(null,b__22596,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})());

var G__22599 = (i__22595 + (1));
i__22595 = G__22599;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22596),hatti$ona$post_process$ona_osm_link_$_iter__22577_$_iter__22593.call(null,cljs.core.chunk_rest.call(null,s__22594__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22596),null);
}
} else {
var field = cljs.core.first.call(null,s__22594__$2);
return cljs.core.cons.call(null,(function (){var osmkey = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.call(null,datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find.call(null,/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field","field",-1302436500),field], null),cljs.core.select_keys.call(null,datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true)))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__22577_$_iter__22593.call(null,cljs.core.rest.call(null,s__22594__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__22578__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__22578__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__.call(null,osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__22577.call(null,cljs.core.rest.call(null,s__22578__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__.call(null,data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.call(null,osmtogeojson(jQuery.parseXML(osm_xml_string)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link.call(null,data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson.call(null,osm_xml);
var featureset = osmgeo.call(null,new cljs.core.Keyword(null,"features","features",-1146962336));
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__22620(s__22621){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__22621__$1 = s__22621;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22621__$1);
if(temp__4657__auto__){
var s__22621__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22621__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22621__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22623 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22622 = (0);
while(true){
if((i__22622 < size__7188__auto__)){
var map__22632 = cljs.core._nth.call(null,c__7187__auto__,i__22622);
var map__22632__$1 = ((((!((map__22632 == null)))?((((map__22632.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22632.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22632):map__22632);
var feature = map__22632__$1;
var type = cljs.core.get.call(null,map__22632__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__22632__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__22632__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
cljs.core.chunk_append.call(null,b__22623,(function (){var map__22634 = properties;
var map__22634__$1 = ((((!((map__22634 == null)))?((((map__22634.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22634.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22634):map__22634);
var type__$1 = cljs.core.get.call(null,map__22634__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__22634__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__22634__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})());

var G__22640 = (i__22622 + (1));
i__22622 = G__22640;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22623),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__22620.call(null,cljs.core.chunk_rest.call(null,s__22621__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22623),null);
}
} else {
var map__22636 = cljs.core.first.call(null,s__22621__$2);
var map__22636__$1 = ((((!((map__22636 == null)))?((((map__22636.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22636.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22636):map__22636);
var feature = map__22636__$1;
var type = cljs.core.get.call(null,map__22636__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var properties = cljs.core.get.call(null,map__22636__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var geometry = cljs.core.get.call(null,map__22636__$1,new cljs.core.Keyword(null,"geometry","geometry",-405034994));
return cljs.core.cons.call(null,(function (){var map__22638 = properties;
var map__22638__$1 = ((((!((map__22638 == null)))?((((map__22638.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22638.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22638):map__22638);
var type__$1 = cljs.core.get.call(null,map__22638__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__22638__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tags = cljs.core.get.call(null,map__22638__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420),id,new cljs.core.Keyword(null,"type","type",1174270348),type__$1,new cljs.core.Keyword(null,"geom","geom",1207084371),geometry,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(tags),new cljs.core.Keyword(null,"tags","tags",1771418977),tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__22620.call(null,cljs.core.rest.call(null,s__22621__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__.call(null,featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.call(null,hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq.call(null,osm_fields)){
var data = cljs.core.get_in.call(null,app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data.call(null,data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__22641_SHARP_){
return cljs.core.re_find.call(null,/[-]?[0-9]+/,p1__22641_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = osm_data.call(null,osm_id);
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__22651(s__22652){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__22652__$1 = s__22652;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22652__$1);
if(temp__4657__auto__){
var s__22652__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22652__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22652__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22654 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22653 = (0);
while(true){
if((i__22653 < size__7188__auto__)){
var datum = cljs.core._nth.call(null,c__7187__auto__,i__22653);
cljs.core.chunk_append.call(null,b__22654,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__22653,osm_id,datum,c__7187__auto__,size__7188__auto__,b__22654,s__22652__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__22642_SHARP_){
return osm_val__GT_osm_data.call(null,p1__22642_SHARP_,osm_id);
});})(i__22653,osm_id,datum,c__7187__auto__,size__7188__auto__,b__22654,s__22652__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__22659 = (i__22653 + (1));
i__22653 = G__22659;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22654),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__22651.call(null,cljs.core.chunk_rest.call(null,s__22652__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22654),null);
}
} else {
var datum = cljs.core.first.call(null,s__22652__$2);
return cljs.core.cons.call(null,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.call(null,datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__22652__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__22642_SHARP_){
return osm_val__GT_osm_data.call(null,p1__22642_SHARP_,osm_id);
});})(osm_id,datum,s__22652__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__22651.call(null,cljs.core.rest.call(null,s__22652__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__.call(null,data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__22655 = cljs.core.seq.call(null,osm_fields);
var chunk__22656 = null;
var count__22657 = (0);
var i__22658 = (0);
while(true){
if((i__22658 < count__22657)){
var osm_field = cljs.core._nth.call(null,chunk__22656,i__22658);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__22660 = seq__22655;
var G__22661 = chunk__22656;
var G__22662 = count__22657;
var G__22663 = (i__22658 + (1));
seq__22655 = G__22660;
chunk__22656 = G__22661;
count__22657 = G__22662;
i__22658 = G__22663;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22655);
if(temp__4657__auto__){
var seq__22655__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22655__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__22655__$1);
var G__22664 = cljs.core.chunk_rest.call(null,seq__22655__$1);
var G__22665 = c__7220__auto__;
var G__22666 = cljs.core.count.call(null,c__7220__auto__);
var G__22667 = (0);
seq__22655 = G__22664;
chunk__22656 = G__22665;
count__22657 = G__22666;
i__22658 = G__22667;
continue;
} else {
var osm_field = cljs.core.first.call(null,seq__22655__$1);
chimera.om.state.transact_BANG_.call(null,app_state,app_state_keys,updater.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__22668 = cljs.core.next.call(null,seq__22655__$1);
var G__22669 = null;
var G__22670 = (0);
var G__22671 = (0);
seq__22655 = G__22668;
chunk__22656 = G__22669;
count__22657 = G__22670;
i__22658 = G__22671;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.call(null,media_obj,"id");
var fname = cljs.core.get.call(null,media_obj,"filename");
var file_url = hatti.ona.urls.media_url.call(null,media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"filename","filename",-1428840783),fname,new cljs.core.Keyword(null,"download_url","download_url",-2115471203),file_url,new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565),[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
var or__6409__auto__ = chimera.seq.filter_first.call(null,(function (p1__22672_SHARP_){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,cljs.core.first.call(null,clojure.string.split.call(null,fname,cljs.core.re_pattern.call(null,"\\.")))),p1__22672_SHARP_);
}),fnames);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.call(null,((function (attachments__$1){
return (function (p1__22673_SHARP_){
return chimera.urls.last_url_param.call(null,cljs.core.get.call(null,p1__22673_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap.call(null,fnames,cljs.core.map.call(null,hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.call(null,fname__GT_urlobj,hatti.ona.post_process.get_matching_name.call(null,fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.call(null,(function (p1__22674_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_.call(null,p1__22674_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.image_QMARK_.call(null,p1__22674_SHARP_);
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22685 = arguments.length;
var i__7485__auto___22686 = (0);
while(true){
if((i__7485__auto___22686 < len__7484__auto___22685)){
args__7491__auto__.push((arguments[i__7485__auto___22686]));

var G__22687 = (i__7485__auto___22686 + (1));
i__7485__auto___22686 = G__22687;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__22678){
var map__22679 = p__22678;
var map__22679__$1 = ((((!((map__22679 == null)))?((((map__22679.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22679.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22679):map__22679);
var attachments = cljs.core.get.call(null,map__22679__$1,new cljs.core.Keyword(null,"attachments","attachments",-1535547830));
var image_fields = hatti.ona.post_process.filter_media.call(null,flat_form);
var iter__7189__auto__ = ((function (image_fields,map__22679,map__22679__$1,attachments){
return (function hatti$ona$post_process$iter__22681(s__22682){
return (new cljs.core.LazySeq(null,((function (image_fields,map__22679,map__22679__$1,attachments){
return (function (){
var s__22682__$1 = s__22682;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22682__$1);
if(temp__4657__auto__){
var s__22682__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22682__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22682__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22684 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22683 = (0);
while(true){
if((i__22683 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__22683);
cljs.core.chunk_append.call(null,b__22684,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (i__22683,attach_map,record,c__7187__auto__,size__7188__auto__,b__22684,s__22682__$2,temp__4657__auto__,image_fields,map__22679,map__22679__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__22683,attach_map,record,c__7187__auto__,size__7188__auto__,b__22684,s__22682__$2,temp__4657__auto__,image_fields,map__22679,map__22679__$1,attachments))
,record,image_fields);
})());

var G__22688 = (i__22683 + (1));
i__22683 = G__22688;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22684),hatti$ona$post_process$iter__22681.call(null,cljs.core.chunk_rest.call(null,s__22682__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22684),null);
}
} else {
var record = cljs.core.first.call(null,s__22682__$2);
return cljs.core.cons.call(null,(function (){var attach_map = hatti.ona.post_process.get_attach_map.call(null,record,attachments);
return cljs.core.reduce.call(null,((function (attach_map,record,s__22682__$2,temp__4657__auto__,image_fields,map__22679,map__22679__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.call(null,record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__22682__$2,temp__4657__auto__,image_fields,map__22679,map__22679__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__22681.call(null,cljs.core.rest.call(null,s__22682__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__22679,map__22679__$1,attachments))
,null,null));
});})(image_fields,map__22679,map__22679__$1,attachments))
;
return iter__7189__auto__.call(null,data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq22675){
var G__22676 = cljs.core.first.call(null,seq22675);
var seq22675__$1 = cljs.core.next.call(null,seq22675);
var G__22677 = cljs.core.first.call(null,seq22675__$1);
var seq22675__$2 = cljs.core.next.call(null,seq22675__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__22676,G__22677,seq22675__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.call(null,record,key,hatti.ona.post_process.integrate_attachments.call(null,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.call(null,record,key),new cljs.core.Keyword(null,"attachments","attachments",-1535547830),cljs.core.get.call(null,record,hatti.constants._attachments)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__22693(s__22694){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__22694__$1 = s__22694;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__22694__$1);
if(temp__4657__auto__){
var s__22694__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__22694__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__22694__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__22696 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__22695 = (0);
while(true){
if((i__22695 < size__7188__auto__)){
var record = cljs.core._nth.call(null,c__7187__auto__,i__22695);
cljs.core.chunk_append.call(null,b__22696,cljs.core.reduce.call(null,integrate,record,repeat_fields));

var G__22697 = (i__22695 + (1));
i__22695 = G__22697;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22696),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__22693.call(null,cljs.core.chunk_rest.call(null,s__22694__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__22696),null);
}
} else {
var record = cljs.core.first.call(null,s__22694__$2);
return cljs.core.cons.call(null,cljs.core.reduce.call(null,integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__22693.call(null,cljs.core.rest.call(null,s__22694__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__.call(null,data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22705 = arguments.length;
var i__7485__auto___22706 = (0);
while(true){
if((i__7485__auto___22706 < len__7484__auto___22705)){
args__7491__auto__.push((arguments[i__7485__auto___22706]));

var G__22707 = (i__7485__auto___22706 + (1));
i__7485__auto___22706 = G__22707;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__22702){
var map__22703 = p__22702;
var map__22703__$1 = ((((!((map__22703 == null)))?((((map__22703.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22703.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22703):map__22703);
var app_data_keys = cljs.core.get.call(null,map__22703__$1,new cljs.core.Keyword(null,"app-data-keys","app-data-keys",-662378404),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
return chimera.om.state.transact_BANG_.call(null,app_state,app_data_keys,((function (map__22703,map__22703__$1,app_data_keys){
return (function (p1__22698_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats.call(null,flat_form,hatti.ona.post_process.integrate_attachments.call(null,flat_form,p1__22698_SHARP_));
});})(map__22703,map__22703__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq22699){
var G__22700 = cljs.core.first.call(null,seq22699);
var seq22699__$1 = cljs.core.next.call(null,seq22699);
var G__22701 = cljs.core.first.call(null,seq22699__$1);
var seq22699__$2 = cljs.core.next.call(null,seq22699__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22700,G__22701,seq22699__$2);
});

