// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7072__auto__ = (((obj == null))?null:obj);
var m__7073__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,obj);
} else {
var m__7073__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,obj);
} else {
throw cljs.core.missing_protocol.call(null,"ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__21320 = millis;
if((G__21320 == null)){
return null;
} else {
return goog.date.UtcDateTime.fromTimestamp.call(null,G__21320);
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first.call(null,(function (){var iter__7189__auto__ = (function cljs_time$coerce$from_string_$_iter__21329(s__21330){
return (new cljs.core.LazySeq(null,(function (){
var s__21330__$1 = s__21330;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21330__$1);
if(temp__4657__auto__){
var s__21330__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21330__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21330__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21332 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21331 = (0);
while(true){
if((i__21331 < size__7188__auto__)){
var f = cljs.core._nth.call(null,c__7187__auto__,i__21331);
var d = (function (){try{return cljs_time.format.parse.call(null,f,s);
}catch (e21335){if((e21335 instanceof Error)){
var _ = e21335;
return null;
} else {
throw e21335;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append.call(null,b__21332,d);

var G__21337 = (i__21331 + (1));
i__21331 = G__21337;
continue;
} else {
var G__21338 = (i__21331 + (1));
i__21331 = G__21338;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21332),cljs_time$coerce$from_string_$_iter__21329.call(null,cljs.core.chunk_rest.call(null,s__21330__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21332),null);
}
} else {
var f = cljs.core.first.call(null,s__21330__$2);
var d = (function (){try{return cljs_time.format.parse.call(null,f,s);
}catch (e21336){if((e21336 instanceof Error)){
var _ = e21336;
return null;
} else {
throw e21336;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons.call(null,d,cljs_time$coerce$from_string_$_iter__21329.call(null,cljs.core.rest.call(null,s__21330__$2)));
} else {
var G__21339 = cljs.core.rest.call(null,s__21330__$2);
s__21330__$1 = G__21339;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,cljs.core.vals.call(null,cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__21341 = date;
var G__21341__$1 = (((G__21341 == null))?null:G__21341.getTime());
if((G__21341__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long.call(null,G__21341__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__21343 = obj;
var G__21343__$1 = (((G__21343 == null))?null:cljs_time.coerce.to_date_time.call(null,G__21343));
if((G__21343__$1 == null)){
return null;
} else {
return G__21343__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var G__21345 = obj;
var G__21345__$1 = (((G__21345 == null))?null:cljs_time.coerce.to_long.call(null,G__21345));
if((G__21345__$1 == null)){
return null;
} else {
return (G__21345__$1 / (1000));
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__21347 = obj;
var G__21347__$1 = (((G__21347 == null))?null:cljs_time.coerce.to_date_time.call(null,G__21347));
var G__21347__$2 = (((G__21347__$1 == null))?null:G__21347__$1.getTime());
if((G__21347__$2 == null)){
return null;
} else {
return (new Date(G__21347__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__21349 = obj;
var G__21349__$1 = (((G__21349 == null))?null:cljs_time.coerce.to_date_time.call(null,G__21349));
if((G__21349__$1 == null)){
return null;
} else {
return cljs_time.format.unparse.call(null,new cljs.core.Keyword(null,"date-time","date-time",177938180).cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__21349__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time.call(null,obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__21351 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__21351.setHours(dt.getHours());

G__21351.setMinutes(dt.getMinutes());

G__21351.setSeconds(dt.getSeconds());

G__21351.setMilliseconds(dt.getMilliseconds());

return G__21351;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date.call(null,date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
var G__21352 = (new goog.date.UtcDateTime());
G__21352.set(local_date__$1);

return G__21352;
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
var G__21353 = (new goog.date.UtcDateTime());
G__21353.setTime(local_date_time__$1.getTime());

return G__21353;
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long.call(null,long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string.call(null,string);
}));
