// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args12346 = [];
var len__7484__auto___12352 = arguments.length;
var i__7485__auto___12353 = (0);
while(true){
if((i__7485__auto___12353 < len__7484__auto___12352)){
args12346.push((arguments[i__7485__auto___12353]));

var G__12354 = (i__7485__auto___12353 + (1));
i__7485__auto___12353 = G__12354;
continue;
} else {
}
break;
}

var G__12348 = args12346.length;
switch (G__12348) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12346.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async12349 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12349 = (function (f,blockable,meta12350){
this.f = f;
this.blockable = blockable;
this.meta12350 = meta12350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12351,meta12350__$1){
var self__ = this;
var _12351__$1 = this;
return (new cljs.core.async.t_cljs$core$async12349(self__.f,self__.blockable,meta12350__$1));
});

cljs.core.async.t_cljs$core$async12349.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12351){
var self__ = this;
var _12351__$1 = this;
return self__.meta12350;
});

cljs.core.async.t_cljs$core$async12349.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12349.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12349.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async12349.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async12349.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12350","meta12350",-797149295,null)], null);
});

cljs.core.async.t_cljs$core$async12349.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12349.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12349";

cljs.core.async.t_cljs$core$async12349.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12349");
});

cljs.core.async.__GT_t_cljs$core$async12349 = (function cljs$core$async$__GT_t_cljs$core$async12349(f__$1,blockable__$1,meta12350){
return (new cljs.core.async.t_cljs$core$async12349(f__$1,blockable__$1,meta12350));
});

}

return (new cljs.core.async.t_cljs$core$async12349(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args12358 = [];
var len__7484__auto___12361 = arguments.length;
var i__7485__auto___12362 = (0);
while(true){
if((i__7485__auto___12362 < len__7484__auto___12361)){
args12358.push((arguments[i__7485__auto___12362]));

var G__12363 = (i__7485__auto___12362 + (1));
i__7485__auto___12362 = G__12363;
continue;
} else {
}
break;
}

var G__12360 = args12358.length;
switch (G__12360) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12358.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args12365 = [];
var len__7484__auto___12368 = arguments.length;
var i__7485__auto___12369 = (0);
while(true){
if((i__7485__auto___12369 < len__7484__auto___12368)){
args12365.push((arguments[i__7485__auto___12369]));

var G__12370 = (i__7485__auto___12369 + (1));
i__7485__auto___12369 = G__12370;
continue;
} else {
}
break;
}

var G__12367 = args12365.length;
switch (G__12367) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12365.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args12372 = [];
var len__7484__auto___12375 = arguments.length;
var i__7485__auto___12376 = (0);
while(true){
if((i__7485__auto___12376 < len__7484__auto___12375)){
args12372.push((arguments[i__7485__auto___12376]));

var G__12377 = (i__7485__auto___12376 + (1));
i__7485__auto___12376 = G__12377;
continue;
} else {
}
break;
}

var G__12374 = args12372.length;
switch (G__12374) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12372.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_12379 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_12379);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_12379,ret){
return (function (){
return fn1.call(null,val_12379);
});})(val_12379,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args12380 = [];
var len__7484__auto___12383 = arguments.length;
var i__7485__auto___12384 = (0);
while(true){
if((i__7485__auto___12384 < len__7484__auto___12383)){
args12380.push((arguments[i__7485__auto___12384]));

var G__12385 = (i__7485__auto___12384 + (1));
i__7485__auto___12384 = G__12385;
continue;
} else {
}
break;
}

var G__12382 = args12380.length;
switch (G__12382) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12380.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___12387 = n;
var x_12388 = (0);
while(true){
if((x_12388 < n__7324__auto___12387)){
(a[x_12388] = (0));

var G__12389 = (x_12388 + (1));
x_12388 = G__12389;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__12390 = (i + (1));
i = G__12390;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async12394 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12394 = (function (alt_flag,flag,meta12395){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta12395 = meta12395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_12396,meta12395__$1){
var self__ = this;
var _12396__$1 = this;
return (new cljs.core.async.t_cljs$core$async12394(self__.alt_flag,self__.flag,meta12395__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async12394.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_12396){
var self__ = this;
var _12396__$1 = this;
return self__.meta12395;
});})(flag))
;

cljs.core.async.t_cljs$core$async12394.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12394.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async12394.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12394.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async12394.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12395","meta12395",-738890392,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async12394.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12394";

cljs.core.async.t_cljs$core$async12394.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12394");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async12394 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12394(alt_flag__$1,flag__$1,meta12395){
return (new cljs.core.async.t_cljs$core$async12394(alt_flag__$1,flag__$1,meta12395));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async12394(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async12400 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12400 = (function (alt_handler,flag,cb,meta12401){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta12401 = meta12401;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12400.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12402,meta12401__$1){
var self__ = this;
var _12402__$1 = this;
return (new cljs.core.async.t_cljs$core$async12400(self__.alt_handler,self__.flag,self__.cb,meta12401__$1));
});

cljs.core.async.t_cljs$core$async12400.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12402){
var self__ = this;
var _12402__$1 = this;
return self__.meta12401;
});

cljs.core.async.t_cljs$core$async12400.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async12400.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async12400.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async12400.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async12400.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12401","meta12401",225204801,null)], null);
});

cljs.core.async.t_cljs$core$async12400.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12400.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12400";

cljs.core.async.t_cljs$core$async12400.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async12400");
});

cljs.core.async.__GT_t_cljs$core$async12400 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12400(alt_handler__$1,flag__$1,cb__$1,meta12401){
return (new cljs.core.async.t_cljs$core$async12400(alt_handler__$1,flag__$1,cb__$1,meta12401));
});

}

return (new cljs.core.async.t_cljs$core$async12400(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12403_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12403_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12404_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12404_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__12405 = (i + (1));
i = G__12405;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___12411 = arguments.length;
var i__7485__auto___12412 = (0);
while(true){
if((i__7485__auto___12412 < len__7484__auto___12411)){
args__7491__auto__.push((arguments[i__7485__auto___12412]));

var G__12413 = (i__7485__auto___12412 + (1));
i__7485__auto___12412 = G__12413;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12408){
var map__12409 = p__12408;
var map__12409__$1 = ((((!((map__12409 == null)))?((((map__12409.cljs$lang$protocol_mask$partition0$ & (64))) || (map__12409.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12409):map__12409);
var opts = map__12409__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12406){
var G__12407 = cljs.core.first.call(null,seq12406);
var seq12406__$1 = cljs.core.next.call(null,seq12406);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12407,seq12406__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args12414 = [];
var len__7484__auto___12464 = arguments.length;
var i__7485__auto___12465 = (0);
while(true){
if((i__7485__auto___12465 < len__7484__auto___12464)){
args12414.push((arguments[i__7485__auto___12465]));

var G__12466 = (i__7485__auto___12465 + (1));
i__7485__auto___12465 = G__12466;
continue;
} else {
}
break;
}

var G__12416 = args12414.length;
switch (G__12416) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12414.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12301__auto___12468 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___12468){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___12468){
return (function (state_12440){
var state_val_12441 = (state_12440[(1)]);
if((state_val_12441 === (7))){
var inst_12436 = (state_12440[(2)]);
var state_12440__$1 = state_12440;
var statearr_12442_12469 = state_12440__$1;
(statearr_12442_12469[(2)] = inst_12436);

(statearr_12442_12469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (1))){
var state_12440__$1 = state_12440;
var statearr_12443_12470 = state_12440__$1;
(statearr_12443_12470[(2)] = null);

(statearr_12443_12470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (4))){
var inst_12419 = (state_12440[(7)]);
var inst_12419__$1 = (state_12440[(2)]);
var inst_12420 = (inst_12419__$1 == null);
var state_12440__$1 = (function (){var statearr_12444 = state_12440;
(statearr_12444[(7)] = inst_12419__$1);

return statearr_12444;
})();
if(cljs.core.truth_(inst_12420)){
var statearr_12445_12471 = state_12440__$1;
(statearr_12445_12471[(1)] = (5));

} else {
var statearr_12446_12472 = state_12440__$1;
(statearr_12446_12472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (13))){
var state_12440__$1 = state_12440;
var statearr_12447_12473 = state_12440__$1;
(statearr_12447_12473[(2)] = null);

(statearr_12447_12473[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (6))){
var inst_12419 = (state_12440[(7)]);
var state_12440__$1 = state_12440;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12440__$1,(11),to,inst_12419);
} else {
if((state_val_12441 === (3))){
var inst_12438 = (state_12440[(2)]);
var state_12440__$1 = state_12440;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12440__$1,inst_12438);
} else {
if((state_val_12441 === (12))){
var state_12440__$1 = state_12440;
var statearr_12448_12474 = state_12440__$1;
(statearr_12448_12474[(2)] = null);

(statearr_12448_12474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (2))){
var state_12440__$1 = state_12440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12440__$1,(4),from);
} else {
if((state_val_12441 === (11))){
var inst_12429 = (state_12440[(2)]);
var state_12440__$1 = state_12440;
if(cljs.core.truth_(inst_12429)){
var statearr_12449_12475 = state_12440__$1;
(statearr_12449_12475[(1)] = (12));

} else {
var statearr_12450_12476 = state_12440__$1;
(statearr_12450_12476[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (9))){
var state_12440__$1 = state_12440;
var statearr_12451_12477 = state_12440__$1;
(statearr_12451_12477[(2)] = null);

(statearr_12451_12477[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (5))){
var state_12440__$1 = state_12440;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12452_12478 = state_12440__$1;
(statearr_12452_12478[(1)] = (8));

} else {
var statearr_12453_12479 = state_12440__$1;
(statearr_12453_12479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (14))){
var inst_12434 = (state_12440[(2)]);
var state_12440__$1 = state_12440;
var statearr_12454_12480 = state_12440__$1;
(statearr_12454_12480[(2)] = inst_12434);

(statearr_12454_12480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (10))){
var inst_12426 = (state_12440[(2)]);
var state_12440__$1 = state_12440;
var statearr_12455_12481 = state_12440__$1;
(statearr_12455_12481[(2)] = inst_12426);

(statearr_12455_12481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12441 === (8))){
var inst_12423 = cljs.core.async.close_BANG_.call(null,to);
var state_12440__$1 = state_12440;
var statearr_12456_12482 = state_12440__$1;
(statearr_12456_12482[(2)] = inst_12423);

(statearr_12456_12482[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___12468))
;
return ((function (switch__12189__auto__,c__12301__auto___12468){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_12460 = [null,null,null,null,null,null,null,null];
(statearr_12460[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_12460[(1)] = (1));

return statearr_12460;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_12440){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12461){if((e12461 instanceof Object)){
var ex__12193__auto__ = e12461;
var statearr_12462_12483 = state_12440;
(statearr_12462_12483[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12440);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12461;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12484 = state_12440;
state_12440 = G__12484;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_12440){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_12440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___12468))
})();
var state__12303__auto__ = (function (){var statearr_12463 = f__12302__auto__.call(null);
(statearr_12463[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___12468);

return statearr_12463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___12468))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12672){
var vec__12673 = p__12672;
var v = cljs.core.nth.call(null,vec__12673,(0),null);
var p = cljs.core.nth.call(null,vec__12673,(1),null);
var job = vec__12673;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__12301__auto___12859 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___12859,res,vec__12673,v,p,job,jobs,results){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___12859,res,vec__12673,v,p,job,jobs,results){
return (function (state_12680){
var state_val_12681 = (state_12680[(1)]);
if((state_val_12681 === (1))){
var state_12680__$1 = state_12680;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12680__$1,(2),res,v);
} else {
if((state_val_12681 === (2))){
var inst_12677 = (state_12680[(2)]);
var inst_12678 = cljs.core.async.close_BANG_.call(null,res);
var state_12680__$1 = (function (){var statearr_12682 = state_12680;
(statearr_12682[(7)] = inst_12677);

return statearr_12682;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12680__$1,inst_12678);
} else {
return null;
}
}
});})(c__12301__auto___12859,res,vec__12673,v,p,job,jobs,results))
;
return ((function (switch__12189__auto__,c__12301__auto___12859,res,vec__12673,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_12686 = [null,null,null,null,null,null,null,null];
(statearr_12686[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_12686[(1)] = (1));

return statearr_12686;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_12680){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12687){if((e12687 instanceof Object)){
var ex__12193__auto__ = e12687;
var statearr_12688_12860 = state_12680;
(statearr_12688_12860[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12687;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12861 = state_12680;
state_12680 = G__12861;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_12680){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_12680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___12859,res,vec__12673,v,p,job,jobs,results))
})();
var state__12303__auto__ = (function (){var statearr_12689 = f__12302__auto__.call(null);
(statearr_12689[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___12859);

return statearr_12689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___12859,res,vec__12673,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12690){
var vec__12691 = p__12690;
var v = cljs.core.nth.call(null,vec__12691,(0),null);
var p = cljs.core.nth.call(null,vec__12691,(1),null);
var job = vec__12691;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___12862 = n;
var __12863 = (0);
while(true){
if((__12863 < n__7324__auto___12862)){
var G__12694_12864 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12694_12864) {
case "compute":
var c__12301__auto___12866 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12863,c__12301__auto___12866,G__12694_12864,n__7324__auto___12862,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (__12863,c__12301__auto___12866,G__12694_12864,n__7324__auto___12862,jobs,results,process,async){
return (function (state_12707){
var state_val_12708 = (state_12707[(1)]);
if((state_val_12708 === (1))){
var state_12707__$1 = state_12707;
var statearr_12709_12867 = state_12707__$1;
(statearr_12709_12867[(2)] = null);

(statearr_12709_12867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12708 === (2))){
var state_12707__$1 = state_12707;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12707__$1,(4),jobs);
} else {
if((state_val_12708 === (3))){
var inst_12705 = (state_12707[(2)]);
var state_12707__$1 = state_12707;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12707__$1,inst_12705);
} else {
if((state_val_12708 === (4))){
var inst_12697 = (state_12707[(2)]);
var inst_12698 = process.call(null,inst_12697);
var state_12707__$1 = state_12707;
if(cljs.core.truth_(inst_12698)){
var statearr_12710_12868 = state_12707__$1;
(statearr_12710_12868[(1)] = (5));

} else {
var statearr_12711_12869 = state_12707__$1;
(statearr_12711_12869[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12708 === (5))){
var state_12707__$1 = state_12707;
var statearr_12712_12870 = state_12707__$1;
(statearr_12712_12870[(2)] = null);

(statearr_12712_12870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12708 === (6))){
var state_12707__$1 = state_12707;
var statearr_12713_12871 = state_12707__$1;
(statearr_12713_12871[(2)] = null);

(statearr_12713_12871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12708 === (7))){
var inst_12703 = (state_12707[(2)]);
var state_12707__$1 = state_12707;
var statearr_12714_12872 = state_12707__$1;
(statearr_12714_12872[(2)] = inst_12703);

(statearr_12714_12872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12863,c__12301__auto___12866,G__12694_12864,n__7324__auto___12862,jobs,results,process,async))
;
return ((function (__12863,switch__12189__auto__,c__12301__auto___12866,G__12694_12864,n__7324__auto___12862,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_12718 = [null,null,null,null,null,null,null];
(statearr_12718[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_12718[(1)] = (1));

return statearr_12718;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_12707){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12707);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12719){if((e12719 instanceof Object)){
var ex__12193__auto__ = e12719;
var statearr_12720_12873 = state_12707;
(statearr_12720_12873[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12707);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12719;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12874 = state_12707;
state_12707 = G__12874;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_12707){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_12707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(__12863,switch__12189__auto__,c__12301__auto___12866,G__12694_12864,n__7324__auto___12862,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_12721 = f__12302__auto__.call(null);
(statearr_12721[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___12866);

return statearr_12721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(__12863,c__12301__auto___12866,G__12694_12864,n__7324__auto___12862,jobs,results,process,async))
);


break;
case "async":
var c__12301__auto___12875 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12863,c__12301__auto___12875,G__12694_12864,n__7324__auto___12862,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (__12863,c__12301__auto___12875,G__12694_12864,n__7324__auto___12862,jobs,results,process,async){
return (function (state_12734){
var state_val_12735 = (state_12734[(1)]);
if((state_val_12735 === (1))){
var state_12734__$1 = state_12734;
var statearr_12736_12876 = state_12734__$1;
(statearr_12736_12876[(2)] = null);

(statearr_12736_12876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (2))){
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12734__$1,(4),jobs);
} else {
if((state_val_12735 === (3))){
var inst_12732 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12734__$1,inst_12732);
} else {
if((state_val_12735 === (4))){
var inst_12724 = (state_12734[(2)]);
var inst_12725 = async.call(null,inst_12724);
var state_12734__$1 = state_12734;
if(cljs.core.truth_(inst_12725)){
var statearr_12737_12877 = state_12734__$1;
(statearr_12737_12877[(1)] = (5));

} else {
var statearr_12738_12878 = state_12734__$1;
(statearr_12738_12878[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (5))){
var state_12734__$1 = state_12734;
var statearr_12739_12879 = state_12734__$1;
(statearr_12739_12879[(2)] = null);

(statearr_12739_12879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (6))){
var state_12734__$1 = state_12734;
var statearr_12740_12880 = state_12734__$1;
(statearr_12740_12880[(2)] = null);

(statearr_12740_12880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12735 === (7))){
var inst_12730 = (state_12734[(2)]);
var state_12734__$1 = state_12734;
var statearr_12741_12881 = state_12734__$1;
(statearr_12741_12881[(2)] = inst_12730);

(statearr_12741_12881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12863,c__12301__auto___12875,G__12694_12864,n__7324__auto___12862,jobs,results,process,async))
;
return ((function (__12863,switch__12189__auto__,c__12301__auto___12875,G__12694_12864,n__7324__auto___12862,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_12745 = [null,null,null,null,null,null,null];
(statearr_12745[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_12745[(1)] = (1));

return statearr_12745;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_12734){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12746){if((e12746 instanceof Object)){
var ex__12193__auto__ = e12746;
var statearr_12747_12882 = state_12734;
(statearr_12747_12882[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12746;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12883 = state_12734;
state_12734 = G__12883;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_12734){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_12734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(__12863,switch__12189__auto__,c__12301__auto___12875,G__12694_12864,n__7324__auto___12862,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_12748 = f__12302__auto__.call(null);
(statearr_12748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___12875);

return statearr_12748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(__12863,c__12301__auto___12875,G__12694_12864,n__7324__auto___12862,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__12884 = (__12863 + (1));
__12863 = G__12884;
continue;
} else {
}
break;
}

var c__12301__auto___12885 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___12885,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___12885,jobs,results,process,async){
return (function (state_12770){
var state_val_12771 = (state_12770[(1)]);
if((state_val_12771 === (1))){
var state_12770__$1 = state_12770;
var statearr_12772_12886 = state_12770__$1;
(statearr_12772_12886[(2)] = null);

(statearr_12772_12886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12771 === (2))){
var state_12770__$1 = state_12770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12770__$1,(4),from);
} else {
if((state_val_12771 === (3))){
var inst_12768 = (state_12770[(2)]);
var state_12770__$1 = state_12770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12770__$1,inst_12768);
} else {
if((state_val_12771 === (4))){
var inst_12751 = (state_12770[(7)]);
var inst_12751__$1 = (state_12770[(2)]);
var inst_12752 = (inst_12751__$1 == null);
var state_12770__$1 = (function (){var statearr_12773 = state_12770;
(statearr_12773[(7)] = inst_12751__$1);

return statearr_12773;
})();
if(cljs.core.truth_(inst_12752)){
var statearr_12774_12887 = state_12770__$1;
(statearr_12774_12887[(1)] = (5));

} else {
var statearr_12775_12888 = state_12770__$1;
(statearr_12775_12888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12771 === (5))){
var inst_12754 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12770__$1 = state_12770;
var statearr_12776_12889 = state_12770__$1;
(statearr_12776_12889[(2)] = inst_12754);

(statearr_12776_12889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12771 === (6))){
var inst_12751 = (state_12770[(7)]);
var inst_12756 = (state_12770[(8)]);
var inst_12756__$1 = cljs.core.async.chan.call(null,(1));
var inst_12757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12758 = [inst_12751,inst_12756__$1];
var inst_12759 = (new cljs.core.PersistentVector(null,2,(5),inst_12757,inst_12758,null));
var state_12770__$1 = (function (){var statearr_12777 = state_12770;
(statearr_12777[(8)] = inst_12756__$1);

return statearr_12777;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12770__$1,(8),jobs,inst_12759);
} else {
if((state_val_12771 === (7))){
var inst_12766 = (state_12770[(2)]);
var state_12770__$1 = state_12770;
var statearr_12778_12890 = state_12770__$1;
(statearr_12778_12890[(2)] = inst_12766);

(statearr_12778_12890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12771 === (8))){
var inst_12756 = (state_12770[(8)]);
var inst_12761 = (state_12770[(2)]);
var state_12770__$1 = (function (){var statearr_12779 = state_12770;
(statearr_12779[(9)] = inst_12761);

return statearr_12779;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12770__$1,(9),results,inst_12756);
} else {
if((state_val_12771 === (9))){
var inst_12763 = (state_12770[(2)]);
var state_12770__$1 = (function (){var statearr_12780 = state_12770;
(statearr_12780[(10)] = inst_12763);

return statearr_12780;
})();
var statearr_12781_12891 = state_12770__$1;
(statearr_12781_12891[(2)] = null);

(statearr_12781_12891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___12885,jobs,results,process,async))
;
return ((function (switch__12189__auto__,c__12301__auto___12885,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_12785 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12785[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_12785[(1)] = (1));

return statearr_12785;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_12770){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12786){if((e12786 instanceof Object)){
var ex__12193__auto__ = e12786;
var statearr_12787_12892 = state_12770;
(statearr_12787_12892[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12786;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12893 = state_12770;
state_12770 = G__12893;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_12770){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_12770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___12885,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_12788 = f__12302__auto__.call(null);
(statearr_12788[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___12885);

return statearr_12788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___12885,jobs,results,process,async))
);


var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,jobs,results,process,async){
return (function (state_12826){
var state_val_12827 = (state_12826[(1)]);
if((state_val_12827 === (7))){
var inst_12822 = (state_12826[(2)]);
var state_12826__$1 = state_12826;
var statearr_12828_12894 = state_12826__$1;
(statearr_12828_12894[(2)] = inst_12822);

(statearr_12828_12894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (20))){
var state_12826__$1 = state_12826;
var statearr_12829_12895 = state_12826__$1;
(statearr_12829_12895[(2)] = null);

(statearr_12829_12895[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (1))){
var state_12826__$1 = state_12826;
var statearr_12830_12896 = state_12826__$1;
(statearr_12830_12896[(2)] = null);

(statearr_12830_12896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (4))){
var inst_12791 = (state_12826[(7)]);
var inst_12791__$1 = (state_12826[(2)]);
var inst_12792 = (inst_12791__$1 == null);
var state_12826__$1 = (function (){var statearr_12831 = state_12826;
(statearr_12831[(7)] = inst_12791__$1);

return statearr_12831;
})();
if(cljs.core.truth_(inst_12792)){
var statearr_12832_12897 = state_12826__$1;
(statearr_12832_12897[(1)] = (5));

} else {
var statearr_12833_12898 = state_12826__$1;
(statearr_12833_12898[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (15))){
var inst_12804 = (state_12826[(8)]);
var state_12826__$1 = state_12826;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12826__$1,(18),to,inst_12804);
} else {
if((state_val_12827 === (21))){
var inst_12817 = (state_12826[(2)]);
var state_12826__$1 = state_12826;
var statearr_12834_12899 = state_12826__$1;
(statearr_12834_12899[(2)] = inst_12817);

(statearr_12834_12899[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (13))){
var inst_12819 = (state_12826[(2)]);
var state_12826__$1 = (function (){var statearr_12835 = state_12826;
(statearr_12835[(9)] = inst_12819);

return statearr_12835;
})();
var statearr_12836_12900 = state_12826__$1;
(statearr_12836_12900[(2)] = null);

(statearr_12836_12900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (6))){
var inst_12791 = (state_12826[(7)]);
var state_12826__$1 = state_12826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12826__$1,(11),inst_12791);
} else {
if((state_val_12827 === (17))){
var inst_12812 = (state_12826[(2)]);
var state_12826__$1 = state_12826;
if(cljs.core.truth_(inst_12812)){
var statearr_12837_12901 = state_12826__$1;
(statearr_12837_12901[(1)] = (19));

} else {
var statearr_12838_12902 = state_12826__$1;
(statearr_12838_12902[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (3))){
var inst_12824 = (state_12826[(2)]);
var state_12826__$1 = state_12826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12826__$1,inst_12824);
} else {
if((state_val_12827 === (12))){
var inst_12801 = (state_12826[(10)]);
var state_12826__$1 = state_12826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12826__$1,(14),inst_12801);
} else {
if((state_val_12827 === (2))){
var state_12826__$1 = state_12826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12826__$1,(4),results);
} else {
if((state_val_12827 === (19))){
var state_12826__$1 = state_12826;
var statearr_12839_12903 = state_12826__$1;
(statearr_12839_12903[(2)] = null);

(statearr_12839_12903[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (11))){
var inst_12801 = (state_12826[(2)]);
var state_12826__$1 = (function (){var statearr_12840 = state_12826;
(statearr_12840[(10)] = inst_12801);

return statearr_12840;
})();
var statearr_12841_12904 = state_12826__$1;
(statearr_12841_12904[(2)] = null);

(statearr_12841_12904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (9))){
var state_12826__$1 = state_12826;
var statearr_12842_12905 = state_12826__$1;
(statearr_12842_12905[(2)] = null);

(statearr_12842_12905[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (5))){
var state_12826__$1 = state_12826;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12843_12906 = state_12826__$1;
(statearr_12843_12906[(1)] = (8));

} else {
var statearr_12844_12907 = state_12826__$1;
(statearr_12844_12907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (14))){
var inst_12806 = (state_12826[(11)]);
var inst_12804 = (state_12826[(8)]);
var inst_12804__$1 = (state_12826[(2)]);
var inst_12805 = (inst_12804__$1 == null);
var inst_12806__$1 = cljs.core.not.call(null,inst_12805);
var state_12826__$1 = (function (){var statearr_12845 = state_12826;
(statearr_12845[(11)] = inst_12806__$1);

(statearr_12845[(8)] = inst_12804__$1);

return statearr_12845;
})();
if(inst_12806__$1){
var statearr_12846_12908 = state_12826__$1;
(statearr_12846_12908[(1)] = (15));

} else {
var statearr_12847_12909 = state_12826__$1;
(statearr_12847_12909[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (16))){
var inst_12806 = (state_12826[(11)]);
var state_12826__$1 = state_12826;
var statearr_12848_12910 = state_12826__$1;
(statearr_12848_12910[(2)] = inst_12806);

(statearr_12848_12910[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (10))){
var inst_12798 = (state_12826[(2)]);
var state_12826__$1 = state_12826;
var statearr_12849_12911 = state_12826__$1;
(statearr_12849_12911[(2)] = inst_12798);

(statearr_12849_12911[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (18))){
var inst_12809 = (state_12826[(2)]);
var state_12826__$1 = state_12826;
var statearr_12850_12912 = state_12826__$1;
(statearr_12850_12912[(2)] = inst_12809);

(statearr_12850_12912[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12827 === (8))){
var inst_12795 = cljs.core.async.close_BANG_.call(null,to);
var state_12826__$1 = state_12826;
var statearr_12851_12913 = state_12826__$1;
(statearr_12851_12913[(2)] = inst_12795);

(statearr_12851_12913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__,jobs,results,process,async))
;
return ((function (switch__12189__auto__,c__12301__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_12855 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12855[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_12855[(1)] = (1));

return statearr_12855;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_12826){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12856){if((e12856 instanceof Object)){
var ex__12193__auto__ = e12856;
var statearr_12857_12914 = state_12826;
(statearr_12857_12914[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12856;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12915 = state_12826;
state_12826 = G__12915;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_12826){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_12826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_12858 = f__12302__auto__.call(null);
(statearr_12858[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_12858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__,jobs,results,process,async))
);

return c__12301__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12916 = [];
var len__7484__auto___12919 = arguments.length;
var i__7485__auto___12920 = (0);
while(true){
if((i__7485__auto___12920 < len__7484__auto___12919)){
args12916.push((arguments[i__7485__auto___12920]));

var G__12921 = (i__7485__auto___12920 + (1));
i__7485__auto___12920 = G__12921;
continue;
} else {
}
break;
}

var G__12918 = args12916.length;
switch (G__12918) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12916.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12923 = [];
var len__7484__auto___12926 = arguments.length;
var i__7485__auto___12927 = (0);
while(true){
if((i__7485__auto___12927 < len__7484__auto___12926)){
args12923.push((arguments[i__7485__auto___12927]));

var G__12928 = (i__7485__auto___12927 + (1));
i__7485__auto___12927 = G__12928;
continue;
} else {
}
break;
}

var G__12925 = args12923.length;
switch (G__12925) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12923.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12930 = [];
var len__7484__auto___12983 = arguments.length;
var i__7485__auto___12984 = (0);
while(true){
if((i__7485__auto___12984 < len__7484__auto___12983)){
args12930.push((arguments[i__7485__auto___12984]));

var G__12985 = (i__7485__auto___12984 + (1));
i__7485__auto___12984 = G__12985;
continue;
} else {
}
break;
}

var G__12932 = args12930.length;
switch (G__12932) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args12930.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__12301__auto___12987 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___12987,tc,fc){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___12987,tc,fc){
return (function (state_12958){
var state_val_12959 = (state_12958[(1)]);
if((state_val_12959 === (7))){
var inst_12954 = (state_12958[(2)]);
var state_12958__$1 = state_12958;
var statearr_12960_12988 = state_12958__$1;
(statearr_12960_12988[(2)] = inst_12954);

(statearr_12960_12988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (1))){
var state_12958__$1 = state_12958;
var statearr_12961_12989 = state_12958__$1;
(statearr_12961_12989[(2)] = null);

(statearr_12961_12989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (4))){
var inst_12935 = (state_12958[(7)]);
var inst_12935__$1 = (state_12958[(2)]);
var inst_12936 = (inst_12935__$1 == null);
var state_12958__$1 = (function (){var statearr_12962 = state_12958;
(statearr_12962[(7)] = inst_12935__$1);

return statearr_12962;
})();
if(cljs.core.truth_(inst_12936)){
var statearr_12963_12990 = state_12958__$1;
(statearr_12963_12990[(1)] = (5));

} else {
var statearr_12964_12991 = state_12958__$1;
(statearr_12964_12991[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (13))){
var state_12958__$1 = state_12958;
var statearr_12965_12992 = state_12958__$1;
(statearr_12965_12992[(2)] = null);

(statearr_12965_12992[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (6))){
var inst_12935 = (state_12958[(7)]);
var inst_12941 = p.call(null,inst_12935);
var state_12958__$1 = state_12958;
if(cljs.core.truth_(inst_12941)){
var statearr_12966_12993 = state_12958__$1;
(statearr_12966_12993[(1)] = (9));

} else {
var statearr_12967_12994 = state_12958__$1;
(statearr_12967_12994[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (3))){
var inst_12956 = (state_12958[(2)]);
var state_12958__$1 = state_12958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12958__$1,inst_12956);
} else {
if((state_val_12959 === (12))){
var state_12958__$1 = state_12958;
var statearr_12968_12995 = state_12958__$1;
(statearr_12968_12995[(2)] = null);

(statearr_12968_12995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (2))){
var state_12958__$1 = state_12958;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12958__$1,(4),ch);
} else {
if((state_val_12959 === (11))){
var inst_12935 = (state_12958[(7)]);
var inst_12945 = (state_12958[(2)]);
var state_12958__$1 = state_12958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12958__$1,(8),inst_12945,inst_12935);
} else {
if((state_val_12959 === (9))){
var state_12958__$1 = state_12958;
var statearr_12969_12996 = state_12958__$1;
(statearr_12969_12996[(2)] = tc);

(statearr_12969_12996[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (5))){
var inst_12938 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12939 = cljs.core.async.close_BANG_.call(null,fc);
var state_12958__$1 = (function (){var statearr_12970 = state_12958;
(statearr_12970[(8)] = inst_12938);

return statearr_12970;
})();
var statearr_12971_12997 = state_12958__$1;
(statearr_12971_12997[(2)] = inst_12939);

(statearr_12971_12997[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (14))){
var inst_12952 = (state_12958[(2)]);
var state_12958__$1 = state_12958;
var statearr_12972_12998 = state_12958__$1;
(statearr_12972_12998[(2)] = inst_12952);

(statearr_12972_12998[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (10))){
var state_12958__$1 = state_12958;
var statearr_12973_12999 = state_12958__$1;
(statearr_12973_12999[(2)] = fc);

(statearr_12973_12999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12959 === (8))){
var inst_12947 = (state_12958[(2)]);
var state_12958__$1 = state_12958;
if(cljs.core.truth_(inst_12947)){
var statearr_12974_13000 = state_12958__$1;
(statearr_12974_13000[(1)] = (12));

} else {
var statearr_12975_13001 = state_12958__$1;
(statearr_12975_13001[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___12987,tc,fc))
;
return ((function (switch__12189__auto__,c__12301__auto___12987,tc,fc){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_12979 = [null,null,null,null,null,null,null,null,null];
(statearr_12979[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_12979[(1)] = (1));

return statearr_12979;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_12958){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_12958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e12980){if((e12980 instanceof Object)){
var ex__12193__auto__ = e12980;
var statearr_12981_13002 = state_12958;
(statearr_12981_13002[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12980;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13003 = state_12958;
state_12958 = G__13003;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_12958){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_12958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___12987,tc,fc))
})();
var state__12303__auto__ = (function (){var statearr_12982 = f__12302__auto__.call(null);
(statearr_12982[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___12987);

return statearr_12982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___12987,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_13067){
var state_val_13068 = (state_13067[(1)]);
if((state_val_13068 === (7))){
var inst_13063 = (state_13067[(2)]);
var state_13067__$1 = state_13067;
var statearr_13069_13090 = state_13067__$1;
(statearr_13069_13090[(2)] = inst_13063);

(statearr_13069_13090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (1))){
var inst_13047 = init;
var state_13067__$1 = (function (){var statearr_13070 = state_13067;
(statearr_13070[(7)] = inst_13047);

return statearr_13070;
})();
var statearr_13071_13091 = state_13067__$1;
(statearr_13071_13091[(2)] = null);

(statearr_13071_13091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (4))){
var inst_13050 = (state_13067[(8)]);
var inst_13050__$1 = (state_13067[(2)]);
var inst_13051 = (inst_13050__$1 == null);
var state_13067__$1 = (function (){var statearr_13072 = state_13067;
(statearr_13072[(8)] = inst_13050__$1);

return statearr_13072;
})();
if(cljs.core.truth_(inst_13051)){
var statearr_13073_13092 = state_13067__$1;
(statearr_13073_13092[(1)] = (5));

} else {
var statearr_13074_13093 = state_13067__$1;
(statearr_13074_13093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (6))){
var inst_13050 = (state_13067[(8)]);
var inst_13047 = (state_13067[(7)]);
var inst_13054 = (state_13067[(9)]);
var inst_13054__$1 = f.call(null,inst_13047,inst_13050);
var inst_13055 = cljs.core.reduced_QMARK_.call(null,inst_13054__$1);
var state_13067__$1 = (function (){var statearr_13075 = state_13067;
(statearr_13075[(9)] = inst_13054__$1);

return statearr_13075;
})();
if(inst_13055){
var statearr_13076_13094 = state_13067__$1;
(statearr_13076_13094[(1)] = (8));

} else {
var statearr_13077_13095 = state_13067__$1;
(statearr_13077_13095[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (3))){
var inst_13065 = (state_13067[(2)]);
var state_13067__$1 = state_13067;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13067__$1,inst_13065);
} else {
if((state_val_13068 === (2))){
var state_13067__$1 = state_13067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13067__$1,(4),ch);
} else {
if((state_val_13068 === (9))){
var inst_13054 = (state_13067[(9)]);
var inst_13047 = inst_13054;
var state_13067__$1 = (function (){var statearr_13078 = state_13067;
(statearr_13078[(7)] = inst_13047);

return statearr_13078;
})();
var statearr_13079_13096 = state_13067__$1;
(statearr_13079_13096[(2)] = null);

(statearr_13079_13096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (5))){
var inst_13047 = (state_13067[(7)]);
var state_13067__$1 = state_13067;
var statearr_13080_13097 = state_13067__$1;
(statearr_13080_13097[(2)] = inst_13047);

(statearr_13080_13097[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (10))){
var inst_13061 = (state_13067[(2)]);
var state_13067__$1 = state_13067;
var statearr_13081_13098 = state_13067__$1;
(statearr_13081_13098[(2)] = inst_13061);

(statearr_13081_13098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13068 === (8))){
var inst_13054 = (state_13067[(9)]);
var inst_13057 = cljs.core.deref.call(null,inst_13054);
var state_13067__$1 = state_13067;
var statearr_13082_13099 = state_13067__$1;
(statearr_13082_13099[(2)] = inst_13057);

(statearr_13082_13099[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12190__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12190__auto____0 = (function (){
var statearr_13086 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13086[(0)] = cljs$core$async$reduce_$_state_machine__12190__auto__);

(statearr_13086[(1)] = (1));

return statearr_13086;
});
var cljs$core$async$reduce_$_state_machine__12190__auto____1 = (function (state_13067){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_13067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e13087){if((e13087 instanceof Object)){
var ex__12193__auto__ = e13087;
var statearr_13088_13100 = state_13067;
(statearr_13088_13100[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13067);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13087;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13101 = state_13067;
state_13067 = G__13101;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12190__auto__ = function(state_13067){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12190__auto____1.call(this,state_13067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12190__auto____0;
cljs$core$async$reduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12190__auto____1;
return cljs$core$async$reduce_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_13089 = f__12302__auto__.call(null);
(statearr_13089[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_13089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__,f__$1){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,f__$1){
return (function (state_13121){
var state_val_13122 = (state_13121[(1)]);
if((state_val_13122 === (1))){
var inst_13116 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_13121__$1 = state_13121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13121__$1,(2),inst_13116);
} else {
if((state_val_13122 === (2))){
var inst_13118 = (state_13121[(2)]);
var inst_13119 = f__$1.call(null,inst_13118);
var state_13121__$1 = state_13121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13121__$1,inst_13119);
} else {
return null;
}
}
});})(c__12301__auto__,f__$1))
;
return ((function (switch__12189__auto__,c__12301__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12190__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12190__auto____0 = (function (){
var statearr_13126 = [null,null,null,null,null,null,null];
(statearr_13126[(0)] = cljs$core$async$transduce_$_state_machine__12190__auto__);

(statearr_13126[(1)] = (1));

return statearr_13126;
});
var cljs$core$async$transduce_$_state_machine__12190__auto____1 = (function (state_13121){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_13121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e13127){if((e13127 instanceof Object)){
var ex__12193__auto__ = e13127;
var statearr_13128_13130 = state_13121;
(statearr_13128_13130[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13121);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13127;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13131 = state_13121;
state_13121 = G__13131;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12190__auto__ = function(state_13121){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12190__auto____1.call(this,state_13121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12190__auto____0;
cljs$core$async$transduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12190__auto____1;
return cljs$core$async$transduce_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,f__$1))
})();
var state__12303__auto__ = (function (){var statearr_13129 = f__12302__auto__.call(null);
(statearr_13129[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_13129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__,f__$1))
);

return c__12301__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args13132 = [];
var len__7484__auto___13184 = arguments.length;
var i__7485__auto___13185 = (0);
while(true){
if((i__7485__auto___13185 < len__7484__auto___13184)){
args13132.push((arguments[i__7485__auto___13185]));

var G__13186 = (i__7485__auto___13185 + (1));
i__7485__auto___13185 = G__13186;
continue;
} else {
}
break;
}

var G__13134 = args13132.length;
switch (G__13134) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13132.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_13159){
var state_val_13160 = (state_13159[(1)]);
if((state_val_13160 === (7))){
var inst_13141 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
var statearr_13161_13188 = state_13159__$1;
(statearr_13161_13188[(2)] = inst_13141);

(statearr_13161_13188[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (1))){
var inst_13135 = cljs.core.seq.call(null,coll);
var inst_13136 = inst_13135;
var state_13159__$1 = (function (){var statearr_13162 = state_13159;
(statearr_13162[(7)] = inst_13136);

return statearr_13162;
})();
var statearr_13163_13189 = state_13159__$1;
(statearr_13163_13189[(2)] = null);

(statearr_13163_13189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (4))){
var inst_13136 = (state_13159[(7)]);
var inst_13139 = cljs.core.first.call(null,inst_13136);
var state_13159__$1 = state_13159;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13159__$1,(7),ch,inst_13139);
} else {
if((state_val_13160 === (13))){
var inst_13153 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
var statearr_13164_13190 = state_13159__$1;
(statearr_13164_13190[(2)] = inst_13153);

(statearr_13164_13190[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (6))){
var inst_13144 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
if(cljs.core.truth_(inst_13144)){
var statearr_13165_13191 = state_13159__$1;
(statearr_13165_13191[(1)] = (8));

} else {
var statearr_13166_13192 = state_13159__$1;
(statearr_13166_13192[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (3))){
var inst_13157 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13159__$1,inst_13157);
} else {
if((state_val_13160 === (12))){
var state_13159__$1 = state_13159;
var statearr_13167_13193 = state_13159__$1;
(statearr_13167_13193[(2)] = null);

(statearr_13167_13193[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (2))){
var inst_13136 = (state_13159[(7)]);
var state_13159__$1 = state_13159;
if(cljs.core.truth_(inst_13136)){
var statearr_13168_13194 = state_13159__$1;
(statearr_13168_13194[(1)] = (4));

} else {
var statearr_13169_13195 = state_13159__$1;
(statearr_13169_13195[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (11))){
var inst_13150 = cljs.core.async.close_BANG_.call(null,ch);
var state_13159__$1 = state_13159;
var statearr_13170_13196 = state_13159__$1;
(statearr_13170_13196[(2)] = inst_13150);

(statearr_13170_13196[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (9))){
var state_13159__$1 = state_13159;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13171_13197 = state_13159__$1;
(statearr_13171_13197[(1)] = (11));

} else {
var statearr_13172_13198 = state_13159__$1;
(statearr_13172_13198[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (5))){
var inst_13136 = (state_13159[(7)]);
var state_13159__$1 = state_13159;
var statearr_13173_13199 = state_13159__$1;
(statearr_13173_13199[(2)] = inst_13136);

(statearr_13173_13199[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (10))){
var inst_13155 = (state_13159[(2)]);
var state_13159__$1 = state_13159;
var statearr_13174_13200 = state_13159__$1;
(statearr_13174_13200[(2)] = inst_13155);

(statearr_13174_13200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13160 === (8))){
var inst_13136 = (state_13159[(7)]);
var inst_13146 = cljs.core.next.call(null,inst_13136);
var inst_13136__$1 = inst_13146;
var state_13159__$1 = (function (){var statearr_13175 = state_13159;
(statearr_13175[(7)] = inst_13136__$1);

return statearr_13175;
})();
var statearr_13176_13201 = state_13159__$1;
(statearr_13176_13201[(2)] = null);

(statearr_13176_13201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_13180 = [null,null,null,null,null,null,null,null];
(statearr_13180[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_13180[(1)] = (1));

return statearr_13180;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_13159){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_13159);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e13181){if((e13181 instanceof Object)){
var ex__12193__auto__ = e13181;
var statearr_13182_13202 = state_13159;
(statearr_13182_13202[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13159);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13181;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13203 = state_13159;
state_13159 = G__13203;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_13159){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_13159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_13183 = f__12302__auto__.call(null);
(statearr_13183[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_13183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13429 = (function (mult,ch,cs,meta13430){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta13430 = meta13430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_13431,meta13430__$1){
var self__ = this;
var _13431__$1 = this;
return (new cljs.core.async.t_cljs$core$async13429(self__.mult,self__.ch,self__.cs,meta13430__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_13431){
var self__ = this;
var _13431__$1 = this;
return self__.meta13430;
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13430","meta13430",-834389870,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async13429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13429";

cljs.core.async.t_cljs$core$async13429.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13429");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async13429 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async13429(mult__$1,ch__$1,cs__$1,meta13430){
return (new cljs.core.async.t_cljs$core$async13429(mult__$1,ch__$1,cs__$1,meta13430));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async13429(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12301__auto___13654 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___13654,cs,m,dchan,dctr,done){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___13654,cs,m,dchan,dctr,done){
return (function (state_13566){
var state_val_13567 = (state_13566[(1)]);
if((state_val_13567 === (7))){
var inst_13562 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13568_13655 = state_13566__$1;
(statearr_13568_13655[(2)] = inst_13562);

(statearr_13568_13655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (20))){
var inst_13465 = (state_13566[(7)]);
var inst_13477 = cljs.core.first.call(null,inst_13465);
var inst_13478 = cljs.core.nth.call(null,inst_13477,(0),null);
var inst_13479 = cljs.core.nth.call(null,inst_13477,(1),null);
var state_13566__$1 = (function (){var statearr_13569 = state_13566;
(statearr_13569[(8)] = inst_13478);

return statearr_13569;
})();
if(cljs.core.truth_(inst_13479)){
var statearr_13570_13656 = state_13566__$1;
(statearr_13570_13656[(1)] = (22));

} else {
var statearr_13571_13657 = state_13566__$1;
(statearr_13571_13657[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (27))){
var inst_13509 = (state_13566[(9)]);
var inst_13434 = (state_13566[(10)]);
var inst_13507 = (state_13566[(11)]);
var inst_13514 = (state_13566[(12)]);
var inst_13514__$1 = cljs.core._nth.call(null,inst_13507,inst_13509);
var inst_13515 = cljs.core.async.put_BANG_.call(null,inst_13514__$1,inst_13434,done);
var state_13566__$1 = (function (){var statearr_13572 = state_13566;
(statearr_13572[(12)] = inst_13514__$1);

return statearr_13572;
})();
if(cljs.core.truth_(inst_13515)){
var statearr_13573_13658 = state_13566__$1;
(statearr_13573_13658[(1)] = (30));

} else {
var statearr_13574_13659 = state_13566__$1;
(statearr_13574_13659[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (1))){
var state_13566__$1 = state_13566;
var statearr_13575_13660 = state_13566__$1;
(statearr_13575_13660[(2)] = null);

(statearr_13575_13660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (24))){
var inst_13465 = (state_13566[(7)]);
var inst_13484 = (state_13566[(2)]);
var inst_13485 = cljs.core.next.call(null,inst_13465);
var inst_13443 = inst_13485;
var inst_13444 = null;
var inst_13445 = (0);
var inst_13446 = (0);
var state_13566__$1 = (function (){var statearr_13576 = state_13566;
(statearr_13576[(13)] = inst_13484);

(statearr_13576[(14)] = inst_13444);

(statearr_13576[(15)] = inst_13443);

(statearr_13576[(16)] = inst_13446);

(statearr_13576[(17)] = inst_13445);

return statearr_13576;
})();
var statearr_13577_13661 = state_13566__$1;
(statearr_13577_13661[(2)] = null);

(statearr_13577_13661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (39))){
var state_13566__$1 = state_13566;
var statearr_13581_13662 = state_13566__$1;
(statearr_13581_13662[(2)] = null);

(statearr_13581_13662[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (4))){
var inst_13434 = (state_13566[(10)]);
var inst_13434__$1 = (state_13566[(2)]);
var inst_13435 = (inst_13434__$1 == null);
var state_13566__$1 = (function (){var statearr_13582 = state_13566;
(statearr_13582[(10)] = inst_13434__$1);

return statearr_13582;
})();
if(cljs.core.truth_(inst_13435)){
var statearr_13583_13663 = state_13566__$1;
(statearr_13583_13663[(1)] = (5));

} else {
var statearr_13584_13664 = state_13566__$1;
(statearr_13584_13664[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (15))){
var inst_13444 = (state_13566[(14)]);
var inst_13443 = (state_13566[(15)]);
var inst_13446 = (state_13566[(16)]);
var inst_13445 = (state_13566[(17)]);
var inst_13461 = (state_13566[(2)]);
var inst_13462 = (inst_13446 + (1));
var tmp13578 = inst_13444;
var tmp13579 = inst_13443;
var tmp13580 = inst_13445;
var inst_13443__$1 = tmp13579;
var inst_13444__$1 = tmp13578;
var inst_13445__$1 = tmp13580;
var inst_13446__$1 = inst_13462;
var state_13566__$1 = (function (){var statearr_13585 = state_13566;
(statearr_13585[(14)] = inst_13444__$1);

(statearr_13585[(15)] = inst_13443__$1);

(statearr_13585[(16)] = inst_13446__$1);

(statearr_13585[(18)] = inst_13461);

(statearr_13585[(17)] = inst_13445__$1);

return statearr_13585;
})();
var statearr_13586_13665 = state_13566__$1;
(statearr_13586_13665[(2)] = null);

(statearr_13586_13665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (21))){
var inst_13488 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13590_13666 = state_13566__$1;
(statearr_13590_13666[(2)] = inst_13488);

(statearr_13590_13666[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (31))){
var inst_13514 = (state_13566[(12)]);
var inst_13518 = done.call(null,null);
var inst_13519 = cljs.core.async.untap_STAR_.call(null,m,inst_13514);
var state_13566__$1 = (function (){var statearr_13591 = state_13566;
(statearr_13591[(19)] = inst_13518);

return statearr_13591;
})();
var statearr_13592_13667 = state_13566__$1;
(statearr_13592_13667[(2)] = inst_13519);

(statearr_13592_13667[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (32))){
var inst_13509 = (state_13566[(9)]);
var inst_13508 = (state_13566[(20)]);
var inst_13507 = (state_13566[(11)]);
var inst_13506 = (state_13566[(21)]);
var inst_13521 = (state_13566[(2)]);
var inst_13522 = (inst_13509 + (1));
var tmp13587 = inst_13508;
var tmp13588 = inst_13507;
var tmp13589 = inst_13506;
var inst_13506__$1 = tmp13589;
var inst_13507__$1 = tmp13588;
var inst_13508__$1 = tmp13587;
var inst_13509__$1 = inst_13522;
var state_13566__$1 = (function (){var statearr_13593 = state_13566;
(statearr_13593[(9)] = inst_13509__$1);

(statearr_13593[(20)] = inst_13508__$1);

(statearr_13593[(11)] = inst_13507__$1);

(statearr_13593[(21)] = inst_13506__$1);

(statearr_13593[(22)] = inst_13521);

return statearr_13593;
})();
var statearr_13594_13668 = state_13566__$1;
(statearr_13594_13668[(2)] = null);

(statearr_13594_13668[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (40))){
var inst_13534 = (state_13566[(23)]);
var inst_13538 = done.call(null,null);
var inst_13539 = cljs.core.async.untap_STAR_.call(null,m,inst_13534);
var state_13566__$1 = (function (){var statearr_13595 = state_13566;
(statearr_13595[(24)] = inst_13538);

return statearr_13595;
})();
var statearr_13596_13669 = state_13566__$1;
(statearr_13596_13669[(2)] = inst_13539);

(statearr_13596_13669[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (33))){
var inst_13525 = (state_13566[(25)]);
var inst_13527 = cljs.core.chunked_seq_QMARK_.call(null,inst_13525);
var state_13566__$1 = state_13566;
if(inst_13527){
var statearr_13597_13670 = state_13566__$1;
(statearr_13597_13670[(1)] = (36));

} else {
var statearr_13598_13671 = state_13566__$1;
(statearr_13598_13671[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (13))){
var inst_13455 = (state_13566[(26)]);
var inst_13458 = cljs.core.async.close_BANG_.call(null,inst_13455);
var state_13566__$1 = state_13566;
var statearr_13599_13672 = state_13566__$1;
(statearr_13599_13672[(2)] = inst_13458);

(statearr_13599_13672[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (22))){
var inst_13478 = (state_13566[(8)]);
var inst_13481 = cljs.core.async.close_BANG_.call(null,inst_13478);
var state_13566__$1 = state_13566;
var statearr_13600_13673 = state_13566__$1;
(statearr_13600_13673[(2)] = inst_13481);

(statearr_13600_13673[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (36))){
var inst_13525 = (state_13566[(25)]);
var inst_13529 = cljs.core.chunk_first.call(null,inst_13525);
var inst_13530 = cljs.core.chunk_rest.call(null,inst_13525);
var inst_13531 = cljs.core.count.call(null,inst_13529);
var inst_13506 = inst_13530;
var inst_13507 = inst_13529;
var inst_13508 = inst_13531;
var inst_13509 = (0);
var state_13566__$1 = (function (){var statearr_13601 = state_13566;
(statearr_13601[(9)] = inst_13509);

(statearr_13601[(20)] = inst_13508);

(statearr_13601[(11)] = inst_13507);

(statearr_13601[(21)] = inst_13506);

return statearr_13601;
})();
var statearr_13602_13674 = state_13566__$1;
(statearr_13602_13674[(2)] = null);

(statearr_13602_13674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (41))){
var inst_13525 = (state_13566[(25)]);
var inst_13541 = (state_13566[(2)]);
var inst_13542 = cljs.core.next.call(null,inst_13525);
var inst_13506 = inst_13542;
var inst_13507 = null;
var inst_13508 = (0);
var inst_13509 = (0);
var state_13566__$1 = (function (){var statearr_13603 = state_13566;
(statearr_13603[(9)] = inst_13509);

(statearr_13603[(20)] = inst_13508);

(statearr_13603[(11)] = inst_13507);

(statearr_13603[(21)] = inst_13506);

(statearr_13603[(27)] = inst_13541);

return statearr_13603;
})();
var statearr_13604_13675 = state_13566__$1;
(statearr_13604_13675[(2)] = null);

(statearr_13604_13675[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (43))){
var state_13566__$1 = state_13566;
var statearr_13605_13676 = state_13566__$1;
(statearr_13605_13676[(2)] = null);

(statearr_13605_13676[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (29))){
var inst_13550 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13606_13677 = state_13566__$1;
(statearr_13606_13677[(2)] = inst_13550);

(statearr_13606_13677[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (44))){
var inst_13559 = (state_13566[(2)]);
var state_13566__$1 = (function (){var statearr_13607 = state_13566;
(statearr_13607[(28)] = inst_13559);

return statearr_13607;
})();
var statearr_13608_13678 = state_13566__$1;
(statearr_13608_13678[(2)] = null);

(statearr_13608_13678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (6))){
var inst_13498 = (state_13566[(29)]);
var inst_13497 = cljs.core.deref.call(null,cs);
var inst_13498__$1 = cljs.core.keys.call(null,inst_13497);
var inst_13499 = cljs.core.count.call(null,inst_13498__$1);
var inst_13500 = cljs.core.reset_BANG_.call(null,dctr,inst_13499);
var inst_13505 = cljs.core.seq.call(null,inst_13498__$1);
var inst_13506 = inst_13505;
var inst_13507 = null;
var inst_13508 = (0);
var inst_13509 = (0);
var state_13566__$1 = (function (){var statearr_13609 = state_13566;
(statearr_13609[(9)] = inst_13509);

(statearr_13609[(20)] = inst_13508);

(statearr_13609[(11)] = inst_13507);

(statearr_13609[(29)] = inst_13498__$1);

(statearr_13609[(21)] = inst_13506);

(statearr_13609[(30)] = inst_13500);

return statearr_13609;
})();
var statearr_13610_13679 = state_13566__$1;
(statearr_13610_13679[(2)] = null);

(statearr_13610_13679[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (28))){
var inst_13506 = (state_13566[(21)]);
var inst_13525 = (state_13566[(25)]);
var inst_13525__$1 = cljs.core.seq.call(null,inst_13506);
var state_13566__$1 = (function (){var statearr_13611 = state_13566;
(statearr_13611[(25)] = inst_13525__$1);

return statearr_13611;
})();
if(inst_13525__$1){
var statearr_13612_13680 = state_13566__$1;
(statearr_13612_13680[(1)] = (33));

} else {
var statearr_13613_13681 = state_13566__$1;
(statearr_13613_13681[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (25))){
var inst_13509 = (state_13566[(9)]);
var inst_13508 = (state_13566[(20)]);
var inst_13511 = (inst_13509 < inst_13508);
var inst_13512 = inst_13511;
var state_13566__$1 = state_13566;
if(cljs.core.truth_(inst_13512)){
var statearr_13614_13682 = state_13566__$1;
(statearr_13614_13682[(1)] = (27));

} else {
var statearr_13615_13683 = state_13566__$1;
(statearr_13615_13683[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (34))){
var state_13566__$1 = state_13566;
var statearr_13616_13684 = state_13566__$1;
(statearr_13616_13684[(2)] = null);

(statearr_13616_13684[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (17))){
var state_13566__$1 = state_13566;
var statearr_13617_13685 = state_13566__$1;
(statearr_13617_13685[(2)] = null);

(statearr_13617_13685[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (3))){
var inst_13564 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13566__$1,inst_13564);
} else {
if((state_val_13567 === (12))){
var inst_13493 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13618_13686 = state_13566__$1;
(statearr_13618_13686[(2)] = inst_13493);

(statearr_13618_13686[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (2))){
var state_13566__$1 = state_13566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13566__$1,(4),ch);
} else {
if((state_val_13567 === (23))){
var state_13566__$1 = state_13566;
var statearr_13619_13687 = state_13566__$1;
(statearr_13619_13687[(2)] = null);

(statearr_13619_13687[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (35))){
var inst_13548 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13620_13688 = state_13566__$1;
(statearr_13620_13688[(2)] = inst_13548);

(statearr_13620_13688[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (19))){
var inst_13465 = (state_13566[(7)]);
var inst_13469 = cljs.core.chunk_first.call(null,inst_13465);
var inst_13470 = cljs.core.chunk_rest.call(null,inst_13465);
var inst_13471 = cljs.core.count.call(null,inst_13469);
var inst_13443 = inst_13470;
var inst_13444 = inst_13469;
var inst_13445 = inst_13471;
var inst_13446 = (0);
var state_13566__$1 = (function (){var statearr_13621 = state_13566;
(statearr_13621[(14)] = inst_13444);

(statearr_13621[(15)] = inst_13443);

(statearr_13621[(16)] = inst_13446);

(statearr_13621[(17)] = inst_13445);

return statearr_13621;
})();
var statearr_13622_13689 = state_13566__$1;
(statearr_13622_13689[(2)] = null);

(statearr_13622_13689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (11))){
var inst_13465 = (state_13566[(7)]);
var inst_13443 = (state_13566[(15)]);
var inst_13465__$1 = cljs.core.seq.call(null,inst_13443);
var state_13566__$1 = (function (){var statearr_13623 = state_13566;
(statearr_13623[(7)] = inst_13465__$1);

return statearr_13623;
})();
if(inst_13465__$1){
var statearr_13624_13690 = state_13566__$1;
(statearr_13624_13690[(1)] = (16));

} else {
var statearr_13625_13691 = state_13566__$1;
(statearr_13625_13691[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (9))){
var inst_13495 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13626_13692 = state_13566__$1;
(statearr_13626_13692[(2)] = inst_13495);

(statearr_13626_13692[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (5))){
var inst_13441 = cljs.core.deref.call(null,cs);
var inst_13442 = cljs.core.seq.call(null,inst_13441);
var inst_13443 = inst_13442;
var inst_13444 = null;
var inst_13445 = (0);
var inst_13446 = (0);
var state_13566__$1 = (function (){var statearr_13627 = state_13566;
(statearr_13627[(14)] = inst_13444);

(statearr_13627[(15)] = inst_13443);

(statearr_13627[(16)] = inst_13446);

(statearr_13627[(17)] = inst_13445);

return statearr_13627;
})();
var statearr_13628_13693 = state_13566__$1;
(statearr_13628_13693[(2)] = null);

(statearr_13628_13693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (14))){
var state_13566__$1 = state_13566;
var statearr_13629_13694 = state_13566__$1;
(statearr_13629_13694[(2)] = null);

(statearr_13629_13694[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (45))){
var inst_13556 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13630_13695 = state_13566__$1;
(statearr_13630_13695[(2)] = inst_13556);

(statearr_13630_13695[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (26))){
var inst_13498 = (state_13566[(29)]);
var inst_13552 = (state_13566[(2)]);
var inst_13553 = cljs.core.seq.call(null,inst_13498);
var state_13566__$1 = (function (){var statearr_13631 = state_13566;
(statearr_13631[(31)] = inst_13552);

return statearr_13631;
})();
if(inst_13553){
var statearr_13632_13696 = state_13566__$1;
(statearr_13632_13696[(1)] = (42));

} else {
var statearr_13633_13697 = state_13566__$1;
(statearr_13633_13697[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (16))){
var inst_13465 = (state_13566[(7)]);
var inst_13467 = cljs.core.chunked_seq_QMARK_.call(null,inst_13465);
var state_13566__$1 = state_13566;
if(inst_13467){
var statearr_13634_13698 = state_13566__$1;
(statearr_13634_13698[(1)] = (19));

} else {
var statearr_13635_13699 = state_13566__$1;
(statearr_13635_13699[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (38))){
var inst_13545 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13636_13700 = state_13566__$1;
(statearr_13636_13700[(2)] = inst_13545);

(statearr_13636_13700[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (30))){
var state_13566__$1 = state_13566;
var statearr_13637_13701 = state_13566__$1;
(statearr_13637_13701[(2)] = null);

(statearr_13637_13701[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (10))){
var inst_13444 = (state_13566[(14)]);
var inst_13446 = (state_13566[(16)]);
var inst_13454 = cljs.core._nth.call(null,inst_13444,inst_13446);
var inst_13455 = cljs.core.nth.call(null,inst_13454,(0),null);
var inst_13456 = cljs.core.nth.call(null,inst_13454,(1),null);
var state_13566__$1 = (function (){var statearr_13638 = state_13566;
(statearr_13638[(26)] = inst_13455);

return statearr_13638;
})();
if(cljs.core.truth_(inst_13456)){
var statearr_13639_13702 = state_13566__$1;
(statearr_13639_13702[(1)] = (13));

} else {
var statearr_13640_13703 = state_13566__$1;
(statearr_13640_13703[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (18))){
var inst_13491 = (state_13566[(2)]);
var state_13566__$1 = state_13566;
var statearr_13641_13704 = state_13566__$1;
(statearr_13641_13704[(2)] = inst_13491);

(statearr_13641_13704[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (42))){
var state_13566__$1 = state_13566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13566__$1,(45),dchan);
} else {
if((state_val_13567 === (37))){
var inst_13434 = (state_13566[(10)]);
var inst_13534 = (state_13566[(23)]);
var inst_13525 = (state_13566[(25)]);
var inst_13534__$1 = cljs.core.first.call(null,inst_13525);
var inst_13535 = cljs.core.async.put_BANG_.call(null,inst_13534__$1,inst_13434,done);
var state_13566__$1 = (function (){var statearr_13642 = state_13566;
(statearr_13642[(23)] = inst_13534__$1);

return statearr_13642;
})();
if(cljs.core.truth_(inst_13535)){
var statearr_13643_13705 = state_13566__$1;
(statearr_13643_13705[(1)] = (39));

} else {
var statearr_13644_13706 = state_13566__$1;
(statearr_13644_13706[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13567 === (8))){
var inst_13446 = (state_13566[(16)]);
var inst_13445 = (state_13566[(17)]);
var inst_13448 = (inst_13446 < inst_13445);
var inst_13449 = inst_13448;
var state_13566__$1 = state_13566;
if(cljs.core.truth_(inst_13449)){
var statearr_13645_13707 = state_13566__$1;
(statearr_13645_13707[(1)] = (10));

} else {
var statearr_13646_13708 = state_13566__$1;
(statearr_13646_13708[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___13654,cs,m,dchan,dctr,done))
;
return ((function (switch__12189__auto__,c__12301__auto___13654,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12190__auto__ = null;
var cljs$core$async$mult_$_state_machine__12190__auto____0 = (function (){
var statearr_13650 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13650[(0)] = cljs$core$async$mult_$_state_machine__12190__auto__);

(statearr_13650[(1)] = (1));

return statearr_13650;
});
var cljs$core$async$mult_$_state_machine__12190__auto____1 = (function (state_13566){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_13566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e13651){if((e13651 instanceof Object)){
var ex__12193__auto__ = e13651;
var statearr_13652_13709 = state_13566;
(statearr_13652_13709[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13566);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13710 = state_13566;
state_13566 = G__13710;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12190__auto__ = function(state_13566){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12190__auto____1.call(this,state_13566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12190__auto____0;
cljs$core$async$mult_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12190__auto____1;
return cljs$core$async$mult_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___13654,cs,m,dchan,dctr,done))
})();
var state__12303__auto__ = (function (){var statearr_13653 = f__12302__auto__.call(null);
(statearr_13653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___13654);

return statearr_13653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___13654,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13711 = [];
var len__7484__auto___13714 = arguments.length;
var i__7485__auto___13715 = (0);
while(true){
if((i__7485__auto___13715 < len__7484__auto___13714)){
args13711.push((arguments[i__7485__auto___13715]));

var G__13716 = (i__7485__auto___13715 + (1));
i__7485__auto___13715 = G__13716;
continue;
} else {
}
break;
}

var G__13713 = args13711.length;
switch (G__13713) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13711.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13728 = arguments.length;
var i__7485__auto___13729 = (0);
while(true){
if((i__7485__auto___13729 < len__7484__auto___13728)){
args__7491__auto__.push((arguments[i__7485__auto___13729]));

var G__13730 = (i__7485__auto___13729 + (1));
i__7485__auto___13729 = G__13730;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13722){
var map__13723 = p__13722;
var map__13723__$1 = ((((!((map__13723 == null)))?((((map__13723.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13723.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13723):map__13723);
var opts = map__13723__$1;
var statearr_13725_13731 = state;
(statearr_13725_13731[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13723,map__13723__$1,opts){
return (function (val){
var statearr_13726_13732 = state;
(statearr_13726_13732[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13723,map__13723__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13727_13733 = state;
(statearr_13727_13733[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13718){
var G__13719 = cljs.core.first.call(null,seq13718);
var seq13718__$1 = cljs.core.next.call(null,seq13718);
var G__13720 = cljs.core.first.call(null,seq13718__$1);
var seq13718__$2 = cljs.core.next.call(null,seq13718__$1);
var G__13721 = cljs.core.first.call(null,seq13718__$2);
var seq13718__$3 = cljs.core.next.call(null,seq13718__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13719,G__13720,G__13721,seq13718__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13899 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13899 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13900){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13900 = meta13900;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13901,meta13900__$1){
var self__ = this;
var _13901__$1 = this;
return (new cljs.core.async.t_cljs$core$async13899(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13900__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13901){
var self__ = this;
var _13901__$1 = this;
return self__.meta13900;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13900","meta13900",-744257238,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13899.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13899.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13899";

cljs.core.async.t_cljs$core$async13899.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13899");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13899 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13899(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13900){
return (new cljs.core.async.t_cljs$core$async13899(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13900));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13899(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12301__auto___14064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14064,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14064,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_14001){
var state_val_14002 = (state_14001[(1)]);
if((state_val_14002 === (7))){
var inst_13917 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
var statearr_14003_14065 = state_14001__$1;
(statearr_14003_14065[(2)] = inst_13917);

(statearr_14003_14065[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (20))){
var inst_13929 = (state_14001[(7)]);
var state_14001__$1 = state_14001;
var statearr_14004_14066 = state_14001__$1;
(statearr_14004_14066[(2)] = inst_13929);

(statearr_14004_14066[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (27))){
var state_14001__$1 = state_14001;
var statearr_14005_14067 = state_14001__$1;
(statearr_14005_14067[(2)] = null);

(statearr_14005_14067[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (1))){
var inst_13905 = (state_14001[(8)]);
var inst_13905__$1 = calc_state.call(null);
var inst_13907 = (inst_13905__$1 == null);
var inst_13908 = cljs.core.not.call(null,inst_13907);
var state_14001__$1 = (function (){var statearr_14006 = state_14001;
(statearr_14006[(8)] = inst_13905__$1);

return statearr_14006;
})();
if(inst_13908){
var statearr_14007_14068 = state_14001__$1;
(statearr_14007_14068[(1)] = (2));

} else {
var statearr_14008_14069 = state_14001__$1;
(statearr_14008_14069[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (24))){
var inst_13952 = (state_14001[(9)]);
var inst_13975 = (state_14001[(10)]);
var inst_13961 = (state_14001[(11)]);
var inst_13975__$1 = inst_13952.call(null,inst_13961);
var state_14001__$1 = (function (){var statearr_14009 = state_14001;
(statearr_14009[(10)] = inst_13975__$1);

return statearr_14009;
})();
if(cljs.core.truth_(inst_13975__$1)){
var statearr_14010_14070 = state_14001__$1;
(statearr_14010_14070[(1)] = (29));

} else {
var statearr_14011_14071 = state_14001__$1;
(statearr_14011_14071[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (4))){
var inst_13920 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13920)){
var statearr_14012_14072 = state_14001__$1;
(statearr_14012_14072[(1)] = (8));

} else {
var statearr_14013_14073 = state_14001__$1;
(statearr_14013_14073[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (15))){
var inst_13946 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13946)){
var statearr_14014_14074 = state_14001__$1;
(statearr_14014_14074[(1)] = (19));

} else {
var statearr_14015_14075 = state_14001__$1;
(statearr_14015_14075[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (21))){
var inst_13951 = (state_14001[(12)]);
var inst_13951__$1 = (state_14001[(2)]);
var inst_13952 = cljs.core.get.call(null,inst_13951__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13953 = cljs.core.get.call(null,inst_13951__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13954 = cljs.core.get.call(null,inst_13951__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_14001__$1 = (function (){var statearr_14016 = state_14001;
(statearr_14016[(13)] = inst_13953);

(statearr_14016[(9)] = inst_13952);

(statearr_14016[(12)] = inst_13951__$1);

return statearr_14016;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14001__$1,(22),inst_13954);
} else {
if((state_val_14002 === (31))){
var inst_13983 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13983)){
var statearr_14017_14076 = state_14001__$1;
(statearr_14017_14076[(1)] = (32));

} else {
var statearr_14018_14077 = state_14001__$1;
(statearr_14018_14077[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (32))){
var inst_13960 = (state_14001[(14)]);
var state_14001__$1 = state_14001;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14001__$1,(35),out,inst_13960);
} else {
if((state_val_14002 === (33))){
var inst_13951 = (state_14001[(12)]);
var inst_13929 = inst_13951;
var state_14001__$1 = (function (){var statearr_14019 = state_14001;
(statearr_14019[(7)] = inst_13929);

return statearr_14019;
})();
var statearr_14020_14078 = state_14001__$1;
(statearr_14020_14078[(2)] = null);

(statearr_14020_14078[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (13))){
var inst_13929 = (state_14001[(7)]);
var inst_13936 = inst_13929.cljs$lang$protocol_mask$partition0$;
var inst_13937 = (inst_13936 & (64));
var inst_13938 = inst_13929.cljs$core$ISeq$;
var inst_13939 = (inst_13937) || (inst_13938);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13939)){
var statearr_14021_14079 = state_14001__$1;
(statearr_14021_14079[(1)] = (16));

} else {
var statearr_14022_14080 = state_14001__$1;
(statearr_14022_14080[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (22))){
var inst_13960 = (state_14001[(14)]);
var inst_13961 = (state_14001[(11)]);
var inst_13959 = (state_14001[(2)]);
var inst_13960__$1 = cljs.core.nth.call(null,inst_13959,(0),null);
var inst_13961__$1 = cljs.core.nth.call(null,inst_13959,(1),null);
var inst_13962 = (inst_13960__$1 == null);
var inst_13963 = cljs.core._EQ_.call(null,inst_13961__$1,change);
var inst_13964 = (inst_13962) || (inst_13963);
var state_14001__$1 = (function (){var statearr_14023 = state_14001;
(statearr_14023[(14)] = inst_13960__$1);

(statearr_14023[(11)] = inst_13961__$1);

return statearr_14023;
})();
if(cljs.core.truth_(inst_13964)){
var statearr_14024_14081 = state_14001__$1;
(statearr_14024_14081[(1)] = (23));

} else {
var statearr_14025_14082 = state_14001__$1;
(statearr_14025_14082[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (36))){
var inst_13951 = (state_14001[(12)]);
var inst_13929 = inst_13951;
var state_14001__$1 = (function (){var statearr_14026 = state_14001;
(statearr_14026[(7)] = inst_13929);

return statearr_14026;
})();
var statearr_14027_14083 = state_14001__$1;
(statearr_14027_14083[(2)] = null);

(statearr_14027_14083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (29))){
var inst_13975 = (state_14001[(10)]);
var state_14001__$1 = state_14001;
var statearr_14028_14084 = state_14001__$1;
(statearr_14028_14084[(2)] = inst_13975);

(statearr_14028_14084[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (6))){
var state_14001__$1 = state_14001;
var statearr_14029_14085 = state_14001__$1;
(statearr_14029_14085[(2)] = false);

(statearr_14029_14085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (28))){
var inst_13971 = (state_14001[(2)]);
var inst_13972 = calc_state.call(null);
var inst_13929 = inst_13972;
var state_14001__$1 = (function (){var statearr_14030 = state_14001;
(statearr_14030[(7)] = inst_13929);

(statearr_14030[(15)] = inst_13971);

return statearr_14030;
})();
var statearr_14031_14086 = state_14001__$1;
(statearr_14031_14086[(2)] = null);

(statearr_14031_14086[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (25))){
var inst_13997 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
var statearr_14032_14087 = state_14001__$1;
(statearr_14032_14087[(2)] = inst_13997);

(statearr_14032_14087[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (34))){
var inst_13995 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
var statearr_14033_14088 = state_14001__$1;
(statearr_14033_14088[(2)] = inst_13995);

(statearr_14033_14088[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (17))){
var state_14001__$1 = state_14001;
var statearr_14034_14089 = state_14001__$1;
(statearr_14034_14089[(2)] = false);

(statearr_14034_14089[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (3))){
var state_14001__$1 = state_14001;
var statearr_14035_14090 = state_14001__$1;
(statearr_14035_14090[(2)] = false);

(statearr_14035_14090[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (12))){
var inst_13999 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14001__$1,inst_13999);
} else {
if((state_val_14002 === (2))){
var inst_13905 = (state_14001[(8)]);
var inst_13910 = inst_13905.cljs$lang$protocol_mask$partition0$;
var inst_13911 = (inst_13910 & (64));
var inst_13912 = inst_13905.cljs$core$ISeq$;
var inst_13913 = (inst_13911) || (inst_13912);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13913)){
var statearr_14036_14091 = state_14001__$1;
(statearr_14036_14091[(1)] = (5));

} else {
var statearr_14037_14092 = state_14001__$1;
(statearr_14037_14092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (23))){
var inst_13960 = (state_14001[(14)]);
var inst_13966 = (inst_13960 == null);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13966)){
var statearr_14038_14093 = state_14001__$1;
(statearr_14038_14093[(1)] = (26));

} else {
var statearr_14039_14094 = state_14001__$1;
(statearr_14039_14094[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (35))){
var inst_13986 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
if(cljs.core.truth_(inst_13986)){
var statearr_14040_14095 = state_14001__$1;
(statearr_14040_14095[(1)] = (36));

} else {
var statearr_14041_14096 = state_14001__$1;
(statearr_14041_14096[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (19))){
var inst_13929 = (state_14001[(7)]);
var inst_13948 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13929);
var state_14001__$1 = state_14001;
var statearr_14042_14097 = state_14001__$1;
(statearr_14042_14097[(2)] = inst_13948);

(statearr_14042_14097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (11))){
var inst_13929 = (state_14001[(7)]);
var inst_13933 = (inst_13929 == null);
var inst_13934 = cljs.core.not.call(null,inst_13933);
var state_14001__$1 = state_14001;
if(inst_13934){
var statearr_14043_14098 = state_14001__$1;
(statearr_14043_14098[(1)] = (13));

} else {
var statearr_14044_14099 = state_14001__$1;
(statearr_14044_14099[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (9))){
var inst_13905 = (state_14001[(8)]);
var state_14001__$1 = state_14001;
var statearr_14045_14100 = state_14001__$1;
(statearr_14045_14100[(2)] = inst_13905);

(statearr_14045_14100[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (5))){
var state_14001__$1 = state_14001;
var statearr_14046_14101 = state_14001__$1;
(statearr_14046_14101[(2)] = true);

(statearr_14046_14101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (14))){
var state_14001__$1 = state_14001;
var statearr_14047_14102 = state_14001__$1;
(statearr_14047_14102[(2)] = false);

(statearr_14047_14102[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (26))){
var inst_13961 = (state_14001[(11)]);
var inst_13968 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13961);
var state_14001__$1 = state_14001;
var statearr_14048_14103 = state_14001__$1;
(statearr_14048_14103[(2)] = inst_13968);

(statearr_14048_14103[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (16))){
var state_14001__$1 = state_14001;
var statearr_14049_14104 = state_14001__$1;
(statearr_14049_14104[(2)] = true);

(statearr_14049_14104[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (38))){
var inst_13991 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
var statearr_14050_14105 = state_14001__$1;
(statearr_14050_14105[(2)] = inst_13991);

(statearr_14050_14105[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (30))){
var inst_13953 = (state_14001[(13)]);
var inst_13952 = (state_14001[(9)]);
var inst_13961 = (state_14001[(11)]);
var inst_13978 = cljs.core.empty_QMARK_.call(null,inst_13952);
var inst_13979 = inst_13953.call(null,inst_13961);
var inst_13980 = cljs.core.not.call(null,inst_13979);
var inst_13981 = (inst_13978) && (inst_13980);
var state_14001__$1 = state_14001;
var statearr_14051_14106 = state_14001__$1;
(statearr_14051_14106[(2)] = inst_13981);

(statearr_14051_14106[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (10))){
var inst_13905 = (state_14001[(8)]);
var inst_13925 = (state_14001[(2)]);
var inst_13926 = cljs.core.get.call(null,inst_13925,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13927 = cljs.core.get.call(null,inst_13925,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13928 = cljs.core.get.call(null,inst_13925,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13929 = inst_13905;
var state_14001__$1 = (function (){var statearr_14052 = state_14001;
(statearr_14052[(16)] = inst_13926);

(statearr_14052[(7)] = inst_13929);

(statearr_14052[(17)] = inst_13928);

(statearr_14052[(18)] = inst_13927);

return statearr_14052;
})();
var statearr_14053_14107 = state_14001__$1;
(statearr_14053_14107[(2)] = null);

(statearr_14053_14107[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (18))){
var inst_13943 = (state_14001[(2)]);
var state_14001__$1 = state_14001;
var statearr_14054_14108 = state_14001__$1;
(statearr_14054_14108[(2)] = inst_13943);

(statearr_14054_14108[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (37))){
var state_14001__$1 = state_14001;
var statearr_14055_14109 = state_14001__$1;
(statearr_14055_14109[(2)] = null);

(statearr_14055_14109[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14002 === (8))){
var inst_13905 = (state_14001[(8)]);
var inst_13922 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13905);
var state_14001__$1 = state_14001;
var statearr_14056_14110 = state_14001__$1;
(statearr_14056_14110[(2)] = inst_13922);

(statearr_14056_14110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14064,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12189__auto__,c__12301__auto___14064,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12190__auto__ = null;
var cljs$core$async$mix_$_state_machine__12190__auto____0 = (function (){
var statearr_14060 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14060[(0)] = cljs$core$async$mix_$_state_machine__12190__auto__);

(statearr_14060[(1)] = (1));

return statearr_14060;
});
var cljs$core$async$mix_$_state_machine__12190__auto____1 = (function (state_14001){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14001);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14061){if((e14061 instanceof Object)){
var ex__12193__auto__ = e14061;
var statearr_14062_14111 = state_14001;
(statearr_14062_14111[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14001);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14061;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14112 = state_14001;
state_14001 = G__14112;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12190__auto__ = function(state_14001){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12190__auto____1.call(this,state_14001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12190__auto____0;
cljs$core$async$mix_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12190__auto____1;
return cljs$core$async$mix_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14064,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12303__auto__ = (function (){var statearr_14063 = f__12302__auto__.call(null);
(statearr_14063[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14064);

return statearr_14063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14064,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args14113 = [];
var len__7484__auto___14116 = arguments.length;
var i__7485__auto___14117 = (0);
while(true){
if((i__7485__auto___14117 < len__7484__auto___14116)){
args14113.push((arguments[i__7485__auto___14117]));

var G__14118 = (i__7485__auto___14117 + (1));
i__7485__auto___14117 = G__14118;
continue;
} else {
}
break;
}

var G__14115 = args14113.length;
switch (G__14115) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14113.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args14121 = [];
var len__7484__auto___14246 = arguments.length;
var i__7485__auto___14247 = (0);
while(true){
if((i__7485__auto___14247 < len__7484__auto___14246)){
args14121.push((arguments[i__7485__auto___14247]));

var G__14248 = (i__7485__auto___14247 + (1));
i__7485__auto___14247 = G__14248;
continue;
} else {
}
break;
}

var G__14123 = args14121.length;
switch (G__14123) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14121.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__14120_SHARP_){
if(cljs.core.truth_(p1__14120_SHARP_.call(null,topic))){
return p1__14120_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__14120_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async14124 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14124 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta14125){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta14125 = meta14125;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_14126,meta14125__$1){
var self__ = this;
var _14126__$1 = this;
return (new cljs.core.async.t_cljs$core$async14124(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta14125__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_14126){
var self__ = this;
var _14126__$1 = this;
return self__.meta14125;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta14125","meta14125",1715543044,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async14124.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14124.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14124";

cljs.core.async.t_cljs$core$async14124.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14124");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async14124 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async14124(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14125){
return (new cljs.core.async.t_cljs$core$async14124(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta14125));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async14124(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12301__auto___14250 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14250,mults,ensure_mult,p){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14250,mults,ensure_mult,p){
return (function (state_14198){
var state_val_14199 = (state_14198[(1)]);
if((state_val_14199 === (7))){
var inst_14194 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
var statearr_14200_14251 = state_14198__$1;
(statearr_14200_14251[(2)] = inst_14194);

(statearr_14200_14251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (20))){
var state_14198__$1 = state_14198;
var statearr_14201_14252 = state_14198__$1;
(statearr_14201_14252[(2)] = null);

(statearr_14201_14252[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (1))){
var state_14198__$1 = state_14198;
var statearr_14202_14253 = state_14198__$1;
(statearr_14202_14253[(2)] = null);

(statearr_14202_14253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (24))){
var inst_14177 = (state_14198[(7)]);
var inst_14186 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_14177);
var state_14198__$1 = state_14198;
var statearr_14203_14254 = state_14198__$1;
(statearr_14203_14254[(2)] = inst_14186);

(statearr_14203_14254[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (4))){
var inst_14129 = (state_14198[(8)]);
var inst_14129__$1 = (state_14198[(2)]);
var inst_14130 = (inst_14129__$1 == null);
var state_14198__$1 = (function (){var statearr_14204 = state_14198;
(statearr_14204[(8)] = inst_14129__$1);

return statearr_14204;
})();
if(cljs.core.truth_(inst_14130)){
var statearr_14205_14255 = state_14198__$1;
(statearr_14205_14255[(1)] = (5));

} else {
var statearr_14206_14256 = state_14198__$1;
(statearr_14206_14256[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (15))){
var inst_14171 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
var statearr_14207_14257 = state_14198__$1;
(statearr_14207_14257[(2)] = inst_14171);

(statearr_14207_14257[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (21))){
var inst_14191 = (state_14198[(2)]);
var state_14198__$1 = (function (){var statearr_14208 = state_14198;
(statearr_14208[(9)] = inst_14191);

return statearr_14208;
})();
var statearr_14209_14258 = state_14198__$1;
(statearr_14209_14258[(2)] = null);

(statearr_14209_14258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (13))){
var inst_14153 = (state_14198[(10)]);
var inst_14155 = cljs.core.chunked_seq_QMARK_.call(null,inst_14153);
var state_14198__$1 = state_14198;
if(inst_14155){
var statearr_14210_14259 = state_14198__$1;
(statearr_14210_14259[(1)] = (16));

} else {
var statearr_14211_14260 = state_14198__$1;
(statearr_14211_14260[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (22))){
var inst_14183 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
if(cljs.core.truth_(inst_14183)){
var statearr_14212_14261 = state_14198__$1;
(statearr_14212_14261[(1)] = (23));

} else {
var statearr_14213_14262 = state_14198__$1;
(statearr_14213_14262[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (6))){
var inst_14129 = (state_14198[(8)]);
var inst_14177 = (state_14198[(7)]);
var inst_14179 = (state_14198[(11)]);
var inst_14177__$1 = topic_fn.call(null,inst_14129);
var inst_14178 = cljs.core.deref.call(null,mults);
var inst_14179__$1 = cljs.core.get.call(null,inst_14178,inst_14177__$1);
var state_14198__$1 = (function (){var statearr_14214 = state_14198;
(statearr_14214[(7)] = inst_14177__$1);

(statearr_14214[(11)] = inst_14179__$1);

return statearr_14214;
})();
if(cljs.core.truth_(inst_14179__$1)){
var statearr_14215_14263 = state_14198__$1;
(statearr_14215_14263[(1)] = (19));

} else {
var statearr_14216_14264 = state_14198__$1;
(statearr_14216_14264[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (25))){
var inst_14188 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
var statearr_14217_14265 = state_14198__$1;
(statearr_14217_14265[(2)] = inst_14188);

(statearr_14217_14265[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (17))){
var inst_14153 = (state_14198[(10)]);
var inst_14162 = cljs.core.first.call(null,inst_14153);
var inst_14163 = cljs.core.async.muxch_STAR_.call(null,inst_14162);
var inst_14164 = cljs.core.async.close_BANG_.call(null,inst_14163);
var inst_14165 = cljs.core.next.call(null,inst_14153);
var inst_14139 = inst_14165;
var inst_14140 = null;
var inst_14141 = (0);
var inst_14142 = (0);
var state_14198__$1 = (function (){var statearr_14218 = state_14198;
(statearr_14218[(12)] = inst_14142);

(statearr_14218[(13)] = inst_14141);

(statearr_14218[(14)] = inst_14164);

(statearr_14218[(15)] = inst_14139);

(statearr_14218[(16)] = inst_14140);

return statearr_14218;
})();
var statearr_14219_14266 = state_14198__$1;
(statearr_14219_14266[(2)] = null);

(statearr_14219_14266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (3))){
var inst_14196 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14198__$1,inst_14196);
} else {
if((state_val_14199 === (12))){
var inst_14173 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
var statearr_14220_14267 = state_14198__$1;
(statearr_14220_14267[(2)] = inst_14173);

(statearr_14220_14267[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (2))){
var state_14198__$1 = state_14198;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14198__$1,(4),ch);
} else {
if((state_val_14199 === (23))){
var state_14198__$1 = state_14198;
var statearr_14221_14268 = state_14198__$1;
(statearr_14221_14268[(2)] = null);

(statearr_14221_14268[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (19))){
var inst_14129 = (state_14198[(8)]);
var inst_14179 = (state_14198[(11)]);
var inst_14181 = cljs.core.async.muxch_STAR_.call(null,inst_14179);
var state_14198__$1 = state_14198;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14198__$1,(22),inst_14181,inst_14129);
} else {
if((state_val_14199 === (11))){
var inst_14153 = (state_14198[(10)]);
var inst_14139 = (state_14198[(15)]);
var inst_14153__$1 = cljs.core.seq.call(null,inst_14139);
var state_14198__$1 = (function (){var statearr_14222 = state_14198;
(statearr_14222[(10)] = inst_14153__$1);

return statearr_14222;
})();
if(inst_14153__$1){
var statearr_14223_14269 = state_14198__$1;
(statearr_14223_14269[(1)] = (13));

} else {
var statearr_14224_14270 = state_14198__$1;
(statearr_14224_14270[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (9))){
var inst_14175 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
var statearr_14225_14271 = state_14198__$1;
(statearr_14225_14271[(2)] = inst_14175);

(statearr_14225_14271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (5))){
var inst_14136 = cljs.core.deref.call(null,mults);
var inst_14137 = cljs.core.vals.call(null,inst_14136);
var inst_14138 = cljs.core.seq.call(null,inst_14137);
var inst_14139 = inst_14138;
var inst_14140 = null;
var inst_14141 = (0);
var inst_14142 = (0);
var state_14198__$1 = (function (){var statearr_14226 = state_14198;
(statearr_14226[(12)] = inst_14142);

(statearr_14226[(13)] = inst_14141);

(statearr_14226[(15)] = inst_14139);

(statearr_14226[(16)] = inst_14140);

return statearr_14226;
})();
var statearr_14227_14272 = state_14198__$1;
(statearr_14227_14272[(2)] = null);

(statearr_14227_14272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (14))){
var state_14198__$1 = state_14198;
var statearr_14231_14273 = state_14198__$1;
(statearr_14231_14273[(2)] = null);

(statearr_14231_14273[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (16))){
var inst_14153 = (state_14198[(10)]);
var inst_14157 = cljs.core.chunk_first.call(null,inst_14153);
var inst_14158 = cljs.core.chunk_rest.call(null,inst_14153);
var inst_14159 = cljs.core.count.call(null,inst_14157);
var inst_14139 = inst_14158;
var inst_14140 = inst_14157;
var inst_14141 = inst_14159;
var inst_14142 = (0);
var state_14198__$1 = (function (){var statearr_14232 = state_14198;
(statearr_14232[(12)] = inst_14142);

(statearr_14232[(13)] = inst_14141);

(statearr_14232[(15)] = inst_14139);

(statearr_14232[(16)] = inst_14140);

return statearr_14232;
})();
var statearr_14233_14274 = state_14198__$1;
(statearr_14233_14274[(2)] = null);

(statearr_14233_14274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (10))){
var inst_14142 = (state_14198[(12)]);
var inst_14141 = (state_14198[(13)]);
var inst_14139 = (state_14198[(15)]);
var inst_14140 = (state_14198[(16)]);
var inst_14147 = cljs.core._nth.call(null,inst_14140,inst_14142);
var inst_14148 = cljs.core.async.muxch_STAR_.call(null,inst_14147);
var inst_14149 = cljs.core.async.close_BANG_.call(null,inst_14148);
var inst_14150 = (inst_14142 + (1));
var tmp14228 = inst_14141;
var tmp14229 = inst_14139;
var tmp14230 = inst_14140;
var inst_14139__$1 = tmp14229;
var inst_14140__$1 = tmp14230;
var inst_14141__$1 = tmp14228;
var inst_14142__$1 = inst_14150;
var state_14198__$1 = (function (){var statearr_14234 = state_14198;
(statearr_14234[(12)] = inst_14142__$1);

(statearr_14234[(13)] = inst_14141__$1);

(statearr_14234[(17)] = inst_14149);

(statearr_14234[(15)] = inst_14139__$1);

(statearr_14234[(16)] = inst_14140__$1);

return statearr_14234;
})();
var statearr_14235_14275 = state_14198__$1;
(statearr_14235_14275[(2)] = null);

(statearr_14235_14275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (18))){
var inst_14168 = (state_14198[(2)]);
var state_14198__$1 = state_14198;
var statearr_14236_14276 = state_14198__$1;
(statearr_14236_14276[(2)] = inst_14168);

(statearr_14236_14276[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14199 === (8))){
var inst_14142 = (state_14198[(12)]);
var inst_14141 = (state_14198[(13)]);
var inst_14144 = (inst_14142 < inst_14141);
var inst_14145 = inst_14144;
var state_14198__$1 = state_14198;
if(cljs.core.truth_(inst_14145)){
var statearr_14237_14277 = state_14198__$1;
(statearr_14237_14277[(1)] = (10));

} else {
var statearr_14238_14278 = state_14198__$1;
(statearr_14238_14278[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14250,mults,ensure_mult,p))
;
return ((function (switch__12189__auto__,c__12301__auto___14250,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_14242 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14242[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_14242[(1)] = (1));

return statearr_14242;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14198){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14198);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14243){if((e14243 instanceof Object)){
var ex__12193__auto__ = e14243;
var statearr_14244_14279 = state_14198;
(statearr_14244_14279[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14198);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14243;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14280 = state_14198;
state_14198 = G__14280;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14198){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14250,mults,ensure_mult,p))
})();
var state__12303__auto__ = (function (){var statearr_14245 = f__12302__auto__.call(null);
(statearr_14245[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14250);

return statearr_14245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14250,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args14281 = [];
var len__7484__auto___14284 = arguments.length;
var i__7485__auto___14285 = (0);
while(true){
if((i__7485__auto___14285 < len__7484__auto___14284)){
args14281.push((arguments[i__7485__auto___14285]));

var G__14286 = (i__7485__auto___14285 + (1));
i__7485__auto___14285 = G__14286;
continue;
} else {
}
break;
}

var G__14283 = args14281.length;
switch (G__14283) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14281.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args14288 = [];
var len__7484__auto___14291 = arguments.length;
var i__7485__auto___14292 = (0);
while(true){
if((i__7485__auto___14292 < len__7484__auto___14291)){
args14288.push((arguments[i__7485__auto___14292]));

var G__14293 = (i__7485__auto___14292 + (1));
i__7485__auto___14292 = G__14293;
continue;
} else {
}
break;
}

var G__14290 = args14288.length;
switch (G__14290) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14288.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args14295 = [];
var len__7484__auto___14366 = arguments.length;
var i__7485__auto___14367 = (0);
while(true){
if((i__7485__auto___14367 < len__7484__auto___14366)){
args14295.push((arguments[i__7485__auto___14367]));

var G__14368 = (i__7485__auto___14367 + (1));
i__7485__auto___14367 = G__14368;
continue;
} else {
}
break;
}

var G__14297 = args14295.length;
switch (G__14297) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14295.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__12301__auto___14370 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14370,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14370,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_14336){
var state_val_14337 = (state_14336[(1)]);
if((state_val_14337 === (7))){
var state_14336__$1 = state_14336;
var statearr_14338_14371 = state_14336__$1;
(statearr_14338_14371[(2)] = null);

(statearr_14338_14371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (1))){
var state_14336__$1 = state_14336;
var statearr_14339_14372 = state_14336__$1;
(statearr_14339_14372[(2)] = null);

(statearr_14339_14372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (4))){
var inst_14300 = (state_14336[(7)]);
var inst_14302 = (inst_14300 < cnt);
var state_14336__$1 = state_14336;
if(cljs.core.truth_(inst_14302)){
var statearr_14340_14373 = state_14336__$1;
(statearr_14340_14373[(1)] = (6));

} else {
var statearr_14341_14374 = state_14336__$1;
(statearr_14341_14374[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (15))){
var inst_14332 = (state_14336[(2)]);
var state_14336__$1 = state_14336;
var statearr_14342_14375 = state_14336__$1;
(statearr_14342_14375[(2)] = inst_14332);

(statearr_14342_14375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (13))){
var inst_14325 = cljs.core.async.close_BANG_.call(null,out);
var state_14336__$1 = state_14336;
var statearr_14343_14376 = state_14336__$1;
(statearr_14343_14376[(2)] = inst_14325);

(statearr_14343_14376[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (6))){
var state_14336__$1 = state_14336;
var statearr_14344_14377 = state_14336__$1;
(statearr_14344_14377[(2)] = null);

(statearr_14344_14377[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (3))){
var inst_14334 = (state_14336[(2)]);
var state_14336__$1 = state_14336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14336__$1,inst_14334);
} else {
if((state_val_14337 === (12))){
var inst_14322 = (state_14336[(8)]);
var inst_14322__$1 = (state_14336[(2)]);
var inst_14323 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_14322__$1);
var state_14336__$1 = (function (){var statearr_14345 = state_14336;
(statearr_14345[(8)] = inst_14322__$1);

return statearr_14345;
})();
if(cljs.core.truth_(inst_14323)){
var statearr_14346_14378 = state_14336__$1;
(statearr_14346_14378[(1)] = (13));

} else {
var statearr_14347_14379 = state_14336__$1;
(statearr_14347_14379[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (2))){
var inst_14299 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_14300 = (0);
var state_14336__$1 = (function (){var statearr_14348 = state_14336;
(statearr_14348[(9)] = inst_14299);

(statearr_14348[(7)] = inst_14300);

return statearr_14348;
})();
var statearr_14349_14380 = state_14336__$1;
(statearr_14349_14380[(2)] = null);

(statearr_14349_14380[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (11))){
var inst_14300 = (state_14336[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_14336,(10),Object,null,(9));
var inst_14309 = chs__$1.call(null,inst_14300);
var inst_14310 = done.call(null,inst_14300);
var inst_14311 = cljs.core.async.take_BANG_.call(null,inst_14309,inst_14310);
var state_14336__$1 = state_14336;
var statearr_14350_14381 = state_14336__$1;
(statearr_14350_14381[(2)] = inst_14311);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14336__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (9))){
var inst_14300 = (state_14336[(7)]);
var inst_14313 = (state_14336[(2)]);
var inst_14314 = (inst_14300 + (1));
var inst_14300__$1 = inst_14314;
var state_14336__$1 = (function (){var statearr_14351 = state_14336;
(statearr_14351[(10)] = inst_14313);

(statearr_14351[(7)] = inst_14300__$1);

return statearr_14351;
})();
var statearr_14352_14382 = state_14336__$1;
(statearr_14352_14382[(2)] = null);

(statearr_14352_14382[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (5))){
var inst_14320 = (state_14336[(2)]);
var state_14336__$1 = (function (){var statearr_14353 = state_14336;
(statearr_14353[(11)] = inst_14320);

return statearr_14353;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14336__$1,(12),dchan);
} else {
if((state_val_14337 === (14))){
var inst_14322 = (state_14336[(8)]);
var inst_14327 = cljs.core.apply.call(null,f,inst_14322);
var state_14336__$1 = state_14336;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14336__$1,(16),out,inst_14327);
} else {
if((state_val_14337 === (16))){
var inst_14329 = (state_14336[(2)]);
var state_14336__$1 = (function (){var statearr_14354 = state_14336;
(statearr_14354[(12)] = inst_14329);

return statearr_14354;
})();
var statearr_14355_14383 = state_14336__$1;
(statearr_14355_14383[(2)] = null);

(statearr_14355_14383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (10))){
var inst_14304 = (state_14336[(2)]);
var inst_14305 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_14336__$1 = (function (){var statearr_14356 = state_14336;
(statearr_14356[(13)] = inst_14304);

return statearr_14356;
})();
var statearr_14357_14384 = state_14336__$1;
(statearr_14357_14384[(2)] = inst_14305);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14336__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14337 === (8))){
var inst_14318 = (state_14336[(2)]);
var state_14336__$1 = state_14336;
var statearr_14358_14385 = state_14336__$1;
(statearr_14358_14385[(2)] = inst_14318);

(statearr_14358_14385[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14370,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12189__auto__,c__12301__auto___14370,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_14362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14362[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_14362[(1)] = (1));

return statearr_14362;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14336){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14363){if((e14363 instanceof Object)){
var ex__12193__auto__ = e14363;
var statearr_14364_14386 = state_14336;
(statearr_14364_14386[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14363;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14387 = state_14336;
state_14336 = G__14387;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14336){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14370,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12303__auto__ = (function (){var statearr_14365 = f__12302__auto__.call(null);
(statearr_14365[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14370);

return statearr_14365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14370,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args14389 = [];
var len__7484__auto___14447 = arguments.length;
var i__7485__auto___14448 = (0);
while(true){
if((i__7485__auto___14448 < len__7484__auto___14447)){
args14389.push((arguments[i__7485__auto___14448]));

var G__14449 = (i__7485__auto___14448 + (1));
i__7485__auto___14448 = G__14449;
continue;
} else {
}
break;
}

var G__14391 = args14389.length;
switch (G__14391) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14389.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12301__auto___14451 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14451,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14451,out){
return (function (state_14423){
var state_val_14424 = (state_14423[(1)]);
if((state_val_14424 === (7))){
var inst_14402 = (state_14423[(7)]);
var inst_14403 = (state_14423[(8)]);
var inst_14402__$1 = (state_14423[(2)]);
var inst_14403__$1 = cljs.core.nth.call(null,inst_14402__$1,(0),null);
var inst_14404 = cljs.core.nth.call(null,inst_14402__$1,(1),null);
var inst_14405 = (inst_14403__$1 == null);
var state_14423__$1 = (function (){var statearr_14425 = state_14423;
(statearr_14425[(7)] = inst_14402__$1);

(statearr_14425[(9)] = inst_14404);

(statearr_14425[(8)] = inst_14403__$1);

return statearr_14425;
})();
if(cljs.core.truth_(inst_14405)){
var statearr_14426_14452 = state_14423__$1;
(statearr_14426_14452[(1)] = (8));

} else {
var statearr_14427_14453 = state_14423__$1;
(statearr_14427_14453[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (1))){
var inst_14392 = cljs.core.vec.call(null,chs);
var inst_14393 = inst_14392;
var state_14423__$1 = (function (){var statearr_14428 = state_14423;
(statearr_14428[(10)] = inst_14393);

return statearr_14428;
})();
var statearr_14429_14454 = state_14423__$1;
(statearr_14429_14454[(2)] = null);

(statearr_14429_14454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (4))){
var inst_14393 = (state_14423[(10)]);
var state_14423__$1 = state_14423;
return cljs.core.async.ioc_alts_BANG_.call(null,state_14423__$1,(7),inst_14393);
} else {
if((state_val_14424 === (6))){
var inst_14419 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
var statearr_14430_14455 = state_14423__$1;
(statearr_14430_14455[(2)] = inst_14419);

(statearr_14430_14455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (3))){
var inst_14421 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14423__$1,inst_14421);
} else {
if((state_val_14424 === (2))){
var inst_14393 = (state_14423[(10)]);
var inst_14395 = cljs.core.count.call(null,inst_14393);
var inst_14396 = (inst_14395 > (0));
var state_14423__$1 = state_14423;
if(cljs.core.truth_(inst_14396)){
var statearr_14432_14456 = state_14423__$1;
(statearr_14432_14456[(1)] = (4));

} else {
var statearr_14433_14457 = state_14423__$1;
(statearr_14433_14457[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (11))){
var inst_14393 = (state_14423[(10)]);
var inst_14412 = (state_14423[(2)]);
var tmp14431 = inst_14393;
var inst_14393__$1 = tmp14431;
var state_14423__$1 = (function (){var statearr_14434 = state_14423;
(statearr_14434[(10)] = inst_14393__$1);

(statearr_14434[(11)] = inst_14412);

return statearr_14434;
})();
var statearr_14435_14458 = state_14423__$1;
(statearr_14435_14458[(2)] = null);

(statearr_14435_14458[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (9))){
var inst_14403 = (state_14423[(8)]);
var state_14423__$1 = state_14423;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14423__$1,(11),out,inst_14403);
} else {
if((state_val_14424 === (5))){
var inst_14417 = cljs.core.async.close_BANG_.call(null,out);
var state_14423__$1 = state_14423;
var statearr_14436_14459 = state_14423__$1;
(statearr_14436_14459[(2)] = inst_14417);

(statearr_14436_14459[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (10))){
var inst_14415 = (state_14423[(2)]);
var state_14423__$1 = state_14423;
var statearr_14437_14460 = state_14423__$1;
(statearr_14437_14460[(2)] = inst_14415);

(statearr_14437_14460[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14424 === (8))){
var inst_14393 = (state_14423[(10)]);
var inst_14402 = (state_14423[(7)]);
var inst_14404 = (state_14423[(9)]);
var inst_14403 = (state_14423[(8)]);
var inst_14407 = (function (){var cs = inst_14393;
var vec__14398 = inst_14402;
var v = inst_14403;
var c = inst_14404;
return ((function (cs,vec__14398,v,c,inst_14393,inst_14402,inst_14404,inst_14403,state_val_14424,c__12301__auto___14451,out){
return (function (p1__14388_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__14388_SHARP_);
});
;})(cs,vec__14398,v,c,inst_14393,inst_14402,inst_14404,inst_14403,state_val_14424,c__12301__auto___14451,out))
})();
var inst_14408 = cljs.core.filterv.call(null,inst_14407,inst_14393);
var inst_14393__$1 = inst_14408;
var state_14423__$1 = (function (){var statearr_14438 = state_14423;
(statearr_14438[(10)] = inst_14393__$1);

return statearr_14438;
})();
var statearr_14439_14461 = state_14423__$1;
(statearr_14439_14461[(2)] = null);

(statearr_14439_14461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14451,out))
;
return ((function (switch__12189__auto__,c__12301__auto___14451,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_14443 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14443[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_14443[(1)] = (1));

return statearr_14443;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14423){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14423);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14444){if((e14444 instanceof Object)){
var ex__12193__auto__ = e14444;
var statearr_14445_14462 = state_14423;
(statearr_14445_14462[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14423);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14444;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14463 = state_14423;
state_14423 = G__14463;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14423){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14451,out))
})();
var state__12303__auto__ = (function (){var statearr_14446 = f__12302__auto__.call(null);
(statearr_14446[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14451);

return statearr_14446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14451,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args14464 = [];
var len__7484__auto___14513 = arguments.length;
var i__7485__auto___14514 = (0);
while(true){
if((i__7485__auto___14514 < len__7484__auto___14513)){
args14464.push((arguments[i__7485__auto___14514]));

var G__14515 = (i__7485__auto___14514 + (1));
i__7485__auto___14514 = G__14515;
continue;
} else {
}
break;
}

var G__14466 = args14464.length;
switch (G__14466) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14464.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12301__auto___14517 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14517,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14517,out){
return (function (state_14490){
var state_val_14491 = (state_14490[(1)]);
if((state_val_14491 === (7))){
var inst_14472 = (state_14490[(7)]);
var inst_14472__$1 = (state_14490[(2)]);
var inst_14473 = (inst_14472__$1 == null);
var inst_14474 = cljs.core.not.call(null,inst_14473);
var state_14490__$1 = (function (){var statearr_14492 = state_14490;
(statearr_14492[(7)] = inst_14472__$1);

return statearr_14492;
})();
if(inst_14474){
var statearr_14493_14518 = state_14490__$1;
(statearr_14493_14518[(1)] = (8));

} else {
var statearr_14494_14519 = state_14490__$1;
(statearr_14494_14519[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (1))){
var inst_14467 = (0);
var state_14490__$1 = (function (){var statearr_14495 = state_14490;
(statearr_14495[(8)] = inst_14467);

return statearr_14495;
})();
var statearr_14496_14520 = state_14490__$1;
(statearr_14496_14520[(2)] = null);

(statearr_14496_14520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (4))){
var state_14490__$1 = state_14490;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14490__$1,(7),ch);
} else {
if((state_val_14491 === (6))){
var inst_14485 = (state_14490[(2)]);
var state_14490__$1 = state_14490;
var statearr_14497_14521 = state_14490__$1;
(statearr_14497_14521[(2)] = inst_14485);

(statearr_14497_14521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (3))){
var inst_14487 = (state_14490[(2)]);
var inst_14488 = cljs.core.async.close_BANG_.call(null,out);
var state_14490__$1 = (function (){var statearr_14498 = state_14490;
(statearr_14498[(9)] = inst_14487);

return statearr_14498;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14490__$1,inst_14488);
} else {
if((state_val_14491 === (2))){
var inst_14467 = (state_14490[(8)]);
var inst_14469 = (inst_14467 < n);
var state_14490__$1 = state_14490;
if(cljs.core.truth_(inst_14469)){
var statearr_14499_14522 = state_14490__$1;
(statearr_14499_14522[(1)] = (4));

} else {
var statearr_14500_14523 = state_14490__$1;
(statearr_14500_14523[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (11))){
var inst_14467 = (state_14490[(8)]);
var inst_14477 = (state_14490[(2)]);
var inst_14478 = (inst_14467 + (1));
var inst_14467__$1 = inst_14478;
var state_14490__$1 = (function (){var statearr_14501 = state_14490;
(statearr_14501[(8)] = inst_14467__$1);

(statearr_14501[(10)] = inst_14477);

return statearr_14501;
})();
var statearr_14502_14524 = state_14490__$1;
(statearr_14502_14524[(2)] = null);

(statearr_14502_14524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (9))){
var state_14490__$1 = state_14490;
var statearr_14503_14525 = state_14490__$1;
(statearr_14503_14525[(2)] = null);

(statearr_14503_14525[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (5))){
var state_14490__$1 = state_14490;
var statearr_14504_14526 = state_14490__$1;
(statearr_14504_14526[(2)] = null);

(statearr_14504_14526[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (10))){
var inst_14482 = (state_14490[(2)]);
var state_14490__$1 = state_14490;
var statearr_14505_14527 = state_14490__$1;
(statearr_14505_14527[(2)] = inst_14482);

(statearr_14505_14527[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14491 === (8))){
var inst_14472 = (state_14490[(7)]);
var state_14490__$1 = state_14490;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14490__$1,(11),out,inst_14472);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14517,out))
;
return ((function (switch__12189__auto__,c__12301__auto___14517,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_14509 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14509[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_14509[(1)] = (1));

return statearr_14509;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14490){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14490);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14510){if((e14510 instanceof Object)){
var ex__12193__auto__ = e14510;
var statearr_14511_14528 = state_14490;
(statearr_14511_14528[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14510;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14529 = state_14490;
state_14490 = G__14529;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14490){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14517,out))
})();
var state__12303__auto__ = (function (){var statearr_14512 = f__12302__auto__.call(null);
(statearr_14512[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14517);

return statearr_14512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14517,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14537 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14537 = (function (map_LT_,f,ch,meta14538){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14538 = meta14538;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14539,meta14538__$1){
var self__ = this;
var _14539__$1 = this;
return (new cljs.core.async.t_cljs$core$async14537(self__.map_LT_,self__.f,self__.ch,meta14538__$1));
});

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14539){
var self__ = this;
var _14539__$1 = this;
return self__.meta14538;
});

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14540 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14540 = (function (map_LT_,f,ch,meta14538,_,fn1,meta14541){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta14538 = meta14538;
this._ = _;
this.fn1 = fn1;
this.meta14541 = meta14541;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14540.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14542,meta14541__$1){
var self__ = this;
var _14542__$1 = this;
return (new cljs.core.async.t_cljs$core$async14540(self__.map_LT_,self__.f,self__.ch,self__.meta14538,self__._,self__.fn1,meta14541__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14540.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14542){
var self__ = this;
var _14542__$1 = this;
return self__.meta14541;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14540.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async14540.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14540.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14540.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14530_SHARP_){
return f1.call(null,(((p1__14530_SHARP_ == null))?null:self__.f.call(null,p1__14530_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14540.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14538","meta14538",-1618759475,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14537","cljs.core.async/t_cljs$core$async14537",-1253196766,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14541","meta14541",-1431321266,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14540.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14540.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14540";

cljs.core.async.t_cljs$core$async14540.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14540");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14540 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14540(map_LT___$1,f__$1,ch__$1,meta14538__$1,___$2,fn1__$1,meta14541){
return (new cljs.core.async.t_cljs$core$async14540(map_LT___$1,f__$1,ch__$1,meta14538__$1,___$2,fn1__$1,meta14541));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14540(self__.map_LT_,self__.f,self__.ch,self__.meta14538,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14537.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14537.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14538","meta14538",-1618759475,null)], null);
});

cljs.core.async.t_cljs$core$async14537.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14537.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14537";

cljs.core.async.t_cljs$core$async14537.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14537");
});

cljs.core.async.__GT_t_cljs$core$async14537 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14537(map_LT___$1,f__$1,ch__$1,meta14538){
return (new cljs.core.async.t_cljs$core$async14537(map_LT___$1,f__$1,ch__$1,meta14538));
});

}

return (new cljs.core.async.t_cljs$core$async14537(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14546 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14546 = (function (map_GT_,f,ch,meta14547){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta14547 = meta14547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14548,meta14547__$1){
var self__ = this;
var _14548__$1 = this;
return (new cljs.core.async.t_cljs$core$async14546(self__.map_GT_,self__.f,self__.ch,meta14547__$1));
});

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14548){
var self__ = this;
var _14548__$1 = this;
return self__.meta14547;
});

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14546.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14547","meta14547",-29418842,null)], null);
});

cljs.core.async.t_cljs$core$async14546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14546";

cljs.core.async.t_cljs$core$async14546.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14546");
});

cljs.core.async.__GT_t_cljs$core$async14546 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14546(map_GT___$1,f__$1,ch__$1,meta14547){
return (new cljs.core.async.t_cljs$core$async14546(map_GT___$1,f__$1,ch__$1,meta14547));
});

}

return (new cljs.core.async.t_cljs$core$async14546(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14552 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14552 = (function (filter_GT_,p,ch,meta14553){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta14553 = meta14553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14554,meta14553__$1){
var self__ = this;
var _14554__$1 = this;
return (new cljs.core.async.t_cljs$core$async14552(self__.filter_GT_,self__.p,self__.ch,meta14553__$1));
});

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14554){
var self__ = this;
var _14554__$1 = this;
return self__.meta14553;
});

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async14552.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14552.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14553","meta14553",-355670504,null)], null);
});

cljs.core.async.t_cljs$core$async14552.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14552";

cljs.core.async.t_cljs$core$async14552.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14552");
});

cljs.core.async.__GT_t_cljs$core$async14552 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14552(filter_GT___$1,p__$1,ch__$1,meta14553){
return (new cljs.core.async.t_cljs$core$async14552(filter_GT___$1,p__$1,ch__$1,meta14553));
});

}

return (new cljs.core.async.t_cljs$core$async14552(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14555 = [];
var len__7484__auto___14599 = arguments.length;
var i__7485__auto___14600 = (0);
while(true){
if((i__7485__auto___14600 < len__7484__auto___14599)){
args14555.push((arguments[i__7485__auto___14600]));

var G__14601 = (i__7485__auto___14600 + (1));
i__7485__auto___14600 = G__14601;
continue;
} else {
}
break;
}

var G__14557 = args14555.length;
switch (G__14557) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14555.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12301__auto___14603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14603,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14603,out){
return (function (state_14578){
var state_val_14579 = (state_14578[(1)]);
if((state_val_14579 === (7))){
var inst_14574 = (state_14578[(2)]);
var state_14578__$1 = state_14578;
var statearr_14580_14604 = state_14578__$1;
(statearr_14580_14604[(2)] = inst_14574);

(statearr_14580_14604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (1))){
var state_14578__$1 = state_14578;
var statearr_14581_14605 = state_14578__$1;
(statearr_14581_14605[(2)] = null);

(statearr_14581_14605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (4))){
var inst_14560 = (state_14578[(7)]);
var inst_14560__$1 = (state_14578[(2)]);
var inst_14561 = (inst_14560__$1 == null);
var state_14578__$1 = (function (){var statearr_14582 = state_14578;
(statearr_14582[(7)] = inst_14560__$1);

return statearr_14582;
})();
if(cljs.core.truth_(inst_14561)){
var statearr_14583_14606 = state_14578__$1;
(statearr_14583_14606[(1)] = (5));

} else {
var statearr_14584_14607 = state_14578__$1;
(statearr_14584_14607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (6))){
var inst_14560 = (state_14578[(7)]);
var inst_14565 = p.call(null,inst_14560);
var state_14578__$1 = state_14578;
if(cljs.core.truth_(inst_14565)){
var statearr_14585_14608 = state_14578__$1;
(statearr_14585_14608[(1)] = (8));

} else {
var statearr_14586_14609 = state_14578__$1;
(statearr_14586_14609[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (3))){
var inst_14576 = (state_14578[(2)]);
var state_14578__$1 = state_14578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14578__$1,inst_14576);
} else {
if((state_val_14579 === (2))){
var state_14578__$1 = state_14578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14578__$1,(4),ch);
} else {
if((state_val_14579 === (11))){
var inst_14568 = (state_14578[(2)]);
var state_14578__$1 = state_14578;
var statearr_14587_14610 = state_14578__$1;
(statearr_14587_14610[(2)] = inst_14568);

(statearr_14587_14610[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (9))){
var state_14578__$1 = state_14578;
var statearr_14588_14611 = state_14578__$1;
(statearr_14588_14611[(2)] = null);

(statearr_14588_14611[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (5))){
var inst_14563 = cljs.core.async.close_BANG_.call(null,out);
var state_14578__$1 = state_14578;
var statearr_14589_14612 = state_14578__$1;
(statearr_14589_14612[(2)] = inst_14563);

(statearr_14589_14612[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (10))){
var inst_14571 = (state_14578[(2)]);
var state_14578__$1 = (function (){var statearr_14590 = state_14578;
(statearr_14590[(8)] = inst_14571);

return statearr_14590;
})();
var statearr_14591_14613 = state_14578__$1;
(statearr_14591_14613[(2)] = null);

(statearr_14591_14613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14579 === (8))){
var inst_14560 = (state_14578[(7)]);
var state_14578__$1 = state_14578;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14578__$1,(11),out,inst_14560);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14603,out))
;
return ((function (switch__12189__auto__,c__12301__auto___14603,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_14595 = [null,null,null,null,null,null,null,null,null];
(statearr_14595[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_14595[(1)] = (1));

return statearr_14595;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14578){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14596){if((e14596 instanceof Object)){
var ex__12193__auto__ = e14596;
var statearr_14597_14614 = state_14578;
(statearr_14597_14614[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14578);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14615 = state_14578;
state_14578 = G__14615;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14578){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14603,out))
})();
var state__12303__auto__ = (function (){var statearr_14598 = f__12302__auto__.call(null);
(statearr_14598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14603);

return statearr_14598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14603,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14616 = [];
var len__7484__auto___14619 = arguments.length;
var i__7485__auto___14620 = (0);
while(true){
if((i__7485__auto___14620 < len__7484__auto___14619)){
args14616.push((arguments[i__7485__auto___14620]));

var G__14621 = (i__7485__auto___14620 + (1));
i__7485__auto___14620 = G__14621;
continue;
} else {
}
break;
}

var G__14618 = args14616.length;
switch (G__14618) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14616.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12301__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_14788){
var state_val_14789 = (state_14788[(1)]);
if((state_val_14789 === (7))){
var inst_14784 = (state_14788[(2)]);
var state_14788__$1 = state_14788;
var statearr_14790_14831 = state_14788__$1;
(statearr_14790_14831[(2)] = inst_14784);

(statearr_14790_14831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (20))){
var inst_14754 = (state_14788[(7)]);
var inst_14765 = (state_14788[(2)]);
var inst_14766 = cljs.core.next.call(null,inst_14754);
var inst_14740 = inst_14766;
var inst_14741 = null;
var inst_14742 = (0);
var inst_14743 = (0);
var state_14788__$1 = (function (){var statearr_14791 = state_14788;
(statearr_14791[(8)] = inst_14740);

(statearr_14791[(9)] = inst_14742);

(statearr_14791[(10)] = inst_14741);

(statearr_14791[(11)] = inst_14765);

(statearr_14791[(12)] = inst_14743);

return statearr_14791;
})();
var statearr_14792_14832 = state_14788__$1;
(statearr_14792_14832[(2)] = null);

(statearr_14792_14832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (1))){
var state_14788__$1 = state_14788;
var statearr_14793_14833 = state_14788__$1;
(statearr_14793_14833[(2)] = null);

(statearr_14793_14833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (4))){
var inst_14729 = (state_14788[(13)]);
var inst_14729__$1 = (state_14788[(2)]);
var inst_14730 = (inst_14729__$1 == null);
var state_14788__$1 = (function (){var statearr_14794 = state_14788;
(statearr_14794[(13)] = inst_14729__$1);

return statearr_14794;
})();
if(cljs.core.truth_(inst_14730)){
var statearr_14795_14834 = state_14788__$1;
(statearr_14795_14834[(1)] = (5));

} else {
var statearr_14796_14835 = state_14788__$1;
(statearr_14796_14835[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (15))){
var state_14788__$1 = state_14788;
var statearr_14800_14836 = state_14788__$1;
(statearr_14800_14836[(2)] = null);

(statearr_14800_14836[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (21))){
var state_14788__$1 = state_14788;
var statearr_14801_14837 = state_14788__$1;
(statearr_14801_14837[(2)] = null);

(statearr_14801_14837[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (13))){
var inst_14740 = (state_14788[(8)]);
var inst_14742 = (state_14788[(9)]);
var inst_14741 = (state_14788[(10)]);
var inst_14743 = (state_14788[(12)]);
var inst_14750 = (state_14788[(2)]);
var inst_14751 = (inst_14743 + (1));
var tmp14797 = inst_14740;
var tmp14798 = inst_14742;
var tmp14799 = inst_14741;
var inst_14740__$1 = tmp14797;
var inst_14741__$1 = tmp14799;
var inst_14742__$1 = tmp14798;
var inst_14743__$1 = inst_14751;
var state_14788__$1 = (function (){var statearr_14802 = state_14788;
(statearr_14802[(8)] = inst_14740__$1);

(statearr_14802[(9)] = inst_14742__$1);

(statearr_14802[(14)] = inst_14750);

(statearr_14802[(10)] = inst_14741__$1);

(statearr_14802[(12)] = inst_14743__$1);

return statearr_14802;
})();
var statearr_14803_14838 = state_14788__$1;
(statearr_14803_14838[(2)] = null);

(statearr_14803_14838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (22))){
var state_14788__$1 = state_14788;
var statearr_14804_14839 = state_14788__$1;
(statearr_14804_14839[(2)] = null);

(statearr_14804_14839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (6))){
var inst_14729 = (state_14788[(13)]);
var inst_14738 = f.call(null,inst_14729);
var inst_14739 = cljs.core.seq.call(null,inst_14738);
var inst_14740 = inst_14739;
var inst_14741 = null;
var inst_14742 = (0);
var inst_14743 = (0);
var state_14788__$1 = (function (){var statearr_14805 = state_14788;
(statearr_14805[(8)] = inst_14740);

(statearr_14805[(9)] = inst_14742);

(statearr_14805[(10)] = inst_14741);

(statearr_14805[(12)] = inst_14743);

return statearr_14805;
})();
var statearr_14806_14840 = state_14788__$1;
(statearr_14806_14840[(2)] = null);

(statearr_14806_14840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (17))){
var inst_14754 = (state_14788[(7)]);
var inst_14758 = cljs.core.chunk_first.call(null,inst_14754);
var inst_14759 = cljs.core.chunk_rest.call(null,inst_14754);
var inst_14760 = cljs.core.count.call(null,inst_14758);
var inst_14740 = inst_14759;
var inst_14741 = inst_14758;
var inst_14742 = inst_14760;
var inst_14743 = (0);
var state_14788__$1 = (function (){var statearr_14807 = state_14788;
(statearr_14807[(8)] = inst_14740);

(statearr_14807[(9)] = inst_14742);

(statearr_14807[(10)] = inst_14741);

(statearr_14807[(12)] = inst_14743);

return statearr_14807;
})();
var statearr_14808_14841 = state_14788__$1;
(statearr_14808_14841[(2)] = null);

(statearr_14808_14841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (3))){
var inst_14786 = (state_14788[(2)]);
var state_14788__$1 = state_14788;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14788__$1,inst_14786);
} else {
if((state_val_14789 === (12))){
var inst_14774 = (state_14788[(2)]);
var state_14788__$1 = state_14788;
var statearr_14809_14842 = state_14788__$1;
(statearr_14809_14842[(2)] = inst_14774);

(statearr_14809_14842[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (2))){
var state_14788__$1 = state_14788;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14788__$1,(4),in$);
} else {
if((state_val_14789 === (23))){
var inst_14782 = (state_14788[(2)]);
var state_14788__$1 = state_14788;
var statearr_14810_14843 = state_14788__$1;
(statearr_14810_14843[(2)] = inst_14782);

(statearr_14810_14843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (19))){
var inst_14769 = (state_14788[(2)]);
var state_14788__$1 = state_14788;
var statearr_14811_14844 = state_14788__$1;
(statearr_14811_14844[(2)] = inst_14769);

(statearr_14811_14844[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (11))){
var inst_14740 = (state_14788[(8)]);
var inst_14754 = (state_14788[(7)]);
var inst_14754__$1 = cljs.core.seq.call(null,inst_14740);
var state_14788__$1 = (function (){var statearr_14812 = state_14788;
(statearr_14812[(7)] = inst_14754__$1);

return statearr_14812;
})();
if(inst_14754__$1){
var statearr_14813_14845 = state_14788__$1;
(statearr_14813_14845[(1)] = (14));

} else {
var statearr_14814_14846 = state_14788__$1;
(statearr_14814_14846[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (9))){
var inst_14776 = (state_14788[(2)]);
var inst_14777 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14788__$1 = (function (){var statearr_14815 = state_14788;
(statearr_14815[(15)] = inst_14776);

return statearr_14815;
})();
if(cljs.core.truth_(inst_14777)){
var statearr_14816_14847 = state_14788__$1;
(statearr_14816_14847[(1)] = (21));

} else {
var statearr_14817_14848 = state_14788__$1;
(statearr_14817_14848[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (5))){
var inst_14732 = cljs.core.async.close_BANG_.call(null,out);
var state_14788__$1 = state_14788;
var statearr_14818_14849 = state_14788__$1;
(statearr_14818_14849[(2)] = inst_14732);

(statearr_14818_14849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (14))){
var inst_14754 = (state_14788[(7)]);
var inst_14756 = cljs.core.chunked_seq_QMARK_.call(null,inst_14754);
var state_14788__$1 = state_14788;
if(inst_14756){
var statearr_14819_14850 = state_14788__$1;
(statearr_14819_14850[(1)] = (17));

} else {
var statearr_14820_14851 = state_14788__$1;
(statearr_14820_14851[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (16))){
var inst_14772 = (state_14788[(2)]);
var state_14788__$1 = state_14788;
var statearr_14821_14852 = state_14788__$1;
(statearr_14821_14852[(2)] = inst_14772);

(statearr_14821_14852[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14789 === (10))){
var inst_14741 = (state_14788[(10)]);
var inst_14743 = (state_14788[(12)]);
var inst_14748 = cljs.core._nth.call(null,inst_14741,inst_14743);
var state_14788__$1 = state_14788;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14788__$1,(13),out,inst_14748);
} else {
if((state_val_14789 === (18))){
var inst_14754 = (state_14788[(7)]);
var inst_14763 = cljs.core.first.call(null,inst_14754);
var state_14788__$1 = state_14788;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14788__$1,(20),out,inst_14763);
} else {
if((state_val_14789 === (8))){
var inst_14742 = (state_14788[(9)]);
var inst_14743 = (state_14788[(12)]);
var inst_14745 = (inst_14743 < inst_14742);
var inst_14746 = inst_14745;
var state_14788__$1 = state_14788;
if(cljs.core.truth_(inst_14746)){
var statearr_14822_14853 = state_14788__$1;
(statearr_14822_14853[(1)] = (10));

} else {
var statearr_14823_14854 = state_14788__$1;
(statearr_14823_14854[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_14827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14827[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__);

(statearr_14827[(1)] = (1));

return statearr_14827;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____1 = (function (state_14788){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14788);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14828){if((e14828 instanceof Object)){
var ex__12193__auto__ = e14828;
var statearr_14829_14855 = state_14788;
(statearr_14829_14855[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14788);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14828;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14856 = state_14788;
state_14788 = G__14856;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__ = function(state_14788){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____1.call(this,state_14788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_14830 = f__12302__auto__.call(null);
(statearr_14830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_14830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14857 = [];
var len__7484__auto___14860 = arguments.length;
var i__7485__auto___14861 = (0);
while(true){
if((i__7485__auto___14861 < len__7484__auto___14860)){
args14857.push((arguments[i__7485__auto___14861]));

var G__14862 = (i__7485__auto___14861 + (1));
i__7485__auto___14861 = G__14862;
continue;
} else {
}
break;
}

var G__14859 = args14857.length;
switch (G__14859) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14857.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14864 = [];
var len__7484__auto___14867 = arguments.length;
var i__7485__auto___14868 = (0);
while(true){
if((i__7485__auto___14868 < len__7484__auto___14867)){
args14864.push((arguments[i__7485__auto___14868]));

var G__14869 = (i__7485__auto___14868 + (1));
i__7485__auto___14868 = G__14869;
continue;
} else {
}
break;
}

var G__14866 = args14864.length;
switch (G__14866) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14864.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14871 = [];
var len__7484__auto___14922 = arguments.length;
var i__7485__auto___14923 = (0);
while(true){
if((i__7485__auto___14923 < len__7484__auto___14922)){
args14871.push((arguments[i__7485__auto___14923]));

var G__14924 = (i__7485__auto___14923 + (1));
i__7485__auto___14923 = G__14924;
continue;
} else {
}
break;
}

var G__14873 = args14871.length;
switch (G__14873) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14871.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12301__auto___14926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___14926,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___14926,out){
return (function (state_14897){
var state_val_14898 = (state_14897[(1)]);
if((state_val_14898 === (7))){
var inst_14892 = (state_14897[(2)]);
var state_14897__$1 = state_14897;
var statearr_14899_14927 = state_14897__$1;
(statearr_14899_14927[(2)] = inst_14892);

(statearr_14899_14927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (1))){
var inst_14874 = null;
var state_14897__$1 = (function (){var statearr_14900 = state_14897;
(statearr_14900[(7)] = inst_14874);

return statearr_14900;
})();
var statearr_14901_14928 = state_14897__$1;
(statearr_14901_14928[(2)] = null);

(statearr_14901_14928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (4))){
var inst_14877 = (state_14897[(8)]);
var inst_14877__$1 = (state_14897[(2)]);
var inst_14878 = (inst_14877__$1 == null);
var inst_14879 = cljs.core.not.call(null,inst_14878);
var state_14897__$1 = (function (){var statearr_14902 = state_14897;
(statearr_14902[(8)] = inst_14877__$1);

return statearr_14902;
})();
if(inst_14879){
var statearr_14903_14929 = state_14897__$1;
(statearr_14903_14929[(1)] = (5));

} else {
var statearr_14904_14930 = state_14897__$1;
(statearr_14904_14930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (6))){
var state_14897__$1 = state_14897;
var statearr_14905_14931 = state_14897__$1;
(statearr_14905_14931[(2)] = null);

(statearr_14905_14931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (3))){
var inst_14894 = (state_14897[(2)]);
var inst_14895 = cljs.core.async.close_BANG_.call(null,out);
var state_14897__$1 = (function (){var statearr_14906 = state_14897;
(statearr_14906[(9)] = inst_14894);

return statearr_14906;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14897__$1,inst_14895);
} else {
if((state_val_14898 === (2))){
var state_14897__$1 = state_14897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14897__$1,(4),ch);
} else {
if((state_val_14898 === (11))){
var inst_14877 = (state_14897[(8)]);
var inst_14886 = (state_14897[(2)]);
var inst_14874 = inst_14877;
var state_14897__$1 = (function (){var statearr_14907 = state_14897;
(statearr_14907[(10)] = inst_14886);

(statearr_14907[(7)] = inst_14874);

return statearr_14907;
})();
var statearr_14908_14932 = state_14897__$1;
(statearr_14908_14932[(2)] = null);

(statearr_14908_14932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (9))){
var inst_14877 = (state_14897[(8)]);
var state_14897__$1 = state_14897;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14897__$1,(11),out,inst_14877);
} else {
if((state_val_14898 === (5))){
var inst_14874 = (state_14897[(7)]);
var inst_14877 = (state_14897[(8)]);
var inst_14881 = cljs.core._EQ_.call(null,inst_14877,inst_14874);
var state_14897__$1 = state_14897;
if(inst_14881){
var statearr_14910_14933 = state_14897__$1;
(statearr_14910_14933[(1)] = (8));

} else {
var statearr_14911_14934 = state_14897__$1;
(statearr_14911_14934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (10))){
var inst_14889 = (state_14897[(2)]);
var state_14897__$1 = state_14897;
var statearr_14912_14935 = state_14897__$1;
(statearr_14912_14935[(2)] = inst_14889);

(statearr_14912_14935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14898 === (8))){
var inst_14874 = (state_14897[(7)]);
var tmp14909 = inst_14874;
var inst_14874__$1 = tmp14909;
var state_14897__$1 = (function (){var statearr_14913 = state_14897;
(statearr_14913[(7)] = inst_14874__$1);

return statearr_14913;
})();
var statearr_14914_14936 = state_14897__$1;
(statearr_14914_14936[(2)] = null);

(statearr_14914_14936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___14926,out))
;
return ((function (switch__12189__auto__,c__12301__auto___14926,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_14918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14918[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_14918[(1)] = (1));

return statearr_14918;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14897){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e14919){if((e14919 instanceof Object)){
var ex__12193__auto__ = e14919;
var statearr_14920_14937 = state_14897;
(statearr_14920_14937[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14897);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14938 = state_14897;
state_14897 = G__14938;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14897){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___14926,out))
})();
var state__12303__auto__ = (function (){var statearr_14921 = f__12302__auto__.call(null);
(statearr_14921[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___14926);

return statearr_14921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___14926,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14939 = [];
var len__7484__auto___15009 = arguments.length;
var i__7485__auto___15010 = (0);
while(true){
if((i__7485__auto___15010 < len__7484__auto___15009)){
args14939.push((arguments[i__7485__auto___15010]));

var G__15011 = (i__7485__auto___15010 + (1));
i__7485__auto___15010 = G__15011;
continue;
} else {
}
break;
}

var G__14941 = args14939.length;
switch (G__14941) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14939.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12301__auto___15013 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___15013,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___15013,out){
return (function (state_14979){
var state_val_14980 = (state_14979[(1)]);
if((state_val_14980 === (7))){
var inst_14975 = (state_14979[(2)]);
var state_14979__$1 = state_14979;
var statearr_14981_15014 = state_14979__$1;
(statearr_14981_15014[(2)] = inst_14975);

(statearr_14981_15014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (1))){
var inst_14942 = (new Array(n));
var inst_14943 = inst_14942;
var inst_14944 = (0);
var state_14979__$1 = (function (){var statearr_14982 = state_14979;
(statearr_14982[(7)] = inst_14943);

(statearr_14982[(8)] = inst_14944);

return statearr_14982;
})();
var statearr_14983_15015 = state_14979__$1;
(statearr_14983_15015[(2)] = null);

(statearr_14983_15015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (4))){
var inst_14947 = (state_14979[(9)]);
var inst_14947__$1 = (state_14979[(2)]);
var inst_14948 = (inst_14947__$1 == null);
var inst_14949 = cljs.core.not.call(null,inst_14948);
var state_14979__$1 = (function (){var statearr_14984 = state_14979;
(statearr_14984[(9)] = inst_14947__$1);

return statearr_14984;
})();
if(inst_14949){
var statearr_14985_15016 = state_14979__$1;
(statearr_14985_15016[(1)] = (5));

} else {
var statearr_14986_15017 = state_14979__$1;
(statearr_14986_15017[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (15))){
var inst_14969 = (state_14979[(2)]);
var state_14979__$1 = state_14979;
var statearr_14987_15018 = state_14979__$1;
(statearr_14987_15018[(2)] = inst_14969);

(statearr_14987_15018[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (13))){
var state_14979__$1 = state_14979;
var statearr_14988_15019 = state_14979__$1;
(statearr_14988_15019[(2)] = null);

(statearr_14988_15019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (6))){
var inst_14944 = (state_14979[(8)]);
var inst_14965 = (inst_14944 > (0));
var state_14979__$1 = state_14979;
if(cljs.core.truth_(inst_14965)){
var statearr_14989_15020 = state_14979__$1;
(statearr_14989_15020[(1)] = (12));

} else {
var statearr_14990_15021 = state_14979__$1;
(statearr_14990_15021[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (3))){
var inst_14977 = (state_14979[(2)]);
var state_14979__$1 = state_14979;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14979__$1,inst_14977);
} else {
if((state_val_14980 === (12))){
var inst_14943 = (state_14979[(7)]);
var inst_14967 = cljs.core.vec.call(null,inst_14943);
var state_14979__$1 = state_14979;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14979__$1,(15),out,inst_14967);
} else {
if((state_val_14980 === (2))){
var state_14979__$1 = state_14979;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14979__$1,(4),ch);
} else {
if((state_val_14980 === (11))){
var inst_14959 = (state_14979[(2)]);
var inst_14960 = (new Array(n));
var inst_14943 = inst_14960;
var inst_14944 = (0);
var state_14979__$1 = (function (){var statearr_14991 = state_14979;
(statearr_14991[(7)] = inst_14943);

(statearr_14991[(8)] = inst_14944);

(statearr_14991[(10)] = inst_14959);

return statearr_14991;
})();
var statearr_14992_15022 = state_14979__$1;
(statearr_14992_15022[(2)] = null);

(statearr_14992_15022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (9))){
var inst_14943 = (state_14979[(7)]);
var inst_14957 = cljs.core.vec.call(null,inst_14943);
var state_14979__$1 = state_14979;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14979__$1,(11),out,inst_14957);
} else {
if((state_val_14980 === (5))){
var inst_14947 = (state_14979[(9)]);
var inst_14943 = (state_14979[(7)]);
var inst_14944 = (state_14979[(8)]);
var inst_14952 = (state_14979[(11)]);
var inst_14951 = (inst_14943[inst_14944] = inst_14947);
var inst_14952__$1 = (inst_14944 + (1));
var inst_14953 = (inst_14952__$1 < n);
var state_14979__$1 = (function (){var statearr_14993 = state_14979;
(statearr_14993[(12)] = inst_14951);

(statearr_14993[(11)] = inst_14952__$1);

return statearr_14993;
})();
if(cljs.core.truth_(inst_14953)){
var statearr_14994_15023 = state_14979__$1;
(statearr_14994_15023[(1)] = (8));

} else {
var statearr_14995_15024 = state_14979__$1;
(statearr_14995_15024[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (14))){
var inst_14972 = (state_14979[(2)]);
var inst_14973 = cljs.core.async.close_BANG_.call(null,out);
var state_14979__$1 = (function (){var statearr_14997 = state_14979;
(statearr_14997[(13)] = inst_14972);

return statearr_14997;
})();
var statearr_14998_15025 = state_14979__$1;
(statearr_14998_15025[(2)] = inst_14973);

(statearr_14998_15025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (10))){
var inst_14963 = (state_14979[(2)]);
var state_14979__$1 = state_14979;
var statearr_14999_15026 = state_14979__$1;
(statearr_14999_15026[(2)] = inst_14963);

(statearr_14999_15026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14980 === (8))){
var inst_14943 = (state_14979[(7)]);
var inst_14952 = (state_14979[(11)]);
var tmp14996 = inst_14943;
var inst_14943__$1 = tmp14996;
var inst_14944 = inst_14952;
var state_14979__$1 = (function (){var statearr_15000 = state_14979;
(statearr_15000[(7)] = inst_14943__$1);

(statearr_15000[(8)] = inst_14944);

return statearr_15000;
})();
var statearr_15001_15027 = state_14979__$1;
(statearr_15001_15027[(2)] = null);

(statearr_15001_15027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___15013,out))
;
return ((function (switch__12189__auto__,c__12301__auto___15013,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_15005 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15005[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_15005[(1)] = (1));

return statearr_15005;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_14979){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_14979);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e15006){if((e15006 instanceof Object)){
var ex__12193__auto__ = e15006;
var statearr_15007_15028 = state_14979;
(statearr_15007_15028[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14979);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15029 = state_14979;
state_14979 = G__15029;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_14979){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_14979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___15013,out))
})();
var state__12303__auto__ = (function (){var statearr_15008 = f__12302__auto__.call(null);
(statearr_15008[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___15013);

return statearr_15008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___15013,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args15030 = [];
var len__7484__auto___15104 = arguments.length;
var i__7485__auto___15105 = (0);
while(true){
if((i__7485__auto___15105 < len__7484__auto___15104)){
args15030.push((arguments[i__7485__auto___15105]));

var G__15106 = (i__7485__auto___15105 + (1));
i__7485__auto___15105 = G__15106;
continue;
} else {
}
break;
}

var G__15032 = args15030.length;
switch (G__15032) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15030.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__12301__auto___15108 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12301__auto___15108,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___15108,out){
return (function (state_15074){
var state_val_15075 = (state_15074[(1)]);
if((state_val_15075 === (7))){
var inst_15070 = (state_15074[(2)]);
var state_15074__$1 = state_15074;
var statearr_15076_15109 = state_15074__$1;
(statearr_15076_15109[(2)] = inst_15070);

(statearr_15076_15109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (1))){
var inst_15033 = [];
var inst_15034 = inst_15033;
var inst_15035 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15074__$1 = (function (){var statearr_15077 = state_15074;
(statearr_15077[(7)] = inst_15035);

(statearr_15077[(8)] = inst_15034);

return statearr_15077;
})();
var statearr_15078_15110 = state_15074__$1;
(statearr_15078_15110[(2)] = null);

(statearr_15078_15110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (4))){
var inst_15038 = (state_15074[(9)]);
var inst_15038__$1 = (state_15074[(2)]);
var inst_15039 = (inst_15038__$1 == null);
var inst_15040 = cljs.core.not.call(null,inst_15039);
var state_15074__$1 = (function (){var statearr_15079 = state_15074;
(statearr_15079[(9)] = inst_15038__$1);

return statearr_15079;
})();
if(inst_15040){
var statearr_15080_15111 = state_15074__$1;
(statearr_15080_15111[(1)] = (5));

} else {
var statearr_15081_15112 = state_15074__$1;
(statearr_15081_15112[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (15))){
var inst_15064 = (state_15074[(2)]);
var state_15074__$1 = state_15074;
var statearr_15082_15113 = state_15074__$1;
(statearr_15082_15113[(2)] = inst_15064);

(statearr_15082_15113[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (13))){
var state_15074__$1 = state_15074;
var statearr_15083_15114 = state_15074__$1;
(statearr_15083_15114[(2)] = null);

(statearr_15083_15114[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (6))){
var inst_15034 = (state_15074[(8)]);
var inst_15059 = inst_15034.length;
var inst_15060 = (inst_15059 > (0));
var state_15074__$1 = state_15074;
if(cljs.core.truth_(inst_15060)){
var statearr_15084_15115 = state_15074__$1;
(statearr_15084_15115[(1)] = (12));

} else {
var statearr_15085_15116 = state_15074__$1;
(statearr_15085_15116[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (3))){
var inst_15072 = (state_15074[(2)]);
var state_15074__$1 = state_15074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15074__$1,inst_15072);
} else {
if((state_val_15075 === (12))){
var inst_15034 = (state_15074[(8)]);
var inst_15062 = cljs.core.vec.call(null,inst_15034);
var state_15074__$1 = state_15074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15074__$1,(15),out,inst_15062);
} else {
if((state_val_15075 === (2))){
var state_15074__$1 = state_15074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15074__$1,(4),ch);
} else {
if((state_val_15075 === (11))){
var inst_15042 = (state_15074[(10)]);
var inst_15038 = (state_15074[(9)]);
var inst_15052 = (state_15074[(2)]);
var inst_15053 = [];
var inst_15054 = inst_15053.push(inst_15038);
var inst_15034 = inst_15053;
var inst_15035 = inst_15042;
var state_15074__$1 = (function (){var statearr_15086 = state_15074;
(statearr_15086[(11)] = inst_15054);

(statearr_15086[(12)] = inst_15052);

(statearr_15086[(7)] = inst_15035);

(statearr_15086[(8)] = inst_15034);

return statearr_15086;
})();
var statearr_15087_15117 = state_15074__$1;
(statearr_15087_15117[(2)] = null);

(statearr_15087_15117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (9))){
var inst_15034 = (state_15074[(8)]);
var inst_15050 = cljs.core.vec.call(null,inst_15034);
var state_15074__$1 = state_15074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15074__$1,(11),out,inst_15050);
} else {
if((state_val_15075 === (5))){
var inst_15042 = (state_15074[(10)]);
var inst_15035 = (state_15074[(7)]);
var inst_15038 = (state_15074[(9)]);
var inst_15042__$1 = f.call(null,inst_15038);
var inst_15043 = cljs.core._EQ_.call(null,inst_15042__$1,inst_15035);
var inst_15044 = cljs.core.keyword_identical_QMARK_.call(null,inst_15035,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15045 = (inst_15043) || (inst_15044);
var state_15074__$1 = (function (){var statearr_15088 = state_15074;
(statearr_15088[(10)] = inst_15042__$1);

return statearr_15088;
})();
if(cljs.core.truth_(inst_15045)){
var statearr_15089_15118 = state_15074__$1;
(statearr_15089_15118[(1)] = (8));

} else {
var statearr_15090_15119 = state_15074__$1;
(statearr_15090_15119[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (14))){
var inst_15067 = (state_15074[(2)]);
var inst_15068 = cljs.core.async.close_BANG_.call(null,out);
var state_15074__$1 = (function (){var statearr_15092 = state_15074;
(statearr_15092[(13)] = inst_15067);

return statearr_15092;
})();
var statearr_15093_15120 = state_15074__$1;
(statearr_15093_15120[(2)] = inst_15068);

(statearr_15093_15120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (10))){
var inst_15057 = (state_15074[(2)]);
var state_15074__$1 = state_15074;
var statearr_15094_15121 = state_15074__$1;
(statearr_15094_15121[(2)] = inst_15057);

(statearr_15094_15121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15075 === (8))){
var inst_15042 = (state_15074[(10)]);
var inst_15038 = (state_15074[(9)]);
var inst_15034 = (state_15074[(8)]);
var inst_15047 = inst_15034.push(inst_15038);
var tmp15091 = inst_15034;
var inst_15034__$1 = tmp15091;
var inst_15035 = inst_15042;
var state_15074__$1 = (function (){var statearr_15095 = state_15074;
(statearr_15095[(14)] = inst_15047);

(statearr_15095[(7)] = inst_15035);

(statearr_15095[(8)] = inst_15034__$1);

return statearr_15095;
})();
var statearr_15096_15122 = state_15074__$1;
(statearr_15096_15122[(2)] = null);

(statearr_15096_15122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___15108,out))
;
return ((function (switch__12189__auto__,c__12301__auto___15108,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_15100 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15100[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_15100[(1)] = (1));

return statearr_15100;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_15074){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__.call(null,state_15074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12192__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e15101){if((e15101 instanceof Object)){
var ex__12193__auto__ = e15101;
var statearr_15102_15123 = state_15074;
(statearr_15102_15123[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15074);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15101;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12191__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15124 = state_15074;
state_15074 = G__15124;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_15074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_15074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___15108,out))
})();
var state__12303__auto__ = (function (){var statearr_15103 = f__12302__auto__.call(null);
(statearr_15103[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___15108);

return statearr_15103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12303__auto__);
});})(c__12301__auto___15108,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

