// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,x);
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args21518 = [];
var len__7484__auto___21521 = arguments.length;
var i__7485__auto___21522 = (0);
while(true){
if((i__7485__auto___21522 < len__7484__auto___21521)){
args21518.push((arguments[i__7485__auto___21522]));

var G__21523 = (i__7485__auto___21522 + (1));
i__7485__auto___21522 = G__21523;
continue;
} else {
}
break;
}

var G__21520 = args21518.length;
switch (G__21520) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21518.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args21525 = [];
var len__7484__auto___21528 = arguments.length;
var i__7485__auto___21529 = (0);
while(true){
if((i__7485__auto___21529 < len__7484__auto___21528)){
args21525.push((arguments[i__7485__auto___21529]));

var G__21530 = (i__7485__auto___21529 + (1));
i__7485__auto___21529 = G__21530;
continue;
} else {
}
break;
}

var G__21527 = args21525.length;
switch (G__21527) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21525.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args21532 = [];
var len__7484__auto___21545 = arguments.length;
var i__7485__auto___21546 = (0);
while(true){
if((i__7485__auto___21546 < len__7484__auto___21545)){
args21532.push((arguments[i__7485__auto___21546]));

var G__21547 = (i__7485__auto___21546 + (1));
i__7485__auto___21546 = G__21547;
continue;
} else {
}
break;
}

var G__21534 = args21532.length;
switch (G__21534) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21532.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21535_21549 = cljs.core.seq.call(null,x);
var chunk__21536_21550 = null;
var count__21537_21551 = (0);
var i__21538_21552 = (0);
while(true){
if((i__21538_21552 < count__21537_21551)){
var vec__21539_21553 = cljs.core._nth.call(null,chunk__21536_21550,i__21538_21552);
var k_21554 = cljs.core.nth.call(null,vec__21539_21553,(0),null);
var v_21555 = cljs.core.nth.call(null,vec__21539_21553,(1),null);
c2.dom.style.call(null,el__$1,k_21554,v_21555);

var G__21556 = seq__21535_21549;
var G__21557 = chunk__21536_21550;
var G__21558 = count__21537_21551;
var G__21559 = (i__21538_21552 + (1));
seq__21535_21549 = G__21556;
chunk__21536_21550 = G__21557;
count__21537_21551 = G__21558;
i__21538_21552 = G__21559;
continue;
} else {
var temp__4657__auto___21560 = cljs.core.seq.call(null,seq__21535_21549);
if(temp__4657__auto___21560){
var seq__21535_21561__$1 = temp__4657__auto___21560;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21535_21561__$1)){
var c__7220__auto___21562 = cljs.core.chunk_first.call(null,seq__21535_21561__$1);
var G__21563 = cljs.core.chunk_rest.call(null,seq__21535_21561__$1);
var G__21564 = c__7220__auto___21562;
var G__21565 = cljs.core.count.call(null,c__7220__auto___21562);
var G__21566 = (0);
seq__21535_21549 = G__21563;
chunk__21536_21550 = G__21564;
count__21537_21551 = G__21565;
i__21538_21552 = G__21566;
continue;
} else {
var vec__21542_21567 = cljs.core.first.call(null,seq__21535_21561__$1);
var k_21568 = cljs.core.nth.call(null,vec__21542_21567,(0),null);
var v_21569 = cljs.core.nth.call(null,vec__21542_21567,(1),null);
c2.dom.style.call(null,el__$1,k_21568,v_21569);

var G__21570 = cljs.core.next.call(null,seq__21535_21561__$1);
var G__21571 = null;
var G__21572 = (0);
var G__21573 = (0);
seq__21535_21549 = G__21570;
chunk__21536_21550 = G__21571;
count__21537_21551 = G__21572;
i__21538_21552 = G__21573;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args21574 = [];
var len__7484__auto___21591 = arguments.length;
var i__7485__auto___21592 = (0);
while(true){
if((i__7485__auto___21592 < len__7484__auto___21591)){
args21574.push((arguments[i__7485__auto___21592]));

var G__21593 = (i__7485__auto___21592 + (1));
i__7485__auto___21592 = G__21593;
continue;
} else {
}
break;
}

var G__21576 = args21574.length;
switch (G__21576) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21574.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__21577(s__21578){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__21578__$1 = s__21578;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21578__$1);
if(temp__4657__auto__){
var s__21578__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21578__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21578__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21580 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21579 = (0);
while(true){
if((i__21579 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__21579);
cljs.core.chunk_append.call(null,b__21580,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__21595 = (i__21579 + (1));
i__21579 = G__21595;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21580),c2$dom$iter__21577.call(null,cljs.core.chunk_rest.call(null,s__21578__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21580),null);
}
} else {
var i = cljs.core.first.call(null,s__21578__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__21577.call(null,cljs.core.rest.call(null,s__21578__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21581_21596 = cljs.core.seq.call(null,x);
var chunk__21582_21597 = null;
var count__21583_21598 = (0);
var i__21584_21599 = (0);
while(true){
if((i__21584_21599 < count__21583_21598)){
var vec__21585_21600 = cljs.core._nth.call(null,chunk__21582_21597,i__21584_21599);
var k_21601 = cljs.core.nth.call(null,vec__21585_21600,(0),null);
var v_21602 = cljs.core.nth.call(null,vec__21585_21600,(1),null);
c2.dom.attr.call(null,el__$1,k_21601,v_21602);

var G__21603 = seq__21581_21596;
var G__21604 = chunk__21582_21597;
var G__21605 = count__21583_21598;
var G__21606 = (i__21584_21599 + (1));
seq__21581_21596 = G__21603;
chunk__21582_21597 = G__21604;
count__21583_21598 = G__21605;
i__21584_21599 = G__21606;
continue;
} else {
var temp__4657__auto___21607 = cljs.core.seq.call(null,seq__21581_21596);
if(temp__4657__auto___21607){
var seq__21581_21608__$1 = temp__4657__auto___21607;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21581_21608__$1)){
var c__7220__auto___21609 = cljs.core.chunk_first.call(null,seq__21581_21608__$1);
var G__21610 = cljs.core.chunk_rest.call(null,seq__21581_21608__$1);
var G__21611 = c__7220__auto___21609;
var G__21612 = cljs.core.count.call(null,c__7220__auto___21609);
var G__21613 = (0);
seq__21581_21596 = G__21610;
chunk__21582_21597 = G__21611;
count__21583_21598 = G__21612;
i__21584_21599 = G__21613;
continue;
} else {
var vec__21588_21614 = cljs.core.first.call(null,seq__21581_21608__$1);
var k_21615 = cljs.core.nth.call(null,vec__21588_21614,(0),null);
var v_21616 = cljs.core.nth.call(null,vec__21588_21614,(1),null);
c2.dom.attr.call(null,el__$1,k_21615,v_21616);

var G__21617 = cljs.core.next.call(null,seq__21581_21608__$1);
var G__21618 = null;
var G__21619 = (0);
var G__21620 = (0);
seq__21581_21596 = G__21617;
chunk__21582_21597 = G__21618;
count__21583_21598 = G__21619;
i__21584_21599 = G__21620;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args21621 = [];
var len__7484__auto___21624 = arguments.length;
var i__7485__auto___21625 = (0);
while(true){
if((i__7485__auto___21625 < len__7484__auto___21624)){
args21621.push((arguments[i__7485__auto___21625]));

var G__21626 = (i__7485__auto___21625 + (1));
i__7485__auto___21625 = G__21626;
continue;
} else {
}
break;
}

var G__21623 = args21621.length;
switch (G__21623) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21621.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args21628 = [];
var len__7484__auto___21631 = arguments.length;
var i__7485__auto___21632 = (0);
while(true){
if((i__7485__auto___21632 < len__7484__auto___21631)){
args21628.push((arguments[i__7485__auto___21632]));

var G__21633 = (i__7485__auto___21632 + (1));
i__7485__auto___21632 = G__21633;
continue;
} else {
}
break;
}

var G__21630 = args21628.length;
switch (G__21630) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21628.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__21635_SHARP_){
return setTimeout(((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return p1__21635_SHARP_.call(null);
});})(or__6409__auto____$1,or__6409__auto__))
,(10));
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
