// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__37475__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__37472 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__37473 = cljs.core.seq(vec__37472);
var first__37474 = cljs.core.first(seq__37473);
var seq__37473__$1 = cljs.core.next(seq__37473);
var tag = first__37474;
var body = seq__37473__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__37475 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__37476__i = 0, G__37476__a = new Array(arguments.length -  0);
while (G__37476__i < G__37476__a.length) {G__37476__a[G__37476__i] = arguments[G__37476__i + 0]; ++G__37476__i;}
  args = new cljs.core.IndexedSeq(G__37476__a,0);
} 
return G__37475__delegate.call(this,args);};
G__37475.cljs$lang$maxFixedArity = 0;
G__37475.cljs$lang$applyTo = (function (arglist__37477){
var args = cljs.core.seq(arglist__37477);
return G__37475__delegate(args);
});
G__37475.cljs$core$IFn$_invoke$arity$variadic = G__37475__delegate;
return G__37475;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__37484(s__37485){
return (new cljs.core.LazySeq(null,(function (){
var s__37485__$1 = s__37485;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37485__$1);
if(temp__4657__auto__){
var s__37485__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37485__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37485__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37487 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37486 = (0);
while(true){
if((i__37486 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37486);
cljs.core.chunk_append(b__37487,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__37490 = (i__37486 + (1));
i__37486 = G__37490;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37487),sablono$core$update_arglists_$_iter__37484(cljs.core.chunk_rest(s__37485__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37487),null);
}
} else {
var args = cljs.core.first(s__37485__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__37484(cljs.core.rest(s__37485__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37498 = arguments.length;
var i__7485__auto___37499 = (0);
while(true){
if((i__7485__auto___37499 < len__7484__auto___37498)){
args__7491__auto__.push((arguments[i__7485__auto___37499]));

var G__37500 = (i__7485__auto___37499 + (1));
i__7485__auto___37499 = G__37500;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__37492(s__37493){
return (new cljs.core.LazySeq(null,(function (){
var s__37493__$1 = s__37493;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37493__$1);
if(temp__4657__auto__){
var s__37493__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37493__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37493__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37495 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37494 = (0);
while(true){
if((i__37494 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37494);
cljs.core.chunk_append(b__37495,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__37501 = (i__37494 + (1));
i__37494 = G__37501;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37495),sablono$core$iter__37492(cljs.core.chunk_rest(s__37493__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37495),null);
}
} else {
var style = cljs.core.first(s__37493__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__37492(cljs.core.rest(s__37493__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq37491){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37491));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__37506 = goog.dom.getDocument().body;
var G__37507 = (function (){var G__37508 = "script";
var G__37509 = ({"src": src});
return goog.dom.createDom(G__37508,G__37509);
})();
return goog.dom.appendChild(G__37506,G__37507);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to37510 = (function sablono$core$link_to37510(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37513 = arguments.length;
var i__7485__auto___37514 = (0);
while(true){
if((i__7485__auto___37514 < len__7484__auto___37513)){
args__7491__auto__.push((arguments[i__7485__auto___37514]));

var G__37515 = (i__7485__auto___37514 + (1));
i__7485__auto___37514 = G__37515;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to37510.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to37510.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to37510.cljs$lang$maxFixedArity = (1);

sablono.core.link_to37510.cljs$lang$applyTo = (function (seq37511){
var G__37512 = cljs.core.first(seq37511);
var seq37511__$1 = cljs.core.next(seq37511);
return sablono.core.link_to37510.cljs$core$IFn$_invoke$arity$variadic(G__37512,seq37511__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to37510);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to37516 = (function sablono$core$mail_to37516(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37523 = arguments.length;
var i__7485__auto___37524 = (0);
while(true){
if((i__7485__auto___37524 < len__7484__auto___37523)){
args__7491__auto__.push((arguments[i__7485__auto___37524]));

var G__37525 = (i__7485__auto___37524 + (1));
i__7485__auto___37524 = G__37525;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to37516.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to37516.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__37519){
var vec__37520 = p__37519;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37520,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to37516.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to37516.cljs$lang$applyTo = (function (seq37517){
var G__37518 = cljs.core.first(seq37517);
var seq37517__$1 = cljs.core.next(seq37517);
return sablono.core.mail_to37516.cljs$core$IFn$_invoke$arity$variadic(G__37518,seq37517__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to37516);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list37526 = (function sablono$core$unordered_list37526(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list37526_$_iter__37533(s__37534){
return (new cljs.core.LazySeq(null,(function (){
var s__37534__$1 = s__37534;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37534__$1);
if(temp__4657__auto__){
var s__37534__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37534__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37534__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37536 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37535 = (0);
while(true){
if((i__37535 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37535);
cljs.core.chunk_append(b__37536,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37539 = (i__37535 + (1));
i__37535 = G__37539;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37536),sablono$core$unordered_list37526_$_iter__37533(cljs.core.chunk_rest(s__37534__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37536),null);
}
} else {
var x = cljs.core.first(s__37534__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list37526_$_iter__37533(cljs.core.rest(s__37534__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list37526);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list37540 = (function sablono$core$ordered_list37540(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list37540_$_iter__37547(s__37548){
return (new cljs.core.LazySeq(null,(function (){
var s__37548__$1 = s__37548;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37548__$1);
if(temp__4657__auto__){
var s__37548__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37548__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37548__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37550 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37549 = (0);
while(true){
if((i__37549 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37549);
cljs.core.chunk_append(b__37550,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37553 = (i__37549 + (1));
i__37549 = G__37553;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37550),sablono$core$ordered_list37540_$_iter__37547(cljs.core.chunk_rest(s__37548__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37550),null);
}
} else {
var x = cljs.core.first(s__37548__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list37540_$_iter__37547(cljs.core.rest(s__37548__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list37540);
/**
 * Create an image element.
 */
sablono.core.image37554 = (function sablono$core$image37554(var_args){
var args37555 = [];
var len__7484__auto___37558 = arguments.length;
var i__7485__auto___37559 = (0);
while(true){
if((i__7485__auto___37559 < len__7484__auto___37558)){
args37555.push((arguments[i__7485__auto___37559]));

var G__37560 = (i__7485__auto___37559 + (1));
i__7485__auto___37559 = G__37560;
continue;
} else {
}
break;
}

var G__37557 = args37555.length;
switch (G__37557) {
case 1:
return sablono.core.image37554.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image37554.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37555.length)].join('')));

}
});

sablono.core.image37554.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image37554.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image37554.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image37554);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37562_SHARP_,p2__37563_SHARP_){
return [cljs.core.str(p1__37562_SHARP_),cljs.core.str("["),cljs.core.str(p2__37563_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37564_SHARP_,p2__37565_SHARP_){
return [cljs.core.str(p1__37564_SHARP_),cljs.core.str("-"),cljs.core.str(p2__37565_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field37566 = (function sablono$core$color_field37566(var_args){
var args37567 = [];
var len__7484__auto___37634 = arguments.length;
var i__7485__auto___37635 = (0);
while(true){
if((i__7485__auto___37635 < len__7484__auto___37634)){
args37567.push((arguments[i__7485__auto___37635]));

var G__37636 = (i__7485__auto___37635 + (1));
i__7485__auto___37635 = G__37636;
continue;
} else {
}
break;
}

var G__37569 = args37567.length;
switch (G__37569) {
case 1:
return sablono.core.color_field37566.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field37566.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37567.length)].join('')));

}
});

sablono.core.color_field37566.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.color_field37566.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.color_field37566.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.color_field37566.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field37566);

/**
 * Creates a date input field.
 */
sablono.core.date_field37570 = (function sablono$core$date_field37570(var_args){
var args37571 = [];
var len__7484__auto___37638 = arguments.length;
var i__7485__auto___37639 = (0);
while(true){
if((i__7485__auto___37639 < len__7484__auto___37638)){
args37571.push((arguments[i__7485__auto___37639]));

var G__37640 = (i__7485__auto___37639 + (1));
i__7485__auto___37639 = G__37640;
continue;
} else {
}
break;
}

var G__37573 = args37571.length;
switch (G__37573) {
case 1:
return sablono.core.date_field37570.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field37570.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37571.length)].join('')));

}
});

sablono.core.date_field37570.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.date_field37570.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.date_field37570.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.date_field37570.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field37570);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field37574 = (function sablono$core$datetime_field37574(var_args){
var args37575 = [];
var len__7484__auto___37642 = arguments.length;
var i__7485__auto___37643 = (0);
while(true){
if((i__7485__auto___37643 < len__7484__auto___37642)){
args37575.push((arguments[i__7485__auto___37643]));

var G__37644 = (i__7485__auto___37643 + (1));
i__7485__auto___37643 = G__37644;
continue;
} else {
}
break;
}

var G__37577 = args37575.length;
switch (G__37577) {
case 1:
return sablono.core.datetime_field37574.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field37574.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37575.length)].join('')));

}
});

sablono.core.datetime_field37574.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.datetime_field37574.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.datetime_field37574.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.datetime_field37574.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field37574);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field37578 = (function sablono$core$datetime_local_field37578(var_args){
var args37579 = [];
var len__7484__auto___37646 = arguments.length;
var i__7485__auto___37647 = (0);
while(true){
if((i__7485__auto___37647 < len__7484__auto___37646)){
args37579.push((arguments[i__7485__auto___37647]));

var G__37648 = (i__7485__auto___37647 + (1));
i__7485__auto___37647 = G__37648;
continue;
} else {
}
break;
}

var G__37581 = args37579.length;
switch (G__37581) {
case 1:
return sablono.core.datetime_local_field37578.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field37578.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37579.length)].join('')));

}
});

sablono.core.datetime_local_field37578.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.datetime_local_field37578.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.datetime_local_field37578.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.datetime_local_field37578.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field37578);

/**
 * Creates a email input field.
 */
sablono.core.email_field37582 = (function sablono$core$email_field37582(var_args){
var args37583 = [];
var len__7484__auto___37650 = arguments.length;
var i__7485__auto___37651 = (0);
while(true){
if((i__7485__auto___37651 < len__7484__auto___37650)){
args37583.push((arguments[i__7485__auto___37651]));

var G__37652 = (i__7485__auto___37651 + (1));
i__7485__auto___37651 = G__37652;
continue;
} else {
}
break;
}

var G__37585 = args37583.length;
switch (G__37585) {
case 1:
return sablono.core.email_field37582.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field37582.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37583.length)].join('')));

}
});

sablono.core.email_field37582.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.email_field37582.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.email_field37582.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.email_field37582.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field37582);

/**
 * Creates a file input field.
 */
sablono.core.file_field37586 = (function sablono$core$file_field37586(var_args){
var args37587 = [];
var len__7484__auto___37654 = arguments.length;
var i__7485__auto___37655 = (0);
while(true){
if((i__7485__auto___37655 < len__7484__auto___37654)){
args37587.push((arguments[i__7485__auto___37655]));

var G__37656 = (i__7485__auto___37655 + (1));
i__7485__auto___37655 = G__37656;
continue;
} else {
}
break;
}

var G__37589 = args37587.length;
switch (G__37589) {
case 1:
return sablono.core.file_field37586.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field37586.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37587.length)].join('')));

}
});

sablono.core.file_field37586.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.file_field37586.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.file_field37586.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.file_field37586.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field37586);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field37590 = (function sablono$core$hidden_field37590(var_args){
var args37591 = [];
var len__7484__auto___37658 = arguments.length;
var i__7485__auto___37659 = (0);
while(true){
if((i__7485__auto___37659 < len__7484__auto___37658)){
args37591.push((arguments[i__7485__auto___37659]));

var G__37660 = (i__7485__auto___37659 + (1));
i__7485__auto___37659 = G__37660;
continue;
} else {
}
break;
}

var G__37593 = args37591.length;
switch (G__37593) {
case 1:
return sablono.core.hidden_field37590.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field37590.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37591.length)].join('')));

}
});

sablono.core.hidden_field37590.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.hidden_field37590.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.hidden_field37590.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.hidden_field37590.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field37590);

/**
 * Creates a month input field.
 */
sablono.core.month_field37594 = (function sablono$core$month_field37594(var_args){
var args37595 = [];
var len__7484__auto___37662 = arguments.length;
var i__7485__auto___37663 = (0);
while(true){
if((i__7485__auto___37663 < len__7484__auto___37662)){
args37595.push((arguments[i__7485__auto___37663]));

var G__37664 = (i__7485__auto___37663 + (1));
i__7485__auto___37663 = G__37664;
continue;
} else {
}
break;
}

var G__37597 = args37595.length;
switch (G__37597) {
case 1:
return sablono.core.month_field37594.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field37594.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37595.length)].join('')));

}
});

sablono.core.month_field37594.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.month_field37594.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.month_field37594.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.month_field37594.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field37594);

/**
 * Creates a number input field.
 */
sablono.core.number_field37598 = (function sablono$core$number_field37598(var_args){
var args37599 = [];
var len__7484__auto___37666 = arguments.length;
var i__7485__auto___37667 = (0);
while(true){
if((i__7485__auto___37667 < len__7484__auto___37666)){
args37599.push((arguments[i__7485__auto___37667]));

var G__37668 = (i__7485__auto___37667 + (1));
i__7485__auto___37667 = G__37668;
continue;
} else {
}
break;
}

var G__37601 = args37599.length;
switch (G__37601) {
case 1:
return sablono.core.number_field37598.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field37598.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37599.length)].join('')));

}
});

sablono.core.number_field37598.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.number_field37598.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.number_field37598.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.number_field37598.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field37598);

/**
 * Creates a password input field.
 */
sablono.core.password_field37602 = (function sablono$core$password_field37602(var_args){
var args37603 = [];
var len__7484__auto___37670 = arguments.length;
var i__7485__auto___37671 = (0);
while(true){
if((i__7485__auto___37671 < len__7484__auto___37670)){
args37603.push((arguments[i__7485__auto___37671]));

var G__37672 = (i__7485__auto___37671 + (1));
i__7485__auto___37671 = G__37672;
continue;
} else {
}
break;
}

var G__37605 = args37603.length;
switch (G__37605) {
case 1:
return sablono.core.password_field37602.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field37602.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37603.length)].join('')));

}
});

sablono.core.password_field37602.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.password_field37602.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.password_field37602.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.password_field37602.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field37602);

/**
 * Creates a range input field.
 */
sablono.core.range_field37606 = (function sablono$core$range_field37606(var_args){
var args37607 = [];
var len__7484__auto___37674 = arguments.length;
var i__7485__auto___37675 = (0);
while(true){
if((i__7485__auto___37675 < len__7484__auto___37674)){
args37607.push((arguments[i__7485__auto___37675]));

var G__37676 = (i__7485__auto___37675 + (1));
i__7485__auto___37675 = G__37676;
continue;
} else {
}
break;
}

var G__37609 = args37607.length;
switch (G__37609) {
case 1:
return sablono.core.range_field37606.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field37606.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37607.length)].join('')));

}
});

sablono.core.range_field37606.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.range_field37606.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.range_field37606.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.range_field37606.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field37606);

/**
 * Creates a search input field.
 */
sablono.core.search_field37610 = (function sablono$core$search_field37610(var_args){
var args37611 = [];
var len__7484__auto___37678 = arguments.length;
var i__7485__auto___37679 = (0);
while(true){
if((i__7485__auto___37679 < len__7484__auto___37678)){
args37611.push((arguments[i__7485__auto___37679]));

var G__37680 = (i__7485__auto___37679 + (1));
i__7485__auto___37679 = G__37680;
continue;
} else {
}
break;
}

var G__37613 = args37611.length;
switch (G__37613) {
case 1:
return sablono.core.search_field37610.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field37610.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37611.length)].join('')));

}
});

sablono.core.search_field37610.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.search_field37610.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.search_field37610.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.search_field37610.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field37610);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field37614 = (function sablono$core$tel_field37614(var_args){
var args37615 = [];
var len__7484__auto___37682 = arguments.length;
var i__7485__auto___37683 = (0);
while(true){
if((i__7485__auto___37683 < len__7484__auto___37682)){
args37615.push((arguments[i__7485__auto___37683]));

var G__37684 = (i__7485__auto___37683 + (1));
i__7485__auto___37683 = G__37684;
continue;
} else {
}
break;
}

var G__37617 = args37615.length;
switch (G__37617) {
case 1:
return sablono.core.tel_field37614.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field37614.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37615.length)].join('')));

}
});

sablono.core.tel_field37614.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.tel_field37614.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.tel_field37614.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.tel_field37614.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field37614);

/**
 * Creates a text input field.
 */
sablono.core.text_field37618 = (function sablono$core$text_field37618(var_args){
var args37619 = [];
var len__7484__auto___37686 = arguments.length;
var i__7485__auto___37687 = (0);
while(true){
if((i__7485__auto___37687 < len__7484__auto___37686)){
args37619.push((arguments[i__7485__auto___37687]));

var G__37688 = (i__7485__auto___37687 + (1));
i__7485__auto___37687 = G__37688;
continue;
} else {
}
break;
}

var G__37621 = args37619.length;
switch (G__37621) {
case 1:
return sablono.core.text_field37618.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field37618.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37619.length)].join('')));

}
});

sablono.core.text_field37618.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.text_field37618.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.text_field37618.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.text_field37618.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field37618);

/**
 * Creates a time input field.
 */
sablono.core.time_field37622 = (function sablono$core$time_field37622(var_args){
var args37623 = [];
var len__7484__auto___37690 = arguments.length;
var i__7485__auto___37691 = (0);
while(true){
if((i__7485__auto___37691 < len__7484__auto___37690)){
args37623.push((arguments[i__7485__auto___37691]));

var G__37692 = (i__7485__auto___37691 + (1));
i__7485__auto___37691 = G__37692;
continue;
} else {
}
break;
}

var G__37625 = args37623.length;
switch (G__37625) {
case 1:
return sablono.core.time_field37622.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field37622.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37623.length)].join('')));

}
});

sablono.core.time_field37622.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.time_field37622.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.time_field37622.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.time_field37622.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field37622);

/**
 * Creates a url input field.
 */
sablono.core.url_field37626 = (function sablono$core$url_field37626(var_args){
var args37627 = [];
var len__7484__auto___37694 = arguments.length;
var i__7485__auto___37695 = (0);
while(true){
if((i__7485__auto___37695 < len__7484__auto___37694)){
args37627.push((arguments[i__7485__auto___37695]));

var G__37696 = (i__7485__auto___37695 + (1));
i__7485__auto___37695 = G__37696;
continue;
} else {
}
break;
}

var G__37629 = args37627.length;
switch (G__37629) {
case 1:
return sablono.core.url_field37626.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field37626.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37627.length)].join('')));

}
});

sablono.core.url_field37626.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.url_field37626.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.url_field37626.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.url_field37626.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field37626);

/**
 * Creates a week input field.
 */
sablono.core.week_field37630 = (function sablono$core$week_field37630(var_args){
var args37631 = [];
var len__7484__auto___37698 = arguments.length;
var i__7485__auto___37699 = (0);
while(true){
if((i__7485__auto___37699 < len__7484__auto___37698)){
args37631.push((arguments[i__7485__auto___37699]));

var G__37700 = (i__7485__auto___37699 + (1));
i__7485__auto___37699 = G__37700;
continue;
} else {
}
break;
}

var G__37633 = args37631.length;
switch (G__37633) {
case 1:
return sablono.core.week_field37630.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field37630.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37631.length)].join('')));

}
});

sablono.core.week_field37630.cljs$core$IFn$_invoke$arity$1 = (function (name__19366__auto__){
return sablono.core.week_field37630.cljs$core$IFn$_invoke$arity$2(name__19366__auto__,null);
});

sablono.core.week_field37630.cljs$core$IFn$_invoke$arity$2 = (function (name__19366__auto__,value__19367__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__19366__auto__,value__19367__auto__);
});

sablono.core.week_field37630.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field37630);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box37702 = (function sablono$core$check_box37702(var_args){
var args37703 = [];
var len__7484__auto___37706 = arguments.length;
var i__7485__auto___37707 = (0);
while(true){
if((i__7485__auto___37707 < len__7484__auto___37706)){
args37703.push((arguments[i__7485__auto___37707]));

var G__37708 = (i__7485__auto___37707 + (1));
i__7485__auto___37707 = G__37708;
continue;
} else {
}
break;
}

var G__37705 = args37703.length;
switch (G__37705) {
case 1:
return sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37703.length)].join('')));

}
});

sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box37702.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box37702.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box37702);
/**
 * Creates a radio button.
 */
sablono.core.radio_button37710 = (function sablono$core$radio_button37710(var_args){
var args37711 = [];
var len__7484__auto___37714 = arguments.length;
var i__7485__auto___37715 = (0);
while(true){
if((i__7485__auto___37715 < len__7484__auto___37714)){
args37711.push((arguments[i__7485__auto___37715]));

var G__37716 = (i__7485__auto___37715 + (1));
i__7485__auto___37715 = G__37716;
continue;
} else {
}
break;
}

var G__37713 = args37711.length;
switch (G__37713) {
case 1:
return sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37711.length)].join('')));

}
});

sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button37710.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button37710.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button37710);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options37718 = (function sablono$core$select_options37718(var_args){
var args37719 = [];
var len__7484__auto___37740 = arguments.length;
var i__7485__auto___37741 = (0);
while(true){
if((i__7485__auto___37741 < len__7484__auto___37740)){
args37719.push((arguments[i__7485__auto___37741]));

var G__37742 = (i__7485__auto___37741 + (1));
i__7485__auto___37741 = G__37742;
continue;
} else {
}
break;
}

var G__37721 = args37719.length;
switch (G__37721) {
case 1:
return sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37719.length)].join('')));

}
});

sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__37722(s__37723){
return (new cljs.core.LazySeq(null,(function (){
var s__37723__$1 = s__37723;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37723__$1);
if(temp__4657__auto__){
var s__37723__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37723__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37723__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37725 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37724 = (0);
while(true){
if((i__37724 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37724);
cljs.core.chunk_append(b__37725,((cljs.core.sequential_QMARK_(x))?(function (){var vec__37734 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37734,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37734,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37734,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__37744 = (i__37724 + (1));
i__37724 = G__37744;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37725),sablono$core$iter__37722(cljs.core.chunk_rest(s__37723__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37725),null);
}
} else {
var x = cljs.core.first(s__37723__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__37737 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37737,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37737,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37737,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options37718.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__37722(cljs.core.rest(s__37723__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options37718.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options37718);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down37745 = (function sablono$core$drop_down37745(var_args){
var args37746 = [];
var len__7484__auto___37749 = arguments.length;
var i__7485__auto___37750 = (0);
while(true){
if((i__7485__auto___37750 < len__7484__auto___37749)){
args37746.push((arguments[i__7485__auto___37750]));

var G__37751 = (i__7485__auto___37750 + (1));
i__7485__auto___37750 = G__37751;
continue;
} else {
}
break;
}

var G__37748 = args37746.length;
switch (G__37748) {
case 2:
return sablono.core.drop_down37745.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down37745.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37746.length)].join('')));

}
});

sablono.core.drop_down37745.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down37745.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down37745.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down37745.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down37745);
/**
 * Creates a text area element.
 */
sablono.core.text_area37753 = (function sablono$core$text_area37753(var_args){
var args37754 = [];
var len__7484__auto___37757 = arguments.length;
var i__7485__auto___37758 = (0);
while(true){
if((i__7485__auto___37758 < len__7484__auto___37757)){
args37754.push((arguments[i__7485__auto___37758]));

var G__37759 = (i__7485__auto___37758 + (1));
i__7485__auto___37758 = G__37759;
continue;
} else {
}
break;
}

var G__37756 = args37754.length;
switch (G__37756) {
case 1:
return sablono.core.text_area37753.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area37753.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37754.length)].join('')));

}
});

sablono.core.text_area37753.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area37753.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area37753.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area37753.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area37753);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label37761 = (function sablono$core$label37761(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label37761);
/**
 * Creates a submit button.
 */
sablono.core.submit_button37762 = (function sablono$core$submit_button37762(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button37762);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button37763 = (function sablono$core$reset_button37763(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button37763);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to37764 = (function sablono$core$form_to37764(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37771 = arguments.length;
var i__7485__auto___37772 = (0);
while(true){
if((i__7485__auto___37772 < len__7484__auto___37771)){
args__7491__auto__.push((arguments[i__7485__auto___37772]));

var G__37773 = (i__7485__auto___37772 + (1));
i__7485__auto___37772 = G__37773;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to37764.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to37764.cljs$core$IFn$_invoke$arity$variadic = (function (p__37767,body){
var vec__37768 = p__37767;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37768,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37768,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to37764.cljs$lang$maxFixedArity = (1);

sablono.core.form_to37764.cljs$lang$applyTo = (function (seq37765){
var G__37766 = cljs.core.first(seq37765);
var seq37765__$1 = cljs.core.next(seq37765);
return sablono.core.form_to37764.cljs$core$IFn$_invoke$arity$variadic(G__37766,seq37765__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to37764);
