// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.urls');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Extra fields that will be displayed on the table.
 */
hatti.views.table.get_extra_fields = (function hatti$views$table$get_extra_fields(is_filtered_dataview_QMARK_){
var id_field = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"ID",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null)], null);
var G__44001 = id_field;
if(cljs.core.not(is_filtered_dataview_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__44001,hatti.ona.forms.submission_time_field);
} else {
return G__44001;
}
});
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___44007 = arguments.length;
var i__7485__auto___44008 = (0);
while(true){
if((i__7485__auto___44008 < len__7484__auto___44007)){
args__7491__auto__.push((arguments[i__7485__auto___44008]));

var G__44009 = (i__7485__auto___44008 + (1));
i__7485__auto___44008 = G__44009;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__44004){
var map__44005 = p__44004;
var map__44005__$1 = ((((!((map__44005 == null)))?((((map__44005.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44005.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44005):map__44005);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44005__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(hatti.views.table.get_extra_fields(is_filtered_dataview_QMARK_),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,cljs.core.not(is_filtered_dataview_QMARK_)], 0))], 0))));
});

hatti.views.table.all_fields.cljs$lang$maxFixedArity = (1);

hatti.views.table.all_fields.cljs$lang$applyTo = (function (seq44002){
var G__44003 = cljs.core.first(seq44002);
var seq44002__$1 = cljs.core.next(seq44002);
return hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(G__44003,seq44002__$1);
});

/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__44010_SHARP_){
if(typeof p1__44010_SHARP_ === 'string'){
return clojure.string.lower_case(p1__44010_SHARP_);
} else {
return p1__44010_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__44016){
var vec__44017 = p__44016;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44017,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44017,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__44011_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__44011_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,clj_value,cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__44020 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__44020__$1 = ((((!((map__44020 == null)))?((((map__44020.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44020.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44020):map__44020);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44020__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44020__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44020__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil_DASH_square_DASH_o], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(70),"",(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___44053 = arguments.length;
var i__7485__auto___44054 = (0);
while(true){
if((i__7485__auto___44054 < len__7484__auto___44053)){
args__7491__auto__.push((arguments[i__7485__auto___44054]));

var G__44055 = (i__7485__auto___44054 + (1));
i__7485__auto___44054 = G__44055;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__44025){
var map__44026 = p__44025;
var map__44026__$1 = ((((!((map__44026 == null)))?((((map__44026.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44026.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44026):map__44026);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44026__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44026__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44026__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44026__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44026__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__44028 = cljs.core.false_QMARK_;
var G__44029 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__44028,map__44026,map__44026__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__44022_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__44022_SHARP_)) == null);
});})(G__44028,map__44026,map__44026__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__44028,G__44029) : chimera.core.any_QMARK_.call(null,G__44028,G__44029));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__44026,map__44026__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__44030(s__44031){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__44026,map__44026__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__44031__$1 = s__44031;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44031__$1);
if(temp__4657__auto__){
var s__44031__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44031__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44031__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44033 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44032 = (0);
while(true){
if((i__44032 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44032);
cljs.core.chunk_append(b__44033,(function (){var map__44044 = field;
var map__44044__$1 = ((((!((map__44044 == null)))?((((map__44044.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44044.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44044):map__44044);
var map__44045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44044__$1,cljs.core.cst$kw$instance);
var map__44045__$1 = ((((!((map__44045 == null)))?((((map__44045.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44045.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44045):map__44045);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44045__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44044__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44044__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44044__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})());

var G__44056 = (i__44032 + (1));
i__44032 = G__44056;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44033),hatti$views$table$iter__44030(cljs.core.chunk_rest(s__44031__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44033),null);
}
} else {
var field = cljs.core.first(s__44031__$2);
return cljs.core.cons((function (){var map__44048 = field;
var map__44048__$1 = ((((!((map__44048 == null)))?((((map__44048.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44048.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44048):map__44048);
var map__44049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44048__$1,cljs.core.cst$kw$instance);
var map__44049__$1 = ((((!((map__44049 == null)))?((((map__44049.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44049.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44049):map__44049);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44049__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44048__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44048__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44048__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$3(hatti.views.table.formatter,field,language),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__44030(cljs.core.rest(s__44031__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__44026,map__44026__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__44026,map__44026__$1,hide_actions_column_QMARK_,is_filtered_dataview_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0)));
})();
return cljs.core.clj__GT_js((function (){var G__44052 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__44052,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__44052;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq44023){
var G__44024 = cljs.core.first(seq44023);
var seq44023__$1 = cljs.core.next(seq44023);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__44024,seq44023__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__44058 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__44058);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44077(s__44078){
return (new cljs.core.LazySeq(null,(function (){
var s__44078__$1 = s__44078;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44078__$1);
if(temp__4657__auto__){
var s__44078__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44078__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44078__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44080 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44079 = (0);
while(true){
if((i__44079 < size__7188__auto__)){
var vec__44089 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44079);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44089,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44089,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__44080,event.subscribe(handler_function));

var G__44095 = (i__44079 + (1));
i__44079 = G__44095;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44080),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44077(cljs.core.chunk_rest(s__44078__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44080),null);
}
} else {
var vec__44092 = cljs.core.first(s__44078__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44092,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44092,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__44077(cljs.core.rest(s__44078__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44114(s__44115){
return (new cljs.core.LazySeq(null,(function (){
var s__44115__$1 = s__44115;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44115__$1);
if(temp__4657__auto__){
var s__44115__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44115__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44115__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44117 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44116 = (0);
while(true){
if((i__44116 < size__7188__auto__)){
var vec__44126 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44116);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44126,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44126,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__44117,event.subscribe(handler_function));

var G__44132 = (i__44116 + (1));
i__44116 = G__44132;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44117),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44114(cljs.core.chunk_rest(s__44115__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44117),null);
}
} else {
var vec__44129 = cljs.core.first(s__44115__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44129,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44129,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__44114(cljs.core.rest(s__44115__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,is_filtered_dataview_QMARK_,owner,p__44133){
var map__44143 = p__44133;
var map__44143__$1 = ((((!((map__44143 == null)))?((((map__44143.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44143.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44143):map__44143);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44143__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44143__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__44145 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__44145__$1 = ((((!((map__44145 == null)))?((((map__44145.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44145.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44145):map__44145);
var map__44146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44145__$1,cljs.core.cst$kw$table_DASH_page);
var map__44146__$1 = ((((!((map__44146 == null)))?((((map__44146.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44146.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44146):map__44146);
var map__44147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44146__$1,cljs.core.cst$kw$paging);
var map__44147__$1 = ((((!((map__44147 == null)))?((((map__44147.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44147.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44147):map__44147);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44147__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44147__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44146__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

dataview.onRowCountChanged.subscribe(((function (map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

return grid.render();
});})(map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__44151 = elem.getAttribute("data-id");
return parseInt(G__44151);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
});})(map__44145,map__44145__$1,map__44146,map__44146__$1,map__44147,map__44147__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__44143,map__44143__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__,event_chan){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,event_chan){
return (function (state_44413){
var state_val_44414 = (state_44413[(1)]);
if((state_val_44414 === (7))){
var inst_44322 = (state_44413[(7)]);
var inst_44322__$1 = (state_44413[(2)]);
var inst_44324 = (inst_44322__$1 == null);
var inst_44325 = cljs.core.not(inst_44324);
var state_44413__$1 = (function (){var statearr_44415 = state_44413;
(statearr_44415[(7)] = inst_44322__$1);

return statearr_44415;
})();
if(inst_44325){
var statearr_44416_44483 = state_44413__$1;
(statearr_44416_44483[(1)] = (8));

} else {
var statearr_44417_44484 = state_44413__$1;
(statearr_44417_44484[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (20))){
var inst_44352 = (state_44413[(8)]);
var inst_44344 = (state_44413[(9)]);
var inst_44361 = (inst_44352.cljs$core$IFn$_invoke$arity$1 ? inst_44352.cljs$core$IFn$_invoke$arity$1(inst_44344) : inst_44352.call(null,inst_44344));
var state_44413__$1 = state_44413;
var statearr_44418_44485 = state_44413__$1;
(statearr_44418_44485[(2)] = inst_44361);

(statearr_44418_44485[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (27))){
var state_44413__$1 = state_44413;
var statearr_44419_44486 = state_44413__$1;
(statearr_44419_44486[(2)] = null);

(statearr_44419_44486[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (1))){
var state_44413__$1 = state_44413;
var statearr_44420_44487 = state_44413__$1;
(statearr_44420_44487[(2)] = null);

(statearr_44420_44487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (24))){
var state_44413__$1 = state_44413;
var statearr_44421_44488 = state_44413__$1;
(statearr_44421_44488[(2)] = null);

(statearr_44421_44488[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (4))){
var state_44413__$1 = state_44413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44413__$1,(7),event_chan);
} else {
if((state_val_44414 === (15))){
var inst_44322 = (state_44413[(7)]);
var state_44413__$1 = state_44413;
var statearr_44422_44489 = state_44413__$1;
(statearr_44422_44489[(2)] = inst_44322);

(statearr_44422_44489[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (21))){
var state_44413__$1 = state_44413;
var statearr_44423_44490 = state_44413__$1;
(statearr_44423_44490[(2)] = null);

(statearr_44423_44490[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (31))){
var inst_44348 = (state_44413[(10)]);
var inst_44386 = (state_44413[(2)]);
var inst_44387 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_44348,cljs.core.cst$kw$table);
var state_44413__$1 = (function (){var statearr_44424 = state_44413;
(statearr_44424[(11)] = inst_44386);

return statearr_44424;
})();
if(inst_44387){
var statearr_44425_44491 = state_44413__$1;
(statearr_44425_44491[(1)] = (32));

} else {
var statearr_44426_44492 = state_44413__$1;
(statearr_44426_44492[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (32))){
var inst_44343 = (state_44413[(12)]);
var inst_44345 = (state_44413[(13)]);
var inst_44348 = (state_44413[(10)]);
var inst_44353 = (state_44413[(14)]);
var inst_44342 = (state_44413[(15)]);
var inst_44352 = (state_44413[(8)]);
var inst_44347 = (state_44413[(16)]);
var inst_44344 = (state_44413[(9)]);
var inst_44346 = (state_44413[(17)]);
var inst_44400 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_44401 = (function (){var new_columns = inst_44347;
var submission_clicked = inst_44344;
var submission_unclicked = inst_44345;
var c__12301__auto____$1 = inst_44400;
var get_submission_data = inst_44353;
var re_render = inst_44348;
var update_data_BANG_ = inst_44352;
var submission_to_rank = inst_44343;
var filter_by = inst_44346;
var map__44320 = inst_44342;
return ((function (new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__44320,inst_44343,inst_44345,inst_44348,inst_44353,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44400,state_val_44414,c__12301__auto__,event_chan){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__44320,inst_44343,inst_44345,inst_44348,inst_44353,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44400,state_val_44414,c__12301__auto__,event_chan){
return (function (state_44398){
var state_val_44399 = (state_44398[(1)]);
if((state_val_44399 === (1))){
var inst_44389 = cljs.core.async.timeout((20));
var state_44398__$1 = state_44398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44398__$1,(2),inst_44389);
} else {
if((state_val_44399 === (2))){
var inst_44391 = (state_44398[(2)]);
var inst_44392 = grid.resizeCanvas();
var inst_44393 = grid.invalidateAllRows();
var inst_44394 = hatti.views.table.resizeColumns(grid);
var inst_44395 = grid.render();
var inst_44396 = hatti.views.table.init_sg_pager(grid,dataview);
var state_44398__$1 = (function (){var statearr_44427 = state_44398;
(statearr_44427[(7)] = inst_44392);

(statearr_44427[(8)] = inst_44395);

(statearr_44427[(9)] = inst_44394);

(statearr_44427[(10)] = inst_44393);

(statearr_44427[(11)] = inst_44391);

return statearr_44427;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_44398__$1,inst_44396);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__44320,inst_44343,inst_44345,inst_44348,inst_44353,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44400,state_val_44414,c__12301__auto__,event_chan))
;
return ((function (switch__12189__auto__,new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__44320,inst_44343,inst_44345,inst_44348,inst_44353,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44400,state_val_44414,c__12301__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____0 = (function (){
var statearr_44431 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44431[(0)] = hatti$views$table$handle_table_events_$_state_machine__12190__auto__);

(statearr_44431[(1)] = (1));

return statearr_44431;
});
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____1 = (function (state_44398){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_44398);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e44432){if((e44432 instanceof Object)){
var ex__12193__auto__ = e44432;
var statearr_44433_44493 = state_44398;
(statearr_44433_44493[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44398);

return cljs.core.cst$kw$recur;
} else {
throw e44432;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__44494 = state_44398;
state_44398 = G__44494;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = function(state_44398){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____1.call(this,state_44398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__44320,inst_44343,inst_44345,inst_44348,inst_44353,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44400,state_val_44414,c__12301__auto__,event_chan))
})();
var state__12303__auto__ = (function (){var statearr_44434 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_44434[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto____$1);

return statearr_44434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,c__12301__auto____$1,get_submission_data,re_render,update_data_BANG_,submission_to_rank,filter_by,map__44320,inst_44343,inst_44345,inst_44348,inst_44353,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44400,state_val_44414,c__12301__auto__,event_chan))
})();
var inst_44402 = cljs.core.async.impl.dispatch.run(inst_44401);
var state_44413__$1 = (function (){var statearr_44435 = state_44413;
(statearr_44435[(18)] = inst_44402);

return statearr_44435;
})();
var statearr_44436_44495 = state_44413__$1;
(statearr_44436_44495[(2)] = inst_44400);

(statearr_44436_44495[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (33))){
var state_44413__$1 = state_44413;
var statearr_44437_44496 = state_44413__$1;
(statearr_44437_44496[(2)] = null);

(statearr_44437_44496[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (13))){
var inst_44334 = (state_44413[(2)]);
var state_44413__$1 = state_44413;
var statearr_44438_44497 = state_44413__$1;
(statearr_44438_44497[(2)] = inst_44334);

(statearr_44438_44497[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (22))){
var inst_44345 = (state_44413[(13)]);
var inst_44364 = (state_44413[(2)]);
var state_44413__$1 = (function (){var statearr_44439 = state_44413;
(statearr_44439[(19)] = inst_44364);

return statearr_44439;
})();
if(cljs.core.truth_(inst_44345)){
var statearr_44440_44498 = state_44413__$1;
(statearr_44440_44498[(1)] = (23));

} else {
var statearr_44441_44499 = state_44413__$1;
(statearr_44441_44499[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (29))){
var inst_44346 = (state_44413[(17)]);
var inst_44378 = [cljs.core.cst$kw$query];
var inst_44379 = [inst_44346];
var inst_44380 = cljs.core.PersistentHashMap.fromArrays(inst_44378,inst_44379);
var inst_44381 = cljs.core.clj__GT_js(inst_44380);
var inst_44382 = dataview.setFilterArgs(inst_44381);
var inst_44383 = dataview.refresh();
var state_44413__$1 = (function (){var statearr_44442 = state_44413;
(statearr_44442[(20)] = inst_44382);

return statearr_44442;
})();
var statearr_44443_44500 = state_44413__$1;
(statearr_44443_44500[(2)] = inst_44383);

(statearr_44443_44500[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (6))){
var inst_44409 = (state_44413[(2)]);
var state_44413__$1 = state_44413;
var statearr_44444_44501 = state_44413__$1;
(statearr_44444_44501[(2)] = inst_44409);

(statearr_44444_44501[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (28))){
var inst_44346 = (state_44413[(17)]);
var inst_44376 = (state_44413[(2)]);
var state_44413__$1 = (function (){var statearr_44445 = state_44413;
(statearr_44445[(21)] = inst_44376);

return statearr_44445;
})();
if(cljs.core.truth_(inst_44346)){
var statearr_44446_44502 = state_44413__$1;
(statearr_44446_44502[(1)] = (29));

} else {
var statearr_44447_44503 = state_44413__$1;
(statearr_44447_44503[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (25))){
var inst_44347 = (state_44413[(16)]);
var inst_44369 = (state_44413[(2)]);
var state_44413__$1 = (function (){var statearr_44448 = state_44413;
(statearr_44448[(22)] = inst_44369);

return statearr_44448;
})();
if(cljs.core.truth_(inst_44347)){
var statearr_44449_44504 = state_44413__$1;
(statearr_44449_44504[(1)] = (26));

} else {
var statearr_44450_44505 = state_44413__$1;
(statearr_44450_44505[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (34))){
var inst_44405 = (state_44413[(2)]);
var state_44413__$1 = (function (){var statearr_44451 = state_44413;
(statearr_44451[(23)] = inst_44405);

return statearr_44451;
})();
var statearr_44452_44506 = state_44413__$1;
(statearr_44452_44506[(2)] = null);

(statearr_44452_44506[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (17))){
var inst_44343 = (state_44413[(12)]);
var inst_44353 = (state_44413[(14)]);
var inst_44352 = (state_44413[(8)]);
var inst_44355 = (inst_44353.cljs$core$IFn$_invoke$arity$2 ? inst_44353.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_44343) : inst_44353.call(null,hatti.constants._rank,inst_44343));
var inst_44356 = (inst_44352.cljs$core$IFn$_invoke$arity$1 ? inst_44352.cljs$core$IFn$_invoke$arity$1(inst_44355) : inst_44352.call(null,inst_44355));
var state_44413__$1 = state_44413;
var statearr_44453_44507 = state_44413__$1;
(statearr_44453_44507[(2)] = inst_44356);

(statearr_44453_44507[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (3))){
var inst_44411 = (state_44413[(2)]);
var state_44413__$1 = state_44413;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44413__$1,inst_44411);
} else {
if((state_val_44414 === (12))){
var state_44413__$1 = state_44413;
var statearr_44454_44508 = state_44413__$1;
(statearr_44454_44508[(2)] = false);

(statearr_44454_44508[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (2))){
var state_44413__$1 = state_44413;
var statearr_44455_44509 = state_44413__$1;
(statearr_44455_44509[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (23))){
var inst_44352 = (state_44413[(8)]);
var inst_44366 = (inst_44352.cljs$core$IFn$_invoke$arity$1 ? inst_44352.cljs$core$IFn$_invoke$arity$1(null) : inst_44352.call(null,null));
var state_44413__$1 = state_44413;
var statearr_44457_44510 = state_44413__$1;
(statearr_44457_44510[(2)] = inst_44366);

(statearr_44457_44510[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (19))){
var inst_44344 = (state_44413[(9)]);
var inst_44359 = (state_44413[(2)]);
var state_44413__$1 = (function (){var statearr_44458 = state_44413;
(statearr_44458[(24)] = inst_44359);

return statearr_44458;
})();
if(cljs.core.truth_(inst_44344)){
var statearr_44459_44511 = state_44413__$1;
(statearr_44459_44511[(1)] = (20));

} else {
var statearr_44460_44512 = state_44413__$1;
(statearr_44460_44512[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (11))){
var state_44413__$1 = state_44413;
var statearr_44461_44513 = state_44413__$1;
(statearr_44461_44513[(2)] = true);

(statearr_44461_44513[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (9))){
var state_44413__$1 = state_44413;
var statearr_44462_44514 = state_44413__$1;
(statearr_44462_44514[(2)] = false);

(statearr_44462_44514[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (5))){
var state_44413__$1 = state_44413;
var statearr_44463_44515 = state_44413__$1;
(statearr_44463_44515[(2)] = null);

(statearr_44463_44515[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (14))){
var inst_44322 = (state_44413[(7)]);
var inst_44339 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_44322);
var state_44413__$1 = state_44413;
var statearr_44464_44516 = state_44413__$1;
(statearr_44464_44516[(2)] = inst_44339);

(statearr_44464_44516[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (26))){
var inst_44347 = (state_44413[(16)]);
var inst_44371 = grid.setColumns(inst_44347);
var inst_44372 = hatti.views.table.resizeColumns(grid);
var inst_44373 = grid.render();
var state_44413__$1 = (function (){var statearr_44465 = state_44413;
(statearr_44465[(25)] = inst_44371);

(statearr_44465[(26)] = inst_44372);

return statearr_44465;
})();
var statearr_44466_44517 = state_44413__$1;
(statearr_44466_44517[(2)] = inst_44373);

(statearr_44466_44517[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (16))){
var inst_44343 = (state_44413[(12)]);
var inst_44345 = (state_44413[(13)]);
var inst_44348 = (state_44413[(10)]);
var inst_44342 = (state_44413[(15)]);
var inst_44352 = (state_44413[(8)]);
var inst_44347 = (state_44413[(16)]);
var inst_44344 = (state_44413[(9)]);
var inst_44346 = (state_44413[(17)]);
var inst_44342__$1 = (state_44413[(2)]);
var inst_44343__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44342__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_44344__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44342__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_44345__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44342__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_44346__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44342__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_44347__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44342__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_44348__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44342__$1,cljs.core.cst$kw$re_DASH_render);
var inst_44349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_44350 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_44351 = (new cljs.core.PersistentVector(null,3,(5),inst_44349,inst_44350,null));
var inst_44352__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_44351);
var inst_44353 = (function (){var map__44320 = inst_44342__$1;
var submission_to_rank = inst_44343__$1;
var submission_clicked = inst_44344__$1;
var submission_unclicked = inst_44345__$1;
var filter_by = inst_44346__$1;
var new_columns = inst_44347__$1;
var re_render = inst_44348__$1;
var update_data_BANG_ = inst_44352__$1;
return ((function (map__44320,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44343,inst_44345,inst_44348,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44342__$1,inst_44343__$1,inst_44344__$1,inst_44345__$1,inst_44346__$1,inst_44347__$1,inst_44348__$1,inst_44349,inst_44350,inst_44351,inst_44352__$1,state_val_44414,c__12301__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__44320,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44343,inst_44345,inst_44348,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44342__$1,inst_44343__$1,inst_44344__$1,inst_44345__$1,inst_44346__$1,inst_44347__$1,inst_44348__$1,inst_44349,inst_44350,inst_44351,inst_44352__$1,state_val_44414,c__12301__auto__,event_chan){
return (function (p1__44152_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__44152_SHARP_,field));
});})(map__44320,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44343,inst_44345,inst_44348,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44342__$1,inst_44343__$1,inst_44344__$1,inst_44345__$1,inst_44346__$1,inst_44347__$1,inst_44348__$1,inst_44349,inst_44350,inst_44351,inst_44352__$1,state_val_44414,c__12301__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__44320,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_44343,inst_44345,inst_44348,inst_44342,inst_44352,inst_44347,inst_44344,inst_44346,inst_44342__$1,inst_44343__$1,inst_44344__$1,inst_44345__$1,inst_44346__$1,inst_44347__$1,inst_44348__$1,inst_44349,inst_44350,inst_44351,inst_44352__$1,state_val_44414,c__12301__auto__,event_chan))
})();
var state_44413__$1 = (function (){var statearr_44467 = state_44413;
(statearr_44467[(12)] = inst_44343__$1);

(statearr_44467[(13)] = inst_44345__$1);

(statearr_44467[(10)] = inst_44348__$1);

(statearr_44467[(14)] = inst_44353);

(statearr_44467[(15)] = inst_44342__$1);

(statearr_44467[(8)] = inst_44352__$1);

(statearr_44467[(16)] = inst_44347__$1);

(statearr_44467[(9)] = inst_44344__$1);

(statearr_44467[(17)] = inst_44346__$1);

return statearr_44467;
})();
if(cljs.core.truth_(inst_44343__$1)){
var statearr_44468_44518 = state_44413__$1;
(statearr_44468_44518[(1)] = (17));

} else {
var statearr_44469_44519 = state_44413__$1;
(statearr_44469_44519[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (30))){
var state_44413__$1 = state_44413;
var statearr_44470_44520 = state_44413__$1;
(statearr_44470_44520[(2)] = null);

(statearr_44470_44520[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (10))){
var inst_44337 = (state_44413[(2)]);
var state_44413__$1 = state_44413;
if(cljs.core.truth_(inst_44337)){
var statearr_44471_44521 = state_44413__$1;
(statearr_44471_44521[(1)] = (14));

} else {
var statearr_44472_44522 = state_44413__$1;
(statearr_44472_44522[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (18))){
var state_44413__$1 = state_44413;
var statearr_44473_44523 = state_44413__$1;
(statearr_44473_44523[(2)] = null);

(statearr_44473_44523[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44414 === (8))){
var inst_44322 = (state_44413[(7)]);
var inst_44327 = inst_44322.cljs$lang$protocol_mask$partition0$;
var inst_44328 = (inst_44327 & (64));
var inst_44329 = inst_44322.cljs$core$ISeq$;
var inst_44330 = (inst_44328) || (inst_44329);
var state_44413__$1 = state_44413;
if(cljs.core.truth_(inst_44330)){
var statearr_44474_44524 = state_44413__$1;
(statearr_44474_44524[(1)] = (11));

} else {
var statearr_44475_44525 = state_44413__$1;
(statearr_44475_44525[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__,event_chan))
;
return ((function (switch__12189__auto__,c__12301__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____0 = (function (){
var statearr_44479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44479[(0)] = hatti$views$table$handle_table_events_$_state_machine__12190__auto__);

(statearr_44479[(1)] = (1));

return statearr_44479;
});
var hatti$views$table$handle_table_events_$_state_machine__12190__auto____1 = (function (state_44413){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_44413);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e44480){if((e44480 instanceof Object)){
var ex__12193__auto__ = e44480;
var statearr_44481_44526 = state_44413;
(statearr_44481_44526[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44413);

return cljs.core.cst$kw$recur;
} else {
throw e44480;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__44527 = state_44413;
state_44413 = G__44527;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12190__auto__ = function(state_44413){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12190__auto____1.call(this,state_44413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12190__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,event_chan))
})();
var state__12303__auto__ = (function (){var statearr_44482 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_44482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_44482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__,event_chan))
);

return c__12301__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$name_DASH_or_DASH_label,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__44546(s__44547){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__44547__$1 = s__44547;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__44547__$1);
if(temp__4657__auto__){
var s__44547__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44547__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__44547__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__44549 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__44548 = (0);
while(true){
if((i__44548 < size__7188__auto__)){
var vec__44558 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__44548);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44558,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44558,(1),null);
cljs.core.chunk_append(b__44549,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__44548,vec__44558,k,v,c__7187__auto__,size__7188__auto__,b__44549,s__44547__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__44548,vec__44558,k,v,c__7187__auto__,size__7188__auto__,b__44549,s__44547__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__44564 = (i__44548 + (1));
i__44548 = G__44564;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44549),hatti$views$table$render_options_$_iter__44546(cljs.core.chunk_rest(s__44547__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44549),null);
}
} else {
var vec__44561 = cljs.core.first(s__44547__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44561,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44561,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__44561,k,v,s__44547__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__44561,k,v,s__44547__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__44546(cljs.core.rest(s__44547__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__44566,owner){
var map__44567 = p__44566;
var map__44567__$1 = ((((!((map__44567 == null)))?((((map__44567.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44567.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44567):map__44567);
var cursor = map__44567__$1;
var map__44568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44567__$1,cljs.core.cst$kw$table_DASH_page);
var map__44568__$1 = ((((!((map__44568 == null)))?((((map__44568.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44568.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44568):map__44568);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44568__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
if(typeof hatti.views.table.t_hatti$views$table44571 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44571 = (function (p__44566,owner,map__44567,cursor,map__44568,hide_actions_column_QMARK_,meta44572){
this.p__44566 = p__44566;
this.owner = owner;
this.map__44567 = map__44567;
this.cursor = cursor;
this.map__44568 = map__44568;
this.hide_actions_column_QMARK_ = hide_actions_column_QMARK_;
this.meta44572 = meta44572;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44571.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (_44573,meta44572__$1){
var self__ = this;
var _44573__$1 = this;
return (new hatti.views.table.t_hatti$views$table44571(self__.p__44566,self__.owner,self__.map__44567,self__.cursor,self__.map__44568,self__.hide_actions_column_QMARK_,meta44572__$1));
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44571.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (_44573){
var self__ = this;
var _44573__$1 = this;
return self__.meta44572;
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44571.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table44571.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name_DASH_or_DASH_label,cljs.core.cst$kw$label], null);
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44571.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table44571.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (_,p__44574){
var self__ = this;
var map__44575 = p__44574;
var map__44575__$1 = ((((!((map__44575 == null)))?((((map__44575.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44575.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44575):map__44575);
var name_or_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44575__$1,cljs.core.cst$kw$name_DASH_or_DASH_label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44575__$1,cljs.core.cst$kw$language);
var ___$1 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__44577 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__44577__$1 = ((((!((map__44577 == null)))?((((map__44577.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44577.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44577):map__44577);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44577__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__44577,map__44577__$1,flat_form,new_language,___$1,map__44575,map__44575__$1,name_or_label,language,map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (p1__44565_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__44565_SHARP_),cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,self__.hide_actions_column_QMARK_,cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__44577,map__44577__$1,flat_form,new_language,___$1,map__44575,map__44575__$1,name_or_label,language,map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(name_or_label);
} else {
}

var G__44586 = ({"className": "label-changer"});
var G__44587 = (function (){var G__44589 = ({"className": "label-changer-label"});
var G__44590 = "Show:";
return React.DOM.span(G__44589,G__44590);
})();
var G__44588 = (function (){var G__44591 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__44592 = (function (){var attrs44581 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(name_or_label) : options.call(null,name_or_label));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs44581))?sablono.interpreter.attributes(attrs44581):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs44581))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__44594 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__44594);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs44581),(function (){var G__44595 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__44595);
})()], null))));
})();
var G__44593 = (function (){var G__44596 = ({"className": "submenu no-dot"});
var G__44597 = sablono.interpreter.interpret(hatti.views.table.render_options(options,self__.owner,colset_BANG_));
return React.DOM.ul(G__44596,G__44597);
})();
return React.DOM.div(G__44591,G__44592,G__44593);
})();
return React.DOM.div(G__44586,G__44587,G__44588);
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44571.getBasis = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__44566,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__44567,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__44568,cljs.core.cst$sym$hide_DASH_actions_DASH_column_QMARK_,cljs.core.cst$sym$meta44572], null);
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

hatti.views.table.t_hatti$views$table44571.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44571.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44571";

hatti.views.table.t_hatti$views$table44571.cljs$lang$ctorPrWriter = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44571");
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

hatti.views.table.__GT_t_hatti$views$table44571 = ((function (map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_){
return (function hatti$views$table$__GT_t_hatti$views$table44571(p__44566__$1,owner__$1,map__44567__$2,cursor__$1,map__44568__$2,hide_actions_column_QMARK___$1,meta44572){
return (new hatti.views.table.t_hatti$views$table44571(p__44566__$1,owner__$1,map__44567__$2,cursor__$1,map__44568__$2,hide_actions_column_QMARK___$1,meta44572));
});})(map__44567,map__44567__$1,cursor,map__44568,map__44568__$1,hide_actions_column_QMARK_))
;

}

return (new hatti.views.table.t_hatti$views$table44571(p__44566,owner,map__44567__$1,cursor,map__44568__$1,hide_actions_column_QMARK_,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__,query){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,query){
return (function (state_44640){
var state_val_44641 = (state_44640[(1)]);
if((state_val_44641 === (1))){
var inst_44626 = cljs.core.async.timeout((150));
var state_44640__$1 = state_44640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44640__$1,(2),inst_44626);
} else {
if((state_val_44641 === (2))){
var inst_44628 = (state_44640[(2)]);
var inst_44629 = input.value;
var inst_44630 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_44629);
var state_44640__$1 = (function (){var statearr_44642 = state_44640;
(statearr_44642[(7)] = inst_44628);

return statearr_44642;
})();
if(inst_44630){
var statearr_44643_44654 = state_44640__$1;
(statearr_44643_44654[(1)] = (3));

} else {
var statearr_44644_44655 = state_44640__$1;
(statearr_44644_44655[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44641 === (3))){
var inst_44632 = [query_event_key];
var inst_44633 = [query];
var inst_44634 = cljs.core.PersistentHashMap.fromArrays(inst_44632,inst_44633);
var inst_44635 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_44634);
var state_44640__$1 = state_44640;
var statearr_44645_44656 = state_44640__$1;
(statearr_44645_44656[(2)] = inst_44635);

(statearr_44645_44656[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44641 === (4))){
var state_44640__$1 = state_44640;
var statearr_44646_44657 = state_44640__$1;
(statearr_44646_44657[(2)] = null);

(statearr_44646_44657[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44641 === (5))){
var inst_44638 = (state_44640[(2)]);
var state_44640__$1 = state_44640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44640__$1,inst_44638);
} else {
return null;
}
}
}
}
}
});})(c__12301__auto__,query))
;
return ((function (switch__12189__auto__,c__12301__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12190__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12190__auto____0 = (function (){
var statearr_44650 = [null,null,null,null,null,null,null,null];
(statearr_44650[(0)] = hatti$views$table$delayed_search_$_state_machine__12190__auto__);

(statearr_44650[(1)] = (1));

return statearr_44650;
});
var hatti$views$table$delayed_search_$_state_machine__12190__auto____1 = (function (state_44640){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_44640);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e44651){if((e44651 instanceof Object)){
var ex__12193__auto__ = e44651;
var statearr_44652_44658 = state_44640;
(statearr_44652_44658[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_44640);

return cljs.core.cst$kw$recur;
} else {
throw e44651;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__44659 = state_44640;
state_44640 = G__44659;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12190__auto__ = function(state_44640){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12190__auto____1.call(this,state_44640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12190__auto____0;
hatti$views$table$delayed_search_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12190__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,query))
})();
var state__12303__auto__ = (function (){var statearr_44653 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_44653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_44653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__,query))
);

return c__12301__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table44661 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44661 = (function (_,owner,meta44662){
this._ = _;
this.owner = owner;
this.meta44662 = meta44662;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44661.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44663,meta44662__$1){
var self__ = this;
var _44663__$1 = this;
return (new hatti.views.table.t_hatti$views$table44661(self__._,self__.owner,meta44662__$1));
});

hatti.views.table.t_hatti$views$table44661.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44663){
var self__ = this;
var _44663__$1 = this;
return self__.meta44662;
});

hatti.views.table.t_hatti$views$table44661.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table44661.prototype.om$core$IRender$render$arity$1 = (function (this__18161__auto__){
var self__ = this;
var this__18161__auto____$1 = this;
var G__44666 = ({"className": "table-search"});
var G__44667 = (function (){var G__44669 = ({"className": "fa fa-search"});
return React.DOM.i(G__44669);
})();
var G__44668 = (function (){var G__44670 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__44666,G__44667,this__18161__auto____$1){
return (function (p1__44660_SHARP_){
return hatti.views.table.delayed_search(p1__44660_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__44666,G__44667,this__18161__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__44670) : sablono.interpreter.input.call(null,G__44670));
})();
return React.DOM.div(G__44666,G__44667,G__44668);
});

hatti.views.table.t_hatti$views$table44661.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44662], null);
});

hatti.views.table.t_hatti$views$table44661.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44661.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44661";

hatti.views.table.t_hatti$views$table44661.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44661");
});

hatti.views.table.__GT_t_hatti$views$table44661 = (function hatti$views$table$__GT_t_hatti$views$table44661(___$1,owner__$1,meta44662){
return (new hatti.views.table.t_hatti$views$table44661(___$1,owner__$1,meta44662));
});

}

return (new hatti.views.table.t_hatti$views$table44661(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table44671 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44671 = (function (cursor,owner,meta44672){
this.cursor = cursor;
this.owner = owner;
this.meta44672 = meta44672;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44671.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44673,meta44672__$1){
var self__ = this;
var _44673__$1 = this;
return (new hatti.views.table.t_hatti$views$table44671(self__.cursor,self__.owner,meta44672__$1));
});

hatti.views.table.t_hatti$views$table44671.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44673){
var self__ = this;
var _44673__$1 = this;
return self__.meta44672;
});

hatti.views.table.t_hatti$views$table44671.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table44671.prototype.om$core$IRender$render$arity$1 = (function (this__18161__auto__){
var self__ = this;
var this__18161__auto____$1 = this;
var G__44676 = ({"className": "topbar"});
var G__44677 = (function (){var G__44681 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__44681);
})();
var G__44678 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__44679 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__44680 = (function (){var G__44682 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__44682);
})();
return React.DOM.div(G__44676,G__44677,G__44678,G__44679,G__44680);
});

hatti.views.table.t_hatti$views$table44671.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta44672], null);
});

hatti.views.table.t_hatti$views$table44671.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44671.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44671";

hatti.views.table.t_hatti$views$table44671.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44671");
});

hatti.views.table.__GT_t_hatti$views$table44671 = (function hatti$views$table$__GT_t_hatti$views$table44671(cursor__$1,owner__$1,meta44672){
return (new hatti.views.table.t_hatti$views$table44671(cursor__$1,owner__$1,meta44672));
});

}

return (new hatti.views.table.t_hatti$views$table44671(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__44688 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__44688__$1 = ((((!((map__44688 == null)))?((((map__44688.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44688.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44688):map__44688);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44688__$1,cljs.core.cst$kw$flat_DASH_form);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44688__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__44689 = hatti.views.table.sg_init(data,flat_form,current_language,is_filtered_dataview_QMARK_,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44689,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44689,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__44694,owner,p__44695){
var map__44696 = p__44694;
var map__44696__$1 = ((((!((map__44696 == null)))?((((map__44696.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44696.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44696):map__44696);
var cursor = map__44696__$1;
var map__44697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44696__$1,cljs.core.cst$kw$views);
var map__44697__$1 = ((((!((map__44697 == null)))?((((map__44697.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44697.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44697):map__44697);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44697__$1,cljs.core.cst$kw$active);
var map__44698 = p__44695;
var map__44698__$1 = ((((!((map__44698 == null)))?((((map__44698.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44698.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44698):map__44698);
var opts = map__44698__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44698__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table44702 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table44702 = (function (owner,active_QMARK_,slick_grid_event_handlers,map__44698,map__44697,cursor,map__44696,active,opts,p__44694,p__44695,meta44703){
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__44698 = map__44698;
this.map__44697 = map__44697;
this.cursor = cursor;
this.map__44696 = map__44696;
this.active = active;
this.opts = opts;
this.p__44694 = p__44694;
this.p__44695 = p__44695;
this.meta44703 = meta44703;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table44702.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (_44704,meta44703__$1){
var self__ = this;
var _44704__$1 = this;
return (new hatti.views.table.t_hatti$views$table44702(self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.map__44698,self__.map__44697,self__.cursor,self__.map__44696,self__.active,self__.opts,self__.p__44694,self__.p__44695,meta44703__$1));
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (_44704){
var self__ = this;
var _44704__$1 = this;
return self__.meta44703;
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (_,p__44705){
var self__ = this;
var map__44706 = p__44705;
var map__44706__$1 = ((((!((map__44706 == null)))?((((map__44706.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44706.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44706):map__44706);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44706__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__44708 = self__.cursor;
var map__44708__$1 = ((((!((map__44708 == null)))?((((map__44708.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44708.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44708):map__44708);
var map__44709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44708__$1,cljs.core.cst$kw$table_DASH_page);
var map__44709__$1 = ((((!((map__44709 == null)))?((((map__44709.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44709.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44709):map__44709);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44709__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44709__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44708__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44708__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__44710 = dataset_info;
var map__44710__$1 = ((((!((map__44710 == null)))?((((map__44710.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44710.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44710):map__44710);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44710__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__44708,map__44708__$1,map__44709,map__44709__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__44710,map__44710__$1,num_of_submissions,no_data_QMARK_,___$1,map__44706,map__44706__$1,table_view_height,active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (p1__44693_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__44693_SHARP_], 0));
});})(map__44708,map__44708__$1,map__44709,map__44709__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__44710,map__44710__$1,num_of_submissions,no_data_QMARK_,___$1,map__44706,map__44706__$1,table_view_height,active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__44714 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__44715 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__44716 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__44717 = (function (){var G__44718 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__44719 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__44724 = ({"className": "alert alert-warning"});
var G__44725 = "No data";
return React.DOM.p(G__44724,G__44725);
})():(function (){var G__44726 = null;
var G__44727 = (function (){var G__44729 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__44729);
})();
var G__44728 = "Loading...";
return React.DOM.span(G__44726,G__44727,G__44728);
})());
return React.DOM.div(G__44718,G__44719);
})();
return React.DOM.div(G__44714,G__44715,G__44716,G__44717);
} else {
return null;
}
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44730 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44730,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44730,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table44702.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__44733 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__44733__$1 = ((((!((map__44733 == null)))?((((map__44733.cljs$lang$protocol_mask$partition0$ & (64))) || (map__44733.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44733):map__44733);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44733__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44733__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__44735 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44735,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44735,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.getBasis = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__44698,cljs.core.cst$sym$map__44697,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__44696,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$p__44694,cljs.core.cst$sym$p__44695,cljs.core.cst$sym$meta44703], null);
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table44702.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table44702.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table44702";

hatti.views.table.t_hatti$views$table44702.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table44702");
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table44702 = ((function (active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table44702(owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__44698__$2,map__44697__$2,cursor__$1,map__44696__$2,active__$1,opts__$1,p__44694__$1,p__44695__$1,meta44703){
return (new hatti.views.table.t_hatti$views$table44702(owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,map__44698__$2,map__44697__$2,cursor__$1,map__44696__$2,active__$1,opts__$1,p__44694__$1,p__44695__$1,meta44703));
});})(active_QMARK_,map__44696,map__44696__$1,cursor,map__44697,map__44697__$1,active,map__44698,map__44698__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table44702(owner,active_QMARK_,slick_grid_event_handlers,map__44698__$1,map__44697__$1,cursor,map__44696__$1,active,opts,p__44694,p__44695,cljs.core.PersistentArrayMap.EMPTY));
}));
