// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__40906__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__40906 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__40907__i = 0, G__40907__a = new Array(arguments.length -  0);
while (G__40907__i < G__40907__a.length) {G__40907__a[G__40907__i] = arguments[G__40907__i + 0]; ++G__40907__i;}
  children = new cljs.core.IndexedSeq(G__40907__a,0);
} 
return G__40906__delegate.call(this,children);};
G__40906.cljs$lang$maxFixedArity = 0;
G__40906.cljs$lang$applyTo = (function (arglist__40908){
var children = cljs.core.seq(arglist__40908);
return G__40906__delegate(children);
});
G__40906.cljs$core$IFn$_invoke$arity$variadic = G__40906__delegate;
return G__40906;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__40917 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__40917) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__40918 = cljs.core._EQ_;
var expr__40919 = view;
if(cljs.core.truth_((function (){var G__40921 = cljs.core.cst$kw$map;
var G__40922 = expr__40919;
return (pred__40918.cljs$core$IFn$_invoke$arity$2 ? pred__40918.cljs$core$IFn$_invoke$arity$2(G__40921,G__40922) : pred__40918.call(null,G__40921,G__40922));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__40923 = cljs.core.cst$kw$table;
var G__40924 = expr__40919;
return (pred__40918.cljs$core$IFn$_invoke$arity$2 ? pred__40918.cljs$core$IFn$_invoke$arity$2(G__40923,G__40924) : pred__40918.call(null,G__40923,G__40924));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__40919)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$pure_DASH_button$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$btn_DASH_close$right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record40926 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40926 = (function (cursor,owner,meta40927){
this.cursor = cursor;
this.owner = owner;
this.meta40927 = meta40927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40928,meta40927__$1){
var self__ = this;
var _40928__$1 = this;
return (new hatti.views.record.t_hatti$views$record40926(self__.cursor,self__.owner,meta40927__$1));
});

hatti.views.record.t_hatti$views$record40926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40928){
var self__ = this;
var _40928__$1 = this;
return self__.meta40927;
});

hatti.views.record.t_hatti$views$record40926.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record40926.prototype.om$core$IRender$render$arity$1 = (function (this__18161__auto__){
var self__ = this;
var this__18161__auto____$1 = this;
var G__40931 = ({"id": "print-xls-report"});
return React.DOM.div(G__40931);
});

hatti.views.record.t_hatti$views$record40926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40927], null);
});

hatti.views.record.t_hatti$views$record40926.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40926.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40926";

hatti.views.record.t_hatti$views$record40926.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40926");
});

hatti.views.record.__GT_t_hatti$views$record40926 = (function hatti$views$record$__GT_t_hatti$views$record40926(cursor__$1,owner__$1,meta40927){
return (new hatti.views.record.t_hatti$views$record40926(cursor__$1,owner__$1,meta40927));
});

}

return (new hatti.views.record.t_hatti$views$record40926(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,answer,cljs.core.array_seq([cljs.core.cst$kw$language,lang], 0));
var map__40934 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__40934__$1 = ((((!((map__40934 == null)))?((((map__40934.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40934.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40934):map__40934);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40934__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40934__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40934__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__40936__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__40936 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__40937__i = 0, G__40937__a = new Array(arguments.length -  0);
while (G__40937__i < G__40937__a.length) {G__40937__a[G__40937__i] = arguments[G__40937__i + 0]; ++G__40937__i;}
  tbody = new cljs.core.IndexedSeq(G__40937__a,0);
} 
return G__40936__delegate.call(this,tbody);};
G__40936.cljs$lang$maxFixedArity = 0;
G__40936.cljs$lang$applyTo = (function (arglist__40938){
var tbody = cljs.core.seq(arglist__40938);
return G__40936__delegate(tbody);
});
G__40936.cljs$core$IFn$_invoke$arity$variadic = G__40936__delegate;
return G__40936;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__40940,owner,p__40941){
var map__40942 = p__40940;
var map__40942__$1 = ((((!((map__40942 == null)))?((((map__40942.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40942.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40942):map__40942);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40942__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40942__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40942__$1,cljs.core.cst$kw$lang);
var map__40943 = p__40941;
var map__40943__$1 = ((((!((map__40943 == null)))?((((map__40943.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40943.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40943):map__40943);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40943__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record40946 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40946 = (function (p__40940,owner,p__40941,map__40942,data,repeat_field,lang,map__40943,view,meta40947){
this.p__40940 = p__40940;
this.owner = owner;
this.p__40941 = p__40941;
this.map__40942 = map__40942;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__40943 = map__40943;
this.view = view;
this.meta40947 = meta40947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (_40948,meta40947__$1){
var self__ = this;
var _40948__$1 = this;
return (new hatti.views.record.t_hatti$views$record40946(self__.p__40940,self__.owner,self__.p__40941,self__.map__40942,self__.data,self__.repeat_field,self__.lang,self__.map__40943,self__.view,meta40947__$1));
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

hatti.views.record.t_hatti$views$record40946.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (_40948){
var self__ = this;
var _40948__$1 = this;
return self__.meta40947;
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

hatti.views.record.t_hatti$views$record40946.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record40946.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

hatti.views.record.t_hatti$views$record40946.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record40946.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (_,p__40949){
var self__ = this;
var map__40950 = p__40949;
var map__40950__$1 = ((((!((map__40950 == null)))?((((map__40950.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40950.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40950):map__40950);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40950__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (p1__40939_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__40939_SHARP_);
});})(___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;
var map__40952 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__40952__$1 = ((((!((map__40952 == null)))?((((map__40952.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40952.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40952):map__40952);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40952__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40952__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40952__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function hatti$views$record$iter__40954(s__40955){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (){
var s__40955__$1 = s__40955;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40955__$1);
if(temp__4657__auto__){
var s__40955__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40955__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40955__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40957 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40956 = (0);
while(true){
if((i__40956 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40956);
cljs.core.chunk_append(b__40957,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__40973 = (i__40956 + (1));
i__40956 = G__40973;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40957),hatti$views$record$iter__40954(cljs.core.chunk_rest(s__40955__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40957),null);
}
} else {
var field = cljs.core.first(s__40955__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__40954(cljs.core.rest(s__40955__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
,null,null));
});})(collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;
var tbl = ((function (collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function() { 
var G__40974__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__40974 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__40975__i = 0, G__40975__a = new Array(arguments.length -  1);
while (G__40975__i < G__40975__a.length) {G__40975__a[G__40975__i] = arguments[G__40975__i + 1]; ++G__40975__i;}
  body = new cljs.core.IndexedSeq(G__40975__a,0);
} 
return G__40974__delegate.call(this,cls,body);};
G__40974.cljs$lang$maxFixedArity = 1;
G__40974.cljs$lang$applyTo = (function (arglist__40976){
var cls = cljs.core.first(arglist__40976);
var body = cljs.core.rest(arglist__40976);
return G__40974__delegate(cls,body);
});
G__40974.cljs$core$IFn$_invoke$arity$variadic = G__40974__delegate;
return G__40974;
})()
;})(collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__40960 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__40960) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function hatti$views$record$iter__40961(s__40962){
return (new cljs.core.LazySeq(null,((function (G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (){
var s__40962__$1 = s__40962;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40962__$1);
if(temp__4657__auto__){
var s__40962__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40962__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40962__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40964 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40963 = (0);
while(true){
if((i__40963 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40963);
cljs.core.chunk_append(b__40964,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__40978 = (i__40963 + (1));
i__40963 = G__40978;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40964),hatti$views$record$iter__40961(cljs.core.chunk_rest(s__40962__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40964),null);
}
} else {
var d = cljs.core.first(s__40962__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__40961(cljs.core.rest(s__40962__$2)));
}
} else {
return null;
}
break;
}
});})(G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
,null,null));
});})(G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function hatti$views$record$iter__40967(s__40968){
return (new cljs.core.LazySeq(null,((function (G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (){
var s__40968__$1 = s__40968;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40968__$1);
if(temp__4657__auto__){
var s__40968__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40968__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40968__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40970 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40969 = (0);
while(true){
if((i__40969 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40969);
cljs.core.chunk_append(b__40970,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__40979 = (i__40969 + (1));
i__40969 = G__40979;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40970),hatti$views$record$iter__40967(cljs.core.chunk_rest(s__40968__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40970),null);
}
} else {
var d = cljs.core.first(s__40968__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__40967(cljs.core.rest(s__40968__$2)));
}
} else {
return null;
}
break;
}
});})(G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
,null,null));
});})(G__40960,collapse_BANG_,map__40952,map__40952__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40950,map__40950__$1,collapsed_QMARK_,map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

hatti.views.record.t_hatti$views$record40946.getBasis = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__40940,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40941,cljs.core.cst$sym$map__40942,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__40943,cljs.core.cst$sym$view,cljs.core.cst$sym$meta40947], null);
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

hatti.views.record.t_hatti$views$record40946.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40946.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40946";

hatti.views.record.t_hatti$views$record40946.cljs$lang$ctorPrWriter = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40946");
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record40946 = ((function (map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record40946(p__40940__$1,owner__$1,p__40941__$1,map__40942__$2,data__$1,repeat_field__$1,lang__$1,map__40943__$2,view__$1,meta40947){
return (new hatti.views.record.t_hatti$views$record40946(p__40940__$1,owner__$1,p__40941__$1,map__40942__$2,data__$1,repeat_field__$1,lang__$1,map__40943__$2,view__$1,meta40947));
});})(map__40942,map__40942__$1,data,repeat_field,lang,map__40943,map__40943__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record40946(p__40940,owner,p__40941,map__40942__$1,data,repeat_field,lang,map__40943__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__40980){
var map__40983 = p__40980;
var map__40983__$1 = ((((!((map__40983 == null)))?((((map__40983.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40983.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40983):map__40983);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40983__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40983__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__40985){
var map__40986 = p__40985;
var map__40986__$1 = ((((!((map__40986 == null)))?((((map__40986.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40986.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40986):map__40986);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40986__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record40988 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40988 = (function (instance_id,owner,p__40985,map__40986,delete_record_BANG_,meta40989){
this.instance_id = instance_id;
this.owner = owner;
this.p__40985 = p__40985;
this.map__40986 = map__40986;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta40989 = meta40989;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40988.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40986,map__40986__$1,delete_record_BANG_){
return (function (_40990,meta40989__$1){
var self__ = this;
var _40990__$1 = this;
return (new hatti.views.record.t_hatti$views$record40988(self__.instance_id,self__.owner,self__.p__40985,self__.map__40986,self__.delete_record_BANG_,meta40989__$1));
});})(map__40986,map__40986__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40988.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40986,map__40986__$1,delete_record_BANG_){
return (function (_40990){
var self__ = this;
var _40990__$1 = this;
return self__.meta40989;
});})(map__40986,map__40986__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40988.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record40988.prototype.om$core$IRender$render$arity$1 = ((function (map__40986,map__40986__$1,delete_record_BANG_){
return (function (this__18161__auto__){
var self__ = this;
var this__18161__auto____$1 = this;
return null;
});})(map__40986,map__40986__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40988.getBasis = ((function (map__40986,map__40986__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40985,cljs.core.cst$sym$map__40986,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta40989], null);
});})(map__40986,map__40986__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40988.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40988.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40988";

hatti.views.record.t_hatti$views$record40988.cljs$lang$ctorPrWriter = ((function (map__40986,map__40986__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40988");
});})(map__40986,map__40986__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record40988 = ((function (map__40986,map__40986__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record40988(instance_id__$1,owner__$1,p__40985__$1,map__40986__$2,delete_record_BANG___$1,meta40989){
return (new hatti.views.record.t_hatti$views$record40988(instance_id__$1,owner__$1,p__40985__$1,map__40986__$2,delete_record_BANG___$1,meta40989));
});})(map__40986,map__40986__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record40988(instance_id,owner,p__40985,map__40986__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__40991){
var map__40992 = p__40991;
var map__40992__$1 = ((((!((map__40992 == null)))?((((map__40992.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40992.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40992):map__40992);
var opts = map__40992__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40992__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record40994 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40994 = (function (cursor,owner,p__40991,map__40992,opts,view,meta40995){
this.cursor = cursor;
this.owner = owner;
this.p__40991 = p__40991;
this.map__40992 = map__40992;
this.opts = opts;
this.view = view;
this.meta40995 = meta40995;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40994.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40992,map__40992__$1,opts,view){
return (function (_40996,meta40995__$1){
var self__ = this;
var _40996__$1 = this;
return (new hatti.views.record.t_hatti$views$record40994(self__.cursor,self__.owner,self__.p__40991,self__.map__40992,self__.opts,self__.view,meta40995__$1));
});})(map__40992,map__40992__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40994.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40992,map__40992__$1,opts,view){
return (function (_40996){
var self__ = this;
var _40996__$1 = this;
return self__.meta40995;
});})(map__40992,map__40992__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40994.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record40994.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__40992,map__40992__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__40992,map__40992__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40994.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record40994.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__40992,map__40992__$1,opts,view){
return (function (_,p__40997){
var self__ = this;
var map__40998 = p__40997;
var map__40998__$1 = ((((!((map__40998 == null)))?((((map__40998.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40998.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40998):map__40998);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40998__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__41000 = self__.cursor;
var map__41000__$1 = ((((!((map__41000 == null)))?((((map__41000.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41000.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41000):map__41000);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41000__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41000__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41000__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__41003 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__41003);
})();
var map__41001 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__41001__$1 = ((((!((map__41001 == null)))?((((map__41001.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41001.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41001):map__41001);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41001__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41001__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41001__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41001__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41001__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41001__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__41005 = (function (){var G__41007 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__41008 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__41009 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__41010 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__41007,G__41008,G__41009,G__41010) : topbar_wrap.call(null,G__41007,G__41008,G__41009,G__41010));
})();
var G__41006 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__41011 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__41012 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__41011,G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__41011,G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__41011,G__41012) : header_wrap.call(null,G__41011,G__41012));
})(),(function (){var G__41013 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__41015 = (function (){var iter__7189__auto__ = ((function (G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view){
return (function hatti$views$record$iter__41016(s__41017){
return (new cljs.core.LazySeq(null,((function (G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view){
return (function (){
var s__41017__$1 = s__41017;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41017__$1);
if(temp__4657__auto__){
var s__41017__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41017__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41017__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41019 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41018 = (0);
while(true){
if((i__41018 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41018);
cljs.core.chunk_append(b__41019,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__41029 = (i__41018 + (1));
i__41018 = G__41029;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41019),hatti$views$record$iter__41016(cljs.core.chunk_rest(s__41017__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41019),null);
}
} else {
var q = cljs.core.first(s__41017__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__41016(cljs.core.rest(s__41017__$2)));
}
} else {
return null;
}
break;
}
});})(G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view))
,null,null));
});})(G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__41015) : section_wrap.call(null,G__41015));
})():null);
var G__41014 = (function (){var G__41022 = (function (){var iter__7189__auto__ = ((function (G__41013,G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view){
return (function hatti$views$record$iter__41023(s__41024){
return (new cljs.core.LazySeq(null,((function (G__41013,G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view){
return (function (){
var s__41024__$1 = s__41024;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41024__$1);
if(temp__4657__auto__){
var s__41024__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41024__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41024__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41026 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41025 = (0);
while(true){
if((i__41025 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41025);
cljs.core.chunk_append(b__41026,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__41030 = (i__41025 + (1));
i__41025 = G__41030;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41026),hatti$views$record$iter__41023(cljs.core.chunk_rest(s__41024__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41026),null);
}
} else {
var q = cljs.core.first(s__41024__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__41023(cljs.core.rest(s__41024__$2)));
}
} else {
return null;
}
break;
}
});})(G__41013,G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view))
,null,null));
});})(G__41013,G__41005,form,language,map__41000,map__41000__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__41001,map__41001__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40998,map__40998__$1,expand_meta_QMARK_,map__40992,map__40992__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__41022) : section_wrap.call(null,G__41022));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__41013,G__41014) : submission_info_wrap.call(null,G__41013,G__41014));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__41005,G__41006) : top_level_wrap.call(null,G__41005,G__41006));
})():null));
});})(map__40992,map__40992__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40994.getBasis = ((function (map__40992,map__40992__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40991,cljs.core.cst$sym$map__40992,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta40995], null);
});})(map__40992,map__40992__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40994.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40994.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40994";

hatti.views.record.t_hatti$views$record40994.cljs$lang$ctorPrWriter = ((function (map__40992,map__40992__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40994");
});})(map__40992,map__40992__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record40994 = ((function (map__40992,map__40992__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record40994(cursor__$1,owner__$1,p__40991__$1,map__40992__$2,opts__$1,view__$1,meta40995){
return (new hatti.views.record.t_hatti$views$record40994(cursor__$1,owner__$1,p__40991__$1,map__40992__$2,opts__$1,view__$1,meta40995));
});})(map__40992,map__40992__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record40994(cursor,owner,p__40991,map__40992__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
