// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.utils.style');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hatti.ona.forms');
/**
 * Set of CSS properties that can be modified by a user
 */
hatti.utils.style.user_customizable_styles = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["color",null], null), null);
/**
 * Saturated qualitative palette from colorbrewer.
 * Saturated red+brown disabled due to clash with the :clicked color.
 */
hatti.utils.style.qualitative_palette = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#1f78b4","#33a02c","#6a3d9a","#ffff99","#b15928","#a6cee3","#b2df8a","#fb9a99","#fdbf6f","#cab2d6"], null);
/**
 * Color palette of YlGnBl from colorbrewer.
 */
hatti.utils.style.sequential_palette = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#ffffcc","#bdd7e7","#6baed6","#3182bd","#08519c"], null);
/**
 * A Grey Color for deselected points.
 */
hatti.utils.style.grey = "#d9d9d9";
/**
 * Check if a user can customize a style
 */
hatti.utils.style.customizable_style_QMARK_ = (function hatti$utils$style$customizable_style_QMARK_(p__38625){
var vec__38629 = p__38625;
var style_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38629,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38629,(1),null);
return cljs.core.contains_QMARK_(hatti.utils.style.user_customizable_styles,style_name);
});
/**
 * Return a map of a form field answer name to CSS rules
 */
hatti.utils.style.get_css_rule_map = (function hatti$utils$style$get_css_rule_map(appearance_attribute){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__38637){
var vec__38638 = p__38637;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38638,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38638,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),value], null);
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.utils.style.customizable_style_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38632_SHARP_){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__38632_SHARP_,/:/);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(appearance_attribute,/;/)))));
});
/**
 * Return a map of answer to associated CSS rules
 */
hatti.utils.style.group_user_defined_styles_by_answer = (function hatti$utils$style$group_user_defined_styles_by_answer(p__38641){
var map__38647 = p__38641;
var map__38647__$1 = ((((!((map__38647 == null)))?((((map__38647.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38647.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38647):map__38647);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38647__$1,cljs.core.cst$kw$children);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__38647,map__38647__$1,children){
return (function (p__38649){
var map__38650 = p__38649;
var map__38650__$1 = ((((!((map__38650 == null)))?((((map__38650.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38650.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38650):map__38650);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38650__$1,cljs.core.cst$kw$name);
var appearance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38650__$1,cljs.core.cst$kw$appearance);
return cljs.core.PersistentArrayMap.fromArray([name,hatti.utils.style.get_css_rule_map(appearance)], true, false);
});})(map__38647,map__38647__$1,children))
,children));
});
/**
 * Returns only the color property of the style map, with the answer as the key
 */
hatti.utils.style.style_map__GT_color_map = (function hatti$utils$style$style_map__GT_color_map(p__38652){
var vec__38658 = p__38652;
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38658,(0),null);
var map__38661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38658,(1),null);
var map__38661__$1 = ((((!((map__38661 == null)))?((((map__38661.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38661.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38661):map__38661);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38661__$1,cljs.core.cst$kw$color);
if(cljs.core.truth_(color)){
return cljs.core.PersistentArrayMap.fromArray([answer,color], true, false);
} else {
return null;
}
});
/**
 * Return a map of answers to their associated colors
 */
hatti.utils.style.group_user_defined_colors_by_answer = (function hatti$utils$style$group_user_defined_colors_by_answer(field){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.vec(cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.utils.style.style_map__GT_color_map,hatti.utils.style.group_user_defined_styles_by_answer(field))))));
});
/**
 * Return the appropriate set of colors given the field. For a select_one,
 * returns a mapping of answer to color. Returns a string for all other field
 * types
 */
hatti.utils.style.field__GT_colors = (function hatti$utils$style$field__GT_colors(field){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
if((cljs.core.count(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)) <= cljs.core.count(hatti.utils.style.qualitative_palette))){
return hatti.utils.style.qualitative_palette;
} else {
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
}
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return hatti.utils.style.qualitative_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.utils.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.utils.style.sequential_palette;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("#f30");
} else {
return null;
}
}
}
}
}
}
});
/**
 * Given a field and set of answers, return a mapping of answer to color
 * defaulting to an inbuilt palette if the field is not a select-one or
 * any of the choices lack an appearance attribute
 */
hatti.utils.style.answer__GT_color = (function hatti$utils$style$answer__GT_color(p__38663,answers){
var map__38666 = p__38663;
var map__38666__$1 = ((((!((map__38666 == null)))?((((map__38666.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38666.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38666):map__38666);
var field = map__38666__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38666__$1,cljs.core.cst$kw$children);
if(cljs.core.truth_((function (){var and__6397__auto__ = hatti.ona.forms.select_one_QMARK_(field);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.every_QMARK_(cljs.core.cst$kw$appearance,children);
} else {
return and__6397__auto__;
}
})())){
return hatti.utils.style.group_user_defined_colors_by_answer(field);
} else {
return cljs.core.zipmap(answers,hatti.utils.style.field__GT_colors(field));
}
});
