// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.shared');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('cljs.core.async');
goog.require('sablono.core');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('hatti.utils.om.state');
goog.require('chimera.urls');
cljs.core.enable_console_print_BANG_();
hatti.shared.event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.event_multi_chan = cljs.core.async.mult(hatti.shared.event_chan);
hatti.shared.event_tap = (function hatti$shared$event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.external_event_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
hatti.shared.external_event_multi_chan = cljs.core.async.mult(hatti.shared.external_event_chan);
hatti.shared.external_event_tap = (function hatti$shared$external_event_tap(){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2(hatti.shared.external_event_multi_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
});
hatti.shared.default_fields = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,"_submission_time",cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$name,"_submission_time",cljs.core.cst$kw$type,"datetime"], null)], null);
/**
 * An initial, empty, app-state, which can be modified to change dataviews.
 */
hatti.shared.empty_app_state = (function hatti$shared$empty_app_state(){
var G__40630 = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$api_DASH_url,cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$status,cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$chart_DASH_page,cljs.core.cst$kw$languages,cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$views,cljs.core.cst$kw$data],["//api.ona.io/api/v1/",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,false], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,(0),cljs.core.cst$kw$loading_QMARK_,true], null),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_charts,hatti.shared.default_fields,cljs.core.cst$kw$chart_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$current,null,cljs.core.cst$kw$all,cljs.core.PersistentVector.EMPTY], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$submission_DASH_clicked,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,null], null),cljs.core.cst$kw$geofield,cljs.core.PersistentArrayMap.EMPTY], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chart,cljs.core.cst$kw$dashboard,cljs.core.cst$kw$map,cljs.core.cst$kw$overview,cljs.core.cst$kw$photos,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$table,cljs.core.cst$kw$user_DASH_guide], null),cljs.core.cst$kw$selected,cljs.core.cst$kw$overview,cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$basemaps,cljs.core.cst$kw$form_DASH_info,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$media_DASH_files,cljs.core.cst$kw$service_DASH_configuration,cljs.core.cst$kw$settings,cljs.core.cst$kw$xls_DASH_reports], null),cljs.core.cst$kw$active_DASH_tab,cljs.core.cst$kw$form_DASH_info,cljs.core.cst$kw$integrated_DASH_apps,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$active_DASH_section,cljs.core.cst$kw$apps_DASH_list,cljs.core.cst$kw$add_QMARK_,false], null)], null)], null),cljs.core.PersistentVector.EMPTY]);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40630) : cljs.core.atom.call(null,G__40630));
});
hatti.shared.app_state = hatti.shared.empty_app_state();
/**
 * Given a function over data, run a transact on data inside app-state.
 */
hatti.shared.transact_app_data_BANG_ = (function hatti$shared$transact_app_data_BANG_(app_state,transact_fn){
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null),transact_fn);
});
/**
 * Given `data` received from the server, update the app-state.
 * Sorts by submission time, and adds rank to the data, for table + map views.
 */
hatti.shared.update_app_data_BANG_ = (function hatti$shared$update_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40638 = arguments.length;
var i__7485__auto___40639 = (0);
while(true){
if((i__7485__auto___40639 < len__7484__auto___40638)){
args__7491__auto__.push((arguments[i__7485__auto___40639]));

var G__40640 = (i__7485__auto___40639 + (1));
i__7485__auto___40639 = G__40640;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__40635){
var map__40636 = p__40635;
var map__40636__$1 = ((((!((map__40636 == null)))?((((map__40636.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40636.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40636):map__40636);
var rerank_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40636__$1,cljs.core.cst$kw$rerank_QMARK_);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40636__$1,cljs.core.cst$kw$completed_QMARK_);
var sort_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40636__$1,cljs.core.cst$kw$sort_DASH_field);
var current_start_index = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__40636__$1,cljs.core.cst$kw$current_DASH_start_DASH_index,(0));
var add_rank = ((function (map__40636,map__40636__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (i,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,hatti.constants._rank,(current_start_index + (i + (1))));
});})(map__40636,map__40636__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
;
var data__$1 = (cljs.core.truth_((function (){var and__6397__auto__ = rerank_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.seq(data);
} else {
return and__6397__auto__;
}
})())?cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (add_rank,map__40636,map__40636__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (p1__40631_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__40631_SHARP_,(function (){var or__6409__auto__ = sort_field;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants._submission_time;
}
})());
});})(add_rank,map__40636,map__40636__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
,data))):cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(add_rank,data)));
var total_records = cljs.core.count(data__$1);
hatti.shared.transact_app_data_BANG_(app_state,((function (add_rank,data__$1,total_records,map__40636,map__40636__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index){
return (function (_){
return data__$1;
});})(add_rank,data__$1,total_records,map__40636,map__40636__$1,rerank_QMARK_,completed_QMARK_,sort_field,current_start_index))
);

return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$total_DASH_records,total_records,cljs.core.cst$kw$loading_QMARK_,cljs.core.not(completed_QMARK_)], null));
});

hatti.shared.update_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.update_app_data_BANG_.cljs$lang$applyTo = (function (seq40632){
var G__40633 = cljs.core.first(seq40632);
var seq40632__$1 = cljs.core.next(seq40632);
var G__40634 = cljs.core.first(seq40632__$1);
var seq40632__$2 = cljs.core.next(seq40632__$1);
return hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40633,G__40634,seq40632__$2);
});

/**
 * Add to app data.
 */
hatti.shared.add_to_app_data_BANG_ = (function hatti$shared$add_to_app_data_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40647 = arguments.length;
var i__7485__auto___40648 = (0);
while(true){
if((i__7485__auto___40648 < len__7484__auto___40647)){
args__7491__auto__.push((arguments[i__7485__auto___40648]));

var G__40649 = (i__7485__auto___40648 + (1));
i__7485__auto___40648 = G__40649;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,data,p__40644){
var map__40645 = p__40644;
var map__40645__$1 = ((((!((map__40645 == null)))?((((map__40645.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40645.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40645):map__40645);
var completed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40645__$1,cljs.core.cst$kw$completed_QMARK_);
var old_data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)));
hatti.shared.update_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(old_data,data),cljs.core.array_seq([cljs.core.cst$kw$rerank_QMARK_,completed_QMARK_], 0));

return hatti.utils.om.state.update_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$status,cljs.core.cst$kw$loading_QMARK_], null),cljs.core.not(completed_QMARK_));
});

hatti.shared.add_to_app_data_BANG_.cljs$lang$maxFixedArity = (2);

hatti.shared.add_to_app_data_BANG_.cljs$lang$applyTo = (function (seq40641){
var G__40642 = cljs.core.first(seq40641);
var seq40641__$1 = cljs.core.next(seq40641);
var G__40643 = cljs.core.first(seq40641__$1);
var seq40641__$2 = cljs.core.next(seq40641__$1);
return hatti.shared.add_to_app_data_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40642,G__40643,seq40641__$2);
});

/**
 * Merge languages into the app-state if form is multilingual
 */
hatti.shared.maybe_merge_languages_BANG_ = (function hatti$shared$maybe_merge_languages_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40656 = arguments.length;
var i__7485__auto___40657 = (0);
while(true){
if((i__7485__auto___40657 < len__7484__auto___40656)){
args__7491__auto__.push((arguments[i__7485__auto___40657]));

var G__40658 = (i__7485__auto___40657 + (1));
i__7485__auto___40657 = G__40658;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__40652){
var vec__40653 = p__40652;
var state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40653,(0),null);
var langs = hatti.ona.forms.get_languages(form);
var default_lang = hatti.ona.forms.default_lang(langs);
var lang_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$all,langs,cljs.core.cst$kw$default,default_lang,cljs.core.cst$kw$current,default_lang], null);
var _ = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xxxxxxxxxxxxxxxxxxxxxxxx"], 0));
var ___$1 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([default_lang], 0));
return chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var or__6409__auto__ = state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$languages], null),lang_state);
});

hatti.shared.maybe_merge_languages_BANG_.cljs$lang$maxFixedArity = (1);

hatti.shared.maybe_merge_languages_BANG_.cljs$lang$applyTo = (function (seq40650){
var G__40651 = cljs.core.first(seq40650);
var seq40650__$1 = cljs.core.next(seq40650);
return hatti.shared.maybe_merge_languages_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40651,seq40650__$1);
});

hatti.shared.language_cursor = (function hatti$shared$language_cursor(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40664 = arguments.length;
var i__7485__auto___40665 = (0);
while(true){
if((i__7485__auto___40665 < len__7484__auto___40664)){
args__7491__auto__.push((arguments[i__7485__auto___40665]));

var G__40666 = (i__7485__auto___40665 + (1));
i__7485__auto___40665 = G__40666;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic = (function (p__40660){
var vec__40661 = p__40660;
var state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40661,(0),null);
return om.core.ref_cursor(cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(om.core.root_cursor((function (){var or__6409__auto__ = state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})())));
});

hatti.shared.language_cursor.cljs$lang$maxFixedArity = (0);

hatti.shared.language_cursor.cljs$lang$applyTo = (function (seq40659){
return hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40659));
});

/**
 * A language selector and a following divider.
 */
hatti.shared.language_selector = (function hatti$shared$language_selector(_,owner,p__40668){
var map__40718 = p__40668;
var map__40718__$1 = ((((!((map__40718 == null)))?((((map__40718.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40718.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40718):map__40718);
var custom_app_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40718__$1,cljs.core.cst$kw$app_DASH_state);
if(typeof hatti.shared.t_hatti$shared40720 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.shared.t_hatti$shared40720 = (function (language_selector,_,owner,p__40668,map__40718,custom_app_state,meta40721){
this.language_selector = language_selector;
this._ = _;
this.owner = owner;
this.p__40668 = p__40668;
this.map__40718 = map__40718;
this.custom_app_state = custom_app_state;
this.meta40721 = meta40721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.shared.t_hatti$shared40720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40718,map__40718__$1,custom_app_state){
return (function (_40722,meta40721__$1){
var self__ = this;
var _40722__$1 = this;
return (new hatti.shared.t_hatti$shared40720(self__.language_selector,self__._,self__.owner,self__.p__40668,self__.map__40718,self__.custom_app_state,meta40721__$1));
});})(map__40718,map__40718__$1,custom_app_state))
;

hatti.shared.t_hatti$shared40720.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40718,map__40718__$1,custom_app_state){
return (function (_40722){
var self__ = this;
var _40722__$1 = this;
return self__.meta40721;
});})(map__40718,map__40718__$1,custom_app_state))
;

hatti.shared.t_hatti$shared40720.prototype.om$core$IRender$ = true;

hatti.shared.t_hatti$shared40720.prototype.om$core$IRender$render$arity$1 = ((function (map__40718,map__40718__$1,custom_app_state){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var map__40723 = om.core.observe(self__.owner,hatti.shared.language_cursor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var or__6409__auto__ = self__.custom_app_state;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.shared.app_state;
}
})()], 0)));
var map__40723__$1 = ((((!((map__40723 == null)))?((((map__40723.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40723.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40723):map__40723);
var ls = map__40723__$1;
var current = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40723__$1,cljs.core.cst$kw$current);
var all = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40723__$1,cljs.core.cst$kw$all);
var get_update_handler = ((function (map__40723,map__40723__$1,ls,current,all,___$2,map__40718,map__40718__$1,custom_app_state){
return (function (language){
return ((function (map__40723,map__40723__$1,ls,current,all,___$2,map__40718,map__40718__$1,custom_app_state){
return (function (event){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(ls,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current], null),language);

return event.preventDefault();
});
;})(map__40723,map__40723__$1,ls,current,all,___$2,map__40718,map__40718__$1,custom_app_state))
});})(map__40723,map__40723__$1,ls,current,all,___$2,map__40718,map__40718__$1,custom_app_state))
;
var stringify = ((function (map__40723,map__40723__$1,ls,current,all,get_update_handler,___$2,map__40718,map__40718__$1,custom_app_state){
return (function (p1__40667_SHARP_){
if((p1__40667_SHARP_ instanceof cljs.core.Keyword)){
return cljs.core.name(p1__40667_SHARP_);
} else {
return [cljs.core.str(p1__40667_SHARP_)].join('');
}
});})(map__40723,map__40723__$1,ls,current,all,get_update_handler,___$2,map__40718,map__40718__$1,custom_app_state))
;
var G__40732 = ({"className": "language-selector-inner"});
var G__40733 = (function (){var G__40735 = ({"className": "dropdown drop-hover"});
var G__40736 = (function (){var G__40740 = ({"style": ({"marginRight": ".2em"}), "className": "fa fa-globe"});
return React.DOM.i(G__40740);
})();
var G__40737 = (function (){var attrs40727 = (cljs.core.truth_(hatti.ona.forms.english_QMARK_(current))?"EN":stringify(current));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs40727))?sablono.interpreter.attributes(attrs40727):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs40727))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs40727)], null))));
})();
var G__40738 = (function (){var G__40741 = ({"style": ({"marginLeft": ".5em"}), "className": "fa fa-angle-down"});
return React.DOM.i(G__40741);
})();
var G__40739 = (function (){var G__40742 = ({"className": "submenu"});
var G__40743 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__40742,G__40735,G__40736,G__40737,G__40738,G__40732,map__40723,map__40723__$1,ls,current,all,get_update_handler,stringify,___$2,map__40718,map__40718__$1,custom_app_state){
return (function hatti$shared$language_selector_$_iter__40744(s__40745){
return (new cljs.core.LazySeq(null,((function (G__40742,G__40735,G__40736,G__40737,G__40738,G__40732,map__40723,map__40723__$1,ls,current,all,get_update_handler,stringify,___$2,map__40718,map__40718__$1,custom_app_state){
return (function (){
var s__40745__$1 = s__40745;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40745__$1);
if(temp__4657__auto__){
var s__40745__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40745__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40745__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40747 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40746 = (0);
while(true){
if((i__40746 < size__7188__auto__)){
var language = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40746);
cljs.core.chunk_append(b__40747,(function (){var G__40758 = null;
var G__40759 = (function (){var G__40760 = ({"href": "#", "onClick": get_update_handler(language)});
var G__40761 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__40760,G__40761);
})();
return React.DOM.li(G__40758,G__40759);
})());

var G__40767 = (i__40746 + (1));
i__40746 = G__40767;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40747),hatti$shared$language_selector_$_iter__40744(cljs.core.chunk_rest(s__40745__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40747),null);
}
} else {
var language = cljs.core.first(s__40745__$2);
return cljs.core.cons((function (){var G__40762 = null;
var G__40763 = (function (){var G__40764 = ({"href": "#", "onClick": get_update_handler(language)});
var G__40765 = sablono.interpreter.interpret(stringify(language));
return React.DOM.a(G__40764,G__40765);
})();
return React.DOM.li(G__40762,G__40763);
})(),hatti$shared$language_selector_$_iter__40744(cljs.core.rest(s__40745__$2)));
}
} else {
return null;
}
break;
}
});})(G__40742,G__40735,G__40736,G__40737,G__40738,G__40732,map__40723,map__40723__$1,ls,current,all,get_update_handler,stringify,___$2,map__40718,map__40718__$1,custom_app_state))
,null,null));
});})(G__40742,G__40735,G__40736,G__40737,G__40738,G__40732,map__40723,map__40723__$1,ls,current,all,get_update_handler,stringify,___$2,map__40718,map__40718__$1,custom_app_state))
;
return iter__7189__auto__(all);
})());
return React.DOM.ul(G__40742,G__40743);
})();
return React.DOM.span(G__40735,G__40736,G__40737,G__40738,G__40739);
})();
var G__40734 = (function (){var G__40766 = ({"className": "divider"});
return React.DOM.div(G__40766);
})();
return React.DOM.div(G__40732,G__40733,G__40734);
});})(map__40718,map__40718__$1,custom_app_state))
;

hatti.shared.t_hatti$shared40720.getBasis = ((function (map__40718,map__40718__$1,custom_app_state){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$language_DASH_selector,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$custom_DASH_app_DASH_state,cljs.core.cst$kw$app_DASH_state], null)], null))),cljs.core.cst$kw$doc,"A language selector and a following divider."], null)),cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40668,cljs.core.cst$sym$map__40718,cljs.core.cst$sym$custom_DASH_app_DASH_state,cljs.core.cst$sym$meta40721], null);
});})(map__40718,map__40718__$1,custom_app_state))
;

hatti.shared.t_hatti$shared40720.cljs$lang$type = true;

hatti.shared.t_hatti$shared40720.cljs$lang$ctorStr = "hatti.shared/t_hatti$shared40720";

hatti.shared.t_hatti$shared40720.cljs$lang$ctorPrWriter = ((function (map__40718,map__40718__$1,custom_app_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.shared/t_hatti$shared40720");
});})(map__40718,map__40718__$1,custom_app_state))
;

hatti.shared.__GT_t_hatti$shared40720 = ((function (map__40718,map__40718__$1,custom_app_state){
return (function hatti$shared$language_selector_$___GT_t_hatti$shared40720(language_selector__$1,___$1,owner__$1,p__40668__$1,map__40718__$2,custom_app_state__$1,meta40721){
return (new hatti.shared.t_hatti$shared40720(language_selector__$1,___$1,owner__$1,p__40668__$1,map__40718__$2,custom_app_state__$1,meta40721));
});})(map__40718,map__40718__$1,custom_app_state))
;

}

return (new hatti.shared.t_hatti$shared40720(hatti$shared$language_selector,_,owner,p__40668,map__40718__$1,custom_app_state,cljs.core.PersistentArrayMap.EMPTY));
});
