// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_40488){
var state_val_40489 = (state_40488[(1)]);
if((state_val_40489 === (7))){
var inst_40445 = (state_40488[(7)]);
var inst_40445__$1 = (state_40488[(2)]);
var inst_40447 = (inst_40445__$1 == null);
var inst_40448 = cljs.core.not(inst_40447);
var state_40488__$1 = (function (){var statearr_40490 = state_40488;
(statearr_40490[(7)] = inst_40445__$1);

return statearr_40490;
})();
if(inst_40448){
var statearr_40491_40528 = state_40488__$1;
(statearr_40491_40528[(1)] = (8));

} else {
var statearr_40492_40529 = state_40488__$1;
(statearr_40492_40529[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (20))){
var inst_40467 = (state_40488[(8)]);
var inst_40475 = (state_40488[(2)]);
var state_40488__$1 = (function (){var statearr_40493 = state_40488;
(statearr_40493[(9)] = inst_40475);

return statearr_40493;
})();
if(cljs.core.truth_(inst_40467)){
var statearr_40494_40530 = state_40488__$1;
(statearr_40494_40530[(1)] = (21));

} else {
var statearr_40495_40531 = state_40488__$1;
(statearr_40495_40531[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (1))){
var state_40488__$1 = state_40488;
var statearr_40496_40532 = state_40488__$1;
(statearr_40496_40532[(2)] = null);

(statearr_40496_40532[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (4))){
var state_40488__$1 = state_40488;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40488__$1,(7),agg_data_channel);
} else {
if((state_val_40489 === (15))){
var inst_40445 = (state_40488[(7)]);
var state_40488__$1 = state_40488;
var statearr_40497_40533 = state_40488__$1;
(statearr_40497_40533[(2)] = inst_40445);

(statearr_40497_40533[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (21))){
var inst_40477 = cljs.core.async.close_BANG_(agg_data_channel);
var state_40488__$1 = state_40488;
var statearr_40498_40534 = state_40488__$1;
(statearr_40498_40534[(2)] = inst_40477);

(statearr_40498_40534[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (13))){
var inst_40457 = (state_40488[(2)]);
var state_40488__$1 = state_40488;
var statearr_40499_40535 = state_40488__$1;
(statearr_40499_40535[(2)] = inst_40457);

(statearr_40499_40535[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (22))){
var state_40488__$1 = state_40488;
var statearr_40500_40536 = state_40488__$1;
(statearr_40500_40536[(2)] = null);

(statearr_40500_40536[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (6))){
var inst_40484 = (state_40488[(2)]);
var state_40488__$1 = state_40488;
var statearr_40501_40537 = state_40488__$1;
(statearr_40501_40537[(2)] = inst_40484);

(statearr_40501_40537[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (17))){
var inst_40467 = (state_40488[(8)]);
var inst_40466 = (state_40488[(10)]);
var inst_40469 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_40466,inst_40467) : callback.call(null,inst_40466,inst_40467));
var state_40488__$1 = state_40488;
var statearr_40502_40538 = state_40488__$1;
(statearr_40502_40538[(2)] = inst_40469);

(statearr_40502_40538[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (3))){
var inst_40486 = (state_40488[(2)]);
var state_40488__$1 = state_40488;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40488__$1,inst_40486);
} else {
if((state_val_40489 === (12))){
var state_40488__$1 = state_40488;
var statearr_40503_40539 = state_40488__$1;
(statearr_40503_40539[(2)] = false);

(statearr_40503_40539[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (2))){
var state_40488__$1 = state_40488;
var statearr_40504_40540 = state_40488__$1;
(statearr_40504_40540[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (23))){
var inst_40480 = (state_40488[(2)]);
var state_40488__$1 = (function (){var statearr_40506 = state_40488;
(statearr_40506[(11)] = inst_40480);

return statearr_40506;
})();
var statearr_40507_40541 = state_40488__$1;
(statearr_40507_40541[(2)] = null);

(statearr_40507_40541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (19))){
var inst_40472 = (state_40488[(2)]);
var inst_40473 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_40488__$1 = (function (){var statearr_40508 = state_40488;
(statearr_40508[(12)] = inst_40472);

return statearr_40508;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40488__$1,(20),inst_40473);
} else {
if((state_val_40489 === (11))){
var state_40488__$1 = state_40488;
var statearr_40509_40542 = state_40488__$1;
(statearr_40509_40542[(2)] = true);

(statearr_40509_40542[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (9))){
var state_40488__$1 = state_40488;
var statearr_40510_40543 = state_40488__$1;
(statearr_40510_40543[(2)] = false);

(statearr_40510_40543[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (5))){
var state_40488__$1 = state_40488;
var statearr_40511_40544 = state_40488__$1;
(statearr_40511_40544[(2)] = null);

(statearr_40511_40544[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (14))){
var inst_40445 = (state_40488[(7)]);
var inst_40462 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40445);
var state_40488__$1 = state_40488;
var statearr_40512_40545 = state_40488__$1;
(statearr_40512_40545[(2)] = inst_40462);

(statearr_40512_40545[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (16))){
var inst_40466 = (state_40488[(10)]);
var inst_40465 = (state_40488[(2)]);
var inst_40466__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40465,cljs.core.cst$kw$data);
var inst_40467 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40465,cljs.core.cst$kw$completed_QMARK_);
var state_40488__$1 = (function (){var statearr_40513 = state_40488;
(statearr_40513[(8)] = inst_40467);

(statearr_40513[(10)] = inst_40466__$1);

return statearr_40513;
})();
if(cljs.core.truth_(inst_40466__$1)){
var statearr_40514_40546 = state_40488__$1;
(statearr_40514_40546[(1)] = (17));

} else {
var statearr_40515_40547 = state_40488__$1;
(statearr_40515_40547[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (10))){
var inst_40460 = (state_40488[(2)]);
var state_40488__$1 = state_40488;
if(cljs.core.truth_(inst_40460)){
var statearr_40516_40548 = state_40488__$1;
(statearr_40516_40548[(1)] = (14));

} else {
var statearr_40517_40549 = state_40488__$1;
(statearr_40517_40549[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (18))){
var state_40488__$1 = state_40488;
var statearr_40518_40550 = state_40488__$1;
(statearr_40518_40550[(2)] = null);

(statearr_40518_40550[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40489 === (8))){
var inst_40445 = (state_40488[(7)]);
var inst_40450 = inst_40445.cljs$lang$protocol_mask$partition0$;
var inst_40451 = (inst_40450 & (64));
var inst_40452 = inst_40445.cljs$core$ISeq$;
var inst_40453 = (inst_40451) || (inst_40452);
var state_40488__$1 = state_40488;
if(cljs.core.truth_(inst_40453)){
var statearr_40519_40551 = state_40488__$1;
(statearr_40519_40551[(1)] = (11));

} else {
var statearr_40520_40552 = state_40488__$1;
(statearr_40520_40552[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto____0 = (function (){
var statearr_40524 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40524[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto__);

(statearr_40524[(1)] = (1));

return statearr_40524;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto____1 = (function (state_40488){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_40488);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e40525){if((e40525 instanceof Object)){
var ex__12193__auto__ = e40525;
var statearr_40526_40553 = state_40488;
(statearr_40526_40553[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40488);

return cljs.core.cst$kw$recur;
} else {
throw e40525;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__40554 = state_40488;
state_40488 = G__40554;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto__ = function(state_40488){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto____1.call(this,state_40488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_40527 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_40527[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_40527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__40557_40559 = agg;
var G__40558_40560 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__40557_40559,G__40558_40560) : cljs.core.reset_BANG_.call(null,G__40557_40559,G__40558_40560));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40568 = arguments.length;
var i__7485__auto___40569 = (0);
while(true){
if((i__7485__auto___40569 < len__7484__auto___40568)){
args__7491__auto__.push((arguments[i__7485__auto___40569]));

var G__40570 = (i__7485__auto___40569 + (1));
i__7485__auto___40569 = G__40570;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__40564){
var map__40565 = p__40564;
var map__40565__$1 = ((((!((map__40565 == null)))?((((map__40565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40565):map__40565);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40565__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__40567 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40567) : cljs.core.atom.call(null,G__40567));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__40565,map__40565__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__40565,map__40565__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__40565,map__40565__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__40565,map__40565__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq40561){
var G__40562 = cljs.core.first(seq40561);
var seq40561__$1 = cljs.core.next(seq40561);
var G__40563 = cljs.core.first(seq40561__$1);
var seq40561__$2 = cljs.core.next(seq40561__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40562,G__40563,seq40561__$2);
});

