// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__41065(s__41066){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__41066__$1 = s__41066;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41066__$1);
if(temp__4657__auto__){
var s__41066__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41066__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41066__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41068 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41067 = (0);
while(true){
if((i__41067 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41067);
cljs.core.chunk_append(b__41068,(function (){var iter__7189__auto__ = ((function (i__41067,datum,c__7187__auto__,size__7188__auto__,b__41068,s__41066__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__41065_$_iter__41083(s__41084){
return (new cljs.core.LazySeq(null,((function (i__41067,datum,c__7187__auto__,size__7188__auto__,b__41068,s__41066__$2,temp__4657__auto__,osmfields){
return (function (){
var s__41084__$1 = s__41084;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__41084__$1);
if(temp__4657__auto____$1){
var s__41084__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41084__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__41084__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__41086 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__41085 = (0);
while(true){
if((i__41085 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__41085);
cljs.core.chunk_append(b__41086,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__41095 = (i__41085 + (1));
i__41085 = G__41095;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41086),hatti$ona$post_process$ona_osm_link_$_iter__41065_$_iter__41083(cljs.core.chunk_rest(s__41084__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41086),null);
}
} else {
var field = cljs.core.first(s__41084__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__41065_$_iter__41083(cljs.core.rest(s__41084__$2)));
}
} else {
return null;
}
break;
}
});})(i__41067,datum,c__7187__auto__,size__7188__auto__,b__41068,s__41066__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__41067,datum,c__7187__auto__,size__7188__auto__,b__41068,s__41066__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__41096 = (i__41067 + (1));
i__41067 = G__41096;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41068),hatti$ona$post_process$ona_osm_link_$_iter__41065(cljs.core.chunk_rest(s__41066__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41068),null);
}
} else {
var datum = cljs.core.first(s__41066__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__41066__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__41065_$_iter__41089(s__41090){
return (new cljs.core.LazySeq(null,((function (datum,s__41066__$2,temp__4657__auto__,osmfields){
return (function (){
var s__41090__$1 = s__41090;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__41090__$1);
if(temp__4657__auto____$1){
var s__41090__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41090__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41090__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41092 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41091 = (0);
while(true){
if((i__41091 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41091);
cljs.core.chunk_append(b__41092,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__41097 = (i__41091 + (1));
i__41091 = G__41097;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41092),hatti$ona$post_process$ona_osm_link_$_iter__41065_$_iter__41089(cljs.core.chunk_rest(s__41090__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41092),null);
}
} else {
var field = cljs.core.first(s__41090__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__41065_$_iter__41089(cljs.core.rest(s__41090__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__41066__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__41066__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__41065(cljs.core.rest(s__41066__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__41099 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__41099);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__41123 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__41123) : osmgeo.call(null,G__41123));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__41124(s__41125){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__41125__$1 = s__41125;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41125__$1);
if(temp__4657__auto__){
var s__41125__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41125__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41125__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41127 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41126 = (0);
while(true){
if((i__41126 < size__7188__auto__)){
var map__41138 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41126);
var map__41138__$1 = ((((!((map__41138 == null)))?((((map__41138.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41138.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41138):map__41138);
var feature = map__41138__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41138__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41138__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41138__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__41127,(function (){var map__41140 = properties;
var map__41140__$1 = ((((!((map__41140 == null)))?((((map__41140.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41140.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41140):map__41140);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41140__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41140__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41140__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__41146 = (i__41126 + (1));
i__41126 = G__41146;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41127),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__41124(cljs.core.chunk_rest(s__41125__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41127),null);
}
} else {
var map__41142 = cljs.core.first(s__41125__$2);
var map__41142__$1 = ((((!((map__41142 == null)))?((((map__41142.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41142.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41142):map__41142);
var feature = map__41142__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41142__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41142__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41142__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__41144 = properties;
var map__41144__$1 = ((((!((map__41144 == null)))?((((map__41144.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41144.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41144):map__41144);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41144__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41144__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41144__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__41124(cljs.core.rest(s__41125__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__41147_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__41147_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__41159(s__41160){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__41160__$1 = s__41160;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41160__$1);
if(temp__4657__auto__){
var s__41160__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41160__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41160__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41162 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41161 = (0);
while(true){
if((i__41161 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41161);
cljs.core.chunk_append(b__41162,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__41161,osm_id,datum,c__7187__auto__,size__7188__auto__,b__41162,s__41160__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__41148_SHARP_){
return osm_val__GT_osm_data(p1__41148_SHARP_,osm_id);
});})(i__41161,osm_id,datum,c__7187__auto__,size__7188__auto__,b__41162,s__41160__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__41169 = (i__41161 + (1));
i__41161 = G__41169;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41162),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__41159(cljs.core.chunk_rest(s__41160__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41162),null);
}
} else {
var datum = cljs.core.first(s__41160__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__41160__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__41148_SHARP_){
return osm_val__GT_osm_data(p1__41148_SHARP_,osm_id);
});})(osm_id,datum,s__41160__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__41159(cljs.core.rest(s__41160__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__41165 = cljs.core.seq(osm_fields);
var chunk__41166 = null;
var count__41167 = (0);
var i__41168 = (0);
while(true){
if((i__41168 < count__41167)){
var osm_field = chunk__41166.cljs$core$IIndexed$_nth$arity$2(null,i__41168);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__41170 = seq__41165;
var G__41171 = chunk__41166;
var G__41172 = count__41167;
var G__41173 = (i__41168 + (1));
seq__41165 = G__41170;
chunk__41166 = G__41171;
count__41167 = G__41172;
i__41168 = G__41173;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__41165);
if(temp__4657__auto__){
var seq__41165__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41165__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__41165__$1);
var G__41174 = cljs.core.chunk_rest(seq__41165__$1);
var G__41175 = c__7220__auto__;
var G__41176 = cljs.core.count(c__7220__auto__);
var G__41177 = (0);
seq__41165 = G__41174;
chunk__41166 = G__41175;
count__41167 = G__41176;
i__41168 = G__41177;
continue;
} else {
var osm_field = cljs.core.first(seq__41165__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__41178 = cljs.core.next(seq__41165__$1);
var G__41179 = null;
var G__41180 = (0);
var G__41181 = (0);
seq__41165 = G__41178;
chunk__41166 = G__41179;
count__41167 = G__41180;
i__41168 = G__41181;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
var or__6409__auto__ = (function (){var G__41189 = (function (p1__41182_SHARP_){
return cljs.core.re_find(cljs.core.re_pattern(cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(fname,cljs.core.re_pattern("\\.")))),p1__41182_SHARP_);
});
var G__41190 = fnames;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__41189,G__41190) : chimera.seq.filter_first.call(null,G__41189,G__41190));
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__41191_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__41191_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,hatti.ona.post_process.get_matching_name(fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41192_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_(p1__41192_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.image_QMARK_(p1__41192_SHARP_);
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41205 = arguments.length;
var i__7485__auto___41206 = (0);
while(true){
if((i__7485__auto___41206 < len__7484__auto___41205)){
args__7491__auto__.push((arguments[i__7485__auto___41206]));

var G__41207 = (i__7485__auto___41206 + (1));
i__7485__auto___41206 = G__41207;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__41196){
var map__41197 = p__41196;
var map__41197__$1 = ((((!((map__41197 == null)))?((((map__41197.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41197.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41197):map__41197);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41197__$1,cljs.core.cst$kw$attachments);
var image_fields = hatti.ona.post_process.filter_media(flat_form);
var iter__7189__auto__ = ((function (image_fields,map__41197,map__41197__$1,attachments){
return (function hatti$ona$post_process$iter__41199(s__41200){
return (new cljs.core.LazySeq(null,((function (image_fields,map__41197,map__41197__$1,attachments){
return (function (){
var s__41200__$1 = s__41200;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41200__$1);
if(temp__4657__auto__){
var s__41200__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41200__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41200__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41202 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41201 = (0);
while(true){
if((i__41201 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41201);
cljs.core.chunk_append(b__41202,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__41201,attach_map,record,c__7187__auto__,size__7188__auto__,b__41202,s__41200__$2,temp__4657__auto__,image_fields,map__41197,map__41197__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__41201,attach_map,record,c__7187__auto__,size__7188__auto__,b__41202,s__41200__$2,temp__4657__auto__,image_fields,map__41197,map__41197__$1,attachments))
,record,image_fields);
})());

var G__41208 = (i__41201 + (1));
i__41201 = G__41208;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41202),hatti$ona$post_process$iter__41199(cljs.core.chunk_rest(s__41200__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41202),null);
}
} else {
var record = cljs.core.first(s__41200__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__41200__$2,temp__4657__auto__,image_fields,map__41197,map__41197__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__41200__$2,temp__4657__auto__,image_fields,map__41197,map__41197__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__41199(cljs.core.rest(s__41200__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__41197,map__41197__$1,attachments))
,null,null));
});})(image_fields,map__41197,map__41197__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq41193){
var G__41194 = cljs.core.first(seq41193);
var seq41193__$1 = cljs.core.next(seq41193);
var G__41195 = cljs.core.first(seq41193__$1);
var seq41193__$2 = cljs.core.next(seq41193__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__41194,G__41195,seq41193__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments)], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__41215(s__41216){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__41216__$1 = s__41216;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41216__$1);
if(temp__4657__auto__){
var s__41216__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41216__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__41216__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__41218 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__41217 = (0);
while(true){
if((i__41217 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__41217);
cljs.core.chunk_append(b__41218,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__41221 = (i__41217 + (1));
i__41217 = G__41221;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41218),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__41215(cljs.core.chunk_rest(s__41216__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41218),null);
}
} else {
var record = cljs.core.first(s__41216__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__41215(cljs.core.rest(s__41216__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___41229 = arguments.length;
var i__7485__auto___41230 = (0);
while(true){
if((i__7485__auto___41230 < len__7484__auto___41229)){
args__7491__auto__.push((arguments[i__7485__auto___41230]));

var G__41231 = (i__7485__auto___41230 + (1));
i__7485__auto___41230 = G__41231;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__41226){
var map__41227 = p__41226;
var map__41227__$1 = ((((!((map__41227 == null)))?((((map__41227.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41227.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41227):map__41227);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__41227__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__41227,map__41227__$1,app_data_keys){
return (function (p1__41222_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__41222_SHARP_));
});})(map__41227,map__41227__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq41223){
var G__41224 = cljs.core.first(seq41223);
var seq41223__$1 = cljs.core.next(seq41223);
var G__41225 = cljs.core.first(seq41223__$1);
var seq41223__$2 = cljs.core.next(seq41223__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__41224,G__41225,seq41223__$2);
});

