// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38166 = arguments.length;
var i__7485__auto___38167 = (0);
while(true){
if((i__7485__auto___38167 < len__7484__auto___38166)){
args__7491__auto__.push((arguments[i__7485__auto___38167]));

var G__38168 = (i__7485__auto___38167 + (1));
i__7485__auto___38167 = G__38168;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__38162){
var map__38163 = p__38162;
var map__38163__$1 = ((((!((map__38163 == null)))?((((map__38163.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38163.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38163):map__38163);
var custom_styles = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38163__$1,cljs.core.cst$kw$custom_DASH_styles,hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__38165 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(custom_styles) : kw.call(null,custom_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__38165) : style_type.call(null,G__38165));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq38159){
var G__38160 = cljs.core.first(seq38159);
var seq38159__$1 = cljs.core.next(seq38159);
var G__38161 = cljs.core.first(seq38159__$1);
var seq38159__$2 = cljs.core.next(seq38159__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__38160,G__38161,seq38159__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args38169 = [];
var len__7484__auto___38173 = arguments.length;
var i__7485__auto___38174 = (0);
while(true){
if((i__7485__auto___38174 < len__7484__auto___38173)){
args38169.push((arguments[i__7485__auto___38174]));

var G__38175 = (i__7485__auto___38174 + (1));
i__7485__auto___38174 = G__38175;
continue;
} else {
}
break;
}

var G__38171 = args38169.length;
switch (G__38171) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38169.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__38172 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__38172) : kw.call(null,G__38172));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__38178 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__38178) : id_selected_QMARK_.call(null,G__38178));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38188 = arguments.length;
var i__7485__auto___38189 = (0);
while(true){
if((i__7485__auto___38189 < len__7484__auto___38188)){
args__7491__auto__.push((arguments[i__7485__auto___38189]));

var G__38190 = (i__7485__auto___38189 + (1));
i__7485__auto___38189 = G__38190;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__38181){
var map__38182 = p__38181;
var map__38182__$1 = ((((!((map__38182 == null)))?((((map__38182.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38182.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38182):map__38182);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38182__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__38184 = cljs.core.seq(markers);
var chunk__38185 = null;
var count__38186 = (0);
var i__38187 = (0);
while(true){
if((i__38187 < count__38186)){
var marker = chunk__38185.cljs$core$IIndexed$_nth$arity$2(null,i__38187);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__38191 = seq__38184;
var G__38192 = chunk__38185;
var G__38193 = count__38186;
var G__38194 = (i__38187 + (1));
seq__38184 = G__38191;
chunk__38185 = G__38192;
count__38186 = G__38193;
i__38187 = G__38194;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38184);
if(temp__4657__auto__){
var seq__38184__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38184__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38184__$1);
var G__38195 = cljs.core.chunk_rest(seq__38184__$1);
var G__38196 = c__7220__auto__;
var G__38197 = cljs.core.count(c__7220__auto__);
var G__38198 = (0);
seq__38184 = G__38195;
chunk__38185 = G__38196;
count__38186 = G__38197;
i__38187 = G__38198;
continue;
} else {
var marker = cljs.core.first(seq__38184__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__38199 = cljs.core.next(seq__38184__$1);
var G__38200 = null;
var G__38201 = (0);
var G__38202 = (0);
seq__38184 = G__38199;
chunk__38185 = G__38200;
count__38186 = G__38201;
i__38187 = G__38202;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq38179){
var G__38180 = cljs.core.first(seq38179);
var seq38179__$1 = cljs.core.next(seq38179);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__38180,seq38179__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__38203 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38203) : cljs.core.atom.call(null,G__38203));
})();
var prefer_table__7335__auto__ = (function (){var G__38204 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38204) : cljs.core.atom.call(null,G__38204));
})();
var method_cache__7336__auto__ = (function (){var G__38205 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38205) : cljs.core.atom.call(null,G__38205));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__38206 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38206) : cljs.core.atom.call(null,G__38206));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__38211__delegate = function (record,field,p__38207){
var vec__38208 = p__38207;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38208,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__38211 = function (record,field,var_args){
var p__38207 = null;
if (arguments.length > 2) {
var G__38212__i = 0, G__38212__a = new Array(arguments.length -  2);
while (G__38212__i < G__38212__a.length) {G__38212__a[G__38212__i] = arguments[G__38212__i + 2]; ++G__38212__i;}
  p__38207 = new cljs.core.IndexedSeq(G__38212__a,0);
} 
return G__38211__delegate.call(this,record,field,p__38207);};
G__38211.cljs$lang$maxFixedArity = 2;
G__38211.cljs$lang$applyTo = (function (arglist__38213){
var record = cljs.core.first(arglist__38213);
arglist__38213 = cljs.core.next(arglist__38213);
var field = cljs.core.first(arglist__38213);
var p__38207 = cljs.core.rest(arglist__38213);
return G__38211__delegate(record,field,p__38207);
});
G__38211.cljs$core$IFn$_invoke$arity$variadic = G__38211__delegate;
return G__38211;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__38214){
var map__38215 = p__38214;
var map__38215__$1 = ((((!((map__38215 == null)))?((((map__38215.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38215.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38215):map__38215);
var field = map__38215__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38215__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38215__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__38215,map__38215__$1,field,children,full_name){
return (function hatti$map$utils$iter__38217(s__38218){
return (new cljs.core.LazySeq(null,((function (map__38215,map__38215__$1,field,children,full_name){
return (function (){
var s__38218__$1 = s__38218;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38218__$1);
if(temp__4657__auto__){
var s__38218__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38218__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38218__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38220 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38219 = (0);
while(true){
if((i__38219 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38219);
cljs.core.chunk_append(b__38220,(function (){var iter__7189__auto__ = ((function (i__38219,child_record,c__7187__auto__,size__7188__auto__,b__38220,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name){
return (function hatti$map$utils$iter__38217_$_iter__38235(s__38236){
return (new cljs.core.LazySeq(null,((function (i__38219,child_record,c__7187__auto__,size__7188__auto__,b__38220,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name){
return (function (){
var s__38236__$1 = s__38236;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__38236__$1);
if(temp__4657__auto____$1){
var s__38236__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38236__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__38236__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__38238 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__38237 = (0);
while(true){
if((i__38237 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__38237);
cljs.core.chunk_append(b__38238,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__38247 = (i__38237 + (1));
i__38237 = G__38247;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38238),hatti$map$utils$iter__38217_$_iter__38235(cljs.core.chunk_rest(s__38236__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38238),null);
}
} else {
var child = cljs.core.first(s__38236__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__38217_$_iter__38235(cljs.core.rest(s__38236__$2)));
}
} else {
return null;
}
break;
}
});})(i__38219,child_record,c__7187__auto__,size__7188__auto__,b__38220,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name))
,null,null));
});})(i__38219,child_record,c__7187__auto__,size__7188__auto__,b__38220,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__38248 = (i__38219 + (1));
i__38219 = G__38248;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38220),hatti$map$utils$iter__38217(cljs.core.chunk_rest(s__38218__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38220),null);
}
} else {
var child_record = cljs.core.first(s__38218__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name){
return (function hatti$map$utils$iter__38217_$_iter__38241(s__38242){
return (new cljs.core.LazySeq(null,((function (child_record,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name){
return (function (){
var s__38242__$1 = s__38242;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__38242__$1);
if(temp__4657__auto____$1){
var s__38242__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38242__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38242__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38244 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38243 = (0);
while(true){
if((i__38243 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38243);
cljs.core.chunk_append(b__38244,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__38249 = (i__38243 + (1));
i__38243 = G__38249;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38244),hatti$map$utils$iter__38217_$_iter__38241(cljs.core.chunk_rest(s__38242__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38244),null);
}
} else {
var child = cljs.core.first(s__38242__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__38217_$_iter__38241(cljs.core.rest(s__38242__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name))
,null,null));
});})(child_record,s__38218__$2,temp__4657__auto__,map__38215,map__38215__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__38217(cljs.core.rest(s__38218__$2)));
}
} else {
return null;
}
break;
}
});})(map__38215,map__38215__$1,field,children,full_name))
,null,null));
});})(map__38215,map__38215__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__38252(s__38253){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__38253__$1 = s__38253;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38253__$1);
if(temp__4657__auto__){
var s__38253__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38253__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38253__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38255 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38254 = (0);
while(true){
if((i__38254 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38254);
cljs.core.chunk_append(b__38255,(function (){var vec__38264 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38264,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38264,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38264,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38264,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__38271 = (i__38254 + (1));
i__38254 = G__38271;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38255),hatti$map$utils$iter__38252(cljs.core.chunk_rest(s__38253__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38255),null);
}
} else {
var coord_string = cljs.core.first(s__38253__$2);
return cljs.core.cons((function (){var vec__38267 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38267,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38267,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38267,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38267,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__38252(cljs.core.rest(s__38253__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__38270 = geotype;
switch (G__38270) {
case "Point":
return ((function (G__38270,geotype,parse){
return (function (p1__38250_SHARP_){
return cljs.core.first(parse(p1__38250_SHARP_));
});
;})(G__38270,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__38270,geotype,parse){
return (function (p1__38251_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__38251_SHARP_)],null));
});
;})(G__38270,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args38274 = [];
var len__7484__auto___38295 = arguments.length;
var i__7485__auto___38296 = (0);
while(true){
if((i__7485__auto___38296 < len__7484__auto___38295)){
args38274.push((arguments[i__7485__auto___38296]));

var G__38297 = (i__7485__auto___38296 + (1));
i__7485__auto___38296 = G__38297;
continue;
} else {
}
break;
}

var G__38276 = args38274.length;
switch (G__38276) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38274.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__38277(s__38278){
return (new cljs.core.LazySeq(null,(function (){
var s__38278__$1 = s__38278;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38278__$1);
if(temp__4657__auto__){
var s__38278__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38278__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38278__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38280 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38279 = (0);
while(true){
if((i__38279 < size__7188__auto__)){
var vec__38289 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38279);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38289,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38289,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__38280,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__38279,s__38278__$1,geom_or_geoms,vec__38289,idx,record,c__7187__auto__,size__7188__auto__,b__38280,s__38278__$2,temp__4657__auto__){
return (function (p1__38273_SHARP_){
return hatti.map.utils.make_feature(p1__38273_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__38279,s__38278__$1,geom_or_geoms,vec__38289,idx,record,c__7187__auto__,size__7188__auto__,b__38280,s__38278__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__38299 = (i__38279 + (1));
i__38279 = G__38299;
continue;
} else {
var G__38300 = (i__38279 + (1));
i__38279 = G__38300;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38280),hatti$map$utils$iter__38277(cljs.core.chunk_rest(s__38278__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38280),null);
}
} else {
var vec__38292 = cljs.core.first(s__38278__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38292,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38292,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__38278__$1,geom_or_geoms,vec__38292,idx,record,s__38278__$2,temp__4657__auto__){
return (function (p1__38273_SHARP_){
return hatti.map.utils.make_feature(p1__38273_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__38278__$1,geom_or_geoms,vec__38292,idx,record,s__38278__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__38277(cljs.core.rest(s__38278__$2)));
} else {
var G__38301 = cljs.core.rest(s__38278__$2);
s__38278__$1 = G__38301;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__38303){
var map__38306 = p__38303;
var map__38306__$1 = ((((!((map__38306 == null)))?((((map__38306.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38306.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38306):map__38306);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38306__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38306__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__38306,map__38306__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__38302_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__38302_SHARP_));
});})(map__38306,map__38306__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38320 = arguments.length;
var i__7485__auto___38321 = (0);
while(true){
if((i__7485__auto___38321 < len__7484__auto___38320)){
args__7491__auto__.push((arguments[i__7485__auto___38321]));

var G__38322 = (i__7485__auto___38321 + (1));
i__7485__auto___38321 = G__38322;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__38317){
var map__38318 = p__38317;
var map__38318__$1 = ((((!((map__38318 == null)))?((((map__38318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38318):map__38318);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38318__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__38318,map__38318__$1,rezoom_QMARK_){
return (function (p1__38308_SHARP_,p2__38309_SHARP_){
return hatti.map.utils.register_mouse_events(p1__38308_SHARP_,p2__38309_SHARP_,event_chan);
});})(map__38318,map__38318__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__38318,map__38318__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__38318,map__38318__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__38318,map__38318__$1,rezoom_QMARK_){
return (function (p1__38311_SHARP_,p2__38310_SHARP_){
return L.circleMarker(p2__38310_SHARP_);
});})(on_events,geometry_type,stylefn,map__38318,map__38318__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__38318,map__38318__$1,rezoom_QMARK_){
return (function (p1__38312_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__38312_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__38318,map__38318__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq38313){
var G__38314 = cljs.core.first(seq38313);
var seq38313__$1 = cljs.core.next(seq38313);
var G__38315 = cljs.core.first(seq38313__$1);
var seq38313__$2 = cljs.core.next(seq38313__$1);
var G__38316 = cljs.core.first(seq38313__$2);
var seq38313__$3 = cljs.core.next(seq38313__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__38314,G__38315,G__38316,seq38313__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__38323,flat_form){
var map__38329 = p__38323;
var map__38329__$1 = ((((!((map__38329 == null)))?((((map__38329.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38329.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38329):map__38329);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38329__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38329__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38329__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38329,map__38329__$1,column,filter,value){
return (function (p__38331){
var map__38332 = p__38331;
var map__38332__$1 = ((((!((map__38332 == null)))?((((map__38332.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38332.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38332):map__38332);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38332__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__38329,map__38329__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38334_SHARP_){
return hatti.map.utils.get_filter(p1__38334_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38344 = arguments.length;
var i__7485__auto___38345 = (0);
while(true){
if((i__7485__auto___38345 < len__7484__auto___38344)){
args__7491__auto__.push((arguments[i__7485__auto___38345]));

var G__38346 = (i__7485__auto___38345 + (1));
i__7485__auto___38345 = G__38346;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__38340){
var vec__38341 = p__38340;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38341,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq38335){
var G__38336 = cljs.core.first(seq38335);
var seq38335__$1 = cljs.core.next(seq38335);
var G__38337 = cljs.core.first(seq38335__$1);
var seq38335__$2 = cljs.core.next(seq38335__$1);
var G__38338 = cljs.core.first(seq38335__$2);
var seq38335__$3 = cljs.core.next(seq38335__$2);
var G__38339 = cljs.core.first(seq38335__$3);
var seq38335__$4 = cljs.core.next(seq38335__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__38336,G__38337,G__38338,G__38339,seq38335__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__38347){
var map__38351 = p__38347;
var map__38351__$1 = ((((!((map__38351 == null)))?((((map__38351.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38351.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38351):map__38351);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38351__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38351__$1,cljs.core.cst$kw$geojson);
var cluster = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38351__$1,cljs.core.cst$kw$cluster,false);
var clusterRadius = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38351__$1,cljs.core.cst$kw$clusterRadius);
var clusterMaxZoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38351__$1,cljs.core.cst$kw$clusterMaxZoom);
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson,cljs.core.cst$kw$cluster,cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js((function (){var G__38353 = geojson_source_defn;
var G__38353__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38353,cljs.core.cst$kw$clusterRadius,clusterRadius):G__38353);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38353__$1,cljs.core.cst$kw$clusterMaxZoom,clusterMaxZoom);
} else {
return G__38353__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"vector",cljs.core.cst$kw$tiles,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38362 = arguments.length;
var i__7485__auto___38363 = (0);
while(true){
if((i__7485__auto___38363 < len__7484__auto___38362)){
args__7491__auto__.push((arguments[i__7485__auto___38363]));

var G__38364 = (i__7485__auto___38363 + (1));
i__7485__auto___38363 = G__38364;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__38358){
var map__38359 = p__38358;
var map__38359__$1 = ((((!((map__38359 == null)))?((((map__38359.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38359.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38359):map__38359);
var layer_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38359__$1,cljs.core.cst$kw$layer_DASH_id);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38359__$1,cljs.core.cst$kw$layout);
var paint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38359__$1,cljs.core.cst$kw$paint);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38359__$1,cljs.core.cst$kw$filter);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38359__$1,cljs.core.cst$kw$tiles_DASH_url);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string], null);
var layer = cljs.core.clj__GT_js((function (){var G__38361 = layer_def;
var G__38361__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38361,cljs.core.cst$kw$source_DASH_layer,hatti.constants.vector_source_layer):G__38361);
var G__38361__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38361__$1,cljs.core.cst$kw$paint,paint):G__38361__$1);
var G__38361__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38361__$2,cljs.core.cst$kw$layout,layout):G__38361__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38361__$3,cljs.core.cst$kw$filter,filter);
} else {
return G__38361__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq38354){
var G__38355 = cljs.core.first(seq38354);
var seq38354__$1 = cljs.core.next(seq38354);
var G__38356 = cljs.core.first(seq38354__$1);
var seq38354__$2 = cljs.core.next(seq38354__$1);
var G__38357 = cljs.core.first(seq38354__$2);
var seq38354__$3 = cljs.core.next(seq38354__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__38355,G__38356,G__38357,seq38354__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38370 = arguments.length;
var i__7485__auto___38371 = (0);
while(true){
if((i__7485__auto___38371 < len__7484__auto___38370)){
args__7491__auto__.push((arguments[i__7485__auto___38371]));

var G__38372 = (i__7485__auto___38371 + (1));
i__7485__auto___38371 = G__38372;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__38366){
var vec__38367 = p__38366;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38367,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38367,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38367,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq38365){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38365));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38381 = arguments.length;
var i__7485__auto___38382 = (0);
while(true){
if((i__7485__auto___38382 < len__7484__auto___38381)){
args__7491__auto__.push((arguments[i__7485__auto___38382]));

var G__38383 = (i__7485__auto___38382 + (1));
i__7485__auto___38382 = G__38383;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__38376){
var map__38377 = p__38376;
var map__38377__$1 = ((((!((map__38377 == null)))?((((map__38377.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38377.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38377):map__38377);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38377__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38377__$1,cljs.core.cst$kw$stops);
var G__38379 = (function (){var G__38380 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__38380) : style_type.call(null,G__38380));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__38379) : style_state.call(null,G__38379));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq38373){
var G__38374 = cljs.core.first(seq38373);
var seq38373__$1 = cljs.core.next(seq38373);
var G__38375 = cljs.core.first(seq38373__$1);
var seq38373__$2 = cljs.core.next(seq38373__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__38374,G__38375,seq38373__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__38394 = cljs.core.seq(properties);
var chunk__38395 = null;
var count__38396 = (0);
var i__38397 = (0);
while(true){
if((i__38397 < count__38396)){
var vec__38398 = chunk__38395.cljs$core$IIndexed$_nth$arity$2(null,i__38397);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38398,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38398,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__38404 = seq__38394;
var G__38405 = chunk__38395;
var G__38406 = count__38396;
var G__38407 = (i__38397 + (1));
seq__38394 = G__38404;
chunk__38395 = G__38405;
count__38396 = G__38406;
i__38397 = G__38407;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38394);
if(temp__4657__auto__){
var seq__38394__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38394__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38394__$1);
var G__38408 = cljs.core.chunk_rest(seq__38394__$1);
var G__38409 = c__7220__auto__;
var G__38410 = cljs.core.count(c__7220__auto__);
var G__38411 = (0);
seq__38394 = G__38408;
chunk__38395 = G__38409;
count__38396 = G__38410;
i__38397 = G__38411;
continue;
} else {
var vec__38401 = cljs.core.first(seq__38394__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38401,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38401,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__38412 = cljs.core.next(seq__38394__$1);
var G__38413 = null;
var G__38414 = (0);
var G__38415 = (0);
seq__38394 = G__38412;
chunk__38395 = G__38413;
count__38396 = G__38414;
i__38397 = G__38415;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
map.off("mousemove");

map.off("click");

map.on("mousemove",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
}));

return map.on("click",(function (e){
var layer_id = id_string;
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
}));
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38423 = arguments.length;
var i__7485__auto___38424 = (0);
while(true){
if((i__7485__auto___38424 < len__7484__auto___38423)){
args__7491__auto__.push((arguments[i__7485__auto___38424]));

var G__38425 = (i__7485__auto___38424 + (1));
i__7485__auto___38424 = G__38425;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__38419){
var vec__38420 = p__38419;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38420,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq38416){
var G__38417 = cljs.core.first(seq38416);
var seq38416__$1 = cljs.core.next(seq38416);
var G__38418 = cljs.core.first(seq38416__$1);
var seq38416__$2 = cljs.core.next(seq38416__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__38417,G__38418,seq38416__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(field){
if(cljs.core.truth_(hatti.ona.forms.geoshape_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_(hatti.ona.forms.geotrace_QMARK_(field))){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$layer_DASH_type,"line",cljs.core.cst$kw$style,cljs.core.cst$kw$line,cljs.core.cst$kw$layout,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line_DASH_join,"round",cljs.core.cst$kw$line_DASH_cap,"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__38432 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__38432){
return (function (p__38433){
var map__38434 = p__38433;
var map__38434__$1 = ((((!((map__38434 == null)))?((((map__38434.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38434.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38434):map__38434);
var map__38435 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38434__$1,cljs.core.cst$kw$properties);
var map__38435__$1 = ((((!((map__38435 == null)))?((((map__38435.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38435.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38435):map__38435);
var _id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38435__$1,cljs.core.cst$kw$_id);
return chimera.seq.in_QMARK_(selected_ids,_id);
});})(G__38432))
,G__38432);
} else {
return G__38432;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__38460(s__38461){
return (new cljs.core.LazySeq(null,(function (){
var s__38461__$1 = s__38461;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38461__$1);
if(temp__4657__auto__){
var s__38461__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38461__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38461__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38463 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38462 = (0);
while(true){
if((i__38462 < size__7188__auto__)){
var map__38474 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38462);
var map__38474__$1 = ((((!((map__38474 == null)))?((((map__38474.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38474.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38474):map__38474);
var feature = map__38474__$1;
var map__38475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38474__$1,cljs.core.cst$kw$properties);
var map__38475__$1 = ((((!((map__38475 == null)))?((((map__38475.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38475.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38475):map__38475);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38475__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
cljs.core.chunk_append(b__38463,(((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null));

var G__38482 = (i__38462 + (1));
i__38462 = G__38482;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38463),hatti$map$utils$count_hexbin_points_$_iter__38460(cljs.core.chunk_rest(s__38461__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38463),null);
}
} else {
var map__38478 = cljs.core.first(s__38461__$2);
var map__38478__$1 = ((((!((map__38478 == null)))?((((map__38478.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38478.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38478):map__38478);
var feature = map__38478__$1;
var map__38479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38478__$1,cljs.core.cst$kw$properties);
var map__38479__$1 = ((((!((map__38479 == null)))?((((map__38479.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38479.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38479):map__38479);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38479__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
return cljs.core.cons((((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__38460(cljs.core.rest(s__38461__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38490 = arguments.length;
var i__7485__auto___38491 = (0);
while(true){
if((i__7485__auto___38491 < len__7484__auto___38490)){
args__7491__auto__.push((arguments[i__7485__auto___38491]));

var G__38492 = (i__7485__auto___38491 + (1));
i__7485__auto___38491 = G__38492;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__38487){
var map__38488 = p__38487;
var map__38488__$1 = ((((!((map__38488 == null)))?((((map__38488.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38488.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38488):map__38488);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38488__$1,cljs.core.cst$kw$geojson);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38488__$1,cljs.core.cst$kw$selected_DASH_ids);

var get_rendered_features = ((function (map__38488,map__38488__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__38488,map__38488__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,get_rendered_features()], null);
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$features], null),((function (get_rendered_features,rendered_features,map__38488,map__38488__$1,geojson,selected_ids){
return (function (p1__38483_SHARP_){
return hatti.map.utils.filter_selected_features(p1__38483_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__38488,map__38488__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq38484){
var G__38485 = cljs.core.first(seq38484);
var seq38484__$1 = cljs.core.next(seq38484);
var G__38486 = cljs.core.first(seq38484__$1);
var seq38484__$2 = cljs.core.next(seq38484__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__38485,G__38486,seq38484__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__38493){
var map__38502 = p__38493;
var map__38502__$1 = ((((!((map__38502 == null)))?((((map__38502.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38502.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38502):map__38502);
var cell_width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38502__$1,cljs.core.cst$kw$cell_DASH_width);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38502__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,layer_id,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var js_rendered_features = cljs.core.clj__GT_js(rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hex_collection,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var features_w_count = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points(hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38502,map__38502__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__38504(s__38505){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38502,map__38502__$1,cell_width,selected_ids){
return (function (){
var s__38505__$1 = s__38505;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38505__$1);
if(temp__4657__auto__){
var s__38505__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38505__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38505__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38507 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38506 = (0);
while(true){
if((i__38506 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38506);
cljs.core.chunk_append(b__38507,cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)));

var G__38510 = (i__38506 + (1));
i__38506 = G__38510;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38507),hatti$map$utils$generate_hexgrid_$_iter__38504(cljs.core.chunk_rest(s__38505__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38507),null);
}
} else {
var f = cljs.core.first(s__38505__$2);
return cljs.core.cons(cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__38504(cljs.core.rest(s__38505__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38502,map__38502__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__38502,map__38502__$1,cell_width,selected_ids))
;
return iter__7189__auto__(features_w_count);
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(hexbins,cljs.core.cst$kw$features,features_w_count,cljs.core.array_seq([cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,point_counts),cljs.core.cst$kw$max_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,point_counts)], null)], 0));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38518 = arguments.length;
var i__7485__auto___38519 = (0);
while(true){
if((i__7485__auto___38519 < len__7484__auto___38518)){
args__7491__auto__.push((arguments[i__7485__auto___38519]));

var G__38520 = (i__7485__auto___38519 + (1));
i__7485__auto___38519 = G__38520;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__38514){
var vec__38515 = p__38514;
var hide_points_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38515,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
map.setLayoutProperty(layer_id,"visibility",visibility);

return map.setLayoutProperty("point-casting","visibility",visibility);
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq38511){
var G__38512 = cljs.core.first(seq38511);
var seq38511__$1 = cljs.core.next(seq38511);
var G__38513 = cljs.core.first(seq38511__$1);
var seq38511__$2 = cljs.core.next(seq38511__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__38512,G__38513,seq38511__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38527 = arguments.length;
var i__7485__auto___38528 = (0);
while(true){
if((i__7485__auto___38528 < len__7484__auto___38527)){
args__7491__auto__.push((arguments[i__7485__auto___38528]));

var G__38529 = (i__7485__auto___38528 + (1));
i__7485__auto___38528 = G__38529;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__38524){
var map__38525 = p__38524;
var map__38525__$1 = ((((!((map__38525 == null)))?((((map__38525.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38525.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38525):map__38525);
var keep_source_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38525__$1,cljs.core.cst$kw$keep_DASH_source_QMARK_);
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq38521){
var G__38522 = cljs.core.first(seq38521);
var seq38521__$1 = cljs.core.next(seq38521);
var G__38523 = cljs.core.first(seq38521__$1);
var seq38521__$2 = cljs.core.next(seq38521__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__38522,G__38523,seq38521__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__38530){
var map__38535 = p__38530;
var map__38535__$1 = ((((!((map__38535 == null)))?((((map__38535.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38535.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38535):map__38535);
var opts = map__38535__$1;
var cell_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38535__$1,cljs.core.cst$kw$cell_DASH_color);
var extrusion_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38535__$1,cljs.core.cst$kw$extrusion_QMARK_);
var hide_points_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38535__$1,cljs.core.cst$kw$hide_DASH_points_QMARK_);
var hexgrid = hatti.map.utils.generate_hexgrid(map,id_string,geojson,opts);
var map__38537 = cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__38537__$1 = ((((!((map__38537 == null)))?((((map__38537.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38537.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38537):map__38537);
var min_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38537__$1,cljs.core.cst$kw$min_DASH_count);
var max_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38537__$1,cljs.core.cst$kw$max_DASH_count);
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,"point-count",cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_extrusion_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_extrusion_DASH_opacity,fill_opacity,cljs.core.cst$kw$fill_DASH_extrusion_DASH_height,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),cljs.core.cst$kw$base,(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_outline_DASH_color,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),cljs.core.cst$kw$fill_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_opacity,fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$geojson,hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint], 0));

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint,cljs.core.cst$kw$layer_DASH_id,extrusion_layer_id], 0));

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(map,extrusion_layer_id,cljs.core.array_seq([cljs.core.cst$kw$keep_DASH_source_QMARK_,true], 0));
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([hide_points_QMARK_], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_hexbins_QMARK_,true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__38539){
var map__38558 = p__38539;
var map__38558__$1 = ((((!((map__38558 == null)))?((((map__38558.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38558.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38558):map__38558);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38558__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var layers = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (rendered_features,map__38558,map__38558__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__38558,map__38558__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count(layers);
hatti.map.utils.add_mapboxgl_source(map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$geojson,rendered_features,cljs.core.cst$kw$cluster,true,cljs.core.cst$kw$clusterRadius,(20),cljs.core.cst$kw$clusterMaxZoom,(15)], null));

var seq__38560_38576 = cljs.core.seq(layers);
var chunk__38561_38577 = null;
var count__38562_38578 = (0);
var i__38563_38579 = (0);
while(true){
if((i__38563_38579 < count__38562_38578)){
var vec__38564_38580 = chunk__38561_38577.cljs$core$IIndexed$_nth$arity$2(null,i__38563_38579);
var i_38581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38564_38580,(0),null);
var vec__38567_38582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38564_38580,(1),null);
var point_count_38583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38567_38582,(0),null);
var color_38584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38567_38582,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_38581)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_38584,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_38581,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38583], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38583], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_38581 + (1)))))], null)], null))], 0));

var G__38585 = seq__38560_38576;
var G__38586 = chunk__38561_38577;
var G__38587 = count__38562_38578;
var G__38588 = (i__38563_38579 + (1));
seq__38560_38576 = G__38585;
chunk__38561_38577 = G__38586;
count__38562_38578 = G__38587;
i__38563_38579 = G__38588;
continue;
} else {
var temp__4657__auto___38589 = cljs.core.seq(seq__38560_38576);
if(temp__4657__auto___38589){
var seq__38560_38590__$1 = temp__4657__auto___38589;
if(cljs.core.chunked_seq_QMARK_(seq__38560_38590__$1)){
var c__7220__auto___38591 = cljs.core.chunk_first(seq__38560_38590__$1);
var G__38592 = cljs.core.chunk_rest(seq__38560_38590__$1);
var G__38593 = c__7220__auto___38591;
var G__38594 = cljs.core.count(c__7220__auto___38591);
var G__38595 = (0);
seq__38560_38576 = G__38592;
chunk__38561_38577 = G__38593;
count__38562_38578 = G__38594;
i__38563_38579 = G__38595;
continue;
} else {
var vec__38570_38596 = cljs.core.first(seq__38560_38590__$1);
var i_38597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38570_38596,(0),null);
var vec__38573_38598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38570_38596,(1),null);
var point_count_38599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38573_38598,(0),null);
var color_38600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38573_38598,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_38597)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_38600,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_38597,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38599], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_38599], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_38597 + (1)))))], null)], null))], 0));

var G__38601 = cljs.core.next(seq__38560_38590__$1);
var G__38602 = null;
var G__38603 = (0);
var G__38604 = (0);
seq__38560_38576 = G__38601;
chunk__38561_38577 = G__38602;
count__38562_38578 = G__38603;
i__38563_38579 = G__38604;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([true], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_heatmap_QMARK_,true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38616 = arguments.length;
var i__7485__auto___38617 = (0);
while(true){
if((i__7485__auto___38617 < len__7484__auto___38616)){
args__7491__auto__.push((arguments[i__7485__auto___38617]));

var G__38618 = (i__7485__auto___38617 + (1));
i__7485__auto___38617 = G__38618;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__38609){
var map__38610 = p__38609;
var map__38610__$1 = ((((!((map__38610 == null)))?((((map__38610.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38610.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38610):map__38610);
var map_data = map__38610__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38610__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38610__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38610__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38610__$1,cljs.core.cst$kw$geojson);
var map__38612 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__38612__$1 = ((((!((map__38612 == null)))?((((map__38612.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38612.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38612):map__38612);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38612__$1,cljs.core.cst$kw$layer_DASH_type);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38612__$1,cljs.core.cst$kw$layout);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38612__$1,cljs.core.cst$kw$style);
var map__38613 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__38613__$1 = ((((!((map__38613 == null)))?((((map__38613.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38613.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38613):map__38613);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38613__$1,cljs.core.cst$kw$stops);
var layer_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38613__$1,cljs.core.cst$kw$layer_DASH_opts);
var show_hexbins_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38613__$1,cljs.core.cst$kw$show_DASH_hexbins_QMARK_);
var show_heatmap_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38613__$1,cljs.core.cst$kw$show_DASH_heatmap_QMARK_);
var circle_border = "point-casting";
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,false);

hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layout,layout,cljs.core.cst$kw$tiles_DASH_url,tiles_url], 0));

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,circle_border,cljs.core.cst$kw$tiles_DASH_url,tiles_url,cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(circle_border))){
map.removeLayer(circle_border);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins(owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap(owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq38605){
var G__38606 = cljs.core.first(seq38605);
var seq38605__$1 = cljs.core.next(seq38605);
var G__38607 = cljs.core.first(seq38605__$1);
var seq38605__$2 = cljs.core.next(seq38605__$1);
var G__38608 = cljs.core.first(seq38605__$2);
var seq38605__$3 = cljs.core.next(seq38605__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__38606,G__38607,G__38608,seq38605__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__38621 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__38621__$1 = ((((!((map__38621 == null)))?((((map__38621.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38621.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38621):map__38621);
var mapboxgl_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38621__$1,cljs.core.cst$kw$mapboxgl_DASH_map);
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38621__$1,cljs.core.cst$kw$zoom);
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(zoom,next_zoom)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$zoom,next_zoom);
} else {
return null;
}
});
