// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31156 = [];
var len__7484__auto___31162 = arguments.length;
var i__7485__auto___31163 = (0);
while(true){
if((i__7485__auto___31163 < len__7484__auto___31162)){
args31156.push((arguments[i__7485__auto___31163]));

var G__31164 = (i__7485__auto___31163 + (1));
i__7485__auto___31163 = G__31164;
continue;
} else {
}
break;
}

var G__31158 = args31156.length;
switch (G__31158) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31156.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31159 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31159 = (function (f,blockable,meta31160){
this.f = f;
this.blockable = blockable;
this.meta31160 = meta31160;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31159.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31161,meta31160__$1){
var self__ = this;
var _31161__$1 = this;
return (new cljs.core.async.t_cljs$core$async31159(self__.f,self__.blockable,meta31160__$1));
});

cljs.core.async.t_cljs$core$async31159.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31161){
var self__ = this;
var _31161__$1 = this;
return self__.meta31160;
});

cljs.core.async.t_cljs$core$async31159.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31159.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31159.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31159.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31159.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31160], null);
});

cljs.core.async.t_cljs$core$async31159.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31159.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31159";

cljs.core.async.t_cljs$core$async31159.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31159");
});

cljs.core.async.__GT_t_cljs$core$async31159 = (function cljs$core$async$__GT_t_cljs$core$async31159(f__$1,blockable__$1,meta31160){
return (new cljs.core.async.t_cljs$core$async31159(f__$1,blockable__$1,meta31160));
});

}

return (new cljs.core.async.t_cljs$core$async31159(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31168 = [];
var len__7484__auto___31171 = arguments.length;
var i__7485__auto___31172 = (0);
while(true){
if((i__7485__auto___31172 < len__7484__auto___31171)){
args31168.push((arguments[i__7485__auto___31172]));

var G__31173 = (i__7485__auto___31172 + (1));
i__7485__auto___31172 = G__31173;
continue;
} else {
}
break;
}

var G__31170 = args31168.length;
switch (G__31170) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31168.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31175 = [];
var len__7484__auto___31178 = arguments.length;
var i__7485__auto___31179 = (0);
while(true){
if((i__7485__auto___31179 < len__7484__auto___31178)){
args31175.push((arguments[i__7485__auto___31179]));

var G__31180 = (i__7485__auto___31179 + (1));
i__7485__auto___31179 = G__31180;
continue;
} else {
}
break;
}

var G__31177 = args31175.length;
switch (G__31177) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31175.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31182 = [];
var len__7484__auto___31185 = arguments.length;
var i__7485__auto___31186 = (0);
while(true){
if((i__7485__auto___31186 < len__7484__auto___31185)){
args31182.push((arguments[i__7485__auto___31186]));

var G__31187 = (i__7485__auto___31186 + (1));
i__7485__auto___31186 = G__31187;
continue;
} else {
}
break;
}

var G__31184 = args31182.length;
switch (G__31184) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31182.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31189 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31189) : fn1.call(null,val_31189));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31189,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31189) : fn1.call(null,val_31189));
});})(val_31189,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31190 = [];
var len__7484__auto___31193 = arguments.length;
var i__7485__auto___31194 = (0);
while(true){
if((i__7485__auto___31194 < len__7484__auto___31193)){
args31190.push((arguments[i__7485__auto___31194]));

var G__31195 = (i__7485__auto___31194 + (1));
i__7485__auto___31194 = G__31195;
continue;
} else {
}
break;
}

var G__31192 = args31190.length;
switch (G__31192) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31190.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___31197 = n;
var x_31198 = (0);
while(true){
if((x_31198 < n__7324__auto___31197)){
(a[x_31198] = (0));

var G__31199 = (x_31198 + (1));
x_31198 = G__31199;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31200 = (i + (1));
i = G__31200;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31204 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31204 = (function (alt_flag,flag,meta31205){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta31205 = meta31205;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31204.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31206,meta31205__$1){
var self__ = this;
var _31206__$1 = this;
return (new cljs.core.async.t_cljs$core$async31204(self__.alt_flag,self__.flag,meta31205__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31204.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31206){
var self__ = this;
var _31206__$1 = this;
return self__.meta31205;
});})(flag))
;

cljs.core.async.t_cljs$core$async31204.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31204.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31204.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31204.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31204.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31205], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31204.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31204.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31204";

cljs.core.async.t_cljs$core$async31204.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31204");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31204 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31204(alt_flag__$1,flag__$1,meta31205){
return (new cljs.core.async.t_cljs$core$async31204(alt_flag__$1,flag__$1,meta31205));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31204(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31210 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31210 = (function (alt_handler,flag,cb,meta31211){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta31211 = meta31211;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31210.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31212,meta31211__$1){
var self__ = this;
var _31212__$1 = this;
return (new cljs.core.async.t_cljs$core$async31210(self__.alt_handler,self__.flag,self__.cb,meta31211__$1));
});

cljs.core.async.t_cljs$core$async31210.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31212){
var self__ = this;
var _31212__$1 = this;
return self__.meta31211;
});

cljs.core.async.t_cljs$core$async31210.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31210.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31210.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31210.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31210.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31211], null);
});

cljs.core.async.t_cljs$core$async31210.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31210.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31210";

cljs.core.async.t_cljs$core$async31210.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31210");
});

cljs.core.async.__GT_t_cljs$core$async31210 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31210(alt_handler__$1,flag__$1,cb__$1,meta31211){
return (new cljs.core.async.t_cljs$core$async31210(alt_handler__$1,flag__$1,cb__$1,meta31211));
});

}

return (new cljs.core.async.t_cljs$core$async31210(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31213_SHARP_){
var G__31217 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31213_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31217) : fret.call(null,G__31217));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31214_SHARP_){
var G__31218 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31214_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31218) : fret.call(null,G__31218));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31219 = (i + (1));
i = G__31219;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31225 = arguments.length;
var i__7485__auto___31226 = (0);
while(true){
if((i__7485__auto___31226 < len__7484__auto___31225)){
args__7491__auto__.push((arguments[i__7485__auto___31226]));

var G__31227 = (i__7485__auto___31226 + (1));
i__7485__auto___31226 = G__31227;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31222){
var map__31223 = p__31222;
var map__31223__$1 = ((((!((map__31223 == null)))?((((map__31223.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31223.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31223):map__31223);
var opts = map__31223__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31220){
var G__31221 = cljs.core.first(seq31220);
var seq31220__$1 = cljs.core.next(seq31220);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31221,seq31220__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31228 = [];
var len__7484__auto___31278 = arguments.length;
var i__7485__auto___31279 = (0);
while(true){
if((i__7485__auto___31279 < len__7484__auto___31278)){
args31228.push((arguments[i__7485__auto___31279]));

var G__31280 = (i__7485__auto___31279 + (1));
i__7485__auto___31279 = G__31280;
continue;
} else {
}
break;
}

var G__31230 = args31228.length;
switch (G__31230) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31228.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12301__auto___31282 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___31282){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___31282){
return (function (state_31254){
var state_val_31255 = (state_31254[(1)]);
if((state_val_31255 === (7))){
var inst_31250 = (state_31254[(2)]);
var state_31254__$1 = state_31254;
var statearr_31256_31283 = state_31254__$1;
(statearr_31256_31283[(2)] = inst_31250);

(statearr_31256_31283[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (1))){
var state_31254__$1 = state_31254;
var statearr_31257_31284 = state_31254__$1;
(statearr_31257_31284[(2)] = null);

(statearr_31257_31284[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (4))){
var inst_31233 = (state_31254[(7)]);
var inst_31233__$1 = (state_31254[(2)]);
var inst_31234 = (inst_31233__$1 == null);
var state_31254__$1 = (function (){var statearr_31258 = state_31254;
(statearr_31258[(7)] = inst_31233__$1);

return statearr_31258;
})();
if(cljs.core.truth_(inst_31234)){
var statearr_31259_31285 = state_31254__$1;
(statearr_31259_31285[(1)] = (5));

} else {
var statearr_31260_31286 = state_31254__$1;
(statearr_31260_31286[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (13))){
var state_31254__$1 = state_31254;
var statearr_31261_31287 = state_31254__$1;
(statearr_31261_31287[(2)] = null);

(statearr_31261_31287[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (6))){
var inst_31233 = (state_31254[(7)]);
var state_31254__$1 = state_31254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31254__$1,(11),to,inst_31233);
} else {
if((state_val_31255 === (3))){
var inst_31252 = (state_31254[(2)]);
var state_31254__$1 = state_31254;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31254__$1,inst_31252);
} else {
if((state_val_31255 === (12))){
var state_31254__$1 = state_31254;
var statearr_31262_31288 = state_31254__$1;
(statearr_31262_31288[(2)] = null);

(statearr_31262_31288[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (2))){
var state_31254__$1 = state_31254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31254__$1,(4),from);
} else {
if((state_val_31255 === (11))){
var inst_31243 = (state_31254[(2)]);
var state_31254__$1 = state_31254;
if(cljs.core.truth_(inst_31243)){
var statearr_31263_31289 = state_31254__$1;
(statearr_31263_31289[(1)] = (12));

} else {
var statearr_31264_31290 = state_31254__$1;
(statearr_31264_31290[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (9))){
var state_31254__$1 = state_31254;
var statearr_31265_31291 = state_31254__$1;
(statearr_31265_31291[(2)] = null);

(statearr_31265_31291[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (5))){
var state_31254__$1 = state_31254;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31266_31292 = state_31254__$1;
(statearr_31266_31292[(1)] = (8));

} else {
var statearr_31267_31293 = state_31254__$1;
(statearr_31267_31293[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (14))){
var inst_31248 = (state_31254[(2)]);
var state_31254__$1 = state_31254;
var statearr_31268_31294 = state_31254__$1;
(statearr_31268_31294[(2)] = inst_31248);

(statearr_31268_31294[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (10))){
var inst_31240 = (state_31254[(2)]);
var state_31254__$1 = state_31254;
var statearr_31269_31295 = state_31254__$1;
(statearr_31269_31295[(2)] = inst_31240);

(statearr_31269_31295[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31255 === (8))){
var inst_31237 = cljs.core.async.close_BANG_(to);
var state_31254__$1 = state_31254;
var statearr_31270_31296 = state_31254__$1;
(statearr_31270_31296[(2)] = inst_31237);

(statearr_31270_31296[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___31282))
;
return ((function (switch__12189__auto__,c__12301__auto___31282){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_31274 = [null,null,null,null,null,null,null,null];
(statearr_31274[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_31274[(1)] = (1));

return statearr_31274;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_31254){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31254);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31275){if((e31275 instanceof Object)){
var ex__12193__auto__ = e31275;
var statearr_31276_31297 = state_31254;
(statearr_31276_31297[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31254);

return cljs.core.cst$kw$recur;
} else {
throw e31275;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31298 = state_31254;
state_31254 = G__31298;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_31254){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_31254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___31282))
})();
var state__12303__auto__ = (function (){var statearr_31277 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___31282);

return statearr_31277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___31282))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31486){
var vec__31487 = p__31486;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31487,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31487,(1),null);
var job = vec__31487;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12301__auto___31673 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___31673,res,vec__31487,v,p,job,jobs,results){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___31673,res,vec__31487,v,p,job,jobs,results){
return (function (state_31494){
var state_val_31495 = (state_31494[(1)]);
if((state_val_31495 === (1))){
var state_31494__$1 = state_31494;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31494__$1,(2),res,v);
} else {
if((state_val_31495 === (2))){
var inst_31491 = (state_31494[(2)]);
var inst_31492 = cljs.core.async.close_BANG_(res);
var state_31494__$1 = (function (){var statearr_31496 = state_31494;
(statearr_31496[(7)] = inst_31491);

return statearr_31496;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31494__$1,inst_31492);
} else {
return null;
}
}
});})(c__12301__auto___31673,res,vec__31487,v,p,job,jobs,results))
;
return ((function (switch__12189__auto__,c__12301__auto___31673,res,vec__31487,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_31500 = [null,null,null,null,null,null,null,null];
(statearr_31500[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_31500[(1)] = (1));

return statearr_31500;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_31494){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31494);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31501){if((e31501 instanceof Object)){
var ex__12193__auto__ = e31501;
var statearr_31502_31674 = state_31494;
(statearr_31502_31674[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31494);

return cljs.core.cst$kw$recur;
} else {
throw e31501;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31675 = state_31494;
state_31494 = G__31675;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_31494){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_31494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___31673,res,vec__31487,v,p,job,jobs,results))
})();
var state__12303__auto__ = (function (){var statearr_31503 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31503[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___31673);

return statearr_31503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___31673,res,vec__31487,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31504){
var vec__31505 = p__31504;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31505,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31505,(1),null);
var job = vec__31505;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___31676 = n;
var __31677 = (0);
while(true){
if((__31677 < n__7324__auto___31676)){
var G__31508_31678 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31508_31678) {
case "compute":
var c__12301__auto___31680 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31677,c__12301__auto___31680,G__31508_31678,n__7324__auto___31676,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (__31677,c__12301__auto___31680,G__31508_31678,n__7324__auto___31676,jobs,results,process,async){
return (function (state_31521){
var state_val_31522 = (state_31521[(1)]);
if((state_val_31522 === (1))){
var state_31521__$1 = state_31521;
var statearr_31523_31681 = state_31521__$1;
(statearr_31523_31681[(2)] = null);

(statearr_31523_31681[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31522 === (2))){
var state_31521__$1 = state_31521;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31521__$1,(4),jobs);
} else {
if((state_val_31522 === (3))){
var inst_31519 = (state_31521[(2)]);
var state_31521__$1 = state_31521;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31521__$1,inst_31519);
} else {
if((state_val_31522 === (4))){
var inst_31511 = (state_31521[(2)]);
var inst_31512 = process(inst_31511);
var state_31521__$1 = state_31521;
if(cljs.core.truth_(inst_31512)){
var statearr_31524_31682 = state_31521__$1;
(statearr_31524_31682[(1)] = (5));

} else {
var statearr_31525_31683 = state_31521__$1;
(statearr_31525_31683[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31522 === (5))){
var state_31521__$1 = state_31521;
var statearr_31526_31684 = state_31521__$1;
(statearr_31526_31684[(2)] = null);

(statearr_31526_31684[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31522 === (6))){
var state_31521__$1 = state_31521;
var statearr_31527_31685 = state_31521__$1;
(statearr_31527_31685[(2)] = null);

(statearr_31527_31685[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31522 === (7))){
var inst_31517 = (state_31521[(2)]);
var state_31521__$1 = state_31521;
var statearr_31528_31686 = state_31521__$1;
(statearr_31528_31686[(2)] = inst_31517);

(statearr_31528_31686[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31677,c__12301__auto___31680,G__31508_31678,n__7324__auto___31676,jobs,results,process,async))
;
return ((function (__31677,switch__12189__auto__,c__12301__auto___31680,G__31508_31678,n__7324__auto___31676,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_31532 = [null,null,null,null,null,null,null];
(statearr_31532[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_31532[(1)] = (1));

return statearr_31532;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_31521){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31521);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31533){if((e31533 instanceof Object)){
var ex__12193__auto__ = e31533;
var statearr_31534_31687 = state_31521;
(statearr_31534_31687[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31521);

return cljs.core.cst$kw$recur;
} else {
throw e31533;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31688 = state_31521;
state_31521 = G__31688;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_31521){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_31521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(__31677,switch__12189__auto__,c__12301__auto___31680,G__31508_31678,n__7324__auto___31676,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_31535 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31535[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___31680);

return statearr_31535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(__31677,c__12301__auto___31680,G__31508_31678,n__7324__auto___31676,jobs,results,process,async))
);


break;
case "async":
var c__12301__auto___31689 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31677,c__12301__auto___31689,G__31508_31678,n__7324__auto___31676,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (__31677,c__12301__auto___31689,G__31508_31678,n__7324__auto___31676,jobs,results,process,async){
return (function (state_31548){
var state_val_31549 = (state_31548[(1)]);
if((state_val_31549 === (1))){
var state_31548__$1 = state_31548;
var statearr_31550_31690 = state_31548__$1;
(statearr_31550_31690[(2)] = null);

(statearr_31550_31690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31549 === (2))){
var state_31548__$1 = state_31548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31548__$1,(4),jobs);
} else {
if((state_val_31549 === (3))){
var inst_31546 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31548__$1,inst_31546);
} else {
if((state_val_31549 === (4))){
var inst_31538 = (state_31548[(2)]);
var inst_31539 = async(inst_31538);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31539)){
var statearr_31551_31691 = state_31548__$1;
(statearr_31551_31691[(1)] = (5));

} else {
var statearr_31552_31692 = state_31548__$1;
(statearr_31552_31692[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31549 === (5))){
var state_31548__$1 = state_31548;
var statearr_31553_31693 = state_31548__$1;
(statearr_31553_31693[(2)] = null);

(statearr_31553_31693[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31549 === (6))){
var state_31548__$1 = state_31548;
var statearr_31554_31694 = state_31548__$1;
(statearr_31554_31694[(2)] = null);

(statearr_31554_31694[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31549 === (7))){
var inst_31544 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
var statearr_31555_31695 = state_31548__$1;
(statearr_31555_31695[(2)] = inst_31544);

(statearr_31555_31695[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31677,c__12301__auto___31689,G__31508_31678,n__7324__auto___31676,jobs,results,process,async))
;
return ((function (__31677,switch__12189__auto__,c__12301__auto___31689,G__31508_31678,n__7324__auto___31676,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_31559 = [null,null,null,null,null,null,null];
(statearr_31559[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_31559[(1)] = (1));

return statearr_31559;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_31548){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31548);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31560){if((e31560 instanceof Object)){
var ex__12193__auto__ = e31560;
var statearr_31561_31696 = state_31548;
(statearr_31561_31696[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31548);

return cljs.core.cst$kw$recur;
} else {
throw e31560;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31697 = state_31548;
state_31548 = G__31697;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_31548){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_31548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(__31677,switch__12189__auto__,c__12301__auto___31689,G__31508_31678,n__7324__auto___31676,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_31562 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31562[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___31689);

return statearr_31562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(__31677,c__12301__auto___31689,G__31508_31678,n__7324__auto___31676,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31698 = (__31677 + (1));
__31677 = G__31698;
continue;
} else {
}
break;
}

var c__12301__auto___31699 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___31699,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___31699,jobs,results,process,async){
return (function (state_31584){
var state_val_31585 = (state_31584[(1)]);
if((state_val_31585 === (1))){
var state_31584__$1 = state_31584;
var statearr_31586_31700 = state_31584__$1;
(statearr_31586_31700[(2)] = null);

(statearr_31586_31700[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31585 === (2))){
var state_31584__$1 = state_31584;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31584__$1,(4),from);
} else {
if((state_val_31585 === (3))){
var inst_31582 = (state_31584[(2)]);
var state_31584__$1 = state_31584;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31584__$1,inst_31582);
} else {
if((state_val_31585 === (4))){
var inst_31565 = (state_31584[(7)]);
var inst_31565__$1 = (state_31584[(2)]);
var inst_31566 = (inst_31565__$1 == null);
var state_31584__$1 = (function (){var statearr_31587 = state_31584;
(statearr_31587[(7)] = inst_31565__$1);

return statearr_31587;
})();
if(cljs.core.truth_(inst_31566)){
var statearr_31588_31701 = state_31584__$1;
(statearr_31588_31701[(1)] = (5));

} else {
var statearr_31589_31702 = state_31584__$1;
(statearr_31589_31702[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31585 === (5))){
var inst_31568 = cljs.core.async.close_BANG_(jobs);
var state_31584__$1 = state_31584;
var statearr_31590_31703 = state_31584__$1;
(statearr_31590_31703[(2)] = inst_31568);

(statearr_31590_31703[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31585 === (6))){
var inst_31570 = (state_31584[(8)]);
var inst_31565 = (state_31584[(7)]);
var inst_31570__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31572 = [inst_31565,inst_31570__$1];
var inst_31573 = (new cljs.core.PersistentVector(null,2,(5),inst_31571,inst_31572,null));
var state_31584__$1 = (function (){var statearr_31591 = state_31584;
(statearr_31591[(8)] = inst_31570__$1);

return statearr_31591;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31584__$1,(8),jobs,inst_31573);
} else {
if((state_val_31585 === (7))){
var inst_31580 = (state_31584[(2)]);
var state_31584__$1 = state_31584;
var statearr_31592_31704 = state_31584__$1;
(statearr_31592_31704[(2)] = inst_31580);

(statearr_31592_31704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31585 === (8))){
var inst_31570 = (state_31584[(8)]);
var inst_31575 = (state_31584[(2)]);
var state_31584__$1 = (function (){var statearr_31593 = state_31584;
(statearr_31593[(9)] = inst_31575);

return statearr_31593;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31584__$1,(9),results,inst_31570);
} else {
if((state_val_31585 === (9))){
var inst_31577 = (state_31584[(2)]);
var state_31584__$1 = (function (){var statearr_31594 = state_31584;
(statearr_31594[(10)] = inst_31577);

return statearr_31594;
})();
var statearr_31595_31705 = state_31584__$1;
(statearr_31595_31705[(2)] = null);

(statearr_31595_31705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___31699,jobs,results,process,async))
;
return ((function (switch__12189__auto__,c__12301__auto___31699,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_31599 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31599[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_31599[(1)] = (1));

return statearr_31599;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_31584){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31584);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31600){if((e31600 instanceof Object)){
var ex__12193__auto__ = e31600;
var statearr_31601_31706 = state_31584;
(statearr_31601_31706[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31584);

return cljs.core.cst$kw$recur;
} else {
throw e31600;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31707 = state_31584;
state_31584 = G__31707;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_31584){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_31584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___31699,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_31602 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31602[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___31699);

return statearr_31602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___31699,jobs,results,process,async))
);


var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__,jobs,results,process,async){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,jobs,results,process,async){
return (function (state_31640){
var state_val_31641 = (state_31640[(1)]);
if((state_val_31641 === (7))){
var inst_31636 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
var statearr_31642_31708 = state_31640__$1;
(statearr_31642_31708[(2)] = inst_31636);

(statearr_31642_31708[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (20))){
var state_31640__$1 = state_31640;
var statearr_31643_31709 = state_31640__$1;
(statearr_31643_31709[(2)] = null);

(statearr_31643_31709[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (1))){
var state_31640__$1 = state_31640;
var statearr_31644_31710 = state_31640__$1;
(statearr_31644_31710[(2)] = null);

(statearr_31644_31710[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (4))){
var inst_31605 = (state_31640[(7)]);
var inst_31605__$1 = (state_31640[(2)]);
var inst_31606 = (inst_31605__$1 == null);
var state_31640__$1 = (function (){var statearr_31645 = state_31640;
(statearr_31645[(7)] = inst_31605__$1);

return statearr_31645;
})();
if(cljs.core.truth_(inst_31606)){
var statearr_31646_31711 = state_31640__$1;
(statearr_31646_31711[(1)] = (5));

} else {
var statearr_31647_31712 = state_31640__$1;
(statearr_31647_31712[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (15))){
var inst_31618 = (state_31640[(8)]);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31640__$1,(18),to,inst_31618);
} else {
if((state_val_31641 === (21))){
var inst_31631 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
var statearr_31648_31713 = state_31640__$1;
(statearr_31648_31713[(2)] = inst_31631);

(statearr_31648_31713[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (13))){
var inst_31633 = (state_31640[(2)]);
var state_31640__$1 = (function (){var statearr_31649 = state_31640;
(statearr_31649[(9)] = inst_31633);

return statearr_31649;
})();
var statearr_31650_31714 = state_31640__$1;
(statearr_31650_31714[(2)] = null);

(statearr_31650_31714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (6))){
var inst_31605 = (state_31640[(7)]);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31640__$1,(11),inst_31605);
} else {
if((state_val_31641 === (17))){
var inst_31626 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
if(cljs.core.truth_(inst_31626)){
var statearr_31651_31715 = state_31640__$1;
(statearr_31651_31715[(1)] = (19));

} else {
var statearr_31652_31716 = state_31640__$1;
(statearr_31652_31716[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (3))){
var inst_31638 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31640__$1,inst_31638);
} else {
if((state_val_31641 === (12))){
var inst_31615 = (state_31640[(10)]);
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31640__$1,(14),inst_31615);
} else {
if((state_val_31641 === (2))){
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31640__$1,(4),results);
} else {
if((state_val_31641 === (19))){
var state_31640__$1 = state_31640;
var statearr_31653_31717 = state_31640__$1;
(statearr_31653_31717[(2)] = null);

(statearr_31653_31717[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (11))){
var inst_31615 = (state_31640[(2)]);
var state_31640__$1 = (function (){var statearr_31654 = state_31640;
(statearr_31654[(10)] = inst_31615);

return statearr_31654;
})();
var statearr_31655_31718 = state_31640__$1;
(statearr_31655_31718[(2)] = null);

(statearr_31655_31718[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (9))){
var state_31640__$1 = state_31640;
var statearr_31656_31719 = state_31640__$1;
(statearr_31656_31719[(2)] = null);

(statearr_31656_31719[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (5))){
var state_31640__$1 = state_31640;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31657_31720 = state_31640__$1;
(statearr_31657_31720[(1)] = (8));

} else {
var statearr_31658_31721 = state_31640__$1;
(statearr_31658_31721[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (14))){
var inst_31618 = (state_31640[(8)]);
var inst_31620 = (state_31640[(11)]);
var inst_31618__$1 = (state_31640[(2)]);
var inst_31619 = (inst_31618__$1 == null);
var inst_31620__$1 = cljs.core.not(inst_31619);
var state_31640__$1 = (function (){var statearr_31659 = state_31640;
(statearr_31659[(8)] = inst_31618__$1);

(statearr_31659[(11)] = inst_31620__$1);

return statearr_31659;
})();
if(inst_31620__$1){
var statearr_31660_31722 = state_31640__$1;
(statearr_31660_31722[(1)] = (15));

} else {
var statearr_31661_31723 = state_31640__$1;
(statearr_31661_31723[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (16))){
var inst_31620 = (state_31640[(11)]);
var state_31640__$1 = state_31640;
var statearr_31662_31724 = state_31640__$1;
(statearr_31662_31724[(2)] = inst_31620);

(statearr_31662_31724[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (10))){
var inst_31612 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
var statearr_31663_31725 = state_31640__$1;
(statearr_31663_31725[(2)] = inst_31612);

(statearr_31663_31725[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (18))){
var inst_31623 = (state_31640[(2)]);
var state_31640__$1 = state_31640;
var statearr_31664_31726 = state_31640__$1;
(statearr_31664_31726[(2)] = inst_31623);

(statearr_31664_31726[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31641 === (8))){
var inst_31609 = cljs.core.async.close_BANG_(to);
var state_31640__$1 = state_31640;
var statearr_31665_31727 = state_31640__$1;
(statearr_31665_31727[(2)] = inst_31609);

(statearr_31665_31727[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__,jobs,results,process,async))
;
return ((function (switch__12189__auto__,c__12301__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_31669 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31669[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__);

(statearr_31669[(1)] = (1));

return statearr_31669;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1 = (function (state_31640){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31640);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31670){if((e31670 instanceof Object)){
var ex__12193__auto__ = e31670;
var statearr_31671_31728 = state_31640;
(statearr_31671_31728[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31640);

return cljs.core.cst$kw$recur;
} else {
throw e31670;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31729 = state_31640;
state_31640 = G__31729;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__ = function(state_31640){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1.call(this,state_31640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,jobs,results,process,async))
})();
var state__12303__auto__ = (function (){var statearr_31672 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31672[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_31672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__,jobs,results,process,async))
);

return c__12301__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31730 = [];
var len__7484__auto___31733 = arguments.length;
var i__7485__auto___31734 = (0);
while(true){
if((i__7485__auto___31734 < len__7484__auto___31733)){
args31730.push((arguments[i__7485__auto___31734]));

var G__31735 = (i__7485__auto___31734 + (1));
i__7485__auto___31734 = G__31735;
continue;
} else {
}
break;
}

var G__31732 = args31730.length;
switch (G__31732) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31730.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31737 = [];
var len__7484__auto___31740 = arguments.length;
var i__7485__auto___31741 = (0);
while(true){
if((i__7485__auto___31741 < len__7484__auto___31740)){
args31737.push((arguments[i__7485__auto___31741]));

var G__31742 = (i__7485__auto___31741 + (1));
i__7485__auto___31741 = G__31742;
continue;
} else {
}
break;
}

var G__31739 = args31737.length;
switch (G__31739) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31737.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31744 = [];
var len__7484__auto___31797 = arguments.length;
var i__7485__auto___31798 = (0);
while(true){
if((i__7485__auto___31798 < len__7484__auto___31797)){
args31744.push((arguments[i__7485__auto___31798]));

var G__31799 = (i__7485__auto___31798 + (1));
i__7485__auto___31798 = G__31799;
continue;
} else {
}
break;
}

var G__31746 = args31744.length;
switch (G__31746) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31744.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12301__auto___31801 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___31801,tc,fc){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___31801,tc,fc){
return (function (state_31772){
var state_val_31773 = (state_31772[(1)]);
if((state_val_31773 === (7))){
var inst_31768 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31774_31802 = state_31772__$1;
(statearr_31774_31802[(2)] = inst_31768);

(statearr_31774_31802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (1))){
var state_31772__$1 = state_31772;
var statearr_31775_31803 = state_31772__$1;
(statearr_31775_31803[(2)] = null);

(statearr_31775_31803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (4))){
var inst_31749 = (state_31772[(7)]);
var inst_31749__$1 = (state_31772[(2)]);
var inst_31750 = (inst_31749__$1 == null);
var state_31772__$1 = (function (){var statearr_31776 = state_31772;
(statearr_31776[(7)] = inst_31749__$1);

return statearr_31776;
})();
if(cljs.core.truth_(inst_31750)){
var statearr_31777_31804 = state_31772__$1;
(statearr_31777_31804[(1)] = (5));

} else {
var statearr_31778_31805 = state_31772__$1;
(statearr_31778_31805[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (13))){
var state_31772__$1 = state_31772;
var statearr_31779_31806 = state_31772__$1;
(statearr_31779_31806[(2)] = null);

(statearr_31779_31806[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (6))){
var inst_31749 = (state_31772[(7)]);
var inst_31755 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31749) : p.call(null,inst_31749));
var state_31772__$1 = state_31772;
if(cljs.core.truth_(inst_31755)){
var statearr_31780_31807 = state_31772__$1;
(statearr_31780_31807[(1)] = (9));

} else {
var statearr_31781_31808 = state_31772__$1;
(statearr_31781_31808[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (3))){
var inst_31770 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31772__$1,inst_31770);
} else {
if((state_val_31773 === (12))){
var state_31772__$1 = state_31772;
var statearr_31782_31809 = state_31772__$1;
(statearr_31782_31809[(2)] = null);

(statearr_31782_31809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (2))){
var state_31772__$1 = state_31772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31772__$1,(4),ch);
} else {
if((state_val_31773 === (11))){
var inst_31749 = (state_31772[(7)]);
var inst_31759 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31772__$1,(8),inst_31759,inst_31749);
} else {
if((state_val_31773 === (9))){
var state_31772__$1 = state_31772;
var statearr_31783_31810 = state_31772__$1;
(statearr_31783_31810[(2)] = tc);

(statearr_31783_31810[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (5))){
var inst_31752 = cljs.core.async.close_BANG_(tc);
var inst_31753 = cljs.core.async.close_BANG_(fc);
var state_31772__$1 = (function (){var statearr_31784 = state_31772;
(statearr_31784[(8)] = inst_31752);

return statearr_31784;
})();
var statearr_31785_31811 = state_31772__$1;
(statearr_31785_31811[(2)] = inst_31753);

(statearr_31785_31811[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (14))){
var inst_31766 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
var statearr_31786_31812 = state_31772__$1;
(statearr_31786_31812[(2)] = inst_31766);

(statearr_31786_31812[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (10))){
var state_31772__$1 = state_31772;
var statearr_31787_31813 = state_31772__$1;
(statearr_31787_31813[(2)] = fc);

(statearr_31787_31813[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31773 === (8))){
var inst_31761 = (state_31772[(2)]);
var state_31772__$1 = state_31772;
if(cljs.core.truth_(inst_31761)){
var statearr_31788_31814 = state_31772__$1;
(statearr_31788_31814[(1)] = (12));

} else {
var statearr_31789_31815 = state_31772__$1;
(statearr_31789_31815[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___31801,tc,fc))
;
return ((function (switch__12189__auto__,c__12301__auto___31801,tc,fc){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_31793 = [null,null,null,null,null,null,null,null,null];
(statearr_31793[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_31793[(1)] = (1));

return statearr_31793;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_31772){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31772);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31794){if((e31794 instanceof Object)){
var ex__12193__auto__ = e31794;
var statearr_31795_31816 = state_31772;
(statearr_31795_31816[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31772);

return cljs.core.cst$kw$recur;
} else {
throw e31794;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31817 = state_31772;
state_31772 = G__31817;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_31772){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_31772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___31801,tc,fc))
})();
var state__12303__auto__ = (function (){var statearr_31796 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___31801);

return statearr_31796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___31801,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_31881){
var state_val_31882 = (state_31881[(1)]);
if((state_val_31882 === (7))){
var inst_31877 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
var statearr_31883_31904 = state_31881__$1;
(statearr_31883_31904[(2)] = inst_31877);

(statearr_31883_31904[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (1))){
var inst_31861 = init;
var state_31881__$1 = (function (){var statearr_31884 = state_31881;
(statearr_31884[(7)] = inst_31861);

return statearr_31884;
})();
var statearr_31885_31905 = state_31881__$1;
(statearr_31885_31905[(2)] = null);

(statearr_31885_31905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (4))){
var inst_31864 = (state_31881[(8)]);
var inst_31864__$1 = (state_31881[(2)]);
var inst_31865 = (inst_31864__$1 == null);
var state_31881__$1 = (function (){var statearr_31886 = state_31881;
(statearr_31886[(8)] = inst_31864__$1);

return statearr_31886;
})();
if(cljs.core.truth_(inst_31865)){
var statearr_31887_31906 = state_31881__$1;
(statearr_31887_31906[(1)] = (5));

} else {
var statearr_31888_31907 = state_31881__$1;
(statearr_31888_31907[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (6))){
var inst_31864 = (state_31881[(8)]);
var inst_31861 = (state_31881[(7)]);
var inst_31868 = (state_31881[(9)]);
var inst_31868__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31861,inst_31864) : f.call(null,inst_31861,inst_31864));
var inst_31869 = cljs.core.reduced_QMARK_(inst_31868__$1);
var state_31881__$1 = (function (){var statearr_31889 = state_31881;
(statearr_31889[(9)] = inst_31868__$1);

return statearr_31889;
})();
if(inst_31869){
var statearr_31890_31908 = state_31881__$1;
(statearr_31890_31908[(1)] = (8));

} else {
var statearr_31891_31909 = state_31881__$1;
(statearr_31891_31909[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (3))){
var inst_31879 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31881__$1,inst_31879);
} else {
if((state_val_31882 === (2))){
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31881__$1,(4),ch);
} else {
if((state_val_31882 === (9))){
var inst_31868 = (state_31881[(9)]);
var inst_31861 = inst_31868;
var state_31881__$1 = (function (){var statearr_31892 = state_31881;
(statearr_31892[(7)] = inst_31861);

return statearr_31892;
})();
var statearr_31893_31910 = state_31881__$1;
(statearr_31893_31910[(2)] = null);

(statearr_31893_31910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (5))){
var inst_31861 = (state_31881[(7)]);
var state_31881__$1 = state_31881;
var statearr_31894_31911 = state_31881__$1;
(statearr_31894_31911[(2)] = inst_31861);

(statearr_31894_31911[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (10))){
var inst_31875 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
var statearr_31895_31912 = state_31881__$1;
(statearr_31895_31912[(2)] = inst_31875);

(statearr_31895_31912[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31882 === (8))){
var inst_31868 = (state_31881[(9)]);
var inst_31871 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_31868) : cljs.core.deref.call(null,inst_31868));
var state_31881__$1 = state_31881;
var statearr_31896_31913 = state_31881__$1;
(statearr_31896_31913[(2)] = inst_31871);

(statearr_31896_31913[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12190__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12190__auto____0 = (function (){
var statearr_31900 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31900[(0)] = cljs$core$async$reduce_$_state_machine__12190__auto__);

(statearr_31900[(1)] = (1));

return statearr_31900;
});
var cljs$core$async$reduce_$_state_machine__12190__auto____1 = (function (state_31881){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31881);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31901){if((e31901 instanceof Object)){
var ex__12193__auto__ = e31901;
var statearr_31902_31914 = state_31881;
(statearr_31902_31914[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31881);

return cljs.core.cst$kw$recur;
} else {
throw e31901;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31915 = state_31881;
state_31881 = G__31915;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12190__auto__ = function(state_31881){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12190__auto____1.call(this,state_31881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12190__auto____0;
cljs$core$async$reduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12190__auto____1;
return cljs$core$async$reduce_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_31903 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31903[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_31903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__,f__$1){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__,f__$1){
return (function (state_31935){
var state_val_31936 = (state_31935[(1)]);
if((state_val_31936 === (1))){
var inst_31930 = cljs.core.async.reduce(f__$1,init,ch);
var state_31935__$1 = state_31935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31935__$1,(2),inst_31930);
} else {
if((state_val_31936 === (2))){
var inst_31932 = (state_31935[(2)]);
var inst_31933 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31932) : f__$1.call(null,inst_31932));
var state_31935__$1 = state_31935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31935__$1,inst_31933);
} else {
return null;
}
}
});})(c__12301__auto__,f__$1))
;
return ((function (switch__12189__auto__,c__12301__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12190__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12190__auto____0 = (function (){
var statearr_31940 = [null,null,null,null,null,null,null];
(statearr_31940[(0)] = cljs$core$async$transduce_$_state_machine__12190__auto__);

(statearr_31940[(1)] = (1));

return statearr_31940;
});
var cljs$core$async$transduce_$_state_machine__12190__auto____1 = (function (state_31935){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31935);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31941){if((e31941 instanceof Object)){
var ex__12193__auto__ = e31941;
var statearr_31942_31944 = state_31935;
(statearr_31942_31944[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31935);

return cljs.core.cst$kw$recur;
} else {
throw e31941;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__31945 = state_31935;
state_31935 = G__31945;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12190__auto__ = function(state_31935){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12190__auto____1.call(this,state_31935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12190__auto____0;
cljs$core$async$transduce_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12190__auto____1;
return cljs$core$async$transduce_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__,f__$1))
})();
var state__12303__auto__ = (function (){var statearr_31943 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31943[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_31943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__,f__$1))
);

return c__12301__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args31946 = [];
var len__7484__auto___31998 = arguments.length;
var i__7485__auto___31999 = (0);
while(true){
if((i__7485__auto___31999 < len__7484__auto___31998)){
args31946.push((arguments[i__7485__auto___31999]));

var G__32000 = (i__7485__auto___31999 + (1));
i__7485__auto___31999 = G__32000;
continue;
} else {
}
break;
}

var G__31948 = args31946.length;
switch (G__31948) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31946.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_31973){
var state_val_31974 = (state_31973[(1)]);
if((state_val_31974 === (7))){
var inst_31955 = (state_31973[(2)]);
var state_31973__$1 = state_31973;
var statearr_31975_32002 = state_31973__$1;
(statearr_31975_32002[(2)] = inst_31955);

(statearr_31975_32002[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (1))){
var inst_31949 = cljs.core.seq(coll);
var inst_31950 = inst_31949;
var state_31973__$1 = (function (){var statearr_31976 = state_31973;
(statearr_31976[(7)] = inst_31950);

return statearr_31976;
})();
var statearr_31977_32003 = state_31973__$1;
(statearr_31977_32003[(2)] = null);

(statearr_31977_32003[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (4))){
var inst_31950 = (state_31973[(7)]);
var inst_31953 = cljs.core.first(inst_31950);
var state_31973__$1 = state_31973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31973__$1,(7),ch,inst_31953);
} else {
if((state_val_31974 === (13))){
var inst_31967 = (state_31973[(2)]);
var state_31973__$1 = state_31973;
var statearr_31978_32004 = state_31973__$1;
(statearr_31978_32004[(2)] = inst_31967);

(statearr_31978_32004[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (6))){
var inst_31958 = (state_31973[(2)]);
var state_31973__$1 = state_31973;
if(cljs.core.truth_(inst_31958)){
var statearr_31979_32005 = state_31973__$1;
(statearr_31979_32005[(1)] = (8));

} else {
var statearr_31980_32006 = state_31973__$1;
(statearr_31980_32006[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (3))){
var inst_31971 = (state_31973[(2)]);
var state_31973__$1 = state_31973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31973__$1,inst_31971);
} else {
if((state_val_31974 === (12))){
var state_31973__$1 = state_31973;
var statearr_31981_32007 = state_31973__$1;
(statearr_31981_32007[(2)] = null);

(statearr_31981_32007[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (2))){
var inst_31950 = (state_31973[(7)]);
var state_31973__$1 = state_31973;
if(cljs.core.truth_(inst_31950)){
var statearr_31982_32008 = state_31973__$1;
(statearr_31982_32008[(1)] = (4));

} else {
var statearr_31983_32009 = state_31973__$1;
(statearr_31983_32009[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (11))){
var inst_31964 = cljs.core.async.close_BANG_(ch);
var state_31973__$1 = state_31973;
var statearr_31984_32010 = state_31973__$1;
(statearr_31984_32010[(2)] = inst_31964);

(statearr_31984_32010[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (9))){
var state_31973__$1 = state_31973;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31985_32011 = state_31973__$1;
(statearr_31985_32011[(1)] = (11));

} else {
var statearr_31986_32012 = state_31973__$1;
(statearr_31986_32012[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (5))){
var inst_31950 = (state_31973[(7)]);
var state_31973__$1 = state_31973;
var statearr_31987_32013 = state_31973__$1;
(statearr_31987_32013[(2)] = inst_31950);

(statearr_31987_32013[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (10))){
var inst_31969 = (state_31973[(2)]);
var state_31973__$1 = state_31973;
var statearr_31988_32014 = state_31973__$1;
(statearr_31988_32014[(2)] = inst_31969);

(statearr_31988_32014[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31974 === (8))){
var inst_31950 = (state_31973[(7)]);
var inst_31960 = cljs.core.next(inst_31950);
var inst_31950__$1 = inst_31960;
var state_31973__$1 = (function (){var statearr_31989 = state_31973;
(statearr_31989[(7)] = inst_31950__$1);

return statearr_31989;
})();
var statearr_31990_32015 = state_31973__$1;
(statearr_31990_32015[(2)] = null);

(statearr_31990_32015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_31994 = [null,null,null,null,null,null,null,null];
(statearr_31994[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_31994[(1)] = (1));

return statearr_31994;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_31973){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_31973);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e31995){if((e31995 instanceof Object)){
var ex__12193__auto__ = e31995;
var statearr_31996_32016 = state_31973;
(statearr_31996_32016[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31973);

return cljs.core.cst$kw$recur;
} else {
throw e31995;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__32017 = state_31973;
state_31973 = G__32017;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_31973){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_31973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_31997 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_31997[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_31997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32246 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32246) : cljs.core.atom.call(null,G__32246));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32247 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32247 = (function (mult,ch,cs,meta32248){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta32248 = meta32248;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32249,meta32248__$1){
var self__ = this;
var _32249__$1 = this;
return (new cljs.core.async.t_cljs$core$async32247(self__.mult,self__.ch,self__.cs,meta32248__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32249){
var self__ = this;
var _32249__$1 = this;
return self__.meta32248;
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32250_32474 = self__.cs;
var G__32251_32475 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32250_32474,G__32251_32475) : cljs.core.reset_BANG_.call(null,G__32250_32474,G__32251_32475));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32248], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32247.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32247.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32247";

cljs.core.async.t_cljs$core$async32247.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32247");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32247 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32247(mult__$1,ch__$1,cs__$1,meta32248){
return (new cljs.core.async.t_cljs$core$async32247(mult__$1,ch__$1,cs__$1,meta32248));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32247(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12301__auto___32476 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___32476,cs,m,dchan,dctr,done){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___32476,cs,m,dchan,dctr,done){
return (function (state_32386){
var state_val_32387 = (state_32386[(1)]);
if((state_val_32387 === (7))){
var inst_32382 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32388_32477 = state_32386__$1;
(statearr_32388_32477[(2)] = inst_32382);

(statearr_32388_32477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (20))){
var inst_32285 = (state_32386[(7)]);
var inst_32297 = cljs.core.first(inst_32285);
var inst_32298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32297,(0),null);
var inst_32299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32297,(1),null);
var state_32386__$1 = (function (){var statearr_32389 = state_32386;
(statearr_32389[(8)] = inst_32298);

return statearr_32389;
})();
if(cljs.core.truth_(inst_32299)){
var statearr_32390_32478 = state_32386__$1;
(statearr_32390_32478[(1)] = (22));

} else {
var statearr_32391_32479 = state_32386__$1;
(statearr_32391_32479[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (27))){
var inst_32327 = (state_32386[(9)]);
var inst_32334 = (state_32386[(10)]);
var inst_32254 = (state_32386[(11)]);
var inst_32329 = (state_32386[(12)]);
var inst_32334__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32327,inst_32329);
var inst_32335 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32334__$1,inst_32254,done);
var state_32386__$1 = (function (){var statearr_32392 = state_32386;
(statearr_32392[(10)] = inst_32334__$1);

return statearr_32392;
})();
if(cljs.core.truth_(inst_32335)){
var statearr_32393_32480 = state_32386__$1;
(statearr_32393_32480[(1)] = (30));

} else {
var statearr_32394_32481 = state_32386__$1;
(statearr_32394_32481[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (1))){
var state_32386__$1 = state_32386;
var statearr_32395_32482 = state_32386__$1;
(statearr_32395_32482[(2)] = null);

(statearr_32395_32482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (24))){
var inst_32285 = (state_32386[(7)]);
var inst_32304 = (state_32386[(2)]);
var inst_32305 = cljs.core.next(inst_32285);
var inst_32263 = inst_32305;
var inst_32264 = null;
var inst_32265 = (0);
var inst_32266 = (0);
var state_32386__$1 = (function (){var statearr_32396 = state_32386;
(statearr_32396[(13)] = inst_32266);

(statearr_32396[(14)] = inst_32265);

(statearr_32396[(15)] = inst_32263);

(statearr_32396[(16)] = inst_32304);

(statearr_32396[(17)] = inst_32264);

return statearr_32396;
})();
var statearr_32397_32483 = state_32386__$1;
(statearr_32397_32483[(2)] = null);

(statearr_32397_32483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (39))){
var state_32386__$1 = state_32386;
var statearr_32401_32484 = state_32386__$1;
(statearr_32401_32484[(2)] = null);

(statearr_32401_32484[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (4))){
var inst_32254 = (state_32386[(11)]);
var inst_32254__$1 = (state_32386[(2)]);
var inst_32255 = (inst_32254__$1 == null);
var state_32386__$1 = (function (){var statearr_32402 = state_32386;
(statearr_32402[(11)] = inst_32254__$1);

return statearr_32402;
})();
if(cljs.core.truth_(inst_32255)){
var statearr_32403_32485 = state_32386__$1;
(statearr_32403_32485[(1)] = (5));

} else {
var statearr_32404_32486 = state_32386__$1;
(statearr_32404_32486[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (15))){
var inst_32266 = (state_32386[(13)]);
var inst_32265 = (state_32386[(14)]);
var inst_32263 = (state_32386[(15)]);
var inst_32264 = (state_32386[(17)]);
var inst_32281 = (state_32386[(2)]);
var inst_32282 = (inst_32266 + (1));
var tmp32398 = inst_32265;
var tmp32399 = inst_32263;
var tmp32400 = inst_32264;
var inst_32263__$1 = tmp32399;
var inst_32264__$1 = tmp32400;
var inst_32265__$1 = tmp32398;
var inst_32266__$1 = inst_32282;
var state_32386__$1 = (function (){var statearr_32405 = state_32386;
(statearr_32405[(18)] = inst_32281);

(statearr_32405[(13)] = inst_32266__$1);

(statearr_32405[(14)] = inst_32265__$1);

(statearr_32405[(15)] = inst_32263__$1);

(statearr_32405[(17)] = inst_32264__$1);

return statearr_32405;
})();
var statearr_32406_32487 = state_32386__$1;
(statearr_32406_32487[(2)] = null);

(statearr_32406_32487[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (21))){
var inst_32308 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32410_32488 = state_32386__$1;
(statearr_32410_32488[(2)] = inst_32308);

(statearr_32410_32488[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (31))){
var inst_32334 = (state_32386[(10)]);
var inst_32338 = done(null);
var inst_32339 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32334);
var state_32386__$1 = (function (){var statearr_32411 = state_32386;
(statearr_32411[(19)] = inst_32338);

return statearr_32411;
})();
var statearr_32412_32489 = state_32386__$1;
(statearr_32412_32489[(2)] = inst_32339);

(statearr_32412_32489[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (32))){
var inst_32327 = (state_32386[(9)]);
var inst_32328 = (state_32386[(20)]);
var inst_32326 = (state_32386[(21)]);
var inst_32329 = (state_32386[(12)]);
var inst_32341 = (state_32386[(2)]);
var inst_32342 = (inst_32329 + (1));
var tmp32407 = inst_32327;
var tmp32408 = inst_32328;
var tmp32409 = inst_32326;
var inst_32326__$1 = tmp32409;
var inst_32327__$1 = tmp32407;
var inst_32328__$1 = tmp32408;
var inst_32329__$1 = inst_32342;
var state_32386__$1 = (function (){var statearr_32413 = state_32386;
(statearr_32413[(9)] = inst_32327__$1);

(statearr_32413[(20)] = inst_32328__$1);

(statearr_32413[(21)] = inst_32326__$1);

(statearr_32413[(22)] = inst_32341);

(statearr_32413[(12)] = inst_32329__$1);

return statearr_32413;
})();
var statearr_32414_32490 = state_32386__$1;
(statearr_32414_32490[(2)] = null);

(statearr_32414_32490[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (40))){
var inst_32354 = (state_32386[(23)]);
var inst_32358 = done(null);
var inst_32359 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32354);
var state_32386__$1 = (function (){var statearr_32415 = state_32386;
(statearr_32415[(24)] = inst_32358);

return statearr_32415;
})();
var statearr_32416_32491 = state_32386__$1;
(statearr_32416_32491[(2)] = inst_32359);

(statearr_32416_32491[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (33))){
var inst_32345 = (state_32386[(25)]);
var inst_32347 = cljs.core.chunked_seq_QMARK_(inst_32345);
var state_32386__$1 = state_32386;
if(inst_32347){
var statearr_32417_32492 = state_32386__$1;
(statearr_32417_32492[(1)] = (36));

} else {
var statearr_32418_32493 = state_32386__$1;
(statearr_32418_32493[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (13))){
var inst_32275 = (state_32386[(26)]);
var inst_32278 = cljs.core.async.close_BANG_(inst_32275);
var state_32386__$1 = state_32386;
var statearr_32419_32494 = state_32386__$1;
(statearr_32419_32494[(2)] = inst_32278);

(statearr_32419_32494[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (22))){
var inst_32298 = (state_32386[(8)]);
var inst_32301 = cljs.core.async.close_BANG_(inst_32298);
var state_32386__$1 = state_32386;
var statearr_32420_32495 = state_32386__$1;
(statearr_32420_32495[(2)] = inst_32301);

(statearr_32420_32495[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (36))){
var inst_32345 = (state_32386[(25)]);
var inst_32349 = cljs.core.chunk_first(inst_32345);
var inst_32350 = cljs.core.chunk_rest(inst_32345);
var inst_32351 = cljs.core.count(inst_32349);
var inst_32326 = inst_32350;
var inst_32327 = inst_32349;
var inst_32328 = inst_32351;
var inst_32329 = (0);
var state_32386__$1 = (function (){var statearr_32421 = state_32386;
(statearr_32421[(9)] = inst_32327);

(statearr_32421[(20)] = inst_32328);

(statearr_32421[(21)] = inst_32326);

(statearr_32421[(12)] = inst_32329);

return statearr_32421;
})();
var statearr_32422_32496 = state_32386__$1;
(statearr_32422_32496[(2)] = null);

(statearr_32422_32496[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (41))){
var inst_32345 = (state_32386[(25)]);
var inst_32361 = (state_32386[(2)]);
var inst_32362 = cljs.core.next(inst_32345);
var inst_32326 = inst_32362;
var inst_32327 = null;
var inst_32328 = (0);
var inst_32329 = (0);
var state_32386__$1 = (function (){var statearr_32423 = state_32386;
(statearr_32423[(9)] = inst_32327);

(statearr_32423[(20)] = inst_32328);

(statearr_32423[(21)] = inst_32326);

(statearr_32423[(27)] = inst_32361);

(statearr_32423[(12)] = inst_32329);

return statearr_32423;
})();
var statearr_32424_32497 = state_32386__$1;
(statearr_32424_32497[(2)] = null);

(statearr_32424_32497[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (43))){
var state_32386__$1 = state_32386;
var statearr_32425_32498 = state_32386__$1;
(statearr_32425_32498[(2)] = null);

(statearr_32425_32498[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (29))){
var inst_32370 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32426_32499 = state_32386__$1;
(statearr_32426_32499[(2)] = inst_32370);

(statearr_32426_32499[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (44))){
var inst_32379 = (state_32386[(2)]);
var state_32386__$1 = (function (){var statearr_32427 = state_32386;
(statearr_32427[(28)] = inst_32379);

return statearr_32427;
})();
var statearr_32428_32500 = state_32386__$1;
(statearr_32428_32500[(2)] = null);

(statearr_32428_32500[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (6))){
var inst_32318 = (state_32386[(29)]);
var inst_32317 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32318__$1 = cljs.core.keys(inst_32317);
var inst_32319 = cljs.core.count(inst_32318__$1);
var inst_32320 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32319) : cljs.core.reset_BANG_.call(null,dctr,inst_32319));
var inst_32325 = cljs.core.seq(inst_32318__$1);
var inst_32326 = inst_32325;
var inst_32327 = null;
var inst_32328 = (0);
var inst_32329 = (0);
var state_32386__$1 = (function (){var statearr_32429 = state_32386;
(statearr_32429[(30)] = inst_32320);

(statearr_32429[(9)] = inst_32327);

(statearr_32429[(20)] = inst_32328);

(statearr_32429[(21)] = inst_32326);

(statearr_32429[(29)] = inst_32318__$1);

(statearr_32429[(12)] = inst_32329);

return statearr_32429;
})();
var statearr_32430_32501 = state_32386__$1;
(statearr_32430_32501[(2)] = null);

(statearr_32430_32501[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (28))){
var inst_32345 = (state_32386[(25)]);
var inst_32326 = (state_32386[(21)]);
var inst_32345__$1 = cljs.core.seq(inst_32326);
var state_32386__$1 = (function (){var statearr_32431 = state_32386;
(statearr_32431[(25)] = inst_32345__$1);

return statearr_32431;
})();
if(inst_32345__$1){
var statearr_32432_32502 = state_32386__$1;
(statearr_32432_32502[(1)] = (33));

} else {
var statearr_32433_32503 = state_32386__$1;
(statearr_32433_32503[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (25))){
var inst_32328 = (state_32386[(20)]);
var inst_32329 = (state_32386[(12)]);
var inst_32331 = (inst_32329 < inst_32328);
var inst_32332 = inst_32331;
var state_32386__$1 = state_32386;
if(cljs.core.truth_(inst_32332)){
var statearr_32434_32504 = state_32386__$1;
(statearr_32434_32504[(1)] = (27));

} else {
var statearr_32435_32505 = state_32386__$1;
(statearr_32435_32505[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (34))){
var state_32386__$1 = state_32386;
var statearr_32436_32506 = state_32386__$1;
(statearr_32436_32506[(2)] = null);

(statearr_32436_32506[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (17))){
var state_32386__$1 = state_32386;
var statearr_32437_32507 = state_32386__$1;
(statearr_32437_32507[(2)] = null);

(statearr_32437_32507[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (3))){
var inst_32384 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32386__$1,inst_32384);
} else {
if((state_val_32387 === (12))){
var inst_32313 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32438_32508 = state_32386__$1;
(statearr_32438_32508[(2)] = inst_32313);

(statearr_32438_32508[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (2))){
var state_32386__$1 = state_32386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32386__$1,(4),ch);
} else {
if((state_val_32387 === (23))){
var state_32386__$1 = state_32386;
var statearr_32439_32509 = state_32386__$1;
(statearr_32439_32509[(2)] = null);

(statearr_32439_32509[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (35))){
var inst_32368 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32440_32510 = state_32386__$1;
(statearr_32440_32510[(2)] = inst_32368);

(statearr_32440_32510[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (19))){
var inst_32285 = (state_32386[(7)]);
var inst_32289 = cljs.core.chunk_first(inst_32285);
var inst_32290 = cljs.core.chunk_rest(inst_32285);
var inst_32291 = cljs.core.count(inst_32289);
var inst_32263 = inst_32290;
var inst_32264 = inst_32289;
var inst_32265 = inst_32291;
var inst_32266 = (0);
var state_32386__$1 = (function (){var statearr_32441 = state_32386;
(statearr_32441[(13)] = inst_32266);

(statearr_32441[(14)] = inst_32265);

(statearr_32441[(15)] = inst_32263);

(statearr_32441[(17)] = inst_32264);

return statearr_32441;
})();
var statearr_32442_32511 = state_32386__$1;
(statearr_32442_32511[(2)] = null);

(statearr_32442_32511[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (11))){
var inst_32263 = (state_32386[(15)]);
var inst_32285 = (state_32386[(7)]);
var inst_32285__$1 = cljs.core.seq(inst_32263);
var state_32386__$1 = (function (){var statearr_32443 = state_32386;
(statearr_32443[(7)] = inst_32285__$1);

return statearr_32443;
})();
if(inst_32285__$1){
var statearr_32444_32512 = state_32386__$1;
(statearr_32444_32512[(1)] = (16));

} else {
var statearr_32445_32513 = state_32386__$1;
(statearr_32445_32513[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (9))){
var inst_32315 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32446_32514 = state_32386__$1;
(statearr_32446_32514[(2)] = inst_32315);

(statearr_32446_32514[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (5))){
var inst_32261 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32262 = cljs.core.seq(inst_32261);
var inst_32263 = inst_32262;
var inst_32264 = null;
var inst_32265 = (0);
var inst_32266 = (0);
var state_32386__$1 = (function (){var statearr_32447 = state_32386;
(statearr_32447[(13)] = inst_32266);

(statearr_32447[(14)] = inst_32265);

(statearr_32447[(15)] = inst_32263);

(statearr_32447[(17)] = inst_32264);

return statearr_32447;
})();
var statearr_32448_32515 = state_32386__$1;
(statearr_32448_32515[(2)] = null);

(statearr_32448_32515[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (14))){
var state_32386__$1 = state_32386;
var statearr_32449_32516 = state_32386__$1;
(statearr_32449_32516[(2)] = null);

(statearr_32449_32516[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (45))){
var inst_32376 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32450_32517 = state_32386__$1;
(statearr_32450_32517[(2)] = inst_32376);

(statearr_32450_32517[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (26))){
var inst_32318 = (state_32386[(29)]);
var inst_32372 = (state_32386[(2)]);
var inst_32373 = cljs.core.seq(inst_32318);
var state_32386__$1 = (function (){var statearr_32451 = state_32386;
(statearr_32451[(31)] = inst_32372);

return statearr_32451;
})();
if(inst_32373){
var statearr_32452_32518 = state_32386__$1;
(statearr_32452_32518[(1)] = (42));

} else {
var statearr_32453_32519 = state_32386__$1;
(statearr_32453_32519[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (16))){
var inst_32285 = (state_32386[(7)]);
var inst_32287 = cljs.core.chunked_seq_QMARK_(inst_32285);
var state_32386__$1 = state_32386;
if(inst_32287){
var statearr_32454_32520 = state_32386__$1;
(statearr_32454_32520[(1)] = (19));

} else {
var statearr_32455_32521 = state_32386__$1;
(statearr_32455_32521[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (38))){
var inst_32365 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32456_32522 = state_32386__$1;
(statearr_32456_32522[(2)] = inst_32365);

(statearr_32456_32522[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (30))){
var state_32386__$1 = state_32386;
var statearr_32457_32523 = state_32386__$1;
(statearr_32457_32523[(2)] = null);

(statearr_32457_32523[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (10))){
var inst_32266 = (state_32386[(13)]);
var inst_32264 = (state_32386[(17)]);
var inst_32274 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32264,inst_32266);
var inst_32275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32274,(0),null);
var inst_32276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32274,(1),null);
var state_32386__$1 = (function (){var statearr_32458 = state_32386;
(statearr_32458[(26)] = inst_32275);

return statearr_32458;
})();
if(cljs.core.truth_(inst_32276)){
var statearr_32459_32524 = state_32386__$1;
(statearr_32459_32524[(1)] = (13));

} else {
var statearr_32460_32525 = state_32386__$1;
(statearr_32460_32525[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (18))){
var inst_32311 = (state_32386[(2)]);
var state_32386__$1 = state_32386;
var statearr_32461_32526 = state_32386__$1;
(statearr_32461_32526[(2)] = inst_32311);

(statearr_32461_32526[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (42))){
var state_32386__$1 = state_32386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32386__$1,(45),dchan);
} else {
if((state_val_32387 === (37))){
var inst_32345 = (state_32386[(25)]);
var inst_32354 = (state_32386[(23)]);
var inst_32254 = (state_32386[(11)]);
var inst_32354__$1 = cljs.core.first(inst_32345);
var inst_32355 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32354__$1,inst_32254,done);
var state_32386__$1 = (function (){var statearr_32462 = state_32386;
(statearr_32462[(23)] = inst_32354__$1);

return statearr_32462;
})();
if(cljs.core.truth_(inst_32355)){
var statearr_32463_32527 = state_32386__$1;
(statearr_32463_32527[(1)] = (39));

} else {
var statearr_32464_32528 = state_32386__$1;
(statearr_32464_32528[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32387 === (8))){
var inst_32266 = (state_32386[(13)]);
var inst_32265 = (state_32386[(14)]);
var inst_32268 = (inst_32266 < inst_32265);
var inst_32269 = inst_32268;
var state_32386__$1 = state_32386;
if(cljs.core.truth_(inst_32269)){
var statearr_32465_32529 = state_32386__$1;
(statearr_32465_32529[(1)] = (10));

} else {
var statearr_32466_32530 = state_32386__$1;
(statearr_32466_32530[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___32476,cs,m,dchan,dctr,done))
;
return ((function (switch__12189__auto__,c__12301__auto___32476,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12190__auto__ = null;
var cljs$core$async$mult_$_state_machine__12190__auto____0 = (function (){
var statearr_32470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32470[(0)] = cljs$core$async$mult_$_state_machine__12190__auto__);

(statearr_32470[(1)] = (1));

return statearr_32470;
});
var cljs$core$async$mult_$_state_machine__12190__auto____1 = (function (state_32386){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_32386);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e32471){if((e32471 instanceof Object)){
var ex__12193__auto__ = e32471;
var statearr_32472_32531 = state_32386;
(statearr_32472_32531[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32386);

return cljs.core.cst$kw$recur;
} else {
throw e32471;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__32532 = state_32386;
state_32386 = G__32532;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12190__auto__ = function(state_32386){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12190__auto____1.call(this,state_32386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12190__auto____0;
cljs$core$async$mult_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12190__auto____1;
return cljs$core$async$mult_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___32476,cs,m,dchan,dctr,done))
})();
var state__12303__auto__ = (function (){var statearr_32473 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_32473[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___32476);

return statearr_32473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___32476,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args32533 = [];
var len__7484__auto___32536 = arguments.length;
var i__7485__auto___32537 = (0);
while(true){
if((i__7485__auto___32537 < len__7484__auto___32536)){
args32533.push((arguments[i__7485__auto___32537]));

var G__32538 = (i__7485__auto___32537 + (1));
i__7485__auto___32537 = G__32538;
continue;
} else {
}
break;
}

var G__32535 = args32533.length;
switch (G__32535) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32533.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32550 = arguments.length;
var i__7485__auto___32551 = (0);
while(true){
if((i__7485__auto___32551 < len__7484__auto___32550)){
args__7491__auto__.push((arguments[i__7485__auto___32551]));

var G__32552 = (i__7485__auto___32551 + (1));
i__7485__auto___32551 = G__32552;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32544){
var map__32545 = p__32544;
var map__32545__$1 = ((((!((map__32545 == null)))?((((map__32545.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32545.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32545):map__32545);
var opts = map__32545__$1;
var statearr_32547_32553 = state;
(statearr_32547_32553[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__32545,map__32545__$1,opts){
return (function (val){
var statearr_32548_32554 = state;
(statearr_32548_32554[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32545,map__32545__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32549_32555 = state;
(statearr_32549_32555[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32540){
var G__32541 = cljs.core.first(seq32540);
var seq32540__$1 = cljs.core.next(seq32540);
var G__32542 = cljs.core.first(seq32540__$1);
var seq32540__$2 = cljs.core.next(seq32540__$1);
var G__32543 = cljs.core.first(seq32540__$2);
var seq32540__$3 = cljs.core.next(seq32540__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32541,G__32542,G__32543,seq32540__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32725 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32725) : cljs.core.atom.call(null,G__32725));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__32726 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32726) : cljs.core.atom.call(null,G__32726));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32727 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32727 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32728){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32728 = meta32728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32729,meta32728__$1){
var self__ = this;
var _32729__$1 = this;
return (new cljs.core.async.t_cljs$core$async32727(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32728__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32729){
var self__ = this;
var _32729__$1 = this;
return self__.meta32728;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32730_32894 = self__.cs;
var G__32731_32895 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32730_32894,G__32731_32895) : cljs.core.reset_BANG_.call(null,G__32730_32894,G__32731_32895));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta32728], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32727.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32727.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32727";

cljs.core.async.t_cljs$core$async32727.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32727");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32727 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32727(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32728){
return (new cljs.core.async.t_cljs$core$async32727(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32728));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32727(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12301__auto___32896 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___32896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___32896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32831){
var state_val_32832 = (state_32831[(1)]);
if((state_val_32832 === (7))){
var inst_32747 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
var statearr_32833_32897 = state_32831__$1;
(statearr_32833_32897[(2)] = inst_32747);

(statearr_32833_32897[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (20))){
var inst_32759 = (state_32831[(7)]);
var state_32831__$1 = state_32831;
var statearr_32834_32898 = state_32831__$1;
(statearr_32834_32898[(2)] = inst_32759);

(statearr_32834_32898[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (27))){
var state_32831__$1 = state_32831;
var statearr_32835_32899 = state_32831__$1;
(statearr_32835_32899[(2)] = null);

(statearr_32835_32899[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (1))){
var inst_32735 = (state_32831[(8)]);
var inst_32735__$1 = calc_state();
var inst_32737 = (inst_32735__$1 == null);
var inst_32738 = cljs.core.not(inst_32737);
var state_32831__$1 = (function (){var statearr_32836 = state_32831;
(statearr_32836[(8)] = inst_32735__$1);

return statearr_32836;
})();
if(inst_32738){
var statearr_32837_32900 = state_32831__$1;
(statearr_32837_32900[(1)] = (2));

} else {
var statearr_32838_32901 = state_32831__$1;
(statearr_32838_32901[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (24))){
var inst_32782 = (state_32831[(9)]);
var inst_32791 = (state_32831[(10)]);
var inst_32805 = (state_32831[(11)]);
var inst_32805__$1 = (inst_32782.cljs$core$IFn$_invoke$arity$1 ? inst_32782.cljs$core$IFn$_invoke$arity$1(inst_32791) : inst_32782.call(null,inst_32791));
var state_32831__$1 = (function (){var statearr_32839 = state_32831;
(statearr_32839[(11)] = inst_32805__$1);

return statearr_32839;
})();
if(cljs.core.truth_(inst_32805__$1)){
var statearr_32840_32902 = state_32831__$1;
(statearr_32840_32902[(1)] = (29));

} else {
var statearr_32841_32903 = state_32831__$1;
(statearr_32841_32903[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (4))){
var inst_32750 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32750)){
var statearr_32842_32904 = state_32831__$1;
(statearr_32842_32904[(1)] = (8));

} else {
var statearr_32843_32905 = state_32831__$1;
(statearr_32843_32905[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (15))){
var inst_32776 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32776)){
var statearr_32844_32906 = state_32831__$1;
(statearr_32844_32906[(1)] = (19));

} else {
var statearr_32845_32907 = state_32831__$1;
(statearr_32845_32907[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (21))){
var inst_32781 = (state_32831[(12)]);
var inst_32781__$1 = (state_32831[(2)]);
var inst_32782 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32781__$1,cljs.core.cst$kw$solos);
var inst_32783 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32781__$1,cljs.core.cst$kw$mutes);
var inst_32784 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32781__$1,cljs.core.cst$kw$reads);
var state_32831__$1 = (function (){var statearr_32846 = state_32831;
(statearr_32846[(9)] = inst_32782);

(statearr_32846[(13)] = inst_32783);

(statearr_32846[(12)] = inst_32781__$1);

return statearr_32846;
})();
return cljs.core.async.ioc_alts_BANG_(state_32831__$1,(22),inst_32784);
} else {
if((state_val_32832 === (31))){
var inst_32813 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32813)){
var statearr_32847_32908 = state_32831__$1;
(statearr_32847_32908[(1)] = (32));

} else {
var statearr_32848_32909 = state_32831__$1;
(statearr_32848_32909[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (32))){
var inst_32790 = (state_32831[(14)]);
var state_32831__$1 = state_32831;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32831__$1,(35),out,inst_32790);
} else {
if((state_val_32832 === (33))){
var inst_32781 = (state_32831[(12)]);
var inst_32759 = inst_32781;
var state_32831__$1 = (function (){var statearr_32849 = state_32831;
(statearr_32849[(7)] = inst_32759);

return statearr_32849;
})();
var statearr_32850_32910 = state_32831__$1;
(statearr_32850_32910[(2)] = null);

(statearr_32850_32910[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (13))){
var inst_32759 = (state_32831[(7)]);
var inst_32766 = inst_32759.cljs$lang$protocol_mask$partition0$;
var inst_32767 = (inst_32766 & (64));
var inst_32768 = inst_32759.cljs$core$ISeq$;
var inst_32769 = (inst_32767) || (inst_32768);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32769)){
var statearr_32851_32911 = state_32831__$1;
(statearr_32851_32911[(1)] = (16));

} else {
var statearr_32852_32912 = state_32831__$1;
(statearr_32852_32912[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (22))){
var inst_32790 = (state_32831[(14)]);
var inst_32791 = (state_32831[(10)]);
var inst_32789 = (state_32831[(2)]);
var inst_32790__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32789,(0),null);
var inst_32791__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32789,(1),null);
var inst_32792 = (inst_32790__$1 == null);
var inst_32793 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32791__$1,change);
var inst_32794 = (inst_32792) || (inst_32793);
var state_32831__$1 = (function (){var statearr_32853 = state_32831;
(statearr_32853[(14)] = inst_32790__$1);

(statearr_32853[(10)] = inst_32791__$1);

return statearr_32853;
})();
if(cljs.core.truth_(inst_32794)){
var statearr_32854_32913 = state_32831__$1;
(statearr_32854_32913[(1)] = (23));

} else {
var statearr_32855_32914 = state_32831__$1;
(statearr_32855_32914[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (36))){
var inst_32781 = (state_32831[(12)]);
var inst_32759 = inst_32781;
var state_32831__$1 = (function (){var statearr_32856 = state_32831;
(statearr_32856[(7)] = inst_32759);

return statearr_32856;
})();
var statearr_32857_32915 = state_32831__$1;
(statearr_32857_32915[(2)] = null);

(statearr_32857_32915[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (29))){
var inst_32805 = (state_32831[(11)]);
var state_32831__$1 = state_32831;
var statearr_32858_32916 = state_32831__$1;
(statearr_32858_32916[(2)] = inst_32805);

(statearr_32858_32916[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (6))){
var state_32831__$1 = state_32831;
var statearr_32859_32917 = state_32831__$1;
(statearr_32859_32917[(2)] = false);

(statearr_32859_32917[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (28))){
var inst_32801 = (state_32831[(2)]);
var inst_32802 = calc_state();
var inst_32759 = inst_32802;
var state_32831__$1 = (function (){var statearr_32860 = state_32831;
(statearr_32860[(7)] = inst_32759);

(statearr_32860[(15)] = inst_32801);

return statearr_32860;
})();
var statearr_32861_32918 = state_32831__$1;
(statearr_32861_32918[(2)] = null);

(statearr_32861_32918[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (25))){
var inst_32827 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
var statearr_32862_32919 = state_32831__$1;
(statearr_32862_32919[(2)] = inst_32827);

(statearr_32862_32919[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (34))){
var inst_32825 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
var statearr_32863_32920 = state_32831__$1;
(statearr_32863_32920[(2)] = inst_32825);

(statearr_32863_32920[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (17))){
var state_32831__$1 = state_32831;
var statearr_32864_32921 = state_32831__$1;
(statearr_32864_32921[(2)] = false);

(statearr_32864_32921[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (3))){
var state_32831__$1 = state_32831;
var statearr_32865_32922 = state_32831__$1;
(statearr_32865_32922[(2)] = false);

(statearr_32865_32922[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (12))){
var inst_32829 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32831__$1,inst_32829);
} else {
if((state_val_32832 === (2))){
var inst_32735 = (state_32831[(8)]);
var inst_32740 = inst_32735.cljs$lang$protocol_mask$partition0$;
var inst_32741 = (inst_32740 & (64));
var inst_32742 = inst_32735.cljs$core$ISeq$;
var inst_32743 = (inst_32741) || (inst_32742);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32743)){
var statearr_32866_32923 = state_32831__$1;
(statearr_32866_32923[(1)] = (5));

} else {
var statearr_32867_32924 = state_32831__$1;
(statearr_32867_32924[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (23))){
var inst_32790 = (state_32831[(14)]);
var inst_32796 = (inst_32790 == null);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32796)){
var statearr_32868_32925 = state_32831__$1;
(statearr_32868_32925[(1)] = (26));

} else {
var statearr_32869_32926 = state_32831__$1;
(statearr_32869_32926[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (35))){
var inst_32816 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
if(cljs.core.truth_(inst_32816)){
var statearr_32870_32927 = state_32831__$1;
(statearr_32870_32927[(1)] = (36));

} else {
var statearr_32871_32928 = state_32831__$1;
(statearr_32871_32928[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (19))){
var inst_32759 = (state_32831[(7)]);
var inst_32778 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32759);
var state_32831__$1 = state_32831;
var statearr_32872_32929 = state_32831__$1;
(statearr_32872_32929[(2)] = inst_32778);

(statearr_32872_32929[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (11))){
var inst_32759 = (state_32831[(7)]);
var inst_32763 = (inst_32759 == null);
var inst_32764 = cljs.core.not(inst_32763);
var state_32831__$1 = state_32831;
if(inst_32764){
var statearr_32873_32930 = state_32831__$1;
(statearr_32873_32930[(1)] = (13));

} else {
var statearr_32874_32931 = state_32831__$1;
(statearr_32874_32931[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (9))){
var inst_32735 = (state_32831[(8)]);
var state_32831__$1 = state_32831;
var statearr_32875_32932 = state_32831__$1;
(statearr_32875_32932[(2)] = inst_32735);

(statearr_32875_32932[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (5))){
var state_32831__$1 = state_32831;
var statearr_32876_32933 = state_32831__$1;
(statearr_32876_32933[(2)] = true);

(statearr_32876_32933[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (14))){
var state_32831__$1 = state_32831;
var statearr_32877_32934 = state_32831__$1;
(statearr_32877_32934[(2)] = false);

(statearr_32877_32934[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (26))){
var inst_32791 = (state_32831[(10)]);
var inst_32798 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32791);
var state_32831__$1 = state_32831;
var statearr_32878_32935 = state_32831__$1;
(statearr_32878_32935[(2)] = inst_32798);

(statearr_32878_32935[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (16))){
var state_32831__$1 = state_32831;
var statearr_32879_32936 = state_32831__$1;
(statearr_32879_32936[(2)] = true);

(statearr_32879_32936[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (38))){
var inst_32821 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
var statearr_32880_32937 = state_32831__$1;
(statearr_32880_32937[(2)] = inst_32821);

(statearr_32880_32937[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (30))){
var inst_32782 = (state_32831[(9)]);
var inst_32783 = (state_32831[(13)]);
var inst_32791 = (state_32831[(10)]);
var inst_32808 = cljs.core.empty_QMARK_(inst_32782);
var inst_32809 = (inst_32783.cljs$core$IFn$_invoke$arity$1 ? inst_32783.cljs$core$IFn$_invoke$arity$1(inst_32791) : inst_32783.call(null,inst_32791));
var inst_32810 = cljs.core.not(inst_32809);
var inst_32811 = (inst_32808) && (inst_32810);
var state_32831__$1 = state_32831;
var statearr_32881_32938 = state_32831__$1;
(statearr_32881_32938[(2)] = inst_32811);

(statearr_32881_32938[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (10))){
var inst_32735 = (state_32831[(8)]);
var inst_32755 = (state_32831[(2)]);
var inst_32756 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32755,cljs.core.cst$kw$solos);
var inst_32757 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32755,cljs.core.cst$kw$mutes);
var inst_32758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32755,cljs.core.cst$kw$reads);
var inst_32759 = inst_32735;
var state_32831__$1 = (function (){var statearr_32882 = state_32831;
(statearr_32882[(7)] = inst_32759);

(statearr_32882[(16)] = inst_32756);

(statearr_32882[(17)] = inst_32757);

(statearr_32882[(18)] = inst_32758);

return statearr_32882;
})();
var statearr_32883_32939 = state_32831__$1;
(statearr_32883_32939[(2)] = null);

(statearr_32883_32939[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (18))){
var inst_32773 = (state_32831[(2)]);
var state_32831__$1 = state_32831;
var statearr_32884_32940 = state_32831__$1;
(statearr_32884_32940[(2)] = inst_32773);

(statearr_32884_32940[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (37))){
var state_32831__$1 = state_32831;
var statearr_32885_32941 = state_32831__$1;
(statearr_32885_32941[(2)] = null);

(statearr_32885_32941[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32832 === (8))){
var inst_32735 = (state_32831[(8)]);
var inst_32752 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32735);
var state_32831__$1 = state_32831;
var statearr_32886_32942 = state_32831__$1;
(statearr_32886_32942[(2)] = inst_32752);

(statearr_32886_32942[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___32896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12189__auto__,c__12301__auto___32896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12190__auto__ = null;
var cljs$core$async$mix_$_state_machine__12190__auto____0 = (function (){
var statearr_32890 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32890[(0)] = cljs$core$async$mix_$_state_machine__12190__auto__);

(statearr_32890[(1)] = (1));

return statearr_32890;
});
var cljs$core$async$mix_$_state_machine__12190__auto____1 = (function (state_32831){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_32831);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e32891){if((e32891 instanceof Object)){
var ex__12193__auto__ = e32891;
var statearr_32892_32943 = state_32831;
(statearr_32892_32943[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32831);

return cljs.core.cst$kw$recur;
} else {
throw e32891;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__32944 = state_32831;
state_32831 = G__32944;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12190__auto__ = function(state_32831){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12190__auto____1.call(this,state_32831);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12190__auto____0;
cljs$core$async$mix_$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12190__auto____1;
return cljs$core$async$mix_$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___32896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12303__auto__ = (function (){var statearr_32893 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_32893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___32896);

return statearr_32893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___32896,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args32945 = [];
var len__7484__auto___32948 = arguments.length;
var i__7485__auto___32949 = (0);
while(true){
if((i__7485__auto___32949 < len__7484__auto___32948)){
args32945.push((arguments[i__7485__auto___32949]));

var G__32950 = (i__7485__auto___32949 + (1));
i__7485__auto___32949 = G__32950;
continue;
} else {
}
break;
}

var G__32947 = args32945.length;
switch (G__32947) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32945.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args32953 = [];
var len__7484__auto___33081 = arguments.length;
var i__7485__auto___33082 = (0);
while(true){
if((i__7485__auto___33082 < len__7484__auto___33081)){
args32953.push((arguments[i__7485__auto___33082]));

var G__33083 = (i__7485__auto___33082 + (1));
i__7485__auto___33082 = G__33083;
continue;
} else {
}
break;
}

var G__32955 = args32953.length;
switch (G__32955) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32953.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__32956 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32956) : cljs.core.atom.call(null,G__32956));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__32952_SHARP_){
if(cljs.core.truth_((p1__32952_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32952_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32952_SHARP_.call(null,topic)))){
return p1__32952_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32952_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32957 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32957 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32958){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32958 = meta32958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32959,meta32958__$1){
var self__ = this;
var _32959__$1 = this;
return (new cljs.core.async.t_cljs$core$async32957(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32958__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32959){
var self__ = this;
var _32959__$1 = this;
return self__.meta32958;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32960 = self__.mults;
var G__32961 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32960,G__32961) : cljs.core.reset_BANG_.call(null,G__32960,G__32961));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta32958], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32957.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32957.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32957";

cljs.core.async.t_cljs$core$async32957.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32957");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32957 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32957(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32958){
return (new cljs.core.async.t_cljs$core$async32957(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32958));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32957(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12301__auto___33085 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33085,mults,ensure_mult,p){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33085,mults,ensure_mult,p){
return (function (state_33033){
var state_val_33034 = (state_33033[(1)]);
if((state_val_33034 === (7))){
var inst_33029 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
var statearr_33035_33086 = state_33033__$1;
(statearr_33035_33086[(2)] = inst_33029);

(statearr_33035_33086[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (20))){
var state_33033__$1 = state_33033;
var statearr_33036_33087 = state_33033__$1;
(statearr_33036_33087[(2)] = null);

(statearr_33036_33087[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (1))){
var state_33033__$1 = state_33033;
var statearr_33037_33088 = state_33033__$1;
(statearr_33037_33088[(2)] = null);

(statearr_33037_33088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (24))){
var inst_33012 = (state_33033[(7)]);
var inst_33021 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33012);
var state_33033__$1 = state_33033;
var statearr_33038_33089 = state_33033__$1;
(statearr_33038_33089[(2)] = inst_33021);

(statearr_33038_33089[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (4))){
var inst_32964 = (state_33033[(8)]);
var inst_32964__$1 = (state_33033[(2)]);
var inst_32965 = (inst_32964__$1 == null);
var state_33033__$1 = (function (){var statearr_33039 = state_33033;
(statearr_33039[(8)] = inst_32964__$1);

return statearr_33039;
})();
if(cljs.core.truth_(inst_32965)){
var statearr_33040_33090 = state_33033__$1;
(statearr_33040_33090[(1)] = (5));

} else {
var statearr_33041_33091 = state_33033__$1;
(statearr_33041_33091[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (15))){
var inst_33006 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
var statearr_33042_33092 = state_33033__$1;
(statearr_33042_33092[(2)] = inst_33006);

(statearr_33042_33092[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (21))){
var inst_33026 = (state_33033[(2)]);
var state_33033__$1 = (function (){var statearr_33043 = state_33033;
(statearr_33043[(9)] = inst_33026);

return statearr_33043;
})();
var statearr_33044_33093 = state_33033__$1;
(statearr_33044_33093[(2)] = null);

(statearr_33044_33093[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (13))){
var inst_32988 = (state_33033[(10)]);
var inst_32990 = cljs.core.chunked_seq_QMARK_(inst_32988);
var state_33033__$1 = state_33033;
if(inst_32990){
var statearr_33045_33094 = state_33033__$1;
(statearr_33045_33094[(1)] = (16));

} else {
var statearr_33046_33095 = state_33033__$1;
(statearr_33046_33095[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (22))){
var inst_33018 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
if(cljs.core.truth_(inst_33018)){
var statearr_33047_33096 = state_33033__$1;
(statearr_33047_33096[(1)] = (23));

} else {
var statearr_33048_33097 = state_33033__$1;
(statearr_33048_33097[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (6))){
var inst_32964 = (state_33033[(8)]);
var inst_33014 = (state_33033[(11)]);
var inst_33012 = (state_33033[(7)]);
var inst_33012__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32964) : topic_fn.call(null,inst_32964));
var inst_33013 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33014__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33013,inst_33012__$1);
var state_33033__$1 = (function (){var statearr_33049 = state_33033;
(statearr_33049[(11)] = inst_33014__$1);

(statearr_33049[(7)] = inst_33012__$1);

return statearr_33049;
})();
if(cljs.core.truth_(inst_33014__$1)){
var statearr_33050_33098 = state_33033__$1;
(statearr_33050_33098[(1)] = (19));

} else {
var statearr_33051_33099 = state_33033__$1;
(statearr_33051_33099[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (25))){
var inst_33023 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
var statearr_33052_33100 = state_33033__$1;
(statearr_33052_33100[(2)] = inst_33023);

(statearr_33052_33100[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (17))){
var inst_32988 = (state_33033[(10)]);
var inst_32997 = cljs.core.first(inst_32988);
var inst_32998 = cljs.core.async.muxch_STAR_(inst_32997);
var inst_32999 = cljs.core.async.close_BANG_(inst_32998);
var inst_33000 = cljs.core.next(inst_32988);
var inst_32974 = inst_33000;
var inst_32975 = null;
var inst_32976 = (0);
var inst_32977 = (0);
var state_33033__$1 = (function (){var statearr_33053 = state_33033;
(statearr_33053[(12)] = inst_32976);

(statearr_33053[(13)] = inst_32977);

(statearr_33053[(14)] = inst_32975);

(statearr_33053[(15)] = inst_32974);

(statearr_33053[(16)] = inst_32999);

return statearr_33053;
})();
var statearr_33054_33101 = state_33033__$1;
(statearr_33054_33101[(2)] = null);

(statearr_33054_33101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (3))){
var inst_33031 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33033__$1,inst_33031);
} else {
if((state_val_33034 === (12))){
var inst_33008 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
var statearr_33055_33102 = state_33033__$1;
(statearr_33055_33102[(2)] = inst_33008);

(statearr_33055_33102[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (2))){
var state_33033__$1 = state_33033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33033__$1,(4),ch);
} else {
if((state_val_33034 === (23))){
var state_33033__$1 = state_33033;
var statearr_33056_33103 = state_33033__$1;
(statearr_33056_33103[(2)] = null);

(statearr_33056_33103[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (19))){
var inst_32964 = (state_33033[(8)]);
var inst_33014 = (state_33033[(11)]);
var inst_33016 = cljs.core.async.muxch_STAR_(inst_33014);
var state_33033__$1 = state_33033;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33033__$1,(22),inst_33016,inst_32964);
} else {
if((state_val_33034 === (11))){
var inst_32988 = (state_33033[(10)]);
var inst_32974 = (state_33033[(15)]);
var inst_32988__$1 = cljs.core.seq(inst_32974);
var state_33033__$1 = (function (){var statearr_33057 = state_33033;
(statearr_33057[(10)] = inst_32988__$1);

return statearr_33057;
})();
if(inst_32988__$1){
var statearr_33058_33104 = state_33033__$1;
(statearr_33058_33104[(1)] = (13));

} else {
var statearr_33059_33105 = state_33033__$1;
(statearr_33059_33105[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (9))){
var inst_33010 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
var statearr_33060_33106 = state_33033__$1;
(statearr_33060_33106[(2)] = inst_33010);

(statearr_33060_33106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (5))){
var inst_32971 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_32972 = cljs.core.vals(inst_32971);
var inst_32973 = cljs.core.seq(inst_32972);
var inst_32974 = inst_32973;
var inst_32975 = null;
var inst_32976 = (0);
var inst_32977 = (0);
var state_33033__$1 = (function (){var statearr_33061 = state_33033;
(statearr_33061[(12)] = inst_32976);

(statearr_33061[(13)] = inst_32977);

(statearr_33061[(14)] = inst_32975);

(statearr_33061[(15)] = inst_32974);

return statearr_33061;
})();
var statearr_33062_33107 = state_33033__$1;
(statearr_33062_33107[(2)] = null);

(statearr_33062_33107[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (14))){
var state_33033__$1 = state_33033;
var statearr_33066_33108 = state_33033__$1;
(statearr_33066_33108[(2)] = null);

(statearr_33066_33108[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (16))){
var inst_32988 = (state_33033[(10)]);
var inst_32992 = cljs.core.chunk_first(inst_32988);
var inst_32993 = cljs.core.chunk_rest(inst_32988);
var inst_32994 = cljs.core.count(inst_32992);
var inst_32974 = inst_32993;
var inst_32975 = inst_32992;
var inst_32976 = inst_32994;
var inst_32977 = (0);
var state_33033__$1 = (function (){var statearr_33067 = state_33033;
(statearr_33067[(12)] = inst_32976);

(statearr_33067[(13)] = inst_32977);

(statearr_33067[(14)] = inst_32975);

(statearr_33067[(15)] = inst_32974);

return statearr_33067;
})();
var statearr_33068_33109 = state_33033__$1;
(statearr_33068_33109[(2)] = null);

(statearr_33068_33109[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (10))){
var inst_32976 = (state_33033[(12)]);
var inst_32977 = (state_33033[(13)]);
var inst_32975 = (state_33033[(14)]);
var inst_32974 = (state_33033[(15)]);
var inst_32982 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32975,inst_32977);
var inst_32983 = cljs.core.async.muxch_STAR_(inst_32982);
var inst_32984 = cljs.core.async.close_BANG_(inst_32983);
var inst_32985 = (inst_32977 + (1));
var tmp33063 = inst_32976;
var tmp33064 = inst_32975;
var tmp33065 = inst_32974;
var inst_32974__$1 = tmp33065;
var inst_32975__$1 = tmp33064;
var inst_32976__$1 = tmp33063;
var inst_32977__$1 = inst_32985;
var state_33033__$1 = (function (){var statearr_33069 = state_33033;
(statearr_33069[(12)] = inst_32976__$1);

(statearr_33069[(13)] = inst_32977__$1);

(statearr_33069[(17)] = inst_32984);

(statearr_33069[(14)] = inst_32975__$1);

(statearr_33069[(15)] = inst_32974__$1);

return statearr_33069;
})();
var statearr_33070_33110 = state_33033__$1;
(statearr_33070_33110[(2)] = null);

(statearr_33070_33110[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (18))){
var inst_33003 = (state_33033[(2)]);
var state_33033__$1 = state_33033;
var statearr_33071_33111 = state_33033__$1;
(statearr_33071_33111[(2)] = inst_33003);

(statearr_33071_33111[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33034 === (8))){
var inst_32976 = (state_33033[(12)]);
var inst_32977 = (state_33033[(13)]);
var inst_32979 = (inst_32977 < inst_32976);
var inst_32980 = inst_32979;
var state_33033__$1 = state_33033;
if(cljs.core.truth_(inst_32980)){
var statearr_33072_33112 = state_33033__$1;
(statearr_33072_33112[(1)] = (10));

} else {
var statearr_33073_33113 = state_33033__$1;
(statearr_33073_33113[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33085,mults,ensure_mult,p))
;
return ((function (switch__12189__auto__,c__12301__auto___33085,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33077 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33077[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33077[(1)] = (1));

return statearr_33077;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33033){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33033);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33078){if((e33078 instanceof Object)){
var ex__12193__auto__ = e33078;
var statearr_33079_33114 = state_33033;
(statearr_33079_33114[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33033);

return cljs.core.cst$kw$recur;
} else {
throw e33078;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33115 = state_33033;
state_33033 = G__33115;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33033){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33085,mults,ensure_mult,p))
})();
var state__12303__auto__ = (function (){var statearr_33080 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33085);

return statearr_33080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33085,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33116 = [];
var len__7484__auto___33119 = arguments.length;
var i__7485__auto___33120 = (0);
while(true){
if((i__7485__auto___33120 < len__7484__auto___33119)){
args33116.push((arguments[i__7485__auto___33120]));

var G__33121 = (i__7485__auto___33120 + (1));
i__7485__auto___33120 = G__33121;
continue;
} else {
}
break;
}

var G__33118 = args33116.length;
switch (G__33118) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33116.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33123 = [];
var len__7484__auto___33126 = arguments.length;
var i__7485__auto___33127 = (0);
while(true){
if((i__7485__auto___33127 < len__7484__auto___33126)){
args33123.push((arguments[i__7485__auto___33127]));

var G__33128 = (i__7485__auto___33127 + (1));
i__7485__auto___33127 = G__33128;
continue;
} else {
}
break;
}

var G__33125 = args33123.length;
switch (G__33125) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33123.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33130 = [];
var len__7484__auto___33201 = arguments.length;
var i__7485__auto___33202 = (0);
while(true){
if((i__7485__auto___33202 < len__7484__auto___33201)){
args33130.push((arguments[i__7485__auto___33202]));

var G__33203 = (i__7485__auto___33202 + (1));
i__7485__auto___33202 = G__33203;
continue;
} else {
}
break;
}

var G__33132 = args33130.length;
switch (G__33132) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33130.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12301__auto___33205 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33205,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33205,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33171){
var state_val_33172 = (state_33171[(1)]);
if((state_val_33172 === (7))){
var state_33171__$1 = state_33171;
var statearr_33173_33206 = state_33171__$1;
(statearr_33173_33206[(2)] = null);

(statearr_33173_33206[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (1))){
var state_33171__$1 = state_33171;
var statearr_33174_33207 = state_33171__$1;
(statearr_33174_33207[(2)] = null);

(statearr_33174_33207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (4))){
var inst_33135 = (state_33171[(7)]);
var inst_33137 = (inst_33135 < cnt);
var state_33171__$1 = state_33171;
if(cljs.core.truth_(inst_33137)){
var statearr_33175_33208 = state_33171__$1;
(statearr_33175_33208[(1)] = (6));

} else {
var statearr_33176_33209 = state_33171__$1;
(statearr_33176_33209[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (15))){
var inst_33167 = (state_33171[(2)]);
var state_33171__$1 = state_33171;
var statearr_33177_33210 = state_33171__$1;
(statearr_33177_33210[(2)] = inst_33167);

(statearr_33177_33210[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (13))){
var inst_33160 = cljs.core.async.close_BANG_(out);
var state_33171__$1 = state_33171;
var statearr_33178_33211 = state_33171__$1;
(statearr_33178_33211[(2)] = inst_33160);

(statearr_33178_33211[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (6))){
var state_33171__$1 = state_33171;
var statearr_33179_33212 = state_33171__$1;
(statearr_33179_33212[(2)] = null);

(statearr_33179_33212[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (3))){
var inst_33169 = (state_33171[(2)]);
var state_33171__$1 = state_33171;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33171__$1,inst_33169);
} else {
if((state_val_33172 === (12))){
var inst_33157 = (state_33171[(8)]);
var inst_33157__$1 = (state_33171[(2)]);
var inst_33158 = cljs.core.some(cljs.core.nil_QMARK_,inst_33157__$1);
var state_33171__$1 = (function (){var statearr_33180 = state_33171;
(statearr_33180[(8)] = inst_33157__$1);

return statearr_33180;
})();
if(cljs.core.truth_(inst_33158)){
var statearr_33181_33213 = state_33171__$1;
(statearr_33181_33213[(1)] = (13));

} else {
var statearr_33182_33214 = state_33171__$1;
(statearr_33182_33214[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (2))){
var inst_33134 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33135 = (0);
var state_33171__$1 = (function (){var statearr_33183 = state_33171;
(statearr_33183[(9)] = inst_33134);

(statearr_33183[(7)] = inst_33135);

return statearr_33183;
})();
var statearr_33184_33215 = state_33171__$1;
(statearr_33184_33215[(2)] = null);

(statearr_33184_33215[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (11))){
var inst_33135 = (state_33171[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33171,(10),Object,null,(9));
var inst_33144 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33135) : chs__$1.call(null,inst_33135));
var inst_33145 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33135) : done.call(null,inst_33135));
var inst_33146 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33144,inst_33145);
var state_33171__$1 = state_33171;
var statearr_33185_33216 = state_33171__$1;
(statearr_33185_33216[(2)] = inst_33146);


cljs.core.async.impl.ioc_helpers.process_exception(state_33171__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (9))){
var inst_33135 = (state_33171[(7)]);
var inst_33148 = (state_33171[(2)]);
var inst_33149 = (inst_33135 + (1));
var inst_33135__$1 = inst_33149;
var state_33171__$1 = (function (){var statearr_33186 = state_33171;
(statearr_33186[(10)] = inst_33148);

(statearr_33186[(7)] = inst_33135__$1);

return statearr_33186;
})();
var statearr_33187_33217 = state_33171__$1;
(statearr_33187_33217[(2)] = null);

(statearr_33187_33217[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (5))){
var inst_33155 = (state_33171[(2)]);
var state_33171__$1 = (function (){var statearr_33188 = state_33171;
(statearr_33188[(11)] = inst_33155);

return statearr_33188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33171__$1,(12),dchan);
} else {
if((state_val_33172 === (14))){
var inst_33157 = (state_33171[(8)]);
var inst_33162 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33157);
var state_33171__$1 = state_33171;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33171__$1,(16),out,inst_33162);
} else {
if((state_val_33172 === (16))){
var inst_33164 = (state_33171[(2)]);
var state_33171__$1 = (function (){var statearr_33189 = state_33171;
(statearr_33189[(12)] = inst_33164);

return statearr_33189;
})();
var statearr_33190_33218 = state_33171__$1;
(statearr_33190_33218[(2)] = null);

(statearr_33190_33218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (10))){
var inst_33139 = (state_33171[(2)]);
var inst_33140 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33171__$1 = (function (){var statearr_33191 = state_33171;
(statearr_33191[(13)] = inst_33139);

return statearr_33191;
})();
var statearr_33192_33219 = state_33171__$1;
(statearr_33192_33219[(2)] = inst_33140);


cljs.core.async.impl.ioc_helpers.process_exception(state_33171__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33172 === (8))){
var inst_33153 = (state_33171[(2)]);
var state_33171__$1 = state_33171;
var statearr_33193_33220 = state_33171__$1;
(statearr_33193_33220[(2)] = inst_33153);

(statearr_33193_33220[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33205,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12189__auto__,c__12301__auto___33205,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33197 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33197[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33197[(1)] = (1));

return statearr_33197;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33171){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33171);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33198){if((e33198 instanceof Object)){
var ex__12193__auto__ = e33198;
var statearr_33199_33221 = state_33171;
(statearr_33199_33221[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33171);

return cljs.core.cst$kw$recur;
} else {
throw e33198;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33222 = state_33171;
state_33171 = G__33222;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33171){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33205,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12303__auto__ = (function (){var statearr_33200 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33200[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33205);

return statearr_33200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33205,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33224 = [];
var len__7484__auto___33282 = arguments.length;
var i__7485__auto___33283 = (0);
while(true){
if((i__7485__auto___33283 < len__7484__auto___33282)){
args33224.push((arguments[i__7485__auto___33283]));

var G__33284 = (i__7485__auto___33283 + (1));
i__7485__auto___33283 = G__33284;
continue;
} else {
}
break;
}

var G__33226 = args33224.length;
switch (G__33226) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33224.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12301__auto___33286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33286,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33286,out){
return (function (state_33258){
var state_val_33259 = (state_33258[(1)]);
if((state_val_33259 === (7))){
var inst_33238 = (state_33258[(7)]);
var inst_33237 = (state_33258[(8)]);
var inst_33237__$1 = (state_33258[(2)]);
var inst_33238__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33237__$1,(0),null);
var inst_33239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33237__$1,(1),null);
var inst_33240 = (inst_33238__$1 == null);
var state_33258__$1 = (function (){var statearr_33260 = state_33258;
(statearr_33260[(7)] = inst_33238__$1);

(statearr_33260[(8)] = inst_33237__$1);

(statearr_33260[(9)] = inst_33239);

return statearr_33260;
})();
if(cljs.core.truth_(inst_33240)){
var statearr_33261_33287 = state_33258__$1;
(statearr_33261_33287[(1)] = (8));

} else {
var statearr_33262_33288 = state_33258__$1;
(statearr_33262_33288[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (1))){
var inst_33227 = cljs.core.vec(chs);
var inst_33228 = inst_33227;
var state_33258__$1 = (function (){var statearr_33263 = state_33258;
(statearr_33263[(10)] = inst_33228);

return statearr_33263;
})();
var statearr_33264_33289 = state_33258__$1;
(statearr_33264_33289[(2)] = null);

(statearr_33264_33289[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (4))){
var inst_33228 = (state_33258[(10)]);
var state_33258__$1 = state_33258;
return cljs.core.async.ioc_alts_BANG_(state_33258__$1,(7),inst_33228);
} else {
if((state_val_33259 === (6))){
var inst_33254 = (state_33258[(2)]);
var state_33258__$1 = state_33258;
var statearr_33265_33290 = state_33258__$1;
(statearr_33265_33290[(2)] = inst_33254);

(statearr_33265_33290[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (3))){
var inst_33256 = (state_33258[(2)]);
var state_33258__$1 = state_33258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33258__$1,inst_33256);
} else {
if((state_val_33259 === (2))){
var inst_33228 = (state_33258[(10)]);
var inst_33230 = cljs.core.count(inst_33228);
var inst_33231 = (inst_33230 > (0));
var state_33258__$1 = state_33258;
if(cljs.core.truth_(inst_33231)){
var statearr_33267_33291 = state_33258__$1;
(statearr_33267_33291[(1)] = (4));

} else {
var statearr_33268_33292 = state_33258__$1;
(statearr_33268_33292[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (11))){
var inst_33228 = (state_33258[(10)]);
var inst_33247 = (state_33258[(2)]);
var tmp33266 = inst_33228;
var inst_33228__$1 = tmp33266;
var state_33258__$1 = (function (){var statearr_33269 = state_33258;
(statearr_33269[(10)] = inst_33228__$1);

(statearr_33269[(11)] = inst_33247);

return statearr_33269;
})();
var statearr_33270_33293 = state_33258__$1;
(statearr_33270_33293[(2)] = null);

(statearr_33270_33293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (9))){
var inst_33238 = (state_33258[(7)]);
var state_33258__$1 = state_33258;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33258__$1,(11),out,inst_33238);
} else {
if((state_val_33259 === (5))){
var inst_33252 = cljs.core.async.close_BANG_(out);
var state_33258__$1 = state_33258;
var statearr_33271_33294 = state_33258__$1;
(statearr_33271_33294[(2)] = inst_33252);

(statearr_33271_33294[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (10))){
var inst_33250 = (state_33258[(2)]);
var state_33258__$1 = state_33258;
var statearr_33272_33295 = state_33258__$1;
(statearr_33272_33295[(2)] = inst_33250);

(statearr_33272_33295[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33259 === (8))){
var inst_33228 = (state_33258[(10)]);
var inst_33238 = (state_33258[(7)]);
var inst_33237 = (state_33258[(8)]);
var inst_33239 = (state_33258[(9)]);
var inst_33242 = (function (){var cs = inst_33228;
var vec__33233 = inst_33237;
var v = inst_33238;
var c = inst_33239;
return ((function (cs,vec__33233,v,c,inst_33228,inst_33238,inst_33237,inst_33239,state_val_33259,c__12301__auto___33286,out){
return (function (p1__33223_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33223_SHARP_);
});
;})(cs,vec__33233,v,c,inst_33228,inst_33238,inst_33237,inst_33239,state_val_33259,c__12301__auto___33286,out))
})();
var inst_33243 = cljs.core.filterv(inst_33242,inst_33228);
var inst_33228__$1 = inst_33243;
var state_33258__$1 = (function (){var statearr_33273 = state_33258;
(statearr_33273[(10)] = inst_33228__$1);

return statearr_33273;
})();
var statearr_33274_33296 = state_33258__$1;
(statearr_33274_33296[(2)] = null);

(statearr_33274_33296[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33286,out))
;
return ((function (switch__12189__auto__,c__12301__auto___33286,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33278 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33278[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33278[(1)] = (1));

return statearr_33278;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33258){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33258);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33279){if((e33279 instanceof Object)){
var ex__12193__auto__ = e33279;
var statearr_33280_33297 = state_33258;
(statearr_33280_33297[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33258);

return cljs.core.cst$kw$recur;
} else {
throw e33279;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33298 = state_33258;
state_33258 = G__33298;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33258){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33286,out))
})();
var state__12303__auto__ = (function (){var statearr_33281 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33281[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33286);

return statearr_33281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33286,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33299 = [];
var len__7484__auto___33348 = arguments.length;
var i__7485__auto___33349 = (0);
while(true){
if((i__7485__auto___33349 < len__7484__auto___33348)){
args33299.push((arguments[i__7485__auto___33349]));

var G__33350 = (i__7485__auto___33349 + (1));
i__7485__auto___33349 = G__33350;
continue;
} else {
}
break;
}

var G__33301 = args33299.length;
switch (G__33301) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33299.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12301__auto___33352 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33352,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33352,out){
return (function (state_33325){
var state_val_33326 = (state_33325[(1)]);
if((state_val_33326 === (7))){
var inst_33307 = (state_33325[(7)]);
var inst_33307__$1 = (state_33325[(2)]);
var inst_33308 = (inst_33307__$1 == null);
var inst_33309 = cljs.core.not(inst_33308);
var state_33325__$1 = (function (){var statearr_33327 = state_33325;
(statearr_33327[(7)] = inst_33307__$1);

return statearr_33327;
})();
if(inst_33309){
var statearr_33328_33353 = state_33325__$1;
(statearr_33328_33353[(1)] = (8));

} else {
var statearr_33329_33354 = state_33325__$1;
(statearr_33329_33354[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (1))){
var inst_33302 = (0);
var state_33325__$1 = (function (){var statearr_33330 = state_33325;
(statearr_33330[(8)] = inst_33302);

return statearr_33330;
})();
var statearr_33331_33355 = state_33325__$1;
(statearr_33331_33355[(2)] = null);

(statearr_33331_33355[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (4))){
var state_33325__$1 = state_33325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33325__$1,(7),ch);
} else {
if((state_val_33326 === (6))){
var inst_33320 = (state_33325[(2)]);
var state_33325__$1 = state_33325;
var statearr_33332_33356 = state_33325__$1;
(statearr_33332_33356[(2)] = inst_33320);

(statearr_33332_33356[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (3))){
var inst_33322 = (state_33325[(2)]);
var inst_33323 = cljs.core.async.close_BANG_(out);
var state_33325__$1 = (function (){var statearr_33333 = state_33325;
(statearr_33333[(9)] = inst_33322);

return statearr_33333;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33325__$1,inst_33323);
} else {
if((state_val_33326 === (2))){
var inst_33302 = (state_33325[(8)]);
var inst_33304 = (inst_33302 < n);
var state_33325__$1 = state_33325;
if(cljs.core.truth_(inst_33304)){
var statearr_33334_33357 = state_33325__$1;
(statearr_33334_33357[(1)] = (4));

} else {
var statearr_33335_33358 = state_33325__$1;
(statearr_33335_33358[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (11))){
var inst_33302 = (state_33325[(8)]);
var inst_33312 = (state_33325[(2)]);
var inst_33313 = (inst_33302 + (1));
var inst_33302__$1 = inst_33313;
var state_33325__$1 = (function (){var statearr_33336 = state_33325;
(statearr_33336[(8)] = inst_33302__$1);

(statearr_33336[(10)] = inst_33312);

return statearr_33336;
})();
var statearr_33337_33359 = state_33325__$1;
(statearr_33337_33359[(2)] = null);

(statearr_33337_33359[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (9))){
var state_33325__$1 = state_33325;
var statearr_33338_33360 = state_33325__$1;
(statearr_33338_33360[(2)] = null);

(statearr_33338_33360[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (5))){
var state_33325__$1 = state_33325;
var statearr_33339_33361 = state_33325__$1;
(statearr_33339_33361[(2)] = null);

(statearr_33339_33361[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (10))){
var inst_33317 = (state_33325[(2)]);
var state_33325__$1 = state_33325;
var statearr_33340_33362 = state_33325__$1;
(statearr_33340_33362[(2)] = inst_33317);

(statearr_33340_33362[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33326 === (8))){
var inst_33307 = (state_33325[(7)]);
var state_33325__$1 = state_33325;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33325__$1,(11),out,inst_33307);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33352,out))
;
return ((function (switch__12189__auto__,c__12301__auto___33352,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33344 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33344[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33344[(1)] = (1));

return statearr_33344;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33325){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33325);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33345){if((e33345 instanceof Object)){
var ex__12193__auto__ = e33345;
var statearr_33346_33363 = state_33325;
(statearr_33346_33363[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33325);

return cljs.core.cst$kw$recur;
} else {
throw e33345;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33364 = state_33325;
state_33325 = G__33364;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33352,out))
})();
var state__12303__auto__ = (function (){var statearr_33347 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33347[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33352);

return statearr_33347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33352,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33374 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33374 = (function (map_LT_,f,ch,meta33375){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33375 = meta33375;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33376,meta33375__$1){
var self__ = this;
var _33376__$1 = this;
return (new cljs.core.async.t_cljs$core$async33374(self__.map_LT_,self__.f,self__.ch,meta33375__$1));
});

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33376){
var self__ = this;
var _33376__$1 = this;
return self__.meta33375;
});

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33377 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33377 = (function (map_LT_,f,ch,meta33375,_,fn1,meta33378){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33375 = meta33375;
this._ = _;
this.fn1 = fn1;
this.meta33378 = meta33378;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33377.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33379,meta33378__$1){
var self__ = this;
var _33379__$1 = this;
return (new cljs.core.async.t_cljs$core$async33377(self__.map_LT_,self__.f,self__.ch,self__.meta33375,self__._,self__.fn1,meta33378__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33377.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33379){
var self__ = this;
var _33379__$1 = this;
return self__.meta33378;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33377.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33377.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33377.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33377.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33365_SHARP_){
var G__33380 = (((p1__33365_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33365_SHARP_) : self__.f.call(null,p1__33365_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33380) : f1.call(null,G__33380));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33377.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33375,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async33374], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta33378], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33377.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33377.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33377";

cljs.core.async.t_cljs$core$async33377.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33377");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33377 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33377(map_LT___$1,f__$1,ch__$1,meta33375__$1,___$2,fn1__$1,meta33378){
return (new cljs.core.async.t_cljs$core$async33377(map_LT___$1,f__$1,ch__$1,meta33375__$1,___$2,fn1__$1,meta33378));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33377(self__.map_LT_,self__.f,self__.ch,self__.meta33375,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33381 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33381) : self__.f.call(null,G__33381));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33374.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33374.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33375], null);
});

cljs.core.async.t_cljs$core$async33374.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33374.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33374";

cljs.core.async.t_cljs$core$async33374.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33374");
});

cljs.core.async.__GT_t_cljs$core$async33374 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33374(map_LT___$1,f__$1,ch__$1,meta33375){
return (new cljs.core.async.t_cljs$core$async33374(map_LT___$1,f__$1,ch__$1,meta33375));
});

}

return (new cljs.core.async.t_cljs$core$async33374(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33385 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33385 = (function (map_GT_,f,ch,meta33386){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta33386 = meta33386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33387,meta33386__$1){
var self__ = this;
var _33387__$1 = this;
return (new cljs.core.async.t_cljs$core$async33385(self__.map_GT_,self__.f,self__.ch,meta33386__$1));
});

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33387){
var self__ = this;
var _33387__$1 = this;
return self__.meta33386;
});

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33385.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33385.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33386], null);
});

cljs.core.async.t_cljs$core$async33385.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33385.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33385";

cljs.core.async.t_cljs$core$async33385.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33385");
});

cljs.core.async.__GT_t_cljs$core$async33385 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33385(map_GT___$1,f__$1,ch__$1,meta33386){
return (new cljs.core.async.t_cljs$core$async33385(map_GT___$1,f__$1,ch__$1,meta33386));
});

}

return (new cljs.core.async.t_cljs$core$async33385(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33391 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33391 = (function (filter_GT_,p,ch,meta33392){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta33392 = meta33392;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33393,meta33392__$1){
var self__ = this;
var _33393__$1 = this;
return (new cljs.core.async.t_cljs$core$async33391(self__.filter_GT_,self__.p,self__.ch,meta33392__$1));
});

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33393){
var self__ = this;
var _33393__$1 = this;
return self__.meta33392;
});

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33391.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33391.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33392], null);
});

cljs.core.async.t_cljs$core$async33391.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33391.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33391";

cljs.core.async.t_cljs$core$async33391.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33391");
});

cljs.core.async.__GT_t_cljs$core$async33391 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33391(filter_GT___$1,p__$1,ch__$1,meta33392){
return (new cljs.core.async.t_cljs$core$async33391(filter_GT___$1,p__$1,ch__$1,meta33392));
});

}

return (new cljs.core.async.t_cljs$core$async33391(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33394 = [];
var len__7484__auto___33438 = arguments.length;
var i__7485__auto___33439 = (0);
while(true){
if((i__7485__auto___33439 < len__7484__auto___33438)){
args33394.push((arguments[i__7485__auto___33439]));

var G__33440 = (i__7485__auto___33439 + (1));
i__7485__auto___33439 = G__33440;
continue;
} else {
}
break;
}

var G__33396 = args33394.length;
switch (G__33396) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33394.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12301__auto___33442 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33442,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33442,out){
return (function (state_33417){
var state_val_33418 = (state_33417[(1)]);
if((state_val_33418 === (7))){
var inst_33413 = (state_33417[(2)]);
var state_33417__$1 = state_33417;
var statearr_33419_33443 = state_33417__$1;
(statearr_33419_33443[(2)] = inst_33413);

(statearr_33419_33443[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (1))){
var state_33417__$1 = state_33417;
var statearr_33420_33444 = state_33417__$1;
(statearr_33420_33444[(2)] = null);

(statearr_33420_33444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (4))){
var inst_33399 = (state_33417[(7)]);
var inst_33399__$1 = (state_33417[(2)]);
var inst_33400 = (inst_33399__$1 == null);
var state_33417__$1 = (function (){var statearr_33421 = state_33417;
(statearr_33421[(7)] = inst_33399__$1);

return statearr_33421;
})();
if(cljs.core.truth_(inst_33400)){
var statearr_33422_33445 = state_33417__$1;
(statearr_33422_33445[(1)] = (5));

} else {
var statearr_33423_33446 = state_33417__$1;
(statearr_33423_33446[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (6))){
var inst_33399 = (state_33417[(7)]);
var inst_33404 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33399) : p.call(null,inst_33399));
var state_33417__$1 = state_33417;
if(cljs.core.truth_(inst_33404)){
var statearr_33424_33447 = state_33417__$1;
(statearr_33424_33447[(1)] = (8));

} else {
var statearr_33425_33448 = state_33417__$1;
(statearr_33425_33448[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (3))){
var inst_33415 = (state_33417[(2)]);
var state_33417__$1 = state_33417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33417__$1,inst_33415);
} else {
if((state_val_33418 === (2))){
var state_33417__$1 = state_33417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33417__$1,(4),ch);
} else {
if((state_val_33418 === (11))){
var inst_33407 = (state_33417[(2)]);
var state_33417__$1 = state_33417;
var statearr_33426_33449 = state_33417__$1;
(statearr_33426_33449[(2)] = inst_33407);

(statearr_33426_33449[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (9))){
var state_33417__$1 = state_33417;
var statearr_33427_33450 = state_33417__$1;
(statearr_33427_33450[(2)] = null);

(statearr_33427_33450[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (5))){
var inst_33402 = cljs.core.async.close_BANG_(out);
var state_33417__$1 = state_33417;
var statearr_33428_33451 = state_33417__$1;
(statearr_33428_33451[(2)] = inst_33402);

(statearr_33428_33451[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (10))){
var inst_33410 = (state_33417[(2)]);
var state_33417__$1 = (function (){var statearr_33429 = state_33417;
(statearr_33429[(8)] = inst_33410);

return statearr_33429;
})();
var statearr_33430_33452 = state_33417__$1;
(statearr_33430_33452[(2)] = null);

(statearr_33430_33452[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33418 === (8))){
var inst_33399 = (state_33417[(7)]);
var state_33417__$1 = state_33417;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33417__$1,(11),out,inst_33399);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33442,out))
;
return ((function (switch__12189__auto__,c__12301__auto___33442,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33434 = [null,null,null,null,null,null,null,null,null];
(statearr_33434[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33434[(1)] = (1));

return statearr_33434;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33417){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33417);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33435){if((e33435 instanceof Object)){
var ex__12193__auto__ = e33435;
var statearr_33436_33453 = state_33417;
(statearr_33436_33453[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33417);

return cljs.core.cst$kw$recur;
} else {
throw e33435;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33454 = state_33417;
state_33417 = G__33454;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33417){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33442,out))
})();
var state__12303__auto__ = (function (){var statearr_33437 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33437[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33442);

return statearr_33437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33442,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args33455 = [];
var len__7484__auto___33458 = arguments.length;
var i__7485__auto___33459 = (0);
while(true){
if((i__7485__auto___33459 < len__7484__auto___33458)){
args33455.push((arguments[i__7485__auto___33459]));

var G__33460 = (i__7485__auto___33459 + (1));
i__7485__auto___33459 = G__33460;
continue;
} else {
}
break;
}

var G__33457 = args33455.length;
switch (G__33457) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33455.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12301__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto__){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto__){
return (function (state_33627){
var state_val_33628 = (state_33627[(1)]);
if((state_val_33628 === (7))){
var inst_33623 = (state_33627[(2)]);
var state_33627__$1 = state_33627;
var statearr_33629_33670 = state_33627__$1;
(statearr_33629_33670[(2)] = inst_33623);

(statearr_33629_33670[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (20))){
var inst_33593 = (state_33627[(7)]);
var inst_33604 = (state_33627[(2)]);
var inst_33605 = cljs.core.next(inst_33593);
var inst_33579 = inst_33605;
var inst_33580 = null;
var inst_33581 = (0);
var inst_33582 = (0);
var state_33627__$1 = (function (){var statearr_33630 = state_33627;
(statearr_33630[(8)] = inst_33582);

(statearr_33630[(9)] = inst_33581);

(statearr_33630[(10)] = inst_33604);

(statearr_33630[(11)] = inst_33579);

(statearr_33630[(12)] = inst_33580);

return statearr_33630;
})();
var statearr_33631_33671 = state_33627__$1;
(statearr_33631_33671[(2)] = null);

(statearr_33631_33671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (1))){
var state_33627__$1 = state_33627;
var statearr_33632_33672 = state_33627__$1;
(statearr_33632_33672[(2)] = null);

(statearr_33632_33672[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (4))){
var inst_33568 = (state_33627[(13)]);
var inst_33568__$1 = (state_33627[(2)]);
var inst_33569 = (inst_33568__$1 == null);
var state_33627__$1 = (function (){var statearr_33633 = state_33627;
(statearr_33633[(13)] = inst_33568__$1);

return statearr_33633;
})();
if(cljs.core.truth_(inst_33569)){
var statearr_33634_33673 = state_33627__$1;
(statearr_33634_33673[(1)] = (5));

} else {
var statearr_33635_33674 = state_33627__$1;
(statearr_33635_33674[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (15))){
var state_33627__$1 = state_33627;
var statearr_33639_33675 = state_33627__$1;
(statearr_33639_33675[(2)] = null);

(statearr_33639_33675[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (21))){
var state_33627__$1 = state_33627;
var statearr_33640_33676 = state_33627__$1;
(statearr_33640_33676[(2)] = null);

(statearr_33640_33676[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (13))){
var inst_33582 = (state_33627[(8)]);
var inst_33581 = (state_33627[(9)]);
var inst_33579 = (state_33627[(11)]);
var inst_33580 = (state_33627[(12)]);
var inst_33589 = (state_33627[(2)]);
var inst_33590 = (inst_33582 + (1));
var tmp33636 = inst_33581;
var tmp33637 = inst_33579;
var tmp33638 = inst_33580;
var inst_33579__$1 = tmp33637;
var inst_33580__$1 = tmp33638;
var inst_33581__$1 = tmp33636;
var inst_33582__$1 = inst_33590;
var state_33627__$1 = (function (){var statearr_33641 = state_33627;
(statearr_33641[(14)] = inst_33589);

(statearr_33641[(8)] = inst_33582__$1);

(statearr_33641[(9)] = inst_33581__$1);

(statearr_33641[(11)] = inst_33579__$1);

(statearr_33641[(12)] = inst_33580__$1);

return statearr_33641;
})();
var statearr_33642_33677 = state_33627__$1;
(statearr_33642_33677[(2)] = null);

(statearr_33642_33677[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (22))){
var state_33627__$1 = state_33627;
var statearr_33643_33678 = state_33627__$1;
(statearr_33643_33678[(2)] = null);

(statearr_33643_33678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (6))){
var inst_33568 = (state_33627[(13)]);
var inst_33577 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33568) : f.call(null,inst_33568));
var inst_33578 = cljs.core.seq(inst_33577);
var inst_33579 = inst_33578;
var inst_33580 = null;
var inst_33581 = (0);
var inst_33582 = (0);
var state_33627__$1 = (function (){var statearr_33644 = state_33627;
(statearr_33644[(8)] = inst_33582);

(statearr_33644[(9)] = inst_33581);

(statearr_33644[(11)] = inst_33579);

(statearr_33644[(12)] = inst_33580);

return statearr_33644;
})();
var statearr_33645_33679 = state_33627__$1;
(statearr_33645_33679[(2)] = null);

(statearr_33645_33679[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (17))){
var inst_33593 = (state_33627[(7)]);
var inst_33597 = cljs.core.chunk_first(inst_33593);
var inst_33598 = cljs.core.chunk_rest(inst_33593);
var inst_33599 = cljs.core.count(inst_33597);
var inst_33579 = inst_33598;
var inst_33580 = inst_33597;
var inst_33581 = inst_33599;
var inst_33582 = (0);
var state_33627__$1 = (function (){var statearr_33646 = state_33627;
(statearr_33646[(8)] = inst_33582);

(statearr_33646[(9)] = inst_33581);

(statearr_33646[(11)] = inst_33579);

(statearr_33646[(12)] = inst_33580);

return statearr_33646;
})();
var statearr_33647_33680 = state_33627__$1;
(statearr_33647_33680[(2)] = null);

(statearr_33647_33680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (3))){
var inst_33625 = (state_33627[(2)]);
var state_33627__$1 = state_33627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33627__$1,inst_33625);
} else {
if((state_val_33628 === (12))){
var inst_33613 = (state_33627[(2)]);
var state_33627__$1 = state_33627;
var statearr_33648_33681 = state_33627__$1;
(statearr_33648_33681[(2)] = inst_33613);

(statearr_33648_33681[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (2))){
var state_33627__$1 = state_33627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33627__$1,(4),in$);
} else {
if((state_val_33628 === (23))){
var inst_33621 = (state_33627[(2)]);
var state_33627__$1 = state_33627;
var statearr_33649_33682 = state_33627__$1;
(statearr_33649_33682[(2)] = inst_33621);

(statearr_33649_33682[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (19))){
var inst_33608 = (state_33627[(2)]);
var state_33627__$1 = state_33627;
var statearr_33650_33683 = state_33627__$1;
(statearr_33650_33683[(2)] = inst_33608);

(statearr_33650_33683[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (11))){
var inst_33593 = (state_33627[(7)]);
var inst_33579 = (state_33627[(11)]);
var inst_33593__$1 = cljs.core.seq(inst_33579);
var state_33627__$1 = (function (){var statearr_33651 = state_33627;
(statearr_33651[(7)] = inst_33593__$1);

return statearr_33651;
})();
if(inst_33593__$1){
var statearr_33652_33684 = state_33627__$1;
(statearr_33652_33684[(1)] = (14));

} else {
var statearr_33653_33685 = state_33627__$1;
(statearr_33653_33685[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (9))){
var inst_33615 = (state_33627[(2)]);
var inst_33616 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33627__$1 = (function (){var statearr_33654 = state_33627;
(statearr_33654[(15)] = inst_33615);

return statearr_33654;
})();
if(cljs.core.truth_(inst_33616)){
var statearr_33655_33686 = state_33627__$1;
(statearr_33655_33686[(1)] = (21));

} else {
var statearr_33656_33687 = state_33627__$1;
(statearr_33656_33687[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (5))){
var inst_33571 = cljs.core.async.close_BANG_(out);
var state_33627__$1 = state_33627;
var statearr_33657_33688 = state_33627__$1;
(statearr_33657_33688[(2)] = inst_33571);

(statearr_33657_33688[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (14))){
var inst_33593 = (state_33627[(7)]);
var inst_33595 = cljs.core.chunked_seq_QMARK_(inst_33593);
var state_33627__$1 = state_33627;
if(inst_33595){
var statearr_33658_33689 = state_33627__$1;
(statearr_33658_33689[(1)] = (17));

} else {
var statearr_33659_33690 = state_33627__$1;
(statearr_33659_33690[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (16))){
var inst_33611 = (state_33627[(2)]);
var state_33627__$1 = state_33627;
var statearr_33660_33691 = state_33627__$1;
(statearr_33660_33691[(2)] = inst_33611);

(statearr_33660_33691[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33628 === (10))){
var inst_33582 = (state_33627[(8)]);
var inst_33580 = (state_33627[(12)]);
var inst_33587 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33580,inst_33582);
var state_33627__$1 = state_33627;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33627__$1,(13),out,inst_33587);
} else {
if((state_val_33628 === (18))){
var inst_33593 = (state_33627[(7)]);
var inst_33602 = cljs.core.first(inst_33593);
var state_33627__$1 = state_33627;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33627__$1,(20),out,inst_33602);
} else {
if((state_val_33628 === (8))){
var inst_33582 = (state_33627[(8)]);
var inst_33581 = (state_33627[(9)]);
var inst_33584 = (inst_33582 < inst_33581);
var inst_33585 = inst_33584;
var state_33627__$1 = state_33627;
if(cljs.core.truth_(inst_33585)){
var statearr_33661_33692 = state_33627__$1;
(statearr_33661_33692[(1)] = (10));

} else {
var statearr_33662_33693 = state_33627__$1;
(statearr_33662_33693[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto__))
;
return ((function (switch__12189__auto__,c__12301__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____0 = (function (){
var statearr_33666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33666[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__);

(statearr_33666[(1)] = (1));

return statearr_33666;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____1 = (function (state_33627){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33627);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33667){if((e33667 instanceof Object)){
var ex__12193__auto__ = e33667;
var statearr_33668_33694 = state_33627;
(statearr_33668_33694[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33627);

return cljs.core.cst$kw$recur;
} else {
throw e33667;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33695 = state_33627;
state_33627 = G__33695;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__ = function(state_33627){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____1.call(this,state_33627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12190__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto__))
})();
var state__12303__auto__ = (function (){var statearr_33669 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33669[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto__);

return statearr_33669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto__))
);

return c__12301__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args33696 = [];
var len__7484__auto___33699 = arguments.length;
var i__7485__auto___33700 = (0);
while(true){
if((i__7485__auto___33700 < len__7484__auto___33699)){
args33696.push((arguments[i__7485__auto___33700]));

var G__33701 = (i__7485__auto___33700 + (1));
i__7485__auto___33700 = G__33701;
continue;
} else {
}
break;
}

var G__33698 = args33696.length;
switch (G__33698) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33696.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args33703 = [];
var len__7484__auto___33706 = arguments.length;
var i__7485__auto___33707 = (0);
while(true){
if((i__7485__auto___33707 < len__7484__auto___33706)){
args33703.push((arguments[i__7485__auto___33707]));

var G__33708 = (i__7485__auto___33707 + (1));
i__7485__auto___33707 = G__33708;
continue;
} else {
}
break;
}

var G__33705 = args33703.length;
switch (G__33705) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33703.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args33710 = [];
var len__7484__auto___33761 = arguments.length;
var i__7485__auto___33762 = (0);
while(true){
if((i__7485__auto___33762 < len__7484__auto___33761)){
args33710.push((arguments[i__7485__auto___33762]));

var G__33763 = (i__7485__auto___33762 + (1));
i__7485__auto___33762 = G__33763;
continue;
} else {
}
break;
}

var G__33712 = args33710.length;
switch (G__33712) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33710.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12301__auto___33765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33765,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33765,out){
return (function (state_33736){
var state_val_33737 = (state_33736[(1)]);
if((state_val_33737 === (7))){
var inst_33731 = (state_33736[(2)]);
var state_33736__$1 = state_33736;
var statearr_33738_33766 = state_33736__$1;
(statearr_33738_33766[(2)] = inst_33731);

(statearr_33738_33766[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (1))){
var inst_33713 = null;
var state_33736__$1 = (function (){var statearr_33739 = state_33736;
(statearr_33739[(7)] = inst_33713);

return statearr_33739;
})();
var statearr_33740_33767 = state_33736__$1;
(statearr_33740_33767[(2)] = null);

(statearr_33740_33767[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (4))){
var inst_33716 = (state_33736[(8)]);
var inst_33716__$1 = (state_33736[(2)]);
var inst_33717 = (inst_33716__$1 == null);
var inst_33718 = cljs.core.not(inst_33717);
var state_33736__$1 = (function (){var statearr_33741 = state_33736;
(statearr_33741[(8)] = inst_33716__$1);

return statearr_33741;
})();
if(inst_33718){
var statearr_33742_33768 = state_33736__$1;
(statearr_33742_33768[(1)] = (5));

} else {
var statearr_33743_33769 = state_33736__$1;
(statearr_33743_33769[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (6))){
var state_33736__$1 = state_33736;
var statearr_33744_33770 = state_33736__$1;
(statearr_33744_33770[(2)] = null);

(statearr_33744_33770[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (3))){
var inst_33733 = (state_33736[(2)]);
var inst_33734 = cljs.core.async.close_BANG_(out);
var state_33736__$1 = (function (){var statearr_33745 = state_33736;
(statearr_33745[(9)] = inst_33733);

return statearr_33745;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33736__$1,inst_33734);
} else {
if((state_val_33737 === (2))){
var state_33736__$1 = state_33736;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33736__$1,(4),ch);
} else {
if((state_val_33737 === (11))){
var inst_33716 = (state_33736[(8)]);
var inst_33725 = (state_33736[(2)]);
var inst_33713 = inst_33716;
var state_33736__$1 = (function (){var statearr_33746 = state_33736;
(statearr_33746[(10)] = inst_33725);

(statearr_33746[(7)] = inst_33713);

return statearr_33746;
})();
var statearr_33747_33771 = state_33736__$1;
(statearr_33747_33771[(2)] = null);

(statearr_33747_33771[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (9))){
var inst_33716 = (state_33736[(8)]);
var state_33736__$1 = state_33736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33736__$1,(11),out,inst_33716);
} else {
if((state_val_33737 === (5))){
var inst_33716 = (state_33736[(8)]);
var inst_33713 = (state_33736[(7)]);
var inst_33720 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33716,inst_33713);
var state_33736__$1 = state_33736;
if(inst_33720){
var statearr_33749_33772 = state_33736__$1;
(statearr_33749_33772[(1)] = (8));

} else {
var statearr_33750_33773 = state_33736__$1;
(statearr_33750_33773[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (10))){
var inst_33728 = (state_33736[(2)]);
var state_33736__$1 = state_33736;
var statearr_33751_33774 = state_33736__$1;
(statearr_33751_33774[(2)] = inst_33728);

(statearr_33751_33774[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33737 === (8))){
var inst_33713 = (state_33736[(7)]);
var tmp33748 = inst_33713;
var inst_33713__$1 = tmp33748;
var state_33736__$1 = (function (){var statearr_33752 = state_33736;
(statearr_33752[(7)] = inst_33713__$1);

return statearr_33752;
})();
var statearr_33753_33775 = state_33736__$1;
(statearr_33753_33775[(2)] = null);

(statearr_33753_33775[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33765,out))
;
return ((function (switch__12189__auto__,c__12301__auto___33765,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33757 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33757[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33757[(1)] = (1));

return statearr_33757;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33736){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33736);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33758){if((e33758 instanceof Object)){
var ex__12193__auto__ = e33758;
var statearr_33759_33776 = state_33736;
(statearr_33759_33776[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33736);

return cljs.core.cst$kw$recur;
} else {
throw e33758;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33777 = state_33736;
state_33736 = G__33777;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33765,out))
})();
var state__12303__auto__ = (function (){var statearr_33760 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33765);

return statearr_33760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33765,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33778 = [];
var len__7484__auto___33848 = arguments.length;
var i__7485__auto___33849 = (0);
while(true){
if((i__7485__auto___33849 < len__7484__auto___33848)){
args33778.push((arguments[i__7485__auto___33849]));

var G__33850 = (i__7485__auto___33849 + (1));
i__7485__auto___33849 = G__33850;
continue;
} else {
}
break;
}

var G__33780 = args33778.length;
switch (G__33780) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33778.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12301__auto___33852 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33852,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33852,out){
return (function (state_33818){
var state_val_33819 = (state_33818[(1)]);
if((state_val_33819 === (7))){
var inst_33814 = (state_33818[(2)]);
var state_33818__$1 = state_33818;
var statearr_33820_33853 = state_33818__$1;
(statearr_33820_33853[(2)] = inst_33814);

(statearr_33820_33853[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (1))){
var inst_33781 = (new Array(n));
var inst_33782 = inst_33781;
var inst_33783 = (0);
var state_33818__$1 = (function (){var statearr_33821 = state_33818;
(statearr_33821[(7)] = inst_33782);

(statearr_33821[(8)] = inst_33783);

return statearr_33821;
})();
var statearr_33822_33854 = state_33818__$1;
(statearr_33822_33854[(2)] = null);

(statearr_33822_33854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (4))){
var inst_33786 = (state_33818[(9)]);
var inst_33786__$1 = (state_33818[(2)]);
var inst_33787 = (inst_33786__$1 == null);
var inst_33788 = cljs.core.not(inst_33787);
var state_33818__$1 = (function (){var statearr_33823 = state_33818;
(statearr_33823[(9)] = inst_33786__$1);

return statearr_33823;
})();
if(inst_33788){
var statearr_33824_33855 = state_33818__$1;
(statearr_33824_33855[(1)] = (5));

} else {
var statearr_33825_33856 = state_33818__$1;
(statearr_33825_33856[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (15))){
var inst_33808 = (state_33818[(2)]);
var state_33818__$1 = state_33818;
var statearr_33826_33857 = state_33818__$1;
(statearr_33826_33857[(2)] = inst_33808);

(statearr_33826_33857[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (13))){
var state_33818__$1 = state_33818;
var statearr_33827_33858 = state_33818__$1;
(statearr_33827_33858[(2)] = null);

(statearr_33827_33858[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (6))){
var inst_33783 = (state_33818[(8)]);
var inst_33804 = (inst_33783 > (0));
var state_33818__$1 = state_33818;
if(cljs.core.truth_(inst_33804)){
var statearr_33828_33859 = state_33818__$1;
(statearr_33828_33859[(1)] = (12));

} else {
var statearr_33829_33860 = state_33818__$1;
(statearr_33829_33860[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (3))){
var inst_33816 = (state_33818[(2)]);
var state_33818__$1 = state_33818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33818__$1,inst_33816);
} else {
if((state_val_33819 === (12))){
var inst_33782 = (state_33818[(7)]);
var inst_33806 = cljs.core.vec(inst_33782);
var state_33818__$1 = state_33818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33818__$1,(15),out,inst_33806);
} else {
if((state_val_33819 === (2))){
var state_33818__$1 = state_33818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33818__$1,(4),ch);
} else {
if((state_val_33819 === (11))){
var inst_33798 = (state_33818[(2)]);
var inst_33799 = (new Array(n));
var inst_33782 = inst_33799;
var inst_33783 = (0);
var state_33818__$1 = (function (){var statearr_33830 = state_33818;
(statearr_33830[(7)] = inst_33782);

(statearr_33830[(8)] = inst_33783);

(statearr_33830[(10)] = inst_33798);

return statearr_33830;
})();
var statearr_33831_33861 = state_33818__$1;
(statearr_33831_33861[(2)] = null);

(statearr_33831_33861[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (9))){
var inst_33782 = (state_33818[(7)]);
var inst_33796 = cljs.core.vec(inst_33782);
var state_33818__$1 = state_33818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33818__$1,(11),out,inst_33796);
} else {
if((state_val_33819 === (5))){
var inst_33782 = (state_33818[(7)]);
var inst_33791 = (state_33818[(11)]);
var inst_33786 = (state_33818[(9)]);
var inst_33783 = (state_33818[(8)]);
var inst_33790 = (inst_33782[inst_33783] = inst_33786);
var inst_33791__$1 = (inst_33783 + (1));
var inst_33792 = (inst_33791__$1 < n);
var state_33818__$1 = (function (){var statearr_33832 = state_33818;
(statearr_33832[(11)] = inst_33791__$1);

(statearr_33832[(12)] = inst_33790);

return statearr_33832;
})();
if(cljs.core.truth_(inst_33792)){
var statearr_33833_33862 = state_33818__$1;
(statearr_33833_33862[(1)] = (8));

} else {
var statearr_33834_33863 = state_33818__$1;
(statearr_33834_33863[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (14))){
var inst_33811 = (state_33818[(2)]);
var inst_33812 = cljs.core.async.close_BANG_(out);
var state_33818__$1 = (function (){var statearr_33836 = state_33818;
(statearr_33836[(13)] = inst_33811);

return statearr_33836;
})();
var statearr_33837_33864 = state_33818__$1;
(statearr_33837_33864[(2)] = inst_33812);

(statearr_33837_33864[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (10))){
var inst_33802 = (state_33818[(2)]);
var state_33818__$1 = state_33818;
var statearr_33838_33865 = state_33818__$1;
(statearr_33838_33865[(2)] = inst_33802);

(statearr_33838_33865[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33819 === (8))){
var inst_33782 = (state_33818[(7)]);
var inst_33791 = (state_33818[(11)]);
var tmp33835 = inst_33782;
var inst_33782__$1 = tmp33835;
var inst_33783 = inst_33791;
var state_33818__$1 = (function (){var statearr_33839 = state_33818;
(statearr_33839[(7)] = inst_33782__$1);

(statearr_33839[(8)] = inst_33783);

return statearr_33839;
})();
var statearr_33840_33866 = state_33818__$1;
(statearr_33840_33866[(2)] = null);

(statearr_33840_33866[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33852,out))
;
return ((function (switch__12189__auto__,c__12301__auto___33852,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33844 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33844[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33844[(1)] = (1));

return statearr_33844;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33818){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33818);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33845){if((e33845 instanceof Object)){
var ex__12193__auto__ = e33845;
var statearr_33846_33867 = state_33818;
(statearr_33846_33867[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33818);

return cljs.core.cst$kw$recur;
} else {
throw e33845;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33868 = state_33818;
state_33818 = G__33868;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33818){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33852,out))
})();
var state__12303__auto__ = (function (){var statearr_33847 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33847[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33852);

return statearr_33847;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33852,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args33869 = [];
var len__7484__auto___33943 = arguments.length;
var i__7485__auto___33944 = (0);
while(true){
if((i__7485__auto___33944 < len__7484__auto___33943)){
args33869.push((arguments[i__7485__auto___33944]));

var G__33945 = (i__7485__auto___33944 + (1));
i__7485__auto___33944 = G__33945;
continue;
} else {
}
break;
}

var G__33871 = args33869.length;
switch (G__33871) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33869.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12301__auto___33947 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12301__auto___33947,out){
return (function (){
var f__12302__auto__ = (function (){var switch__12189__auto__ = ((function (c__12301__auto___33947,out){
return (function (state_33913){
var state_val_33914 = (state_33913[(1)]);
if((state_val_33914 === (7))){
var inst_33909 = (state_33913[(2)]);
var state_33913__$1 = state_33913;
var statearr_33915_33948 = state_33913__$1;
(statearr_33915_33948[(2)] = inst_33909);

(statearr_33915_33948[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (1))){
var inst_33872 = [];
var inst_33873 = inst_33872;
var inst_33874 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_33913__$1 = (function (){var statearr_33916 = state_33913;
(statearr_33916[(7)] = inst_33873);

(statearr_33916[(8)] = inst_33874);

return statearr_33916;
})();
var statearr_33917_33949 = state_33913__$1;
(statearr_33917_33949[(2)] = null);

(statearr_33917_33949[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (4))){
var inst_33877 = (state_33913[(9)]);
var inst_33877__$1 = (state_33913[(2)]);
var inst_33878 = (inst_33877__$1 == null);
var inst_33879 = cljs.core.not(inst_33878);
var state_33913__$1 = (function (){var statearr_33918 = state_33913;
(statearr_33918[(9)] = inst_33877__$1);

return statearr_33918;
})();
if(inst_33879){
var statearr_33919_33950 = state_33913__$1;
(statearr_33919_33950[(1)] = (5));

} else {
var statearr_33920_33951 = state_33913__$1;
(statearr_33920_33951[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (15))){
var inst_33903 = (state_33913[(2)]);
var state_33913__$1 = state_33913;
var statearr_33921_33952 = state_33913__$1;
(statearr_33921_33952[(2)] = inst_33903);

(statearr_33921_33952[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (13))){
var state_33913__$1 = state_33913;
var statearr_33922_33953 = state_33913__$1;
(statearr_33922_33953[(2)] = null);

(statearr_33922_33953[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (6))){
var inst_33873 = (state_33913[(7)]);
var inst_33898 = inst_33873.length;
var inst_33899 = (inst_33898 > (0));
var state_33913__$1 = state_33913;
if(cljs.core.truth_(inst_33899)){
var statearr_33923_33954 = state_33913__$1;
(statearr_33923_33954[(1)] = (12));

} else {
var statearr_33924_33955 = state_33913__$1;
(statearr_33924_33955[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (3))){
var inst_33911 = (state_33913[(2)]);
var state_33913__$1 = state_33913;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33913__$1,inst_33911);
} else {
if((state_val_33914 === (12))){
var inst_33873 = (state_33913[(7)]);
var inst_33901 = cljs.core.vec(inst_33873);
var state_33913__$1 = state_33913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33913__$1,(15),out,inst_33901);
} else {
if((state_val_33914 === (2))){
var state_33913__$1 = state_33913;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33913__$1,(4),ch);
} else {
if((state_val_33914 === (11))){
var inst_33881 = (state_33913[(10)]);
var inst_33877 = (state_33913[(9)]);
var inst_33891 = (state_33913[(2)]);
var inst_33892 = [];
var inst_33893 = inst_33892.push(inst_33877);
var inst_33873 = inst_33892;
var inst_33874 = inst_33881;
var state_33913__$1 = (function (){var statearr_33925 = state_33913;
(statearr_33925[(11)] = inst_33893);

(statearr_33925[(7)] = inst_33873);

(statearr_33925[(8)] = inst_33874);

(statearr_33925[(12)] = inst_33891);

return statearr_33925;
})();
var statearr_33926_33956 = state_33913__$1;
(statearr_33926_33956[(2)] = null);

(statearr_33926_33956[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (9))){
var inst_33873 = (state_33913[(7)]);
var inst_33889 = cljs.core.vec(inst_33873);
var state_33913__$1 = state_33913;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33913__$1,(11),out,inst_33889);
} else {
if((state_val_33914 === (5))){
var inst_33881 = (state_33913[(10)]);
var inst_33874 = (state_33913[(8)]);
var inst_33877 = (state_33913[(9)]);
var inst_33881__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33877) : f.call(null,inst_33877));
var inst_33882 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33881__$1,inst_33874);
var inst_33883 = cljs.core.keyword_identical_QMARK_(inst_33874,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_33884 = (inst_33882) || (inst_33883);
var state_33913__$1 = (function (){var statearr_33927 = state_33913;
(statearr_33927[(10)] = inst_33881__$1);

return statearr_33927;
})();
if(cljs.core.truth_(inst_33884)){
var statearr_33928_33957 = state_33913__$1;
(statearr_33928_33957[(1)] = (8));

} else {
var statearr_33929_33958 = state_33913__$1;
(statearr_33929_33958[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (14))){
var inst_33906 = (state_33913[(2)]);
var inst_33907 = cljs.core.async.close_BANG_(out);
var state_33913__$1 = (function (){var statearr_33931 = state_33913;
(statearr_33931[(13)] = inst_33906);

return statearr_33931;
})();
var statearr_33932_33959 = state_33913__$1;
(statearr_33932_33959[(2)] = inst_33907);

(statearr_33932_33959[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (10))){
var inst_33896 = (state_33913[(2)]);
var state_33913__$1 = state_33913;
var statearr_33933_33960 = state_33913__$1;
(statearr_33933_33960[(2)] = inst_33896);

(statearr_33933_33960[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33914 === (8))){
var inst_33881 = (state_33913[(10)]);
var inst_33873 = (state_33913[(7)]);
var inst_33877 = (state_33913[(9)]);
var inst_33886 = inst_33873.push(inst_33877);
var tmp33930 = inst_33873;
var inst_33873__$1 = tmp33930;
var inst_33874 = inst_33881;
var state_33913__$1 = (function (){var statearr_33934 = state_33913;
(statearr_33934[(14)] = inst_33886);

(statearr_33934[(7)] = inst_33873__$1);

(statearr_33934[(8)] = inst_33874);

return statearr_33934;
})();
var statearr_33935_33961 = state_33913__$1;
(statearr_33935_33961[(2)] = null);

(statearr_33935_33961[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12301__auto___33947,out))
;
return ((function (switch__12189__auto__,c__12301__auto___33947,out){
return (function() {
var cljs$core$async$state_machine__12190__auto__ = null;
var cljs$core$async$state_machine__12190__auto____0 = (function (){
var statearr_33939 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33939[(0)] = cljs$core$async$state_machine__12190__auto__);

(statearr_33939[(1)] = (1));

return statearr_33939;
});
var cljs$core$async$state_machine__12190__auto____1 = (function (state_33913){
while(true){
var ret_value__12191__auto__ = (function (){try{while(true){
var result__12192__auto__ = switch__12189__auto__(state_33913);
if(cljs.core.keyword_identical_QMARK_(result__12192__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12192__auto__;
}
break;
}
}catch (e33940){if((e33940 instanceof Object)){
var ex__12193__auto__ = e33940;
var statearr_33941_33962 = state_33913;
(statearr_33941_33962[(5)] = ex__12193__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33913);

return cljs.core.cst$kw$recur;
} else {
throw e33940;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12191__auto__,cljs.core.cst$kw$recur)){
var G__33963 = state_33913;
state_33913 = G__33963;
continue;
} else {
return ret_value__12191__auto__;
}
break;
}
});
cljs$core$async$state_machine__12190__auto__ = function(state_33913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12190__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12190__auto____1.call(this,state_33913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12190__auto____0;
cljs$core$async$state_machine__12190__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12190__auto____1;
return cljs$core$async$state_machine__12190__auto__;
})()
;})(switch__12189__auto__,c__12301__auto___33947,out))
})();
var state__12303__auto__ = (function (){var statearr_33942 = (f__12302__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12302__auto__.cljs$core$IFn$_invoke$arity$0() : f__12302__auto__.call(null));
(statearr_33942[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12301__auto___33947);

return statearr_33942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12303__auto__);
});})(c__12301__auto___33947,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

