// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of string
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33975 = arguments.length;
var i__7485__auto___33976 = (0);
while(true){
if((i__7485__auto___33976 < len__7484__auto___33975)){
args__7491__auto__.push((arguments[i__7485__auto___33976]));

var G__33977 = (i__7485__auto___33976 + (1));
i__7485__auto___33976 = G__33977;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__33971){
var map__33972 = p__33971;
var map__33972__$1 = ((((!((map__33972 == null)))?((((map__33972.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33972.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33972):map__33972);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33972__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(cljs.core.truth_((function (){var or__6409__auto__ = cljs.core.empty_QMARK_(string);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return chimera.string.is_null_QMARK_(string);
}
})())){
return false;
} else {
var G__33974 = cljs.core.re_find(cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),string);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__33974) : chimera.core.not_nil_QMARK_.call(null,G__33974));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq33968){
var G__33969 = cljs.core.first(seq33968);
var seq33968__$1 = cljs.core.next(seq33968);
var G__33970 = cljs.core.first(seq33968__$1);
var seq33968__$2 = cljs.core.next(seq33968__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__33969,G__33970,seq33968__$2);
});

