// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args39675 = [];
var len__7484__auto___39678 = arguments.length;
var i__7485__auto___39679 = (0);
while(true){
if((i__7485__auto___39679 < len__7484__auto___39678)){
args39675.push((arguments[i__7485__auto___39679]));

var G__39680 = (i__7485__auto___39679 + (1));
i__7485__auto___39679 = G__39680;
continue;
} else {
}
break;
}

var G__39677 = args39675.length;
switch (G__39677) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39675.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args39682 = [];
var len__7484__auto___39685 = arguments.length;
var i__7485__auto___39686 = (0);
while(true){
if((i__7485__auto___39686 < len__7484__auto___39685)){
args39682.push((arguments[i__7485__auto___39686]));

var G__39687 = (i__7485__auto___39686 + (1));
i__7485__auto___39686 = G__39687;
continue;
} else {
}
break;
}

var G__39684 = args39682.length;
switch (G__39684) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39682.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39691_39693 = c2.dom.__GT_dom(container);
var G__39692_39694 = el__$1;
goog.dom.appendChild(G__39691_39693,G__39692_39694);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39698_39701 = c2.dom.__GT_dom(container);
var G__39699_39702 = el__$1;
var G__39700_39703 = (0);
goog.dom.insertChildAt(G__39698_39701,G__39699_39702,G__39700_39703);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__39705 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__39705);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__39708_39710 = new$__$1;
var G__39709_39711 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__39708_39710,G__39709_39711);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args39712 = [];
var len__7484__auto___39730 = arguments.length;
var i__7485__auto___39731 = (0);
while(true){
if((i__7485__auto___39731 < len__7484__auto___39730)){
args39712.push((arguments[i__7485__auto___39731]));

var G__39732 = (i__7485__auto___39731 + (1));
i__7485__auto___39731 = G__39732;
continue;
} else {
}
break;
}

var G__39714 = args39712.length;
switch (G__39714) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39712.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__39715 = el__$1;
var G__39716 = cljs.core.name(x);
return goog.style.getComputedStyle(G__39715,G__39716);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39717_39734 = cljs.core.seq(x);
var chunk__39718_39735 = null;
var count__39719_39736 = (0);
var i__39720_39737 = (0);
while(true){
if((i__39720_39737 < count__39719_39736)){
var vec__39721_39738 = chunk__39718_39735.cljs$core$IIndexed$_nth$arity$2(null,i__39720_39737);
var k_39739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721_39738,(0),null);
var v_39740 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721_39738,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39739,v_39740);

var G__39741 = seq__39717_39734;
var G__39742 = chunk__39718_39735;
var G__39743 = count__39719_39736;
var G__39744 = (i__39720_39737 + (1));
seq__39717_39734 = G__39741;
chunk__39718_39735 = G__39742;
count__39719_39736 = G__39743;
i__39720_39737 = G__39744;
continue;
} else {
var temp__4657__auto___39745 = cljs.core.seq(seq__39717_39734);
if(temp__4657__auto___39745){
var seq__39717_39746__$1 = temp__4657__auto___39745;
if(cljs.core.chunked_seq_QMARK_(seq__39717_39746__$1)){
var c__7220__auto___39747 = cljs.core.chunk_first(seq__39717_39746__$1);
var G__39748 = cljs.core.chunk_rest(seq__39717_39746__$1);
var G__39749 = c__7220__auto___39747;
var G__39750 = cljs.core.count(c__7220__auto___39747);
var G__39751 = (0);
seq__39717_39734 = G__39748;
chunk__39718_39735 = G__39749;
count__39719_39736 = G__39750;
i__39720_39737 = G__39751;
continue;
} else {
var vec__39724_39752 = cljs.core.first(seq__39717_39746__$1);
var k_39753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39724_39752,(0),null);
var v_39754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39724_39752,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39753,v_39754);

var G__39755 = cljs.core.next(seq__39717_39746__$1);
var G__39756 = null;
var G__39757 = (0);
var G__39758 = (0);
seq__39717_39734 = G__39755;
chunk__39718_39735 = G__39756;
count__39719_39736 = G__39757;
i__39720_39737 = G__39758;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__39727_39759 = c2.dom.__GT_dom(el);
var G__39728_39760 = cljs.core.name(k);
var G__39729_39761 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__39727_39759,G__39728_39760,G__39729_39761);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args39762 = [];
var len__7484__auto___39781 = arguments.length;
var i__7485__auto___39782 = (0);
while(true){
if((i__7485__auto___39782 < len__7484__auto___39781)){
args39762.push((arguments[i__7485__auto___39782]));

var G__39783 = (i__7485__auto___39782 + (1));
i__7485__auto___39782 = G__39783;
continue;
} else {
}
break;
}

var G__39764 = args39762.length;
switch (G__39764) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39762.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__39765(s__39766){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__39766__$1 = s__39766;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39766__$1);
if(temp__4657__auto__){
var s__39766__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39766__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39766__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39768 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39767 = (0);
while(true){
if((i__39767 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39767);
cljs.core.chunk_append(b__39768,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__39785 = (i__39767 + (1));
i__39767 = G__39785;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39768),c2$dom$iter__39765(cljs.core.chunk_rest(s__39766__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39768),null);
}
} else {
var i = cljs.core.first(s__39766__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__39765(cljs.core.rest(s__39766__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39771_39786 = cljs.core.seq(x);
var chunk__39772_39787 = null;
var count__39773_39788 = (0);
var i__39774_39789 = (0);
while(true){
if((i__39774_39789 < count__39773_39788)){
var vec__39775_39790 = chunk__39772_39787.cljs$core$IIndexed$_nth$arity$2(null,i__39774_39789);
var k_39791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39775_39790,(0),null);
var v_39792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39775_39790,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39791,v_39792);

var G__39793 = seq__39771_39786;
var G__39794 = chunk__39772_39787;
var G__39795 = count__39773_39788;
var G__39796 = (i__39774_39789 + (1));
seq__39771_39786 = G__39793;
chunk__39772_39787 = G__39794;
count__39773_39788 = G__39795;
i__39774_39789 = G__39796;
continue;
} else {
var temp__4657__auto___39797 = cljs.core.seq(seq__39771_39786);
if(temp__4657__auto___39797){
var seq__39771_39798__$1 = temp__4657__auto___39797;
if(cljs.core.chunked_seq_QMARK_(seq__39771_39798__$1)){
var c__7220__auto___39799 = cljs.core.chunk_first(seq__39771_39798__$1);
var G__39800 = cljs.core.chunk_rest(seq__39771_39798__$1);
var G__39801 = c__7220__auto___39799;
var G__39802 = cljs.core.count(c__7220__auto___39799);
var G__39803 = (0);
seq__39771_39786 = G__39800;
chunk__39772_39787 = G__39801;
count__39773_39788 = G__39802;
i__39774_39789 = G__39803;
continue;
} else {
var vec__39778_39804 = cljs.core.first(seq__39771_39798__$1);
var k_39805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39778_39804,(0),null);
var v_39806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39778_39804,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39805,v_39806);

var G__39807 = cljs.core.next(seq__39771_39798__$1);
var G__39808 = null;
var G__39809 = (0);
var G__39810 = (0);
seq__39771_39786 = G__39807;
chunk__39772_39787 = G__39808;
count__39773_39788 = G__39809;
i__39774_39789 = G__39810;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args39811 = [];
var len__7484__auto___39815 = arguments.length;
var i__7485__auto___39816 = (0);
while(true){
if((i__7485__auto___39816 < len__7484__auto___39815)){
args39811.push((arguments[i__7485__auto___39816]));

var G__39817 = (i__7485__auto___39816 + (1));
i__7485__auto___39816 = G__39817;
continue;
} else {
}
break;
}

var G__39813 = args39811.length;
switch (G__39813) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39811.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39814 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__39814);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args39819 = [];
var len__7484__auto___39823 = arguments.length;
var i__7485__auto___39824 = (0);
while(true){
if((i__7485__auto___39824 < len__7484__auto___39823)){
args39819.push((arguments[i__7485__auto___39824]));

var G__39825 = (i__7485__auto___39824 + (1));
i__7485__auto___39824 = G__39825;
continue;
} else {
}
break;
}

var G__39821 = args39819.length;
switch (G__39821) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39819.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39822 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__39822);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__39830_39833 = c2.dom.__GT_dom(el);
var G__39831_39834 = cljs.core.name(class$);
var G__39832_39835 = classed_QMARK_;
goog.dom.classes.enable(G__39830_39833,G__39831_39834,G__39832_39835);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__39836_SHARP_){
var G__39837 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__39836_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__39836_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__39836_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__39838 = (10);
return setTimeout(G__39837,G__39838);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
