// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12231__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12231__auto__){
return (function (){
var f__12232__auto__ = (function (){var switch__12119__auto__ = ((function (c__12231__auto__){
return (function (state_20398){
var state_val_20399 = (state_20398[(1)]);
if((state_val_20399 === (7))){
var inst_20355 = (state_20398[(7)]);
var inst_20355__$1 = (state_20398[(2)]);
var inst_20357 = (inst_20355__$1 == null);
var inst_20358 = cljs.core.not.call(null,inst_20357);
var state_20398__$1 = (function (){var statearr_20400 = state_20398;
(statearr_20400[(7)] = inst_20355__$1);

return statearr_20400;
})();
if(inst_20358){
var statearr_20401_20438 = state_20398__$1;
(statearr_20401_20438[(1)] = (8));

} else {
var statearr_20402_20439 = state_20398__$1;
(statearr_20402_20439[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (20))){
var inst_20377 = (state_20398[(8)]);
var inst_20385 = (state_20398[(2)]);
var state_20398__$1 = (function (){var statearr_20403 = state_20398;
(statearr_20403[(9)] = inst_20385);

return statearr_20403;
})();
if(cljs.core.truth_(inst_20377)){
var statearr_20404_20440 = state_20398__$1;
(statearr_20404_20440[(1)] = (21));

} else {
var statearr_20405_20441 = state_20398__$1;
(statearr_20405_20441[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (1))){
var state_20398__$1 = state_20398;
var statearr_20406_20442 = state_20398__$1;
(statearr_20406_20442[(2)] = null);

(statearr_20406_20442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (4))){
var state_20398__$1 = state_20398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20398__$1,(7),agg_data_channel);
} else {
if((state_val_20399 === (15))){
var inst_20355 = (state_20398[(7)]);
var state_20398__$1 = state_20398;
var statearr_20407_20443 = state_20398__$1;
(statearr_20407_20443[(2)] = inst_20355);

(statearr_20407_20443[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (21))){
var inst_20387 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_20398__$1 = state_20398;
var statearr_20408_20444 = state_20398__$1;
(statearr_20408_20444[(2)] = inst_20387);

(statearr_20408_20444[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (13))){
var inst_20367 = (state_20398[(2)]);
var state_20398__$1 = state_20398;
var statearr_20409_20445 = state_20398__$1;
(statearr_20409_20445[(2)] = inst_20367);

(statearr_20409_20445[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (22))){
var state_20398__$1 = state_20398;
var statearr_20410_20446 = state_20398__$1;
(statearr_20410_20446[(2)] = null);

(statearr_20410_20446[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (6))){
var inst_20394 = (state_20398[(2)]);
var state_20398__$1 = state_20398;
var statearr_20411_20447 = state_20398__$1;
(statearr_20411_20447[(2)] = inst_20394);

(statearr_20411_20447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (17))){
var inst_20377 = (state_20398[(8)]);
var inst_20376 = (state_20398[(10)]);
var inst_20379 = callback.call(null,inst_20376,inst_20377);
var state_20398__$1 = state_20398;
var statearr_20412_20448 = state_20398__$1;
(statearr_20412_20448[(2)] = inst_20379);

(statearr_20412_20448[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (3))){
var inst_20396 = (state_20398[(2)]);
var state_20398__$1 = state_20398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20398__$1,inst_20396);
} else {
if((state_val_20399 === (12))){
var state_20398__$1 = state_20398;
var statearr_20413_20449 = state_20398__$1;
(statearr_20413_20449[(2)] = false);

(statearr_20413_20449[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (2))){
var state_20398__$1 = state_20398;
var statearr_20414_20450 = state_20398__$1;
(statearr_20414_20450[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (23))){
var inst_20390 = (state_20398[(2)]);
var state_20398__$1 = (function (){var statearr_20416 = state_20398;
(statearr_20416[(11)] = inst_20390);

return statearr_20416;
})();
var statearr_20417_20451 = state_20398__$1;
(statearr_20417_20451[(2)] = null);

(statearr_20417_20451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (19))){
var inst_20382 = (state_20398[(2)]);
var inst_20383 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_20398__$1 = (function (){var statearr_20418 = state_20398;
(statearr_20418[(12)] = inst_20382);

return statearr_20418;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20398__$1,(20),inst_20383);
} else {
if((state_val_20399 === (11))){
var state_20398__$1 = state_20398;
var statearr_20419_20452 = state_20398__$1;
(statearr_20419_20452[(2)] = true);

(statearr_20419_20452[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (9))){
var state_20398__$1 = state_20398;
var statearr_20420_20453 = state_20398__$1;
(statearr_20420_20453[(2)] = false);

(statearr_20420_20453[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (5))){
var state_20398__$1 = state_20398;
var statearr_20421_20454 = state_20398__$1;
(statearr_20421_20454[(2)] = null);

(statearr_20421_20454[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (14))){
var inst_20355 = (state_20398[(7)]);
var inst_20372 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20355);
var state_20398__$1 = state_20398;
var statearr_20422_20455 = state_20398__$1;
(statearr_20422_20455[(2)] = inst_20372);

(statearr_20422_20455[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (16))){
var inst_20376 = (state_20398[(10)]);
var inst_20375 = (state_20398[(2)]);
var inst_20376__$1 = cljs.core.get.call(null,inst_20375,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_20377 = cljs.core.get.call(null,inst_20375,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_20398__$1 = (function (){var statearr_20423 = state_20398;
(statearr_20423[(8)] = inst_20377);

(statearr_20423[(10)] = inst_20376__$1);

return statearr_20423;
})();
if(cljs.core.truth_(inst_20376__$1)){
var statearr_20424_20456 = state_20398__$1;
(statearr_20424_20456[(1)] = (17));

} else {
var statearr_20425_20457 = state_20398__$1;
(statearr_20425_20457[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (10))){
var inst_20370 = (state_20398[(2)]);
var state_20398__$1 = state_20398;
if(cljs.core.truth_(inst_20370)){
var statearr_20426_20458 = state_20398__$1;
(statearr_20426_20458[(1)] = (14));

} else {
var statearr_20427_20459 = state_20398__$1;
(statearr_20427_20459[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (18))){
var state_20398__$1 = state_20398;
var statearr_20428_20460 = state_20398__$1;
(statearr_20428_20460[(2)] = null);

(statearr_20428_20460[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20399 === (8))){
var inst_20355 = (state_20398[(7)]);
var inst_20360 = inst_20355.cljs$lang$protocol_mask$partition0$;
var inst_20361 = (inst_20360 & (64));
var inst_20362 = inst_20355.cljs$core$ISeq$;
var inst_20363 = (inst_20361) || (inst_20362);
var state_20398__$1 = state_20398;
if(cljs.core.truth_(inst_20363)){
var statearr_20429_20461 = state_20398__$1;
(statearr_20429_20461[(1)] = (11));

} else {
var statearr_20430_20462 = state_20398__$1;
(statearr_20430_20462[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12231__auto__))
;
return ((function (switch__12119__auto__,c__12231__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto____0 = (function (){
var statearr_20434 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20434[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto__);

(statearr_20434[(1)] = (1));

return statearr_20434;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto____1 = (function (state_20398){
while(true){
var ret_value__12121__auto__ = (function (){try{while(true){
var result__12122__auto__ = switch__12119__auto__.call(null,state_20398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12122__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12122__auto__;
}
break;
}
}catch (e20435){if((e20435 instanceof Object)){
var ex__12123__auto__ = e20435;
var statearr_20436_20463 = state_20398;
(statearr_20436_20463[(5)] = ex__12123__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20398);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12121__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20464 = state_20398;
state_20398 = G__20464;
continue;
} else {
return ret_value__12121__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto__ = function(state_20398){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto____1.call(this,state_20398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12120__auto__;
})()
;})(switch__12119__auto__,c__12231__auto__))
})();
var state__12233__auto__ = (function (){var statearr_20437 = f__12232__auto__.call(null);
(statearr_20437[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12231__auto__);

return statearr_20437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12233__auto__);
});})(c__12231__auto__))
);

return c__12231__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20471 = arguments.length;
var i__7485__auto___20472 = (0);
while(true){
if((i__7485__auto___20472 < len__7484__auto___20471)){
args__7491__auto__.push((arguments[i__7485__auto___20472]));

var G__20473 = (i__7485__auto___20472 + (1));
i__7485__auto___20472 = G__20473;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__20468){
var map__20469 = p__20468;
var map__20469__$1 = ((((!((map__20469 == null)))?((((map__20469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20469):map__20469);
var oboe_headers = cljs.core.get.call(null,map__20469__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__20469,map__20469__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__20469,map__20469__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__20469,map__20469__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__20469,map__20469__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq20465){
var G__20466 = cljs.core.first.call(null,seq20465);
var seq20465__$1 = cljs.core.next.call(null,seq20465);
var G__20467 = cljs.core.first.call(null,seq20465__$1);
var seq20465__$2 = cljs.core.next.call(null,seq20465__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__20466,G__20467,seq20465__$2);
});

