// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__31479__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__31479 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__31480__i = 0, G__31480__a = new Array(arguments.length -  0);
while (G__31480__i < G__31480__a.length) {G__31480__a[G__31480__i] = arguments[G__31480__i + 0]; ++G__31480__i;}
  children = new cljs.core.IndexedSeq(G__31480__a,0);
} 
return G__31479__delegate.call(this,children);};
G__31479.cljs$lang$maxFixedArity = 0;
G__31479.cljs$lang$applyTo = (function (arglist__31481){
var children = cljs.core.seq(arglist__31481);
return G__31479__delegate(children);
});
G__31479.cljs$core$IFn$_invoke$arity$variadic = G__31479__delegate;
return G__31479;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__31490 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__31490) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__31491 = cljs.core._EQ_;
var expr__31492 = view;
if(cljs.core.truth_((function (){var G__31494 = cljs.core.cst$kw$map;
var G__31495 = expr__31492;
return (pred__31491.cljs$core$IFn$_invoke$arity$2 ? pred__31491.cljs$core$IFn$_invoke$arity$2(G__31494,G__31495) : pred__31491.call(null,G__31494,G__31495));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__31496 = cljs.core.cst$kw$table;
var G__31497 = expr__31492;
return (pred__31491.cljs$core$IFn$_invoke$arity$2 ? pred__31491.cljs$core$IFn$_invoke$arity$2(G__31496,G__31497) : pred__31491.call(null,G__31496,G__31497));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__31492)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$class,"pure-button btn-default",cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$class,"btn-close right",cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record31499 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record31499 = (function (cursor,owner,meta31500){
this.cursor = cursor;
this.owner = owner;
this.meta31500 = meta31500;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record31499.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31501,meta31500__$1){
var self__ = this;
var _31501__$1 = this;
return (new hatti.views.record.t_hatti$views$record31499(self__.cursor,self__.owner,meta31500__$1));
});

hatti.views.record.t_hatti$views$record31499.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31501){
var self__ = this;
var _31501__$1 = this;
return self__.meta31500;
});

hatti.views.record.t_hatti$views$record31499.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record31499.prototype.om$core$IRender$render$arity$1 = (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
var G__31504 = ({"id": "print-xls-report"});
return React.DOM.div(G__31504);
});

hatti.views.record.t_hatti$views$record31499.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta31500], null);
});

hatti.views.record.t_hatti$views$record31499.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record31499.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record31499";

hatti.views.record.t_hatti$views$record31499.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record31499");
});

hatti.views.record.__GT_t_hatti$views$record31499 = (function hatti$views$record$__GT_t_hatti$views$record31499(cursor__$1,owner__$1,meta31500){
return (new hatti.views.record.t_hatti$views$record31499(cursor__$1,owner__$1,meta31500));
});

}

return (new hatti.views.record.t_hatti$views$record31499(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$3(field,answer,lang);
var map__31507 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__31507__$1 = ((((!((map__31507 == null)))?((((map__31507.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31507.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31507):map__31507);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31507__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31507__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31507__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__31509__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__31509 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__31510__i = 0, G__31510__a = new Array(arguments.length -  0);
while (G__31510__i < G__31510__a.length) {G__31510__a[G__31510__i] = arguments[G__31510__i + 0]; ++G__31510__i;}
  tbody = new cljs.core.IndexedSeq(G__31510__a,0);
} 
return G__31509__delegate.call(this,tbody);};
G__31509.cljs$lang$maxFixedArity = 0;
G__31509.cljs$lang$applyTo = (function (arglist__31511){
var tbody = cljs.core.seq(arglist__31511);
return G__31509__delegate(tbody);
});
G__31509.cljs$core$IFn$_invoke$arity$variadic = G__31509__delegate;
return G__31509;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__31513,owner,p__31514){
var map__31515 = p__31513;
var map__31515__$1 = ((((!((map__31515 == null)))?((((map__31515.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31515.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31515):map__31515);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31515__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31515__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31515__$1,cljs.core.cst$kw$lang);
var map__31516 = p__31514;
var map__31516__$1 = ((((!((map__31516 == null)))?((((map__31516.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31516.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31516):map__31516);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31516__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record31519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record31519 = (function (p__31513,owner,p__31514,map__31515,data,repeat_field,lang,map__31516,view,meta31520){
this.p__31513 = p__31513;
this.owner = owner;
this.p__31514 = p__31514;
this.map__31515 = map__31515;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__31516 = map__31516;
this.view = view;
this.meta31520 = meta31520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record31519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (_31521,meta31520__$1){
var self__ = this;
var _31521__$1 = this;
return (new hatti.views.record.t_hatti$views$record31519(self__.p__31513,self__.owner,self__.p__31514,self__.map__31515,self__.data,self__.repeat_field,self__.lang,self__.map__31516,self__.view,meta31520__$1));
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

hatti.views.record.t_hatti$views$record31519.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (_31521){
var self__ = this;
var _31521__$1 = this;
return self__.meta31520;
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

hatti.views.record.t_hatti$views$record31519.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record31519.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

hatti.views.record.t_hatti$views$record31519.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record31519.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (_,p__31522){
var self__ = this;
var map__31523 = p__31522;
var map__31523__$1 = ((((!((map__31523 == null)))?((((map__31523.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31523.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31523):map__31523);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31523__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (p1__31512_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__31512_SHARP_);
});})(___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;
var map__31525 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__31525__$1 = ((((!((map__31525 == null)))?((((map__31525.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31525.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31525):map__31525);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31525__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31525__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31525__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function hatti$views$record$iter__31527(s__31528){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (){
var s__31528__$1 = s__31528;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31528__$1);
if(temp__4657__auto__){
var s__31528__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31528__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31528__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31530 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31529 = (0);
while(true){
if((i__31529 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31529);
cljs.core.chunk_append(b__31530,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__31546 = (i__31529 + (1));
i__31529 = G__31546;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31530),hatti$views$record$iter__31527(cljs.core.chunk_rest(s__31528__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31530),null);
}
} else {
var field = cljs.core.first(s__31528__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__31527(cljs.core.rest(s__31528__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
,null,null));
});})(collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;
var tbl = ((function (collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function() { 
var G__31547__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__31547 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__31548__i = 0, G__31548__a = new Array(arguments.length -  1);
while (G__31548__i < G__31548__a.length) {G__31548__a[G__31548__i] = arguments[G__31548__i + 1]; ++G__31548__i;}
  body = new cljs.core.IndexedSeq(G__31548__a,0);
} 
return G__31547__delegate.call(this,cls,body);};
G__31547.cljs$lang$maxFixedArity = 1;
G__31547.cljs$lang$applyTo = (function (arglist__31549){
var cls = cljs.core.first(arglist__31549);
var body = cljs.core.rest(arglist__31549);
return G__31547__delegate(cls,body);
});
G__31547.cljs$core$IFn$_invoke$arity$variadic = G__31547__delegate;
return G__31547;
})()
;})(collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__31533 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__31533) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function hatti$views$record$iter__31534(s__31535){
return (new cljs.core.LazySeq(null,((function (G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (){
var s__31535__$1 = s__31535;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31535__$1);
if(temp__4657__auto__){
var s__31535__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31535__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31535__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31537 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31536 = (0);
while(true){
if((i__31536 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31536);
cljs.core.chunk_append(b__31537,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__31551 = (i__31536 + (1));
i__31536 = G__31551;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31537),hatti$views$record$iter__31534(cljs.core.chunk_rest(s__31535__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31537),null);
}
} else {
var d = cljs.core.first(s__31535__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__31534(cljs.core.rest(s__31535__$2)));
}
} else {
return null;
}
break;
}
});})(G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
,null,null));
});})(G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function hatti$views$record$iter__31540(s__31541){
return (new cljs.core.LazySeq(null,((function (G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (){
var s__31541__$1 = s__31541;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31541__$1);
if(temp__4657__auto__){
var s__31541__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31541__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31541__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31543 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31542 = (0);
while(true){
if((i__31542 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31542);
cljs.core.chunk_append(b__31543,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__31552 = (i__31542 + (1));
i__31542 = G__31552;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31543),hatti$views$record$iter__31540(cljs.core.chunk_rest(s__31541__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31543),null);
}
} else {
var d = cljs.core.first(s__31541__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__31540(cljs.core.rest(s__31541__$2)));
}
} else {
return null;
}
break;
}
});})(G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
,null,null));
});})(G__31533,collapse_BANG_,map__31525,map__31525__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__31523,map__31523__$1,collapsed_QMARK_,map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

hatti.views.record.t_hatti$views$record31519.getBasis = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__31513,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__31514,cljs.core.cst$sym$map__31515,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__31516,cljs.core.cst$sym$view,cljs.core.cst$sym$meta31520], null);
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

hatti.views.record.t_hatti$views$record31519.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record31519.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record31519";

hatti.views.record.t_hatti$views$record31519.cljs$lang$ctorPrWriter = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record31519");
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record31519 = ((function (map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record31519(p__31513__$1,owner__$1,p__31514__$1,map__31515__$2,data__$1,repeat_field__$1,lang__$1,map__31516__$2,view__$1,meta31520){
return (new hatti.views.record.t_hatti$views$record31519(p__31513__$1,owner__$1,p__31514__$1,map__31515__$2,data__$1,repeat_field__$1,lang__$1,map__31516__$2,view__$1,meta31520));
});})(map__31515,map__31515__$1,data,repeat_field,lang,map__31516,map__31516__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record31519(p__31513,owner,p__31514,map__31515__$1,data,repeat_field,lang,map__31516__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__31553){
var map__31556 = p__31553;
var map__31556__$1 = ((((!((map__31556 == null)))?((((map__31556.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31556.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31556):map__31556);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31556__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31556__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__31558){
var map__31559 = p__31558;
var map__31559__$1 = ((((!((map__31559 == null)))?((((map__31559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31559):map__31559);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31559__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record31561 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record31561 = (function (instance_id,owner,p__31558,map__31559,delete_record_BANG_,meta31562){
this.instance_id = instance_id;
this.owner = owner;
this.p__31558 = p__31558;
this.map__31559 = map__31559;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta31562 = meta31562;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record31561.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__31559,map__31559__$1,delete_record_BANG_){
return (function (_31563,meta31562__$1){
var self__ = this;
var _31563__$1 = this;
return (new hatti.views.record.t_hatti$views$record31561(self__.instance_id,self__.owner,self__.p__31558,self__.map__31559,self__.delete_record_BANG_,meta31562__$1));
});})(map__31559,map__31559__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record31561.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__31559,map__31559__$1,delete_record_BANG_){
return (function (_31563){
var self__ = this;
var _31563__$1 = this;
return self__.meta31562;
});})(map__31559,map__31559__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record31561.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record31561.prototype.om$core$IRender$render$arity$1 = ((function (map__31559,map__31559__$1,delete_record_BANG_){
return (function (this__16392__auto__){
var self__ = this;
var this__16392__auto____$1 = this;
return null;
});})(map__31559,map__31559__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record31561.getBasis = ((function (map__31559,map__31559__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__31558,cljs.core.cst$sym$map__31559,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta31562], null);
});})(map__31559,map__31559__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record31561.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record31561.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record31561";

hatti.views.record.t_hatti$views$record31561.cljs$lang$ctorPrWriter = ((function (map__31559,map__31559__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record31561");
});})(map__31559,map__31559__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record31561 = ((function (map__31559,map__31559__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record31561(instance_id__$1,owner__$1,p__31558__$1,map__31559__$2,delete_record_BANG___$1,meta31562){
return (new hatti.views.record.t_hatti$views$record31561(instance_id__$1,owner__$1,p__31558__$1,map__31559__$2,delete_record_BANG___$1,meta31562));
});})(map__31559,map__31559__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record31561(instance_id,owner,p__31558,map__31559__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__31564){
var map__31565 = p__31564;
var map__31565__$1 = ((((!((map__31565 == null)))?((((map__31565.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31565.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31565):map__31565);
var opts = map__31565__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31565__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record31567 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record31567 = (function (cursor,owner,p__31564,map__31565,opts,view,meta31568){
this.cursor = cursor;
this.owner = owner;
this.p__31564 = p__31564;
this.map__31565 = map__31565;
this.opts = opts;
this.view = view;
this.meta31568 = meta31568;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record31567.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__31565,map__31565__$1,opts,view){
return (function (_31569,meta31568__$1){
var self__ = this;
var _31569__$1 = this;
return (new hatti.views.record.t_hatti$views$record31567(self__.cursor,self__.owner,self__.p__31564,self__.map__31565,self__.opts,self__.view,meta31568__$1));
});})(map__31565,map__31565__$1,opts,view))
;

hatti.views.record.t_hatti$views$record31567.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__31565,map__31565__$1,opts,view){
return (function (_31569){
var self__ = this;
var _31569__$1 = this;
return self__.meta31568;
});})(map__31565,map__31565__$1,opts,view))
;

hatti.views.record.t_hatti$views$record31567.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record31567.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__31565,map__31565__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__31565,map__31565__$1,opts,view))
;

hatti.views.record.t_hatti$views$record31567.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record31567.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__31565,map__31565__$1,opts,view){
return (function (_,p__31570){
var self__ = this;
var map__31571 = p__31570;
var map__31571__$1 = ((((!((map__31571 == null)))?((((map__31571.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31571.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31571):map__31571);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31571__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__31573 = self__.cursor;
var map__31573__$1 = ((((!((map__31573 == null)))?((((map__31573.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31573.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31573):map__31573);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31573__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31573__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31573__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__31576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__31576);
})();
var map__31574 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__31574__$1 = ((((!((map__31574 == null)))?((((map__31574.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31574.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31574):map__31574);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31574__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31574__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31574__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31574__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31574__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31574__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__31578 = (function (){var G__31580 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__31581 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__31582 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__31583 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__31580,G__31581,G__31582,G__31583) : topbar_wrap.call(null,G__31580,G__31581,G__31582,G__31583));
})();
var G__31579 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__31584 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("Submission "),cljs.core.str(cur_rank)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__31585 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,[cljs.core.str("Record ID: "),cljs.core.str(instance_id)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__31584,G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__31584,G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__31584,G__31585) : header_wrap.call(null,G__31584,G__31585));
})(),(function (){var G__31586 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__31588 = (function (){var iter__7189__auto__ = ((function (G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view){
return (function hatti$views$record$iter__31589(s__31590){
return (new cljs.core.LazySeq(null,((function (G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view){
return (function (){
var s__31590__$1 = s__31590;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31590__$1);
if(temp__4657__auto__){
var s__31590__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31590__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31590__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31592 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31591 = (0);
while(true){
if((i__31591 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31591);
cljs.core.chunk_append(b__31592,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__31602 = (i__31591 + (1));
i__31591 = G__31602;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31592),hatti$views$record$iter__31589(cljs.core.chunk_rest(s__31590__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31592),null);
}
} else {
var q = cljs.core.first(s__31590__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__31589(cljs.core.rest(s__31590__$2)));
}
} else {
return null;
}
break;
}
});})(G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view))
,null,null));
});})(G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__31588) : section_wrap.call(null,G__31588));
})():null);
var G__31587 = (function (){var G__31595 = (function (){var iter__7189__auto__ = ((function (G__31586,G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view){
return (function hatti$views$record$iter__31596(s__31597){
return (new cljs.core.LazySeq(null,((function (G__31586,G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view){
return (function (){
var s__31597__$1 = s__31597;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31597__$1);
if(temp__4657__auto__){
var s__31597__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31597__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31597__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31599 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31598 = (0);
while(true){
if((i__31598 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31598);
cljs.core.chunk_append(b__31599,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__31603 = (i__31598 + (1));
i__31598 = G__31603;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31599),hatti$views$record$iter__31596(cljs.core.chunk_rest(s__31597__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31599),null);
}
} else {
var q = cljs.core.first(s__31597__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__31596(cljs.core.rest(s__31597__$2)));
}
} else {
return null;
}
break;
}
});})(G__31586,G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view))
,null,null));
});})(G__31586,G__31578,form,language,map__31573,map__31573__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__31574,map__31574__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__31571,map__31571__$1,expand_meta_QMARK_,map__31565,map__31565__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__31595) : section_wrap.call(null,G__31595));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__31586,G__31587) : submission_info_wrap.call(null,G__31586,G__31587));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__31578,G__31579) : top_level_wrap.call(null,G__31578,G__31579));
})():null));
});})(map__31565,map__31565__$1,opts,view))
;

hatti.views.record.t_hatti$views$record31567.getBasis = ((function (map__31565,map__31565__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__31564,cljs.core.cst$sym$map__31565,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta31568], null);
});})(map__31565,map__31565__$1,opts,view))
;

hatti.views.record.t_hatti$views$record31567.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record31567.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record31567";

hatti.views.record.t_hatti$views$record31567.cljs$lang$ctorPrWriter = ((function (map__31565,map__31565__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record31567");
});})(map__31565,map__31565__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record31567 = ((function (map__31565,map__31565__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record31567(cursor__$1,owner__$1,p__31564__$1,map__31565__$2,opts__$1,view__$1,meta31568){
return (new hatti.views.record.t_hatti$views$record31567(cursor__$1,owner__$1,p__31564__$1,map__31565__$2,opts__$1,view__$1,meta31568));
});})(map__31565,map__31565__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record31567(cursor,owner,p__31564,map__31565__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
