// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__17814__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__17811 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__17812 = cljs.core.seq.call(null,vec__17811);
var first__17813 = cljs.core.first.call(null,seq__17812);
var seq__17812__$1 = cljs.core.next.call(null,seq__17812);
var tag = first__17813;
var body = seq__17812__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__17814 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17815__i = 0, G__17815__a = new Array(arguments.length -  0);
while (G__17815__i < G__17815__a.length) {G__17815__a[G__17815__i] = arguments[G__17815__i + 0]; ++G__17815__i;}
  args = new cljs.core.IndexedSeq(G__17815__a,0);
} 
return G__17814__delegate.call(this,args);};
G__17814.cljs$lang$maxFixedArity = 0;
G__17814.cljs$lang$applyTo = (function (arglist__17816){
var args = cljs.core.seq(arglist__17816);
return G__17814__delegate(args);
});
G__17814.cljs$core$IFn$_invoke$arity$variadic = G__17814__delegate;
return G__17814;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__17821(s__17822){
return (new cljs.core.LazySeq(null,(function (){
var s__17822__$1 = s__17822;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17822__$1);
if(temp__4657__auto__){
var s__17822__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17822__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__17822__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__17824 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__17823 = (0);
while(true){
if((i__17823 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__17823);
cljs.core.chunk_append.call(null,b__17824,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__17825 = (i__17823 + (1));
i__17823 = G__17825;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17824),sablono$core$update_arglists_$_iter__17821.call(null,cljs.core.chunk_rest.call(null,s__17822__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17824),null);
}
} else {
var args = cljs.core.first.call(null,s__17822__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__17821.call(null,cljs.core.rest.call(null,s__17822__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17831 = arguments.length;
var i__7485__auto___17832 = (0);
while(true){
if((i__7485__auto___17832 < len__7484__auto___17831)){
args__7491__auto__.push((arguments[i__7485__auto___17832]));

var G__17833 = (i__7485__auto___17832 + (1));
i__7485__auto___17832 = G__17833;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__17827(s__17828){
return (new cljs.core.LazySeq(null,(function (){
var s__17828__$1 = s__17828;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17828__$1);
if(temp__4657__auto__){
var s__17828__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17828__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__17828__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__17830 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__17829 = (0);
while(true){
if((i__17829 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__17829);
cljs.core.chunk_append.call(null,b__17830,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__17834 = (i__17829 + (1));
i__17829 = G__17834;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17830),sablono$core$iter__17827.call(null,cljs.core.chunk_rest.call(null,s__17828__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17830),null);
}
} else {
var style = cljs.core.first.call(null,s__17828__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__17827.call(null,cljs.core.rest.call(null,s__17828__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq17826){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17826));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to17835 = (function sablono$core$link_to17835(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17838 = arguments.length;
var i__7485__auto___17839 = (0);
while(true){
if((i__7485__auto___17839 < len__7484__auto___17838)){
args__7491__auto__.push((arguments[i__7485__auto___17839]));

var G__17840 = (i__7485__auto___17839 + (1));
i__7485__auto___17839 = G__17840;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to17835.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to17835.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to17835.cljs$lang$maxFixedArity = (1);

sablono.core.link_to17835.cljs$lang$applyTo = (function (seq17836){
var G__17837 = cljs.core.first.call(null,seq17836);
var seq17836__$1 = cljs.core.next.call(null,seq17836);
return sablono.core.link_to17835.cljs$core$IFn$_invoke$arity$variadic(G__17837,seq17836__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to17835);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to17841 = (function sablono$core$mail_to17841(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17848 = arguments.length;
var i__7485__auto___17849 = (0);
while(true){
if((i__7485__auto___17849 < len__7484__auto___17848)){
args__7491__auto__.push((arguments[i__7485__auto___17849]));

var G__17850 = (i__7485__auto___17849 + (1));
i__7485__auto___17849 = G__17850;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to17841.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to17841.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__17844){
var vec__17845 = p__17844;
var content = cljs.core.nth.call(null,vec__17845,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to17841.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to17841.cljs$lang$applyTo = (function (seq17842){
var G__17843 = cljs.core.first.call(null,seq17842);
var seq17842__$1 = cljs.core.next.call(null,seq17842);
return sablono.core.mail_to17841.cljs$core$IFn$_invoke$arity$variadic(G__17843,seq17842__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to17841);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list17851 = (function sablono$core$unordered_list17851(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list17851_$_iter__17856(s__17857){
return (new cljs.core.LazySeq(null,(function (){
var s__17857__$1 = s__17857;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17857__$1);
if(temp__4657__auto__){
var s__17857__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17857__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__17857__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__17859 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__17858 = (0);
while(true){
if((i__17858 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__17858);
cljs.core.chunk_append.call(null,b__17859,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__17860 = (i__17858 + (1));
i__17858 = G__17860;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17859),sablono$core$unordered_list17851_$_iter__17856.call(null,cljs.core.chunk_rest.call(null,s__17857__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17859),null);
}
} else {
var x = cljs.core.first.call(null,s__17857__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list17851_$_iter__17856.call(null,cljs.core.rest.call(null,s__17857__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list17851);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list17861 = (function sablono$core$ordered_list17861(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list17861_$_iter__17866(s__17867){
return (new cljs.core.LazySeq(null,(function (){
var s__17867__$1 = s__17867;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__17867__$1);
if(temp__4657__auto__){
var s__17867__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17867__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__17867__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__17869 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__17868 = (0);
while(true){
if((i__17868 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__17868);
cljs.core.chunk_append.call(null,b__17869,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__17870 = (i__17868 + (1));
i__17868 = G__17870;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17869),sablono$core$ordered_list17861_$_iter__17866.call(null,cljs.core.chunk_rest.call(null,s__17867__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17869),null);
}
} else {
var x = cljs.core.first.call(null,s__17867__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list17861_$_iter__17866.call(null,cljs.core.rest.call(null,s__17867__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list17861);
/**
 * Create an image element.
 */
sablono.core.image17871 = (function sablono$core$image17871(var_args){
var args17872 = [];
var len__7484__auto___17875 = arguments.length;
var i__7485__auto___17876 = (0);
while(true){
if((i__7485__auto___17876 < len__7484__auto___17875)){
args17872.push((arguments[i__7485__auto___17876]));

var G__17877 = (i__7485__auto___17876 + (1));
i__7485__auto___17876 = G__17877;
continue;
} else {
}
break;
}

var G__17874 = args17872.length;
switch (G__17874) {
case 1:
return sablono.core.image17871.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image17871.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17872.length)].join('')));

}
});

sablono.core.image17871.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image17871.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image17871.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image17871);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__17879_SHARP_,p2__17880_SHARP_){
return [cljs.core.str(p1__17879_SHARP_),cljs.core.str("["),cljs.core.str(p2__17880_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__17881_SHARP_,p2__17882_SHARP_){
return [cljs.core.str(p1__17881_SHARP_),cljs.core.str("-"),cljs.core.str(p2__17882_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field17883 = (function sablono$core$color_field17883(var_args){
var args17884 = [];
var len__7484__auto___17951 = arguments.length;
var i__7485__auto___17952 = (0);
while(true){
if((i__7485__auto___17952 < len__7484__auto___17951)){
args17884.push((arguments[i__7485__auto___17952]));

var G__17953 = (i__7485__auto___17952 + (1));
i__7485__auto___17952 = G__17953;
continue;
} else {
}
break;
}

var G__17886 = args17884.length;
switch (G__17886) {
case 1:
return sablono.core.color_field17883.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field17883.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17884.length)].join('')));

}
});

sablono.core.color_field17883.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.color_field17883.call(null,name__17728__auto__,null);
});

sablono.core.color_field17883.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.color_field17883.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field17883);

/**
 * Creates a date input field.
 */
sablono.core.date_field17887 = (function sablono$core$date_field17887(var_args){
var args17888 = [];
var len__7484__auto___17955 = arguments.length;
var i__7485__auto___17956 = (0);
while(true){
if((i__7485__auto___17956 < len__7484__auto___17955)){
args17888.push((arguments[i__7485__auto___17956]));

var G__17957 = (i__7485__auto___17956 + (1));
i__7485__auto___17956 = G__17957;
continue;
} else {
}
break;
}

var G__17890 = args17888.length;
switch (G__17890) {
case 1:
return sablono.core.date_field17887.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field17887.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17888.length)].join('')));

}
});

sablono.core.date_field17887.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.date_field17887.call(null,name__17728__auto__,null);
});

sablono.core.date_field17887.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.date_field17887.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field17887);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field17891 = (function sablono$core$datetime_field17891(var_args){
var args17892 = [];
var len__7484__auto___17959 = arguments.length;
var i__7485__auto___17960 = (0);
while(true){
if((i__7485__auto___17960 < len__7484__auto___17959)){
args17892.push((arguments[i__7485__auto___17960]));

var G__17961 = (i__7485__auto___17960 + (1));
i__7485__auto___17960 = G__17961;
continue;
} else {
}
break;
}

var G__17894 = args17892.length;
switch (G__17894) {
case 1:
return sablono.core.datetime_field17891.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field17891.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17892.length)].join('')));

}
});

sablono.core.datetime_field17891.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.datetime_field17891.call(null,name__17728__auto__,null);
});

sablono.core.datetime_field17891.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.datetime_field17891.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field17891);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field17895 = (function sablono$core$datetime_local_field17895(var_args){
var args17896 = [];
var len__7484__auto___17963 = arguments.length;
var i__7485__auto___17964 = (0);
while(true){
if((i__7485__auto___17964 < len__7484__auto___17963)){
args17896.push((arguments[i__7485__auto___17964]));

var G__17965 = (i__7485__auto___17964 + (1));
i__7485__auto___17964 = G__17965;
continue;
} else {
}
break;
}

var G__17898 = args17896.length;
switch (G__17898) {
case 1:
return sablono.core.datetime_local_field17895.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field17895.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17896.length)].join('')));

}
});

sablono.core.datetime_local_field17895.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.datetime_local_field17895.call(null,name__17728__auto__,null);
});

sablono.core.datetime_local_field17895.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.datetime_local_field17895.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field17895);

/**
 * Creates a email input field.
 */
sablono.core.email_field17899 = (function sablono$core$email_field17899(var_args){
var args17900 = [];
var len__7484__auto___17967 = arguments.length;
var i__7485__auto___17968 = (0);
while(true){
if((i__7485__auto___17968 < len__7484__auto___17967)){
args17900.push((arguments[i__7485__auto___17968]));

var G__17969 = (i__7485__auto___17968 + (1));
i__7485__auto___17968 = G__17969;
continue;
} else {
}
break;
}

var G__17902 = args17900.length;
switch (G__17902) {
case 1:
return sablono.core.email_field17899.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field17899.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17900.length)].join('')));

}
});

sablono.core.email_field17899.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.email_field17899.call(null,name__17728__auto__,null);
});

sablono.core.email_field17899.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.email_field17899.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field17899);

/**
 * Creates a file input field.
 */
sablono.core.file_field17903 = (function sablono$core$file_field17903(var_args){
var args17904 = [];
var len__7484__auto___17971 = arguments.length;
var i__7485__auto___17972 = (0);
while(true){
if((i__7485__auto___17972 < len__7484__auto___17971)){
args17904.push((arguments[i__7485__auto___17972]));

var G__17973 = (i__7485__auto___17972 + (1));
i__7485__auto___17972 = G__17973;
continue;
} else {
}
break;
}

var G__17906 = args17904.length;
switch (G__17906) {
case 1:
return sablono.core.file_field17903.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field17903.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17904.length)].join('')));

}
});

sablono.core.file_field17903.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.file_field17903.call(null,name__17728__auto__,null);
});

sablono.core.file_field17903.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.file_field17903.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field17903);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field17907 = (function sablono$core$hidden_field17907(var_args){
var args17908 = [];
var len__7484__auto___17975 = arguments.length;
var i__7485__auto___17976 = (0);
while(true){
if((i__7485__auto___17976 < len__7484__auto___17975)){
args17908.push((arguments[i__7485__auto___17976]));

var G__17977 = (i__7485__auto___17976 + (1));
i__7485__auto___17976 = G__17977;
continue;
} else {
}
break;
}

var G__17910 = args17908.length;
switch (G__17910) {
case 1:
return sablono.core.hidden_field17907.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field17907.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17908.length)].join('')));

}
});

sablono.core.hidden_field17907.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.hidden_field17907.call(null,name__17728__auto__,null);
});

sablono.core.hidden_field17907.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.hidden_field17907.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field17907);

/**
 * Creates a month input field.
 */
sablono.core.month_field17911 = (function sablono$core$month_field17911(var_args){
var args17912 = [];
var len__7484__auto___17979 = arguments.length;
var i__7485__auto___17980 = (0);
while(true){
if((i__7485__auto___17980 < len__7484__auto___17979)){
args17912.push((arguments[i__7485__auto___17980]));

var G__17981 = (i__7485__auto___17980 + (1));
i__7485__auto___17980 = G__17981;
continue;
} else {
}
break;
}

var G__17914 = args17912.length;
switch (G__17914) {
case 1:
return sablono.core.month_field17911.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field17911.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17912.length)].join('')));

}
});

sablono.core.month_field17911.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.month_field17911.call(null,name__17728__auto__,null);
});

sablono.core.month_field17911.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.month_field17911.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field17911);

/**
 * Creates a number input field.
 */
sablono.core.number_field17915 = (function sablono$core$number_field17915(var_args){
var args17916 = [];
var len__7484__auto___17983 = arguments.length;
var i__7485__auto___17984 = (0);
while(true){
if((i__7485__auto___17984 < len__7484__auto___17983)){
args17916.push((arguments[i__7485__auto___17984]));

var G__17985 = (i__7485__auto___17984 + (1));
i__7485__auto___17984 = G__17985;
continue;
} else {
}
break;
}

var G__17918 = args17916.length;
switch (G__17918) {
case 1:
return sablono.core.number_field17915.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field17915.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17916.length)].join('')));

}
});

sablono.core.number_field17915.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.number_field17915.call(null,name__17728__auto__,null);
});

sablono.core.number_field17915.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.number_field17915.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field17915);

/**
 * Creates a password input field.
 */
sablono.core.password_field17919 = (function sablono$core$password_field17919(var_args){
var args17920 = [];
var len__7484__auto___17987 = arguments.length;
var i__7485__auto___17988 = (0);
while(true){
if((i__7485__auto___17988 < len__7484__auto___17987)){
args17920.push((arguments[i__7485__auto___17988]));

var G__17989 = (i__7485__auto___17988 + (1));
i__7485__auto___17988 = G__17989;
continue;
} else {
}
break;
}

var G__17922 = args17920.length;
switch (G__17922) {
case 1:
return sablono.core.password_field17919.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field17919.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17920.length)].join('')));

}
});

sablono.core.password_field17919.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.password_field17919.call(null,name__17728__auto__,null);
});

sablono.core.password_field17919.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.password_field17919.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field17919);

/**
 * Creates a range input field.
 */
sablono.core.range_field17923 = (function sablono$core$range_field17923(var_args){
var args17924 = [];
var len__7484__auto___17991 = arguments.length;
var i__7485__auto___17992 = (0);
while(true){
if((i__7485__auto___17992 < len__7484__auto___17991)){
args17924.push((arguments[i__7485__auto___17992]));

var G__17993 = (i__7485__auto___17992 + (1));
i__7485__auto___17992 = G__17993;
continue;
} else {
}
break;
}

var G__17926 = args17924.length;
switch (G__17926) {
case 1:
return sablono.core.range_field17923.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field17923.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17924.length)].join('')));

}
});

sablono.core.range_field17923.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.range_field17923.call(null,name__17728__auto__,null);
});

sablono.core.range_field17923.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.range_field17923.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field17923);

/**
 * Creates a search input field.
 */
sablono.core.search_field17927 = (function sablono$core$search_field17927(var_args){
var args17928 = [];
var len__7484__auto___17995 = arguments.length;
var i__7485__auto___17996 = (0);
while(true){
if((i__7485__auto___17996 < len__7484__auto___17995)){
args17928.push((arguments[i__7485__auto___17996]));

var G__17997 = (i__7485__auto___17996 + (1));
i__7485__auto___17996 = G__17997;
continue;
} else {
}
break;
}

var G__17930 = args17928.length;
switch (G__17930) {
case 1:
return sablono.core.search_field17927.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field17927.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17928.length)].join('')));

}
});

sablono.core.search_field17927.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.search_field17927.call(null,name__17728__auto__,null);
});

sablono.core.search_field17927.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.search_field17927.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field17927);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field17931 = (function sablono$core$tel_field17931(var_args){
var args17932 = [];
var len__7484__auto___17999 = arguments.length;
var i__7485__auto___18000 = (0);
while(true){
if((i__7485__auto___18000 < len__7484__auto___17999)){
args17932.push((arguments[i__7485__auto___18000]));

var G__18001 = (i__7485__auto___18000 + (1));
i__7485__auto___18000 = G__18001;
continue;
} else {
}
break;
}

var G__17934 = args17932.length;
switch (G__17934) {
case 1:
return sablono.core.tel_field17931.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field17931.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17932.length)].join('')));

}
});

sablono.core.tel_field17931.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.tel_field17931.call(null,name__17728__auto__,null);
});

sablono.core.tel_field17931.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.tel_field17931.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field17931);

/**
 * Creates a text input field.
 */
sablono.core.text_field17935 = (function sablono$core$text_field17935(var_args){
var args17936 = [];
var len__7484__auto___18003 = arguments.length;
var i__7485__auto___18004 = (0);
while(true){
if((i__7485__auto___18004 < len__7484__auto___18003)){
args17936.push((arguments[i__7485__auto___18004]));

var G__18005 = (i__7485__auto___18004 + (1));
i__7485__auto___18004 = G__18005;
continue;
} else {
}
break;
}

var G__17938 = args17936.length;
switch (G__17938) {
case 1:
return sablono.core.text_field17935.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field17935.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17936.length)].join('')));

}
});

sablono.core.text_field17935.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.text_field17935.call(null,name__17728__auto__,null);
});

sablono.core.text_field17935.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.text_field17935.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field17935);

/**
 * Creates a time input field.
 */
sablono.core.time_field17939 = (function sablono$core$time_field17939(var_args){
var args17940 = [];
var len__7484__auto___18007 = arguments.length;
var i__7485__auto___18008 = (0);
while(true){
if((i__7485__auto___18008 < len__7484__auto___18007)){
args17940.push((arguments[i__7485__auto___18008]));

var G__18009 = (i__7485__auto___18008 + (1));
i__7485__auto___18008 = G__18009;
continue;
} else {
}
break;
}

var G__17942 = args17940.length;
switch (G__17942) {
case 1:
return sablono.core.time_field17939.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field17939.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17940.length)].join('')));

}
});

sablono.core.time_field17939.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.time_field17939.call(null,name__17728__auto__,null);
});

sablono.core.time_field17939.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.time_field17939.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field17939);

/**
 * Creates a url input field.
 */
sablono.core.url_field17943 = (function sablono$core$url_field17943(var_args){
var args17944 = [];
var len__7484__auto___18011 = arguments.length;
var i__7485__auto___18012 = (0);
while(true){
if((i__7485__auto___18012 < len__7484__auto___18011)){
args17944.push((arguments[i__7485__auto___18012]));

var G__18013 = (i__7485__auto___18012 + (1));
i__7485__auto___18012 = G__18013;
continue;
} else {
}
break;
}

var G__17946 = args17944.length;
switch (G__17946) {
case 1:
return sablono.core.url_field17943.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field17943.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17944.length)].join('')));

}
});

sablono.core.url_field17943.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.url_field17943.call(null,name__17728__auto__,null);
});

sablono.core.url_field17943.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.url_field17943.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field17943);

/**
 * Creates a week input field.
 */
sablono.core.week_field17947 = (function sablono$core$week_field17947(var_args){
var args17948 = [];
var len__7484__auto___18015 = arguments.length;
var i__7485__auto___18016 = (0);
while(true){
if((i__7485__auto___18016 < len__7484__auto___18015)){
args17948.push((arguments[i__7485__auto___18016]));

var G__18017 = (i__7485__auto___18016 + (1));
i__7485__auto___18016 = G__18017;
continue;
} else {
}
break;
}

var G__17950 = args17948.length;
switch (G__17950) {
case 1:
return sablono.core.week_field17947.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field17947.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17948.length)].join('')));

}
});

sablono.core.week_field17947.cljs$core$IFn$_invoke$arity$1 = (function (name__17728__auto__){
return sablono.core.week_field17947.call(null,name__17728__auto__,null);
});

sablono.core.week_field17947.cljs$core$IFn$_invoke$arity$2 = (function (name__17728__auto__,value__17729__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__17728__auto__,value__17729__auto__);
});

sablono.core.week_field17947.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field17947);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box18019 = (function sablono$core$check_box18019(var_args){
var args18020 = [];
var len__7484__auto___18023 = arguments.length;
var i__7485__auto___18024 = (0);
while(true){
if((i__7485__auto___18024 < len__7484__auto___18023)){
args18020.push((arguments[i__7485__auto___18024]));

var G__18025 = (i__7485__auto___18024 + (1));
i__7485__auto___18024 = G__18025;
continue;
} else {
}
break;
}

var G__18022 = args18020.length;
switch (G__18022) {
case 1:
return sablono.core.check_box18019.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box18019.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box18019.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18020.length)].join('')));

}
});

sablono.core.check_box18019.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box18019.call(null,name,null);
});

sablono.core.check_box18019.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box18019.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box18019.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box18019.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box18019);
/**
 * Creates a radio button.
 */
sablono.core.radio_button18027 = (function sablono$core$radio_button18027(var_args){
var args18028 = [];
var len__7484__auto___18031 = arguments.length;
var i__7485__auto___18032 = (0);
while(true){
if((i__7485__auto___18032 < len__7484__auto___18031)){
args18028.push((arguments[i__7485__auto___18032]));

var G__18033 = (i__7485__auto___18032 + (1));
i__7485__auto___18032 = G__18033;
continue;
} else {
}
break;
}

var G__18030 = args18028.length;
switch (G__18030) {
case 1:
return sablono.core.radio_button18027.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button18027.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button18027.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18028.length)].join('')));

}
});

sablono.core.radio_button18027.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button18027.call(null,group,null);
});

sablono.core.radio_button18027.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button18027.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button18027.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button18027.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button18027);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options18035 = (function sablono$core$select_options18035(var_args){
var args18036 = [];
var len__7484__auto___18055 = arguments.length;
var i__7485__auto___18056 = (0);
while(true){
if((i__7485__auto___18056 < len__7484__auto___18055)){
args18036.push((arguments[i__7485__auto___18056]));

var G__18057 = (i__7485__auto___18056 + (1));
i__7485__auto___18056 = G__18057;
continue;
} else {
}
break;
}

var G__18038 = args18036.length;
switch (G__18038) {
case 1:
return sablono.core.select_options18035.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options18035.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18036.length)].join('')));

}
});

sablono.core.select_options18035.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options18035.call(null,coll,null);
});

sablono.core.select_options18035.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__18039(s__18040){
return (new cljs.core.LazySeq(null,(function (){
var s__18040__$1 = s__18040;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__18040__$1);
if(temp__4657__auto__){
var s__18040__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18040__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__18040__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__18042 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__18041 = (0);
while(true){
if((i__18041 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__18041);
cljs.core.chunk_append.call(null,b__18042,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__18049 = x;
var text = cljs.core.nth.call(null,vec__18049,(0),null);
var val = cljs.core.nth.call(null,vec__18049,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__18049,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options18035.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__18059 = (i__18041 + (1));
i__18041 = G__18059;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18042),sablono$core$iter__18039.call(null,cljs.core.chunk_rest.call(null,s__18040__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18042),null);
}
} else {
var x = cljs.core.first.call(null,s__18040__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__18052 = x;
var text = cljs.core.nth.call(null,vec__18052,(0),null);
var val = cljs.core.nth.call(null,vec__18052,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__18052,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options18035.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__18039.call(null,cljs.core.rest.call(null,s__18040__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options18035.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options18035);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down18060 = (function sablono$core$drop_down18060(var_args){
var args18061 = [];
var len__7484__auto___18064 = arguments.length;
var i__7485__auto___18065 = (0);
while(true){
if((i__7485__auto___18065 < len__7484__auto___18064)){
args18061.push((arguments[i__7485__auto___18065]));

var G__18066 = (i__7485__auto___18065 + (1));
i__7485__auto___18065 = G__18066;
continue;
} else {
}
break;
}

var G__18063 = args18061.length;
switch (G__18063) {
case 2:
return sablono.core.drop_down18060.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down18060.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18061.length)].join('')));

}
});

sablono.core.drop_down18060.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down18060.call(null,name,options,null);
});

sablono.core.drop_down18060.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down18060.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down18060);
/**
 * Creates a text area element.
 */
sablono.core.text_area18068 = (function sablono$core$text_area18068(var_args){
var args18069 = [];
var len__7484__auto___18072 = arguments.length;
var i__7485__auto___18073 = (0);
while(true){
if((i__7485__auto___18073 < len__7484__auto___18072)){
args18069.push((arguments[i__7485__auto___18073]));

var G__18074 = (i__7485__auto___18073 + (1));
i__7485__auto___18073 = G__18074;
continue;
} else {
}
break;
}

var G__18071 = args18069.length;
switch (G__18071) {
case 1:
return sablono.core.text_area18068.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area18068.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18069.length)].join('')));

}
});

sablono.core.text_area18068.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area18068.call(null,name,null);
});

sablono.core.text_area18068.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area18068.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area18068);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label18076 = (function sablono$core$label18076(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label18076);
/**
 * Creates a submit button.
 */
sablono.core.submit_button18077 = (function sablono$core$submit_button18077(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button18077);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button18078 = (function sablono$core$reset_button18078(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button18078);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to18079 = (function sablono$core$form_to18079(var_args){
var args__7491__auto__ = [];
var len__7484__auto___18086 = arguments.length;
var i__7485__auto___18087 = (0);
while(true){
if((i__7485__auto___18087 < len__7484__auto___18086)){
args__7491__auto__.push((arguments[i__7485__auto___18087]));

var G__18088 = (i__7485__auto___18087 + (1));
i__7485__auto___18087 = G__18088;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to18079.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to18079.cljs$core$IFn$_invoke$arity$variadic = (function (p__18082,body){
var vec__18083 = p__18082;
var method = cljs.core.nth.call(null,vec__18083,(0),null);
var action = cljs.core.nth.call(null,vec__18083,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to18079.cljs$lang$maxFixedArity = (1);

sablono.core.form_to18079.cljs$lang$applyTo = (function (seq18080){
var G__18081 = cljs.core.first.call(null,seq18080);
var seq18080__$1 = cljs.core.next.call(null,seq18080);
return sablono.core.form_to18079.cljs$core$IFn$_invoke$arity$variadic(G__18081,seq18080__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to18079);
