// Compiled by ClojureScript 1.9.229 {}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.call(null,"null",s);
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement.call(null,chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case.call(null,str);
} else {
return null;
}
});
/**
 * True if substring is a substring of string
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___15095 = arguments.length;
var i__7485__auto___15096 = (0);
while(true){
if((i__7485__auto___15096 < len__7484__auto___15095)){
args__7491__auto__.push((arguments[i__7485__auto___15096]));

var G__15097 = (i__7485__auto___15096 + (1));
i__7485__auto___15096 = G__15097;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,string,p__15092){
var map__15093 = p__15092;
var map__15093__$1 = ((((!((map__15093 == null)))?((((map__15093.cljs$lang$protocol_mask$partition0$ & (64))) || (map__15093.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15093):map__15093);
var case_sensitive_QMARK_ = cljs.core.get.call(null,map__15093__$1,new cljs.core.Keyword(null,"case-sensitive?","case-sensitive?",-2133754107),true);
if(cljs.core.truth_((function (){var or__6409__auto__ = cljs.core.empty_QMARK_.call(null,string);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return chimera.string.is_null_QMARK_.call(null,string);
}
})())){
return false;
} else {
return chimera.core.not_nil_QMARK_.call(null,cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),string));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq15089){
var G__15090 = cljs.core.first.call(null,seq15089);
var seq15089__$1 = cljs.core.next.call(null,seq15089);
var G__15091 = cljs.core.first.call(null,seq15089__$1);
var seq15089__$2 = cljs.core.next.call(null,seq15089__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__15090,G__15091,seq15089__$2);
});

