// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__40869__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__40869 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__40870__i = 0, G__40870__a = new Array(arguments.length -  0);
while (G__40870__i < G__40870__a.length) {G__40870__a[G__40870__i] = arguments[G__40870__i + 0]; ++G__40870__i;}
  children = new cljs.core.IndexedSeq(G__40870__a,0);
} 
return G__40869__delegate.call(this,children);};
G__40869.cljs$lang$maxFixedArity = 0;
G__40869.cljs$lang$applyTo = (function (arglist__40871){
var children = cljs.core.seq(arglist__40871);
return G__40869__delegate(children);
});
G__40869.cljs$core$IFn$_invoke$arity$variadic = G__40869__delegate;
return G__40869;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__40880 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__40880) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__40881 = cljs.core._EQ_;
var expr__40882 = view;
if(cljs.core.truth_((function (){var G__40884 = cljs.core.cst$kw$map;
var G__40885 = expr__40882;
return (pred__40881.cljs$core$IFn$_invoke$arity$2 ? pred__40881.cljs$core$IFn$_invoke$arity$2(G__40884,G__40885) : pred__40881.call(null,G__40884,G__40885));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__40886 = cljs.core.cst$kw$table;
var G__40887 = expr__40882;
return (pred__40881.cljs$core$IFn$_invoke$arity$2 ? pred__40881.cljs$core$IFn$_invoke$arity$2(G__40886,G__40887) : pred__40881.call(null,G__40886,G__40887));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__40882)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$pure_DASH_button$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$btn_DASH_close$right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record40889 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40889 = (function (cursor,owner,meta40890){
this.cursor = cursor;
this.owner = owner;
this.meta40890 = meta40890;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40889.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40891,meta40890__$1){
var self__ = this;
var _40891__$1 = this;
return (new hatti.views.record.t_hatti$views$record40889(self__.cursor,self__.owner,meta40890__$1));
});

hatti.views.record.t_hatti$views$record40889.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40891){
var self__ = this;
var _40891__$1 = this;
return self__.meta40890;
});

hatti.views.record.t_hatti$views$record40889.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record40889.prototype.om$core$IRender$render$arity$1 = (function (this__18114__auto__){
var self__ = this;
var this__18114__auto____$1 = this;
var G__40894 = ({"id": "print-xls-report"});
return React.DOM.div(G__40894);
});

hatti.views.record.t_hatti$views$record40889.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40890], null);
});

hatti.views.record.t_hatti$views$record40889.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40889.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40889";

hatti.views.record.t_hatti$views$record40889.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40889");
});

hatti.views.record.__GT_t_hatti$views$record40889 = (function hatti$views$record$__GT_t_hatti$views$record40889(cursor__$1,owner__$1,meta40890){
return (new hatti.views.record.t_hatti$views$record40889(cursor__$1,owner__$1,meta40890));
});

}

return (new hatti.views.record.t_hatti$views$record40889(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,answer,cljs.core.array_seq([cljs.core.cst$kw$language,lang], 0));
var map__40897 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__40897__$1 = ((((!((map__40897 == null)))?((((map__40897.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40897.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40897):map__40897);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40897__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40897__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40897__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__40899__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__40899 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__40900__i = 0, G__40900__a = new Array(arguments.length -  0);
while (G__40900__i < G__40900__a.length) {G__40900__a[G__40900__i] = arguments[G__40900__i + 0]; ++G__40900__i;}
  tbody = new cljs.core.IndexedSeq(G__40900__a,0);
} 
return G__40899__delegate.call(this,tbody);};
G__40899.cljs$lang$maxFixedArity = 0;
G__40899.cljs$lang$applyTo = (function (arglist__40901){
var tbody = cljs.core.seq(arglist__40901);
return G__40899__delegate(tbody);
});
G__40899.cljs$core$IFn$_invoke$arity$variadic = G__40899__delegate;
return G__40899;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__40903,owner,p__40904){
var map__40905 = p__40903;
var map__40905__$1 = ((((!((map__40905 == null)))?((((map__40905.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40905.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40905):map__40905);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40905__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40905__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40905__$1,cljs.core.cst$kw$lang);
var map__40906 = p__40904;
var map__40906__$1 = ((((!((map__40906 == null)))?((((map__40906.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40906.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40906):map__40906);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40906__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record40909 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40909 = (function (p__40903,owner,p__40904,map__40905,data,repeat_field,lang,map__40906,view,meta40910){
this.p__40903 = p__40903;
this.owner = owner;
this.p__40904 = p__40904;
this.map__40905 = map__40905;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__40906 = map__40906;
this.view = view;
this.meta40910 = meta40910;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40909.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (_40911,meta40910__$1){
var self__ = this;
var _40911__$1 = this;
return (new hatti.views.record.t_hatti$views$record40909(self__.p__40903,self__.owner,self__.p__40904,self__.map__40905,self__.data,self__.repeat_field,self__.lang,self__.map__40906,self__.view,meta40910__$1));
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

hatti.views.record.t_hatti$views$record40909.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (_40911){
var self__ = this;
var _40911__$1 = this;
return self__.meta40910;
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

hatti.views.record.t_hatti$views$record40909.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record40909.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

hatti.views.record.t_hatti$views$record40909.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record40909.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (_,p__40912){
var self__ = this;
var map__40913 = p__40912;
var map__40913__$1 = ((((!((map__40913 == null)))?((((map__40913.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40913.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40913):map__40913);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40913__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (p1__40902_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__40902_SHARP_);
});})(___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;
var map__40915 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__40915__$1 = ((((!((map__40915 == null)))?((((map__40915.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40915.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40915):map__40915);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40915__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40915__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40915__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function hatti$views$record$iter__40917(s__40918){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (){
var s__40918__$1 = s__40918;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40918__$1);
if(temp__4657__auto__){
var s__40918__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40918__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40918__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40920 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40919 = (0);
while(true){
if((i__40919 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40919);
cljs.core.chunk_append(b__40920,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__40936 = (i__40919 + (1));
i__40919 = G__40936;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40920),hatti$views$record$iter__40917(cljs.core.chunk_rest(s__40918__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40920),null);
}
} else {
var field = cljs.core.first(s__40918__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__40917(cljs.core.rest(s__40918__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
,null,null));
});})(collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;
var tbl = ((function (collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function() { 
var G__40937__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__40937 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__40938__i = 0, G__40938__a = new Array(arguments.length -  1);
while (G__40938__i < G__40938__a.length) {G__40938__a[G__40938__i] = arguments[G__40938__i + 1]; ++G__40938__i;}
  body = new cljs.core.IndexedSeq(G__40938__a,0);
} 
return G__40937__delegate.call(this,cls,body);};
G__40937.cljs$lang$maxFixedArity = 1;
G__40937.cljs$lang$applyTo = (function (arglist__40939){
var cls = cljs.core.first(arglist__40939);
var body = cljs.core.rest(arglist__40939);
return G__40937__delegate(cls,body);
});
G__40937.cljs$core$IFn$_invoke$arity$variadic = G__40937__delegate;
return G__40937;
})()
;})(collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__40923 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__40923) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function hatti$views$record$iter__40924(s__40925){
return (new cljs.core.LazySeq(null,((function (G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (){
var s__40925__$1 = s__40925;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40925__$1);
if(temp__4657__auto__){
var s__40925__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40925__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40925__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40927 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40926 = (0);
while(true){
if((i__40926 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40926);
cljs.core.chunk_append(b__40927,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__40941 = (i__40926 + (1));
i__40926 = G__40941;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40927),hatti$views$record$iter__40924(cljs.core.chunk_rest(s__40925__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40927),null);
}
} else {
var d = cljs.core.first(s__40925__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__40924(cljs.core.rest(s__40925__$2)));
}
} else {
return null;
}
break;
}
});})(G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
,null,null));
});})(G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function hatti$views$record$iter__40930(s__40931){
return (new cljs.core.LazySeq(null,((function (G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (){
var s__40931__$1 = s__40931;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40931__$1);
if(temp__4657__auto__){
var s__40931__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40931__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40931__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40933 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40932 = (0);
while(true){
if((i__40932 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40932);
cljs.core.chunk_append(b__40933,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__40942 = (i__40932 + (1));
i__40932 = G__40942;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40933),hatti$views$record$iter__40930(cljs.core.chunk_rest(s__40931__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40933),null);
}
} else {
var d = cljs.core.first(s__40931__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__40930(cljs.core.rest(s__40931__$2)));
}
} else {
return null;
}
break;
}
});})(G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
,null,null));
});})(G__40923,collapse_BANG_,map__40915,map__40915__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__40913,map__40913__$1,collapsed_QMARK_,map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

hatti.views.record.t_hatti$views$record40909.getBasis = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__40903,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40904,cljs.core.cst$sym$map__40905,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__40906,cljs.core.cst$sym$view,cljs.core.cst$sym$meta40910], null);
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

hatti.views.record.t_hatti$views$record40909.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40909.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40909";

hatti.views.record.t_hatti$views$record40909.cljs$lang$ctorPrWriter = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40909");
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record40909 = ((function (map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record40909(p__40903__$1,owner__$1,p__40904__$1,map__40905__$2,data__$1,repeat_field__$1,lang__$1,map__40906__$2,view__$1,meta40910){
return (new hatti.views.record.t_hatti$views$record40909(p__40903__$1,owner__$1,p__40904__$1,map__40905__$2,data__$1,repeat_field__$1,lang__$1,map__40906__$2,view__$1,meta40910));
});})(map__40905,map__40905__$1,data,repeat_field,lang,map__40906,map__40906__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record40909(p__40903,owner,p__40904,map__40905__$1,data,repeat_field,lang,map__40906__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__40943){
var map__40946 = p__40943;
var map__40946__$1 = ((((!((map__40946 == null)))?((((map__40946.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40946.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40946):map__40946);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40946__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40946__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__40948){
var map__40949 = p__40948;
var map__40949__$1 = ((((!((map__40949 == null)))?((((map__40949.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40949.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40949):map__40949);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40949__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record40951 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40951 = (function (instance_id,owner,p__40948,map__40949,delete_record_BANG_,meta40952){
this.instance_id = instance_id;
this.owner = owner;
this.p__40948 = p__40948;
this.map__40949 = map__40949;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta40952 = meta40952;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40951.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40949,map__40949__$1,delete_record_BANG_){
return (function (_40953,meta40952__$1){
var self__ = this;
var _40953__$1 = this;
return (new hatti.views.record.t_hatti$views$record40951(self__.instance_id,self__.owner,self__.p__40948,self__.map__40949,self__.delete_record_BANG_,meta40952__$1));
});})(map__40949,map__40949__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40951.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40949,map__40949__$1,delete_record_BANG_){
return (function (_40953){
var self__ = this;
var _40953__$1 = this;
return self__.meta40952;
});})(map__40949,map__40949__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40951.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record40951.prototype.om$core$IRender$render$arity$1 = ((function (map__40949,map__40949__$1,delete_record_BANG_){
return (function (this__18114__auto__){
var self__ = this;
var this__18114__auto____$1 = this;
return null;
});})(map__40949,map__40949__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40951.getBasis = ((function (map__40949,map__40949__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40948,cljs.core.cst$sym$map__40949,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta40952], null);
});})(map__40949,map__40949__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record40951.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40951.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40951";

hatti.views.record.t_hatti$views$record40951.cljs$lang$ctorPrWriter = ((function (map__40949,map__40949__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40951");
});})(map__40949,map__40949__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record40951 = ((function (map__40949,map__40949__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record40951(instance_id__$1,owner__$1,p__40948__$1,map__40949__$2,delete_record_BANG___$1,meta40952){
return (new hatti.views.record.t_hatti$views$record40951(instance_id__$1,owner__$1,p__40948__$1,map__40949__$2,delete_record_BANG___$1,meta40952));
});})(map__40949,map__40949__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record40951(instance_id,owner,p__40948,map__40949__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__40954){
var map__40955 = p__40954;
var map__40955__$1 = ((((!((map__40955 == null)))?((((map__40955.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40955.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40955):map__40955);
var opts = map__40955__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40955__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record40957 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record40957 = (function (cursor,owner,p__40954,map__40955,opts,view,meta40958){
this.cursor = cursor;
this.owner = owner;
this.p__40954 = p__40954;
this.map__40955 = map__40955;
this.opts = opts;
this.view = view;
this.meta40958 = meta40958;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record40957.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__40955,map__40955__$1,opts,view){
return (function (_40959,meta40958__$1){
var self__ = this;
var _40959__$1 = this;
return (new hatti.views.record.t_hatti$views$record40957(self__.cursor,self__.owner,self__.p__40954,self__.map__40955,self__.opts,self__.view,meta40958__$1));
});})(map__40955,map__40955__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40957.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__40955,map__40955__$1,opts,view){
return (function (_40959){
var self__ = this;
var _40959__$1 = this;
return self__.meta40958;
});})(map__40955,map__40955__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40957.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record40957.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__40955,map__40955__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__40955,map__40955__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40957.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record40957.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__40955,map__40955__$1,opts,view){
return (function (_,p__40960){
var self__ = this;
var map__40961 = p__40960;
var map__40961__$1 = ((((!((map__40961 == null)))?((((map__40961.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40961.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40961):map__40961);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40961__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__40963 = self__.cursor;
var map__40963__$1 = ((((!((map__40963 == null)))?((((map__40963.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40963.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40963):map__40963);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40963__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40963__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40963__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__40966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__40966);
})();
var map__40964 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__40964__$1 = ((((!((map__40964 == null)))?((((map__40964.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40964.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40964):map__40964);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40964__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40964__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40964__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40964__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40964__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40964__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__40968 = (function (){var G__40970 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__40971 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__40972 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__40973 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__40970,G__40971,G__40972,G__40973) : topbar_wrap.call(null,G__40970,G__40971,G__40972,G__40973));
})();
var G__40969 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__40974 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__40975 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__40974,G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__40974,G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__40974,G__40975) : header_wrap.call(null,G__40974,G__40975));
})(),(function (){var G__40976 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__40978 = (function (){var iter__7189__auto__ = ((function (G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view){
return (function hatti$views$record$iter__40979(s__40980){
return (new cljs.core.LazySeq(null,((function (G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view){
return (function (){
var s__40980__$1 = s__40980;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40980__$1);
if(temp__4657__auto__){
var s__40980__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40980__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40980__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40982 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40981 = (0);
while(true){
if((i__40981 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40981);
cljs.core.chunk_append(b__40982,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__40992 = (i__40981 + (1));
i__40981 = G__40992;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40982),hatti$views$record$iter__40979(cljs.core.chunk_rest(s__40980__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40982),null);
}
} else {
var q = cljs.core.first(s__40980__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__40979(cljs.core.rest(s__40980__$2)));
}
} else {
return null;
}
break;
}
});})(G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view))
,null,null));
});})(G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__40978) : section_wrap.call(null,G__40978));
})():null);
var G__40977 = (function (){var G__40985 = (function (){var iter__7189__auto__ = ((function (G__40976,G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view){
return (function hatti$views$record$iter__40986(s__40987){
return (new cljs.core.LazySeq(null,((function (G__40976,G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view){
return (function (){
var s__40987__$1 = s__40987;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40987__$1);
if(temp__4657__auto__){
var s__40987__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40987__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40987__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40989 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40988 = (0);
while(true){
if((i__40988 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40988);
cljs.core.chunk_append(b__40989,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__40993 = (i__40988 + (1));
i__40988 = G__40993;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40989),hatti$views$record$iter__40986(cljs.core.chunk_rest(s__40987__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40989),null);
}
} else {
var q = cljs.core.first(s__40987__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__40986(cljs.core.rest(s__40987__$2)));
}
} else {
return null;
}
break;
}
});})(G__40976,G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view))
,null,null));
});})(G__40976,G__40968,form,language,map__40963,map__40963__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__40964,map__40964__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__40961,map__40961__$1,expand_meta_QMARK_,map__40955,map__40955__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__40985) : section_wrap.call(null,G__40985));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__40976,G__40977) : submission_info_wrap.call(null,G__40976,G__40977));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__40968,G__40969) : top_level_wrap.call(null,G__40968,G__40969));
})():null));
});})(map__40955,map__40955__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40957.getBasis = ((function (map__40955,map__40955__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__40954,cljs.core.cst$sym$map__40955,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta40958], null);
});})(map__40955,map__40955__$1,opts,view))
;

hatti.views.record.t_hatti$views$record40957.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record40957.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record40957";

hatti.views.record.t_hatti$views$record40957.cljs$lang$ctorPrWriter = ((function (map__40955,map__40955__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record40957");
});})(map__40955,map__40955__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record40957 = ((function (map__40955,map__40955__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record40957(cursor__$1,owner__$1,p__40954__$1,map__40955__$2,opts__$1,view__$1,meta40958){
return (new hatti.views.record.t_hatti$views$record40957(cursor__$1,owner__$1,p__40954__$1,map__40955__$2,opts__$1,view__$1,meta40958));
});})(map__40955,map__40955__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record40957(cursor,owner,p__40954,map__40955__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
