// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_40451){
var state_val_40452 = (state_40451[(1)]);
if((state_val_40452 === (7))){
var inst_40408 = (state_40451[(7)]);
var inst_40408__$1 = (state_40451[(2)]);
var inst_40410 = (inst_40408__$1 == null);
var inst_40411 = cljs.core.not(inst_40410);
var state_40451__$1 = (function (){var statearr_40453 = state_40451;
(statearr_40453[(7)] = inst_40408__$1);

return statearr_40453;
})();
if(inst_40411){
var statearr_40454_40491 = state_40451__$1;
(statearr_40454_40491[(1)] = (8));

} else {
var statearr_40455_40492 = state_40451__$1;
(statearr_40455_40492[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (20))){
var inst_40430 = (state_40451[(8)]);
var inst_40438 = (state_40451[(2)]);
var state_40451__$1 = (function (){var statearr_40456 = state_40451;
(statearr_40456[(9)] = inst_40438);

return statearr_40456;
})();
if(cljs.core.truth_(inst_40430)){
var statearr_40457_40493 = state_40451__$1;
(statearr_40457_40493[(1)] = (21));

} else {
var statearr_40458_40494 = state_40451__$1;
(statearr_40458_40494[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (1))){
var state_40451__$1 = state_40451;
var statearr_40459_40495 = state_40451__$1;
(statearr_40459_40495[(2)] = null);

(statearr_40459_40495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (4))){
var state_40451__$1 = state_40451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40451__$1,(7),agg_data_channel);
} else {
if((state_val_40452 === (15))){
var inst_40408 = (state_40451[(7)]);
var state_40451__$1 = state_40451;
var statearr_40460_40496 = state_40451__$1;
(statearr_40460_40496[(2)] = inst_40408);

(statearr_40460_40496[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (21))){
var inst_40440 = cljs.core.async.close_BANG_(agg_data_channel);
var state_40451__$1 = state_40451;
var statearr_40461_40497 = state_40451__$1;
(statearr_40461_40497[(2)] = inst_40440);

(statearr_40461_40497[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (13))){
var inst_40420 = (state_40451[(2)]);
var state_40451__$1 = state_40451;
var statearr_40462_40498 = state_40451__$1;
(statearr_40462_40498[(2)] = inst_40420);

(statearr_40462_40498[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (22))){
var state_40451__$1 = state_40451;
var statearr_40463_40499 = state_40451__$1;
(statearr_40463_40499[(2)] = null);

(statearr_40463_40499[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (6))){
var inst_40447 = (state_40451[(2)]);
var state_40451__$1 = state_40451;
var statearr_40464_40500 = state_40451__$1;
(statearr_40464_40500[(2)] = inst_40447);

(statearr_40464_40500[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (17))){
var inst_40429 = (state_40451[(10)]);
var inst_40430 = (state_40451[(8)]);
var inst_40432 = (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(inst_40429,inst_40430) : callback.call(null,inst_40429,inst_40430));
var state_40451__$1 = state_40451;
var statearr_40465_40501 = state_40451__$1;
(statearr_40465_40501[(2)] = inst_40432);

(statearr_40465_40501[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (3))){
var inst_40449 = (state_40451[(2)]);
var state_40451__$1 = state_40451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40451__$1,inst_40449);
} else {
if((state_val_40452 === (12))){
var state_40451__$1 = state_40451;
var statearr_40466_40502 = state_40451__$1;
(statearr_40466_40502[(2)] = false);

(statearr_40466_40502[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (2))){
var state_40451__$1 = state_40451;
var statearr_40467_40503 = state_40451__$1;
(statearr_40467_40503[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (23))){
var inst_40443 = (state_40451[(2)]);
var state_40451__$1 = (function (){var statearr_40469 = state_40451;
(statearr_40469[(11)] = inst_40443);

return statearr_40469;
})();
var statearr_40470_40504 = state_40451__$1;
(statearr_40470_40504[(2)] = null);

(statearr_40470_40504[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (19))){
var inst_40435 = (state_40451[(2)]);
var inst_40436 = cljs.core.async.timeout(hatti.ona.stream.small_delay);
var state_40451__$1 = (function (){var statearr_40471 = state_40451;
(statearr_40471[(12)] = inst_40435);

return statearr_40471;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40451__$1,(20),inst_40436);
} else {
if((state_val_40452 === (11))){
var state_40451__$1 = state_40451;
var statearr_40472_40505 = state_40451__$1;
(statearr_40472_40505[(2)] = true);

(statearr_40472_40505[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (9))){
var state_40451__$1 = state_40451;
var statearr_40473_40506 = state_40451__$1;
(statearr_40473_40506[(2)] = false);

(statearr_40473_40506[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (5))){
var state_40451__$1 = state_40451;
var statearr_40474_40507 = state_40451__$1;
(statearr_40474_40507[(2)] = null);

(statearr_40474_40507[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (14))){
var inst_40408 = (state_40451[(7)]);
var inst_40425 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40408);
var state_40451__$1 = state_40451;
var statearr_40475_40508 = state_40451__$1;
(statearr_40475_40508[(2)] = inst_40425);

(statearr_40475_40508[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (16))){
var inst_40429 = (state_40451[(10)]);
var inst_40428 = (state_40451[(2)]);
var inst_40429__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40428,cljs.core.cst$kw$data);
var inst_40430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40428,cljs.core.cst$kw$completed_QMARK_);
var state_40451__$1 = (function (){var statearr_40476 = state_40451;
(statearr_40476[(10)] = inst_40429__$1);

(statearr_40476[(8)] = inst_40430);

return statearr_40476;
})();
if(cljs.core.truth_(inst_40429__$1)){
var statearr_40477_40509 = state_40451__$1;
(statearr_40477_40509[(1)] = (17));

} else {
var statearr_40478_40510 = state_40451__$1;
(statearr_40478_40510[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (10))){
var inst_40423 = (state_40451[(2)]);
var state_40451__$1 = state_40451;
if(cljs.core.truth_(inst_40423)){
var statearr_40479_40511 = state_40451__$1;
(statearr_40479_40511[(1)] = (14));

} else {
var statearr_40480_40512 = state_40451__$1;
(statearr_40480_40512[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (18))){
var state_40451__$1 = state_40451;
var statearr_40481_40513 = state_40451__$1;
(statearr_40481_40513[(2)] = null);

(statearr_40481_40513[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40452 === (8))){
var inst_40408 = (state_40451[(7)]);
var inst_40413 = inst_40408.cljs$lang$protocol_mask$partition0$;
var inst_40414 = (inst_40413 & (64));
var inst_40415 = inst_40408.cljs$core$ISeq$;
var inst_40416 = (inst_40414) || (inst_40415);
var state_40451__$1 = state_40451;
if(cljs.core.truth_(inst_40416)){
var statearr_40482_40514 = state_40451__$1;
(statearr_40482_40514[(1)] = (11));

} else {
var statearr_40483_40515 = state_40451__$1;
(statearr_40483_40515[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0 = (function (){
var statearr_40487 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40487[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__);

(statearr_40487[(1)] = (1));

return statearr_40487;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1 = (function (state_40451){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_40451);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e40488){if((e40488 instanceof Object)){
var ex__12031__auto__ = e40488;
var statearr_40489_40516 = state_40451;
(statearr_40489_40516[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40451);

return cljs.core.cst$kw$recur;
} else {
throw e40488;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__40517 = state_40451;
state_40451 = G__40517;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__ = function(state_40451){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1.call(this,state_40451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_40490 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_40490[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_40490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(read_count,cljs.core.inc);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(agg,cljs.core.conj,data_chunk);

if((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)) >= (100))) && (cljs.core.integer_QMARK_(Math.log10((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(read_count) : cljs.core.deref.call(null,read_count)))))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg))], null));

var G__40520_40522 = agg;
var G__40521_40523 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__40520_40522,G__40521_40523) : cljs.core.reset_BANG_.call(null,G__40520_40522,G__40521_40523));

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___40531 = arguments.length;
var i__7485__auto___40532 = (0);
while(true){
if((i__7485__auto___40532 < len__7484__auto___40531)){
args__7491__auto__.push((arguments[i__7485__auto___40532]));

var G__40533 = (i__7485__auto___40532 + (1));
i__7485__auto___40532 = G__40533;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__40527){
var map__40528 = p__40527;
var map__40528__$1 = ((((!((map__40528 == null)))?((((map__40528.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40528.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40528):map__40528);
var oboe_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40528__$1,cljs.core.cst$kw$oboe_DASH_headers);
var read_count = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
var agg = (function (){var G__40530 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__40530) : cljs.core.atom.call(null,G__40530));
})();
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var return_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var oboe_params = cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$headers,oboe_headers,cljs.core.cst$kw$withCredentials,true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__40528,map__40528__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__40528,map__40528__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__40528,map__40528__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(agg) : cljs.core.deref.call(null,agg)),cljs.core.cst$kw$completed_QMARK_,true], null));

return cljs.core.async.close_BANG_(return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__40528,map__40528__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_(channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq40524){
var G__40525 = cljs.core.first(seq40524);
var seq40524__$1 = cljs.core.next(seq40524);
var G__40526 = cljs.core.first(seq40524__$1);
var seq40524__$2 = cljs.core.next(seq40524__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__40525,G__40526,seq40524__$2);
});

