// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.urls');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('hatti.constants');
hatti.ona.forms.currency_regex = /£|$/;
hatti.ona.forms.newline_regex = /[\n\r]/;
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submission_time,cljs.core.cst$kw$full_DASH_name,hatti.constants._submission_time,cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$type,"dateTime"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submitted_by,cljs.core.cst$kw$full_DASH_name,hatti.constants._submitted_by,cljs.core.cst$kw$label,"Submitted by",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.last_edited = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._last_edited,cljs.core.cst$kw$full_DASH_name,hatti.constants._last_edited,cljs.core.cst$kw$label,"Last Edited",cljs.core.cst$kw$type,"date"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.last_edited,hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field], null);
/**
 * Format multiline answer by introducing html line breaks
 */
hatti.ona.forms.format_multiline_answer = (function hatti$ona$forms$format_multiline_answer(answer){
if(cljs.core.truth_((function (){var and__6397__auto__ = typeof answer === 'string';
if(and__6397__auto__){
return cljs.core.re_find(hatti.ona.forms.newline_regex,answer);
} else {
return and__6397__auto__;
}
})())){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35946_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$p,p1__35946_SHARP_],null));
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,hatti.ona.forms.newline_regex));
} else {
return answer;
}
});
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_(types,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Helper function: is the :name of a field among a set of names
 */
hatti.ona.forms.field_name_in_set_QMARK_ = (function hatti$ona$forms$field_name_in_set_QMARK_(names,field){
return cljs.core.contains_QMARK_(names,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_name_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["instanceID",null,"meta",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
}
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__35949 = field;
var map__35949__$1 = ((((!((map__35949 == null)))?((((map__35949.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35949.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35949):map__35949);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35949__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__35953 = field;
var map__35953__$1 = ((((!((map__35953 == null)))?((((map__35953.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35953.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35953):map__35953);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35953__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.geotrace_QMARK_ = (function hatti$ona$forms$geotrace_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geotrace",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.video_QMARK_ = (function hatti$ona$forms$video_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["video",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not((function (){var or__6409__auto__ = hatti.ona.forms.note_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.group_QMARK_(field);
}
})());
});
/**
 * Get the icon relevant to the given field (depending on its type).
 */
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return "column-string";
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_(field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.video_QMARK_(field))){
return "column-video";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_(field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35965 = arguments.length;
var i__7485__auto___35966 = (0);
while(true){
if((i__7485__auto___35966 < len__7484__auto___35965)){
args__7491__auto__.push((arguments[i__7485__auto___35966]));

var G__35967 = (i__7485__auto___35966 + (1));
i__7485__auto___35966 = G__35967;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__35957,p__35958){
var map__35959 = p__35957;
var map__35959__$1 = ((((!((map__35959 == null)))?((((map__35959.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35959.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35959):map__35959);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35959__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35959__$1,cljs.core.cst$kw$name);
var vec__35960 = p__35958;
var language = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35960,(0),null);
if(!(cljs.core.map_QMARK_(label))){
var or__6409__auto__ = label;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.keys(label)),language)){
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(language) : label.call(null,language));
} else {
var G__35964 = cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(label)));
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(G__35964) : label.call(null,G__35964));
}
}
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq35955){
var G__35956 = cljs.core.first(seq35955);
var seq35955__$1 = cljs.core.next(seq35955);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__35956,seq35955__$1);
});

/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35984 = arguments.length;
var i__7485__auto___35985 = (0);
while(true){
if((i__7485__auto___35985 < len__7484__auto___35984)){
args__7491__auto__.push((arguments[i__7485__auto___35985]));

var G__35986 = (i__7485__auto___35985 + (1));
i__7485__auto___35985 = G__35986;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic = (function (field,answer,p__35974){
var map__35975 = p__35974;
var map__35975__$1 = ((((!((map__35975 == null)))?((((map__35975.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35975.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35975):map__35975);
var compact_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35975__$1,cljs.core.cst$kw$compact_QMARK_);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35975__$1,cljs.core.cst$kw$label);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35975__$1,cljs.core.cst$kw$language);
if(clojure.string.blank_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
var option = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__35975,map__35975__$1,compact_QMARK_,label,language){
return (function (p1__35968_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__35968_SHARP_));
});})(map__35975,map__35975__$1,compact_QMARK_,label,language))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(option,cljs.core.array_seq([language], 0));
var or__6409__auto__ = formatted;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return answer;
}
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
var names = cljs.core.set(clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,/ /));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,map__35975,map__35975__$1,compact_QMARK_,label,language){
return (function (p1__35970_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(p1__35970_SHARP_,cljs.core.array_seq([language], 0))),cljs.core.str(" ")].join('');
});})(names,map__35975,map__35975__$1,compact_QMARK_,label,language))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (names,map__35975,map__35975__$1,compact_QMARK_,label,language){
return (function (p1__35969_SHARP_){
return cljs.core.contains_QMARK_(names,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__35969_SHARP_));
});})(names,map__35975,map__35975__$1,compact_QMARK_,label,language))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field))));
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return moment(answer).format("ll");
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.image_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.video_QMARK_(field);
}
})())){
var image = cljs.core.cst$kw$download_url.cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__6409__auto__ = cljs.core.cst$kw$small_download_url.cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return image;
}
})();
var fname = chimera.urls.last_url_param(cljs.core.cst$kw$filename.cljs$core$IFn$_invoke$arity$1(answer));
if(typeof answer === 'string'){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                     %s </a>",cljs.core.array_seq([image,fname], 0));
} else {
if((thumb == null)){
return answer;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,image,cljs.core.cst$kw$target,"_blank"], null),(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"80px",cljs.core.cst$kw$src,thumb], null)], null):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_file_DASH_video_DASH_o], null)," ",fname], null))], null);

}
}
}
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
var kw__GT_name = cljs.core.name;
var map__35977 = answer;
var map__35977__$1 = ((((!((map__35977 == null)))?((((map__35977.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35977.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35977):map__35977);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35977__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35977__$1,cljs.core.cst$kw$type);
var osm_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35977__$1,cljs.core.cst$kw$osm_DASH_id);
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize(type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$osm_DASH_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (kw__GT_name,map__35977,map__35977__$1,name,type,osm_id,type_cap,title,map__35975,map__35975__$1,compact_QMARK_,label,language){
return (function (p__35979){
var vec__35980 = p__35979;
var tk = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35980,(0),null);
var tv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35980,(1),null);
if(clojure.string.blank_QMARK_(tv)){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$question,(kw__GT_name.cljs$core$IFn$_invoke$arity$1 ? kw__GT_name.cljs$core$IFn$_invoke$arity$1(tk) : kw__GT_name.call(null,tk))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$answer,tv], null)], null);
}
});})(kw__GT_name,map__35977,map__35977__$1,name,type,osm_id,type_cap,title,map__35975,map__35975__$1,compact_QMARK_,label,language))
,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
if(cljs.core.empty_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count(answer)),cljs.core.str(" answers.")].join('');
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
var temp__4655__auto__ = (function (){var G__35983 = label;
if((G__35983 == null)){
return null;
} else {
return cljs.core.re_find(hatti.ona.forms.currency_regex,G__35983);
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var currency = temp__4655__auto__;
return [cljs.core.str(currency),cljs.core.str(cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([answer], 0)))].join('');
} else {
return answer;
}
} else {
return hatti.ona.forms.format_multiline_answer(answer);
}

}
}
}
}
}
}
}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = (2);

hatti.ona.forms.format_answer.cljs$lang$applyTo = (function (seq35971){
var G__35972 = cljs.core.first(seq35971);
var seq35971__$1 = cljs.core.next(seq35971);
var G__35973 = cljs.core.first(seq35971__$1);
var seq35971__$2 = cljs.core.next(seq35971__$1);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(G__35972,G__35973,seq35971__$2);
});

/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(field){
var label = (function (){var temp__4655__auto__ = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core.truth_(temp__4655__auto__)){
var type = temp__4655__auto__;
var G__35989 = type;
switch (G__35989) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
default:
return cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field);

}
} else {
var G__35990 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submission_time,G__35990)){
return "Submission time";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submitted_by,G__35990)){
return "Submitted by";
} else {
return "";

}
}
}
})();
if(cljs.core.truth_(cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(field))){
return field;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(field,cljs.core.cst$kw$label,label);
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__7491__auto__ = [];
var len__7484__auto___36014 = arguments.length;
var i__7485__auto___36015 = (0);
while(true){
if((i__7485__auto___36015 < len__7484__auto___36014)){
args__7491__auto__.push((arguments[i__7485__auto___36015]));

var G__36016 = (i__7485__auto___36015 + (1));
i__7485__auto___36015 = G__36016;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__35997){
var map__35998 = p__35997;
var map__35998__$1 = ((((!((map__35998 == null)))?((((map__35998.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35998.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35998):map__35998);
var flatten_repeats_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35998__$1,cljs.core.cst$kw$flatten_DASH_repeats_QMARK_);
var name_label_map = ((function (map__35998,map__35998__$1,flatten_repeats_QMARK_){
return (function hatti$ona$forms$name_label_map(nd,prefix,acc){
var map__36012 = nd;
var map__36012__$1 = ((((!((map__36012 == null)))?((((map__36012.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36012.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36012):map__36012);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36012__$1,cljs.core.cst$kw$type);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36012__$1,cljs.core.cst$kw$children);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36012__$1,cljs.core.cst$kw$name);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36012__$1,cljs.core.cst$kw$label);
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_(label))?cljs.core.keys(label):null);
var nd__$1 = cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nd,cljs.core.cst$kw$full_DASH_name,full_name),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$langs,langs], null));
var mini_nd = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(nd__$1,cljs.core.cst$kw$children);
var new_children = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__36012,map__36012__$1,type,children,name,label,full_name,langs,nd__$1,mini_nd,map__35998,map__35998__$1,flatten_repeats_QMARK_){
return (function (p1__35992_SHARP_){
return hatti$ona$forms$name_label_map(p1__35992_SHARP_,full_name,cljs.core.PersistentVector.EMPTY);
});})(map__36012,map__36012__$1,type,children,name,label,full_name,langs,nd__$1,mini_nd,map__35998,map__35998__$1,flatten_repeats_QMARK_))
,children);
if(cljs.core.truth_(hatti.ona.forms.group_QMARK_(nd__$1))){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,mini_nd),new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(nd__$1))){
if(cljs.core.truth_(flatten_repeats_QMARK_)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,mini_nd),new_children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nd__$1,cljs.core.cst$kw$children,cljs.core.flatten(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,new_children))));
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,nd__$1);

}
}
});})(map__35998,map__35998__$1,flatten_repeats_QMARK_))
;
var nodes = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__35998,map__35998__$1,flatten_repeats_QMARK_){
return (function (p1__35993_SHARP_){
return name_label_map(p1__35993_SHARP_,null,cljs.core.PersistentVector.EMPTY);
});})(map__35998,map__35998__$1,flatten_repeats_QMARK_))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(form)));
var langs = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (nodes,map__35998,map__35998__$1,flatten_repeats_QMARK_){
return (function (p1__35994_SHARP_){
return cljs.core.cst$kw$langs.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__35994_SHARP_));
});})(nodes,map__35998,map__35998__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta(nodes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$languages,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq35995){
var G__35996 = cljs.core.first(seq35995);
var seq35995__$1 = cljs.core.next(seq35995);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__35996,seq35995__$1);
});

/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___36024 = arguments.length;
var i__7485__auto___36025 = (0);
while(true){
if((i__7485__auto___36025 < len__7484__auto___36024)){
args__7491__auto__.push((arguments[i__7485__auto___36025]));

var G__36026 = (i__7485__auto___36025 + (1));
i__7485__auto___36025 = G__36026;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__36020){
var map__36021 = p__36020;
var map__36021__$1 = ((((!((map__36021 == null)))?((((map__36021.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36021.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36021):map__36021);
var relabel_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__36021__$1,cljs.core.cst$kw$relabel_QMARK_,true);
var with_submission_details_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36021__$1,cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_);
var meta_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__36021,map__36021__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__36017_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__36017_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__36021,map__36021__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
var G__36023 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(relabel,meta_fields);
return (include_extra_sub_details.cljs$core$IFn$_invoke$arity$1 ? include_extra_sub_details.cljs$core$IFn$_invoke$arity$1(G__36023) : include_extra_sub_details.call(null,G__36023));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq36018){
var G__36019 = cljs.core.first(seq36018);
var seq36018__$1 = cljs.core.next(seq36018);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__36019,seq36018__$1);
});

/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
});
/**
 * Get just the geofields from the form.
 */
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,flat_form);
});
/**
 * From a list of geofields, get the default one to map.
 * Implementation: pick first geoshape if any, else pick first geofield.
 */
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){
var repeats = cljs.core.flatten(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(flat_form,repeats));
var geoshapes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq(geoshapes)){
return cljs.core.first(geoshapes);
} else {
if(cljs.core.seq(geopoints)){
return cljs.core.first(geopoints);
} else {
return cljs.core.first(geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find(/english/i,[cljs.core.str(language)].join(''));
});
/**
 * Get the languages for a given form.
 */
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){
return cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(form));
});
/**
 * Does this form contain labels in multiple languages?
 */
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){
return cljs.core.seq(hatti.ona.forms.get_languages(form));
});
/**
 * Get default language (English or alphabetical first) from within a list.
 */
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){
var temp__4655__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4655__auto__)){
var eng = temp__4655__auto__;
return eng;
} else {
return cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(languages));
}
});
