// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args30958 = [];
var len__7484__auto___30964 = arguments.length;
var i__7485__auto___30965 = (0);
while(true){
if((i__7485__auto___30965 < len__7484__auto___30964)){
args30958.push((arguments[i__7485__auto___30965]));

var G__30966 = (i__7485__auto___30965 + (1));
i__7485__auto___30965 = G__30966;
continue;
} else {
}
break;
}

var G__30960 = args30958.length;
switch (G__30960) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30958.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30961 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30961 = (function (f,blockable,meta30962){
this.f = f;
this.blockable = blockable;
this.meta30962 = meta30962;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30961.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30963,meta30962__$1){
var self__ = this;
var _30963__$1 = this;
return (new cljs.core.async.t_cljs$core$async30961(self__.f,self__.blockable,meta30962__$1));
});

cljs.core.async.t_cljs$core$async30961.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30963){
var self__ = this;
var _30963__$1 = this;
return self__.meta30962;
});

cljs.core.async.t_cljs$core$async30961.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async30961.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30961.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30961.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30961.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta30962], null);
});

cljs.core.async.t_cljs$core$async30961.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30961.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30961";

cljs.core.async.t_cljs$core$async30961.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async30961");
});

cljs.core.async.__GT_t_cljs$core$async30961 = (function cljs$core$async$__GT_t_cljs$core$async30961(f__$1,blockable__$1,meta30962){
return (new cljs.core.async.t_cljs$core$async30961(f__$1,blockable__$1,meta30962));
});

}

return (new cljs.core.async.t_cljs$core$async30961(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args30970 = [];
var len__7484__auto___30973 = arguments.length;
var i__7485__auto___30974 = (0);
while(true){
if((i__7485__auto___30974 < len__7484__auto___30973)){
args30970.push((arguments[i__7485__auto___30974]));

var G__30975 = (i__7485__auto___30974 + (1));
i__7485__auto___30974 = G__30975;
continue;
} else {
}
break;
}

var G__30972 = args30970.length;
switch (G__30972) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30970.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args30977 = [];
var len__7484__auto___30980 = arguments.length;
var i__7485__auto___30981 = (0);
while(true){
if((i__7485__auto___30981 < len__7484__auto___30980)){
args30977.push((arguments[i__7485__auto___30981]));

var G__30982 = (i__7485__auto___30981 + (1));
i__7485__auto___30981 = G__30982;
continue;
} else {
}
break;
}

var G__30979 = args30977.length;
switch (G__30979) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30977.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args30984 = [];
var len__7484__auto___30987 = arguments.length;
var i__7485__auto___30988 = (0);
while(true){
if((i__7485__auto___30988 < len__7484__auto___30987)){
args30984.push((arguments[i__7485__auto___30988]));

var G__30989 = (i__7485__auto___30988 + (1));
i__7485__auto___30988 = G__30989;
continue;
} else {
}
break;
}

var G__30986 = args30984.length;
switch (G__30986) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30984.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30991 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30991) : fn1.call(null,val_30991));
} else {
cljs.core.async.impl.dispatch.run(((function (val_30991,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30991) : fn1.call(null,val_30991));
});})(val_30991,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args30992 = [];
var len__7484__auto___30995 = arguments.length;
var i__7485__auto___30996 = (0);
while(true){
if((i__7485__auto___30996 < len__7484__auto___30995)){
args30992.push((arguments[i__7485__auto___30996]));

var G__30997 = (i__7485__auto___30996 + (1));
i__7485__auto___30996 = G__30997;
continue;
} else {
}
break;
}

var G__30994 = args30992.length;
switch (G__30994) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30992.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___30999 = n;
var x_31000 = (0);
while(true){
if((x_31000 < n__7324__auto___30999)){
(a[x_31000] = (0));

var G__31001 = (x_31000 + (1));
x_31000 = G__31001;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31002 = (i + (1));
i = G__31002;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31006 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31006 = (function (alt_flag,flag,meta31007){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta31007 = meta31007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31008,meta31007__$1){
var self__ = this;
var _31008__$1 = this;
return (new cljs.core.async.t_cljs$core$async31006(self__.alt_flag,self__.flag,meta31007__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31008){
var self__ = this;
var _31008__$1 = this;
return self__.meta31007;
});})(flag))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31006.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31007], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31006.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31006.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31006";

cljs.core.async.t_cljs$core$async31006.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31006");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31006 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31006(alt_flag__$1,flag__$1,meta31007){
return (new cljs.core.async.t_cljs$core$async31006(alt_flag__$1,flag__$1,meta31007));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31006(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31012 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31012 = (function (alt_handler,flag,cb,meta31013){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta31013 = meta31013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31014,meta31013__$1){
var self__ = this;
var _31014__$1 = this;
return (new cljs.core.async.t_cljs$core$async31012(self__.alt_handler,self__.flag,self__.cb,meta31013__$1));
});

cljs.core.async.t_cljs$core$async31012.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31014){
var self__ = this;
var _31014__$1 = this;
return self__.meta31013;
});

cljs.core.async.t_cljs$core$async31012.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31012.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31012.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31012.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31012.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31013], null);
});

cljs.core.async.t_cljs$core$async31012.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31012.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31012";

cljs.core.async.t_cljs$core$async31012.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31012");
});

cljs.core.async.__GT_t_cljs$core$async31012 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31012(alt_handler__$1,flag__$1,cb__$1,meta31013){
return (new cljs.core.async.t_cljs$core$async31012(alt_handler__$1,flag__$1,cb__$1,meta31013));
});

}

return (new cljs.core.async.t_cljs$core$async31012(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31015_SHARP_){
var G__31019 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31015_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31019) : fret.call(null,G__31019));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31016_SHARP_){
var G__31020 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31016_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31020) : fret.call(null,G__31020));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31021 = (i + (1));
i = G__31021;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31027 = arguments.length;
var i__7485__auto___31028 = (0);
while(true){
if((i__7485__auto___31028 < len__7484__auto___31027)){
args__7491__auto__.push((arguments[i__7485__auto___31028]));

var G__31029 = (i__7485__auto___31028 + (1));
i__7485__auto___31028 = G__31029;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31024){
var map__31025 = p__31024;
var map__31025__$1 = ((((!((map__31025 == null)))?((((map__31025.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31025.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31025):map__31025);
var opts = map__31025__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31022){
var G__31023 = cljs.core.first(seq31022);
var seq31022__$1 = cljs.core.next(seq31022);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31023,seq31022__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31030 = [];
var len__7484__auto___31080 = arguments.length;
var i__7485__auto___31081 = (0);
while(true){
if((i__7485__auto___31081 < len__7484__auto___31080)){
args31030.push((arguments[i__7485__auto___31081]));

var G__31082 = (i__7485__auto___31081 + (1));
i__7485__auto___31081 = G__31082;
continue;
} else {
}
break;
}

var G__31032 = args31030.length;
switch (G__31032) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31030.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12139__auto___31084 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31084){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31084){
return (function (state_31056){
var state_val_31057 = (state_31056[(1)]);
if((state_val_31057 === (7))){
var inst_31052 = (state_31056[(2)]);
var state_31056__$1 = state_31056;
var statearr_31058_31085 = state_31056__$1;
(statearr_31058_31085[(2)] = inst_31052);

(statearr_31058_31085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (1))){
var state_31056__$1 = state_31056;
var statearr_31059_31086 = state_31056__$1;
(statearr_31059_31086[(2)] = null);

(statearr_31059_31086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (4))){
var inst_31035 = (state_31056[(7)]);
var inst_31035__$1 = (state_31056[(2)]);
var inst_31036 = (inst_31035__$1 == null);
var state_31056__$1 = (function (){var statearr_31060 = state_31056;
(statearr_31060[(7)] = inst_31035__$1);

return statearr_31060;
})();
if(cljs.core.truth_(inst_31036)){
var statearr_31061_31087 = state_31056__$1;
(statearr_31061_31087[(1)] = (5));

} else {
var statearr_31062_31088 = state_31056__$1;
(statearr_31062_31088[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (13))){
var state_31056__$1 = state_31056;
var statearr_31063_31089 = state_31056__$1;
(statearr_31063_31089[(2)] = null);

(statearr_31063_31089[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (6))){
var inst_31035 = (state_31056[(7)]);
var state_31056__$1 = state_31056;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31056__$1,(11),to,inst_31035);
} else {
if((state_val_31057 === (3))){
var inst_31054 = (state_31056[(2)]);
var state_31056__$1 = state_31056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31056__$1,inst_31054);
} else {
if((state_val_31057 === (12))){
var state_31056__$1 = state_31056;
var statearr_31064_31090 = state_31056__$1;
(statearr_31064_31090[(2)] = null);

(statearr_31064_31090[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (2))){
var state_31056__$1 = state_31056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31056__$1,(4),from);
} else {
if((state_val_31057 === (11))){
var inst_31045 = (state_31056[(2)]);
var state_31056__$1 = state_31056;
if(cljs.core.truth_(inst_31045)){
var statearr_31065_31091 = state_31056__$1;
(statearr_31065_31091[(1)] = (12));

} else {
var statearr_31066_31092 = state_31056__$1;
(statearr_31066_31092[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (9))){
var state_31056__$1 = state_31056;
var statearr_31067_31093 = state_31056__$1;
(statearr_31067_31093[(2)] = null);

(statearr_31067_31093[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (5))){
var state_31056__$1 = state_31056;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31068_31094 = state_31056__$1;
(statearr_31068_31094[(1)] = (8));

} else {
var statearr_31069_31095 = state_31056__$1;
(statearr_31069_31095[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (14))){
var inst_31050 = (state_31056[(2)]);
var state_31056__$1 = state_31056;
var statearr_31070_31096 = state_31056__$1;
(statearr_31070_31096[(2)] = inst_31050);

(statearr_31070_31096[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (10))){
var inst_31042 = (state_31056[(2)]);
var state_31056__$1 = state_31056;
var statearr_31071_31097 = state_31056__$1;
(statearr_31071_31097[(2)] = inst_31042);

(statearr_31071_31097[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31057 === (8))){
var inst_31039 = cljs.core.async.close_BANG_(to);
var state_31056__$1 = state_31056;
var statearr_31072_31098 = state_31056__$1;
(statearr_31072_31098[(2)] = inst_31039);

(statearr_31072_31098[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31084))
;
return ((function (switch__12027__auto__,c__12139__auto___31084){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31076 = [null,null,null,null,null,null,null,null];
(statearr_31076[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31076[(1)] = (1));

return statearr_31076;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31056){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31056);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31077){if((e31077 instanceof Object)){
var ex__12031__auto__ = e31077;
var statearr_31078_31099 = state_31056;
(statearr_31078_31099[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31056);

return cljs.core.cst$kw$recur;
} else {
throw e31077;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31100 = state_31056;
state_31056 = G__31100;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31056){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31084))
})();
var state__12141__auto__ = (function (){var statearr_31079 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31079[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31084);

return statearr_31079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31084))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31288){
var vec__31289 = p__31288;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31289,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31289,(1),null);
var job = vec__31289;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12139__auto___31475 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31475,res,vec__31289,v,p,job,jobs,results){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31475,res,vec__31289,v,p,job,jobs,results){
return (function (state_31296){
var state_val_31297 = (state_31296[(1)]);
if((state_val_31297 === (1))){
var state_31296__$1 = state_31296;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31296__$1,(2),res,v);
} else {
if((state_val_31297 === (2))){
var inst_31293 = (state_31296[(2)]);
var inst_31294 = cljs.core.async.close_BANG_(res);
var state_31296__$1 = (function (){var statearr_31298 = state_31296;
(statearr_31298[(7)] = inst_31293);

return statearr_31298;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31296__$1,inst_31294);
} else {
return null;
}
}
});})(c__12139__auto___31475,res,vec__31289,v,p,job,jobs,results))
;
return ((function (switch__12027__auto__,c__12139__auto___31475,res,vec__31289,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_31302 = [null,null,null,null,null,null,null,null];
(statearr_31302[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_31302[(1)] = (1));

return statearr_31302;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_31296){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31296);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31303){if((e31303 instanceof Object)){
var ex__12031__auto__ = e31303;
var statearr_31304_31476 = state_31296;
(statearr_31304_31476[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31296);

return cljs.core.cst$kw$recur;
} else {
throw e31303;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31477 = state_31296;
state_31296 = G__31477;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_31296){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_31296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31475,res,vec__31289,v,p,job,jobs,results))
})();
var state__12141__auto__ = (function (){var statearr_31305 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31305[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31475);

return statearr_31305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31475,res,vec__31289,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31306){
var vec__31307 = p__31306;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31307,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31307,(1),null);
var job = vec__31307;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___31478 = n;
var __31479 = (0);
while(true){
if((__31479 < n__7324__auto___31478)){
var G__31310_31480 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31310_31480) {
case "compute":
var c__12139__auto___31482 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31479,c__12139__auto___31482,G__31310_31480,n__7324__auto___31478,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (__31479,c__12139__auto___31482,G__31310_31480,n__7324__auto___31478,jobs,results,process,async){
return (function (state_31323){
var state_val_31324 = (state_31323[(1)]);
if((state_val_31324 === (1))){
var state_31323__$1 = state_31323;
var statearr_31325_31483 = state_31323__$1;
(statearr_31325_31483[(2)] = null);

(statearr_31325_31483[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31324 === (2))){
var state_31323__$1 = state_31323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31323__$1,(4),jobs);
} else {
if((state_val_31324 === (3))){
var inst_31321 = (state_31323[(2)]);
var state_31323__$1 = state_31323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31323__$1,inst_31321);
} else {
if((state_val_31324 === (4))){
var inst_31313 = (state_31323[(2)]);
var inst_31314 = process(inst_31313);
var state_31323__$1 = state_31323;
if(cljs.core.truth_(inst_31314)){
var statearr_31326_31484 = state_31323__$1;
(statearr_31326_31484[(1)] = (5));

} else {
var statearr_31327_31485 = state_31323__$1;
(statearr_31327_31485[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31324 === (5))){
var state_31323__$1 = state_31323;
var statearr_31328_31486 = state_31323__$1;
(statearr_31328_31486[(2)] = null);

(statearr_31328_31486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31324 === (6))){
var state_31323__$1 = state_31323;
var statearr_31329_31487 = state_31323__$1;
(statearr_31329_31487[(2)] = null);

(statearr_31329_31487[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31324 === (7))){
var inst_31319 = (state_31323[(2)]);
var state_31323__$1 = state_31323;
var statearr_31330_31488 = state_31323__$1;
(statearr_31330_31488[(2)] = inst_31319);

(statearr_31330_31488[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31479,c__12139__auto___31482,G__31310_31480,n__7324__auto___31478,jobs,results,process,async))
;
return ((function (__31479,switch__12027__auto__,c__12139__auto___31482,G__31310_31480,n__7324__auto___31478,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_31334 = [null,null,null,null,null,null,null];
(statearr_31334[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_31334[(1)] = (1));

return statearr_31334;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_31323){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31323);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31335){if((e31335 instanceof Object)){
var ex__12031__auto__ = e31335;
var statearr_31336_31489 = state_31323;
(statearr_31336_31489[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31323);

return cljs.core.cst$kw$recur;
} else {
throw e31335;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31490 = state_31323;
state_31323 = G__31490;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_31323){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_31323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(__31479,switch__12027__auto__,c__12139__auto___31482,G__31310_31480,n__7324__auto___31478,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_31337 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31337[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31482);

return statearr_31337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(__31479,c__12139__auto___31482,G__31310_31480,n__7324__auto___31478,jobs,results,process,async))
);


break;
case "async":
var c__12139__auto___31491 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31479,c__12139__auto___31491,G__31310_31480,n__7324__auto___31478,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (__31479,c__12139__auto___31491,G__31310_31480,n__7324__auto___31478,jobs,results,process,async){
return (function (state_31350){
var state_val_31351 = (state_31350[(1)]);
if((state_val_31351 === (1))){
var state_31350__$1 = state_31350;
var statearr_31352_31492 = state_31350__$1;
(statearr_31352_31492[(2)] = null);

(statearr_31352_31492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31351 === (2))){
var state_31350__$1 = state_31350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31350__$1,(4),jobs);
} else {
if((state_val_31351 === (3))){
var inst_31348 = (state_31350[(2)]);
var state_31350__$1 = state_31350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31350__$1,inst_31348);
} else {
if((state_val_31351 === (4))){
var inst_31340 = (state_31350[(2)]);
var inst_31341 = async(inst_31340);
var state_31350__$1 = state_31350;
if(cljs.core.truth_(inst_31341)){
var statearr_31353_31493 = state_31350__$1;
(statearr_31353_31493[(1)] = (5));

} else {
var statearr_31354_31494 = state_31350__$1;
(statearr_31354_31494[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31351 === (5))){
var state_31350__$1 = state_31350;
var statearr_31355_31495 = state_31350__$1;
(statearr_31355_31495[(2)] = null);

(statearr_31355_31495[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31351 === (6))){
var state_31350__$1 = state_31350;
var statearr_31356_31496 = state_31350__$1;
(statearr_31356_31496[(2)] = null);

(statearr_31356_31496[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31351 === (7))){
var inst_31346 = (state_31350[(2)]);
var state_31350__$1 = state_31350;
var statearr_31357_31497 = state_31350__$1;
(statearr_31357_31497[(2)] = inst_31346);

(statearr_31357_31497[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31479,c__12139__auto___31491,G__31310_31480,n__7324__auto___31478,jobs,results,process,async))
;
return ((function (__31479,switch__12027__auto__,c__12139__auto___31491,G__31310_31480,n__7324__auto___31478,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_31361 = [null,null,null,null,null,null,null];
(statearr_31361[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_31361[(1)] = (1));

return statearr_31361;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_31350){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31350);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31362){if((e31362 instanceof Object)){
var ex__12031__auto__ = e31362;
var statearr_31363_31498 = state_31350;
(statearr_31363_31498[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31350);

return cljs.core.cst$kw$recur;
} else {
throw e31362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31499 = state_31350;
state_31350 = G__31499;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_31350){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_31350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(__31479,switch__12027__auto__,c__12139__auto___31491,G__31310_31480,n__7324__auto___31478,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_31364 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31491);

return statearr_31364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(__31479,c__12139__auto___31491,G__31310_31480,n__7324__auto___31478,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31500 = (__31479 + (1));
__31479 = G__31500;
continue;
} else {
}
break;
}

var c__12139__auto___31501 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31501,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31501,jobs,results,process,async){
return (function (state_31386){
var state_val_31387 = (state_31386[(1)]);
if((state_val_31387 === (1))){
var state_31386__$1 = state_31386;
var statearr_31388_31502 = state_31386__$1;
(statearr_31388_31502[(2)] = null);

(statearr_31388_31502[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31387 === (2))){
var state_31386__$1 = state_31386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31386__$1,(4),from);
} else {
if((state_val_31387 === (3))){
var inst_31384 = (state_31386[(2)]);
var state_31386__$1 = state_31386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31386__$1,inst_31384);
} else {
if((state_val_31387 === (4))){
var inst_31367 = (state_31386[(7)]);
var inst_31367__$1 = (state_31386[(2)]);
var inst_31368 = (inst_31367__$1 == null);
var state_31386__$1 = (function (){var statearr_31389 = state_31386;
(statearr_31389[(7)] = inst_31367__$1);

return statearr_31389;
})();
if(cljs.core.truth_(inst_31368)){
var statearr_31390_31503 = state_31386__$1;
(statearr_31390_31503[(1)] = (5));

} else {
var statearr_31391_31504 = state_31386__$1;
(statearr_31391_31504[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31387 === (5))){
var inst_31370 = cljs.core.async.close_BANG_(jobs);
var state_31386__$1 = state_31386;
var statearr_31392_31505 = state_31386__$1;
(statearr_31392_31505[(2)] = inst_31370);

(statearr_31392_31505[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31387 === (6))){
var inst_31372 = (state_31386[(8)]);
var inst_31367 = (state_31386[(7)]);
var inst_31372__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31374 = [inst_31367,inst_31372__$1];
var inst_31375 = (new cljs.core.PersistentVector(null,2,(5),inst_31373,inst_31374,null));
var state_31386__$1 = (function (){var statearr_31393 = state_31386;
(statearr_31393[(8)] = inst_31372__$1);

return statearr_31393;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31386__$1,(8),jobs,inst_31375);
} else {
if((state_val_31387 === (7))){
var inst_31382 = (state_31386[(2)]);
var state_31386__$1 = state_31386;
var statearr_31394_31506 = state_31386__$1;
(statearr_31394_31506[(2)] = inst_31382);

(statearr_31394_31506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31387 === (8))){
var inst_31372 = (state_31386[(8)]);
var inst_31377 = (state_31386[(2)]);
var state_31386__$1 = (function (){var statearr_31395 = state_31386;
(statearr_31395[(9)] = inst_31377);

return statearr_31395;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31386__$1,(9),results,inst_31372);
} else {
if((state_val_31387 === (9))){
var inst_31379 = (state_31386[(2)]);
var state_31386__$1 = (function (){var statearr_31396 = state_31386;
(statearr_31396[(10)] = inst_31379);

return statearr_31396;
})();
var statearr_31397_31507 = state_31386__$1;
(statearr_31397_31507[(2)] = null);

(statearr_31397_31507[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31501,jobs,results,process,async))
;
return ((function (switch__12027__auto__,c__12139__auto___31501,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_31401 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31401[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_31401[(1)] = (1));

return statearr_31401;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_31386){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31386);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31402){if((e31402 instanceof Object)){
var ex__12031__auto__ = e31402;
var statearr_31403_31508 = state_31386;
(statearr_31403_31508[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31386);

return cljs.core.cst$kw$recur;
} else {
throw e31402;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31509 = state_31386;
state_31386 = G__31509;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_31386){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_31386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31501,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_31404 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31404[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31501);

return statearr_31404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31501,jobs,results,process,async))
);


var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,jobs,results,process,async){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,jobs,results,process,async){
return (function (state_31442){
var state_val_31443 = (state_31442[(1)]);
if((state_val_31443 === (7))){
var inst_31438 = (state_31442[(2)]);
var state_31442__$1 = state_31442;
var statearr_31444_31510 = state_31442__$1;
(statearr_31444_31510[(2)] = inst_31438);

(statearr_31444_31510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (20))){
var state_31442__$1 = state_31442;
var statearr_31445_31511 = state_31442__$1;
(statearr_31445_31511[(2)] = null);

(statearr_31445_31511[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (1))){
var state_31442__$1 = state_31442;
var statearr_31446_31512 = state_31442__$1;
(statearr_31446_31512[(2)] = null);

(statearr_31446_31512[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (4))){
var inst_31407 = (state_31442[(7)]);
var inst_31407__$1 = (state_31442[(2)]);
var inst_31408 = (inst_31407__$1 == null);
var state_31442__$1 = (function (){var statearr_31447 = state_31442;
(statearr_31447[(7)] = inst_31407__$1);

return statearr_31447;
})();
if(cljs.core.truth_(inst_31408)){
var statearr_31448_31513 = state_31442__$1;
(statearr_31448_31513[(1)] = (5));

} else {
var statearr_31449_31514 = state_31442__$1;
(statearr_31449_31514[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (15))){
var inst_31420 = (state_31442[(8)]);
var state_31442__$1 = state_31442;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31442__$1,(18),to,inst_31420);
} else {
if((state_val_31443 === (21))){
var inst_31433 = (state_31442[(2)]);
var state_31442__$1 = state_31442;
var statearr_31450_31515 = state_31442__$1;
(statearr_31450_31515[(2)] = inst_31433);

(statearr_31450_31515[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (13))){
var inst_31435 = (state_31442[(2)]);
var state_31442__$1 = (function (){var statearr_31451 = state_31442;
(statearr_31451[(9)] = inst_31435);

return statearr_31451;
})();
var statearr_31452_31516 = state_31442__$1;
(statearr_31452_31516[(2)] = null);

(statearr_31452_31516[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (6))){
var inst_31407 = (state_31442[(7)]);
var state_31442__$1 = state_31442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31442__$1,(11),inst_31407);
} else {
if((state_val_31443 === (17))){
var inst_31428 = (state_31442[(2)]);
var state_31442__$1 = state_31442;
if(cljs.core.truth_(inst_31428)){
var statearr_31453_31517 = state_31442__$1;
(statearr_31453_31517[(1)] = (19));

} else {
var statearr_31454_31518 = state_31442__$1;
(statearr_31454_31518[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (3))){
var inst_31440 = (state_31442[(2)]);
var state_31442__$1 = state_31442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31442__$1,inst_31440);
} else {
if((state_val_31443 === (12))){
var inst_31417 = (state_31442[(10)]);
var state_31442__$1 = state_31442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31442__$1,(14),inst_31417);
} else {
if((state_val_31443 === (2))){
var state_31442__$1 = state_31442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31442__$1,(4),results);
} else {
if((state_val_31443 === (19))){
var state_31442__$1 = state_31442;
var statearr_31455_31519 = state_31442__$1;
(statearr_31455_31519[(2)] = null);

(statearr_31455_31519[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (11))){
var inst_31417 = (state_31442[(2)]);
var state_31442__$1 = (function (){var statearr_31456 = state_31442;
(statearr_31456[(10)] = inst_31417);

return statearr_31456;
})();
var statearr_31457_31520 = state_31442__$1;
(statearr_31457_31520[(2)] = null);

(statearr_31457_31520[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (9))){
var state_31442__$1 = state_31442;
var statearr_31458_31521 = state_31442__$1;
(statearr_31458_31521[(2)] = null);

(statearr_31458_31521[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (5))){
var state_31442__$1 = state_31442;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31459_31522 = state_31442__$1;
(statearr_31459_31522[(1)] = (8));

} else {
var statearr_31460_31523 = state_31442__$1;
(statearr_31460_31523[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (14))){
var inst_31422 = (state_31442[(11)]);
var inst_31420 = (state_31442[(8)]);
var inst_31420__$1 = (state_31442[(2)]);
var inst_31421 = (inst_31420__$1 == null);
var inst_31422__$1 = cljs.core.not(inst_31421);
var state_31442__$1 = (function (){var statearr_31461 = state_31442;
(statearr_31461[(11)] = inst_31422__$1);

(statearr_31461[(8)] = inst_31420__$1);

return statearr_31461;
})();
if(inst_31422__$1){
var statearr_31462_31524 = state_31442__$1;
(statearr_31462_31524[(1)] = (15));

} else {
var statearr_31463_31525 = state_31442__$1;
(statearr_31463_31525[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (16))){
var inst_31422 = (state_31442[(11)]);
var state_31442__$1 = state_31442;
var statearr_31464_31526 = state_31442__$1;
(statearr_31464_31526[(2)] = inst_31422);

(statearr_31464_31526[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (10))){
var inst_31414 = (state_31442[(2)]);
var state_31442__$1 = state_31442;
var statearr_31465_31527 = state_31442__$1;
(statearr_31465_31527[(2)] = inst_31414);

(statearr_31465_31527[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (18))){
var inst_31425 = (state_31442[(2)]);
var state_31442__$1 = state_31442;
var statearr_31466_31528 = state_31442__$1;
(statearr_31466_31528[(2)] = inst_31425);

(statearr_31466_31528[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31443 === (8))){
var inst_31411 = cljs.core.async.close_BANG_(to);
var state_31442__$1 = state_31442;
var statearr_31467_31529 = state_31442__$1;
(statearr_31467_31529[(2)] = inst_31411);

(statearr_31467_31529[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__,jobs,results,process,async))
;
return ((function (switch__12027__auto__,c__12139__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_31471 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31471[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__);

(statearr_31471[(1)] = (1));

return statearr_31471;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1 = (function (state_31442){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31442);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31472){if((e31472 instanceof Object)){
var ex__12031__auto__ = e31472;
var statearr_31473_31530 = state_31442;
(statearr_31473_31530[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31442);

return cljs.core.cst$kw$recur;
} else {
throw e31472;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31531 = state_31442;
state_31442 = G__31531;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__ = function(state_31442){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1.call(this,state_31442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,jobs,results,process,async))
})();
var state__12141__auto__ = (function (){var statearr_31474 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31474[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_31474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,jobs,results,process,async))
);

return c__12139__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31532 = [];
var len__7484__auto___31535 = arguments.length;
var i__7485__auto___31536 = (0);
while(true){
if((i__7485__auto___31536 < len__7484__auto___31535)){
args31532.push((arguments[i__7485__auto___31536]));

var G__31537 = (i__7485__auto___31536 + (1));
i__7485__auto___31536 = G__31537;
continue;
} else {
}
break;
}

var G__31534 = args31532.length;
switch (G__31534) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31532.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31539 = [];
var len__7484__auto___31542 = arguments.length;
var i__7485__auto___31543 = (0);
while(true){
if((i__7485__auto___31543 < len__7484__auto___31542)){
args31539.push((arguments[i__7485__auto___31543]));

var G__31544 = (i__7485__auto___31543 + (1));
i__7485__auto___31543 = G__31544;
continue;
} else {
}
break;
}

var G__31541 = args31539.length;
switch (G__31541) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31539.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31546 = [];
var len__7484__auto___31599 = arguments.length;
var i__7485__auto___31600 = (0);
while(true){
if((i__7485__auto___31600 < len__7484__auto___31599)){
args31546.push((arguments[i__7485__auto___31600]));

var G__31601 = (i__7485__auto___31600 + (1));
i__7485__auto___31600 = G__31601;
continue;
} else {
}
break;
}

var G__31548 = args31546.length;
switch (G__31548) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31546.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12139__auto___31603 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___31603,tc,fc){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___31603,tc,fc){
return (function (state_31574){
var state_val_31575 = (state_31574[(1)]);
if((state_val_31575 === (7))){
var inst_31570 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31576_31604 = state_31574__$1;
(statearr_31576_31604[(2)] = inst_31570);

(statearr_31576_31604[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (1))){
var state_31574__$1 = state_31574;
var statearr_31577_31605 = state_31574__$1;
(statearr_31577_31605[(2)] = null);

(statearr_31577_31605[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (4))){
var inst_31551 = (state_31574[(7)]);
var inst_31551__$1 = (state_31574[(2)]);
var inst_31552 = (inst_31551__$1 == null);
var state_31574__$1 = (function (){var statearr_31578 = state_31574;
(statearr_31578[(7)] = inst_31551__$1);

return statearr_31578;
})();
if(cljs.core.truth_(inst_31552)){
var statearr_31579_31606 = state_31574__$1;
(statearr_31579_31606[(1)] = (5));

} else {
var statearr_31580_31607 = state_31574__$1;
(statearr_31580_31607[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (13))){
var state_31574__$1 = state_31574;
var statearr_31581_31608 = state_31574__$1;
(statearr_31581_31608[(2)] = null);

(statearr_31581_31608[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (6))){
var inst_31551 = (state_31574[(7)]);
var inst_31557 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31551) : p.call(null,inst_31551));
var state_31574__$1 = state_31574;
if(cljs.core.truth_(inst_31557)){
var statearr_31582_31609 = state_31574__$1;
(statearr_31582_31609[(1)] = (9));

} else {
var statearr_31583_31610 = state_31574__$1;
(statearr_31583_31610[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (3))){
var inst_31572 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31574__$1,inst_31572);
} else {
if((state_val_31575 === (12))){
var state_31574__$1 = state_31574;
var statearr_31584_31611 = state_31574__$1;
(statearr_31584_31611[(2)] = null);

(statearr_31584_31611[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (2))){
var state_31574__$1 = state_31574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31574__$1,(4),ch);
} else {
if((state_val_31575 === (11))){
var inst_31551 = (state_31574[(7)]);
var inst_31561 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31574__$1,(8),inst_31561,inst_31551);
} else {
if((state_val_31575 === (9))){
var state_31574__$1 = state_31574;
var statearr_31585_31612 = state_31574__$1;
(statearr_31585_31612[(2)] = tc);

(statearr_31585_31612[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (5))){
var inst_31554 = cljs.core.async.close_BANG_(tc);
var inst_31555 = cljs.core.async.close_BANG_(fc);
var state_31574__$1 = (function (){var statearr_31586 = state_31574;
(statearr_31586[(8)] = inst_31554);

return statearr_31586;
})();
var statearr_31587_31613 = state_31574__$1;
(statearr_31587_31613[(2)] = inst_31555);

(statearr_31587_31613[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (14))){
var inst_31568 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
var statearr_31588_31614 = state_31574__$1;
(statearr_31588_31614[(2)] = inst_31568);

(statearr_31588_31614[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (10))){
var state_31574__$1 = state_31574;
var statearr_31589_31615 = state_31574__$1;
(statearr_31589_31615[(2)] = fc);

(statearr_31589_31615[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31575 === (8))){
var inst_31563 = (state_31574[(2)]);
var state_31574__$1 = state_31574;
if(cljs.core.truth_(inst_31563)){
var statearr_31590_31616 = state_31574__$1;
(statearr_31590_31616[(1)] = (12));

} else {
var statearr_31591_31617 = state_31574__$1;
(statearr_31591_31617[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___31603,tc,fc))
;
return ((function (switch__12027__auto__,c__12139__auto___31603,tc,fc){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31595 = [null,null,null,null,null,null,null,null,null];
(statearr_31595[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31595[(1)] = (1));

return statearr_31595;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31574){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31574);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31596){if((e31596 instanceof Object)){
var ex__12031__auto__ = e31596;
var statearr_31597_31618 = state_31574;
(statearr_31597_31618[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31574);

return cljs.core.cst$kw$recur;
} else {
throw e31596;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31619 = state_31574;
state_31574 = G__31619;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31574){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___31603,tc,fc))
})();
var state__12141__auto__ = (function (){var statearr_31598 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___31603);

return statearr_31598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___31603,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_31683){
var state_val_31684 = (state_31683[(1)]);
if((state_val_31684 === (7))){
var inst_31679 = (state_31683[(2)]);
var state_31683__$1 = state_31683;
var statearr_31685_31706 = state_31683__$1;
(statearr_31685_31706[(2)] = inst_31679);

(statearr_31685_31706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (1))){
var inst_31663 = init;
var state_31683__$1 = (function (){var statearr_31686 = state_31683;
(statearr_31686[(7)] = inst_31663);

return statearr_31686;
})();
var statearr_31687_31707 = state_31683__$1;
(statearr_31687_31707[(2)] = null);

(statearr_31687_31707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (4))){
var inst_31666 = (state_31683[(8)]);
var inst_31666__$1 = (state_31683[(2)]);
var inst_31667 = (inst_31666__$1 == null);
var state_31683__$1 = (function (){var statearr_31688 = state_31683;
(statearr_31688[(8)] = inst_31666__$1);

return statearr_31688;
})();
if(cljs.core.truth_(inst_31667)){
var statearr_31689_31708 = state_31683__$1;
(statearr_31689_31708[(1)] = (5));

} else {
var statearr_31690_31709 = state_31683__$1;
(statearr_31690_31709[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (6))){
var inst_31670 = (state_31683[(9)]);
var inst_31663 = (state_31683[(7)]);
var inst_31666 = (state_31683[(8)]);
var inst_31670__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31663,inst_31666) : f.call(null,inst_31663,inst_31666));
var inst_31671 = cljs.core.reduced_QMARK_(inst_31670__$1);
var state_31683__$1 = (function (){var statearr_31691 = state_31683;
(statearr_31691[(9)] = inst_31670__$1);

return statearr_31691;
})();
if(inst_31671){
var statearr_31692_31710 = state_31683__$1;
(statearr_31692_31710[(1)] = (8));

} else {
var statearr_31693_31711 = state_31683__$1;
(statearr_31693_31711[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (3))){
var inst_31681 = (state_31683[(2)]);
var state_31683__$1 = state_31683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31683__$1,inst_31681);
} else {
if((state_val_31684 === (2))){
var state_31683__$1 = state_31683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31683__$1,(4),ch);
} else {
if((state_val_31684 === (9))){
var inst_31670 = (state_31683[(9)]);
var inst_31663 = inst_31670;
var state_31683__$1 = (function (){var statearr_31694 = state_31683;
(statearr_31694[(7)] = inst_31663);

return statearr_31694;
})();
var statearr_31695_31712 = state_31683__$1;
(statearr_31695_31712[(2)] = null);

(statearr_31695_31712[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (5))){
var inst_31663 = (state_31683[(7)]);
var state_31683__$1 = state_31683;
var statearr_31696_31713 = state_31683__$1;
(statearr_31696_31713[(2)] = inst_31663);

(statearr_31696_31713[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (10))){
var inst_31677 = (state_31683[(2)]);
var state_31683__$1 = state_31683;
var statearr_31697_31714 = state_31683__$1;
(statearr_31697_31714[(2)] = inst_31677);

(statearr_31697_31714[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31684 === (8))){
var inst_31670 = (state_31683[(9)]);
var inst_31673 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_31670) : cljs.core.deref.call(null,inst_31670));
var state_31683__$1 = state_31683;
var statearr_31698_31715 = state_31683__$1;
(statearr_31698_31715[(2)] = inst_31673);

(statearr_31698_31715[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12028__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12028__auto____0 = (function (){
var statearr_31702 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31702[(0)] = cljs$core$async$reduce_$_state_machine__12028__auto__);

(statearr_31702[(1)] = (1));

return statearr_31702;
});
var cljs$core$async$reduce_$_state_machine__12028__auto____1 = (function (state_31683){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31683);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31703){if((e31703 instanceof Object)){
var ex__12031__auto__ = e31703;
var statearr_31704_31716 = state_31683;
(statearr_31704_31716[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31683);

return cljs.core.cst$kw$recur;
} else {
throw e31703;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31717 = state_31683;
state_31683 = G__31717;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12028__auto__ = function(state_31683){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12028__auto____1.call(this,state_31683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12028__auto____0;
cljs$core$async$reduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12028__auto____1;
return cljs$core$async$reduce_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_31705 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31705[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_31705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__,f__$1){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__,f__$1){
return (function (state_31737){
var state_val_31738 = (state_31737[(1)]);
if((state_val_31738 === (1))){
var inst_31732 = cljs.core.async.reduce(f__$1,init,ch);
var state_31737__$1 = state_31737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31737__$1,(2),inst_31732);
} else {
if((state_val_31738 === (2))){
var inst_31734 = (state_31737[(2)]);
var inst_31735 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31734) : f__$1.call(null,inst_31734));
var state_31737__$1 = state_31737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31737__$1,inst_31735);
} else {
return null;
}
}
});})(c__12139__auto__,f__$1))
;
return ((function (switch__12027__auto__,c__12139__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12028__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12028__auto____0 = (function (){
var statearr_31742 = [null,null,null,null,null,null,null];
(statearr_31742[(0)] = cljs$core$async$transduce_$_state_machine__12028__auto__);

(statearr_31742[(1)] = (1));

return statearr_31742;
});
var cljs$core$async$transduce_$_state_machine__12028__auto____1 = (function (state_31737){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31737);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31743){if((e31743 instanceof Object)){
var ex__12031__auto__ = e31743;
var statearr_31744_31746 = state_31737;
(statearr_31744_31746[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31737);

return cljs.core.cst$kw$recur;
} else {
throw e31743;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31747 = state_31737;
state_31737 = G__31747;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12028__auto__ = function(state_31737){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12028__auto____1.call(this,state_31737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12028__auto____0;
cljs$core$async$transduce_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12028__auto____1;
return cljs$core$async$transduce_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__,f__$1))
})();
var state__12141__auto__ = (function (){var statearr_31745 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31745[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_31745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__,f__$1))
);

return c__12139__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args31748 = [];
var len__7484__auto___31800 = arguments.length;
var i__7485__auto___31801 = (0);
while(true){
if((i__7485__auto___31801 < len__7484__auto___31800)){
args31748.push((arguments[i__7485__auto___31801]));

var G__31802 = (i__7485__auto___31801 + (1));
i__7485__auto___31801 = G__31802;
continue;
} else {
}
break;
}

var G__31750 = args31748.length;
switch (G__31750) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31748.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_31775){
var state_val_31776 = (state_31775[(1)]);
if((state_val_31776 === (7))){
var inst_31757 = (state_31775[(2)]);
var state_31775__$1 = state_31775;
var statearr_31777_31804 = state_31775__$1;
(statearr_31777_31804[(2)] = inst_31757);

(statearr_31777_31804[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (1))){
var inst_31751 = cljs.core.seq(coll);
var inst_31752 = inst_31751;
var state_31775__$1 = (function (){var statearr_31778 = state_31775;
(statearr_31778[(7)] = inst_31752);

return statearr_31778;
})();
var statearr_31779_31805 = state_31775__$1;
(statearr_31779_31805[(2)] = null);

(statearr_31779_31805[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (4))){
var inst_31752 = (state_31775[(7)]);
var inst_31755 = cljs.core.first(inst_31752);
var state_31775__$1 = state_31775;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31775__$1,(7),ch,inst_31755);
} else {
if((state_val_31776 === (13))){
var inst_31769 = (state_31775[(2)]);
var state_31775__$1 = state_31775;
var statearr_31780_31806 = state_31775__$1;
(statearr_31780_31806[(2)] = inst_31769);

(statearr_31780_31806[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (6))){
var inst_31760 = (state_31775[(2)]);
var state_31775__$1 = state_31775;
if(cljs.core.truth_(inst_31760)){
var statearr_31781_31807 = state_31775__$1;
(statearr_31781_31807[(1)] = (8));

} else {
var statearr_31782_31808 = state_31775__$1;
(statearr_31782_31808[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (3))){
var inst_31773 = (state_31775[(2)]);
var state_31775__$1 = state_31775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31775__$1,inst_31773);
} else {
if((state_val_31776 === (12))){
var state_31775__$1 = state_31775;
var statearr_31783_31809 = state_31775__$1;
(statearr_31783_31809[(2)] = null);

(statearr_31783_31809[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (2))){
var inst_31752 = (state_31775[(7)]);
var state_31775__$1 = state_31775;
if(cljs.core.truth_(inst_31752)){
var statearr_31784_31810 = state_31775__$1;
(statearr_31784_31810[(1)] = (4));

} else {
var statearr_31785_31811 = state_31775__$1;
(statearr_31785_31811[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (11))){
var inst_31766 = cljs.core.async.close_BANG_(ch);
var state_31775__$1 = state_31775;
var statearr_31786_31812 = state_31775__$1;
(statearr_31786_31812[(2)] = inst_31766);

(statearr_31786_31812[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (9))){
var state_31775__$1 = state_31775;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31787_31813 = state_31775__$1;
(statearr_31787_31813[(1)] = (11));

} else {
var statearr_31788_31814 = state_31775__$1;
(statearr_31788_31814[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (5))){
var inst_31752 = (state_31775[(7)]);
var state_31775__$1 = state_31775;
var statearr_31789_31815 = state_31775__$1;
(statearr_31789_31815[(2)] = inst_31752);

(statearr_31789_31815[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (10))){
var inst_31771 = (state_31775[(2)]);
var state_31775__$1 = state_31775;
var statearr_31790_31816 = state_31775__$1;
(statearr_31790_31816[(2)] = inst_31771);

(statearr_31790_31816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31776 === (8))){
var inst_31752 = (state_31775[(7)]);
var inst_31762 = cljs.core.next(inst_31752);
var inst_31752__$1 = inst_31762;
var state_31775__$1 = (function (){var statearr_31791 = state_31775;
(statearr_31791[(7)] = inst_31752__$1);

return statearr_31791;
})();
var statearr_31792_31817 = state_31775__$1;
(statearr_31792_31817[(2)] = null);

(statearr_31792_31817[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_31796 = [null,null,null,null,null,null,null,null];
(statearr_31796[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_31796[(1)] = (1));

return statearr_31796;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_31775){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_31775);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e31797){if((e31797 instanceof Object)){
var ex__12031__auto__ = e31797;
var statearr_31798_31818 = state_31775;
(statearr_31798_31818[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31775);

return cljs.core.cst$kw$recur;
} else {
throw e31797;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__31819 = state_31775;
state_31775 = G__31819;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_31775){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_31775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_31799 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_31799[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_31799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32048 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32048) : cljs.core.atom.call(null,G__32048));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32049 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32049 = (function (mult,ch,cs,meta32050){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta32050 = meta32050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32051,meta32050__$1){
var self__ = this;
var _32051__$1 = this;
return (new cljs.core.async.t_cljs$core$async32049(self__.mult,self__.ch,self__.cs,meta32050__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32051){
var self__ = this;
var _32051__$1 = this;
return self__.meta32050;
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32052_32276 = self__.cs;
var G__32053_32277 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32052_32276,G__32053_32277) : cljs.core.reset_BANG_.call(null,G__32052_32276,G__32053_32277));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32050], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32049.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32049.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32049";

cljs.core.async.t_cljs$core$async32049.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32049");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32049 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32049(mult__$1,ch__$1,cs__$1,meta32050){
return (new cljs.core.async.t_cljs$core$async32049(mult__$1,ch__$1,cs__$1,meta32050));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32049(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12139__auto___32278 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___32278,cs,m,dchan,dctr,done){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___32278,cs,m,dchan,dctr,done){
return (function (state_32188){
var state_val_32189 = (state_32188[(1)]);
if((state_val_32189 === (7))){
var inst_32184 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32190_32279 = state_32188__$1;
(statearr_32190_32279[(2)] = inst_32184);

(statearr_32190_32279[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (20))){
var inst_32087 = (state_32188[(7)]);
var inst_32099 = cljs.core.first(inst_32087);
var inst_32100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32099,(0),null);
var inst_32101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32099,(1),null);
var state_32188__$1 = (function (){var statearr_32191 = state_32188;
(statearr_32191[(8)] = inst_32100);

return statearr_32191;
})();
if(cljs.core.truth_(inst_32101)){
var statearr_32192_32280 = state_32188__$1;
(statearr_32192_32280[(1)] = (22));

} else {
var statearr_32193_32281 = state_32188__$1;
(statearr_32193_32281[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (27))){
var inst_32131 = (state_32188[(9)]);
var inst_32056 = (state_32188[(10)]);
var inst_32136 = (state_32188[(11)]);
var inst_32129 = (state_32188[(12)]);
var inst_32136__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32129,inst_32131);
var inst_32137 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32136__$1,inst_32056,done);
var state_32188__$1 = (function (){var statearr_32194 = state_32188;
(statearr_32194[(11)] = inst_32136__$1);

return statearr_32194;
})();
if(cljs.core.truth_(inst_32137)){
var statearr_32195_32282 = state_32188__$1;
(statearr_32195_32282[(1)] = (30));

} else {
var statearr_32196_32283 = state_32188__$1;
(statearr_32196_32283[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (1))){
var state_32188__$1 = state_32188;
var statearr_32197_32284 = state_32188__$1;
(statearr_32197_32284[(2)] = null);

(statearr_32197_32284[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (24))){
var inst_32087 = (state_32188[(7)]);
var inst_32106 = (state_32188[(2)]);
var inst_32107 = cljs.core.next(inst_32087);
var inst_32065 = inst_32107;
var inst_32066 = null;
var inst_32067 = (0);
var inst_32068 = (0);
var state_32188__$1 = (function (){var statearr_32198 = state_32188;
(statearr_32198[(13)] = inst_32065);

(statearr_32198[(14)] = inst_32106);

(statearr_32198[(15)] = inst_32068);

(statearr_32198[(16)] = inst_32067);

(statearr_32198[(17)] = inst_32066);

return statearr_32198;
})();
var statearr_32199_32285 = state_32188__$1;
(statearr_32199_32285[(2)] = null);

(statearr_32199_32285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (39))){
var state_32188__$1 = state_32188;
var statearr_32203_32286 = state_32188__$1;
(statearr_32203_32286[(2)] = null);

(statearr_32203_32286[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (4))){
var inst_32056 = (state_32188[(10)]);
var inst_32056__$1 = (state_32188[(2)]);
var inst_32057 = (inst_32056__$1 == null);
var state_32188__$1 = (function (){var statearr_32204 = state_32188;
(statearr_32204[(10)] = inst_32056__$1);

return statearr_32204;
})();
if(cljs.core.truth_(inst_32057)){
var statearr_32205_32287 = state_32188__$1;
(statearr_32205_32287[(1)] = (5));

} else {
var statearr_32206_32288 = state_32188__$1;
(statearr_32206_32288[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (15))){
var inst_32065 = (state_32188[(13)]);
var inst_32068 = (state_32188[(15)]);
var inst_32067 = (state_32188[(16)]);
var inst_32066 = (state_32188[(17)]);
var inst_32083 = (state_32188[(2)]);
var inst_32084 = (inst_32068 + (1));
var tmp32200 = inst_32065;
var tmp32201 = inst_32067;
var tmp32202 = inst_32066;
var inst_32065__$1 = tmp32200;
var inst_32066__$1 = tmp32202;
var inst_32067__$1 = tmp32201;
var inst_32068__$1 = inst_32084;
var state_32188__$1 = (function (){var statearr_32207 = state_32188;
(statearr_32207[(13)] = inst_32065__$1);

(statearr_32207[(15)] = inst_32068__$1);

(statearr_32207[(16)] = inst_32067__$1);

(statearr_32207[(17)] = inst_32066__$1);

(statearr_32207[(18)] = inst_32083);

return statearr_32207;
})();
var statearr_32208_32289 = state_32188__$1;
(statearr_32208_32289[(2)] = null);

(statearr_32208_32289[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (21))){
var inst_32110 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32212_32290 = state_32188__$1;
(statearr_32212_32290[(2)] = inst_32110);

(statearr_32212_32290[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (31))){
var inst_32136 = (state_32188[(11)]);
var inst_32140 = done(null);
var inst_32141 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32136);
var state_32188__$1 = (function (){var statearr_32213 = state_32188;
(statearr_32213[(19)] = inst_32140);

return statearr_32213;
})();
var statearr_32214_32291 = state_32188__$1;
(statearr_32214_32291[(2)] = inst_32141);

(statearr_32214_32291[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (32))){
var inst_32131 = (state_32188[(9)]);
var inst_32130 = (state_32188[(20)]);
var inst_32129 = (state_32188[(12)]);
var inst_32128 = (state_32188[(21)]);
var inst_32143 = (state_32188[(2)]);
var inst_32144 = (inst_32131 + (1));
var tmp32209 = inst_32130;
var tmp32210 = inst_32129;
var tmp32211 = inst_32128;
var inst_32128__$1 = tmp32211;
var inst_32129__$1 = tmp32210;
var inst_32130__$1 = tmp32209;
var inst_32131__$1 = inst_32144;
var state_32188__$1 = (function (){var statearr_32215 = state_32188;
(statearr_32215[(9)] = inst_32131__$1);

(statearr_32215[(22)] = inst_32143);

(statearr_32215[(20)] = inst_32130__$1);

(statearr_32215[(12)] = inst_32129__$1);

(statearr_32215[(21)] = inst_32128__$1);

return statearr_32215;
})();
var statearr_32216_32292 = state_32188__$1;
(statearr_32216_32292[(2)] = null);

(statearr_32216_32292[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (40))){
var inst_32156 = (state_32188[(23)]);
var inst_32160 = done(null);
var inst_32161 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32156);
var state_32188__$1 = (function (){var statearr_32217 = state_32188;
(statearr_32217[(24)] = inst_32160);

return statearr_32217;
})();
var statearr_32218_32293 = state_32188__$1;
(statearr_32218_32293[(2)] = inst_32161);

(statearr_32218_32293[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (33))){
var inst_32147 = (state_32188[(25)]);
var inst_32149 = cljs.core.chunked_seq_QMARK_(inst_32147);
var state_32188__$1 = state_32188;
if(inst_32149){
var statearr_32219_32294 = state_32188__$1;
(statearr_32219_32294[(1)] = (36));

} else {
var statearr_32220_32295 = state_32188__$1;
(statearr_32220_32295[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (13))){
var inst_32077 = (state_32188[(26)]);
var inst_32080 = cljs.core.async.close_BANG_(inst_32077);
var state_32188__$1 = state_32188;
var statearr_32221_32296 = state_32188__$1;
(statearr_32221_32296[(2)] = inst_32080);

(statearr_32221_32296[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (22))){
var inst_32100 = (state_32188[(8)]);
var inst_32103 = cljs.core.async.close_BANG_(inst_32100);
var state_32188__$1 = state_32188;
var statearr_32222_32297 = state_32188__$1;
(statearr_32222_32297[(2)] = inst_32103);

(statearr_32222_32297[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (36))){
var inst_32147 = (state_32188[(25)]);
var inst_32151 = cljs.core.chunk_first(inst_32147);
var inst_32152 = cljs.core.chunk_rest(inst_32147);
var inst_32153 = cljs.core.count(inst_32151);
var inst_32128 = inst_32152;
var inst_32129 = inst_32151;
var inst_32130 = inst_32153;
var inst_32131 = (0);
var state_32188__$1 = (function (){var statearr_32223 = state_32188;
(statearr_32223[(9)] = inst_32131);

(statearr_32223[(20)] = inst_32130);

(statearr_32223[(12)] = inst_32129);

(statearr_32223[(21)] = inst_32128);

return statearr_32223;
})();
var statearr_32224_32298 = state_32188__$1;
(statearr_32224_32298[(2)] = null);

(statearr_32224_32298[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (41))){
var inst_32147 = (state_32188[(25)]);
var inst_32163 = (state_32188[(2)]);
var inst_32164 = cljs.core.next(inst_32147);
var inst_32128 = inst_32164;
var inst_32129 = null;
var inst_32130 = (0);
var inst_32131 = (0);
var state_32188__$1 = (function (){var statearr_32225 = state_32188;
(statearr_32225[(9)] = inst_32131);

(statearr_32225[(20)] = inst_32130);

(statearr_32225[(12)] = inst_32129);

(statearr_32225[(27)] = inst_32163);

(statearr_32225[(21)] = inst_32128);

return statearr_32225;
})();
var statearr_32226_32299 = state_32188__$1;
(statearr_32226_32299[(2)] = null);

(statearr_32226_32299[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (43))){
var state_32188__$1 = state_32188;
var statearr_32227_32300 = state_32188__$1;
(statearr_32227_32300[(2)] = null);

(statearr_32227_32300[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (29))){
var inst_32172 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32228_32301 = state_32188__$1;
(statearr_32228_32301[(2)] = inst_32172);

(statearr_32228_32301[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (44))){
var inst_32181 = (state_32188[(2)]);
var state_32188__$1 = (function (){var statearr_32229 = state_32188;
(statearr_32229[(28)] = inst_32181);

return statearr_32229;
})();
var statearr_32230_32302 = state_32188__$1;
(statearr_32230_32302[(2)] = null);

(statearr_32230_32302[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (6))){
var inst_32120 = (state_32188[(29)]);
var inst_32119 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32120__$1 = cljs.core.keys(inst_32119);
var inst_32121 = cljs.core.count(inst_32120__$1);
var inst_32122 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32121) : cljs.core.reset_BANG_.call(null,dctr,inst_32121));
var inst_32127 = cljs.core.seq(inst_32120__$1);
var inst_32128 = inst_32127;
var inst_32129 = null;
var inst_32130 = (0);
var inst_32131 = (0);
var state_32188__$1 = (function (){var statearr_32231 = state_32188;
(statearr_32231[(9)] = inst_32131);

(statearr_32231[(20)] = inst_32130);

(statearr_32231[(12)] = inst_32129);

(statearr_32231[(30)] = inst_32122);

(statearr_32231[(21)] = inst_32128);

(statearr_32231[(29)] = inst_32120__$1);

return statearr_32231;
})();
var statearr_32232_32303 = state_32188__$1;
(statearr_32232_32303[(2)] = null);

(statearr_32232_32303[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (28))){
var inst_32147 = (state_32188[(25)]);
var inst_32128 = (state_32188[(21)]);
var inst_32147__$1 = cljs.core.seq(inst_32128);
var state_32188__$1 = (function (){var statearr_32233 = state_32188;
(statearr_32233[(25)] = inst_32147__$1);

return statearr_32233;
})();
if(inst_32147__$1){
var statearr_32234_32304 = state_32188__$1;
(statearr_32234_32304[(1)] = (33));

} else {
var statearr_32235_32305 = state_32188__$1;
(statearr_32235_32305[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (25))){
var inst_32131 = (state_32188[(9)]);
var inst_32130 = (state_32188[(20)]);
var inst_32133 = (inst_32131 < inst_32130);
var inst_32134 = inst_32133;
var state_32188__$1 = state_32188;
if(cljs.core.truth_(inst_32134)){
var statearr_32236_32306 = state_32188__$1;
(statearr_32236_32306[(1)] = (27));

} else {
var statearr_32237_32307 = state_32188__$1;
(statearr_32237_32307[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (34))){
var state_32188__$1 = state_32188;
var statearr_32238_32308 = state_32188__$1;
(statearr_32238_32308[(2)] = null);

(statearr_32238_32308[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (17))){
var state_32188__$1 = state_32188;
var statearr_32239_32309 = state_32188__$1;
(statearr_32239_32309[(2)] = null);

(statearr_32239_32309[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (3))){
var inst_32186 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32188__$1,inst_32186);
} else {
if((state_val_32189 === (12))){
var inst_32115 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32240_32310 = state_32188__$1;
(statearr_32240_32310[(2)] = inst_32115);

(statearr_32240_32310[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (2))){
var state_32188__$1 = state_32188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32188__$1,(4),ch);
} else {
if((state_val_32189 === (23))){
var state_32188__$1 = state_32188;
var statearr_32241_32311 = state_32188__$1;
(statearr_32241_32311[(2)] = null);

(statearr_32241_32311[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (35))){
var inst_32170 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32242_32312 = state_32188__$1;
(statearr_32242_32312[(2)] = inst_32170);

(statearr_32242_32312[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (19))){
var inst_32087 = (state_32188[(7)]);
var inst_32091 = cljs.core.chunk_first(inst_32087);
var inst_32092 = cljs.core.chunk_rest(inst_32087);
var inst_32093 = cljs.core.count(inst_32091);
var inst_32065 = inst_32092;
var inst_32066 = inst_32091;
var inst_32067 = inst_32093;
var inst_32068 = (0);
var state_32188__$1 = (function (){var statearr_32243 = state_32188;
(statearr_32243[(13)] = inst_32065);

(statearr_32243[(15)] = inst_32068);

(statearr_32243[(16)] = inst_32067);

(statearr_32243[(17)] = inst_32066);

return statearr_32243;
})();
var statearr_32244_32313 = state_32188__$1;
(statearr_32244_32313[(2)] = null);

(statearr_32244_32313[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (11))){
var inst_32065 = (state_32188[(13)]);
var inst_32087 = (state_32188[(7)]);
var inst_32087__$1 = cljs.core.seq(inst_32065);
var state_32188__$1 = (function (){var statearr_32245 = state_32188;
(statearr_32245[(7)] = inst_32087__$1);

return statearr_32245;
})();
if(inst_32087__$1){
var statearr_32246_32314 = state_32188__$1;
(statearr_32246_32314[(1)] = (16));

} else {
var statearr_32247_32315 = state_32188__$1;
(statearr_32247_32315[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (9))){
var inst_32117 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32248_32316 = state_32188__$1;
(statearr_32248_32316[(2)] = inst_32117);

(statearr_32248_32316[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (5))){
var inst_32063 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32064 = cljs.core.seq(inst_32063);
var inst_32065 = inst_32064;
var inst_32066 = null;
var inst_32067 = (0);
var inst_32068 = (0);
var state_32188__$1 = (function (){var statearr_32249 = state_32188;
(statearr_32249[(13)] = inst_32065);

(statearr_32249[(15)] = inst_32068);

(statearr_32249[(16)] = inst_32067);

(statearr_32249[(17)] = inst_32066);

return statearr_32249;
})();
var statearr_32250_32317 = state_32188__$1;
(statearr_32250_32317[(2)] = null);

(statearr_32250_32317[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (14))){
var state_32188__$1 = state_32188;
var statearr_32251_32318 = state_32188__$1;
(statearr_32251_32318[(2)] = null);

(statearr_32251_32318[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (45))){
var inst_32178 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32252_32319 = state_32188__$1;
(statearr_32252_32319[(2)] = inst_32178);

(statearr_32252_32319[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (26))){
var inst_32120 = (state_32188[(29)]);
var inst_32174 = (state_32188[(2)]);
var inst_32175 = cljs.core.seq(inst_32120);
var state_32188__$1 = (function (){var statearr_32253 = state_32188;
(statearr_32253[(31)] = inst_32174);

return statearr_32253;
})();
if(inst_32175){
var statearr_32254_32320 = state_32188__$1;
(statearr_32254_32320[(1)] = (42));

} else {
var statearr_32255_32321 = state_32188__$1;
(statearr_32255_32321[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (16))){
var inst_32087 = (state_32188[(7)]);
var inst_32089 = cljs.core.chunked_seq_QMARK_(inst_32087);
var state_32188__$1 = state_32188;
if(inst_32089){
var statearr_32256_32322 = state_32188__$1;
(statearr_32256_32322[(1)] = (19));

} else {
var statearr_32257_32323 = state_32188__$1;
(statearr_32257_32323[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (38))){
var inst_32167 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32258_32324 = state_32188__$1;
(statearr_32258_32324[(2)] = inst_32167);

(statearr_32258_32324[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (30))){
var state_32188__$1 = state_32188;
var statearr_32259_32325 = state_32188__$1;
(statearr_32259_32325[(2)] = null);

(statearr_32259_32325[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (10))){
var inst_32068 = (state_32188[(15)]);
var inst_32066 = (state_32188[(17)]);
var inst_32076 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32066,inst_32068);
var inst_32077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32076,(0),null);
var inst_32078 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32076,(1),null);
var state_32188__$1 = (function (){var statearr_32260 = state_32188;
(statearr_32260[(26)] = inst_32077);

return statearr_32260;
})();
if(cljs.core.truth_(inst_32078)){
var statearr_32261_32326 = state_32188__$1;
(statearr_32261_32326[(1)] = (13));

} else {
var statearr_32262_32327 = state_32188__$1;
(statearr_32262_32327[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (18))){
var inst_32113 = (state_32188[(2)]);
var state_32188__$1 = state_32188;
var statearr_32263_32328 = state_32188__$1;
(statearr_32263_32328[(2)] = inst_32113);

(statearr_32263_32328[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (42))){
var state_32188__$1 = state_32188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32188__$1,(45),dchan);
} else {
if((state_val_32189 === (37))){
var inst_32056 = (state_32188[(10)]);
var inst_32156 = (state_32188[(23)]);
var inst_32147 = (state_32188[(25)]);
var inst_32156__$1 = cljs.core.first(inst_32147);
var inst_32157 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32156__$1,inst_32056,done);
var state_32188__$1 = (function (){var statearr_32264 = state_32188;
(statearr_32264[(23)] = inst_32156__$1);

return statearr_32264;
})();
if(cljs.core.truth_(inst_32157)){
var statearr_32265_32329 = state_32188__$1;
(statearr_32265_32329[(1)] = (39));

} else {
var statearr_32266_32330 = state_32188__$1;
(statearr_32266_32330[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32189 === (8))){
var inst_32068 = (state_32188[(15)]);
var inst_32067 = (state_32188[(16)]);
var inst_32070 = (inst_32068 < inst_32067);
var inst_32071 = inst_32070;
var state_32188__$1 = state_32188;
if(cljs.core.truth_(inst_32071)){
var statearr_32267_32331 = state_32188__$1;
(statearr_32267_32331[(1)] = (10));

} else {
var statearr_32268_32332 = state_32188__$1;
(statearr_32268_32332[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___32278,cs,m,dchan,dctr,done))
;
return ((function (switch__12027__auto__,c__12139__auto___32278,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12028__auto__ = null;
var cljs$core$async$mult_$_state_machine__12028__auto____0 = (function (){
var statearr_32272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32272[(0)] = cljs$core$async$mult_$_state_machine__12028__auto__);

(statearr_32272[(1)] = (1));

return statearr_32272;
});
var cljs$core$async$mult_$_state_machine__12028__auto____1 = (function (state_32188){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_32188);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e32273){if((e32273 instanceof Object)){
var ex__12031__auto__ = e32273;
var statearr_32274_32333 = state_32188;
(statearr_32274_32333[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32188);

return cljs.core.cst$kw$recur;
} else {
throw e32273;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__32334 = state_32188;
state_32188 = G__32334;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12028__auto__ = function(state_32188){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12028__auto____1.call(this,state_32188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12028__auto____0;
cljs$core$async$mult_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12028__auto____1;
return cljs$core$async$mult_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___32278,cs,m,dchan,dctr,done))
})();
var state__12141__auto__ = (function (){var statearr_32275 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_32275[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___32278);

return statearr_32275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___32278,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args32335 = [];
var len__7484__auto___32338 = arguments.length;
var i__7485__auto___32339 = (0);
while(true){
if((i__7485__auto___32339 < len__7484__auto___32338)){
args32335.push((arguments[i__7485__auto___32339]));

var G__32340 = (i__7485__auto___32339 + (1));
i__7485__auto___32339 = G__32340;
continue;
} else {
}
break;
}

var G__32337 = args32335.length;
switch (G__32337) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32335.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32352 = arguments.length;
var i__7485__auto___32353 = (0);
while(true){
if((i__7485__auto___32353 < len__7484__auto___32352)){
args__7491__auto__.push((arguments[i__7485__auto___32353]));

var G__32354 = (i__7485__auto___32353 + (1));
i__7485__auto___32353 = G__32354;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32346){
var map__32347 = p__32346;
var map__32347__$1 = ((((!((map__32347 == null)))?((((map__32347.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32347.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32347):map__32347);
var opts = map__32347__$1;
var statearr_32349_32355 = state;
(statearr_32349_32355[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__32347,map__32347__$1,opts){
return (function (val){
var statearr_32350_32356 = state;
(statearr_32350_32356[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32347,map__32347__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32351_32357 = state;
(statearr_32351_32357[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32342){
var G__32343 = cljs.core.first(seq32342);
var seq32342__$1 = cljs.core.next(seq32342);
var G__32344 = cljs.core.first(seq32342__$1);
var seq32342__$2 = cljs.core.next(seq32342__$1);
var G__32345 = cljs.core.first(seq32342__$2);
var seq32342__$3 = cljs.core.next(seq32342__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32343,G__32344,G__32345,seq32342__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32527 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32527) : cljs.core.atom.call(null,G__32527));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__32528 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32528) : cljs.core.atom.call(null,G__32528));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32529 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32529 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32530){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32530 = meta32530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32531,meta32530__$1){
var self__ = this;
var _32531__$1 = this;
return (new cljs.core.async.t_cljs$core$async32529(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32530__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32531){
var self__ = this;
var _32531__$1 = this;
return self__.meta32530;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32532_32696 = self__.cs;
var G__32533_32697 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32532_32696,G__32533_32697) : cljs.core.reset_BANG_.call(null,G__32532_32696,G__32533_32697));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta32530], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32529.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32529";

cljs.core.async.t_cljs$core$async32529.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32529");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32529 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32529(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32530){
return (new cljs.core.async.t_cljs$core$async32529(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32530));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32529(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12139__auto___32698 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___32698,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___32698,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32633){
var state_val_32634 = (state_32633[(1)]);
if((state_val_32634 === (7))){
var inst_32549 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32635_32699 = state_32633__$1;
(statearr_32635_32699[(2)] = inst_32549);

(statearr_32635_32699[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (20))){
var inst_32561 = (state_32633[(7)]);
var state_32633__$1 = state_32633;
var statearr_32636_32700 = state_32633__$1;
(statearr_32636_32700[(2)] = inst_32561);

(statearr_32636_32700[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (27))){
var state_32633__$1 = state_32633;
var statearr_32637_32701 = state_32633__$1;
(statearr_32637_32701[(2)] = null);

(statearr_32637_32701[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (1))){
var inst_32537 = (state_32633[(8)]);
var inst_32537__$1 = calc_state();
var inst_32539 = (inst_32537__$1 == null);
var inst_32540 = cljs.core.not(inst_32539);
var state_32633__$1 = (function (){var statearr_32638 = state_32633;
(statearr_32638[(8)] = inst_32537__$1);

return statearr_32638;
})();
if(inst_32540){
var statearr_32639_32702 = state_32633__$1;
(statearr_32639_32702[(1)] = (2));

} else {
var statearr_32640_32703 = state_32633__$1;
(statearr_32640_32703[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (24))){
var inst_32584 = (state_32633[(9)]);
var inst_32593 = (state_32633[(10)]);
var inst_32607 = (state_32633[(11)]);
var inst_32607__$1 = (inst_32584.cljs$core$IFn$_invoke$arity$1 ? inst_32584.cljs$core$IFn$_invoke$arity$1(inst_32593) : inst_32584.call(null,inst_32593));
var state_32633__$1 = (function (){var statearr_32641 = state_32633;
(statearr_32641[(11)] = inst_32607__$1);

return statearr_32641;
})();
if(cljs.core.truth_(inst_32607__$1)){
var statearr_32642_32704 = state_32633__$1;
(statearr_32642_32704[(1)] = (29));

} else {
var statearr_32643_32705 = state_32633__$1;
(statearr_32643_32705[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (4))){
var inst_32552 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32552)){
var statearr_32644_32706 = state_32633__$1;
(statearr_32644_32706[(1)] = (8));

} else {
var statearr_32645_32707 = state_32633__$1;
(statearr_32645_32707[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (15))){
var inst_32578 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32578)){
var statearr_32646_32708 = state_32633__$1;
(statearr_32646_32708[(1)] = (19));

} else {
var statearr_32647_32709 = state_32633__$1;
(statearr_32647_32709[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (21))){
var inst_32583 = (state_32633[(12)]);
var inst_32583__$1 = (state_32633[(2)]);
var inst_32584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32583__$1,cljs.core.cst$kw$solos);
var inst_32585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32583__$1,cljs.core.cst$kw$mutes);
var inst_32586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32583__$1,cljs.core.cst$kw$reads);
var state_32633__$1 = (function (){var statearr_32648 = state_32633;
(statearr_32648[(9)] = inst_32584);

(statearr_32648[(13)] = inst_32585);

(statearr_32648[(12)] = inst_32583__$1);

return statearr_32648;
})();
return cljs.core.async.ioc_alts_BANG_(state_32633__$1,(22),inst_32586);
} else {
if((state_val_32634 === (31))){
var inst_32615 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32615)){
var statearr_32649_32710 = state_32633__$1;
(statearr_32649_32710[(1)] = (32));

} else {
var statearr_32650_32711 = state_32633__$1;
(statearr_32650_32711[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (32))){
var inst_32592 = (state_32633[(14)]);
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32633__$1,(35),out,inst_32592);
} else {
if((state_val_32634 === (33))){
var inst_32583 = (state_32633[(12)]);
var inst_32561 = inst_32583;
var state_32633__$1 = (function (){var statearr_32651 = state_32633;
(statearr_32651[(7)] = inst_32561);

return statearr_32651;
})();
var statearr_32652_32712 = state_32633__$1;
(statearr_32652_32712[(2)] = null);

(statearr_32652_32712[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (13))){
var inst_32561 = (state_32633[(7)]);
var inst_32568 = inst_32561.cljs$lang$protocol_mask$partition0$;
var inst_32569 = (inst_32568 & (64));
var inst_32570 = inst_32561.cljs$core$ISeq$;
var inst_32571 = (inst_32569) || (inst_32570);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32571)){
var statearr_32653_32713 = state_32633__$1;
(statearr_32653_32713[(1)] = (16));

} else {
var statearr_32654_32714 = state_32633__$1;
(statearr_32654_32714[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (22))){
var inst_32593 = (state_32633[(10)]);
var inst_32592 = (state_32633[(14)]);
var inst_32591 = (state_32633[(2)]);
var inst_32592__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32591,(0),null);
var inst_32593__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32591,(1),null);
var inst_32594 = (inst_32592__$1 == null);
var inst_32595 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32593__$1,change);
var inst_32596 = (inst_32594) || (inst_32595);
var state_32633__$1 = (function (){var statearr_32655 = state_32633;
(statearr_32655[(10)] = inst_32593__$1);

(statearr_32655[(14)] = inst_32592__$1);

return statearr_32655;
})();
if(cljs.core.truth_(inst_32596)){
var statearr_32656_32715 = state_32633__$1;
(statearr_32656_32715[(1)] = (23));

} else {
var statearr_32657_32716 = state_32633__$1;
(statearr_32657_32716[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (36))){
var inst_32583 = (state_32633[(12)]);
var inst_32561 = inst_32583;
var state_32633__$1 = (function (){var statearr_32658 = state_32633;
(statearr_32658[(7)] = inst_32561);

return statearr_32658;
})();
var statearr_32659_32717 = state_32633__$1;
(statearr_32659_32717[(2)] = null);

(statearr_32659_32717[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (29))){
var inst_32607 = (state_32633[(11)]);
var state_32633__$1 = state_32633;
var statearr_32660_32718 = state_32633__$1;
(statearr_32660_32718[(2)] = inst_32607);

(statearr_32660_32718[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (6))){
var state_32633__$1 = state_32633;
var statearr_32661_32719 = state_32633__$1;
(statearr_32661_32719[(2)] = false);

(statearr_32661_32719[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (28))){
var inst_32603 = (state_32633[(2)]);
var inst_32604 = calc_state();
var inst_32561 = inst_32604;
var state_32633__$1 = (function (){var statearr_32662 = state_32633;
(statearr_32662[(15)] = inst_32603);

(statearr_32662[(7)] = inst_32561);

return statearr_32662;
})();
var statearr_32663_32720 = state_32633__$1;
(statearr_32663_32720[(2)] = null);

(statearr_32663_32720[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (25))){
var inst_32629 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32664_32721 = state_32633__$1;
(statearr_32664_32721[(2)] = inst_32629);

(statearr_32664_32721[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (34))){
var inst_32627 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32665_32722 = state_32633__$1;
(statearr_32665_32722[(2)] = inst_32627);

(statearr_32665_32722[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (17))){
var state_32633__$1 = state_32633;
var statearr_32666_32723 = state_32633__$1;
(statearr_32666_32723[(2)] = false);

(statearr_32666_32723[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (3))){
var state_32633__$1 = state_32633;
var statearr_32667_32724 = state_32633__$1;
(statearr_32667_32724[(2)] = false);

(statearr_32667_32724[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (12))){
var inst_32631 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32633__$1,inst_32631);
} else {
if((state_val_32634 === (2))){
var inst_32537 = (state_32633[(8)]);
var inst_32542 = inst_32537.cljs$lang$protocol_mask$partition0$;
var inst_32543 = (inst_32542 & (64));
var inst_32544 = inst_32537.cljs$core$ISeq$;
var inst_32545 = (inst_32543) || (inst_32544);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32545)){
var statearr_32668_32725 = state_32633__$1;
(statearr_32668_32725[(1)] = (5));

} else {
var statearr_32669_32726 = state_32633__$1;
(statearr_32669_32726[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (23))){
var inst_32592 = (state_32633[(14)]);
var inst_32598 = (inst_32592 == null);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32598)){
var statearr_32670_32727 = state_32633__$1;
(statearr_32670_32727[(1)] = (26));

} else {
var statearr_32671_32728 = state_32633__$1;
(statearr_32671_32728[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (35))){
var inst_32618 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
if(cljs.core.truth_(inst_32618)){
var statearr_32672_32729 = state_32633__$1;
(statearr_32672_32729[(1)] = (36));

} else {
var statearr_32673_32730 = state_32633__$1;
(statearr_32673_32730[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (19))){
var inst_32561 = (state_32633[(7)]);
var inst_32580 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32561);
var state_32633__$1 = state_32633;
var statearr_32674_32731 = state_32633__$1;
(statearr_32674_32731[(2)] = inst_32580);

(statearr_32674_32731[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (11))){
var inst_32561 = (state_32633[(7)]);
var inst_32565 = (inst_32561 == null);
var inst_32566 = cljs.core.not(inst_32565);
var state_32633__$1 = state_32633;
if(inst_32566){
var statearr_32675_32732 = state_32633__$1;
(statearr_32675_32732[(1)] = (13));

} else {
var statearr_32676_32733 = state_32633__$1;
(statearr_32676_32733[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (9))){
var inst_32537 = (state_32633[(8)]);
var state_32633__$1 = state_32633;
var statearr_32677_32734 = state_32633__$1;
(statearr_32677_32734[(2)] = inst_32537);

(statearr_32677_32734[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (5))){
var state_32633__$1 = state_32633;
var statearr_32678_32735 = state_32633__$1;
(statearr_32678_32735[(2)] = true);

(statearr_32678_32735[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (14))){
var state_32633__$1 = state_32633;
var statearr_32679_32736 = state_32633__$1;
(statearr_32679_32736[(2)] = false);

(statearr_32679_32736[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (26))){
var inst_32593 = (state_32633[(10)]);
var inst_32600 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32593);
var state_32633__$1 = state_32633;
var statearr_32680_32737 = state_32633__$1;
(statearr_32680_32737[(2)] = inst_32600);

(statearr_32680_32737[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (16))){
var state_32633__$1 = state_32633;
var statearr_32681_32738 = state_32633__$1;
(statearr_32681_32738[(2)] = true);

(statearr_32681_32738[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (38))){
var inst_32623 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32682_32739 = state_32633__$1;
(statearr_32682_32739[(2)] = inst_32623);

(statearr_32682_32739[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (30))){
var inst_32584 = (state_32633[(9)]);
var inst_32585 = (state_32633[(13)]);
var inst_32593 = (state_32633[(10)]);
var inst_32610 = cljs.core.empty_QMARK_(inst_32584);
var inst_32611 = (inst_32585.cljs$core$IFn$_invoke$arity$1 ? inst_32585.cljs$core$IFn$_invoke$arity$1(inst_32593) : inst_32585.call(null,inst_32593));
var inst_32612 = cljs.core.not(inst_32611);
var inst_32613 = (inst_32610) && (inst_32612);
var state_32633__$1 = state_32633;
var statearr_32683_32740 = state_32633__$1;
(statearr_32683_32740[(2)] = inst_32613);

(statearr_32683_32740[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (10))){
var inst_32537 = (state_32633[(8)]);
var inst_32557 = (state_32633[(2)]);
var inst_32558 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32557,cljs.core.cst$kw$solos);
var inst_32559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32557,cljs.core.cst$kw$mutes);
var inst_32560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32557,cljs.core.cst$kw$reads);
var inst_32561 = inst_32537;
var state_32633__$1 = (function (){var statearr_32684 = state_32633;
(statearr_32684[(16)] = inst_32559);

(statearr_32684[(17)] = inst_32560);

(statearr_32684[(7)] = inst_32561);

(statearr_32684[(18)] = inst_32558);

return statearr_32684;
})();
var statearr_32685_32741 = state_32633__$1;
(statearr_32685_32741[(2)] = null);

(statearr_32685_32741[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (18))){
var inst_32575 = (state_32633[(2)]);
var state_32633__$1 = state_32633;
var statearr_32686_32742 = state_32633__$1;
(statearr_32686_32742[(2)] = inst_32575);

(statearr_32686_32742[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (37))){
var state_32633__$1 = state_32633;
var statearr_32687_32743 = state_32633__$1;
(statearr_32687_32743[(2)] = null);

(statearr_32687_32743[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32634 === (8))){
var inst_32537 = (state_32633[(8)]);
var inst_32554 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32537);
var state_32633__$1 = state_32633;
var statearr_32688_32744 = state_32633__$1;
(statearr_32688_32744[(2)] = inst_32554);

(statearr_32688_32744[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___32698,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12027__auto__,c__12139__auto___32698,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12028__auto__ = null;
var cljs$core$async$mix_$_state_machine__12028__auto____0 = (function (){
var statearr_32692 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32692[(0)] = cljs$core$async$mix_$_state_machine__12028__auto__);

(statearr_32692[(1)] = (1));

return statearr_32692;
});
var cljs$core$async$mix_$_state_machine__12028__auto____1 = (function (state_32633){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_32633);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e32693){if((e32693 instanceof Object)){
var ex__12031__auto__ = e32693;
var statearr_32694_32745 = state_32633;
(statearr_32694_32745[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32633);

return cljs.core.cst$kw$recur;
} else {
throw e32693;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__32746 = state_32633;
state_32633 = G__32746;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12028__auto__ = function(state_32633){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12028__auto____1.call(this,state_32633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12028__auto____0;
cljs$core$async$mix_$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12028__auto____1;
return cljs$core$async$mix_$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___32698,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12141__auto__ = (function (){var statearr_32695 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_32695[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___32698);

return statearr_32695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___32698,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args32747 = [];
var len__7484__auto___32750 = arguments.length;
var i__7485__auto___32751 = (0);
while(true){
if((i__7485__auto___32751 < len__7484__auto___32750)){
args32747.push((arguments[i__7485__auto___32751]));

var G__32752 = (i__7485__auto___32751 + (1));
i__7485__auto___32751 = G__32752;
continue;
} else {
}
break;
}

var G__32749 = args32747.length;
switch (G__32749) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32747.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args32755 = [];
var len__7484__auto___32883 = arguments.length;
var i__7485__auto___32884 = (0);
while(true){
if((i__7485__auto___32884 < len__7484__auto___32883)){
args32755.push((arguments[i__7485__auto___32884]));

var G__32885 = (i__7485__auto___32884 + (1));
i__7485__auto___32884 = G__32885;
continue;
} else {
}
break;
}

var G__32757 = args32755.length;
switch (G__32757) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32755.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__32758 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32758) : cljs.core.atom.call(null,G__32758));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__32754_SHARP_){
if(cljs.core.truth_((p1__32754_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32754_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32754_SHARP_.call(null,topic)))){
return p1__32754_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32754_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32759 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32759 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32760){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32760 = meta32760;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32761,meta32760__$1){
var self__ = this;
var _32761__$1 = this;
return (new cljs.core.async.t_cljs$core$async32759(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32760__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32761){
var self__ = this;
var _32761__$1 = this;
return self__.meta32760;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32762 = self__.mults;
var G__32763 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32762,G__32763) : cljs.core.reset_BANG_.call(null,G__32762,G__32763));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta32760], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32759.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32759.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32759";

cljs.core.async.t_cljs$core$async32759.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32759");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32759 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32759(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32760){
return (new cljs.core.async.t_cljs$core$async32759(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32760));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32759(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12139__auto___32887 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___32887,mults,ensure_mult,p){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___32887,mults,ensure_mult,p){
return (function (state_32835){
var state_val_32836 = (state_32835[(1)]);
if((state_val_32836 === (7))){
var inst_32831 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
var statearr_32837_32888 = state_32835__$1;
(statearr_32837_32888[(2)] = inst_32831);

(statearr_32837_32888[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (20))){
var state_32835__$1 = state_32835;
var statearr_32838_32889 = state_32835__$1;
(statearr_32838_32889[(2)] = null);

(statearr_32838_32889[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (1))){
var state_32835__$1 = state_32835;
var statearr_32839_32890 = state_32835__$1;
(statearr_32839_32890[(2)] = null);

(statearr_32839_32890[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (24))){
var inst_32814 = (state_32835[(7)]);
var inst_32823 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32814);
var state_32835__$1 = state_32835;
var statearr_32840_32891 = state_32835__$1;
(statearr_32840_32891[(2)] = inst_32823);

(statearr_32840_32891[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (4))){
var inst_32766 = (state_32835[(8)]);
var inst_32766__$1 = (state_32835[(2)]);
var inst_32767 = (inst_32766__$1 == null);
var state_32835__$1 = (function (){var statearr_32841 = state_32835;
(statearr_32841[(8)] = inst_32766__$1);

return statearr_32841;
})();
if(cljs.core.truth_(inst_32767)){
var statearr_32842_32892 = state_32835__$1;
(statearr_32842_32892[(1)] = (5));

} else {
var statearr_32843_32893 = state_32835__$1;
(statearr_32843_32893[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (15))){
var inst_32808 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
var statearr_32844_32894 = state_32835__$1;
(statearr_32844_32894[(2)] = inst_32808);

(statearr_32844_32894[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (21))){
var inst_32828 = (state_32835[(2)]);
var state_32835__$1 = (function (){var statearr_32845 = state_32835;
(statearr_32845[(9)] = inst_32828);

return statearr_32845;
})();
var statearr_32846_32895 = state_32835__$1;
(statearr_32846_32895[(2)] = null);

(statearr_32846_32895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (13))){
var inst_32790 = (state_32835[(10)]);
var inst_32792 = cljs.core.chunked_seq_QMARK_(inst_32790);
var state_32835__$1 = state_32835;
if(inst_32792){
var statearr_32847_32896 = state_32835__$1;
(statearr_32847_32896[(1)] = (16));

} else {
var statearr_32848_32897 = state_32835__$1;
(statearr_32848_32897[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (22))){
var inst_32820 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
if(cljs.core.truth_(inst_32820)){
var statearr_32849_32898 = state_32835__$1;
(statearr_32849_32898[(1)] = (23));

} else {
var statearr_32850_32899 = state_32835__$1;
(statearr_32850_32899[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (6))){
var inst_32766 = (state_32835[(8)]);
var inst_32814 = (state_32835[(7)]);
var inst_32816 = (state_32835[(11)]);
var inst_32814__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32766) : topic_fn.call(null,inst_32766));
var inst_32815 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_32816__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32815,inst_32814__$1);
var state_32835__$1 = (function (){var statearr_32851 = state_32835;
(statearr_32851[(7)] = inst_32814__$1);

(statearr_32851[(11)] = inst_32816__$1);

return statearr_32851;
})();
if(cljs.core.truth_(inst_32816__$1)){
var statearr_32852_32900 = state_32835__$1;
(statearr_32852_32900[(1)] = (19));

} else {
var statearr_32853_32901 = state_32835__$1;
(statearr_32853_32901[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (25))){
var inst_32825 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
var statearr_32854_32902 = state_32835__$1;
(statearr_32854_32902[(2)] = inst_32825);

(statearr_32854_32902[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (17))){
var inst_32790 = (state_32835[(10)]);
var inst_32799 = cljs.core.first(inst_32790);
var inst_32800 = cljs.core.async.muxch_STAR_(inst_32799);
var inst_32801 = cljs.core.async.close_BANG_(inst_32800);
var inst_32802 = cljs.core.next(inst_32790);
var inst_32776 = inst_32802;
var inst_32777 = null;
var inst_32778 = (0);
var inst_32779 = (0);
var state_32835__$1 = (function (){var statearr_32855 = state_32835;
(statearr_32855[(12)] = inst_32777);

(statearr_32855[(13)] = inst_32778);

(statearr_32855[(14)] = inst_32776);

(statearr_32855[(15)] = inst_32779);

(statearr_32855[(16)] = inst_32801);

return statearr_32855;
})();
var statearr_32856_32903 = state_32835__$1;
(statearr_32856_32903[(2)] = null);

(statearr_32856_32903[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (3))){
var inst_32833 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32835__$1,inst_32833);
} else {
if((state_val_32836 === (12))){
var inst_32810 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
var statearr_32857_32904 = state_32835__$1;
(statearr_32857_32904[(2)] = inst_32810);

(statearr_32857_32904[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (2))){
var state_32835__$1 = state_32835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32835__$1,(4),ch);
} else {
if((state_val_32836 === (23))){
var state_32835__$1 = state_32835;
var statearr_32858_32905 = state_32835__$1;
(statearr_32858_32905[(2)] = null);

(statearr_32858_32905[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (19))){
var inst_32766 = (state_32835[(8)]);
var inst_32816 = (state_32835[(11)]);
var inst_32818 = cljs.core.async.muxch_STAR_(inst_32816);
var state_32835__$1 = state_32835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32835__$1,(22),inst_32818,inst_32766);
} else {
if((state_val_32836 === (11))){
var inst_32790 = (state_32835[(10)]);
var inst_32776 = (state_32835[(14)]);
var inst_32790__$1 = cljs.core.seq(inst_32776);
var state_32835__$1 = (function (){var statearr_32859 = state_32835;
(statearr_32859[(10)] = inst_32790__$1);

return statearr_32859;
})();
if(inst_32790__$1){
var statearr_32860_32906 = state_32835__$1;
(statearr_32860_32906[(1)] = (13));

} else {
var statearr_32861_32907 = state_32835__$1;
(statearr_32861_32907[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (9))){
var inst_32812 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
var statearr_32862_32908 = state_32835__$1;
(statearr_32862_32908[(2)] = inst_32812);

(statearr_32862_32908[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (5))){
var inst_32773 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_32774 = cljs.core.vals(inst_32773);
var inst_32775 = cljs.core.seq(inst_32774);
var inst_32776 = inst_32775;
var inst_32777 = null;
var inst_32778 = (0);
var inst_32779 = (0);
var state_32835__$1 = (function (){var statearr_32863 = state_32835;
(statearr_32863[(12)] = inst_32777);

(statearr_32863[(13)] = inst_32778);

(statearr_32863[(14)] = inst_32776);

(statearr_32863[(15)] = inst_32779);

return statearr_32863;
})();
var statearr_32864_32909 = state_32835__$1;
(statearr_32864_32909[(2)] = null);

(statearr_32864_32909[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (14))){
var state_32835__$1 = state_32835;
var statearr_32868_32910 = state_32835__$1;
(statearr_32868_32910[(2)] = null);

(statearr_32868_32910[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (16))){
var inst_32790 = (state_32835[(10)]);
var inst_32794 = cljs.core.chunk_first(inst_32790);
var inst_32795 = cljs.core.chunk_rest(inst_32790);
var inst_32796 = cljs.core.count(inst_32794);
var inst_32776 = inst_32795;
var inst_32777 = inst_32794;
var inst_32778 = inst_32796;
var inst_32779 = (0);
var state_32835__$1 = (function (){var statearr_32869 = state_32835;
(statearr_32869[(12)] = inst_32777);

(statearr_32869[(13)] = inst_32778);

(statearr_32869[(14)] = inst_32776);

(statearr_32869[(15)] = inst_32779);

return statearr_32869;
})();
var statearr_32870_32911 = state_32835__$1;
(statearr_32870_32911[(2)] = null);

(statearr_32870_32911[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (10))){
var inst_32777 = (state_32835[(12)]);
var inst_32778 = (state_32835[(13)]);
var inst_32776 = (state_32835[(14)]);
var inst_32779 = (state_32835[(15)]);
var inst_32784 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32777,inst_32779);
var inst_32785 = cljs.core.async.muxch_STAR_(inst_32784);
var inst_32786 = cljs.core.async.close_BANG_(inst_32785);
var inst_32787 = (inst_32779 + (1));
var tmp32865 = inst_32777;
var tmp32866 = inst_32778;
var tmp32867 = inst_32776;
var inst_32776__$1 = tmp32867;
var inst_32777__$1 = tmp32865;
var inst_32778__$1 = tmp32866;
var inst_32779__$1 = inst_32787;
var state_32835__$1 = (function (){var statearr_32871 = state_32835;
(statearr_32871[(12)] = inst_32777__$1);

(statearr_32871[(13)] = inst_32778__$1);

(statearr_32871[(14)] = inst_32776__$1);

(statearr_32871[(15)] = inst_32779__$1);

(statearr_32871[(17)] = inst_32786);

return statearr_32871;
})();
var statearr_32872_32912 = state_32835__$1;
(statearr_32872_32912[(2)] = null);

(statearr_32872_32912[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (18))){
var inst_32805 = (state_32835[(2)]);
var state_32835__$1 = state_32835;
var statearr_32873_32913 = state_32835__$1;
(statearr_32873_32913[(2)] = inst_32805);

(statearr_32873_32913[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32836 === (8))){
var inst_32778 = (state_32835[(13)]);
var inst_32779 = (state_32835[(15)]);
var inst_32781 = (inst_32779 < inst_32778);
var inst_32782 = inst_32781;
var state_32835__$1 = state_32835;
if(cljs.core.truth_(inst_32782)){
var statearr_32874_32914 = state_32835__$1;
(statearr_32874_32914[(1)] = (10));

} else {
var statearr_32875_32915 = state_32835__$1;
(statearr_32875_32915[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___32887,mults,ensure_mult,p))
;
return ((function (switch__12027__auto__,c__12139__auto___32887,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_32879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32879[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_32879[(1)] = (1));

return statearr_32879;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_32835){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_32835);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e32880){if((e32880 instanceof Object)){
var ex__12031__auto__ = e32880;
var statearr_32881_32916 = state_32835;
(statearr_32881_32916[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32835);

return cljs.core.cst$kw$recur;
} else {
throw e32880;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__32917 = state_32835;
state_32835 = G__32917;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_32835){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_32835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___32887,mults,ensure_mult,p))
})();
var state__12141__auto__ = (function (){var statearr_32882 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_32882[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___32887);

return statearr_32882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___32887,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args32918 = [];
var len__7484__auto___32921 = arguments.length;
var i__7485__auto___32922 = (0);
while(true){
if((i__7485__auto___32922 < len__7484__auto___32921)){
args32918.push((arguments[i__7485__auto___32922]));

var G__32923 = (i__7485__auto___32922 + (1));
i__7485__auto___32922 = G__32923;
continue;
} else {
}
break;
}

var G__32920 = args32918.length;
switch (G__32920) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32918.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args32925 = [];
var len__7484__auto___32928 = arguments.length;
var i__7485__auto___32929 = (0);
while(true){
if((i__7485__auto___32929 < len__7484__auto___32928)){
args32925.push((arguments[i__7485__auto___32929]));

var G__32930 = (i__7485__auto___32929 + (1));
i__7485__auto___32929 = G__32930;
continue;
} else {
}
break;
}

var G__32927 = args32925.length;
switch (G__32927) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32925.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args32932 = [];
var len__7484__auto___33003 = arguments.length;
var i__7485__auto___33004 = (0);
while(true){
if((i__7485__auto___33004 < len__7484__auto___33003)){
args32932.push((arguments[i__7485__auto___33004]));

var G__33005 = (i__7485__auto___33004 + (1));
i__7485__auto___33004 = G__33005;
continue;
} else {
}
break;
}

var G__32934 = args32932.length;
switch (G__32934) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32932.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12139__auto___33007 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33007,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33007,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32973){
var state_val_32974 = (state_32973[(1)]);
if((state_val_32974 === (7))){
var state_32973__$1 = state_32973;
var statearr_32975_33008 = state_32973__$1;
(statearr_32975_33008[(2)] = null);

(statearr_32975_33008[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (1))){
var state_32973__$1 = state_32973;
var statearr_32976_33009 = state_32973__$1;
(statearr_32976_33009[(2)] = null);

(statearr_32976_33009[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (4))){
var inst_32937 = (state_32973[(7)]);
var inst_32939 = (inst_32937 < cnt);
var state_32973__$1 = state_32973;
if(cljs.core.truth_(inst_32939)){
var statearr_32977_33010 = state_32973__$1;
(statearr_32977_33010[(1)] = (6));

} else {
var statearr_32978_33011 = state_32973__$1;
(statearr_32978_33011[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (15))){
var inst_32969 = (state_32973[(2)]);
var state_32973__$1 = state_32973;
var statearr_32979_33012 = state_32973__$1;
(statearr_32979_33012[(2)] = inst_32969);

(statearr_32979_33012[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (13))){
var inst_32962 = cljs.core.async.close_BANG_(out);
var state_32973__$1 = state_32973;
var statearr_32980_33013 = state_32973__$1;
(statearr_32980_33013[(2)] = inst_32962);

(statearr_32980_33013[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (6))){
var state_32973__$1 = state_32973;
var statearr_32981_33014 = state_32973__$1;
(statearr_32981_33014[(2)] = null);

(statearr_32981_33014[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (3))){
var inst_32971 = (state_32973[(2)]);
var state_32973__$1 = state_32973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32973__$1,inst_32971);
} else {
if((state_val_32974 === (12))){
var inst_32959 = (state_32973[(8)]);
var inst_32959__$1 = (state_32973[(2)]);
var inst_32960 = cljs.core.some(cljs.core.nil_QMARK_,inst_32959__$1);
var state_32973__$1 = (function (){var statearr_32982 = state_32973;
(statearr_32982[(8)] = inst_32959__$1);

return statearr_32982;
})();
if(cljs.core.truth_(inst_32960)){
var statearr_32983_33015 = state_32973__$1;
(statearr_32983_33015[(1)] = (13));

} else {
var statearr_32984_33016 = state_32973__$1;
(statearr_32984_33016[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (2))){
var inst_32936 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_32937 = (0);
var state_32973__$1 = (function (){var statearr_32985 = state_32973;
(statearr_32985[(9)] = inst_32936);

(statearr_32985[(7)] = inst_32937);

return statearr_32985;
})();
var statearr_32986_33017 = state_32973__$1;
(statearr_32986_33017[(2)] = null);

(statearr_32986_33017[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (11))){
var inst_32937 = (state_32973[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_32973,(10),Object,null,(9));
var inst_32946 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_32937) : chs__$1.call(null,inst_32937));
var inst_32947 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_32937) : done.call(null,inst_32937));
var inst_32948 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32946,inst_32947);
var state_32973__$1 = state_32973;
var statearr_32987_33018 = state_32973__$1;
(statearr_32987_33018[(2)] = inst_32948);


cljs.core.async.impl.ioc_helpers.process_exception(state_32973__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (9))){
var inst_32937 = (state_32973[(7)]);
var inst_32950 = (state_32973[(2)]);
var inst_32951 = (inst_32937 + (1));
var inst_32937__$1 = inst_32951;
var state_32973__$1 = (function (){var statearr_32988 = state_32973;
(statearr_32988[(7)] = inst_32937__$1);

(statearr_32988[(10)] = inst_32950);

return statearr_32988;
})();
var statearr_32989_33019 = state_32973__$1;
(statearr_32989_33019[(2)] = null);

(statearr_32989_33019[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (5))){
var inst_32957 = (state_32973[(2)]);
var state_32973__$1 = (function (){var statearr_32990 = state_32973;
(statearr_32990[(11)] = inst_32957);

return statearr_32990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32973__$1,(12),dchan);
} else {
if((state_val_32974 === (14))){
var inst_32959 = (state_32973[(8)]);
var inst_32964 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32959);
var state_32973__$1 = state_32973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32973__$1,(16),out,inst_32964);
} else {
if((state_val_32974 === (16))){
var inst_32966 = (state_32973[(2)]);
var state_32973__$1 = (function (){var statearr_32991 = state_32973;
(statearr_32991[(12)] = inst_32966);

return statearr_32991;
})();
var statearr_32992_33020 = state_32973__$1;
(statearr_32992_33020[(2)] = null);

(statearr_32992_33020[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (10))){
var inst_32941 = (state_32973[(2)]);
var inst_32942 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32973__$1 = (function (){var statearr_32993 = state_32973;
(statearr_32993[(13)] = inst_32941);

return statearr_32993;
})();
var statearr_32994_33021 = state_32973__$1;
(statearr_32994_33021[(2)] = inst_32942);


cljs.core.async.impl.ioc_helpers.process_exception(state_32973__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_32974 === (8))){
var inst_32955 = (state_32973[(2)]);
var state_32973__$1 = state_32973;
var statearr_32995_33022 = state_32973__$1;
(statearr_32995_33022[(2)] = inst_32955);

(statearr_32995_33022[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33007,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12027__auto__,c__12139__auto___33007,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_32999 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32999[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_32999[(1)] = (1));

return statearr_32999;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_32973){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_32973);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33000){if((e33000 instanceof Object)){
var ex__12031__auto__ = e33000;
var statearr_33001_33023 = state_32973;
(statearr_33001_33023[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32973);

return cljs.core.cst$kw$recur;
} else {
throw e33000;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33024 = state_32973;
state_32973 = G__33024;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_32973){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_32973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33007,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12141__auto__ = (function (){var statearr_33002 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33002[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33007);

return statearr_33002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33007,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33026 = [];
var len__7484__auto___33084 = arguments.length;
var i__7485__auto___33085 = (0);
while(true){
if((i__7485__auto___33085 < len__7484__auto___33084)){
args33026.push((arguments[i__7485__auto___33085]));

var G__33086 = (i__7485__auto___33085 + (1));
i__7485__auto___33085 = G__33086;
continue;
} else {
}
break;
}

var G__33028 = args33026.length;
switch (G__33028) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33026.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___33088 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33088,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33088,out){
return (function (state_33060){
var state_val_33061 = (state_33060[(1)]);
if((state_val_33061 === (7))){
var inst_33040 = (state_33060[(7)]);
var inst_33039 = (state_33060[(8)]);
var inst_33039__$1 = (state_33060[(2)]);
var inst_33040__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33039__$1,(0),null);
var inst_33041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33039__$1,(1),null);
var inst_33042 = (inst_33040__$1 == null);
var state_33060__$1 = (function (){var statearr_33062 = state_33060;
(statearr_33062[(7)] = inst_33040__$1);

(statearr_33062[(9)] = inst_33041);

(statearr_33062[(8)] = inst_33039__$1);

return statearr_33062;
})();
if(cljs.core.truth_(inst_33042)){
var statearr_33063_33089 = state_33060__$1;
(statearr_33063_33089[(1)] = (8));

} else {
var statearr_33064_33090 = state_33060__$1;
(statearr_33064_33090[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (1))){
var inst_33029 = cljs.core.vec(chs);
var inst_33030 = inst_33029;
var state_33060__$1 = (function (){var statearr_33065 = state_33060;
(statearr_33065[(10)] = inst_33030);

return statearr_33065;
})();
var statearr_33066_33091 = state_33060__$1;
(statearr_33066_33091[(2)] = null);

(statearr_33066_33091[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (4))){
var inst_33030 = (state_33060[(10)]);
var state_33060__$1 = state_33060;
return cljs.core.async.ioc_alts_BANG_(state_33060__$1,(7),inst_33030);
} else {
if((state_val_33061 === (6))){
var inst_33056 = (state_33060[(2)]);
var state_33060__$1 = state_33060;
var statearr_33067_33092 = state_33060__$1;
(statearr_33067_33092[(2)] = inst_33056);

(statearr_33067_33092[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (3))){
var inst_33058 = (state_33060[(2)]);
var state_33060__$1 = state_33060;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33060__$1,inst_33058);
} else {
if((state_val_33061 === (2))){
var inst_33030 = (state_33060[(10)]);
var inst_33032 = cljs.core.count(inst_33030);
var inst_33033 = (inst_33032 > (0));
var state_33060__$1 = state_33060;
if(cljs.core.truth_(inst_33033)){
var statearr_33069_33093 = state_33060__$1;
(statearr_33069_33093[(1)] = (4));

} else {
var statearr_33070_33094 = state_33060__$1;
(statearr_33070_33094[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (11))){
var inst_33030 = (state_33060[(10)]);
var inst_33049 = (state_33060[(2)]);
var tmp33068 = inst_33030;
var inst_33030__$1 = tmp33068;
var state_33060__$1 = (function (){var statearr_33071 = state_33060;
(statearr_33071[(11)] = inst_33049);

(statearr_33071[(10)] = inst_33030__$1);

return statearr_33071;
})();
var statearr_33072_33095 = state_33060__$1;
(statearr_33072_33095[(2)] = null);

(statearr_33072_33095[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (9))){
var inst_33040 = (state_33060[(7)]);
var state_33060__$1 = state_33060;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33060__$1,(11),out,inst_33040);
} else {
if((state_val_33061 === (5))){
var inst_33054 = cljs.core.async.close_BANG_(out);
var state_33060__$1 = state_33060;
var statearr_33073_33096 = state_33060__$1;
(statearr_33073_33096[(2)] = inst_33054);

(statearr_33073_33096[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (10))){
var inst_33052 = (state_33060[(2)]);
var state_33060__$1 = state_33060;
var statearr_33074_33097 = state_33060__$1;
(statearr_33074_33097[(2)] = inst_33052);

(statearr_33074_33097[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33061 === (8))){
var inst_33040 = (state_33060[(7)]);
var inst_33041 = (state_33060[(9)]);
var inst_33039 = (state_33060[(8)]);
var inst_33030 = (state_33060[(10)]);
var inst_33044 = (function (){var cs = inst_33030;
var vec__33035 = inst_33039;
var v = inst_33040;
var c = inst_33041;
return ((function (cs,vec__33035,v,c,inst_33040,inst_33041,inst_33039,inst_33030,state_val_33061,c__12139__auto___33088,out){
return (function (p1__33025_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33025_SHARP_);
});
;})(cs,vec__33035,v,c,inst_33040,inst_33041,inst_33039,inst_33030,state_val_33061,c__12139__auto___33088,out))
})();
var inst_33045 = cljs.core.filterv(inst_33044,inst_33030);
var inst_33030__$1 = inst_33045;
var state_33060__$1 = (function (){var statearr_33075 = state_33060;
(statearr_33075[(10)] = inst_33030__$1);

return statearr_33075;
})();
var statearr_33076_33098 = state_33060__$1;
(statearr_33076_33098[(2)] = null);

(statearr_33076_33098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33088,out))
;
return ((function (switch__12027__auto__,c__12139__auto___33088,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_33080 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33080[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_33080[(1)] = (1));

return statearr_33080;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_33060){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33060);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33081){if((e33081 instanceof Object)){
var ex__12031__auto__ = e33081;
var statearr_33082_33099 = state_33060;
(statearr_33082_33099[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33060);

return cljs.core.cst$kw$recur;
} else {
throw e33081;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33100 = state_33060;
state_33060 = G__33100;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_33060){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_33060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33088,out))
})();
var state__12141__auto__ = (function (){var statearr_33083 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33083[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33088);

return statearr_33083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33088,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33101 = [];
var len__7484__auto___33150 = arguments.length;
var i__7485__auto___33151 = (0);
while(true){
if((i__7485__auto___33151 < len__7484__auto___33150)){
args33101.push((arguments[i__7485__auto___33151]));

var G__33152 = (i__7485__auto___33151 + (1));
i__7485__auto___33151 = G__33152;
continue;
} else {
}
break;
}

var G__33103 = args33101.length;
switch (G__33103) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33101.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___33154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33154,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33154,out){
return (function (state_33127){
var state_val_33128 = (state_33127[(1)]);
if((state_val_33128 === (7))){
var inst_33109 = (state_33127[(7)]);
var inst_33109__$1 = (state_33127[(2)]);
var inst_33110 = (inst_33109__$1 == null);
var inst_33111 = cljs.core.not(inst_33110);
var state_33127__$1 = (function (){var statearr_33129 = state_33127;
(statearr_33129[(7)] = inst_33109__$1);

return statearr_33129;
})();
if(inst_33111){
var statearr_33130_33155 = state_33127__$1;
(statearr_33130_33155[(1)] = (8));

} else {
var statearr_33131_33156 = state_33127__$1;
(statearr_33131_33156[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (1))){
var inst_33104 = (0);
var state_33127__$1 = (function (){var statearr_33132 = state_33127;
(statearr_33132[(8)] = inst_33104);

return statearr_33132;
})();
var statearr_33133_33157 = state_33127__$1;
(statearr_33133_33157[(2)] = null);

(statearr_33133_33157[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (4))){
var state_33127__$1 = state_33127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33127__$1,(7),ch);
} else {
if((state_val_33128 === (6))){
var inst_33122 = (state_33127[(2)]);
var state_33127__$1 = state_33127;
var statearr_33134_33158 = state_33127__$1;
(statearr_33134_33158[(2)] = inst_33122);

(statearr_33134_33158[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (3))){
var inst_33124 = (state_33127[(2)]);
var inst_33125 = cljs.core.async.close_BANG_(out);
var state_33127__$1 = (function (){var statearr_33135 = state_33127;
(statearr_33135[(9)] = inst_33124);

return statearr_33135;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33127__$1,inst_33125);
} else {
if((state_val_33128 === (2))){
var inst_33104 = (state_33127[(8)]);
var inst_33106 = (inst_33104 < n);
var state_33127__$1 = state_33127;
if(cljs.core.truth_(inst_33106)){
var statearr_33136_33159 = state_33127__$1;
(statearr_33136_33159[(1)] = (4));

} else {
var statearr_33137_33160 = state_33127__$1;
(statearr_33137_33160[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (11))){
var inst_33104 = (state_33127[(8)]);
var inst_33114 = (state_33127[(2)]);
var inst_33115 = (inst_33104 + (1));
var inst_33104__$1 = inst_33115;
var state_33127__$1 = (function (){var statearr_33138 = state_33127;
(statearr_33138[(10)] = inst_33114);

(statearr_33138[(8)] = inst_33104__$1);

return statearr_33138;
})();
var statearr_33139_33161 = state_33127__$1;
(statearr_33139_33161[(2)] = null);

(statearr_33139_33161[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (9))){
var state_33127__$1 = state_33127;
var statearr_33140_33162 = state_33127__$1;
(statearr_33140_33162[(2)] = null);

(statearr_33140_33162[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (5))){
var state_33127__$1 = state_33127;
var statearr_33141_33163 = state_33127__$1;
(statearr_33141_33163[(2)] = null);

(statearr_33141_33163[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (10))){
var inst_33119 = (state_33127[(2)]);
var state_33127__$1 = state_33127;
var statearr_33142_33164 = state_33127__$1;
(statearr_33142_33164[(2)] = inst_33119);

(statearr_33142_33164[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (8))){
var inst_33109 = (state_33127[(7)]);
var state_33127__$1 = state_33127;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33127__$1,(11),out,inst_33109);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33154,out))
;
return ((function (switch__12027__auto__,c__12139__auto___33154,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_33146 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33146[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_33146[(1)] = (1));

return statearr_33146;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_33127){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33127);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33147){if((e33147 instanceof Object)){
var ex__12031__auto__ = e33147;
var statearr_33148_33165 = state_33127;
(statearr_33148_33165[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33127);

return cljs.core.cst$kw$recur;
} else {
throw e33147;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33166 = state_33127;
state_33127 = G__33166;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_33127){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_33127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33154,out))
})();
var state__12141__auto__ = (function (){var statearr_33149 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33149[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33154);

return statearr_33149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33154,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33176 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33176 = (function (map_LT_,f,ch,meta33177){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33177 = meta33177;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33178,meta33177__$1){
var self__ = this;
var _33178__$1 = this;
return (new cljs.core.async.t_cljs$core$async33176(self__.map_LT_,self__.f,self__.ch,meta33177__$1));
});

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33178){
var self__ = this;
var _33178__$1 = this;
return self__.meta33177;
});

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33179 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33179 = (function (map_LT_,f,ch,meta33177,_,fn1,meta33180){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33177 = meta33177;
this._ = _;
this.fn1 = fn1;
this.meta33180 = meta33180;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33179.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33181,meta33180__$1){
var self__ = this;
var _33181__$1 = this;
return (new cljs.core.async.t_cljs$core$async33179(self__.map_LT_,self__.f,self__.ch,self__.meta33177,self__._,self__.fn1,meta33180__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33179.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33181){
var self__ = this;
var _33181__$1 = this;
return self__.meta33180;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33179.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33179.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33179.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33179.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33167_SHARP_){
var G__33182 = (((p1__33167_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33167_SHARP_) : self__.f.call(null,p1__33167_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33182) : f1.call(null,G__33182));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33179.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33177,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async33176], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta33180], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33179.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33179.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33179";

cljs.core.async.t_cljs$core$async33179.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33179");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33179 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33179(map_LT___$1,f__$1,ch__$1,meta33177__$1,___$2,fn1__$1,meta33180){
return (new cljs.core.async.t_cljs$core$async33179(map_LT___$1,f__$1,ch__$1,meta33177__$1,___$2,fn1__$1,meta33180));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33179(self__.map_LT_,self__.f,self__.ch,self__.meta33177,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33183 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33183) : self__.f.call(null,G__33183));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33176.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33176.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33177], null);
});

cljs.core.async.t_cljs$core$async33176.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33176.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33176";

cljs.core.async.t_cljs$core$async33176.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33176");
});

cljs.core.async.__GT_t_cljs$core$async33176 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33176(map_LT___$1,f__$1,ch__$1,meta33177){
return (new cljs.core.async.t_cljs$core$async33176(map_LT___$1,f__$1,ch__$1,meta33177));
});

}

return (new cljs.core.async.t_cljs$core$async33176(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33187 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33187 = (function (map_GT_,f,ch,meta33188){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta33188 = meta33188;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33189,meta33188__$1){
var self__ = this;
var _33189__$1 = this;
return (new cljs.core.async.t_cljs$core$async33187(self__.map_GT_,self__.f,self__.ch,meta33188__$1));
});

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33189){
var self__ = this;
var _33189__$1 = this;
return self__.meta33188;
});

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33187.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33187.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33188], null);
});

cljs.core.async.t_cljs$core$async33187.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33187.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33187";

cljs.core.async.t_cljs$core$async33187.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33187");
});

cljs.core.async.__GT_t_cljs$core$async33187 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33187(map_GT___$1,f__$1,ch__$1,meta33188){
return (new cljs.core.async.t_cljs$core$async33187(map_GT___$1,f__$1,ch__$1,meta33188));
});

}

return (new cljs.core.async.t_cljs$core$async33187(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33193 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33193 = (function (filter_GT_,p,ch,meta33194){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta33194 = meta33194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33195,meta33194__$1){
var self__ = this;
var _33195__$1 = this;
return (new cljs.core.async.t_cljs$core$async33193(self__.filter_GT_,self__.p,self__.ch,meta33194__$1));
});

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33195){
var self__ = this;
var _33195__$1 = this;
return self__.meta33194;
});

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33193.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33193.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33194], null);
});

cljs.core.async.t_cljs$core$async33193.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33193";

cljs.core.async.t_cljs$core$async33193.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33193");
});

cljs.core.async.__GT_t_cljs$core$async33193 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33193(filter_GT___$1,p__$1,ch__$1,meta33194){
return (new cljs.core.async.t_cljs$core$async33193(filter_GT___$1,p__$1,ch__$1,meta33194));
});

}

return (new cljs.core.async.t_cljs$core$async33193(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33196 = [];
var len__7484__auto___33240 = arguments.length;
var i__7485__auto___33241 = (0);
while(true){
if((i__7485__auto___33241 < len__7484__auto___33240)){
args33196.push((arguments[i__7485__auto___33241]));

var G__33242 = (i__7485__auto___33241 + (1));
i__7485__auto___33241 = G__33242;
continue;
} else {
}
break;
}

var G__33198 = args33196.length;
switch (G__33198) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33196.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___33244 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33244,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33244,out){
return (function (state_33219){
var state_val_33220 = (state_33219[(1)]);
if((state_val_33220 === (7))){
var inst_33215 = (state_33219[(2)]);
var state_33219__$1 = state_33219;
var statearr_33221_33245 = state_33219__$1;
(statearr_33221_33245[(2)] = inst_33215);

(statearr_33221_33245[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (1))){
var state_33219__$1 = state_33219;
var statearr_33222_33246 = state_33219__$1;
(statearr_33222_33246[(2)] = null);

(statearr_33222_33246[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (4))){
var inst_33201 = (state_33219[(7)]);
var inst_33201__$1 = (state_33219[(2)]);
var inst_33202 = (inst_33201__$1 == null);
var state_33219__$1 = (function (){var statearr_33223 = state_33219;
(statearr_33223[(7)] = inst_33201__$1);

return statearr_33223;
})();
if(cljs.core.truth_(inst_33202)){
var statearr_33224_33247 = state_33219__$1;
(statearr_33224_33247[(1)] = (5));

} else {
var statearr_33225_33248 = state_33219__$1;
(statearr_33225_33248[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (6))){
var inst_33201 = (state_33219[(7)]);
var inst_33206 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33201) : p.call(null,inst_33201));
var state_33219__$1 = state_33219;
if(cljs.core.truth_(inst_33206)){
var statearr_33226_33249 = state_33219__$1;
(statearr_33226_33249[(1)] = (8));

} else {
var statearr_33227_33250 = state_33219__$1;
(statearr_33227_33250[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (3))){
var inst_33217 = (state_33219[(2)]);
var state_33219__$1 = state_33219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33219__$1,inst_33217);
} else {
if((state_val_33220 === (2))){
var state_33219__$1 = state_33219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33219__$1,(4),ch);
} else {
if((state_val_33220 === (11))){
var inst_33209 = (state_33219[(2)]);
var state_33219__$1 = state_33219;
var statearr_33228_33251 = state_33219__$1;
(statearr_33228_33251[(2)] = inst_33209);

(statearr_33228_33251[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (9))){
var state_33219__$1 = state_33219;
var statearr_33229_33252 = state_33219__$1;
(statearr_33229_33252[(2)] = null);

(statearr_33229_33252[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (5))){
var inst_33204 = cljs.core.async.close_BANG_(out);
var state_33219__$1 = state_33219;
var statearr_33230_33253 = state_33219__$1;
(statearr_33230_33253[(2)] = inst_33204);

(statearr_33230_33253[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (10))){
var inst_33212 = (state_33219[(2)]);
var state_33219__$1 = (function (){var statearr_33231 = state_33219;
(statearr_33231[(8)] = inst_33212);

return statearr_33231;
})();
var statearr_33232_33254 = state_33219__$1;
(statearr_33232_33254[(2)] = null);

(statearr_33232_33254[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33220 === (8))){
var inst_33201 = (state_33219[(7)]);
var state_33219__$1 = state_33219;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33219__$1,(11),out,inst_33201);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33244,out))
;
return ((function (switch__12027__auto__,c__12139__auto___33244,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_33236 = [null,null,null,null,null,null,null,null,null];
(statearr_33236[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_33236[(1)] = (1));

return statearr_33236;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_33219){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33219);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33237){if((e33237 instanceof Object)){
var ex__12031__auto__ = e33237;
var statearr_33238_33255 = state_33219;
(statearr_33238_33255[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33219);

return cljs.core.cst$kw$recur;
} else {
throw e33237;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33256 = state_33219;
state_33219 = G__33256;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_33219){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_33219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33244,out))
})();
var state__12141__auto__ = (function (){var statearr_33239 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33239[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33244);

return statearr_33239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33244,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args33257 = [];
var len__7484__auto___33260 = arguments.length;
var i__7485__auto___33261 = (0);
while(true){
if((i__7485__auto___33261 < len__7484__auto___33260)){
args33257.push((arguments[i__7485__auto___33261]));

var G__33262 = (i__7485__auto___33261 + (1));
i__7485__auto___33261 = G__33262;
continue;
} else {
}
break;
}

var G__33259 = args33257.length;
switch (G__33259) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33257.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12139__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto__){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto__){
return (function (state_33429){
var state_val_33430 = (state_33429[(1)]);
if((state_val_33430 === (7))){
var inst_33425 = (state_33429[(2)]);
var state_33429__$1 = state_33429;
var statearr_33431_33472 = state_33429__$1;
(statearr_33431_33472[(2)] = inst_33425);

(statearr_33431_33472[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (20))){
var inst_33395 = (state_33429[(7)]);
var inst_33406 = (state_33429[(2)]);
var inst_33407 = cljs.core.next(inst_33395);
var inst_33381 = inst_33407;
var inst_33382 = null;
var inst_33383 = (0);
var inst_33384 = (0);
var state_33429__$1 = (function (){var statearr_33432 = state_33429;
(statearr_33432[(8)] = inst_33383);

(statearr_33432[(9)] = inst_33406);

(statearr_33432[(10)] = inst_33384);

(statearr_33432[(11)] = inst_33382);

(statearr_33432[(12)] = inst_33381);

return statearr_33432;
})();
var statearr_33433_33473 = state_33429__$1;
(statearr_33433_33473[(2)] = null);

(statearr_33433_33473[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (1))){
var state_33429__$1 = state_33429;
var statearr_33434_33474 = state_33429__$1;
(statearr_33434_33474[(2)] = null);

(statearr_33434_33474[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (4))){
var inst_33370 = (state_33429[(13)]);
var inst_33370__$1 = (state_33429[(2)]);
var inst_33371 = (inst_33370__$1 == null);
var state_33429__$1 = (function (){var statearr_33435 = state_33429;
(statearr_33435[(13)] = inst_33370__$1);

return statearr_33435;
})();
if(cljs.core.truth_(inst_33371)){
var statearr_33436_33475 = state_33429__$1;
(statearr_33436_33475[(1)] = (5));

} else {
var statearr_33437_33476 = state_33429__$1;
(statearr_33437_33476[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (15))){
var state_33429__$1 = state_33429;
var statearr_33441_33477 = state_33429__$1;
(statearr_33441_33477[(2)] = null);

(statearr_33441_33477[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (21))){
var state_33429__$1 = state_33429;
var statearr_33442_33478 = state_33429__$1;
(statearr_33442_33478[(2)] = null);

(statearr_33442_33478[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (13))){
var inst_33383 = (state_33429[(8)]);
var inst_33384 = (state_33429[(10)]);
var inst_33382 = (state_33429[(11)]);
var inst_33381 = (state_33429[(12)]);
var inst_33391 = (state_33429[(2)]);
var inst_33392 = (inst_33384 + (1));
var tmp33438 = inst_33383;
var tmp33439 = inst_33382;
var tmp33440 = inst_33381;
var inst_33381__$1 = tmp33440;
var inst_33382__$1 = tmp33439;
var inst_33383__$1 = tmp33438;
var inst_33384__$1 = inst_33392;
var state_33429__$1 = (function (){var statearr_33443 = state_33429;
(statearr_33443[(8)] = inst_33383__$1);

(statearr_33443[(14)] = inst_33391);

(statearr_33443[(10)] = inst_33384__$1);

(statearr_33443[(11)] = inst_33382__$1);

(statearr_33443[(12)] = inst_33381__$1);

return statearr_33443;
})();
var statearr_33444_33479 = state_33429__$1;
(statearr_33444_33479[(2)] = null);

(statearr_33444_33479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (22))){
var state_33429__$1 = state_33429;
var statearr_33445_33480 = state_33429__$1;
(statearr_33445_33480[(2)] = null);

(statearr_33445_33480[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (6))){
var inst_33370 = (state_33429[(13)]);
var inst_33379 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33370) : f.call(null,inst_33370));
var inst_33380 = cljs.core.seq(inst_33379);
var inst_33381 = inst_33380;
var inst_33382 = null;
var inst_33383 = (0);
var inst_33384 = (0);
var state_33429__$1 = (function (){var statearr_33446 = state_33429;
(statearr_33446[(8)] = inst_33383);

(statearr_33446[(10)] = inst_33384);

(statearr_33446[(11)] = inst_33382);

(statearr_33446[(12)] = inst_33381);

return statearr_33446;
})();
var statearr_33447_33481 = state_33429__$1;
(statearr_33447_33481[(2)] = null);

(statearr_33447_33481[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (17))){
var inst_33395 = (state_33429[(7)]);
var inst_33399 = cljs.core.chunk_first(inst_33395);
var inst_33400 = cljs.core.chunk_rest(inst_33395);
var inst_33401 = cljs.core.count(inst_33399);
var inst_33381 = inst_33400;
var inst_33382 = inst_33399;
var inst_33383 = inst_33401;
var inst_33384 = (0);
var state_33429__$1 = (function (){var statearr_33448 = state_33429;
(statearr_33448[(8)] = inst_33383);

(statearr_33448[(10)] = inst_33384);

(statearr_33448[(11)] = inst_33382);

(statearr_33448[(12)] = inst_33381);

return statearr_33448;
})();
var statearr_33449_33482 = state_33429__$1;
(statearr_33449_33482[(2)] = null);

(statearr_33449_33482[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (3))){
var inst_33427 = (state_33429[(2)]);
var state_33429__$1 = state_33429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33429__$1,inst_33427);
} else {
if((state_val_33430 === (12))){
var inst_33415 = (state_33429[(2)]);
var state_33429__$1 = state_33429;
var statearr_33450_33483 = state_33429__$1;
(statearr_33450_33483[(2)] = inst_33415);

(statearr_33450_33483[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (2))){
var state_33429__$1 = state_33429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33429__$1,(4),in$);
} else {
if((state_val_33430 === (23))){
var inst_33423 = (state_33429[(2)]);
var state_33429__$1 = state_33429;
var statearr_33451_33484 = state_33429__$1;
(statearr_33451_33484[(2)] = inst_33423);

(statearr_33451_33484[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (19))){
var inst_33410 = (state_33429[(2)]);
var state_33429__$1 = state_33429;
var statearr_33452_33485 = state_33429__$1;
(statearr_33452_33485[(2)] = inst_33410);

(statearr_33452_33485[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (11))){
var inst_33395 = (state_33429[(7)]);
var inst_33381 = (state_33429[(12)]);
var inst_33395__$1 = cljs.core.seq(inst_33381);
var state_33429__$1 = (function (){var statearr_33453 = state_33429;
(statearr_33453[(7)] = inst_33395__$1);

return statearr_33453;
})();
if(inst_33395__$1){
var statearr_33454_33486 = state_33429__$1;
(statearr_33454_33486[(1)] = (14));

} else {
var statearr_33455_33487 = state_33429__$1;
(statearr_33455_33487[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (9))){
var inst_33417 = (state_33429[(2)]);
var inst_33418 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33429__$1 = (function (){var statearr_33456 = state_33429;
(statearr_33456[(15)] = inst_33417);

return statearr_33456;
})();
if(cljs.core.truth_(inst_33418)){
var statearr_33457_33488 = state_33429__$1;
(statearr_33457_33488[(1)] = (21));

} else {
var statearr_33458_33489 = state_33429__$1;
(statearr_33458_33489[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (5))){
var inst_33373 = cljs.core.async.close_BANG_(out);
var state_33429__$1 = state_33429;
var statearr_33459_33490 = state_33429__$1;
(statearr_33459_33490[(2)] = inst_33373);

(statearr_33459_33490[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (14))){
var inst_33395 = (state_33429[(7)]);
var inst_33397 = cljs.core.chunked_seq_QMARK_(inst_33395);
var state_33429__$1 = state_33429;
if(inst_33397){
var statearr_33460_33491 = state_33429__$1;
(statearr_33460_33491[(1)] = (17));

} else {
var statearr_33461_33492 = state_33429__$1;
(statearr_33461_33492[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (16))){
var inst_33413 = (state_33429[(2)]);
var state_33429__$1 = state_33429;
var statearr_33462_33493 = state_33429__$1;
(statearr_33462_33493[(2)] = inst_33413);

(statearr_33462_33493[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33430 === (10))){
var inst_33384 = (state_33429[(10)]);
var inst_33382 = (state_33429[(11)]);
var inst_33389 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33382,inst_33384);
var state_33429__$1 = state_33429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33429__$1,(13),out,inst_33389);
} else {
if((state_val_33430 === (18))){
var inst_33395 = (state_33429[(7)]);
var inst_33404 = cljs.core.first(inst_33395);
var state_33429__$1 = state_33429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33429__$1,(20),out,inst_33404);
} else {
if((state_val_33430 === (8))){
var inst_33383 = (state_33429[(8)]);
var inst_33384 = (state_33429[(10)]);
var inst_33386 = (inst_33384 < inst_33383);
var inst_33387 = inst_33386;
var state_33429__$1 = state_33429;
if(cljs.core.truth_(inst_33387)){
var statearr_33463_33494 = state_33429__$1;
(statearr_33463_33494[(1)] = (10));

} else {
var statearr_33464_33495 = state_33429__$1;
(statearr_33464_33495[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto__))
;
return ((function (switch__12027__auto__,c__12139__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0 = (function (){
var statearr_33468 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33468[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__);

(statearr_33468[(1)] = (1));

return statearr_33468;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1 = (function (state_33429){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33429);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33469){if((e33469 instanceof Object)){
var ex__12031__auto__ = e33469;
var statearr_33470_33496 = state_33429;
(statearr_33470_33496[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33429);

return cljs.core.cst$kw$recur;
} else {
throw e33469;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33497 = state_33429;
state_33429 = G__33497;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__ = function(state_33429){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1.call(this,state_33429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12028__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto__))
})();
var state__12141__auto__ = (function (){var statearr_33471 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33471[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto__);

return statearr_33471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto__))
);

return c__12139__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args33498 = [];
var len__7484__auto___33501 = arguments.length;
var i__7485__auto___33502 = (0);
while(true){
if((i__7485__auto___33502 < len__7484__auto___33501)){
args33498.push((arguments[i__7485__auto___33502]));

var G__33503 = (i__7485__auto___33502 + (1));
i__7485__auto___33502 = G__33503;
continue;
} else {
}
break;
}

var G__33500 = args33498.length;
switch (G__33500) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33498.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args33505 = [];
var len__7484__auto___33508 = arguments.length;
var i__7485__auto___33509 = (0);
while(true){
if((i__7485__auto___33509 < len__7484__auto___33508)){
args33505.push((arguments[i__7485__auto___33509]));

var G__33510 = (i__7485__auto___33509 + (1));
i__7485__auto___33509 = G__33510;
continue;
} else {
}
break;
}

var G__33507 = args33505.length;
switch (G__33507) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33505.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args33512 = [];
var len__7484__auto___33563 = arguments.length;
var i__7485__auto___33564 = (0);
while(true){
if((i__7485__auto___33564 < len__7484__auto___33563)){
args33512.push((arguments[i__7485__auto___33564]));

var G__33565 = (i__7485__auto___33564 + (1));
i__7485__auto___33564 = G__33565;
continue;
} else {
}
break;
}

var G__33514 = args33512.length;
switch (G__33514) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33512.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___33567 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33567,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33567,out){
return (function (state_33538){
var state_val_33539 = (state_33538[(1)]);
if((state_val_33539 === (7))){
var inst_33533 = (state_33538[(2)]);
var state_33538__$1 = state_33538;
var statearr_33540_33568 = state_33538__$1;
(statearr_33540_33568[(2)] = inst_33533);

(statearr_33540_33568[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (1))){
var inst_33515 = null;
var state_33538__$1 = (function (){var statearr_33541 = state_33538;
(statearr_33541[(7)] = inst_33515);

return statearr_33541;
})();
var statearr_33542_33569 = state_33538__$1;
(statearr_33542_33569[(2)] = null);

(statearr_33542_33569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (4))){
var inst_33518 = (state_33538[(8)]);
var inst_33518__$1 = (state_33538[(2)]);
var inst_33519 = (inst_33518__$1 == null);
var inst_33520 = cljs.core.not(inst_33519);
var state_33538__$1 = (function (){var statearr_33543 = state_33538;
(statearr_33543[(8)] = inst_33518__$1);

return statearr_33543;
})();
if(inst_33520){
var statearr_33544_33570 = state_33538__$1;
(statearr_33544_33570[(1)] = (5));

} else {
var statearr_33545_33571 = state_33538__$1;
(statearr_33545_33571[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (6))){
var state_33538__$1 = state_33538;
var statearr_33546_33572 = state_33538__$1;
(statearr_33546_33572[(2)] = null);

(statearr_33546_33572[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (3))){
var inst_33535 = (state_33538[(2)]);
var inst_33536 = cljs.core.async.close_BANG_(out);
var state_33538__$1 = (function (){var statearr_33547 = state_33538;
(statearr_33547[(9)] = inst_33535);

return statearr_33547;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33538__$1,inst_33536);
} else {
if((state_val_33539 === (2))){
var state_33538__$1 = state_33538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33538__$1,(4),ch);
} else {
if((state_val_33539 === (11))){
var inst_33518 = (state_33538[(8)]);
var inst_33527 = (state_33538[(2)]);
var inst_33515 = inst_33518;
var state_33538__$1 = (function (){var statearr_33548 = state_33538;
(statearr_33548[(7)] = inst_33515);

(statearr_33548[(10)] = inst_33527);

return statearr_33548;
})();
var statearr_33549_33573 = state_33538__$1;
(statearr_33549_33573[(2)] = null);

(statearr_33549_33573[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (9))){
var inst_33518 = (state_33538[(8)]);
var state_33538__$1 = state_33538;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33538__$1,(11),out,inst_33518);
} else {
if((state_val_33539 === (5))){
var inst_33518 = (state_33538[(8)]);
var inst_33515 = (state_33538[(7)]);
var inst_33522 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33518,inst_33515);
var state_33538__$1 = state_33538;
if(inst_33522){
var statearr_33551_33574 = state_33538__$1;
(statearr_33551_33574[(1)] = (8));

} else {
var statearr_33552_33575 = state_33538__$1;
(statearr_33552_33575[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (10))){
var inst_33530 = (state_33538[(2)]);
var state_33538__$1 = state_33538;
var statearr_33553_33576 = state_33538__$1;
(statearr_33553_33576[(2)] = inst_33530);

(statearr_33553_33576[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33539 === (8))){
var inst_33515 = (state_33538[(7)]);
var tmp33550 = inst_33515;
var inst_33515__$1 = tmp33550;
var state_33538__$1 = (function (){var statearr_33554 = state_33538;
(statearr_33554[(7)] = inst_33515__$1);

return statearr_33554;
})();
var statearr_33555_33577 = state_33538__$1;
(statearr_33555_33577[(2)] = null);

(statearr_33555_33577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33567,out))
;
return ((function (switch__12027__auto__,c__12139__auto___33567,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_33559 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33559[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_33559[(1)] = (1));

return statearr_33559;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_33538){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33538);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33560){if((e33560 instanceof Object)){
var ex__12031__auto__ = e33560;
var statearr_33561_33578 = state_33538;
(statearr_33561_33578[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33538);

return cljs.core.cst$kw$recur;
} else {
throw e33560;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33579 = state_33538;
state_33538 = G__33579;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_33538){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_33538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33567,out))
})();
var state__12141__auto__ = (function (){var statearr_33562 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33562[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33567);

return statearr_33562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33567,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33580 = [];
var len__7484__auto___33650 = arguments.length;
var i__7485__auto___33651 = (0);
while(true){
if((i__7485__auto___33651 < len__7484__auto___33650)){
args33580.push((arguments[i__7485__auto___33651]));

var G__33652 = (i__7485__auto___33651 + (1));
i__7485__auto___33651 = G__33652;
continue;
} else {
}
break;
}

var G__33582 = args33580.length;
switch (G__33582) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33580.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___33654 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33654,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33654,out){
return (function (state_33620){
var state_val_33621 = (state_33620[(1)]);
if((state_val_33621 === (7))){
var inst_33616 = (state_33620[(2)]);
var state_33620__$1 = state_33620;
var statearr_33622_33655 = state_33620__$1;
(statearr_33622_33655[(2)] = inst_33616);

(statearr_33622_33655[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (1))){
var inst_33583 = (new Array(n));
var inst_33584 = inst_33583;
var inst_33585 = (0);
var state_33620__$1 = (function (){var statearr_33623 = state_33620;
(statearr_33623[(7)] = inst_33584);

(statearr_33623[(8)] = inst_33585);

return statearr_33623;
})();
var statearr_33624_33656 = state_33620__$1;
(statearr_33624_33656[(2)] = null);

(statearr_33624_33656[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (4))){
var inst_33588 = (state_33620[(9)]);
var inst_33588__$1 = (state_33620[(2)]);
var inst_33589 = (inst_33588__$1 == null);
var inst_33590 = cljs.core.not(inst_33589);
var state_33620__$1 = (function (){var statearr_33625 = state_33620;
(statearr_33625[(9)] = inst_33588__$1);

return statearr_33625;
})();
if(inst_33590){
var statearr_33626_33657 = state_33620__$1;
(statearr_33626_33657[(1)] = (5));

} else {
var statearr_33627_33658 = state_33620__$1;
(statearr_33627_33658[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (15))){
var inst_33610 = (state_33620[(2)]);
var state_33620__$1 = state_33620;
var statearr_33628_33659 = state_33620__$1;
(statearr_33628_33659[(2)] = inst_33610);

(statearr_33628_33659[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (13))){
var state_33620__$1 = state_33620;
var statearr_33629_33660 = state_33620__$1;
(statearr_33629_33660[(2)] = null);

(statearr_33629_33660[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (6))){
var inst_33585 = (state_33620[(8)]);
var inst_33606 = (inst_33585 > (0));
var state_33620__$1 = state_33620;
if(cljs.core.truth_(inst_33606)){
var statearr_33630_33661 = state_33620__$1;
(statearr_33630_33661[(1)] = (12));

} else {
var statearr_33631_33662 = state_33620__$1;
(statearr_33631_33662[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (3))){
var inst_33618 = (state_33620[(2)]);
var state_33620__$1 = state_33620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33620__$1,inst_33618);
} else {
if((state_val_33621 === (12))){
var inst_33584 = (state_33620[(7)]);
var inst_33608 = cljs.core.vec(inst_33584);
var state_33620__$1 = state_33620;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33620__$1,(15),out,inst_33608);
} else {
if((state_val_33621 === (2))){
var state_33620__$1 = state_33620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33620__$1,(4),ch);
} else {
if((state_val_33621 === (11))){
var inst_33600 = (state_33620[(2)]);
var inst_33601 = (new Array(n));
var inst_33584 = inst_33601;
var inst_33585 = (0);
var state_33620__$1 = (function (){var statearr_33632 = state_33620;
(statearr_33632[(7)] = inst_33584);

(statearr_33632[(10)] = inst_33600);

(statearr_33632[(8)] = inst_33585);

return statearr_33632;
})();
var statearr_33633_33663 = state_33620__$1;
(statearr_33633_33663[(2)] = null);

(statearr_33633_33663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (9))){
var inst_33584 = (state_33620[(7)]);
var inst_33598 = cljs.core.vec(inst_33584);
var state_33620__$1 = state_33620;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33620__$1,(11),out,inst_33598);
} else {
if((state_val_33621 === (5))){
var inst_33588 = (state_33620[(9)]);
var inst_33593 = (state_33620[(11)]);
var inst_33584 = (state_33620[(7)]);
var inst_33585 = (state_33620[(8)]);
var inst_33592 = (inst_33584[inst_33585] = inst_33588);
var inst_33593__$1 = (inst_33585 + (1));
var inst_33594 = (inst_33593__$1 < n);
var state_33620__$1 = (function (){var statearr_33634 = state_33620;
(statearr_33634[(11)] = inst_33593__$1);

(statearr_33634[(12)] = inst_33592);

return statearr_33634;
})();
if(cljs.core.truth_(inst_33594)){
var statearr_33635_33664 = state_33620__$1;
(statearr_33635_33664[(1)] = (8));

} else {
var statearr_33636_33665 = state_33620__$1;
(statearr_33636_33665[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (14))){
var inst_33613 = (state_33620[(2)]);
var inst_33614 = cljs.core.async.close_BANG_(out);
var state_33620__$1 = (function (){var statearr_33638 = state_33620;
(statearr_33638[(13)] = inst_33613);

return statearr_33638;
})();
var statearr_33639_33666 = state_33620__$1;
(statearr_33639_33666[(2)] = inst_33614);

(statearr_33639_33666[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (10))){
var inst_33604 = (state_33620[(2)]);
var state_33620__$1 = state_33620;
var statearr_33640_33667 = state_33620__$1;
(statearr_33640_33667[(2)] = inst_33604);

(statearr_33640_33667[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33621 === (8))){
var inst_33593 = (state_33620[(11)]);
var inst_33584 = (state_33620[(7)]);
var tmp33637 = inst_33584;
var inst_33584__$1 = tmp33637;
var inst_33585 = inst_33593;
var state_33620__$1 = (function (){var statearr_33641 = state_33620;
(statearr_33641[(7)] = inst_33584__$1);

(statearr_33641[(8)] = inst_33585);

return statearr_33641;
})();
var statearr_33642_33668 = state_33620__$1;
(statearr_33642_33668[(2)] = null);

(statearr_33642_33668[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33654,out))
;
return ((function (switch__12027__auto__,c__12139__auto___33654,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_33646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33646[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_33646[(1)] = (1));

return statearr_33646;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_33620){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33620);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33647){if((e33647 instanceof Object)){
var ex__12031__auto__ = e33647;
var statearr_33648_33669 = state_33620;
(statearr_33648_33669[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33620);

return cljs.core.cst$kw$recur;
} else {
throw e33647;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33670 = state_33620;
state_33620 = G__33670;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_33620){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_33620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33654,out))
})();
var state__12141__auto__ = (function (){var statearr_33649 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33649[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33654);

return statearr_33649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33654,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args33671 = [];
var len__7484__auto___33745 = arguments.length;
var i__7485__auto___33746 = (0);
while(true){
if((i__7485__auto___33746 < len__7484__auto___33745)){
args33671.push((arguments[i__7485__auto___33746]));

var G__33747 = (i__7485__auto___33746 + (1));
i__7485__auto___33746 = G__33747;
continue;
} else {
}
break;
}

var G__33673 = args33671.length;
switch (G__33673) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33671.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12139__auto___33749 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12139__auto___33749,out){
return (function (){
var f__12140__auto__ = (function (){var switch__12027__auto__ = ((function (c__12139__auto___33749,out){
return (function (state_33715){
var state_val_33716 = (state_33715[(1)]);
if((state_val_33716 === (7))){
var inst_33711 = (state_33715[(2)]);
var state_33715__$1 = state_33715;
var statearr_33717_33750 = state_33715__$1;
(statearr_33717_33750[(2)] = inst_33711);

(statearr_33717_33750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (1))){
var inst_33674 = [];
var inst_33675 = inst_33674;
var inst_33676 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_33715__$1 = (function (){var statearr_33718 = state_33715;
(statearr_33718[(7)] = inst_33676);

(statearr_33718[(8)] = inst_33675);

return statearr_33718;
})();
var statearr_33719_33751 = state_33715__$1;
(statearr_33719_33751[(2)] = null);

(statearr_33719_33751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (4))){
var inst_33679 = (state_33715[(9)]);
var inst_33679__$1 = (state_33715[(2)]);
var inst_33680 = (inst_33679__$1 == null);
var inst_33681 = cljs.core.not(inst_33680);
var state_33715__$1 = (function (){var statearr_33720 = state_33715;
(statearr_33720[(9)] = inst_33679__$1);

return statearr_33720;
})();
if(inst_33681){
var statearr_33721_33752 = state_33715__$1;
(statearr_33721_33752[(1)] = (5));

} else {
var statearr_33722_33753 = state_33715__$1;
(statearr_33722_33753[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (15))){
var inst_33705 = (state_33715[(2)]);
var state_33715__$1 = state_33715;
var statearr_33723_33754 = state_33715__$1;
(statearr_33723_33754[(2)] = inst_33705);

(statearr_33723_33754[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (13))){
var state_33715__$1 = state_33715;
var statearr_33724_33755 = state_33715__$1;
(statearr_33724_33755[(2)] = null);

(statearr_33724_33755[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (6))){
var inst_33675 = (state_33715[(8)]);
var inst_33700 = inst_33675.length;
var inst_33701 = (inst_33700 > (0));
var state_33715__$1 = state_33715;
if(cljs.core.truth_(inst_33701)){
var statearr_33725_33756 = state_33715__$1;
(statearr_33725_33756[(1)] = (12));

} else {
var statearr_33726_33757 = state_33715__$1;
(statearr_33726_33757[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (3))){
var inst_33713 = (state_33715[(2)]);
var state_33715__$1 = state_33715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33715__$1,inst_33713);
} else {
if((state_val_33716 === (12))){
var inst_33675 = (state_33715[(8)]);
var inst_33703 = cljs.core.vec(inst_33675);
var state_33715__$1 = state_33715;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33715__$1,(15),out,inst_33703);
} else {
if((state_val_33716 === (2))){
var state_33715__$1 = state_33715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33715__$1,(4),ch);
} else {
if((state_val_33716 === (11))){
var inst_33679 = (state_33715[(9)]);
var inst_33683 = (state_33715[(10)]);
var inst_33693 = (state_33715[(2)]);
var inst_33694 = [];
var inst_33695 = inst_33694.push(inst_33679);
var inst_33675 = inst_33694;
var inst_33676 = inst_33683;
var state_33715__$1 = (function (){var statearr_33727 = state_33715;
(statearr_33727[(7)] = inst_33676);

(statearr_33727[(11)] = inst_33693);

(statearr_33727[(8)] = inst_33675);

(statearr_33727[(12)] = inst_33695);

return statearr_33727;
})();
var statearr_33728_33758 = state_33715__$1;
(statearr_33728_33758[(2)] = null);

(statearr_33728_33758[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (9))){
var inst_33675 = (state_33715[(8)]);
var inst_33691 = cljs.core.vec(inst_33675);
var state_33715__$1 = state_33715;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33715__$1,(11),out,inst_33691);
} else {
if((state_val_33716 === (5))){
var inst_33679 = (state_33715[(9)]);
var inst_33676 = (state_33715[(7)]);
var inst_33683 = (state_33715[(10)]);
var inst_33683__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33679) : f.call(null,inst_33679));
var inst_33684 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33683__$1,inst_33676);
var inst_33685 = cljs.core.keyword_identical_QMARK_(inst_33676,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_33686 = (inst_33684) || (inst_33685);
var state_33715__$1 = (function (){var statearr_33729 = state_33715;
(statearr_33729[(10)] = inst_33683__$1);

return statearr_33729;
})();
if(cljs.core.truth_(inst_33686)){
var statearr_33730_33759 = state_33715__$1;
(statearr_33730_33759[(1)] = (8));

} else {
var statearr_33731_33760 = state_33715__$1;
(statearr_33731_33760[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (14))){
var inst_33708 = (state_33715[(2)]);
var inst_33709 = cljs.core.async.close_BANG_(out);
var state_33715__$1 = (function (){var statearr_33733 = state_33715;
(statearr_33733[(13)] = inst_33708);

return statearr_33733;
})();
var statearr_33734_33761 = state_33715__$1;
(statearr_33734_33761[(2)] = inst_33709);

(statearr_33734_33761[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (10))){
var inst_33698 = (state_33715[(2)]);
var state_33715__$1 = state_33715;
var statearr_33735_33762 = state_33715__$1;
(statearr_33735_33762[(2)] = inst_33698);

(statearr_33735_33762[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33716 === (8))){
var inst_33679 = (state_33715[(9)]);
var inst_33675 = (state_33715[(8)]);
var inst_33683 = (state_33715[(10)]);
var inst_33688 = inst_33675.push(inst_33679);
var tmp33732 = inst_33675;
var inst_33675__$1 = tmp33732;
var inst_33676 = inst_33683;
var state_33715__$1 = (function (){var statearr_33736 = state_33715;
(statearr_33736[(7)] = inst_33676);

(statearr_33736[(14)] = inst_33688);

(statearr_33736[(8)] = inst_33675__$1);

return statearr_33736;
})();
var statearr_33737_33763 = state_33715__$1;
(statearr_33737_33763[(2)] = null);

(statearr_33737_33763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12139__auto___33749,out))
;
return ((function (switch__12027__auto__,c__12139__auto___33749,out){
return (function() {
var cljs$core$async$state_machine__12028__auto__ = null;
var cljs$core$async$state_machine__12028__auto____0 = (function (){
var statearr_33741 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33741[(0)] = cljs$core$async$state_machine__12028__auto__);

(statearr_33741[(1)] = (1));

return statearr_33741;
});
var cljs$core$async$state_machine__12028__auto____1 = (function (state_33715){
while(true){
var ret_value__12029__auto__ = (function (){try{while(true){
var result__12030__auto__ = switch__12027__auto__(state_33715);
if(cljs.core.keyword_identical_QMARK_(result__12030__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12030__auto__;
}
break;
}
}catch (e33742){if((e33742 instanceof Object)){
var ex__12031__auto__ = e33742;
var statearr_33743_33764 = state_33715;
(statearr_33743_33764[(5)] = ex__12031__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33715);

return cljs.core.cst$kw$recur;
} else {
throw e33742;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12029__auto__,cljs.core.cst$kw$recur)){
var G__33765 = state_33715;
state_33715 = G__33765;
continue;
} else {
return ret_value__12029__auto__;
}
break;
}
});
cljs$core$async$state_machine__12028__auto__ = function(state_33715){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12028__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12028__auto____1.call(this,state_33715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12028__auto____0;
cljs$core$async$state_machine__12028__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12028__auto____1;
return cljs$core$async$state_machine__12028__auto__;
})()
;})(switch__12027__auto__,c__12139__auto___33749,out))
})();
var state__12141__auto__ = (function (){var statearr_33744 = (f__12140__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12140__auto__.cljs$core$IFn$_invoke$arity$0() : f__12140__auto__.call(null));
(statearr_33744[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12139__auto___33749);

return statearr_33744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12141__auto__);
});})(c__12139__auto___33749,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

