// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e30888){if((e30888 instanceof Error)){
var _ = e30888;
return string;
} else {
throw e30888;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30891 = arguments.length;
var i__7485__auto___30892 = (0);
while(true){
if((i__7485__auto___30892 < len__7484__auto___30891)){
args__7491__auto__.push((arguments[i__7485__auto___30892]));

var G__30893 = (i__7485__auto___30892 + (1));
i__7485__auto___30892 = G__30893;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq30889){
var G__30890 = cljs.core.first(seq30889);
var seq30889__$1 = cljs.core.next(seq30889);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__30890,seq30889__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7491__auto__ = [];
var len__7484__auto___30899 = arguments.length;
var i__7485__auto___30900 = (0);
while(true){
if((i__7485__auto___30900 < len__7484__auto___30899)){
args__7491__auto__.push((arguments[i__7485__auto___30900]));

var G__30901 = (i__7485__auto___30900 + (1));
i__7485__auto___30900 = G__30901;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__30896){
var map__30897 = p__30896;
var map__30897__$1 = ((((!((map__30897 == null)))?((((map__30897.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30897.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30897):map__30897);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__30897__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq30894){
var G__30895 = cljs.core.first(seq30894);
var seq30894__$1 = cljs.core.next(seq30894);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__30895,seq30894__$1);
});

