// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.layout.histogram');
goog.require('cljs.core');
goog.require('c2.maths');
c2.layout.histogram.binary_search = (function c2$layout$histogram$binary_search(v,target){

var low = (0);
var high = (cljs.core.count(v) - (1));
while(true){
if((low > high)){
return (- (low + (1)));
} else {
var mid = cljs.core.quot((low + high),(2));
var mid_val = (v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(mid) : v.call(null,mid));
if((mid_val < target)){
var G__38698 = (mid + (1));
var G__38699 = high;
low = G__38698;
high = G__38699;
continue;
} else {
if((target < mid_val)){
var G__38700 = low;
var G__38701 = (mid - (1));
low = G__38700;
high = G__38701;
continue;
} else {
return mid;

}
}
}
break;
}
});
/**
 * Calulate reasonable number of bins assuming an approximately normal
 *   distribution
 */
c2.layout.histogram.sturges = (function c2$layout$histogram$sturges(values){
return ((c2.maths.log.cljs$core$IFn$_invoke$arity$2(cljs.core.count(values),(2)) | (0)) + (1));
});
/**
 * Return the inclusive upper threshold of all bins
 */
c2.layout.histogram.fixed_size_bins = (function c2$layout$histogram$fixed_size_bins(p__38702,n){
var vec__38712 = p__38702;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38712,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38712,(1),null);
var size = ((mx - mn) / n);
return cljs.core.vec((function (){var iter__7189__auto__ = ((function (size,vec__38712,mn,mx){
return (function c2$layout$histogram$fixed_size_bins_$_iter__38715(s__38716){
return (new cljs.core.LazySeq(null,((function (size,vec__38712,mn,mx){
return (function (){
var s__38716__$1 = s__38716;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38716__$1);
if(temp__4657__auto__){
var s__38716__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38716__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38716__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38718 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38717 = (0);
while(true){
if((i__38717 < size__7188__auto__)){
var step = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38717);
cljs.core.chunk_append(b__38718,(mn + (size * step)));

var G__38721 = (i__38717 + (1));
i__38717 = G__38721;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38718),c2$layout$histogram$fixed_size_bins_$_iter__38715(cljs.core.chunk_rest(s__38716__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38718),null);
}
} else {
var step = cljs.core.first(s__38716__$2);
return cljs.core.cons((mn + (size * step)),c2$layout$histogram$fixed_size_bins_$_iter__38715(cljs.core.rest(s__38716__$2)));
}
} else {
return null;
}
break;
}
});})(size,vec__38712,mn,mx))
,null,null));
});})(size,vec__38712,mn,mx))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1((n + (1))));
})());
});
/**
 * The histogram layout transforms data by grouping descrete data points into
 *   bins. Returns a collection of values with the following metadata set:
 * 
 *   > *:x* the lower bound of the bin (inclusive).
 * 
 *   > *:dx* the width of the bin; x + dx is the upper bound (exclusive).
 * 
 *   > *:y* the count
 * 
 * Kwargs:
 * 
 * > *:value* fn that calculates value of node, defaults to `:value`
 * 
 * > *:index* opaque value passed to `:bins` and `:range`
 * 
 * > *:range* fn which calculates the minimum and maximum values given the array of values
 * 
 * > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index
 */
c2.layout.histogram.histogram = (function c2$layout$histogram$histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38732 = arguments.length;
var i__7485__auto___38733 = (0);
while(true){
if((i__7485__auto___38733 < len__7484__auto___38732)){
args__7491__auto__.push((arguments[i__7485__auto___38733]));

var G__38734 = (i__7485__auto___38733 + (1));
i__7485__auto___38733 = G__38734;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__38724){
var map__38725 = p__38724;
var map__38725__$1 = ((((!((map__38725 == null)))?((((map__38725.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38725.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38725):map__38725);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38725__$1,cljs.core.cst$kw$value,cljs.core.cst$kw$value);
var index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38725__$1,cljs.core.cst$kw$index);
var range = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38725__$1,cljs.core.cst$kw$range,((function (map__38725,map__38725__$1,value,index){
return (function (xs,_){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.min),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.max)).call(null,xs);
});})(map__38725,map__38725__$1,value,index))
);
var bins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38725__$1,cljs.core.cst$kw$bins,((function (map__38725,map__38725__$1,value,index,range){
return (function (r,xs,_){
return c2.layout.histogram.fixed_size_bins(r,c2.layout.histogram.sturges(xs));
});})(map__38725,map__38725__$1,value,index,range))
);
var values = cljs.core.map.cljs$core$IFn$_invoke$arity$2(value,data);
var r = ((cljs.core.fn_QMARK_(range))?(range.cljs$core$IFn$_invoke$arity$2 ? range.cljs$core$IFn$_invoke$arity$2(values,index) : range.call(null,values,index)):range
);
var thresholds = ((cljs.core.fn_QMARK_(bins))?(bins.cljs$core$IFn$_invoke$arity$3 ? bins.cljs$core$IFn$_invoke$arity$3(r,values,index) : bins.call(null,r,values,index)):((typeof bins === 'number')?c2.layout.histogram.fixed_size_bins(r,bins):bins
));
var binner = ((function (values,r,thresholds,map__38725,map__38725__$1,value,index,range,bins){
return (function (e){
return ((function (){var G__38727 = (c2.layout.histogram.binary_search(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(thresholds,(0),(cljs.core.count(thresholds) - (1))),(value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(e) : value.call(null,e))) + (1));
return Math.abs(G__38727);
})() - (1));
});})(values,r,thresholds,map__38725,map__38725__$1,value,index,range,bins))
;
var groups = cljs.core.group_by(binner,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (values,r,thresholds,binner,map__38725,map__38725__$1,value,index,range,bins){
return (function (p1__109951_SHARP_){
return (((value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(p1__109951_SHARP_) : value.call(null,p1__109951_SHARP_)) >= (r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1((0)) : r.call(null,(0))))) && (((value.cljs$core$IFn$_invoke$arity$1 ? value.cljs$core$IFn$_invoke$arity$1(p1__109951_SHARP_) : value.call(null,p1__109951_SHARP_)) <= (r.cljs$core$IFn$_invoke$arity$1 ? r.cljs$core$IFn$_invoke$arity$1((1)) : r.call(null,(1)))));
});})(values,r,thresholds,binner,map__38725,map__38725__$1,value,index,range,bins))
,data));
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (values,r,thresholds,binner,groups,map__38725,map__38725__$1,value,index,range,bins){
return (function (index__$1,p__38728){
var vec__38729 = p__38728;
var mn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38729,(0),null);
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38729,(1),null);
var group = (function (){var or__6409__auto__ = (groups.cljs$core$IFn$_invoke$arity$1 ? groups.cljs$core$IFn$_invoke$arity$1(index__$1) : groups.call(null,index__$1));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.with_meta(group,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,mn,cljs.core.cst$kw$dx,(mx - mn),cljs.core.cst$kw$y,cljs.core.count(group)], null));
});})(values,r,thresholds,binner,groups,map__38725,map__38725__$1,value,index,range,bins))
,cljs.core.partition.cljs$core$IFn$_invoke$arity$3((2),(1),thresholds));
});

c2.layout.histogram.histogram.cljs$lang$maxFixedArity = (1);

c2.layout.histogram.histogram.cljs$lang$applyTo = (function (seq38722){
var G__38723 = cljs.core.first(seq38722);
var seq38722__$1 = cljs.core.next(seq38722);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(G__38723,seq38722__$1);
});

