// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args39638 = [];
var len__7484__auto___39641 = arguments.length;
var i__7485__auto___39642 = (0);
while(true){
if((i__7485__auto___39642 < len__7484__auto___39641)){
args39638.push((arguments[i__7485__auto___39642]));

var G__39643 = (i__7485__auto___39642 + (1));
i__7485__auto___39642 = G__39643;
continue;
} else {
}
break;
}

var G__39640 = args39638.length;
switch (G__39640) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39638.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args39645 = [];
var len__7484__auto___39648 = arguments.length;
var i__7485__auto___39649 = (0);
while(true){
if((i__7485__auto___39649 < len__7484__auto___39648)){
args39645.push((arguments[i__7485__auto___39649]));

var G__39650 = (i__7485__auto___39649 + (1));
i__7485__auto___39649 = G__39650;
continue;
} else {
}
break;
}

var G__39647 = args39645.length;
switch (G__39647) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39645.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39654_39656 = c2.dom.__GT_dom(container);
var G__39655_39657 = el__$1;
goog.dom.appendChild(G__39654_39656,G__39655_39657);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__39661_39664 = c2.dom.__GT_dom(container);
var G__39662_39665 = el__$1;
var G__39663_39666 = (0);
goog.dom.insertChildAt(G__39661_39664,G__39662_39665,G__39663_39666);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__39668 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__39668);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__39671_39673 = new$__$1;
var G__39672_39674 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__39671_39673,G__39672_39674);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args39675 = [];
var len__7484__auto___39693 = arguments.length;
var i__7485__auto___39694 = (0);
while(true){
if((i__7485__auto___39694 < len__7484__auto___39693)){
args39675.push((arguments[i__7485__auto___39694]));

var G__39695 = (i__7485__auto___39694 + (1));
i__7485__auto___39694 = G__39695;
continue;
} else {
}
break;
}

var G__39677 = args39675.length;
switch (G__39677) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39675.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__39678 = el__$1;
var G__39679 = cljs.core.name(x);
return goog.style.getComputedStyle(G__39678,G__39679);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39680_39697 = cljs.core.seq(x);
var chunk__39681_39698 = null;
var count__39682_39699 = (0);
var i__39683_39700 = (0);
while(true){
if((i__39683_39700 < count__39682_39699)){
var vec__39684_39701 = chunk__39681_39698.cljs$core$IIndexed$_nth$arity$2(null,i__39683_39700);
var k_39702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39684_39701,(0),null);
var v_39703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39684_39701,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39702,v_39703);

var G__39704 = seq__39680_39697;
var G__39705 = chunk__39681_39698;
var G__39706 = count__39682_39699;
var G__39707 = (i__39683_39700 + (1));
seq__39680_39697 = G__39704;
chunk__39681_39698 = G__39705;
count__39682_39699 = G__39706;
i__39683_39700 = G__39707;
continue;
} else {
var temp__4657__auto___39708 = cljs.core.seq(seq__39680_39697);
if(temp__4657__auto___39708){
var seq__39680_39709__$1 = temp__4657__auto___39708;
if(cljs.core.chunked_seq_QMARK_(seq__39680_39709__$1)){
var c__7220__auto___39710 = cljs.core.chunk_first(seq__39680_39709__$1);
var G__39711 = cljs.core.chunk_rest(seq__39680_39709__$1);
var G__39712 = c__7220__auto___39710;
var G__39713 = cljs.core.count(c__7220__auto___39710);
var G__39714 = (0);
seq__39680_39697 = G__39711;
chunk__39681_39698 = G__39712;
count__39682_39699 = G__39713;
i__39683_39700 = G__39714;
continue;
} else {
var vec__39687_39715 = cljs.core.first(seq__39680_39709__$1);
var k_39716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39687_39715,(0),null);
var v_39717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39687_39715,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_39716,v_39717);

var G__39718 = cljs.core.next(seq__39680_39709__$1);
var G__39719 = null;
var G__39720 = (0);
var G__39721 = (0);
seq__39680_39697 = G__39718;
chunk__39681_39698 = G__39719;
count__39682_39699 = G__39720;
i__39683_39700 = G__39721;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__39690_39722 = c2.dom.__GT_dom(el);
var G__39691_39723 = cljs.core.name(k);
var G__39692_39724 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__39690_39722,G__39691_39723,G__39692_39724);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args39725 = [];
var len__7484__auto___39744 = arguments.length;
var i__7485__auto___39745 = (0);
while(true){
if((i__7485__auto___39745 < len__7484__auto___39744)){
args39725.push((arguments[i__7485__auto___39745]));

var G__39746 = (i__7485__auto___39745 + (1));
i__7485__auto___39745 = G__39746;
continue;
} else {
}
break;
}

var G__39727 = args39725.length;
switch (G__39727) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39725.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__39728(s__39729){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__39729__$1 = s__39729;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39729__$1);
if(temp__4657__auto__){
var s__39729__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39729__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39729__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39731 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39730 = (0);
while(true){
if((i__39730 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39730);
cljs.core.chunk_append(b__39731,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__39748 = (i__39730 + (1));
i__39730 = G__39748;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39731),c2$dom$iter__39728(cljs.core.chunk_rest(s__39729__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39731),null);
}
} else {
var i = cljs.core.first(s__39729__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__39728(cljs.core.rest(s__39729__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__39734_39749 = cljs.core.seq(x);
var chunk__39735_39750 = null;
var count__39736_39751 = (0);
var i__39737_39752 = (0);
while(true){
if((i__39737_39752 < count__39736_39751)){
var vec__39738_39753 = chunk__39735_39750.cljs$core$IIndexed$_nth$arity$2(null,i__39737_39752);
var k_39754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39738_39753,(0),null);
var v_39755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39738_39753,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39754,v_39755);

var G__39756 = seq__39734_39749;
var G__39757 = chunk__39735_39750;
var G__39758 = count__39736_39751;
var G__39759 = (i__39737_39752 + (1));
seq__39734_39749 = G__39756;
chunk__39735_39750 = G__39757;
count__39736_39751 = G__39758;
i__39737_39752 = G__39759;
continue;
} else {
var temp__4657__auto___39760 = cljs.core.seq(seq__39734_39749);
if(temp__4657__auto___39760){
var seq__39734_39761__$1 = temp__4657__auto___39760;
if(cljs.core.chunked_seq_QMARK_(seq__39734_39761__$1)){
var c__7220__auto___39762 = cljs.core.chunk_first(seq__39734_39761__$1);
var G__39763 = cljs.core.chunk_rest(seq__39734_39761__$1);
var G__39764 = c__7220__auto___39762;
var G__39765 = cljs.core.count(c__7220__auto___39762);
var G__39766 = (0);
seq__39734_39749 = G__39763;
chunk__39735_39750 = G__39764;
count__39736_39751 = G__39765;
i__39737_39752 = G__39766;
continue;
} else {
var vec__39741_39767 = cljs.core.first(seq__39734_39761__$1);
var k_39768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39741_39767,(0),null);
var v_39769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39741_39767,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_39768,v_39769);

var G__39770 = cljs.core.next(seq__39734_39761__$1);
var G__39771 = null;
var G__39772 = (0);
var G__39773 = (0);
seq__39734_39749 = G__39770;
chunk__39735_39750 = G__39771;
count__39736_39751 = G__39772;
i__39737_39752 = G__39773;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args39774 = [];
var len__7484__auto___39778 = arguments.length;
var i__7485__auto___39779 = (0);
while(true){
if((i__7485__auto___39779 < len__7484__auto___39778)){
args39774.push((arguments[i__7485__auto___39779]));

var G__39780 = (i__7485__auto___39779 + (1));
i__7485__auto___39779 = G__39780;
continue;
} else {
}
break;
}

var G__39776 = args39774.length;
switch (G__39776) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39774.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39777 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__39777);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args39782 = [];
var len__7484__auto___39786 = arguments.length;
var i__7485__auto___39787 = (0);
while(true){
if((i__7485__auto___39787 < len__7484__auto___39786)){
args39782.push((arguments[i__7485__auto___39787]));

var G__39788 = (i__7485__auto___39787 + (1));
i__7485__auto___39787 = G__39788;
continue;
} else {
}
break;
}

var G__39784 = args39782.length;
switch (G__39784) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39782.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__39785 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__39785);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__39793_39796 = c2.dom.__GT_dom(el);
var G__39794_39797 = cljs.core.name(class$);
var G__39795_39798 = classed_QMARK_;
goog.dom.classes.enable(G__39793_39796,G__39794_39797,G__39795_39798);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__39799_SHARP_){
var G__39800 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__39799_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__39799_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__39799_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__39801 = (10);
return setTimeout(G__39800,G__39801);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
