// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.photos');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.constants');
goog.require('milia.utils.remote');
goog.require('sablono.core');
goog.require('hatti.shared');
goog.require('hatti.views');
goog.require('om.core');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.photos.data_pswp_id = "data-pswp-id";
hatti.views.photos.pswp_gallery_class = "pswp";
hatti.views.photos.width_px = (1024);
hatti.views.photos.thumb_width_px = (180);
hatti.views.photos.thumb_width_px_str = [cljs.core.str(hatti.views.photos.thumb_width_px),cljs.core.str("px")].join('');
hatti.views.photos.num_columns = (3);
/**
 * Return a URL for this image resized.
 */
hatti.views.photos.resize_image = (function hatti$views$photos$resize_image(image_url,edge_px){
return [cljs.core.str(milia.utils.remote.thumbor_server),cljs.core.str(chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["unsafe","fit-in",[cljs.core.str(edge_px),cljs.core.str("x"),cljs.core.str(edge_px)].join(''),"smart","filters:fill(000)",image_url], 0)))].join('');
});
/**
 * If not a fully qualified URL, remove the API namespace prefix from a URI
 * string and convert to a fully qualified URL.
 */
hatti.views.photos.make_url = (function hatti$views$photos$make_url(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(4)),"http")){
return s;
} else {
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([clojure.string.replace(s,/\/api\/v1/,"")], 0));
}
});
hatti.views.photos.build_caption = (function hatti$views$photos$build_caption(item){
var datetime = item.date;
var date = moment(datetime).format("MMM D, YYYY");
var time = moment(datetime).format("h:mm A");
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%s <br/><small>Submitted at %s on %s <br/>Record ID: %s </small>",cljs.core.array_seq([item.title,time,date,item.id], 0));
});
hatti.views.photos.full_url_from_active_image = (function hatti$views$photos$full_url_from_active_image(){
var G__31330_31332 = document.querySelector("#active-image .pswp__img");
(ona.utils.interop.console_log.cljs$core$IFn$_invoke$arity$1 ? ona.utils.interop.console_log.cljs$core$IFn$_invoke$arity$1(G__31330_31332) : ona.utils.interop.console_log.call(null,G__31330_31332));

var G__31331_31333 = document.querySelector("#active-image .pswp__img").getAttribute("src");
(ona.utils.interop.console_log.cljs$core$IFn$_invoke$arity$1 ? ona.utils.interop.console_log.cljs$core$IFn$_invoke$arity$1(G__31331_31333) : ona.utils.interop.console_log.call(null,G__31331_31333));

return cljs.core.last(cljs.core.re_find(/\/(http.*)/,document.querySelector("#active-image .pswp__img").getAttribute("src")));
});
/**
 * Initiate photoswipe using the index of the image that was just clicked on.
 */
hatti.views.photos.open_photoswipe = (function hatti$views$photos$open_photoswipe(index,photos){
var pswp_element = cljs.core.first(document.querySelectorAll([cljs.core.str("."),cljs.core.str(hatti.views.photos.pswp_gallery_class)].join('')));
var options = (function (){var obj31339 = {"index":(index | (0)),"getThumbBoundsFn":((function (pswp_element){
return (function (index__$1){
var thumbnail = document.querySelector(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("[%s='%s']",cljs.core.array_seq([hatti.views.photos.data_pswp_id,index__$1], 0)));
var page_y_scroll = (window.pageYOffset + document.documentElement.scrollTop);
var rect = thumbnail.getBoundingClientRect();
var obj31341 = {"x":rect.left,"y":(rect.top + page_y_scroll),"w":rect.width};
return obj31341;
});})(pswp_element))
,"getImageURLForShare":((function (pswp_element){
return (function (share_button_data){
return hatti.views.photos.full_url_from_active_image();
});})(pswp_element))
,"addCaptionHTMLFn":((function (pswp_element){
return (function (item,caption_el,is_fake){
return cljs.core.first(caption_el.children).innerHTML = hatti.views.photos.build_caption(item);
});})(pswp_element))
};
return obj31339;
})();
var gallery = (new PhotoSwipe(pswp_element,PhotoSwipeUI_Default,cljs.core.clj__GT_js(photos),options));
return gallery.init();
});
/**
 * Actions to perform on thumbnail click.
 */
hatti.views.photos.on_thumbnail_click = (function hatti$views$photos$on_thumbnail_click(event,photos){
event.preventDefault();

return hatti.views.photos.open_photoswipe(event.target.getAttribute(hatti.views.photos.data_pswp_id),photos);
});
/**
 * Return True if no mimetype or the mimetype begins with image. Otherwise
 * return nil.
 */
hatti.views.photos.image_or_no_mimetype_QMARK_ = (function hatti$views$photos$image_or_no_mimetype_QMARK_(attachment){
var mimetype = cljs.core.get.cljs$core$IFn$_invoke$arity$2(attachment,hatti.constants.mimetype);
var or__6409__auto__ = cljs.core.not(mimetype);
if(or__6409__auto__){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("image",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(mimetype,(0),(5)));
if(or__6409__auto____$1){
return or__6409__auto____$1;
} else {
return null;
}
}
});
/**
 * Take a datum and return the datum with a new key :attachements that has a
 * list of download URLs for all the attachments.
 */
hatti.views.photos.extract_images = (function hatti$views$photos$extract_images(datum,photo_columns){
var download_url_kw = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants.download_url);
var attachments = (function (){var or__6409__auto__ = (function (){var G__31350 = datum;
var G__31350__$1 = (((G__31350 == null))?null:cljs.core.get.cljs$core$IFn$_invoke$arity$2(G__31350,hatti.constants.photo));
var G__31350__$2 = (((G__31350__$1 == null))?null:(download_url_kw.cljs$core$IFn$_invoke$arity$1 ? download_url_kw.cljs$core$IFn$_invoke$arity$1(G__31350__$1) : download_url_kw.call(null,G__31350__$1)));
if((G__31350__$2 == null)){
return null;
} else {
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[G__31350__$2],null));
}
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (or__6409__auto__,download_url_kw){
return (function (p1__31343_SHARP_,p2__31342_SHARP_){
var G__31352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,p2__31342_SHARP_);
var G__31352__$1 = (((G__31352 == null))?null:(download_url_kw.cljs$core$IFn$_invoke$arity$1 ? download_url_kw.cljs$core$IFn$_invoke$arity$1(G__31352) : download_url_kw.call(null,G__31352)));
var G__31352__$2 = (((G__31352__$1 == null))?null:cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31343_SHARP_,G__31352__$1));
if((G__31352__$2 == null)){
return null;
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,G__31352__$2);
}
});})(or__6409__auto__,download_url_kw))
,null,photo_columns);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (or__6409__auto____$1,or__6409__auto__,download_url_kw){
return (function (p1__31344_SHARP_){
var and__6397__auto__ = hatti.views.photos.image_or_no_mimetype_QMARK_(p1__31344_SHARP_);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__31344_SHARP_,hatti.constants.download_url);
} else {
return and__6397__auto__;
}
});})(or__6409__auto____$1,or__6409__auto__,download_url_kw))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._attachments));
}
}
})();
var and__6397__auto__ = cljs.core.seq(attachments);
if(and__6397__auto__){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(datum,cljs.core.cst$kw$attachments,attachments);
} else {
return and__6397__auto__;
}
});
/**
 * Build photos for photoswipe from a set of form data. Ignore submissions that
 * do not have a photo attached. If the photo info is attached directly to the
 * submission and not to the attachments list, use the information attached
 * directly to the submission.
 */
hatti.views.photos.build_photos = (function hatti$views$photos$build_photos(data,photo_columns){
var data_with_attachments = cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__31353_SHARP_){
return hatti.views.photos.extract_images(p1__31353_SHARP_,photo_columns);
}),data);
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (data_with_attachments){
return (function (p1__31354_SHARP_,p2__31355_SHARP_){
return (p1__31354_SHARP_ + cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p2__31355_SHARP_,cljs.core.cst$kw$attachments)));
});})(data_with_attachments))
,(0),data_with_attachments);
var data_left = data_with_attachments;
var result = cljs.core.PersistentVector.EMPTY;
var photo_index = (1);
while(true){
if(cljs.core.seq(data_left)){
var map__31358 = cljs.core.first(data_left);
var map__31358__$1 = ((((!((map__31358 == null)))?((((map__31358.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31358.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31358):map__31358);
var datum = map__31358__$1;
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31358__$1,cljs.core.cst$kw$attachments);
var rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._rank);
var photo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants.photo);
var G__31360 = cljs.core.rest(data_left);
var G__31361 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(result,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (data_left,result,photo_index,map__31358,map__31358__$1,datum,attachments,rank,photo,data_with_attachments,total){
return (function (j,attachment){
var download_url = hatti.views.photos.make_url(attachment);
var thumbnail = hatti.views.photos.resize_image(download_url,hatti.views.photos.thumb_width_px);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$thumb,cljs.core.cst$kw$date,cljs.core.cst$kw$w,cljs.core.cst$kw$rank,cljs.core.cst$kw$msrc,cljs.core.cst$kw$src,cljs.core.cst$kw$title,cljs.core.cst$kw$h,cljs.core.cst$kw$id,cljs.core.cst$kw$original_DASH_src],[thumbnail,cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._submission_time),hatti.views.photos.width_px,rank,thumbnail,hatti.views.photos.resize_image(hatti.views.photos.make_url(download_url),hatti.views.photos.width_px),chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%s/%s | Submission %s",cljs.core.array_seq([(photo_index + j),total,rank], 0)),hatti.views.photos.width_px,cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._id),download_url]);
});})(data_left,result,photo_index,map__31358,map__31358__$1,datum,attachments,rank,photo,data_with_attachments,total))
,attachments));
var G__31362 = (photo_index + cljs.core.count(attachments));
data_left = G__31360;
result = G__31361;
photo_index = G__31362;
continue;
} else {
return result;
}
break;
}
});
/**
 * Return the full-names of all columns with photo type.
 */
hatti.views.photos.get_photo_columns = (function hatti$views$photos$get_photo_columns(form){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__31363_SHARP_){
var and__6397__auto__ = (function (){var or__6409__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("photo",cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(p1__31363_SHARP_));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return null;
}
})();
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(p1__31363_SHARP_);
} else {
return and__6397__auto__;
}
}),form);
});
/**
 * Build markup with actions for a photo gallery.
 */
hatti.views.photos.build_photo_gallery = (function hatti$views$photos$build_photo_gallery(photos,owner){
var iter__7189__auto__ = (function hatti$views$photos$build_photo_gallery_$_iter__31379(s__31380){
return (new cljs.core.LazySeq(null,(function (){
var s__31380__$1 = s__31380;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31380__$1);
if(temp__4657__auto__){
var s__31380__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31380__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31380__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31382 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31381 = (0);
while(true){
if((i__31381 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31381);
var map__31389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(photos,i);
var map__31389__$1 = ((((!((map__31389 == null)))?((((map__31389.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31389.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31389):map__31389);
var photo = map__31389__$1;
var title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31389__$1,cljs.core.cst$kw$title);
cljs.core.chunk_append(b__31382,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figure,new cljs.core.PersistentArrayMap(null, 3, ["itemProp","associatedMedia","itemScope","","itemType","http://schema.org/ImageObject"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$href,cljs.core.cst$kw$src.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","contentUrl",cljs.core.cst$kw$data_DASH_size,chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%sx%s",cljs.core.array_seq([hatti.views.photos.width_px,hatti.views.photos.width_px], 0)),cljs.core.cst$kw$on_DASH_click,((function (i__31381,map__31389,map__31389__$1,photo,title,i,c__7187__auto__,size__7188__auto__,b__31382,s__31380__$2,temp__4657__auto__){
return (function (p1__31364_SHARP_){
return hatti.views.photos.on_thumbnail_click(p1__31364_SHARP_,photos);
});})(i__31381,map__31389,map__31389__$1,photo,title,i,c__7187__auto__,size__7188__auto__,b__31382,s__31380__$2,temp__4657__auto__))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,cljs.core.PersistentArrayMap.fromArray([cljs.core.cst$kw$width,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$height,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$src,cljs.core.cst$kw$thumb.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","thumbnail",cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.views.photos.data_pswp_id),i,cljs.core.cst$kw$alt,title], true, false)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figcaption,new cljs.core.PersistentArrayMap(null, 1, ["itemProp","caption description"], null),title], null)], null));

var G__31393 = (i__31381 + (1));
i__31381 = G__31393;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31382),hatti$views$photos$build_photo_gallery_$_iter__31379(cljs.core.chunk_rest(s__31380__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31382),null);
}
} else {
var i = cljs.core.first(s__31380__$2);
var map__31391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(photos,i);
var map__31391__$1 = ((((!((map__31391 == null)))?((((map__31391.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31391.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31391):map__31391);
var photo = map__31391__$1;
var title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31391__$1,cljs.core.cst$kw$title);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figure,new cljs.core.PersistentArrayMap(null, 3, ["itemProp","associatedMedia","itemScope","","itemType","http://schema.org/ImageObject"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$href,cljs.core.cst$kw$src.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","contentUrl",cljs.core.cst$kw$data_DASH_size,chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%sx%s",cljs.core.array_seq([hatti.views.photos.width_px,hatti.views.photos.width_px], 0)),cljs.core.cst$kw$on_DASH_click,((function (map__31391,map__31391__$1,photo,title,i,s__31380__$2,temp__4657__auto__){
return (function (p1__31364_SHARP_){
return hatti.views.photos.on_thumbnail_click(p1__31364_SHARP_,photos);
});})(map__31391,map__31391__$1,photo,title,i,s__31380__$2,temp__4657__auto__))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,cljs.core.PersistentArrayMap.fromArray([cljs.core.cst$kw$width,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$height,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$src,cljs.core.cst$kw$thumb.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","thumbnail",cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.views.photos.data_pswp_id),i,cljs.core.cst$kw$alt,title], true, false)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figcaption,new cljs.core.PersistentArrayMap(null, 1, ["itemProp","caption description"], null),title], null)], null),hatti$views$photos$build_photo_gallery_$_iter__31379(cljs.core.rest(s__31380__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(photos)));
});
hatti.views.photos_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__31394,owner){
var map__31395 = p__31394;
var map__31395__$1 = ((((!((map__31395 == null)))?((((map__31395.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31395.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31395):map__31395);
var map__31396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31395__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__31396__$1 = ((((!((map__31396 == null)))?((((map__31396.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31396.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31396):map__31396);
var dataset_info = map__31396__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31396__$1,cljs.core.cst$kw$num_of_submissions);

if(typeof hatti.views.photos.t_hatti$views$photos31399 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.photos.t_hatti$views$photos31399 = (function (p__31394,owner,map__31395,map__31396,dataset_info,num_of_submissions,meta31400){
this.p__31394 = p__31394;
this.owner = owner;
this.map__31395 = map__31395;
this.map__31396 = map__31396;
this.dataset_info = dataset_info;
this.num_of_submissions = num_of_submissions;
this.meta31400 = meta31400;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.photos.t_hatti$views$photos31399.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (_31401,meta31400__$1){
var self__ = this;
var _31401__$1 = this;
return (new hatti.views.photos.t_hatti$views$photos31399(self__.p__31394,self__.owner,self__.map__31395,self__.map__31396,self__.dataset_info,self__.num_of_submissions,meta31400__$1));
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos31399.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (_31401){
var self__ = this;
var _31401__$1 = this;
return self__.meta31400;
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos31399.prototype.om$core$IInitState$ = true;

hatti.views.photos.t_hatti$views$photos31399.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$data], null)),cljs.core.cst$kw$photo_DASH_columns,hatti.views.photos.get_photo_columns(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null))));
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos31399.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.photos.t_hatti$views$photos31399.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$data,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$map_DASH_page.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos31399.prototype.om$core$IRenderState$ = true;

hatti.views.photos.t_hatti$views$photos31399.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (_,p__31402){
var self__ = this;
var map__31403 = p__31402;
var map__31403__$1 = ((((!((map__31403 == null)))?((((map__31403.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31403.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31403):map__31403);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31403__$1,cljs.core.cst$kw$data);
var photo_columns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31403__$1,cljs.core.cst$kw$photo_DASH_columns);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var photos = hatti.views.photos.build_photos(data,photo_columns);
var attrs31405 = ((((self__.num_of_submissions === (0))) || ((cljs.core.seq(data)) && (cljs.core.empty_QMARK_(photos))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$alert$alert_DASH_warning$alert_DASH_photos,"There are no photos in this dataset yet."], null):((cljs.core.seq(photos))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$role,"dialog",cljs.core.cst$kw$aria_DASH_hidden,"true",cljs.core.cst$kw$tab_DASH_index,"-1",cljs.core.cst$kw$class,hatti.views.photos.pswp_gallery_class], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__bg], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__scroll_DASH_wrap,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__container,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__item], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__item_SHARP_active_DASH_image], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__item], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__ui$pswp__ui_DASH__DASH_hidden,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__top_DASH_bar,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__counter], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_close,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Close (Esc)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_share,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Share"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_fs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Toggle fullscreen"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_zoom,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Zoom in/out"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader__icn,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader__cut,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader__donut], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__share_DASH_modal$pswp__share_DASH_modal_DASH__DASH_hidden,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"pswp__single-tap"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__share_DASH_tooltip], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_arrow_DASH__DASH_left,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Previous (arrow left)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_arrow_DASH__DASH_right,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Next (arrow right)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__caption,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__caption__center], null)], null)], null)], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$alert$alert_DASH_photos,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading photos ..."], null)
));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs31405))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-content"], null)], null),attrs31405], 0))):({"className": "tab-content"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs31405))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__31408 = ({"itemScope": "", "itemType": "http://schema.org/ImageGallery", "className": "gallery"});
var G__31409 = (function (){var attrs31406 = hatti.views.photos.build_photo_gallery(photos,self__.owner);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.table,((cljs.core.map_QMARK_(attrs31406))?sablono.interpreter.attributes(attrs31406):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs31406))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs31406)], null))));
})();
return React.DOM.div(G__31408,G__31409);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs31405),(function (){var G__31410 = ({"itemScope": "", "itemType": "http://schema.org/ImageGallery", "className": "gallery"});
var G__31411 = (function (){var attrs31407 = hatti.views.photos.build_photo_gallery(photos,self__.owner);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.table,((cljs.core.map_QMARK_(attrs31407))?sablono.interpreter.attributes(attrs31407):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs31407))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs31407)], null))));
})();
return React.DOM.div(G__31410,G__31411);
})()], null))));
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos31399.getBasis = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__31394,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__31395,cljs.core.cst$sym$map__31396,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$num_of_submissions,cljs.core.cst$sym$meta31400], null);
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos31399.cljs$lang$type = true;

hatti.views.photos.t_hatti$views$photos31399.cljs$lang$ctorStr = "hatti.views.photos/t_hatti$views$photos31399";

hatti.views.photos.t_hatti$views$photos31399.cljs$lang$ctorPrWriter = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.photos/t_hatti$views$photos31399");
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.__GT_t_hatti$views$photos31399 = ((function (map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions){
return (function hatti$views$photos$__GT_t_hatti$views$photos31399(p__31394__$1,owner__$1,map__31395__$2,map__31396__$2,dataset_info__$1,num_of_submissions__$1,meta31400){
return (new hatti.views.photos.t_hatti$views$photos31399(p__31394__$1,owner__$1,map__31395__$2,map__31396__$2,dataset_info__$1,num_of_submissions__$1,meta31400));
});})(map__31395,map__31395__$1,map__31396,map__31396__$1,dataset_info,num_of_submissions))
;

}

return (new hatti.views.photos.t_hatti$views$photos31399(p__31394,owner,map__31395__$1,map__31396__$1,dataset_info,num_of_submissions,cljs.core.PersistentArrayMap.EMPTY));
}));
