// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__31638(s__31639){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__31639__$1 = s__31639;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31639__$1);
if(temp__4657__auto__){
var s__31639__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31639__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31639__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31641 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31640 = (0);
while(true){
if((i__31640 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31640);
cljs.core.chunk_append(b__31641,(function (){var iter__7189__auto__ = ((function (i__31640,datum,c__7187__auto__,size__7188__auto__,b__31641,s__31639__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__31638_$_iter__31656(s__31657){
return (new cljs.core.LazySeq(null,((function (i__31640,datum,c__7187__auto__,size__7188__auto__,b__31641,s__31639__$2,temp__4657__auto__,osmfields){
return (function (){
var s__31657__$1 = s__31657;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__31657__$1);
if(temp__4657__auto____$1){
var s__31657__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__31657__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__31657__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__31659 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__31658 = (0);
while(true){
if((i__31658 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__31658);
cljs.core.chunk_append(b__31659,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__31668 = (i__31658 + (1));
i__31658 = G__31668;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31659),hatti$ona$post_process$ona_osm_link_$_iter__31638_$_iter__31656(cljs.core.chunk_rest(s__31657__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31659),null);
}
} else {
var field = cljs.core.first(s__31657__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__31638_$_iter__31656(cljs.core.rest(s__31657__$2)));
}
} else {
return null;
}
break;
}
});})(i__31640,datum,c__7187__auto__,size__7188__auto__,b__31641,s__31639__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__31640,datum,c__7187__auto__,size__7188__auto__,b__31641,s__31639__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__31669 = (i__31640 + (1));
i__31640 = G__31669;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31641),hatti$ona$post_process$ona_osm_link_$_iter__31638(cljs.core.chunk_rest(s__31639__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31641),null);
}
} else {
var datum = cljs.core.first(s__31639__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__31639__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__31638_$_iter__31662(s__31663){
return (new cljs.core.LazySeq(null,((function (datum,s__31639__$2,temp__4657__auto__,osmfields){
return (function (){
var s__31663__$1 = s__31663;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__31663__$1);
if(temp__4657__auto____$1){
var s__31663__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__31663__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31663__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31665 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31664 = (0);
while(true){
if((i__31664 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31664);
cljs.core.chunk_append(b__31665,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__31670 = (i__31664 + (1));
i__31664 = G__31670;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31665),hatti$ona$post_process$ona_osm_link_$_iter__31638_$_iter__31662(cljs.core.chunk_rest(s__31663__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31665),null);
}
} else {
var field = cljs.core.first(s__31663__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__31638_$_iter__31662(cljs.core.rest(s__31663__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__31639__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__31639__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__31638(cljs.core.rest(s__31639__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__31672 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__31672);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__31696 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__31696) : osmgeo.call(null,G__31696));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__31697(s__31698){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__31698__$1 = s__31698;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31698__$1);
if(temp__4657__auto__){
var s__31698__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31698__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31698__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31700 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31699 = (0);
while(true){
if((i__31699 < size__7188__auto__)){
var map__31711 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31699);
var map__31711__$1 = ((((!((map__31711 == null)))?((((map__31711.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31711.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31711):map__31711);
var feature = map__31711__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31711__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31711__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31711__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__31700,(function (){var map__31713 = properties;
var map__31713__$1 = ((((!((map__31713 == null)))?((((map__31713.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31713.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31713):map__31713);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31713__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31713__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31713__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__31719 = (i__31699 + (1));
i__31699 = G__31719;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31700),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__31697(cljs.core.chunk_rest(s__31698__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31700),null);
}
} else {
var map__31715 = cljs.core.first(s__31698__$2);
var map__31715__$1 = ((((!((map__31715 == null)))?((((map__31715.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31715.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31715):map__31715);
var feature = map__31715__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31715__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31715__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31715__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__31717 = properties;
var map__31717__$1 = ((((!((map__31717 == null)))?((((map__31717.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31717.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31717):map__31717);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31717__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31717__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31717__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__31697(cljs.core.rest(s__31698__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__31720_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__31720_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__31732(s__31733){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__31733__$1 = s__31733;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31733__$1);
if(temp__4657__auto__){
var s__31733__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31733__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31733__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31735 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31734 = (0);
while(true){
if((i__31734 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31734);
cljs.core.chunk_append(b__31735,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__31734,osm_id,datum,c__7187__auto__,size__7188__auto__,b__31735,s__31733__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__31721_SHARP_){
return osm_val__GT_osm_data(p1__31721_SHARP_,osm_id);
});})(i__31734,osm_id,datum,c__7187__auto__,size__7188__auto__,b__31735,s__31733__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__31742 = (i__31734 + (1));
i__31734 = G__31742;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31735),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__31732(cljs.core.chunk_rest(s__31733__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31735),null);
}
} else {
var datum = cljs.core.first(s__31733__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__31733__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__31721_SHARP_){
return osm_val__GT_osm_data(p1__31721_SHARP_,osm_id);
});})(osm_id,datum,s__31733__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__31732(cljs.core.rest(s__31733__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__31738 = cljs.core.seq(osm_fields);
var chunk__31739 = null;
var count__31740 = (0);
var i__31741 = (0);
while(true){
if((i__31741 < count__31740)){
var osm_field = chunk__31739.cljs$core$IIndexed$_nth$arity$2(null,i__31741);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__31743 = seq__31738;
var G__31744 = chunk__31739;
var G__31745 = count__31740;
var G__31746 = (i__31741 + (1));
seq__31738 = G__31743;
chunk__31739 = G__31744;
count__31740 = G__31745;
i__31741 = G__31746;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__31738);
if(temp__4657__auto__){
var seq__31738__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31738__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__31738__$1);
var G__31747 = cljs.core.chunk_rest(seq__31738__$1);
var G__31748 = c__7220__auto__;
var G__31749 = cljs.core.count(c__7220__auto__);
var G__31750 = (0);
seq__31738 = G__31747;
chunk__31739 = G__31748;
count__31740 = G__31749;
i__31741 = G__31750;
continue;
} else {
var osm_field = cljs.core.first(seq__31738__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__31751 = cljs.core.next(seq__31738__$1);
var G__31752 = null;
var G__31753 = (0);
var G__31754 = (0);
seq__31738 = G__31751;
chunk__31739 = G__31752;
count__31740 = G__31753;
i__31741 = G__31754;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__31755_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__31755_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,fname,fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Inlines media data from within _attachments into each record.
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31768 = arguments.length;
var i__7485__auto___31769 = (0);
while(true){
if((i__7485__auto___31769 < len__7484__auto___31768)){
args__7491__auto__.push((arguments[i__7485__auto___31769]));

var G__31770 = (i__7485__auto___31769 + (1));
i__7485__auto___31769 = G__31770;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__31759){
var map__31760 = p__31759;
var map__31760__$1 = ((((!((map__31760 == null)))?((((map__31760.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31760.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31760):map__31760);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31760__$1,cljs.core.cst$kw$attachments);
var image_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.image_QMARK_,flat_form);
var iter__7189__auto__ = ((function (image_fields,map__31760,map__31760__$1,attachments){
return (function hatti$ona$post_process$iter__31762(s__31763){
return (new cljs.core.LazySeq(null,((function (image_fields,map__31760,map__31760__$1,attachments){
return (function (){
var s__31763__$1 = s__31763;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31763__$1);
if(temp__4657__auto__){
var s__31763__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31763__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31763__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31765 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31764 = (0);
while(true){
if((i__31764 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31764);
cljs.core.chunk_append(b__31765,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__31764,attach_map,record,c__7187__auto__,size__7188__auto__,b__31765,s__31763__$2,temp__4657__auto__,image_fields,map__31760,map__31760__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__31764,attach_map,record,c__7187__auto__,size__7188__auto__,b__31765,s__31763__$2,temp__4657__auto__,image_fields,map__31760,map__31760__$1,attachments))
,record,image_fields);
})());

var G__31771 = (i__31764 + (1));
i__31764 = G__31771;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31765),hatti$ona$post_process$iter__31762(cljs.core.chunk_rest(s__31763__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31765),null);
}
} else {
var record = cljs.core.first(s__31763__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__31763__$2,temp__4657__auto__,image_fields,map__31760,map__31760__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__31763__$2,temp__4657__auto__,image_fields,map__31760,map__31760__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__31762(cljs.core.rest(s__31763__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__31760,map__31760__$1,attachments))
,null,null));
});})(image_fields,map__31760,map__31760__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq31756){
var G__31757 = cljs.core.first(seq31756);
var seq31756__$1 = cljs.core.next(seq31756);
var G__31758 = cljs.core.first(seq31756__$1);
var seq31756__$2 = cljs.core.next(seq31756__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__31757,G__31758,seq31756__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments)], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__31778(s__31779){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__31779__$1 = s__31779;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31779__$1);
if(temp__4657__auto__){
var s__31779__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31779__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__31779__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__31781 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__31780 = (0);
while(true){
if((i__31780 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__31780);
cljs.core.chunk_append(b__31781,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__31784 = (i__31780 + (1));
i__31780 = G__31784;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31781),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__31778(cljs.core.chunk_rest(s__31779__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31781),null);
}
} else {
var record = cljs.core.first(s__31779__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__31778(cljs.core.rest(s__31779__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31792 = arguments.length;
var i__7485__auto___31793 = (0);
while(true){
if((i__7485__auto___31793 < len__7484__auto___31792)){
args__7491__auto__.push((arguments[i__7485__auto___31793]));

var G__31794 = (i__7485__auto___31793 + (1));
i__7485__auto___31793 = G__31794;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__31789){
var map__31790 = p__31789;
var map__31790__$1 = ((((!((map__31790 == null)))?((((map__31790.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31790.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31790):map__31790);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31790__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__31790,map__31790__$1,app_data_keys){
return (function (p1__31785_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__31785_SHARP_));
});})(map__31790,map__31790__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq31786){
var G__31787 = cljs.core.first(seq31786);
var seq31786__$1 = cljs.core.next(seq31786);
var G__31788 = cljs.core.first(seq31786__$1);
var seq31786__$2 = cljs.core.next(seq31786__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31787,G__31788,seq31786__$2);
});

