// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.remote');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.urls');
/**
 * Store credentials used to authenticate API requests.
 * Based on existence in this atom credentials will be tried in top down order.
 */
milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$temp_DASH_token,null,cljs.core.cst$kw$token,null,cljs.core.cst$kw$username,null,cljs.core.cst$kw$password,null], null);
milia.utils.remote.invalid_token_msg = "Invalid token";
milia.utils.remote.token_expired_msg = "Token expired";
milia.utils.remote.bad_token_msgs = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [milia.utils.remote.invalid_token_msg,milia.utils.remote.token_expired_msg], null);
/**
 * Store remote hosts that requests are made to.
 */
milia.utils.remote.hosts = (function (){var G__31797 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$client,"zebra.ona.io",cljs.core.cst$kw$data,"stage-api.ona.io",cljs.core.cst$kw$j2x,"j2x.ona.io",cljs.core.cst$kw$request_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31797) : cljs.core.atom.call(null,G__31797));
})();
/**
 * Store customizable timeouts to use in the http libraries. In milliseconds.
 */
milia.utils.remote.timeouts = (function (){var G__31798 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$conn_DASH_timeout,(30000),cljs.core.cst$kw$socket_DASH_timeout,(30000)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31798) : cljs.core.atom.call(null,G__31798));
})();
/**
 * Swap values into hosts atom, requires data-host, other args are option but
 * must be provided in order. If an option arg is nil it is ignored, and not
 * swapped into hosts.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_hosts = (function milia$utils$remote$set_hosts(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31806 = arguments.length;
var i__7485__auto___31807 = (0);
while(true){
if((i__7485__auto___31807 < len__7484__auto___31806)){
args__7491__auto__.push((arguments[i__7485__auto___31807]));

var G__31808 = (i__7485__auto___31807 + (1));
i__7485__auto___31807 = G__31808;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_hosts', milia.utils.remote.set_hosts);

milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic = (function (data_host,p__31801){
var vec__31802 = p__31801;
var client_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31802,(0),null);
var j2x_host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31802,(1),null);
var request_protocol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31802,(2),null);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(milia.utils.remote.hosts,cljs.core.merge,(function (){var G__31805 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,data_host], null);
var G__31805__$1 = ((cljs.core.some_QMARK_(client_host))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31805,cljs.core.cst$kw$client,client_host):G__31805);
var G__31805__$2 = ((cljs.core.some_QMARK_(j2x_host))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31805__$1,cljs.core.cst$kw$j2x,j2x_host):G__31805__$1);
if(cljs.core.some_QMARK_(request_protocol)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31805__$2,cljs.core.cst$kw$request_DASH_protocol,request_protocol);
} else {
return G__31805__$2;
}
})());
});

milia.utils.remote.set_hosts.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_hosts.cljs$lang$applyTo = (function (seq31799){
var G__31800 = cljs.core.first(seq31799);
var seq31799__$1 = cljs.core.next(seq31799);
return milia.utils.remote.set_hosts.cljs$core$IFn$_invoke$arity$variadic(G__31800,seq31799__$1);
});

/**
 * Set the dynamic credentials to include the username and optionally
 * any other arguments that are passed. If an argument is nil or not passed
 * it will be set to nil in the credentials.
 * 
 * Calling this from Clojure will break if not done from within a previous
 * binding of the *credentials* variable.
 * 
 * Built to support setting hosts from JavaScript.
 */
milia.utils.remote.set_credentials = (function milia$utils$remote$set_credentials(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31815 = arguments.length;
var i__7485__auto___31816 = (0);
while(true){
if((i__7485__auto___31816 < len__7484__auto___31815)){
args__7491__auto__.push((arguments[i__7485__auto___31816]));

var G__31817 = (i__7485__auto___31816 + (1));
i__7485__auto___31816 = G__31817;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});
goog.exportSymbol('milia.utils.remote.set_credentials', milia.utils.remote.set_credentials);

milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic = (function (username,p__31811){
var vec__31812 = p__31811;
var password = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31812,(0),null);
var temp_token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31812,(1),null);
var token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31812,(2),null);
return milia.utils.remote._STAR_credentials_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$password,password,cljs.core.cst$kw$temp_DASH_token,temp_token,cljs.core.cst$kw$token,token], null);
});

milia.utils.remote.set_credentials.cljs$lang$maxFixedArity = (1);

milia.utils.remote.set_credentials.cljs$lang$applyTo = (function (seq31809){
var G__31810 = cljs.core.first(seq31809);
var seq31809__$1 = cljs.core.next(seq31809);
return milia.utils.remote.set_credentials.cljs$core$IFn$_invoke$arity$variadic(G__31810,seq31809__$1);
});

/**
 * Prefix the resources with the protocol and format strings.
 */
milia.utils.remote.protocol_prefixed = (function milia$utils$remote$protocol_prefixed(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$request_DASH_protocol.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))),"://",resources], null)));
});
milia.utils.remote.thumbor_host = "images.ona.io";
milia.utils.remote.thumbor_server = milia.utils.remote.protocol_prefixed(milia.utils.remote.thumbor_host);
milia.utils.remote.url_join = (function milia$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.urls.url,args)));
});
/**
 * Build an API url.
 */
milia.utils.remote.make_url = (function milia$utils$remote$make_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31819 = arguments.length;
var i__7485__auto___31820 = (0);
while(true){
if((i__7485__auto___31820 < len__7484__auto___31819)){
args__7491__auto__.push((arguments[i__7485__auto___31820]));

var G__31821 = (i__7485__auto___31820 + (1));
i__7485__auto___31820 = G__31821;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join([cljs.core.str(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts))))),cljs.core.str("/api/v1")].join(''),postfix);
});

milia.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_url.cljs$lang$applyTo = (function (seq31818){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31818));
});

/**
 * Build a URL pointing to the client.
 */
milia.utils.remote.make_client_url = (function milia$utils$remote$make_client_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31823 = arguments.length;
var i__7485__auto___31824 = (0);
while(true){
if((i__7485__auto___31824 < len__7484__auto___31823)){
args__7491__auto__.push((arguments[i__7485__auto___31824]));

var G__31825 = (i__7485__auto___31824 + (1));
i__7485__auto___31824 = G__31825;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var client_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(client_host,postfix);
});

milia.utils.remote.make_client_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_client_url.cljs$lang$applyTo = (function (seq31822){
return milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31822));
});

/**
 * Like make-url, but ensures an ending in .json
 */
milia.utils.remote.make_json_url = (function milia$utils$remote$make_json_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31827 = arguments.length;
var i__7485__auto___31828 = (0);
while(true){
if((i__7485__auto___31828 < len__7484__auto___31827)){
args__7491__auto__.push((arguments[i__7485__auto___31828]));

var G__31829 = (i__7485__auto___31828 + (1));
i__7485__auto___31828 = G__31829;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return [cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.utils.remote.make_url,args)),cljs.core.str(".json")].join('');
});

milia.utils.remote.make_json_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_json_url.cljs$lang$applyTo = (function (seq31826){
return milia.utils.remote.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31826));
});

/**
 * Build an API url.
 */
milia.utils.remote.make_j2x_url = (function milia$utils$remote$make_j2x_url(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31831 = arguments.length;
var i__7485__auto___31832 = (0);
while(true){
if((i__7485__auto___31832 < len__7484__auto___31831)){
args__7491__auto__.push((arguments[i__7485__auto___31832]));

var G__31833 = (i__7485__auto___31832 + (1));
i__7485__auto___31832 = G__31833;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return milia.utils.remote.url_join(milia.utils.remote.protocol_prefixed(cljs.core.cst$kw$j2x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(milia.utils.remote.hosts) : cljs.core.deref.call(null,milia.utils.remote.hosts)))),postfix);
});

milia.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

milia.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq31830){
return milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31830));
});

