// Compiled by ClojureScript 1.7.145 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.7.145";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 */
cljs.core._STAR_target_STAR_;

/** @define {string} */
goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
if(typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = (function cljs$core$_STAR_print_err_fn_STAR_(_){
throw (new Error("No *print-err-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return cljs.core._STAR_print_err_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
cljs.core.into_array;
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__16620__delegate = function (args){
return console.log.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__16620 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16621__i = 0, G__16621__a = new Array(arguments.length -  0);
while (G__16621__i < G__16621__a.length) {G__16621__a[G__16621__i] = arguments[G__16621__i + 0]; ++G__16621__i;}
  args = new cljs.core.IndexedSeq(G__16621__a,0);
} 
return G__16620__delegate.call(this,args);};
G__16620.cljs$lang$maxFixedArity = 0;
G__16620.cljs$lang$applyTo = (function (arglist__16622){
var args = cljs.core.seq(arglist__16622);
return G__16620__delegate(args);
});
G__16620.cljs$core$IFn$_invoke$arity$variadic = G__16620__delegate;
return G__16620;
})()
;

cljs.core._STAR_print_err_fn_STAR_ = (function() { 
var G__16623__delegate = function (args){
return console.error.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__16623 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__16624__i = 0, G__16624__a = new Array(arguments.length -  0);
while (G__16624__i < G__16624__a.length) {G__16624__a[G__16624__i] = arguments[G__16624__i + 0]; ++G__16624__i;}
  args = new cljs.core.IndexedSeq(G__16624__a,0);
} 
return G__16623__delegate.call(this,args);};
G__16623.cljs$lang$maxFixedArity = 0;
G__16623.cljs$lang$applyTo = (function (arglist__16625){
var args = cljs.core.seq(arglist__16625);
return G__16623__delegate(args);
});
G__16623.cljs$core$IFn$_invoke$arity$variadic = G__16623__delegate;
return G__16623;
})()
;

return null;
});
/**
 * bound in a repl thread to the most recent value printed
 */
cljs.core._STAR_1;
/**
 * bound in a repl thread to the second most recent value printed
 */
cljs.core._STAR_2;
/**
 * bound in a repl thread to the third most recent value printed
 */
cljs.core._STAR_3;
/**
 * bound in a repl thread to the most recent exception caught by the repl
 */
cljs.core._STAR_e;
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;
cljs.core.instance_QMARK_;

cljs.core.Keyword;
/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript char.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return goog.string.isUnicodeChar(x);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__4557__auto__ = ty;
if(cljs.core.truth_(and__4557__auto__)){
return ty.cljs$lang$type;
} else {
return and__4557__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4423__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4423__auto__)){
var s = temp__4423__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && ((goog.typeOf(Symbol) === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = {"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"};
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = {"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"};
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if(typeof performance !== 'undefined'){
return performance.now();
} else {
if(typeof process !== 'undefined'){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 *   argument for compatibility with Clojure.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var args16626 = [];
var len__5627__auto___16629 = arguments.length;
var i__5628__auto___16630 = (0);
while(true){
if((i__5628__auto___16630 < len__5627__auto___16629)){
args16626.push((arguments[i__5628__auto___16630]));

var G__16631 = (i__5628__auto___16630 + (1));
i__5628__auto___16630 = G__16631;
continue;
} else {
}
break;
}

var G__16628 = args16626.length;
switch (G__16628) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16626.length)].join('')));

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$lang$maxFixedArity = 2;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__5472__auto___16633 = len;
var i_16634 = (0);
while(true){
if((i_16634 < n__5472__auto___16633)){
(new_arr[i_16634] = (arr[i_16634]));

var G__16635 = (i_16634 + (1));
i_16634 = G__16635;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__16636 = (i + (1));
i = G__16636;
continue;
} else {
return a;
}
break;
}
});
cljs.core.apply;
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var args16637 = [];
var len__5627__auto___16646 = arguments.length;
var i__5628__auto___16647 = (0);
while(true){
if((i__5628__auto___16647 < len__5627__auto___16646)){
args16637.push((arguments[i__5628__auto___16647]));

var G__16648 = (i__5628__auto___16647 + (1));
i__5628__auto___16647 = G__16648;
continue;
} else {
}
break;
}

var G__16642 = args16637.length;
switch (G__16642) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16637.slice((2)),(0)));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__16643 = cljs.core.aget;
var G__16644 = (array[i]);
var G__16645 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__16643,G__16644,G__16645) : cljs.core.apply.call(null,G__16643,G__16644,G__16645));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq16638){
var G__16639 = cljs.core.first(seq16638);
var seq16638__$1 = cljs.core.next(seq16638);
var G__16640 = cljs.core.first(seq16638__$1);
var seq16638__$2 = cljs.core.next(seq16638__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__16639,G__16640,seq16638__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);
/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var args16650 = [];
var len__5627__auto___16661 = arguments.length;
var i__5628__auto___16662 = (0);
while(true){
if((i__5628__auto___16662 < len__5627__auto___16661)){
args16650.push((arguments[i__5628__auto___16662]));

var G__16663 = (i__5628__auto___16662 + (1));
i__5628__auto___16662 = G__16663;
continue;
} else {
}
break;
}

var G__16656 = args16650.length;
switch (G__16656) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16650.slice((3)),(0)));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__16657 = cljs.core.aset;
var G__16658 = (array[idx]);
var G__16659 = idx2;
var G__16660 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__16657,G__16658,G__16659,G__16660) : cljs.core.apply.call(null,G__16657,G__16658,G__16659,G__16660));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq16651){
var G__16652 = cljs.core.first(seq16651);
var seq16651__$1 = cljs.core.next(seq16651);
var G__16653 = cljs.core.first(seq16651__$1);
var seq16651__$2 = cljs.core.next(seq16651__$1);
var G__16654 = cljs.core.first(seq16651__$2);
var seq16651__$3 = cljs.core.next(seq16651__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__16652,G__16653,G__16654,seq16651__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
cljs.core.reduce;
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var args16665 = [];
var len__5627__auto___16671 = arguments.length;
var i__5628__auto___16672 = (0);
while(true){
if((i__5628__auto___16672 < len__5627__auto___16671)){
args16665.push((arguments[i__5628__auto___16672]));

var G__16673 = (i__5628__auto___16672 + (1));
i__5628__auto___16672 = G__16673;
continue;
} else {
}
break;
}

var G__16667 = args16665.length;
switch (G__16667) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16665.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__16668 = (function (a,x){
a.push(x);

return a;
});
var G__16669 = [];
var G__16670 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__16668,G__16669,G__16670) : cljs.core.reduce.call(null,G__16668,G__16669,G__16670));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;
/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__5634__auto__ = [];
var len__5627__auto___16678 = arguments.length;
var i__5628__auto___16679 = (0);
while(true){
if((i__5628__auto___16679 < len__5627__auto___16678)){
args__5634__auto__.push((arguments[i__5628__auto___16679]));

var G__16680 = (i__5628__auto___16679 + (1));
i__5628__auto___16679 = G__16680;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq16675){
var G__16676 = cljs.core.first(seq16675);
var seq16675__$1 = cljs.core.next(seq16675);
var G__16677 = cljs.core.first(seq16675__$1);
var seq16675__$2 = cljs.core.next(seq16675__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__16676,G__16677,seq16675__$2);
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

cljs.core._invoke = (function cljs$core$_invoke(var_args){
var args16681 = [];
var len__5627__auto___16684 = arguments.length;
var i__5628__auto___16685 = (0);
while(true){
if((i__5628__auto___16685 < len__5627__auto___16684)){
args16681.push((arguments[i__5628__auto___16685]));

var G__16686 = (i__5628__auto___16685 + (1));
i__5628__auto___16685 = G__16686;
continue;
} else {
}
break;
}

var G__16683 = args16681.length;
switch (G__16683) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16681.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$1 == null)))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5225__auto__.call(null,this$));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__5225__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$2 == null)))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__5225__auto__.call(null,this$,a));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a) : m__5225__auto____$1.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$3 == null)))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__5225__auto__.call(null,this$,a,b));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__5225__auto____$1.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$4 == null)))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__5225__auto__.call(null,this$,a,b,c));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__5225__auto____$1.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$5 == null)))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__5225__auto__.call(null,this$,a,b,c,d));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__5225__auto____$1.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$6 == null)))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$6 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__5225__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__5225__auto____$1.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$7 == null)))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$7 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__5225__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$8 == null)))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$8 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$9 == null)))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$9 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$10 == null)))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$10 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$11 == null)))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$11 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$12 == null)))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$12 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$13 == null)))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$13 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$14 == null)))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$14 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$15 == null)))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$15 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$16 == null)))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$16 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$17 == null)))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$17 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$18 == null)))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$18 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$19 == null)))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$19 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$20 == null)))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$20 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$21 == null)))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$21 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$22 == null)))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._invoke[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$22 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__5225__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__5225__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__5225__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;


/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((!((value == null))) && (!((value.cljs$core$ICloneable$_clone$arity$1 == null)))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__5224__auto__ = (((value == null))?null:value);
var m__5225__auto__ = (cljs.core._clone[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__5225__auto__.call(null,value));
} else {
var m__5225__auto____$1 = (cljs.core._clone["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__5225__auto____$1.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((!((coll == null))) && (!((coll.cljs$core$ICounted$_count$arity$1 == null)))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._count[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._count["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._empty[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._empty["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((!((coll == null))) && (!((coll.cljs$core$ICollection$_conj$arity$2 == null)))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._conj[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__5225__auto__.call(null,coll,o));
} else {
var m__5225__auto____$1 = (cljs.core._conj["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o) : m__5225__auto____$1.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var args16688 = [];
var len__5627__auto___16691 = arguments.length;
var i__5628__auto___16692 = (0);
while(true){
if((i__5628__auto___16692 < len__5627__auto___16691)){
args16688.push((arguments[i__5628__auto___16692]));

var G__16693 = (i__5628__auto___16692 + (1));
i__5628__auto___16692 = G__16693;
continue;
} else {
}
break;
}

var G__16690 = args16688.length;
switch (G__16690) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16688.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._nth[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5225__auto__.call(null,coll,n));
} else {
var m__5225__auto____$1 = (cljs.core._nth["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n) : m__5225__auto____$1.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._nth[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__5225__auto__.call(null,coll,n,not_found));
} else {
var m__5225__auto____$1 = (cljs.core._nth["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__5225__auto____$1.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;


/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_first$arity$1 == null)))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._first[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._first["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
}
});

/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_rest$arity$1 == null)))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._rest[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._rest["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$INext$_next$arity$1 == null)))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._next[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._next["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var args16695 = [];
var len__5627__auto___16698 = arguments.length;
var i__5628__auto___16699 = (0);
while(true){
if((i__5628__auto___16699 < len__5627__auto___16698)){
args16695.push((arguments[i__5628__auto___16699]));

var G__16700 = (i__5628__auto___16699 + (1));
i__5628__auto___16699 = G__16700;
continue;
} else {
}
break;
}

var G__16697 = args16695.length;
switch (G__16697) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16695.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$2 == null)))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._lookup[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__5225__auto__.call(null,o,k));
} else {
var m__5225__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k) : m__5225__auto____$1.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$3 == null)))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._lookup[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__5225__auto__.call(null,o,k,not_found));
} else {
var m__5225__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__5225__auto____$1.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5225__auto__.call(null,coll,k));
} else {
var m__5225__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5225__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._assoc[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__5225__auto__.call(null,coll,k,v));
} else {
var m__5225__auto____$1 = (cljs.core._assoc["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__5225__auto____$1.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._dissoc[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5225__auto__.call(null,coll,k));
} else {
var m__5225__auto____$1 = (cljs.core._dissoc["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__5225__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._key[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._key["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._val[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._val["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((!((coll == null))) && (!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._disjoin[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__5225__auto__.call(null,coll,v));
} else {
var m__5225__auto____$1 = (cljs.core._disjoin["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v) : m__5225__auto____$1.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_peek$arity$1 == null)))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._peek[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._peek["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_pop$arity$1 == null)))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._pop[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._pop["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((!((coll == null))) && (!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._assoc_n[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__5225__auto__.call(null,coll,n,val));
} else {
var m__5225__auto____$1 = (cljs.core._assoc_n["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__5225__auto____$1.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((!((o == null))) && (!((o.cljs$core$IDeref$_deref$arity$1 == null)))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._deref[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto__.call(null,o));
} else {
var m__5225__auto____$1 = (cljs.core._deref["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((!((o == null))) && (!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__5225__auto__.call(null,o,msec,timeout_val));
} else {
var m__5225__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__5225__auto____$1.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((!((o == null))) && (!((o.cljs$core$IMeta$_meta$arity$1 == null)))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._meta[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto__.call(null,o));
} else {
var m__5225__auto____$1 = (cljs.core._meta["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((!((o == null))) && (!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._with_meta[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__5225__auto__.call(null,o,meta));
} else {
var m__5225__auto____$1 = (cljs.core._with_meta["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta) : m__5225__auto____$1.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var args16702 = [];
var len__5627__auto___16705 = arguments.length;
var i__5628__auto___16706 = (0);
while(true){
if((i__5628__auto___16706 < len__5627__auto___16705)){
args16702.push((arguments[i__5628__auto___16706]));

var G__16707 = (i__5628__auto___16706 + (1));
i__5628__auto___16706 = G__16707;
continue;
} else {
}
break;
}

var G__16704 = args16702.length;
switch (G__16704) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16702.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._reduce[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__5225__auto__.call(null,coll,f));
} else {
var m__5225__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f) : m__5225__auto____$1.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._reduce[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__5225__auto__.call(null,coll,f,start));
} else {
var m__5225__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__5225__auto____$1.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((!((coll == null))) && (!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__5225__auto__.call(null,coll,f,init));
} else {
var m__5225__auto____$1 = (cljs.core._kv_reduce["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__5225__auto____$1.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((!((o == null))) && (!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._equiv[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__5225__auto__.call(null,o,other));
} else {
var m__5225__auto____$1 = (cljs.core._equiv["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other) : m__5225__auto____$1.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((!((o == null))) && (!((o.cljs$core$IHash$_hash$arity$1 == null)))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._hash[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto__.call(null,o));
} else {
var m__5225__auto____$1 = (cljs.core._hash["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((!((o == null))) && (!((o.cljs$core$ISeqable$_seq$arity$1 == null)))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._seq[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto__.call(null,o));
} else {
var m__5225__auto____$1 = (cljs.core._seq["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__5225__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((!((coll == null))) && (!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._rseq[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._rseq["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__5225__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core._sorted_seq["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__5225__auto____$1.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__5225__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__5225__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__5225__auto____$1.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._entry_key[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__5225__auto__.call(null,coll,entry));
} else {
var m__5225__auto____$1 = (cljs.core._entry_key["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__5225__auto____$1.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._comparator[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._comparator["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_write$arity$2 == null)))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__5224__auto__ = (((writer == null))?null:writer);
var m__5225__auto__ = (cljs.core._write[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__5225__auto__.call(null,writer,s));
} else {
var m__5225__auto____$1 = (cljs.core._write["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s) : m__5225__auto____$1.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_flush$arity$1 == null)))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__5224__auto__ = (((writer == null))?null:writer);
var m__5225__auto__ = (cljs.core._flush[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__5225__auto__.call(null,writer));
} else {
var m__5225__auto____$1 = (cljs.core._flush["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__5225__auto____$1.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((!((o == null))) && (!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._pr_writer[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__5225__auto__.call(null,o,writer,opts));
} else {
var m__5225__auto____$1 = (cljs.core._pr_writer["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__5225__auto____$1.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay.
 * @interface
 */
cljs.core.IPending = function(){};

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((!((d == null))) && (!((d.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__5224__auto__ = (((d == null))?null:d);
var m__5225__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(d) : m__5225__auto__.call(null,d));
} else {
var m__5225__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(d) : m__5225__auto____$1.call(null,d));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._notify_watches[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__5225__auto__.call(null,this$,oldval,newval));
} else {
var m__5225__auto____$1 = (cljs.core._notify_watches["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__5225__auto____$1.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._add_watch[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__5225__auto__.call(null,this$,key,f));
} else {
var m__5225__auto____$1 = (cljs.core._add_watch["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__5225__auto____$1.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__5224__auto__ = (((this$ == null))?null:this$);
var m__5225__auto__ = (cljs.core._remove_watch[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__5225__auto__.call(null,this$,key));
} else {
var m__5225__auto____$1 = (cljs.core._remove_watch["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key) : m__5225__auto____$1.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._as_transient[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._as_transient["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__5225__auto__.call(null,tcoll,val));
} else {
var m__5225__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__5225__auto____$1.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5225__auto__.call(null,tcoll));
} else {
var m__5225__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5225__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__5225__auto__.call(null,tcoll,key,val));
} else {
var m__5225__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__5225__auto____$1.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__5225__auto__.call(null,tcoll,key));
} else {
var m__5225__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__5225__auto____$1.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__5225__auto__.call(null,tcoll,n,val));
} else {
var m__5225__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__5225__auto____$1.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5225__auto__.call(null,tcoll));
} else {
var m__5225__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__5225__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__5224__auto__ = (((tcoll == null))?null:tcoll);
var m__5225__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__5225__auto__.call(null,tcoll,v));
} else {
var m__5225__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__5225__auto____$1.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((!((x == null))) && (!((x.cljs$core$IComparable$_compare$arity$2 == null)))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (cljs.core._compare[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__5225__auto__.call(null,x,y));
} else {
var m__5225__auto____$1 = (cljs.core._compare["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__5225__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._drop_first[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._drop_first["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._chunked_first[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._chunked_first["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._chunked_rest["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._chunked_next[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._chunked_next["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_name$arity$1 == null)))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (cljs.core._name[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (cljs.core._name["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_namespace$arity$1 == null)))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (cljs.core._namespace[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto__.call(null,x));
} else {
var m__5225__auto____$1 = (cljs.core._namespace["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__5225__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5225__auto__.call(null,o,new_value));
} else {
var m__5225__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5225__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var args16709 = [];
var len__5627__auto___16712 = arguments.length;
var i__5628__auto___16713 = (0);
while(true){
if((i__5628__auto___16713 < len__5627__auto___16712)){
args16709.push((arguments[i__5628__auto___16713]));

var G__16714 = (i__5628__auto___16713 + (1));
i__5628__auto___16713 = G__16714;
continue;
} else {
}
break;
}

var G__16711 = args16709.length;
switch (G__16711) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16709.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__5225__auto__.call(null,o,f));
} else {
var m__5225__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f) : m__5225__auto____$1.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__5225__auto__.call(null,o,f,a));
} else {
var m__5225__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__5225__auto____$1.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__5225__auto__.call(null,o,f,a,b));
} else {
var m__5225__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__5225__auto____$1.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$5 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__5225__auto__.call(null,o,f,a,b,xs));
} else {
var m__5225__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__5225__auto____$1.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;


/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__5224__auto__ = (((o == null))?null:o);
var m__5225__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5225__auto__.call(null,o,new_value));
} else {
var m__5225__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__5225__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((!((coll == null))) && (!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__5224__auto__ = (((coll == null))?null:coll);
var m__5225__auto__ = (cljs.core._iterator[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return (m__5225__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto__.call(null,coll));
} else {
var m__5225__auto____$1 = (cljs.core._iterator["_"]);
if(!((m__5225__auto____$1 == null))){
return (m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__5225__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__5225__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sb","sb",-1249746442,null)], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!((Math.imul((4294967295),(5)) === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__16716 = (i + (2));
var G__16717 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__16716;
h1 = G__16717;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});
cljs.core.list;

cljs.core.Symbol;

cljs.core._EQ_;

cljs.core.compare;
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__16720 = (i + (1));
var G__16721 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__16720;
hash = G__16721;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = {};

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || (o.cljs$core$IHash$))?true:false):false)){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return (Math.floor(o) % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__4557__auto__ = cljs.core.not(a.ns);
if(and__4557__auto__){
return b.ns;
} else {
return and__4557__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__16734 = a.ns;
var G__16735 = b.ns;
return goog.array.defaultCompare(G__16734,G__16735);
})();
if(((0) === nsc)){
var G__16736 = a.name;
var G__16737 = b.name;
return goog.array.defaultCompare(G__16736,G__16737);
} else {
return nsc;
}
}
} else {
var G__16738 = a.name;
var G__16739 = b.name;
return goog.array.defaultCompare(G__16738,G__16739);

}
}
}
});
cljs.core.get;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__16741 = null;
var G__16741__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});
var G__16741__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});
G__16741 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__16741__2.call(this,self__,coll);
case 3:
return G__16741__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16741.cljs$core$IFn$_invoke$arity$2 = G__16741__2;
G__16741.cljs$core$IFn$_invoke$arity$3 = G__16741__3;
return G__16741;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args16740){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args16740)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__5004__auto__ = self__._hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function cljs$core$symbol(var_args){
var args16742 = [];
var len__5627__auto___16745 = arguments.length;
var i__5628__auto___16746 = (0);
while(true){
if((i__5628__auto___16746 < len__5627__auto___16745)){
args16742.push((arguments[i__5628__auto___16746]));

var G__16747 = (i__5628__auto___16746 + (1));
i__5628__auto___16746 = G__16747;
continue;
} else {
}
break;
}

var G__16744 = args16742.length;
switch (G__16744) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16742.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
var idx = name.indexOf("/");
if((idx === (-1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2523137;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
});

cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__16750 = this$__$1.sym;
var G__16751 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__16750,G__16751) : cljs.core._EQ_.call(null,G__16750,G__16751));
} else {
return false;
}
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.call = (function() {
var G__16796 = null;
var G__16796__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});
var G__16796__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});
var G__16796__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});
var G__16796__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});
var G__16796__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});
var G__16796__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});
var G__16796__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});
var G__16796__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});
var G__16796__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});
var G__16796__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});
var G__16796__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__16796__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__16796__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__16796__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__16796__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__16796__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__16796__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__16796__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__16796__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__16796__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__16796__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__16796__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__16752 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__16753 = a;
var G__16754 = b;
var G__16755 = c;
var G__16756 = d;
var G__16757 = e;
var G__16758 = f;
var G__16759 = g;
var G__16760 = h;
var G__16761 = i;
var G__16762 = j;
var G__16763 = k;
var G__16764 = l;
var G__16765 = m;
var G__16766 = n;
var G__16767 = o;
var G__16768 = p;
var G__16769 = q;
var G__16770 = r;
var G__16771 = s;
var G__16772 = t;
var G__16773 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__16752,G__16753,G__16754,G__16755,G__16756,G__16757,G__16758,G__16759,G__16760,G__16761,G__16762,G__16763,G__16764,G__16765,G__16766,G__16767,G__16768,G__16769,G__16770,G__16771,G__16772,G__16773) : cljs.core.apply.call(null,G__16752,G__16753,G__16754,G__16755,G__16756,G__16757,G__16758,G__16759,G__16760,G__16761,G__16762,G__16763,G__16764,G__16765,G__16766,G__16767,G__16768,G__16769,G__16770,G__16771,G__16772,G__16773));
});
G__16796 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__16796__1.call(this,self__);
case 2:
return G__16796__2.call(this,self__,a);
case 3:
return G__16796__3.call(this,self__,a,b);
case 4:
return G__16796__4.call(this,self__,a,b,c);
case 5:
return G__16796__5.call(this,self__,a,b,c,d);
case 6:
return G__16796__6.call(this,self__,a,b,c,d,e);
case 7:
return G__16796__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__16796__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__16796__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__16796__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__16796__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__16796__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__16796__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__16796__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__16796__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__16796__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__16796__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__16796__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__16796__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__16796__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__16796__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__16796__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16796.cljs$core$IFn$_invoke$arity$1 = G__16796__1;
G__16796.cljs$core$IFn$_invoke$arity$2 = G__16796__2;
G__16796.cljs$core$IFn$_invoke$arity$3 = G__16796__3;
G__16796.cljs$core$IFn$_invoke$arity$4 = G__16796__4;
G__16796.cljs$core$IFn$_invoke$arity$5 = G__16796__5;
G__16796.cljs$core$IFn$_invoke$arity$6 = G__16796__6;
G__16796.cljs$core$IFn$_invoke$arity$7 = G__16796__7;
G__16796.cljs$core$IFn$_invoke$arity$8 = G__16796__8;
G__16796.cljs$core$IFn$_invoke$arity$9 = G__16796__9;
G__16796.cljs$core$IFn$_invoke$arity$10 = G__16796__10;
G__16796.cljs$core$IFn$_invoke$arity$11 = G__16796__11;
G__16796.cljs$core$IFn$_invoke$arity$12 = G__16796__12;
G__16796.cljs$core$IFn$_invoke$arity$13 = G__16796__13;
G__16796.cljs$core$IFn$_invoke$arity$14 = G__16796__14;
G__16796.cljs$core$IFn$_invoke$arity$15 = G__16796__15;
G__16796.cljs$core$IFn$_invoke$arity$16 = G__16796__16;
G__16796.cljs$core$IFn$_invoke$arity$17 = G__16796__17;
G__16796.cljs$core$IFn$_invoke$arity$18 = G__16796__18;
G__16796.cljs$core$IFn$_invoke$arity$19 = G__16796__19;
G__16796.cljs$core$IFn$_invoke$arity$20 = G__16796__20;
G__16796.cljs$core$IFn$_invoke$arity$21 = G__16796__21;
G__16796.cljs$core$IFn$_invoke$arity$22 = G__16796__22;
return G__16796;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args16749){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args16749)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__16774 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__16775 = a;
var G__16776 = b;
var G__16777 = c;
var G__16778 = d;
var G__16779 = e;
var G__16780 = f;
var G__16781 = g;
var G__16782 = h;
var G__16783 = i;
var G__16784 = j;
var G__16785 = k;
var G__16786 = l;
var G__16787 = m;
var G__16788 = n;
var G__16789 = o;
var G__16790 = p;
var G__16791 = q;
var G__16792 = r;
var G__16793 = s;
var G__16794 = t;
var G__16795 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__16774,G__16775,G__16776,G__16777,G__16778,G__16779,G__16780,G__16781,G__16782,G__16783,G__16784,G__16785,G__16786,G__16787,G__16788,G__16789,G__16790,G__16791,G__16792,G__16793,G__16794,G__16795) : cljs.core.apply.call(null,G__16774,G__16775,G__16776,G__16777,G__16778,G__16779,G__16780,G__16781,G__16782,G__16783,G__16784,G__16785,G__16786,G__16787,G__16788,G__16789,G__16790,G__16791,G__16792,G__16793,G__16794,G__16795));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"sym","sym",195671222,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
cljs.core.array_seq;

cljs.core.prim_seq;

cljs.core.IndexedSeq;
/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if(!((x == null))){
if((false) || (x.cljs$core$IIterable$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if(!((value == null))){
if(((value.cljs$lang$protocol_mask$partition1$ & (8192))) || (value.cljs$core$ICloneable$)){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || (coll.cljs$core$ISeqable$))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || (coll.cljs$core$INext$))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var args16809 = [];
var len__5627__auto___16815 = arguments.length;
var i__5628__auto___16816 = (0);
while(true){
if((i__5628__auto___16816 < len__5627__auto___16815)){
args16809.push((arguments[i__5628__auto___16816]));

var G__16817 = (i__5628__auto___16816 + (1));
i__5628__auto___16816 = G__16817;
continue;
} else {
}
break;
}

var G__16814 = args16809.length;
switch (G__16814) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16809.slice((2)),(0)));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__16819 = y;
var G__16820 = cljs.core.first(more);
var G__16821 = cljs.core.next(more);
x = G__16819;
y = G__16820;
more = G__16821;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq16810){
var G__16811 = cljs.core.first(seq16810);
var seq16810__$1 = cljs.core.next(seq16810);
var G__16812 = cljs.core.first(seq16810__$1);
var seq16810__$2 = cljs.core.next(seq16810__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16811,G__16812,seq16810__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": x, "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});
cljs.core.es6_iterator_seq;

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter));
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_rest","_rest",-2100466189,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__16822 = (n + (1));
var G__16823 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__16824 = cljs.core.next(coll__$1);
n = G__16822;
hash_code = G__16823;
coll__$1 = G__16824;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__16825 = (n + (1));
var G__16826 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__16827 = cljs.core.next(coll__$1);
n = G__16825;
hash_code = G__16826;
coll__$1 = G__16827;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));
cljs.core.hash_map;

cljs.core.list;

cljs.core.equiv_sequential;
(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__16828 = this$__$1.valueOf();
var G__16829 = other.valueOf();
return goog.array.defaultCompare(G__16828,G__16829);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
cljs.core.with_meta;
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});
cljs.core.deref;

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null)], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var args16830 = [];
var len__5627__auto___16839 = arguments.length;
var i__5628__auto___16840 = (0);
while(true){
if((i__5628__auto___16840 < len__5627__auto___16839)){
args16830.push((arguments[i__5628__auto___16840]));

var G__16841 = (i__5628__auto___16840 + (1));
i__5628__auto___16840 = G__16841;
continue;
} else {
}
break;
}

var G__16832 = args16830.length;
switch (G__16832) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16830.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__16833 = val;
var G__16834 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16833,G__16834) : f.call(null,G__16833,G__16834));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16843 = nval;
var G__16844 = (n + (1));
val = G__16843;
n = G__16844;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__16835 = val__$1;
var G__16836 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16835,G__16836) : f.call(null,G__16835,G__16836));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16845 = nval;
var G__16846 = (n + (1));
val__$1 = G__16845;
n = G__16846;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__16837 = val__$1;
var G__16838 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16837,G__16838) : f.call(null,G__16837,G__16838));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16847 = nval;
var G__16848 = (n + (1));
val__$1 = G__16847;
n = G__16848;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var args16849 = [];
var len__5627__auto___16858 = arguments.length;
var i__5628__auto___16859 = (0);
while(true){
if((i__5628__auto___16859 < len__5627__auto___16858)){
args16849.push((arguments[i__5628__auto___16859]));

var G__16860 = (i__5628__auto___16859 + (1));
i__5628__auto___16859 = G__16860;
continue;
} else {
}
break;
}

var G__16851 = args16849.length;
switch (G__16851) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16849.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__16852 = val;
var G__16853 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16852,G__16853) : f.call(null,G__16852,G__16853));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16862 = nval;
var G__16863 = (n + (1));
val = G__16862;
n = G__16863;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__16854 = val__$1;
var G__16855 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16854,G__16855) : f.call(null,G__16854,G__16855));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16864 = nval;
var G__16865 = (n + (1));
val__$1 = G__16864;
n = G__16865;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__16856 = val__$1;
var G__16857 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16856,G__16857) : f.call(null,G__16856,G__16857));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__16866 = nval;
var G__16867 = (n + (1));
val__$1 = G__16866;
n = G__16867;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.hash_coll;

cljs.core.cons;

cljs.core.RSeq;

cljs.core.List;
/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (2))) || (x.cljs$core$ICounted$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16))) || (x.cljs$core$IIndexed$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__4900__auto__ = (0);
var y__4901__auto__ = (self__.arr.length - self__.i);
return ((x__4900__auto__ > y__4901__auto__) ? x__4900__auto__ : y__4901__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var args16872 = [];
var len__5627__auto___16875 = arguments.length;
var i__5628__auto___16876 = (0);
while(true){
if((i__5628__auto___16876 < len__5627__auto___16875)){
args16872.push((arguments[i__5628__auto___16876]));

var G__16877 = (i__5628__auto___16876 + (1));
i__5628__auto___16876 = G__16877;
continue;
} else {
}
break;
}

var G__16874 = args16872.length;
switch (G__16874) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16872.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var args16879 = [];
var len__5627__auto___16882 = arguments.length;
var i__5628__auto___16883 = (0);
while(true){
if((i__5628__auto___16883 < len__5627__auto___16882)){
args16879.push((arguments[i__5628__auto___16883]));

var G__16884 = (i__5628__auto___16883 + (1));
i__5628__auto___16883 = G__16884;
continue;
} else {
}
break;
}

var G__16881 = args16879.length;
switch (G__16881) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16879.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.with_meta;

cljs.core.seq_reduce;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__16886 = cljs.core.List.EMPTY;
var G__16887 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__16886,G__16887) : cljs.core.with_meta.call(null,G__16886,G__16887));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ci","ci",2049808339,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__16888 = sn;
s = G__16888;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var args16889 = [];
var len__5627__auto___16895 = arguments.length;
var i__5628__auto___16896 = (0);
while(true){
if((i__5628__auto___16896 < len__5627__auto___16895)){
args16889.push((arguments[i__5628__auto___16896]));

var G__16897 = (i__5628__auto___16896 + (1));
i__5628__auto___16896 = G__16897;
continue;
} else {
}
break;
}

var G__16894 = args16889.length;
switch (G__16894) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16889.slice((2)),(0)));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__16899 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__16900 = cljs.core.first(xs);
var G__16901 = cljs.core.next(xs);
coll = G__16899;
x = G__16900;
xs = G__16901;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq16890){
var G__16891 = cljs.core.first(seq16890);
var seq16890__$1 = cljs.core.next(seq16890);
var G__16892 = cljs.core.first(seq16890__$1);
var seq16890__$2 = cljs.core.next(seq16890__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__16891,G__16892,seq16890__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__16902 = cljs.core.next(s);
var G__16903 = (acc + (1));
s = G__16902;
acc = G__16903;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || (coll.cljs$core$ICounted$))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || (coll.cljs$core$ISeqable$))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var args16908 = [];
var len__5627__auto___16911 = arguments.length;
var i__5628__auto___16912 = (0);
while(true){
if((i__5628__auto___16912 < len__5627__auto___16911)){
args16908.push((arguments[i__5628__auto___16912]));

var G__16913 = (i__5628__auto___16912 + (1));
i__5628__auto___16912 = G__16913;
continue;
} else {
}
break;
}

var G__16910 = args16908.length;
switch (G__16910) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16908.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__16915 = cljs.core.next(coll);
var G__16916 = (n - (1));
coll = G__16915;
n = G__16916;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__16917 = cljs.core.next(coll);
var G__16918 = (n - (1));
var G__16919 = not_found;
coll = G__16917;
n = G__16918;
not_found = G__16919;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var args16920 = [];
var len__5627__auto___16927 = arguments.length;
var i__5628__auto___16928 = (0);
while(true){
if((i__5628__auto___16928 < len__5627__auto___16927)){
args16920.push((arguments[i__5628__auto___16928]));

var G__16929 = (i__5628__auto___16928 + (1));
i__5628__auto___16928 = G__16929;
continue;
} else {
}
break;
}

var G__16922 = args16920.length;
switch (G__16922) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16920.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || (coll.cljs$core$IIndexed$))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return coll.charAt(n);
} else {
return null;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || (coll.cljs$core$IIndexed$))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return coll.charAt(n);
} else {
return not_found;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__16931 = (n__$1 - (1));
var G__16932 = cljs.core.rest(xs);
n__$1 = G__16931;
xs = G__16932;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var args16933 = [];
var len__5627__auto___16938 = arguments.length;
var i__5628__auto___16939 = (0);
while(true){
if((i__5628__auto___16939 < len__5627__auto___16938)){
args16933.push((arguments[i__5628__auto___16939]));

var G__16940 = (i__5628__auto___16939 + (1));
i__5628__auto___16939 = G__16940;
continue;
} else {
}
break;
}

var G__16935 = args16933.length;
switch (G__16935) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16933.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || (o.cljs$core$ILookup$))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || (o.cljs$core$ILookup$))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.PersistentHashMap;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var args16942 = [];
var len__5627__auto___16949 = arguments.length;
var i__5628__auto___16950 = (0);
while(true){
if((i__5628__auto___16950 < len__5627__auto___16949)){
args16942.push((arguments[i__5628__auto___16950]));

var G__16951 = (i__5628__auto___16950 + (1));
i__5628__auto___16950 = G__16951;
continue;
} else {
}
break;
}

var G__16948 = args16942.length;
switch (G__16948) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16942.slice((3)),(0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__16953 = ret;
var G__16954 = cljs.core.first(kvs);
var G__16955 = cljs.core.second(kvs);
var G__16956 = cljs.core.nnext(kvs);
coll = G__16953;
k = G__16954;
v = G__16955;
kvs = G__16956;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq16943){
var G__16944 = cljs.core.first(seq16943);
var seq16943__$1 = cljs.core.next(seq16943);
var G__16945 = cljs.core.first(seq16943__$1);
var seq16943__$2 = cljs.core.next(seq16943__$1);
var G__16946 = cljs.core.first(seq16943__$2);
var seq16943__$3 = cljs.core.next(seq16943__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__16944,G__16945,G__16946,seq16943__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var args16957 = [];
var len__5627__auto___16963 = arguments.length;
var i__5628__auto___16964 = (0);
while(true){
if((i__5628__auto___16964 < len__5627__auto___16963)){
args16957.push((arguments[i__5628__auto___16964]));

var G__16965 = (i__5628__auto___16964 + (1));
i__5628__auto___16964 = G__16965;
continue;
} else {
}
break;
}

var G__16962 = args16957.length;
switch (G__16962) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16957.slice((2)),(0)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__16967 = ret;
var G__16968 = cljs.core.first(ks);
var G__16969 = cljs.core.next(ks);
coll = G__16967;
k = G__16968;
ks = G__16969;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq16958){
var G__16959 = cljs.core.first(seq16958);
var seq16958__$1 = cljs.core.next(seq16958);
var G__16960 = cljs.core.first(seq16958__$1);
var seq16958__$2 = cljs.core.next(seq16958__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__16959,G__16960,seq16958__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__4569__auto__ = goog.isFunction(f);
if(or__4569__auto__){
return or__4569__auto__;
} else {
if(!((f == null))){
if((false) || (f.cljs$core$Fn$)){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.call = (function() {
var G__16975 = null;
var G__16975__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__16975__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__16975__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__16975__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__16975__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__16975__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__16975__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__16975__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__16975__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__16975__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__16975__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__16975__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__16975__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__16975__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__16975__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__16975__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__16975__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__16975__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__16975__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__16975__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__16975__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__16975__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});
G__16975 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__16975__1.call(this,self__);
case 2:
return G__16975__2.call(this,self__,a);
case 3:
return G__16975__3.call(this,self__,a,b);
case 4:
return G__16975__4.call(this,self__,a,b,c);
case 5:
return G__16975__5.call(this,self__,a,b,c,d);
case 6:
return G__16975__6.call(this,self__,a,b,c,d,e);
case 7:
return G__16975__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__16975__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__16975__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__16975__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__16975__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__16975__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__16975__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__16975__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__16975__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__16975__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__16975__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__16975__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__16975__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__16975__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__16975__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__16975__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__16975.cljs$core$IFn$_invoke$arity$1 = G__16975__1;
G__16975.cljs$core$IFn$_invoke$arity$2 = G__16975__2;
G__16975.cljs$core$IFn$_invoke$arity$3 = G__16975__3;
G__16975.cljs$core$IFn$_invoke$arity$4 = G__16975__4;
G__16975.cljs$core$IFn$_invoke$arity$5 = G__16975__5;
G__16975.cljs$core$IFn$_invoke$arity$6 = G__16975__6;
G__16975.cljs$core$IFn$_invoke$arity$7 = G__16975__7;
G__16975.cljs$core$IFn$_invoke$arity$8 = G__16975__8;
G__16975.cljs$core$IFn$_invoke$arity$9 = G__16975__9;
G__16975.cljs$core$IFn$_invoke$arity$10 = G__16975__10;
G__16975.cljs$core$IFn$_invoke$arity$11 = G__16975__11;
G__16975.cljs$core$IFn$_invoke$arity$12 = G__16975__12;
G__16975.cljs$core$IFn$_invoke$arity$13 = G__16975__13;
G__16975.cljs$core$IFn$_invoke$arity$14 = G__16975__14;
G__16975.cljs$core$IFn$_invoke$arity$15 = G__16975__15;
G__16975.cljs$core$IFn$_invoke$arity$16 = G__16975__16;
G__16975.cljs$core$IFn$_invoke$arity$17 = G__16975__17;
G__16975.cljs$core$IFn$_invoke$arity$18 = G__16975__18;
G__16975.cljs$core$IFn$_invoke$arity$19 = G__16975__19;
G__16975.cljs$core$IFn$_invoke$arity$20 = G__16975__20;
G__16975.cljs$core$IFn$_invoke$arity$21 = G__16975__21;
G__16975.cljs$core$IFn$_invoke$arity$22 = G__16975__22;
return G__16975;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args16974){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args16974)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__4557__auto__ = !((o == null));
if(and__4557__auto__){
if(!((o == null))){
if(((o.cljs$lang$protocol_mask$partition0$ & (131072))) || (o.cljs$core$IMeta$)){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__4557__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var args16980 = [];
var len__5627__auto___16986 = arguments.length;
var i__5628__auto___16987 = (0);
while(true){
if((i__5628__auto___16987 < len__5627__auto___16986)){
args16980.push((arguments[i__5628__auto___16987]));

var G__16988 = (i__5628__auto___16987 + (1));
i__5628__auto___16987 = G__16988;
continue;
} else {
}
break;
}

var G__16985 = args16980.length;
switch (G__16985) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args16980.slice((2)),(0)));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__16990 = ret;
var G__16991 = cljs.core.first(ks);
var G__16992 = cljs.core.next(ks);
coll = G__16990;
k = G__16991;
ks = G__16992;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq16981){
var G__16982 = cljs.core.first(seq16981);
var seq16981__$1 = cljs.core.next(seq16981);
var G__16983 = cljs.core.first(seq16981__$1);
var seq16981__$2 = cljs.core.next(seq16981__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__16982,G__16983,seq16981__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (8))) || (x.cljs$core$ICollection$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (4096))) || (x.cljs$core$ISet$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (512))) || (x.cljs$core$IAssociative$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || (x.cljs$core$ISequential$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || (x.cljs$core$ISorted$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (524288))) || (x.cljs$core$IReduce$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (1024))) || (x.cljs$core$IMap$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || (x.cljs$core$IRecord$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16384))) || (x.cljs$core$IVector$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});
cljs.core.ChunkedCons;

cljs.core.ChunkedSeq;
/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (512))) || (x.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var args17013 = [];
var len__5627__auto___17019 = arguments.length;
var i__5628__auto___17020 = (0);
while(true){
if((i__5628__auto___17020 < len__5627__auto___17019)){
args17013.push((arguments[i__5628__auto___17020]));

var G__17021 = (i__5628__auto___17020 + (1));
i__5628__auto___17020 = G__17021;
continue;
} else {
}
break;
}

var G__17016 = args17013.length;
switch (G__17016) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17013.slice((0)),(0)));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5646__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return {};
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq17014){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17014));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__17025_17027 = obj;
var G__17026_17028 = ((function (G__17025_17027,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__17025_17027,keys))
;
goog.object.forEach(G__17025_17027,G__17026_17028);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__17029 = (i__$1 + (1));
var G__17030 = (j__$1 + (1));
var G__17031 = (len__$1 - (1));
i__$1 = G__17029;
j__$1 = G__17030;
len__$1 = G__17031;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__17032 = (i__$1 - (1));
var G__17033 = (j__$1 - (1));
var G__17034 = (len__$1 - (1));
i__$1 = G__17032;
j__$1 = G__17033;
len__$1 = G__17034;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = {};
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (64))) || (s.cljs$core$ISeq$)){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || (s.cljs$core$ISeqable$)){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__4569__auto__ = cljs.core.fn_QMARK_(f);
if(or__4569__auto__){
return or__4569__auto__;
} else {
if(!((f == null))){
if(((f.cljs$lang$protocol_mask$partition0$ & (1))) || (f.cljs$core$IFn$)){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (!(isNaN(n))) && (!((n === Infinity))) && ((parseFloat(n) === parseInt(n,(10))));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var args17045 = [];
var len__5627__auto___17051 = arguments.length;
var i__5628__auto___17052 = (0);
while(true){
if((i__5628__auto___17052 < len__5627__auto___17051)){
args17045.push((arguments[i__5628__auto___17052]));

var G__17053 = (i__5628__auto___17052 + (1));
i__5628__auto___17052 = G__17053;
continue;
} else {
}
break;
}

var G__17050 = args17045.length;
switch (G__17050) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17045.slice((2)),(0)));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__17055 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__17056 = etc;
s = G__17055;
xs = G__17056;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq17046){
var G__17047 = cljs.core.first(seq17046);
var seq17046__$1 = cljs.core.next(seq17046);
var G__17048 = cljs.core.first(seq17046__$1);
var seq17046__$2 = cljs.core.next(seq17046__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__17047,G__17048,seq17046__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);
/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || (x.cljs$core$IComparable$))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false)) && ((cljs.core.type(x) === cljs.core.type(y)))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var args17059 = [];
var len__5627__auto___17062 = arguments.length;
var i__5628__auto___17063 = (0);
while(true){
if((i__5628__auto___17063 < len__5627__auto___17062)){
args17059.push((arguments[i__5628__auto___17063]));

var G__17064 = (i__5628__auto___17063 + (1));
i__5628__auto___17063 = G__17064;
continue;
} else {
}
break;
}

var G__17061 = args17059.length;
switch (G__17061) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17059.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__17066 = xs;
var G__17067 = ys;
var G__17068 = len;
var G__17069 = (n + (1));
xs = G__17066;
ys = G__17067;
len = G__17068;
n = G__17069;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
cljs.core.to_array;
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var args17070 = [];
var len__5627__auto___17075 = arguments.length;
var i__5628__auto___17076 = (0);
while(true){
if((i__5628__auto___17076 < len__5627__auto___17075)){
args17070.push((arguments[i__5628__auto___17076]));

var G__17077 = (i__5628__auto___17076 + (1));
i__5628__auto___17076 = G__17077;
continue;
} else {
}
break;
}

var G__17072 = args17070.length;
switch (G__17072) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17070.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
var G__17073_17079 = a;
var G__17074_17080 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__17073_17079,G__17074_17080);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var args17081 = [];
var len__5627__auto___17084 = arguments.length;
var i__5628__auto___17085 = (0);
while(true){
if((i__5628__auto___17085 < len__5627__auto___17084)){
args17081.push((arguments[i__5628__auto___17085]));

var G__17086 = (i__5628__auto___17085 + (1));
i__5628__auto___17085 = G__17086;
continue;
} else {
}
break;
}

var G__17083 = args17081.length;
switch (G__17083) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17081.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x)),(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y)));
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var args17088 = [];
var len__5627__auto___17096 = arguments.length;
var i__5628__auto___17097 = (0);
while(true){
if((i__5628__auto___17097 < len__5627__auto___17096)){
args17088.push((arguments[i__5628__auto___17097]));

var G__17098 = (i__5628__auto___17097 + (1));
i__5628__auto___17097 = G__17098;
continue;
} else {
}
break;
}

var G__17090 = args17088.length;
switch (G__17090) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17088.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
var G__17091 = f;
var G__17092 = cljs.core.first(s);
var G__17093 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__17091,G__17092,G__17093) : cljs.core.reduce.call(null,G__17091,G__17092,G__17093));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__17094 = val__$1;
var G__17095 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17094,G__17095) : f.call(null,G__17094,G__17095));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__17100 = nval;
var G__17101 = cljs.core.next(coll__$1);
val__$1 = G__17100;
coll__$1 = G__17101;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.vec;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
goog.array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var args17102 = [];
var len__5627__auto___17107 = arguments.length;
var i__5628__auto___17108 = (0);
while(true){
if((i__5628__auto___17108 < len__5627__auto___17107)){
args17102.push((arguments[i__5628__auto___17108]));

var G__17109 = (i__5628__auto___17108 + (1));
i__5628__auto___17108 = G__17109;
continue;
} else {
}
break;
}

var G__17104 = args17102.length;
switch (G__17104) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17102.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || (coll.cljs$core$IReduce$))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || (coll.cljs$core$IReduce$))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;
/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var args17111 = [];
var len__5627__auto___17114 = arguments.length;
var i__5628__auto___17115 = (0);
while(true){
if((i__5628__auto___17115 < len__5627__auto___17114)){
args17111.push((arguments[i__5628__auto___17115]));

var G__17116 = (i__5628__auto___17115 + (1));
i__5628__auto___17115 = G__17116;
continue;
} else {
}
break;
}

var G__17113 = args17111.length;
switch (G__17113) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17111.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__17118 = null;
var G__17118__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__17118__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__17118__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__17118 = function(x,y){
switch(arguments.length){
case 0:
return G__17118__0.call(this);
case 1:
return G__17118__1.call(this,x);
case 2:
return G__17118__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17118.cljs$core$IFn$_invoke$arity$0 = G__17118__0;
G__17118.cljs$core$IFn$_invoke$arity$1 = G__17118__1;
G__17118.cljs$core$IFn$_invoke$arity$2 = G__17118__2;
return G__17118;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;
/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var args17119 = [];
var len__5627__auto___17122 = arguments.length;
var i__5628__auto___17123 = (0);
while(true){
if((i__5628__auto___17123 < len__5627__auto___17122)){
args17119.push((arguments[i__5628__auto___17123]));

var G__17124 = (i__5628__auto___17123 + (1));
i__5628__auto___17123 = G__17124;
continue;
} else {
}
break;
}

var G__17121 = args17119.length;
switch (G__17121) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17119.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var args17126 = [];
var len__5627__auto___17132 = arguments.length;
var i__5628__auto___17133 = (0);
while(true){
if((i__5628__auto___17133 < len__5627__auto___17132)){
args17126.push((arguments[i__5628__auto___17133]));

var G__17134 = (i__5628__auto___17133 + (1));
i__5628__auto___17133 = G__17134;
continue;
} else {
}
break;
}

var G__17131 = args17126.length;
switch (G__17131) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17126.slice((2)),(0)));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq17127){
var G__17128 = cljs.core.first(seq17127);
var seq17127__$1 = cljs.core.next(seq17127);
var G__17129 = cljs.core.first(seq17127__$1);
var seq17127__$2 = cljs.core.next(seq17127__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__17128,G__17129,seq17127__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var args17136 = [];
var len__5627__auto___17142 = arguments.length;
var i__5628__auto___17143 = (0);
while(true){
if((i__5628__auto___17143 < len__5627__auto___17142)){
args17136.push((arguments[i__5628__auto___17143]));

var G__17144 = (i__5628__auto___17143 + (1));
i__5628__auto___17143 = G__17144;
continue;
} else {
}
break;
}

var G__17141 = args17136.length;
switch (G__17141) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17136.slice((2)),(0)));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq17137){
var G__17138 = cljs.core.first(seq17137);
var seq17137__$1 = cljs.core.next(seq17137);
var G__17139 = cljs.core.first(seq17137__$1);
var seq17137__$2 = cljs.core.next(seq17137__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__17138,G__17139,seq17137__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var args17146 = [];
var len__5627__auto___17152 = arguments.length;
var i__5628__auto___17153 = (0);
while(true){
if((i__5628__auto___17153 < len__5627__auto___17152)){
args17146.push((arguments[i__5628__auto___17153]));

var G__17154 = (i__5628__auto___17153 + (1));
i__5628__auto___17153 = G__17154;
continue;
} else {
}
break;
}

var G__17151 = args17146.length;
switch (G__17151) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17146.slice((2)),(0)));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq17147){
var G__17148 = cljs.core.first(seq17147);
var seq17147__$1 = cljs.core.next(seq17147);
var G__17149 = cljs.core.first(seq17147__$1);
var seq17147__$2 = cljs.core.next(seq17147__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__17148,G__17149,seq17147__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);
cljs.core.divide;
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var args17156 = [];
var len__5627__auto___17162 = arguments.length;
var i__5628__auto___17163 = (0);
while(true){
if((i__5628__auto___17163 < len__5627__auto___17162)){
args17156.push((arguments[i__5628__auto___17163]));

var G__17164 = (i__5628__auto___17163 + (1));
i__5628__auto___17163 = G__17164;
continue;
} else {
}
break;
}

var G__17161 = args17156.length;
switch (G__17161) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17156.slice((2)),(0)));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq17157){
var G__17158 = cljs.core.first(seq17157);
var seq17157__$1 = cljs.core.next(seq17157);
var G__17159 = cljs.core.first(seq17157__$1);
var seq17157__$2 = cljs.core.next(seq17157__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__17158,G__17159,seq17157__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var args17166 = [];
var len__5627__auto___17172 = arguments.length;
var i__5628__auto___17173 = (0);
while(true){
if((i__5628__auto___17173 < len__5627__auto___17172)){
args17166.push((arguments[i__5628__auto___17173]));

var G__17174 = (i__5628__auto___17173 + (1));
i__5628__auto___17173 = G__17174;
continue;
} else {
}
break;
}

var G__17171 = args17166.length;
switch (G__17171) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17166.slice((2)),(0)));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__17176 = y;
var G__17177 = cljs.core.first(more);
var G__17178 = cljs.core.next(more);
x = G__17176;
y = G__17177;
more = G__17178;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq17167){
var G__17168 = cljs.core.first(seq17167);
var seq17167__$1 = cljs.core.next(seq17167);
var G__17169 = cljs.core.first(seq17167__$1);
var seq17167__$2 = cljs.core.next(seq17167__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__17168,G__17169,seq17167__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var args17179 = [];
var len__5627__auto___17185 = arguments.length;
var i__5628__auto___17186 = (0);
while(true){
if((i__5628__auto___17186 < len__5627__auto___17185)){
args17179.push((arguments[i__5628__auto___17186]));

var G__17187 = (i__5628__auto___17186 + (1));
i__5628__auto___17186 = G__17187;
continue;
} else {
}
break;
}

var G__17184 = args17179.length;
switch (G__17184) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17179.slice((2)),(0)));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__17189 = y;
var G__17190 = cljs.core.first(more);
var G__17191 = cljs.core.next(more);
x = G__17189;
y = G__17190;
more = G__17191;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq17180){
var G__17181 = cljs.core.first(seq17180);
var seq17180__$1 = cljs.core.next(seq17180);
var G__17182 = cljs.core.first(seq17180__$1);
var seq17180__$2 = cljs.core.next(seq17180__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17181,G__17182,seq17180__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var args17192 = [];
var len__5627__auto___17198 = arguments.length;
var i__5628__auto___17199 = (0);
while(true){
if((i__5628__auto___17199 < len__5627__auto___17198)){
args17192.push((arguments[i__5628__auto___17199]));

var G__17200 = (i__5628__auto___17199 + (1));
i__5628__auto___17199 = G__17200;
continue;
} else {
}
break;
}

var G__17197 = args17192.length;
switch (G__17197) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17192.slice((2)),(0)));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__17202 = y;
var G__17203 = cljs.core.first(more);
var G__17204 = cljs.core.next(more);
x = G__17202;
y = G__17203;
more = G__17204;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq17193){
var G__17194 = cljs.core.first(seq17193);
var seq17193__$1 = cljs.core.next(seq17193);
var G__17195 = cljs.core.first(seq17193__$1);
var seq17193__$2 = cljs.core.next(seq17193__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__17194,G__17195,seq17193__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var args17205 = [];
var len__5627__auto___17211 = arguments.length;
var i__5628__auto___17212 = (0);
while(true){
if((i__5628__auto___17212 < len__5627__auto___17211)){
args17205.push((arguments[i__5628__auto___17212]));

var G__17213 = (i__5628__auto___17212 + (1));
i__5628__auto___17212 = G__17213;
continue;
} else {
}
break;
}

var G__17210 = args17205.length;
switch (G__17210) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17205.slice((2)),(0)));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__17215 = y;
var G__17216 = cljs.core.first(more);
var G__17217 = cljs.core.next(more);
x = G__17215;
y = G__17216;
more = G__17217;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq17206){
var G__17207 = cljs.core.first(seq17206);
var seq17206__$1 = cljs.core.next(seq17206);
var G__17208 = cljs.core.first(seq17206__$1);
var seq17206__$2 = cljs.core.next(seq17206__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17207,G__17208,seq17206__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var args17218 = [];
var len__5627__auto___17224 = arguments.length;
var i__5628__auto___17225 = (0);
while(true){
if((i__5628__auto___17225 < len__5627__auto___17224)){
args17218.push((arguments[i__5628__auto___17225]));

var G__17226 = (i__5628__auto___17225 + (1));
i__5628__auto___17225 = G__17226;
continue;
} else {
}
break;
}

var G__17223 = args17218.length;
switch (G__17223) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17218.slice((2)),(0)));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4900__auto__ = x;
var y__4901__auto__ = y;
return ((x__4900__auto__ > y__4901__auto__) ? x__4900__auto__ : y__4901__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4900__auto__ = x;
var y__4901__auto__ = y;
return ((x__4900__auto__ > y__4901__auto__) ? x__4900__auto__ : y__4901__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq17219){
var G__17220 = cljs.core.first(seq17219);
var seq17219__$1 = cljs.core.next(seq17219);
var G__17221 = cljs.core.first(seq17219__$1);
var seq17219__$2 = cljs.core.next(seq17219__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__17220,G__17221,seq17219__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);
/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var args17228 = [];
var len__5627__auto___17234 = arguments.length;
var i__5628__auto___17235 = (0);
while(true){
if((i__5628__auto___17235 < len__5627__auto___17234)){
args17228.push((arguments[i__5628__auto___17235]));

var G__17236 = (i__5628__auto___17235 + (1));
i__5628__auto___17235 = G__17236;
continue;
} else {
}
break;
}

var G__17233 = args17228.length;
switch (G__17233) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17228.slice((2)),(0)));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4907__auto__ = x;
var y__4908__auto__ = y;
return ((x__4907__auto__ < y__4908__auto__) ? x__4907__auto__ : y__4908__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4907__auto__ = x;
var y__4908__auto__ = y;
return ((x__4907__auto__ < y__4908__auto__) ? x__4907__auto__ : y__4908__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq17229){
var G__17230 = cljs.core.first(seq17229);
var seq17229__$1 = cljs.core.next(seq17229);
var G__17231 = cljs.core.first(seq17229__$1);
var seq17229__$2 = cljs.core.next(seq17229__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__17230,G__17231,seq17229__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var args17238 = [];
var len__5627__auto___17244 = arguments.length;
var i__5628__auto___17245 = (0);
while(true){
if((i__5628__auto___17245 < len__5627__auto___17244)){
args17238.push((arguments[i__5628__auto___17245]));

var G__17246 = (i__5628__auto___17245 + (1));
i__5628__auto___17245 = G__17246;
continue;
} else {
}
break;
}

var G__17243 = args17238.length;
switch (G__17243) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17238.slice((2)),(0)));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq17239){
var G__17240 = cljs.core.first(seq17239);
var seq17239__$1 = cljs.core.next(seq17239);
var G__17241 = cljs.core.first(seq17239__$1);
var seq17239__$2 = cljs.core.next(seq17239__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__17240,G__17241,seq17239__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var args17248 = [];
var len__5627__auto___17254 = arguments.length;
var i__5628__auto___17255 = (0);
while(true){
if((i__5628__auto___17255 < len__5627__auto___17254)){
args17248.push((arguments[i__5628__auto___17255]));

var G__17256 = (i__5628__auto___17255 + (1));
i__5628__auto___17255 = G__17256;
continue;
} else {
}
break;
}

var G__17253 = args17248.length;
switch (G__17253) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17248.slice((2)),(0)));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq17249){
var G__17250 = cljs.core.first(seq17249);
var seq17249__$1 = cljs.core.next(seq17249);
var G__17251 = cljs.core.first(seq17249__$1);
var seq17249__$2 = cljs.core.next(seq17249__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__17250,G__17251,seq17249__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var args17258 = [];
var len__5627__auto___17264 = arguments.length;
var i__5628__auto___17265 = (0);
while(true){
if((i__5628__auto___17265 < len__5627__auto___17264)){
args17258.push((arguments[i__5628__auto___17265]));

var G__17266 = (i__5628__auto___17265 + (1));
i__5628__auto___17265 = G__17266;
continue;
} else {
}
break;
}

var G__17263 = args17258.length;
switch (G__17263) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17258.slice((2)),(0)));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq17259){
var G__17260 = cljs.core.first(seq17259);
var seq17259__$1 = cljs.core.next(seq17259);
var G__17261 = cljs.core.first(seq17259__$1);
var seq17259__$2 = cljs.core.next(seq17259__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__17260,G__17261,seq17259__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var args17268 = [];
var len__5627__auto___17274 = arguments.length;
var i__5628__auto___17275 = (0);
while(true){
if((i__5628__auto___17275 < len__5627__auto___17274)){
args17268.push((arguments[i__5628__auto___17275]));

var G__17276 = (i__5628__auto___17275 + (1));
i__5628__auto___17275 = G__17276;
continue;
} else {
}
break;
}

var G__17273 = args17268.length;
switch (G__17273) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17268.slice((2)),(0)));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq17269){
var G__17270 = cljs.core.first(seq17269);
var seq17269__$1 = cljs.core.next(seq17269);
var G__17271 = cljs.core.first(seq17269__$1);
var seq17269__$2 = cljs.core.next(seq17269__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__17270,G__17271,seq17269__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var args17278 = [];
var len__5627__auto___17284 = arguments.length;
var i__5628__auto___17285 = (0);
while(true){
if((i__5628__auto___17285 < len__5627__auto___17284)){
args17278.push((arguments[i__5628__auto___17285]));

var G__17286 = (i__5628__auto___17285 + (1));
i__5628__auto___17285 = G__17286;
continue;
} else {
}
break;
}

var G__17283 = args17278.length;
switch (G__17283) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17278.slice((2)),(0)));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq17279){
var G__17280 = cljs.core.first(seq17279);
var seq17279__$1 = cljs.core.next(seq17279);
var G__17281 = cljs.core.first(seq17279__$1);
var seq17279__$2 = cljs.core.next(seq17279__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__17280,G__17281,seq17279__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.mod;
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var args17288 = [];
var len__5627__auto___17294 = arguments.length;
var i__5628__auto___17295 = (0);
while(true){
if((i__5628__auto___17295 < len__5627__auto___17294)){
args17288.push((arguments[i__5628__auto___17295]));

var G__17296 = (i__5628__auto___17295 + (1));
i__5628__auto___17295 = G__17296;
continue;
} else {
}
break;
}

var G__17293 = args17288.length;
switch (G__17293) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17288.slice((2)),(0)));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq17289){
var G__17290 = cljs.core.first(seq17289);
var seq17289__$1 = cljs.core.next(seq17289);
var G__17291 = cljs.core.first(seq17289__$1);
var seq17289__$2 = cljs.core.next(seq17289__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__17290,G__17291,seq17289__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var args17298 = [];
var len__5627__auto___17304 = arguments.length;
var i__5628__auto___17305 = (0);
while(true){
if((i__5628__auto___17305 < len__5627__auto___17304)){
args17298.push((arguments[i__5628__auto___17305]));

var G__17306 = (i__5628__auto___17305 + (1));
i__5628__auto___17305 = G__17306;
continue;
} else {
}
break;
}

var G__17303 = args17298.length;
switch (G__17303) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17298.slice((2)),(0)));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq17299){
var G__17300 = cljs.core.first(seq17299);
var seq17299__$1 = cljs.core.next(seq17299);
var G__17301 = cljs.core.first(seq17299__$1);
var seq17299__$2 = cljs.core.next(seq17299__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__17300,G__17301,seq17299__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var args17308 = [];
var len__5627__auto___17314 = arguments.length;
var i__5628__auto___17315 = (0);
while(true){
if((i__5628__auto___17315 < len__5627__auto___17314)){
args17308.push((arguments[i__5628__auto___17315]));

var G__17316 = (i__5628__auto___17315 + (1));
i__5628__auto___17315 = G__17316;
continue;
} else {
}
break;
}

var G__17313 = args17308.length;
switch (G__17313) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17308.slice((2)),(0)));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq17309){
var G__17310 = cljs.core.first(seq17309);
var seq17309__$1 = cljs.core.next(seq17309);
var G__17311 = cljs.core.first(seq17309__$1);
var seq17309__$2 = cljs.core.next(seq17309__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__17310,G__17311,seq17309__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var args17318 = [];
var len__5627__auto___17324 = arguments.length;
var i__5628__auto___17325 = (0);
while(true){
if((i__5628__auto___17325 < len__5627__auto___17324)){
args17318.push((arguments[i__5628__auto___17325]));

var G__17326 = (i__5628__auto___17325 + (1));
i__5628__auto___17325 = G__17326;
continue;
} else {
}
break;
}

var G__17323 = args17318.length;
switch (G__17323) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17318.slice((2)),(0)));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq17319){
var G__17320 = cljs.core.first(seq17319);
var seq17319__$1 = cljs.core.next(seq17319);
var G__17321 = cljs.core.first(seq17319__$1);
var seq17319__$2 = cljs.core.next(seq17319__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__17320,G__17321,seq17319__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var args17328 = [];
var len__5627__auto___17334 = arguments.length;
var i__5628__auto___17335 = (0);
while(true){
if((i__5628__auto___17335 < len__5627__auto___17334)){
args17328.push((arguments[i__5628__auto___17335]));

var G__17336 = (i__5628__auto___17335 + (1));
i__5628__auto___17335 = G__17336;
continue;
} else {
}
break;
}

var G__17333 = args17328.length;
switch (G__17333) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17328.slice((2)),(0)));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq17329){
var G__17330 = cljs.core.first(seq17329);
var seq17329__$1 = cljs.core.next(seq17329);
var G__17331 = cljs.core.first(seq17329__$1);
var seq17329__$2 = cljs.core.next(seq17329__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__17330,G__17331,seq17329__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise and
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var args17338 = [];
var len__5627__auto___17344 = arguments.length;
var i__5628__auto___17345 = (0);
while(true){
if((i__5628__auto___17345 < len__5627__auto___17344)){
args17338.push((arguments[i__5628__auto___17345]));

var G__17346 = (i__5628__auto___17345 + (1));
i__5628__auto___17345 = G__17346;
continue;
} else {
}
break;
}

var G__17343 = args17338.length;
switch (G__17343) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17338.slice((2)),(0)));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq17339){
var G__17340 = cljs.core.first(seq17339);
var seq17339__$1 = cljs.core.next(seq17339);
var G__17341 = cljs.core.first(seq17339__$1);
var seq17339__$2 = cljs.core.next(seq17339__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__17340,G__17341,seq17339__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var args17348 = [];
var len__5627__auto___17354 = arguments.length;
var i__5628__auto___17355 = (0);
while(true){
if((i__5628__auto___17355 < len__5627__auto___17354)){
args17348.push((arguments[i__5628__auto___17355]));

var G__17356 = (i__5628__auto___17355 + (1));
i__5628__auto___17355 = G__17356;
continue;
} else {
}
break;
}

var G__17353 = args17348.length;
switch (G__17353) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17348.slice((2)),(0)));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__17358 = y;
var G__17359 = cljs.core.first(more);
var G__17360 = cljs.core.next(more);
x = G__17358;
y = G__17359;
more = G__17360;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq17349){
var G__17350 = cljs.core.first(seq17349);
var seq17349__$1 = cljs.core.next(seq17349);
var G__17351 = cljs.core.first(seq17349__$1);
var seq17349__$2 = cljs.core.next(seq17349__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17350,G__17351,seq17349__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__17361 = (n__$1 - (1));
var G__17362 = cljs.core.next(xs);
n__$1 = G__17361;
xs = G__17362;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var args17363 = [];
var len__5627__auto___17368 = arguments.length;
var i__5628__auto___17369 = (0);
while(true){
if((i__5628__auto___17369 < len__5627__auto___17368)){
args17363.push((arguments[i__5628__auto___17369]));

var G__17370 = (i__5628__auto___17369 + (1));
i__5628__auto___17369 = G__17370;
continue;
} else {
}
break;
}

var G__17367 = args17363.length;
switch (G__17367) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17363.slice((1)),(0)));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__17372 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__17373 = cljs.core.next(more);
sb = G__17372;
more = G__17373;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq17364){
var G__17365 = cljs.core.first(seq17364);
var seq17364__$1 = cljs.core.next(seq17364);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__17365,seq17364__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);
/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var args17374 = [];
var len__5627__auto___17377 = arguments.length;
var i__5628__auto___17378 = (0);
while(true){
if((i__5628__auto___17378 < len__5627__auto___17377)){
args17374.push((arguments[i__5628__auto___17378]));

var G__17379 = (i__5628__auto___17378 + (1));
i__5628__auto___17378 = G__17379;
continue;
} else {
}
break;
}

var G__17376 = args17374.length;
switch (G__17376) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17374.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.map;

cljs.core.name;
/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__17381 = cljs.core.next(xs);
var G__17382 = cljs.core.next(ys);
xs = G__17381;
ys = G__17382;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__17383 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__17384 = cljs.core.next(s);
res = G__17383;
s = G__17384;
continue;
}
break;
}
} else {
return (0);
}
});
cljs.core.key;

cljs.core.val;
cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__17385 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));
var G__17386 = cljs.core.next(s);
h = G__17385;
s = G__17386;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__17387 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__17388 = cljs.core.next(s__$1);
h = G__17387;
s__$1 = G__17388;
continue;
} else {
return h;
}
break;
}
});
cljs.core.name;

cljs.core.chunk_first;

cljs.core.chunk_rest;
/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__17395_17401 = cljs.core.seq(fn_map);
var chunk__17396_17402 = null;
var count__17397_17403 = (0);
var i__17398_17404 = (0);
while(true){
if((i__17398_17404 < count__17397_17403)){
var vec__17399_17405 = chunk__17396_17402.cljs$core$IIndexed$_nth$arity$2(null,i__17398_17404);
var key_name_17406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17399_17405,(0),null);
var f_17407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17399_17405,(1),null);
var str_name_17408 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_17406) : cljs.core.name.call(null,key_name_17406));
(obj[str_name_17408] = f_17407);

var G__17409 = seq__17395_17401;
var G__17410 = chunk__17396_17402;
var G__17411 = count__17397_17403;
var G__17412 = (i__17398_17404 + (1));
seq__17395_17401 = G__17409;
chunk__17396_17402 = G__17410;
count__17397_17403 = G__17411;
i__17398_17404 = G__17412;
continue;
} else {
var temp__4425__auto___17413 = cljs.core.seq(seq__17395_17401);
if(temp__4425__auto___17413){
var seq__17395_17414__$1 = temp__4425__auto___17413;
if(cljs.core.chunked_seq_QMARK_(seq__17395_17414__$1)){
var c__5372__auto___17415 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__17395_17414__$1) : cljs.core.chunk_first.call(null,seq__17395_17414__$1));
var G__17416 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__17395_17414__$1) : cljs.core.chunk_rest.call(null,seq__17395_17414__$1));
var G__17417 = c__5372__auto___17415;
var G__17418 = cljs.core.count(c__5372__auto___17415);
var G__17419 = (0);
seq__17395_17401 = G__17416;
chunk__17396_17402 = G__17417;
count__17397_17403 = G__17418;
i__17398_17404 = G__17419;
continue;
} else {
var vec__17400_17420 = cljs.core.first(seq__17395_17414__$1);
var key_name_17421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17400_17420,(0),null);
var f_17422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17400_17420,(1),null);
var str_name_17423 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_17421) : cljs.core.name.call(null,key_name_17421));
(obj[str_name_17423] = f_17422);

var G__17424 = cljs.core.next(seq__17395_17414__$1);
var G__17425 = null;
var G__17426 = (0);
var G__17427 = (0);
seq__17395_17401 = G__17424;
chunk__17396_17402 = G__17425;
count__17397_17403 = G__17426;
i__17398_17404 = G__17427;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.Symbol(null,"count","count",-514511684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || (x.cljs$core$IList$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || (coll.cljs$core$IReversible$)){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__5634__auto__ = [];
var len__5627__auto___17433 = arguments.length;
var i__5628__auto___17434 = (0);
while(true){
if((i__5628__auto___17434 < len__5627__auto___17433)){
args__5634__auto__.push((arguments[i__5628__auto___17434]));

var G__17435 = (i__5628__auto___17434 + (1));
i__5628__auto___17434 = G__17435;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__17436 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__17436;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__17437 = (i - (1));
var G__17438 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__17437;
r = G__17438;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq17432){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq17432));
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rest","rest",398835108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__4569__auto__ = (coll == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__4557__auto__ = cljs.core.not(a.ns);
if(and__4557__auto__){
return b.ns;
} else {
return and__4557__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__17449 = a.ns;
var G__17450 = b.ns;
return goog.array.defaultCompare(G__17449,G__17450);
})();
if(((0) === nsc)){
var G__17451 = a.name;
var G__17452 = b.name;
return goog.array.defaultCompare(G__17451,G__17452);
} else {
return nsc;
}
}
} else {
var G__17453 = a.name;
var G__17454 = b.name;
return goog.array.defaultCompare(G__17453,G__17454);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__17456 = null;
var G__17456__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__17456__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__17456 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__17456__2.call(this,self__,coll);
case 3:
return G__17456__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17456.cljs$core$IFn$_invoke$arity$2 = G__17456__2;
G__17456.cljs$core$IFn$_invoke$arity$3 = G__17456__3;
return G__17456;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args17455){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args17455)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__5004__auto__ = self__._hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ns","ns",2082130287,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"fqn","fqn",-1749334463,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbol are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || (x.cljs$core$INamed$))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var args17459 = [];
var len__5627__auto___17462 = arguments.length;
var i__5628__auto___17463 = (0);
while(true){
if((i__5628__auto___17463 < len__5627__auto___17462)){
args17459.push((arguments[i__5628__auto___17463]));

var G__17464 = (i__5628__auto___17463 + (1));
i__5628__auto___17463 = G__17464;
continue;
} else {
}
break;
}

var G__17461 = args17459.length;
switch (G__17461) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17459.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__17466 = ls.sval();
ls = G__17466;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"fn","fn",465265323,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.ArrayChunk;

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"buf","buf",1426618187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var args17467 = [];
var len__5627__auto___17470 = arguments.length;
var i__5628__auto___17471 = (0);
while(true){
if((i__5628__auto___17471 < len__5627__auto___17470)){
args17467.push((arguments[i__5628__auto___17471]));

var G__17472 = (i__5628__auto___17471 + (1));
i__5628__auto___17471 = G__17472;
continue;
} else {
}
break;
}

var G__17469 = args17467.length;
switch (G__17469) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17467.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"chunk","chunk",449371907,null),new cljs.core.Symbol(null,"more","more",-418290273,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if(((!((s == null)))?((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || (s.cljs$core$IChunkedNext$))?true:false):false)){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__17476 = cljs.core.next(s__$1);
s__$1 = G__17476;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_17477 = (0);
var xs_17478 = cljs.core.seq(coll);
while(true){
if(xs_17478){
(ret[i_17477] = cljs.core.to_array(cljs.core.first(xs_17478)));

var G__17479 = (i_17477 + (1));
var G__17480 = cljs.core.next(xs_17478);
i_17477 = G__17479;
xs_17478 = G__17480;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var args17481 = [];
var len__5627__auto___17484 = arguments.length;
var i__5628__auto___17485 = (0);
while(true){
if((i__5628__auto___17485 < len__5627__auto___17484)){
args17481.push((arguments[i__5628__auto___17485]));

var G__17486 = (i__5628__auto___17485 + (1));
i__5628__auto___17485 = G__17486;
continue;
} else {
}
break;
}

var G__17483 = args17481.length;
switch (G__17483) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17481.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__17488 = (i + (1));
var G__17489 = cljs.core.next(s__$1);
i = G__17488;
s__$1 = G__17489;
continue;
} else {
return a;
}
break;
}
} else {
var n__5472__auto___17490 = size;
var i_17491 = (0);
while(true){
if((i_17491 < n__5472__auto___17490)){
(a[i_17491] = init_val_or_seq);

var G__17492 = (i_17491 + (1));
i_17491 = G__17492;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var args17493 = [];
var len__5627__auto___17496 = arguments.length;
var i__5628__auto___17497 = (0);
while(true){
if((i__5628__auto___17497 < len__5627__auto___17496)){
args17493.push((arguments[i__5628__auto___17497]));

var G__17498 = (i__5628__auto___17497 + (1));
i__5628__auto___17497 = G__17498;
continue;
} else {
}
break;
}

var G__17495 = args17493.length;
switch (G__17495) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17493.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__17500 = (i + (1));
var G__17501 = cljs.core.next(s__$1);
i = G__17500;
s__$1 = G__17501;
continue;
} else {
return a;
}
break;
}
} else {
var n__5472__auto___17502 = size;
var i_17503 = (0);
while(true){
if((i_17503 < n__5472__auto___17502)){
(a[i_17503] = init_val_or_seq);

var G__17504 = (i_17503 + (1));
i_17503 = G__17504;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var args17505 = [];
var len__5627__auto___17508 = arguments.length;
var i__5628__auto___17509 = (0);
while(true){
if((i__5628__auto___17509 < len__5627__auto___17508)){
args17505.push((arguments[i__5628__auto___17509]));

var G__17510 = (i__5628__auto___17509 + (1));
i__5628__auto___17509 = G__17510;
continue;
} else {
}
break;
}

var G__17507 = args17505.length;
switch (G__17507) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17505.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__17512 = (i + (1));
var G__17513 = cljs.core.next(s__$1);
i = G__17512;
s__$1 = G__17513;
continue;
} else {
return a;
}
break;
}
} else {
var n__5472__auto___17514 = size;
var i_17515 = (0);
while(true){
if((i_17515 < n__5472__auto___17514)){
(a[i_17515] = init_val_or_seq);

var G__17516 = (i_17515 + (1));
i_17515 = G__17516;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var args17517 = [];
var len__5627__auto___17520 = arguments.length;
var i__5628__auto___17521 = (0);
while(true){
if((i__5628__auto___17521 < len__5627__auto___17520)){
args17517.push((arguments[i__5628__auto___17521]));

var G__17522 = (i__5628__auto___17521 + (1));
i__5628__auto___17521 = G__17522;
continue;
} else {
}
break;
}

var G__17519 = args17517.length;
switch (G__17519) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17517.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__17524 = (i + (1));
var G__17525 = cljs.core.next(s__$1);
i = G__17524;
s__$1 = G__17525;
continue;
} else {
return a;
}
break;
}
} else {
var n__5472__auto___17526 = size;
var i_17527 = (0);
while(true){
if((i_17527 < n__5472__auto___17526)){
(a[i_17527] = init_val_or_seq);

var G__17528 = (i_17527 + (1));
i_17527 = G__17528;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__17529 = cljs.core.next(s__$1);
var G__17530 = (i - (1));
var G__17531 = (sum + (1));
s__$1 = G__17529;
i = G__17530;
sum = G__17531;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var args17533 = [];
var len__5627__auto___17545 = arguments.length;
var i__5628__auto___17546 = (0);
while(true){
if((i__5628__auto___17546 < len__5627__auto___17545)){
args17533.push((arguments[i__5628__auto___17546]));

var G__17547 = (i__5628__auto___17546 + (1));
i__5628__auto___17546 = G__17547;
continue;
} else {
}
break;
}

var G__17538 = args17533.length;
switch (G__17538) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17533.slice((2)),(0)));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq17534){
var G__17535 = cljs.core.first(seq17534);
var seq17534__$1 = cljs.core.next(seq17534);
var G__17536 = cljs.core.first(seq17534__$1);
var seq17534__$2 = cljs.core.next(seq17534__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__17535,G__17536,seq17534__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);
/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var args17549 = [];
var len__5627__auto___17557 = arguments.length;
var i__5628__auto___17558 = (0);
while(true){
if((i__5628__auto___17558 < len__5627__auto___17557)){
args17549.push((arguments[i__5628__auto___17558]));

var G__17559 = (i__5628__auto___17558 + (1));
i__5628__auto___17558 = G__17559;
continue;
} else {
}
break;
}

var G__17556 = args17549.length;
switch (G__17556) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17549.slice((4)),(0)));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5646__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq17550){
var G__17551 = cljs.core.first(seq17550);
var seq17550__$1 = cljs.core.next(seq17550);
var G__17552 = cljs.core.first(seq17550__$1);
var seq17550__$2 = cljs.core.next(seq17550__$1);
var G__17553 = cljs.core.first(seq17550__$2);
var seq17550__$3 = cljs.core.next(seq17550__$2);
var G__17554 = cljs.core.first(seq17550__$3);
var seq17550__$4 = cljs.core.next(seq17550__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__17551,G__17552,G__17553,G__17554,seq17550__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var args17561 = [];
var len__5627__auto___17567 = arguments.length;
var i__5628__auto___17568 = (0);
while(true){
if((i__5628__auto___17568 < len__5627__auto___17567)){
args17561.push((arguments[i__5628__auto___17568]));

var G__17569 = (i__5628__auto___17568 + (1));
i__5628__auto___17568 = G__17569;
continue;
} else {
}
break;
}

var G__17566 = args17561.length;
switch (G__17566) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17561.slice((2)),(0)));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__17571 = ntcoll;
var G__17572 = cljs.core.first(vals);
var G__17573 = cljs.core.next(vals);
tcoll = G__17571;
val = G__17572;
vals = G__17573;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq17562){
var G__17563 = cljs.core.first(seq17562);
var seq17562__$1 = cljs.core.next(seq17562);
var G__17564 = cljs.core.first(seq17562__$1);
var seq17562__$2 = cljs.core.next(seq17562__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17563,G__17564,seq17562__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var args17574 = [];
var len__5627__auto___17581 = arguments.length;
var i__5628__auto___17582 = (0);
while(true){
if((i__5628__auto___17582 < len__5627__auto___17581)){
args17574.push((arguments[i__5628__auto___17582]));

var G__17583 = (i__5628__auto___17582 + (1));
i__5628__auto___17582 = G__17583;
continue;
} else {
}
break;
}

var G__17580 = args17574.length;
switch (G__17580) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17574.slice((3)),(0)));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__17585 = ntcoll;
var G__17586 = cljs.core.first(kvs);
var G__17587 = cljs.core.second(kvs);
var G__17588 = cljs.core.nnext(kvs);
tcoll = G__17585;
key = G__17586;
val = G__17587;
kvs = G__17588;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq17575){
var G__17576 = cljs.core.first(seq17575);
var seq17575__$1 = cljs.core.next(seq17575);
var G__17577 = cljs.core.first(seq17575__$1);
var seq17575__$2 = cljs.core.next(seq17575__$1);
var G__17578 = cljs.core.first(seq17575__$2);
var seq17575__$3 = cljs.core.next(seq17575__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17576,G__17577,G__17578,seq17575__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var args17589 = [];
var len__5627__auto___17595 = arguments.length;
var i__5628__auto___17596 = (0);
while(true){
if((i__5628__auto___17596 < len__5627__auto___17595)){
args17589.push((arguments[i__5628__auto___17596]));

var G__17597 = (i__5628__auto___17596 + (1));
i__5628__auto___17596 = G__17597;
continue;
} else {
}
break;
}

var G__17594 = args17589.length;
switch (G__17594) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17589.slice((2)),(0)));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__17599 = ntcoll;
var G__17600 = cljs.core.first(ks);
var G__17601 = cljs.core.next(ks);
tcoll = G__17599;
key = G__17600;
ks = G__17601;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq17590){
var G__17591 = cljs.core.first(seq17590);
var seq17590__$1 = cljs.core.next(seq17590);
var G__17592 = cljs.core.first(seq17590__$1);
var seq17590__$2 = cljs.core.next(seq17590__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17591,G__17592,seq17590__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var args17602 = [];
var len__5627__auto___17608 = arguments.length;
var i__5628__auto___17609 = (0);
while(true){
if((i__5628__auto___17609 < len__5627__auto___17608)){
args17602.push((arguments[i__5628__auto___17609]));

var G__17610 = (i__5628__auto___17609 + (1));
i__5628__auto___17609 = G__17610;
continue;
} else {
}
break;
}

var G__17607 = args17602.length;
switch (G__17607) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17602.slice((2)),(0)));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__17612 = ntcoll;
var G__17613 = cljs.core.first(vals);
var G__17614 = cljs.core.next(vals);
tcoll = G__17612;
val = G__17613;
vals = G__17614;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq17603){
var G__17604 = cljs.core.first(seq17603);
var seq17603__$1 = cljs.core.next(seq17603);
var G__17605 = cljs.core.first(seq17603__$1);
var seq17603__$2 = cljs.core.next(seq17603__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17604,G__17605,seq17603__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a5516 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a5516);
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a5516) : f.call(null,a5516));
}
} else {
var b5517 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a5516,b5517);
} else {
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a5516,b5517) : f.call(null,a5516,b5517));
}
} else {
var c5518 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a5516,b5517,c5518);
} else {
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a5516,b5517,c5518) : f.call(null,a5516,b5517,c5518));
}
} else {
var d5519 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a5516,b5517,c5518,d5519);
} else {
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a5516,b5517,c5518,d5519) : f.call(null,a5516,b5517,c5518,d5519));
}
} else {
var e5520 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a5516,b5517,c5518,d5519,e5520);
} else {
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a5516,b5517,c5518,d5519,e5520) : f.call(null,a5516,b5517,c5518,d5519,e5520));
}
} else {
var f5521 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a5516,b5517,c5518,d5519,e5520,f5521);
} else {
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a5516,b5517,c5518,d5519,e5520,f5521) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521));
}
} else {
var g5522 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a5516,b5517,c5518,d5519,e5520,f5521,g5522);
} else {
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a5516,b5517,c5518,d5519,e5520,f5521,g5522) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522));
}
} else {
var h5523 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523);
} else {
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523));
}
} else {
var i5524 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524);
} else {
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524));
}
} else {
var j5525 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525);
} else {
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525));
}
} else {
var k5526 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526);
} else {
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526));
}
} else {
var l5527 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527);
} else {
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527));
}
} else {
var m5528 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528);
} else {
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528));
}
} else {
var n5529 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529);
} else {
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529));
}
} else {
var o5530 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530);
} else {
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530));
}
} else {
var p5531 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531);
} else {
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531));
}
} else {
var q5532 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532);
} else {
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532));
}
} else {
var r5533 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533);
} else {
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533));
}
} else {
var s5534 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533,s5534);
} else {
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533,s5534) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533,s5534));
}
} else {
var t5535 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533,s5534,t5535);
} else {
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533,s5534,t5535) : f.call(null,a5516,b5517,c5518,d5519,e5520,f5521,g5522,h5523,i5524,j5525,k5526,l5527,m5528,n5529,o5530,p5531,q5532,r5533,s5534,t5535));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var args17615 = [];
var len__5627__auto___17624 = arguments.length;
var i__5628__auto___17625 = (0);
while(true){
if((i__5628__auto___17625 < len__5627__auto___17624)){
args17615.push((arguments[i__5628__auto___17625]));

var G__17626 = (i__5628__auto___17625 + (1));
i__5628__auto___17625 = G__17626;
continue;
} else {
}
break;
}

var G__17623 = args17615.length;
switch (G__17623) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17615.slice((5)),(0)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__5646__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq17616){
var G__17617 = cljs.core.first(seq17616);
var seq17616__$1 = cljs.core.next(seq17616);
var G__17618 = cljs.core.first(seq17616__$1);
var seq17616__$2 = cljs.core.next(seq17616__$1);
var G__17619 = cljs.core.first(seq17616__$2);
var seq17616__$3 = cljs.core.next(seq17616__$2);
var G__17620 = cljs.core.first(seq17616__$3);
var seq17616__$4 = cljs.core.next(seq17616__$3);
var G__17621 = cljs.core.first(seq17616__$4);
var seq17616__$5 = cljs.core.next(seq17616__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__17617,G__17618,G__17619,G__17620,G__17621,seq17616__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var args17628 = [];
var len__5627__auto___17653 = arguments.length;
var i__5628__auto___17654 = (0);
while(true){
if((i__5628__auto___17654 < len__5627__auto___17653)){
args17628.push((arguments[i__5628__auto___17654]));

var G__17655 = (i__5628__auto___17654 + (1));
i__5628__auto___17654 = G__17655;
continue;
} else {
}
break;
}

var G__17637 = args17628.length;
switch (G__17637) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17628.slice((6)),(0)));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5646__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__17638 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17638) : f.call(null,G__17638));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__17639 = cljs.core.meta(obj);
var G__17640 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17639,G__17640) : f.call(null,G__17639,G__17640));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__17641 = cljs.core.meta(obj);
var G__17642 = a;
var G__17643 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17641,G__17642,G__17643) : f.call(null,G__17641,G__17642,G__17643));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__17644 = cljs.core.meta(obj);
var G__17645 = a;
var G__17646 = b;
var G__17647 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17644,G__17645,G__17646,G__17647) : f.call(null,G__17644,G__17645,G__17646,G__17647));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__17648 = cljs.core.meta(obj);
var G__17649 = a;
var G__17650 = b;
var G__17651 = c;
var G__17652 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17648,G__17649,G__17650,G__17651,G__17652) : f.call(null,G__17648,G__17649,G__17650,G__17651,G__17652));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq17629){
var G__17630 = cljs.core.first(seq17629);
var seq17629__$1 = cljs.core.next(seq17629);
var G__17631 = cljs.core.first(seq17629__$1);
var seq17629__$2 = cljs.core.next(seq17629__$1);
var G__17632 = cljs.core.first(seq17629__$2);
var seq17629__$3 = cljs.core.next(seq17629__$2);
var G__17633 = cljs.core.first(seq17629__$3);
var seq17629__$4 = cljs.core.next(seq17629__$3);
var G__17634 = cljs.core.first(seq17629__$4);
var seq17629__$5 = cljs.core.next(seq17629__$4);
var G__17635 = cljs.core.first(seq17629__$5);
var seq17629__$6 = cljs.core.next(seq17629__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__17630,G__17631,G__17632,G__17633,G__17634,G__17635,seq17629__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);
/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var args17657 = [];
var len__5627__auto___17663 = arguments.length;
var i__5628__auto___17664 = (0);
while(true){
if((i__5628__auto___17664 < len__5627__auto___17663)){
args17657.push((arguments[i__5628__auto___17664]));

var G__17665 = (i__5628__auto___17664 + (1));
i__5628__auto___17664 = G__17665;
continue;
} else {
}
break;
}

var G__17662 = args17657.length;
switch (G__17662) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17657.slice((2)),(0)));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq17658){
var G__17659 = cljs.core.first(seq17658);
var seq17658__$1 = cljs.core.next(seq17658);
var G__17660 = cljs.core.first(seq17658__$1);
var seq17658__$2 = cljs.core.next(seq17658__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17659,G__17660,seq17658__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t_cljs$core17670 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core17670 = (function (nil_iter,meta17671){
this.nil_iter = nil_iter;
this.meta17671 = meta17671;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t_cljs$core17670.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17672,meta17671__$1){
var self__ = this;
var _17672__$1 = this;
return (new cljs.core.t_cljs$core17670(self__.nil_iter,meta17671__$1));
});

cljs.core.t_cljs$core17670.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17672){
var self__ = this;
var _17672__$1 = this;
return self__.meta17671;
});

cljs.core.t_cljs$core17670.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t_cljs$core17670.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t_cljs$core17670.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t_cljs$core17670.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"nil-iter","nil-iter",1101030523,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"meta17671","meta17671",-582966006,null)], null);
});

cljs.core.t_cljs$core17670.cljs$lang$type = true;

cljs.core.t_cljs$core17670.cljs$lang$ctorStr = "cljs.core/t_cljs$core17670";

cljs.core.t_cljs$core17670.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/t_cljs$core17670");
});

cljs.core.__GT_t_cljs$core17670 = (function cljs$core$nil_iter_$___GT_t_cljs$core17670(nil_iter__$1,meta17671){
return (new cljs.core.t_cljs$core17670(nil_iter__$1,meta17671));
});

}

return (new cljs.core.t_cljs$core17670(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"_seq","_seq",-449557847,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"_next","_next",101877036,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.truth_(cljs.core.iterable_QMARK_(coll))){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.LazyTransformer;
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__4557__auto__ = !((lt.stepper == null));
if(and__4557__auto__){
return self__.iter.hasNext();
} else {
return and__4557__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__17673 = lt;
var G__17674 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__17673,G__17674) : self__.xform.call(null,G__17673,G__17674));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.Stepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null);
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__17675 = cljs.core.next(iters__$1);
iters__$1 = G__17675;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__5472__auto___17676 = self__.iters.length;
var i_17677 = (0);
while(true){
if((i_17677 < n__5472__auto___17676)){
(self__.nexts[i_17677] = (self__.iters[i_17677]).next());

var G__17678 = (i_17677 + (1));
i_17677 = G__17678;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__4557__auto__ = !((lt.stepper == null));
if(and__4557__auto__){
return this$.hasNext();
} else {
return and__4557__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.MultiStepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"xform","xform",-85179481,null),new cljs.core.Symbol(null,"iters","iters",719353031,null),new cljs.core.Symbol(null,"nexts","nexts",-1683579407,null)], null);
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(var_args){
var args17679 = [];
var len__5627__auto___17682 = arguments.length;
var i__5628__auto___17683 = (0);
while(true){
if((i__5628__auto___17683 < len__5627__auto___17682)){
args17679.push((arguments[i__5628__auto___17683]));

var G__17684 = (i__5628__auto___17683 + (1));
i__5628__auto___17683 = G__17684;
continue;
} else {
}
break;
}

var G__17681 = args17679.length;
switch (G__17681) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17679.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"stepper","stepper",1159163296,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rest","rest",398835108,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__17686_17690 = cljs.core.seq(colls);
var chunk__17687_17691 = null;
var count__17688_17692 = (0);
var i__17689_17693 = (0);
while(true){
if((i__17689_17693 < count__17688_17692)){
var coll_17694 = chunk__17687_17691.cljs$core$IIndexed$_nth$arity$2(null,i__17689_17693);
iters.push(cljs.core.iter(coll_17694));

var G__17695 = seq__17686_17690;
var G__17696 = chunk__17687_17691;
var G__17697 = count__17688_17692;
var G__17698 = (i__17689_17693 + (1));
seq__17686_17690 = G__17695;
chunk__17687_17691 = G__17696;
count__17688_17692 = G__17697;
i__17689_17693 = G__17698;
continue;
} else {
var temp__4425__auto___17699 = cljs.core.seq(seq__17686_17690);
if(temp__4425__auto___17699){
var seq__17686_17700__$1 = temp__4425__auto___17699;
if(cljs.core.chunked_seq_QMARK_(seq__17686_17700__$1)){
var c__5372__auto___17701 = cljs.core.chunk_first(seq__17686_17700__$1);
var G__17702 = cljs.core.chunk_rest(seq__17686_17700__$1);
var G__17703 = c__5372__auto___17701;
var G__17704 = cljs.core.count(c__5372__auto___17701);
var G__17705 = (0);
seq__17686_17690 = G__17702;
chunk__17687_17691 = G__17703;
count__17688_17692 = G__17704;
i__17689_17693 = G__17705;
continue;
} else {
var coll_17706 = cljs.core.first(seq__17686_17700__$1);
iters.push(cljs.core.iter(coll_17706));

var G__17707 = cljs.core.next(seq__17686_17700__$1);
var G__17708 = null;
var G__17709 = (0);
var G__17710 = (0);
seq__17686_17690 = G__17707;
chunk__17687_17691 = G__17708;
count__17688_17692 = G__17709;
i__17689_17693 = G__17710;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var args17711 = [];
var len__5627__auto___17717 = arguments.length;
var i__5628__auto___17718 = (0);
while(true){
if((i__5628__auto___17718 < len__5627__auto___17717)){
args17711.push((arguments[i__5628__auto___17718]));

var G__17719 = (i__5628__auto___17718 + (1));
i__5628__auto___17718 = G__17719;
continue;
} else {
}
break;
}

var G__17716 = args17711.length;
switch (G__17716) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17711.slice((2)),(0)));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__4569__auto__ = cljs.core.seq(coll);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq17712){
var G__17713 = cljs.core.first(seq17712);
var seq17712__$1 = cljs.core.next(seq17712);
var G__17714 = cljs.core.first(seq17712__$1);
var seq17712__$2 = cljs.core.next(seq17712__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__17713,G__17714,seq17712__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__17722 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17722) : pred.call(null,G__17722));
})())){
var G__17723 = pred;
var G__17724 = cljs.core.next(coll);
pred = G__17723;
coll = G__17724;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__4569__auto__ = (function (){var G__17728 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17728) : pred.call(null,G__17728));
})();
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var G__17729 = pred;
var G__17730 = cljs.core.next(coll);
pred = G__17729;
coll = G__17730;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__17731 = null;
var G__17731__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__17731__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__17731__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__17731__3 = (function() { 
var G__17732__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__17732 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__17733__i = 0, G__17733__a = new Array(arguments.length -  2);
while (G__17733__i < G__17733__a.length) {G__17733__a[G__17733__i] = arguments[G__17733__i + 2]; ++G__17733__i;}
  zs = new cljs.core.IndexedSeq(G__17733__a,0);
} 
return G__17732__delegate.call(this,x,y,zs);};
G__17732.cljs$lang$maxFixedArity = 2;
G__17732.cljs$lang$applyTo = (function (arglist__17734){
var x = cljs.core.first(arglist__17734);
arglist__17734 = cljs.core.next(arglist__17734);
var y = cljs.core.first(arglist__17734);
var zs = cljs.core.rest(arglist__17734);
return G__17732__delegate(x,y,zs);
});
G__17732.cljs$core$IFn$_invoke$arity$variadic = G__17732__delegate;
return G__17732;
})()
;
G__17731 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__17731__0.call(this);
case 1:
return G__17731__1.call(this,x);
case 2:
return G__17731__2.call(this,x,y);
default:
var G__17735 = null;
if (arguments.length > 2) {
var G__17736__i = 0, G__17736__a = new Array(arguments.length -  2);
while (G__17736__i < G__17736__a.length) {G__17736__a[G__17736__i] = arguments[G__17736__i + 2]; ++G__17736__i;}
G__17735 = new cljs.core.IndexedSeq(G__17736__a,0);
}
return G__17731__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__17735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17731.cljs$lang$maxFixedArity = 2;
G__17731.cljs$lang$applyTo = G__17731__3.cljs$lang$applyTo;
G__17731.cljs$core$IFn$_invoke$arity$0 = G__17731__0;
G__17731.cljs$core$IFn$_invoke$arity$1 = G__17731__1;
G__17731.cljs$core$IFn$_invoke$arity$2 = G__17731__2;
G__17731.cljs$core$IFn$_invoke$arity$variadic = G__17731__3.cljs$core$IFn$_invoke$arity$variadic;
return G__17731;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__17737__delegate = function (args){
return x;
};
var G__17737 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17738__i = 0, G__17738__a = new Array(arguments.length -  0);
while (G__17738__i < G__17738__a.length) {G__17738__a[G__17738__i] = arguments[G__17738__i + 0]; ++G__17738__i;}
  args = new cljs.core.IndexedSeq(G__17738__a,0);
} 
return G__17737__delegate.call(this,args);};
G__17737.cljs$lang$maxFixedArity = 0;
G__17737.cljs$lang$applyTo = (function (arglist__17739){
var args = cljs.core.seq(arglist__17739);
return G__17737__delegate(args);
});
G__17737.cljs$core$IFn$_invoke$arity$variadic = G__17737__delegate;
return G__17737;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var args17740 = [];
var len__5627__auto___17767 = arguments.length;
var i__5628__auto___17768 = (0);
while(true){
if((i__5628__auto___17768 < len__5627__auto___17767)){
args17740.push((arguments[i__5628__auto___17768]));

var G__17769 = (i__5628__auto___17768 + (1));
i__5628__auto___17768 = G__17769;
continue;
} else {
}
break;
}

var G__17746 = args17740.length;
switch (G__17746) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17740.slice((3)),(0)));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__17771 = null;
var G__17771__0 = (function (){
var G__17747 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17747) : f.call(null,G__17747));
});
var G__17771__1 = (function (x){
var G__17748 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17748) : f.call(null,G__17748));
});
var G__17771__2 = (function (x,y){
var G__17749 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17749) : f.call(null,G__17749));
});
var G__17771__3 = (function (x,y,z){
var G__17750 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17750) : f.call(null,G__17750));
});
var G__17771__4 = (function() { 
var G__17772__delegate = function (x,y,z,args){
var G__17751 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17751) : f.call(null,G__17751));
};
var G__17772 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17773__i = 0, G__17773__a = new Array(arguments.length -  3);
while (G__17773__i < G__17773__a.length) {G__17773__a[G__17773__i] = arguments[G__17773__i + 3]; ++G__17773__i;}
  args = new cljs.core.IndexedSeq(G__17773__a,0);
} 
return G__17772__delegate.call(this,x,y,z,args);};
G__17772.cljs$lang$maxFixedArity = 3;
G__17772.cljs$lang$applyTo = (function (arglist__17774){
var x = cljs.core.first(arglist__17774);
arglist__17774 = cljs.core.next(arglist__17774);
var y = cljs.core.first(arglist__17774);
arglist__17774 = cljs.core.next(arglist__17774);
var z = cljs.core.first(arglist__17774);
var args = cljs.core.rest(arglist__17774);
return G__17772__delegate(x,y,z,args);
});
G__17772.cljs$core$IFn$_invoke$arity$variadic = G__17772__delegate;
return G__17772;
})()
;
G__17771 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17771__0.call(this);
case 1:
return G__17771__1.call(this,x);
case 2:
return G__17771__2.call(this,x,y);
case 3:
return G__17771__3.call(this,x,y,z);
default:
var G__17775 = null;
if (arguments.length > 3) {
var G__17776__i = 0, G__17776__a = new Array(arguments.length -  3);
while (G__17776__i < G__17776__a.length) {G__17776__a[G__17776__i] = arguments[G__17776__i + 3]; ++G__17776__i;}
G__17775 = new cljs.core.IndexedSeq(G__17776__a,0);
}
return G__17771__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17771.cljs$lang$maxFixedArity = 3;
G__17771.cljs$lang$applyTo = G__17771__4.cljs$lang$applyTo;
G__17771.cljs$core$IFn$_invoke$arity$0 = G__17771__0;
G__17771.cljs$core$IFn$_invoke$arity$1 = G__17771__1;
G__17771.cljs$core$IFn$_invoke$arity$2 = G__17771__2;
G__17771.cljs$core$IFn$_invoke$arity$3 = G__17771__3;
G__17771.cljs$core$IFn$_invoke$arity$variadic = G__17771__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17771;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__17777 = null;
var G__17777__0 = (function (){
var G__17753 = (function (){var G__17754 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17754) : g.call(null,G__17754));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17753) : f.call(null,G__17753));
});
var G__17777__1 = (function (x){
var G__17756 = (function (){var G__17757 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17757) : g.call(null,G__17757));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17756) : f.call(null,G__17756));
});
var G__17777__2 = (function (x,y){
var G__17759 = (function (){var G__17760 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17760) : g.call(null,G__17760));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17759) : f.call(null,G__17759));
});
var G__17777__3 = (function (x,y,z){
var G__17762 = (function (){var G__17763 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17763) : g.call(null,G__17763));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17762) : f.call(null,G__17762));
});
var G__17777__4 = (function() { 
var G__17778__delegate = function (x,y,z,args){
var G__17765 = (function (){var G__17766 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17766) : g.call(null,G__17766));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17765) : f.call(null,G__17765));
};
var G__17778 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17779__i = 0, G__17779__a = new Array(arguments.length -  3);
while (G__17779__i < G__17779__a.length) {G__17779__a[G__17779__i] = arguments[G__17779__i + 3]; ++G__17779__i;}
  args = new cljs.core.IndexedSeq(G__17779__a,0);
} 
return G__17778__delegate.call(this,x,y,z,args);};
G__17778.cljs$lang$maxFixedArity = 3;
G__17778.cljs$lang$applyTo = (function (arglist__17780){
var x = cljs.core.first(arglist__17780);
arglist__17780 = cljs.core.next(arglist__17780);
var y = cljs.core.first(arglist__17780);
arglist__17780 = cljs.core.next(arglist__17780);
var z = cljs.core.first(arglist__17780);
var args = cljs.core.rest(arglist__17780);
return G__17778__delegate(x,y,z,args);
});
G__17778.cljs$core$IFn$_invoke$arity$variadic = G__17778__delegate;
return G__17778;
})()
;
G__17777 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17777__0.call(this);
case 1:
return G__17777__1.call(this,x);
case 2:
return G__17777__2.call(this,x,y);
case 3:
return G__17777__3.call(this,x,y,z);
default:
var G__17781 = null;
if (arguments.length > 3) {
var G__17782__i = 0, G__17782__a = new Array(arguments.length -  3);
while (G__17782__i < G__17782__a.length) {G__17782__a[G__17782__i] = arguments[G__17782__i + 3]; ++G__17782__i;}
G__17781 = new cljs.core.IndexedSeq(G__17782__a,0);
}
return G__17777__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17777.cljs$lang$maxFixedArity = 3;
G__17777.cljs$lang$applyTo = G__17777__4.cljs$lang$applyTo;
G__17777.cljs$core$IFn$_invoke$arity$0 = G__17777__0;
G__17777.cljs$core$IFn$_invoke$arity$1 = G__17777__1;
G__17777.cljs$core$IFn$_invoke$arity$2 = G__17777__2;
G__17777.cljs$core$IFn$_invoke$arity$3 = G__17777__3;
G__17777.cljs$core$IFn$_invoke$arity$variadic = G__17777__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17777;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__17783__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__17784 = cljs.core.first(fs__$2).call(null,ret);
var G__17785 = cljs.core.next(fs__$2);
ret = G__17784;
fs__$2 = G__17785;
continue;
} else {
return ret;
}
break;
}
};
var G__17783 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17786__i = 0, G__17786__a = new Array(arguments.length -  0);
while (G__17786__i < G__17786__a.length) {G__17786__a[G__17786__i] = arguments[G__17786__i + 0]; ++G__17786__i;}
  args = new cljs.core.IndexedSeq(G__17786__a,0);
} 
return G__17783__delegate.call(this,args);};
G__17783.cljs$lang$maxFixedArity = 0;
G__17783.cljs$lang$applyTo = (function (arglist__17787){
var args = cljs.core.seq(arglist__17787);
return G__17783__delegate(args);
});
G__17783.cljs$core$IFn$_invoke$arity$variadic = G__17783__delegate;
return G__17783;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq17741){
var G__17742 = cljs.core.first(seq17741);
var seq17741__$1 = cljs.core.next(seq17741);
var G__17743 = cljs.core.first(seq17741__$1);
var seq17741__$2 = cljs.core.next(seq17741__$1);
var G__17744 = cljs.core.first(seq17741__$2);
var seq17741__$3 = cljs.core.next(seq17741__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__17742,G__17743,G__17744,seq17741__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);
/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var args17788 = [];
var len__5627__auto___17796 = arguments.length;
var i__5628__auto___17797 = (0);
while(true){
if((i__5628__auto___17797 < len__5627__auto___17796)){
args17788.push((arguments[i__5628__auto___17797]));

var G__17798 = (i__5628__auto___17797 + (1));
i__5628__auto___17797 = G__17798;
continue;
} else {
}
break;
}

var G__17795 = args17788.length;
switch (G__17795) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17788.slice((4)),(0)));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5646__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__17800 = null;
var G__17800__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__17800__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__17800__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__17800__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__17800__4 = (function() { 
var G__17801__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__17801 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17802__i = 0, G__17802__a = new Array(arguments.length -  3);
while (G__17802__i < G__17802__a.length) {G__17802__a[G__17802__i] = arguments[G__17802__i + 3]; ++G__17802__i;}
  args = new cljs.core.IndexedSeq(G__17802__a,0);
} 
return G__17801__delegate.call(this,x,y,z,args);};
G__17801.cljs$lang$maxFixedArity = 3;
G__17801.cljs$lang$applyTo = (function (arglist__17803){
var x = cljs.core.first(arglist__17803);
arglist__17803 = cljs.core.next(arglist__17803);
var y = cljs.core.first(arglist__17803);
arglist__17803 = cljs.core.next(arglist__17803);
var z = cljs.core.first(arglist__17803);
var args = cljs.core.rest(arglist__17803);
return G__17801__delegate(x,y,z,args);
});
G__17801.cljs$core$IFn$_invoke$arity$variadic = G__17801__delegate;
return G__17801;
})()
;
G__17800 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17800__0.call(this);
case 1:
return G__17800__1.call(this,x);
case 2:
return G__17800__2.call(this,x,y);
case 3:
return G__17800__3.call(this,x,y,z);
default:
var G__17804 = null;
if (arguments.length > 3) {
var G__17805__i = 0, G__17805__a = new Array(arguments.length -  3);
while (G__17805__i < G__17805__a.length) {G__17805__a[G__17805__i] = arguments[G__17805__i + 3]; ++G__17805__i;}
G__17804 = new cljs.core.IndexedSeq(G__17805__a,0);
}
return G__17800__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17800.cljs$lang$maxFixedArity = 3;
G__17800.cljs$lang$applyTo = G__17800__4.cljs$lang$applyTo;
G__17800.cljs$core$IFn$_invoke$arity$0 = G__17800__0;
G__17800.cljs$core$IFn$_invoke$arity$1 = G__17800__1;
G__17800.cljs$core$IFn$_invoke$arity$2 = G__17800__2;
G__17800.cljs$core$IFn$_invoke$arity$3 = G__17800__3;
G__17800.cljs$core$IFn$_invoke$arity$variadic = G__17800__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17800;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__17806 = null;
var G__17806__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__17806__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__17806__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__17806__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__17806__4 = (function() { 
var G__17807__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__17807 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17808__i = 0, G__17808__a = new Array(arguments.length -  3);
while (G__17808__i < G__17808__a.length) {G__17808__a[G__17808__i] = arguments[G__17808__i + 3]; ++G__17808__i;}
  args = new cljs.core.IndexedSeq(G__17808__a,0);
} 
return G__17807__delegate.call(this,x,y,z,args);};
G__17807.cljs$lang$maxFixedArity = 3;
G__17807.cljs$lang$applyTo = (function (arglist__17809){
var x = cljs.core.first(arglist__17809);
arglist__17809 = cljs.core.next(arglist__17809);
var y = cljs.core.first(arglist__17809);
arglist__17809 = cljs.core.next(arglist__17809);
var z = cljs.core.first(arglist__17809);
var args = cljs.core.rest(arglist__17809);
return G__17807__delegate(x,y,z,args);
});
G__17807.cljs$core$IFn$_invoke$arity$variadic = G__17807__delegate;
return G__17807;
})()
;
G__17806 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17806__0.call(this);
case 1:
return G__17806__1.call(this,x);
case 2:
return G__17806__2.call(this,x,y);
case 3:
return G__17806__3.call(this,x,y,z);
default:
var G__17810 = null;
if (arguments.length > 3) {
var G__17811__i = 0, G__17811__a = new Array(arguments.length -  3);
while (G__17811__i < G__17811__a.length) {G__17811__a[G__17811__i] = arguments[G__17811__i + 3]; ++G__17811__i;}
G__17810 = new cljs.core.IndexedSeq(G__17811__a,0);
}
return G__17806__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17806.cljs$lang$maxFixedArity = 3;
G__17806.cljs$lang$applyTo = G__17806__4.cljs$lang$applyTo;
G__17806.cljs$core$IFn$_invoke$arity$0 = G__17806__0;
G__17806.cljs$core$IFn$_invoke$arity$1 = G__17806__1;
G__17806.cljs$core$IFn$_invoke$arity$2 = G__17806__2;
G__17806.cljs$core$IFn$_invoke$arity$3 = G__17806__3;
G__17806.cljs$core$IFn$_invoke$arity$variadic = G__17806__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17806;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__17812 = null;
var G__17812__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__17812__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__17812__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__17812__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__17812__4 = (function() { 
var G__17813__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__17813 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__17814__i = 0, G__17814__a = new Array(arguments.length -  3);
while (G__17814__i < G__17814__a.length) {G__17814__a[G__17814__i] = arguments[G__17814__i + 3]; ++G__17814__i;}
  args = new cljs.core.IndexedSeq(G__17814__a,0);
} 
return G__17813__delegate.call(this,x,y,z,args);};
G__17813.cljs$lang$maxFixedArity = 3;
G__17813.cljs$lang$applyTo = (function (arglist__17815){
var x = cljs.core.first(arglist__17815);
arglist__17815 = cljs.core.next(arglist__17815);
var y = cljs.core.first(arglist__17815);
arglist__17815 = cljs.core.next(arglist__17815);
var z = cljs.core.first(arglist__17815);
var args = cljs.core.rest(arglist__17815);
return G__17813__delegate(x,y,z,args);
});
G__17813.cljs$core$IFn$_invoke$arity$variadic = G__17813__delegate;
return G__17813;
})()
;
G__17812 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__17812__0.call(this);
case 1:
return G__17812__1.call(this,x);
case 2:
return G__17812__2.call(this,x,y);
case 3:
return G__17812__3.call(this,x,y,z);
default:
var G__17816 = null;
if (arguments.length > 3) {
var G__17817__i = 0, G__17817__a = new Array(arguments.length -  3);
while (G__17817__i < G__17817__a.length) {G__17817__a[G__17817__i] = arguments[G__17817__i + 3]; ++G__17817__i;}
G__17816 = new cljs.core.IndexedSeq(G__17817__a,0);
}
return G__17812__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__17816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17812.cljs$lang$maxFixedArity = 3;
G__17812.cljs$lang$applyTo = G__17812__4.cljs$lang$applyTo;
G__17812.cljs$core$IFn$_invoke$arity$0 = G__17812__0;
G__17812.cljs$core$IFn$_invoke$arity$1 = G__17812__1;
G__17812.cljs$core$IFn$_invoke$arity$2 = G__17812__2;
G__17812.cljs$core$IFn$_invoke$arity$3 = G__17812__3;
G__17812.cljs$core$IFn$_invoke$arity$variadic = G__17812__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17812;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__17818__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__17818 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__17819__i = 0, G__17819__a = new Array(arguments.length -  0);
while (G__17819__i < G__17819__a.length) {G__17819__a[G__17819__i] = arguments[G__17819__i + 0]; ++G__17819__i;}
  args = new cljs.core.IndexedSeq(G__17819__a,0);
} 
return G__17818__delegate.call(this,args);};
G__17818.cljs$lang$maxFixedArity = 0;
G__17818.cljs$lang$applyTo = (function (arglist__17820){
var args = cljs.core.seq(arglist__17820);
return G__17818__delegate(args);
});
G__17818.cljs$core$IFn$_invoke$arity$variadic = G__17818__delegate;
return G__17818;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq17789){
var G__17790 = cljs.core.first(seq17789);
var seq17789__$1 = cljs.core.next(seq17789);
var G__17791 = cljs.core.first(seq17789__$1);
var seq17789__$2 = cljs.core.next(seq17789__$1);
var G__17792 = cljs.core.first(seq17789__$2);
var seq17789__$3 = cljs.core.next(seq17789__$2);
var G__17793 = cljs.core.first(seq17789__$3);
var seq17789__$4 = cljs.core.next(seq17789__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__17790,G__17791,G__17792,G__17793,seq17789__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);
/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var args17821 = [];
var len__5627__auto___17840 = arguments.length;
var i__5628__auto___17841 = (0);
while(true){
if((i__5628__auto___17841 < len__5627__auto___17840)){
args17821.push((arguments[i__5628__auto___17841]));

var G__17842 = (i__5628__auto___17841 + (1));
i__5628__auto___17841 = G__17842;
continue;
} else {
}
break;
}

var G__17823 = args17821.length;
switch (G__17823) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17821.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__17844 = null;
var G__17844__1 = (function (a){
var G__17824 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17824) : f.call(null,G__17824));
});
var G__17844__2 = (function (a,b){
var G__17825 = (((a == null))?x:a);
var G__17826 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17825,G__17826) : f.call(null,G__17825,G__17826));
});
var G__17844__3 = (function (a,b,c){
var G__17827 = (((a == null))?x:a);
var G__17828 = b;
var G__17829 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17827,G__17828,G__17829) : f.call(null,G__17827,G__17828,G__17829));
});
var G__17844__4 = (function() { 
var G__17845__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__17845 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__17846__i = 0, G__17846__a = new Array(arguments.length -  3);
while (G__17846__i < G__17846__a.length) {G__17846__a[G__17846__i] = arguments[G__17846__i + 3]; ++G__17846__i;}
  ds = new cljs.core.IndexedSeq(G__17846__a,0);
} 
return G__17845__delegate.call(this,a,b,c,ds);};
G__17845.cljs$lang$maxFixedArity = 3;
G__17845.cljs$lang$applyTo = (function (arglist__17847){
var a = cljs.core.first(arglist__17847);
arglist__17847 = cljs.core.next(arglist__17847);
var b = cljs.core.first(arglist__17847);
arglist__17847 = cljs.core.next(arglist__17847);
var c = cljs.core.first(arglist__17847);
var ds = cljs.core.rest(arglist__17847);
return G__17845__delegate(a,b,c,ds);
});
G__17845.cljs$core$IFn$_invoke$arity$variadic = G__17845__delegate;
return G__17845;
})()
;
G__17844 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__17844__1.call(this,a);
case 2:
return G__17844__2.call(this,a,b);
case 3:
return G__17844__3.call(this,a,b,c);
default:
var G__17848 = null;
if (arguments.length > 3) {
var G__17849__i = 0, G__17849__a = new Array(arguments.length -  3);
while (G__17849__i < G__17849__a.length) {G__17849__a[G__17849__i] = arguments[G__17849__i + 3]; ++G__17849__i;}
G__17848 = new cljs.core.IndexedSeq(G__17849__a,0);
}
return G__17844__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__17848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17844.cljs$lang$maxFixedArity = 3;
G__17844.cljs$lang$applyTo = G__17844__4.cljs$lang$applyTo;
G__17844.cljs$core$IFn$_invoke$arity$1 = G__17844__1;
G__17844.cljs$core$IFn$_invoke$arity$2 = G__17844__2;
G__17844.cljs$core$IFn$_invoke$arity$3 = G__17844__3;
G__17844.cljs$core$IFn$_invoke$arity$variadic = G__17844__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17844;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__17850 = null;
var G__17850__2 = (function (a,b){
var G__17830 = (((a == null))?x:a);
var G__17831 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17830,G__17831) : f.call(null,G__17830,G__17831));
});
var G__17850__3 = (function (a,b,c){
var G__17832 = (((a == null))?x:a);
var G__17833 = (((b == null))?y:b);
var G__17834 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17832,G__17833,G__17834) : f.call(null,G__17832,G__17833,G__17834));
});
var G__17850__4 = (function() { 
var G__17851__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__17851 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__17852__i = 0, G__17852__a = new Array(arguments.length -  3);
while (G__17852__i < G__17852__a.length) {G__17852__a[G__17852__i] = arguments[G__17852__i + 3]; ++G__17852__i;}
  ds = new cljs.core.IndexedSeq(G__17852__a,0);
} 
return G__17851__delegate.call(this,a,b,c,ds);};
G__17851.cljs$lang$maxFixedArity = 3;
G__17851.cljs$lang$applyTo = (function (arglist__17853){
var a = cljs.core.first(arglist__17853);
arglist__17853 = cljs.core.next(arglist__17853);
var b = cljs.core.first(arglist__17853);
arglist__17853 = cljs.core.next(arglist__17853);
var c = cljs.core.first(arglist__17853);
var ds = cljs.core.rest(arglist__17853);
return G__17851__delegate(a,b,c,ds);
});
G__17851.cljs$core$IFn$_invoke$arity$variadic = G__17851__delegate;
return G__17851;
})()
;
G__17850 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__17850__2.call(this,a,b);
case 3:
return G__17850__3.call(this,a,b,c);
default:
var G__17854 = null;
if (arguments.length > 3) {
var G__17855__i = 0, G__17855__a = new Array(arguments.length -  3);
while (G__17855__i < G__17855__a.length) {G__17855__a[G__17855__i] = arguments[G__17855__i + 3]; ++G__17855__i;}
G__17854 = new cljs.core.IndexedSeq(G__17855__a,0);
}
return G__17850__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__17854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17850.cljs$lang$maxFixedArity = 3;
G__17850.cljs$lang$applyTo = G__17850__4.cljs$lang$applyTo;
G__17850.cljs$core$IFn$_invoke$arity$2 = G__17850__2;
G__17850.cljs$core$IFn$_invoke$arity$3 = G__17850__3;
G__17850.cljs$core$IFn$_invoke$arity$variadic = G__17850__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17850;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__17856 = null;
var G__17856__2 = (function (a,b){
var G__17835 = (((a == null))?x:a);
var G__17836 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17835,G__17836) : f.call(null,G__17835,G__17836));
});
var G__17856__3 = (function (a,b,c){
var G__17837 = (((a == null))?x:a);
var G__17838 = (((b == null))?y:b);
var G__17839 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17837,G__17838,G__17839) : f.call(null,G__17837,G__17838,G__17839));
});
var G__17856__4 = (function() { 
var G__17857__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__17857 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__17858__i = 0, G__17858__a = new Array(arguments.length -  3);
while (G__17858__i < G__17858__a.length) {G__17858__a[G__17858__i] = arguments[G__17858__i + 3]; ++G__17858__i;}
  ds = new cljs.core.IndexedSeq(G__17858__a,0);
} 
return G__17857__delegate.call(this,a,b,c,ds);};
G__17857.cljs$lang$maxFixedArity = 3;
G__17857.cljs$lang$applyTo = (function (arglist__17859){
var a = cljs.core.first(arglist__17859);
arglist__17859 = cljs.core.next(arglist__17859);
var b = cljs.core.first(arglist__17859);
arglist__17859 = cljs.core.next(arglist__17859);
var c = cljs.core.first(arglist__17859);
var ds = cljs.core.rest(arglist__17859);
return G__17857__delegate(a,b,c,ds);
});
G__17857.cljs$core$IFn$_invoke$arity$variadic = G__17857__delegate;
return G__17857;
})()
;
G__17856 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__17856__2.call(this,a,b);
case 3:
return G__17856__3.call(this,a,b,c);
default:
var G__17860 = null;
if (arguments.length > 3) {
var G__17861__i = 0, G__17861__a = new Array(arguments.length -  3);
while (G__17861__i < G__17861__a.length) {G__17861__a[G__17861__i] = arguments[G__17861__i + 3]; ++G__17861__i;}
G__17860 = new cljs.core.IndexedSeq(G__17861__a,0);
}
return G__17856__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__17860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17856.cljs$lang$maxFixedArity = 3;
G__17856.cljs$lang$applyTo = G__17856__4.cljs$lang$applyTo;
G__17856.cljs$core$IFn$_invoke$arity$2 = G__17856__2;
G__17856.cljs$core$IFn$_invoke$arity$3 = G__17856__3;
G__17856.cljs$core$IFn$_invoke$arity$variadic = G__17856__4.cljs$core$IFn$_invoke$arity$variadic;
return G__17856;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.volatile_BANG_;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var args17862 = [];
var len__5627__auto___17895 = arguments.length;
var i__5628__auto___17896 = (0);
while(true){
if((i__5628__auto___17896 < len__5627__auto___17895)){
args17862.push((arguments[i__5628__auto___17896]));

var G__17897 = (i__5628__auto___17896 + (1));
i__5628__auto___17896 = G__17897;
continue;
} else {
}
break;
}

var G__17864 = args17862.length;
switch (G__17864) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17862.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));
return ((function (i){
return (function() {
var G__17899 = null;
var G__17899__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17899__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__17899__2 = (function (result,input){
var G__17867 = result;
var G__17868 = (function (){var G__17869 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__17870 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17869,G__17870) : f.call(null,G__17869,G__17870));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17867,G__17868) : rf.call(null,G__17867,G__17868));
});
G__17899 = function(result,input){
switch(arguments.length){
case 0:
return G__17899__0.call(this);
case 1:
return G__17899__1.call(this,result);
case 2:
return G__17899__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17899.cljs$core$IFn$_invoke$arity$0 = G__17899__0;
G__17899.cljs$core$IFn$_invoke$arity$1 = G__17899__1;
G__17899.cljs$core$IFn$_invoke$arity$2 = G__17899__2;
return G__17899;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll__$1);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5472__auto___17900 = size;
var i_17901 = (0);
while(true){
if((i_17901 < n__5472__auto___17900)){
cljs.core.chunk_append(b,(function (){var G__17891 = (idx + i_17901);
var G__17892 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_17901);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17891,G__17892) : f.call(null,G__17891,G__17892));
})());

var G__17902 = (i_17901 + (1));
i_17901 = G__17902;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__17893 = idx;
var G__17894 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17893,G__17894) : f.call(null,G__17893,G__17894));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var args17903 = [];
var len__5627__auto___17908 = arguments.length;
var i__5628__auto___17909 = (0);
while(true){
if((i__5628__auto___17909 < len__5627__auto___17908)){
args17903.push((arguments[i__5628__auto___17909]));

var G__17910 = (i__5628__auto___17909 + (1));
i__5628__auto___17909 = G__17910;
continue;
} else {
}
break;
}

var G__17905 = args17903.length;
switch (G__17905) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17903.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__17912 = null;
var G__17912__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__17912__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__17912__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__17912 = function(result,input){
switch(arguments.length){
case 0:
return G__17912__0.call(this);
case 1:
return G__17912__1.call(this,result);
case 2:
return G__17912__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17912.cljs$core$IFn$_invoke$arity$0 = G__17912__0;
G__17912.cljs$core$IFn$_invoke$arity$1 = G__17912__1;
G__17912.cljs$core$IFn$_invoke$arity$2 = G__17912__2;
return G__17912;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5472__auto___17913 = size;
var i_17914 = (0);
while(true){
if((i_17914 < n__5472__auto___17913)){
var x_17915 = (function (){var G__17906 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_17914);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17906) : f.call(null,G__17906));
})();
if((x_17915 == null)){
} else {
cljs.core.chunk_append(b,x_17915);
}

var G__17916 = (i_17914 + (1));
i_17914 = G__17916;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__17907 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17907) : f.call(null,G__17907));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__17917 = cljs.core.seq(self__.watches);
var chunk__17918 = null;
var count__17919 = (0);
var i__17920 = (0);
while(true){
if((i__17920 < count__17919)){
var vec__17921 = chunk__17918.cljs$core$IIndexed$_nth$arity$2(null,i__17920);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17921,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17921,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__17923 = seq__17917;
var G__17924 = chunk__17918;
var G__17925 = count__17919;
var G__17926 = (i__17920 + (1));
seq__17917 = G__17923;
chunk__17918 = G__17924;
count__17919 = G__17925;
i__17920 = G__17926;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__17917);
if(temp__4425__auto__){
var seq__17917__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17917__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__17917__$1);
var G__17927 = cljs.core.chunk_rest(seq__17917__$1);
var G__17928 = c__5372__auto__;
var G__17929 = cljs.core.count(c__5372__auto__);
var G__17930 = (0);
seq__17917 = G__17927;
chunk__17918 = G__17928;
count__17919 = G__17929;
i__17920 = G__17930;
continue;
} else {
var vec__17922 = cljs.core.first(seq__17917__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17922,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17922,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__17931 = cljs.core.next(seq__17917__$1);
var G__17932 = null;
var G__17933 = (0);
var G__17934 = (0);
seq__17917 = G__17931;
chunk__17918 = G__17932;
count__17919 = G__17933;
i__17920 = G__17934;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null)], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will be come the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var args17935 = [];
var len__5627__auto___17943 = arguments.length;
var i__5628__auto___17944 = (0);
while(true){
if((i__5628__auto___17944 < len__5627__auto___17943)){
args17935.push((arguments[i__5628__auto___17944]));

var G__17945 = (i__5628__auto___17944 + (1));
i__5628__auto___17944 = G__17945;
continue;
} else {
}
break;
}

var G__17939 = args17935.length;
switch (G__17939) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17935.slice((1)),(0)));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__17940){
var map__17941 = p__17940;
var map__17941__$1 = ((((!((map__17941 == null)))?((((map__17941.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17941.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17941):map__17941);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17941__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17941__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq17936){
var G__17937 = cljs.core.first(seq17936);
var seq17936__$1 = cljs.core.next(seq17936);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__17937,seq17936__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);
cljs.core.pr_str;
/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__17948 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17948) : cljs.core.pr_str.call(null,G__17948));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var args17949 = [];
var len__5627__auto___17963 = arguments.length;
var i__5628__auto___17964 = (0);
while(true){
if((i__5628__auto___17964 < len__5627__auto___17963)){
args17949.push((arguments[i__5628__auto___17964]));

var G__17965 = (i__5628__auto___17964 + (1));
i__5628__auto___17964 = G__17965;
continue;
} else {
}
break;
}

var G__17956 = args17949.length;
switch (G__17956) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args17949.slice((4)),(0)));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5646__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__17957 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17957) : f.call(null,G__17957));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__17958 = a.state;
var G__17959 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17958,G__17959) : f.call(null,G__17958,G__17959));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__17960 = a.state;
var G__17961 = x;
var G__17962 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17960,G__17961,G__17962) : f.call(null,G__17960,G__17961,G__17962));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq17950){
var G__17951 = cljs.core.first(seq17950);
var seq17950__$1 = cljs.core.next(seq17950);
var G__17952 = cljs.core.first(seq17950__$1);
var seq17950__$2 = cljs.core.next(seq17950__$1);
var G__17953 = cljs.core.first(seq17950__$2);
var seq17950__$3 = cljs.core.next(seq17950__$2);
var G__17954 = cljs.core.first(seq17950__$3);
var seq17950__$4 = cljs.core.next(seq17950__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17951,G__17952,G__17953,G__17954,seq17950__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);
/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var args17967 = [];
var len__5627__auto___17998 = arguments.length;
var i__5628__auto___17999 = (0);
while(true){
if((i__5628__auto___17999 < len__5627__auto___17998)){
args17967.push((arguments[i__5628__auto___17999]));

var G__18000 = (i__5628__auto___17999 + (1));
i__5628__auto___17999 = G__18000;
continue;
} else {
}
break;
}

var G__17969 = args17967.length;
switch (G__17969) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17967.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__18002 = null;
var G__18002__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18002__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18002__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__18002 = function(result,input){
switch(arguments.length){
case 0:
return G__18002__0.call(this);
case 1:
return G__18002__1.call(this,result);
case 2:
return G__18002__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18002.cljs$core$IFn$_invoke$arity$0 = G__18002__0;
G__18002.cljs$core$IFn$_invoke$arity$1 = G__18002__1;
G__18002.cljs$core$IFn$_invoke$arity$2 = G__18002__2;
return G__18002;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll__$1);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5472__auto___18003 = size;
var i_18004 = (0);
while(true){
if((i_18004 < n__5472__auto___18003)){
var x_18005 = (function (){var G__17994 = (idx + i_18004);
var G__17995 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_18004);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17994,G__17995) : f.call(null,G__17994,G__17995));
})();
if((x_18005 == null)){
} else {
cljs.core.chunk_append(b,x_18005);
}

var G__18006 = (i_18004 + (1));
i_18004 = G__18006;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__17996 = idx;
var G__17997 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17996,G__17997) : f.call(null,G__17996,G__17997));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var args18013 = [];
var len__5627__auto___18020 = arguments.length;
var i__5628__auto___18021 = (0);
while(true){
if((i__5628__auto___18021 < len__5627__auto___18020)){
args18013.push((arguments[i__5628__auto___18021]));

var G__18022 = (i__5628__auto___18021 + (1));
i__5628__auto___18021 = G__18022;
continue;
} else {
}
break;
}

var G__18019 = args18013.length;
switch (G__18019) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18013.slice((3)),(0)));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__4557__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__18024__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4557__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__4557__auto__;
}
})());
};
var G__18024 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18025__i = 0, G__18025__a = new Array(arguments.length -  3);
while (G__18025__i < G__18025__a.length) {G__18025__a[G__18025__i] = arguments[G__18025__i + 3]; ++G__18025__i;}
  args = new cljs.core.IndexedSeq(G__18025__a,0);
} 
return G__18024__delegate.call(this,x,y,z,args);};
G__18024.cljs$lang$maxFixedArity = 3;
G__18024.cljs$lang$applyTo = (function (arglist__18026){
var x = cljs.core.first(arglist__18026);
arglist__18026 = cljs.core.next(arglist__18026);
var y = cljs.core.first(arglist__18026);
arglist__18026 = cljs.core.next(arglist__18026);
var z = cljs.core.first(arglist__18026);
var args = cljs.core.rest(arglist__18026);
return G__18024__delegate(x,y,z,args);
});
G__18024.cljs$core$IFn$_invoke$arity$variadic = G__18024__delegate;
return G__18024;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__18027 = null;
if (arguments.length > 3) {
var G__18028__i = 0, G__18028__a = new Array(arguments.length -  3);
while (G__18028__i < G__18028__a.length) {G__18028__a[G__18028__i] = arguments[G__18028__i + 3]; ++G__18028__i;}
G__18027 = new cljs.core.IndexedSeq(G__18028__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4557__auto____$1)){
var and__4557__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4557__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__4557__auto____$2;
}
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4557__auto____$1)){
var and__4557__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__4557__auto____$2)){
var and__4557__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4557__auto____$3)){
var and__4557__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4557__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__4557__auto____$4;
}
} else {
return and__4557__auto____$3;
}
} else {
return and__4557__auto____$2;
}
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__18029__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4557__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_(((function (and__4557__auto__){
return (function (p1__18007_SHARP_){
var and__4557__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__18007_SHARP_) : p1.call(null,p1__18007_SHARP_));
if(cljs.core.truth_(and__4557__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__18007_SHARP_) : p2.call(null,p1__18007_SHARP_));
} else {
return and__4557__auto____$1;
}
});})(and__4557__auto__))
,args);
} else {
return and__4557__auto__;
}
})());
};
var G__18029 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18030__i = 0, G__18030__a = new Array(arguments.length -  3);
while (G__18030__i < G__18030__a.length) {G__18030__a[G__18030__i] = arguments[G__18030__i + 3]; ++G__18030__i;}
  args = new cljs.core.IndexedSeq(G__18030__a,0);
} 
return G__18029__delegate.call(this,x,y,z,args);};
G__18029.cljs$lang$maxFixedArity = 3;
G__18029.cljs$lang$applyTo = (function (arglist__18031){
var x = cljs.core.first(arglist__18031);
arglist__18031 = cljs.core.next(arglist__18031);
var y = cljs.core.first(arglist__18031);
arglist__18031 = cljs.core.next(arglist__18031);
var z = cljs.core.first(arglist__18031);
var args = cljs.core.rest(arglist__18031);
return G__18029__delegate(x,y,z,args);
});
G__18029.cljs$core$IFn$_invoke$arity$variadic = G__18029__delegate;
return G__18029;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__18032 = null;
if (arguments.length > 3) {
var G__18033__i = 0, G__18033__a = new Array(arguments.length -  3);
while (G__18033__i < G__18033__a.length) {G__18033__a[G__18033__i] = arguments[G__18033__i + 3]; ++G__18033__i;}
G__18032 = new cljs.core.IndexedSeq(G__18033__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4557__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4557__auto____$1)){
var and__4557__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__4557__auto____$2)){
var and__4557__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4557__auto____$3)){
var and__4557__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4557__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__4557__auto____$4;
}
} else {
return and__4557__auto____$3;
}
} else {
return and__4557__auto____$2;
}
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4557__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4557__auto____$1)){
var and__4557__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__4557__auto____$2)){
var and__4557__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4557__auto____$3)){
var and__4557__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4557__auto____$4)){
var and__4557__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__4557__auto____$5)){
var and__4557__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__4557__auto____$6)){
var and__4557__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__4557__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__4557__auto____$7;
}
} else {
return and__4557__auto____$6;
}
} else {
return and__4557__auto____$5;
}
} else {
return and__4557__auto____$4;
}
} else {
return and__4557__auto____$3;
}
} else {
return and__4557__auto____$2;
}
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__18034__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4557__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_(((function (and__4557__auto__){
return (function (p1__18008_SHARP_){
var and__4557__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__18008_SHARP_) : p1.call(null,p1__18008_SHARP_));
if(cljs.core.truth_(and__4557__auto____$1)){
var and__4557__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__18008_SHARP_) : p2.call(null,p1__18008_SHARP_));
if(cljs.core.truth_(and__4557__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__18008_SHARP_) : p3.call(null,p1__18008_SHARP_));
} else {
return and__4557__auto____$2;
}
} else {
return and__4557__auto____$1;
}
});})(and__4557__auto__))
,args);
} else {
return and__4557__auto__;
}
})());
};
var G__18034 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18035__i = 0, G__18035__a = new Array(arguments.length -  3);
while (G__18035__i < G__18035__a.length) {G__18035__a[G__18035__i] = arguments[G__18035__i + 3]; ++G__18035__i;}
  args = new cljs.core.IndexedSeq(G__18035__a,0);
} 
return G__18034__delegate.call(this,x,y,z,args);};
G__18034.cljs$lang$maxFixedArity = 3;
G__18034.cljs$lang$applyTo = (function (arglist__18036){
var x = cljs.core.first(arglist__18036);
arglist__18036 = cljs.core.next(arglist__18036);
var y = cljs.core.first(arglist__18036);
arglist__18036 = cljs.core.next(arglist__18036);
var z = cljs.core.first(arglist__18036);
var args = cljs.core.rest(arglist__18036);
return G__18034__delegate(x,y,z,args);
});
G__18034.cljs$core$IFn$_invoke$arity$variadic = G__18034__delegate;
return G__18034;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__18037 = null;
if (arguments.length > 3) {
var G__18038__i = 0, G__18038__a = new Array(arguments.length -  3);
while (G__18038__i < G__18038__a.length) {G__18038__a[G__18038__i] = arguments[G__18038__i + 3]; ++G__18038__i;}
G__18037 = new cljs.core.IndexedSeq(G__18038__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__18009_SHARP_){
return (p1__18009_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18009_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__18009_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__18010_SHARP_){
var and__4557__auto__ = (p1__18010_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18010_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__18010_SHARP_.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
return (p1__18010_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18010_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__18010_SHARP_.call(null,y));
} else {
return and__4557__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__18011_SHARP_){
var and__4557__auto__ = (p1__18011_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18011_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__18011_SHARP_.call(null,x));
if(cljs.core.truth_(and__4557__auto__)){
var and__4557__auto____$1 = (p1__18011_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18011_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__18011_SHARP_.call(null,y));
if(cljs.core.truth_(and__4557__auto____$1)){
return (p1__18011_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18011_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__18011_SHARP_.call(null,z));
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__18039__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4557__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4557__auto__)){
return cljs.core.every_QMARK_(((function (and__4557__auto__,ps__$1){
return (function (p1__18012_SHARP_){
return cljs.core.every_QMARK_(p1__18012_SHARP_,args);
});})(and__4557__auto__,ps__$1))
,ps__$1);
} else {
return and__4557__auto__;
}
})());
};
var G__18039 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18040__i = 0, G__18040__a = new Array(arguments.length -  3);
while (G__18040__i < G__18040__a.length) {G__18040__a[G__18040__i] = arguments[G__18040__i + 3]; ++G__18040__i;}
  args = new cljs.core.IndexedSeq(G__18040__a,0);
} 
return G__18039__delegate.call(this,x,y,z,args);};
G__18039.cljs$lang$maxFixedArity = 3;
G__18039.cljs$lang$applyTo = (function (arglist__18041){
var x = cljs.core.first(arglist__18041);
arglist__18041 = cljs.core.next(arglist__18041);
var y = cljs.core.first(arglist__18041);
arglist__18041 = cljs.core.next(arglist__18041);
var z = cljs.core.first(arglist__18041);
var args = cljs.core.rest(arglist__18041);
return G__18039__delegate(x,y,z,args);
});
G__18039.cljs$core$IFn$_invoke$arity$variadic = G__18039__delegate;
return G__18039;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__18042 = null;
if (arguments.length > 3) {
var G__18043__i = 0, G__18043__a = new Array(arguments.length -  3);
while (G__18043__i < G__18043__a.length) {G__18043__a[G__18043__i] = arguments[G__18043__i + 3]; ++G__18043__i;}
G__18042 = new cljs.core.IndexedSeq(G__18043__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq18014){
var G__18015 = cljs.core.first(seq18014);
var seq18014__$1 = cljs.core.next(seq18014);
var G__18016 = cljs.core.first(seq18014__$1);
var seq18014__$2 = cljs.core.next(seq18014__$1);
var G__18017 = cljs.core.first(seq18014__$2);
var seq18014__$3 = cljs.core.next(seq18014__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__18015,G__18016,G__18017,seq18014__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var args18050 = [];
var len__5627__auto___18057 = arguments.length;
var i__5628__auto___18058 = (0);
while(true){
if((i__5628__auto___18058 < len__5627__auto___18057)){
args18050.push((arguments[i__5628__auto___18058]));

var G__18059 = (i__5628__auto___18058 + (1));
i__5628__auto___18058 = G__18059;
continue;
} else {
}
break;
}

var G__18056 = args18050.length;
switch (G__18056) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18050.slice((3)),(0)));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__4569__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__4569__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__18061__delegate = function (x,y,z,args){
var or__4569__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__18061 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18062__i = 0, G__18062__a = new Array(arguments.length -  3);
while (G__18062__i < G__18062__a.length) {G__18062__a[G__18062__i] = arguments[G__18062__i + 3]; ++G__18062__i;}
  args = new cljs.core.IndexedSeq(G__18062__a,0);
} 
return G__18061__delegate.call(this,x,y,z,args);};
G__18061.cljs$lang$maxFixedArity = 3;
G__18061.cljs$lang$applyTo = (function (arglist__18063){
var x = cljs.core.first(arglist__18063);
arglist__18063 = cljs.core.next(arglist__18063);
var y = cljs.core.first(arglist__18063);
arglist__18063 = cljs.core.next(arglist__18063);
var z = cljs.core.first(arglist__18063);
var args = cljs.core.rest(arglist__18063);
return G__18061__delegate(x,y,z,args);
});
G__18061.cljs$core$IFn$_invoke$arity$variadic = G__18061__delegate;
return G__18061;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__18064 = null;
if (arguments.length > 3) {
var G__18065__i = 0, G__18065__a = new Array(arguments.length -  3);
while (G__18065__i < G__18065__a.length) {G__18065__a[G__18065__i] = arguments[G__18065__i + 3]; ++G__18065__i;}
G__18064 = new cljs.core.IndexedSeq(G__18065__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__4569__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__4569__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
var or__4569__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4569__auto____$2)){
return or__4569__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__4569__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
var or__4569__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__4569__auto____$2)){
return or__4569__auto____$2;
} else {
var or__4569__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4569__auto____$3)){
return or__4569__auto____$3;
} else {
var or__4569__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4569__auto____$4)){
return or__4569__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__18066__delegate = function (x,y,z,args){
var or__4569__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.some(((function (or__4569__auto__){
return (function (p1__18044_SHARP_){
var or__4569__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__18044_SHARP_) : p1.call(null,p1__18044_SHARP_));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__18044_SHARP_) : p2.call(null,p1__18044_SHARP_));
}
});})(or__4569__auto__))
,args);
}
};
var G__18066 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18067__i = 0, G__18067__a = new Array(arguments.length -  3);
while (G__18067__i < G__18067__a.length) {G__18067__a[G__18067__i] = arguments[G__18067__i + 3]; ++G__18067__i;}
  args = new cljs.core.IndexedSeq(G__18067__a,0);
} 
return G__18066__delegate.call(this,x,y,z,args);};
G__18066.cljs$lang$maxFixedArity = 3;
G__18066.cljs$lang$applyTo = (function (arglist__18068){
var x = cljs.core.first(arglist__18068);
arglist__18068 = cljs.core.next(arglist__18068);
var y = cljs.core.first(arglist__18068);
arglist__18068 = cljs.core.next(arglist__18068);
var z = cljs.core.first(arglist__18068);
var args = cljs.core.rest(arglist__18068);
return G__18066__delegate(x,y,z,args);
});
G__18066.cljs$core$IFn$_invoke$arity$variadic = G__18066__delegate;
return G__18066;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__18069 = null;
if (arguments.length > 3) {
var G__18070__i = 0, G__18070__a = new Array(arguments.length -  3);
while (G__18070__i < G__18070__a.length) {G__18070__a[G__18070__i] = arguments[G__18070__i + 3]; ++G__18070__i;}
G__18069 = new cljs.core.IndexedSeq(G__18070__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__4569__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__4569__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
var or__4569__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__4569__auto____$2)){
return or__4569__auto____$2;
} else {
var or__4569__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4569__auto____$3)){
return or__4569__auto____$3;
} else {
var or__4569__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4569__auto____$4)){
return or__4569__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__4569__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
var or__4569__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__4569__auto____$2)){
return or__4569__auto____$2;
} else {
var or__4569__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4569__auto____$3)){
return or__4569__auto____$3;
} else {
var or__4569__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4569__auto____$4)){
return or__4569__auto____$4;
} else {
var or__4569__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__4569__auto____$5)){
return or__4569__auto____$5;
} else {
var or__4569__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__4569__auto____$6)){
return or__4569__auto____$6;
} else {
var or__4569__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__4569__auto____$7)){
return or__4569__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__18071__delegate = function (x,y,z,args){
var or__4569__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.some(((function (or__4569__auto__){
return (function (p1__18045_SHARP_){
var or__4569__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__18045_SHARP_) : p1.call(null,p1__18045_SHARP_));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
var or__4569__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__18045_SHARP_) : p2.call(null,p1__18045_SHARP_));
if(cljs.core.truth_(or__4569__auto____$2)){
return or__4569__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__18045_SHARP_) : p3.call(null,p1__18045_SHARP_));
}
}
});})(or__4569__auto__))
,args);
}
};
var G__18071 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18072__i = 0, G__18072__a = new Array(arguments.length -  3);
while (G__18072__i < G__18072__a.length) {G__18072__a[G__18072__i] = arguments[G__18072__i + 3]; ++G__18072__i;}
  args = new cljs.core.IndexedSeq(G__18072__a,0);
} 
return G__18071__delegate.call(this,x,y,z,args);};
G__18071.cljs$lang$maxFixedArity = 3;
G__18071.cljs$lang$applyTo = (function (arglist__18073){
var x = cljs.core.first(arglist__18073);
arglist__18073 = cljs.core.next(arglist__18073);
var y = cljs.core.first(arglist__18073);
arglist__18073 = cljs.core.next(arglist__18073);
var z = cljs.core.first(arglist__18073);
var args = cljs.core.rest(arglist__18073);
return G__18071__delegate(x,y,z,args);
});
G__18071.cljs$core$IFn$_invoke$arity$variadic = G__18071__delegate;
return G__18071;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__18074 = null;
if (arguments.length > 3) {
var G__18075__i = 0, G__18075__a = new Array(arguments.length -  3);
while (G__18075__i < G__18075__a.length) {G__18075__a[G__18075__i] = arguments[G__18075__i + 3]; ++G__18075__i;}
G__18074 = new cljs.core.IndexedSeq(G__18075__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__18046_SHARP_){
return (p1__18046_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18046_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__18046_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__18047_SHARP_){
var or__4569__auto__ = (p1__18047_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18047_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__18047_SHARP_.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return (p1__18047_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18047_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__18047_SHARP_.call(null,y));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__18048_SHARP_){
var or__4569__auto__ = (p1__18048_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18048_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__18048_SHARP_.call(null,x));
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = (p1__18048_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18048_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__18048_SHARP_.call(null,y));
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return (p1__18048_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18048_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__18048_SHARP_.call(null,z));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__18076__delegate = function (x,y,z,args){
var or__4569__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.some(((function (or__4569__auto__,ps__$1){
return (function (p1__18049_SHARP_){
return cljs.core.some(p1__18049_SHARP_,args);
});})(or__4569__auto__,ps__$1))
,ps__$1);
}
};
var G__18076 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__18077__i = 0, G__18077__a = new Array(arguments.length -  3);
while (G__18077__i < G__18077__a.length) {G__18077__a[G__18077__i] = arguments[G__18077__i + 3]; ++G__18077__i;}
  args = new cljs.core.IndexedSeq(G__18077__a,0);
} 
return G__18076__delegate.call(this,x,y,z,args);};
G__18076.cljs$lang$maxFixedArity = 3;
G__18076.cljs$lang$applyTo = (function (arglist__18078){
var x = cljs.core.first(arglist__18078);
arglist__18078 = cljs.core.next(arglist__18078);
var y = cljs.core.first(arglist__18078);
arglist__18078 = cljs.core.next(arglist__18078);
var z = cljs.core.first(arglist__18078);
var args = cljs.core.rest(arglist__18078);
return G__18076__delegate(x,y,z,args);
});
G__18076.cljs$core$IFn$_invoke$arity$variadic = G__18076__delegate;
return G__18076;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__18079 = null;
if (arguments.length > 3) {
var G__18080__i = 0, G__18080__a = new Array(arguments.length -  3);
while (G__18080__i < G__18080__a.length) {G__18080__a[G__18080__i] = arguments[G__18080__i + 3]; ++G__18080__i;}
G__18079 = new cljs.core.IndexedSeq(G__18080__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__18079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq18051){
var G__18052 = cljs.core.first(seq18051);
var seq18051__$1 = cljs.core.next(seq18051);
var G__18053 = cljs.core.first(seq18051__$1);
var seq18051__$2 = cljs.core.next(seq18051__$1);
var G__18054 = cljs.core.first(seq18051__$2);
var seq18051__$3 = cljs.core.next(seq18051__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__18052,G__18053,G__18054,seq18051__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);
/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var args18082 = [];
var len__5627__auto___18102 = arguments.length;
var i__5628__auto___18103 = (0);
while(true){
if((i__5628__auto___18103 < len__5627__auto___18102)){
args18082.push((arguments[i__5628__auto___18103]));

var G__18104 = (i__5628__auto___18103 + (1));
i__5628__auto___18103 = G__18104;
continue;
} else {
}
break;
}

var G__18089 = args18082.length;
switch (G__18089) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18082.slice((4)),(0)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5646__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__18106 = null;
var G__18106__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18106__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18106__2 = (function (result,input){
var G__18090 = result;
var G__18091 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18090,G__18091) : rf.call(null,G__18090,G__18091));
});
var G__18106__3 = (function() { 
var G__18107__delegate = function (result,input,inputs){
var G__18092 = result;
var G__18093 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18092,G__18093) : rf.call(null,G__18092,G__18093));
};
var G__18107 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__18108__i = 0, G__18108__a = new Array(arguments.length -  2);
while (G__18108__i < G__18108__a.length) {G__18108__a[G__18108__i] = arguments[G__18108__i + 2]; ++G__18108__i;}
  inputs = new cljs.core.IndexedSeq(G__18108__a,0);
} 
return G__18107__delegate.call(this,result,input,inputs);};
G__18107.cljs$lang$maxFixedArity = 2;
G__18107.cljs$lang$applyTo = (function (arglist__18109){
var result = cljs.core.first(arglist__18109);
arglist__18109 = cljs.core.next(arglist__18109);
var input = cljs.core.first(arglist__18109);
var inputs = cljs.core.rest(arglist__18109);
return G__18107__delegate(result,input,inputs);
});
G__18107.cljs$core$IFn$_invoke$arity$variadic = G__18107__delegate;
return G__18107;
})()
;
G__18106 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__18106__0.call(this);
case 1:
return G__18106__1.call(this,result);
case 2:
return G__18106__2.call(this,result,input);
default:
var G__18110 = null;
if (arguments.length > 2) {
var G__18111__i = 0, G__18111__a = new Array(arguments.length -  2);
while (G__18111__i < G__18111__a.length) {G__18111__a[G__18111__i] = arguments[G__18111__i + 2]; ++G__18111__i;}
G__18110 = new cljs.core.IndexedSeq(G__18111__a,0);
}
return G__18106__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__18110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18106.cljs$lang$maxFixedArity = 2;
G__18106.cljs$lang$applyTo = G__18106__3.cljs$lang$applyTo;
G__18106.cljs$core$IFn$_invoke$arity$0 = G__18106__0;
G__18106.cljs$core$IFn$_invoke$arity$1 = G__18106__1;
G__18106.cljs$core$IFn$_invoke$arity$2 = G__18106__2;
G__18106.cljs$core$IFn$_invoke$arity$variadic = G__18106__3.cljs$core$IFn$_invoke$arity$variadic;
return G__18106;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5472__auto___18112 = size;
var i_18113 = (0);
while(true){
if((i_18113 < n__5472__auto___18112)){
cljs.core.chunk_append(b,(function (){var G__18094 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_18113);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18094) : f.call(null,G__18094));
})());

var G__18114 = (i_18113 + (1));
i_18113 = G__18114;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__18095 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18095) : f.call(null,G__18095));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2__$1){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2__$1);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__18096 = cljs.core.first(s1);
var G__18097 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18096,G__18097) : f.call(null,G__18096,G__18097));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2__$1,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2__$1);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__18098 = cljs.core.first(s1);
var G__18099 = cljs.core.first(s2);
var G__18100 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18098,G__18099,G__18100) : f.call(null,G__18098,G__18099,G__18100));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2__$1,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__18081_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__18081_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2__$1,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq18083){
var G__18084 = cljs.core.first(seq18083);
var seq18083__$1 = cljs.core.next(seq18083);
var G__18085 = cljs.core.first(seq18083__$1);
var seq18083__$2 = cljs.core.next(seq18083__$1);
var G__18086 = cljs.core.first(seq18083__$2);
var seq18083__$3 = cljs.core.next(seq18083__$2);
var G__18087 = cljs.core.first(seq18083__$3);
var seq18083__$4 = cljs.core.next(seq18083__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__18084,G__18085,G__18086,G__18087,seq18083__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var args18115 = [];
var len__5627__auto___18120 = arguments.length;
var i__5628__auto___18121 = (0);
while(true){
if((i__5628__auto___18121 < len__5627__auto___18120)){
args18115.push((arguments[i__5628__auto___18121]));

var G__18122 = (i__5628__auto___18121 + (1));
i__5628__auto___18121 = G__18122;
continue;
} else {
}
break;
}

var G__18117 = args18115.length;
switch (G__18117) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18115.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__18118 = cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"n","n",-2092305744,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__18118) : cljs.core.pr_str.call(null,G__18118));
})())].join('')));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__18124 = null;
var G__18124__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18124__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18124__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__18124 = function(result,input){
switch(arguments.length){
case 0:
return G__18124__0.call(this);
case 1:
return G__18124__1.call(this,result);
case 2:
return G__18124__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18124.cljs$core$IFn$_invoke$arity$0 = G__18124__0;
G__18124.cljs$core$IFn$_invoke$arity$1 = G__18124__1;
G__18124.cljs$core$IFn$_invoke$arity$2 = G__18124__2;
return G__18124;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__18119 = cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"n","n",-2092305744,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__18119) : cljs.core.pr_str.call(null,G__18119));
})())].join('')));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var args18125 = [];
var len__5627__auto___18130 = arguments.length;
var i__5628__auto___18131 = (0);
while(true){
if((i__5628__auto___18131 < len__5627__auto___18130)){
args18125.push((arguments[i__5628__auto___18131]));

var G__18132 = (i__5628__auto___18131 + (1));
i__5628__auto___18131 = G__18132;
continue;
} else {
}
break;
}

var G__18127 = args18125.length;
switch (G__18127) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18125.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__18128 = cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"n","n",-2092305744,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__18128) : cljs.core.pr_str.call(null,G__18128));
})())].join('')));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__18134 = null;
var G__18134__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18134__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18134__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__18134 = function(result,input){
switch(arguments.length){
case 0:
return G__18134__0.call(this);
case 1:
return G__18134__1.call(this,result);
case 2:
return G__18134__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18134.cljs$core$IFn$_invoke$arity$0 = G__18134__0;
G__18134.cljs$core$IFn$_invoke$arity$1 = G__18134__1;
G__18134.cljs$core$IFn$_invoke$arity$2 = G__18134__2;
return G__18134;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__18129 = cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"n","n",-2092305744,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__18129) : cljs.core.pr_str.call(null,G__18129));
})())].join('')));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__18135 = (n__$1 - (1));
var G__18136 = cljs.core.rest(s);
n__$1 = G__18135;
coll__$1 = G__18136;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var args18137 = [];
var len__5627__auto___18140 = arguments.length;
var i__5628__auto___18141 = (0);
while(true){
if((i__5628__auto___18141 < len__5627__auto___18140)){
args18137.push((arguments[i__5628__auto___18141]));

var G__18142 = (i__5628__auto___18141 + (1));
i__5628__auto___18141 = G__18142;
continue;
} else {
}
break;
}

var G__18139 = args18137.length;
switch (G__18139) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18137.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__18144 = cljs.core.next(s);
var G__18145 = cljs.core.next(lead);
s = G__18144;
lead = G__18145;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var args18146 = [];
var len__5627__auto___18151 = arguments.length;
var i__5628__auto___18152 = (0);
while(true){
if((i__5628__auto___18152 < len__5627__auto___18151)){
args18146.push((arguments[i__5628__auto___18152]));

var G__18153 = (i__5628__auto___18152 + (1));
i__5628__auto___18152 = G__18153;
continue;
} else {
}
break;
}

var G__18148 = args18146.length;
switch (G__18148) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18146.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__18155 = null;
var G__18155__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18155__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18155__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__4557__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__4557__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__4557__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__18155 = function(result,input){
switch(arguments.length){
case 0:
return G__18155__0.call(this);
case 1:
return G__18155__1.call(this,result);
case 2:
return G__18155__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18155.cljs$core$IFn$_invoke$arity$0 = G__18155__0;
G__18155.cljs$core$IFn$_invoke$arity$1 = G__18155__1;
G__18155.cljs$core$IFn$_invoke$arity$2 = G__18155__2;
return G__18155;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__4557__auto__ = s;
if(and__4557__auto__){
var G__18150 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__18150) : pred__$1.call(null,G__18150));
} else {
return and__4557__auto__;
}
})())){
var G__18156 = pred__$1;
var G__18157 = cljs.core.rest(s);
pred__$1 = G__18156;
coll__$1 = G__18157;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var args18158 = [];
var len__5627__auto___18161 = arguments.length;
var i__5628__auto___18162 = (0);
while(true){
if((i__5628__auto___18162 < len__5627__auto___18161)){
args18158.push((arguments[i__5628__auto___18162]));

var G__18163 = (i__5628__auto___18162 + (1));
i__5628__auto___18162 = G__18163;
continue;
} else {
}
break;
}

var G__18160 = args18158.length;
switch (G__18160) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18158.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var args18165 = [];
var len__5627__auto___18168 = arguments.length;
var i__5628__auto___18169 = (0);
while(true){
if((i__5628__auto___18169 < len__5627__auto___18168)){
args18165.push((arguments[i__5628__auto___18169]));

var G__18170 = (i__5628__auto___18169 + (1));
i__5628__auto___18169 = G__18170;
continue;
} else {
}
break;
}

var G__18167 = args18165.length;
switch (G__18167) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18165.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var args18174 = [];
var len__5627__auto___18180 = arguments.length;
var i__5628__auto___18181 = (0);
while(true){
if((i__5628__auto___18181 < len__5627__auto___18180)){
args18174.push((arguments[i__5628__auto___18181]));

var G__18182 = (i__5628__auto___18181 + (1));
i__5628__auto___18181 = G__18182;
continue;
} else {
}
break;
}

var G__18179 = args18174.length;
switch (G__18179) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18174.slice((2)),(0)));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5646__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2__$1){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2__$1);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2__$1,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2__$1,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq18175){
var G__18176 = cljs.core.first(seq18175);
var seq18175__$1 = cljs.core.next(seq18175);
var G__18177 = cljs.core.first(seq18175__$1);
var seq18175__$2 = cljs.core.next(seq18175__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__18176,G__18177,seq18175__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);
/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var args18184 = [];
var len__5627__auto___18187 = arguments.length;
var i__5628__auto___18188 = (0);
while(true){
if((i__5628__auto___18188 < len__5627__auto___18187)){
args18184.push((arguments[i__5628__auto___18188]));

var G__18189 = (i__5628__auto___18188 + (1));
i__5628__auto___18188 = G__18189;
continue;
} else {
}
break;
}

var G__18186 = args18184.length;
switch (G__18186) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18184.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__18191 = null;
var G__18191__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18191__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18191__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__18191 = function(result,input){
switch(arguments.length){
case 0:
return G__18191__0.call(this);
case 1:
return G__18191__1.call(this,result);
case 2:
return G__18191__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18191.cljs$core$IFn$_invoke$arity$0 = G__18191__0;
G__18191.cljs$core$IFn$_invoke$arity$1 = G__18191__1;
G__18191.cljs$core$IFn$_invoke$arity$2 = G__18191__2;
return G__18191;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;
/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var coll__$1 = temp__4423__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
cljs.core.cat;
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var args18200 = [];
var len__5627__auto___18205 = arguments.length;
var i__5628__auto___18206 = (0);
while(true){
if((i__5628__auto___18206 < len__5627__auto___18205)){
args18200.push((arguments[i__5628__auto___18206]));

var G__18207 = (i__5628__auto___18206 + (1));
i__5628__auto___18206 = G__18207;
continue;
} else {
}
break;
}

var G__18204 = args18200.length;
switch (G__18204) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18200.slice((1)),(0)));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5646__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq18201){
var G__18202 = cljs.core.first(seq18201);
var seq18201__$1 = cljs.core.next(seq18201);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__18202,seq18201__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);
/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var args18209 = [];
var len__5627__auto___18213 = arguments.length;
var i__5628__auto___18214 = (0);
while(true){
if((i__5628__auto___18214 < len__5627__auto___18213)){
args18209.push((arguments[i__5628__auto___18214]));

var G__18215 = (i__5628__auto___18214 + (1));
i__5628__auto___18214 = G__18215;
continue;
} else {
}
break;
}

var G__18211 = args18209.length;
switch (G__18211) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18209.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__18217 = null;
var G__18217__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18217__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18217__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__18217 = function(result,input){
switch(arguments.length){
case 0:
return G__18217__0.call(this);
case 1:
return G__18217__1.call(this,result);
case 2:
return G__18217__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18217.cljs$core$IFn$_invoke$arity$0 = G__18217__0;
G__18217.cljs$core$IFn$_invoke$arity$1 = G__18217__1;
G__18217.cljs$core$IFn$_invoke$arity$2 = G__18217__2;
return G__18217;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__5472__auto___18218 = size;
var i_18219 = (0);
while(true){
if((i_18219 < n__5472__auto___18218)){
if(cljs.core.truth_((function (){var G__18212 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_18219);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18212) : pred.call(null,G__18212));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_18219));
} else {
}

var G__18220 = (i_18219 + (1));
i_18219 = G__18220;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var args18221 = [];
var len__5627__auto___18224 = arguments.length;
var i__5628__auto___18225 = (0);
while(true){
if((i__5628__auto___18225 < len__5627__auto___18224)){
args18221.push((arguments[i__5628__auto___18225]));

var G__18226 = (i__5628__auto___18225 + (1));
i__5628__auto___18225 = G__18226;
continue;
} else {
}
break;
}

var G__18223 = args18221.length;
switch (G__18223) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18221.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18228_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__18228_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var args18229 = [];
var len__5627__auto___18234 = arguments.length;
var i__5628__auto___18235 = (0);
while(true){
if((i__5628__auto___18235 < len__5627__auto___18234)){
args18229.push((arguments[i__5628__auto___18235]));

var G__18236 = (i__5628__auto___18235 + (1));
i__5628__auto___18235 = G__18236;
continue;
} else {
}
break;
}

var G__18231 = args18229.length;
switch (G__18231) {
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18229.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || (to.cljs$core$IEditableCollection$))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || (to.cljs$core$IEditableCollection$))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;
/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var args18238 = [];
var len__5627__auto___18246 = arguments.length;
var i__5628__auto___18247 = (0);
while(true){
if((i__5628__auto___18247 < len__5627__auto___18246)){
args18238.push((arguments[i__5628__auto___18247]));

var G__18248 = (i__5628__auto___18247 + (1));
i__5628__auto___18247 = G__18248;
continue;
} else {
}
break;
}

var G__18245 = args18238.length;
switch (G__18245) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18238.slice((4)),(0)));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5646__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2__$1){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2__$1));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2__$1,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2__$1,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2__$1,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2__$1,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq18239){
var G__18240 = cljs.core.first(seq18239);
var seq18239__$1 = cljs.core.next(seq18239);
var G__18241 = cljs.core.first(seq18239__$1);
var seq18239__$2 = cljs.core.next(seq18239__$1);
var G__18242 = cljs.core.first(seq18239__$2);
var seq18239__$3 = cljs.core.next(seq18239__$2);
var G__18243 = cljs.core.first(seq18239__$3);
var seq18239__$4 = cljs.core.next(seq18239__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__18240,G__18241,G__18242,G__18243,seq18239__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);
/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var args18250 = [];
var len__5627__auto___18253 = arguments.length;
var i__5628__auto___18254 = (0);
while(true){
if((i__5628__auto___18254 < len__5627__auto___18253)){
args18250.push((arguments[i__5628__auto___18254]));

var G__18255 = (i__5628__auto___18254 + (1));
i__5628__auto___18254 = G__18255;
continue;
} else {
}
break;
}

var G__18252 = args18250.length;
switch (G__18252) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18250.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;
/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var args18257 = [];
var len__5627__auto___18261 = arguments.length;
var i__5628__auto___18262 = (0);
while(true){
if((i__5628__auto___18262 < len__5627__auto___18261)){
args18257.push((arguments[i__5628__auto___18262]));

var G__18263 = (i__5628__auto___18262 + (1));
i__5628__auto___18262 = G__18263;
continue;
} else {
}
break;
}

var G__18259 = args18257.length;
switch (G__18259) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18257.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!(((!((m__$1 == null)))?((((m__$1.cljs$lang$protocol_mask$partition0$ & (256))) || (m__$1.cljs$core$ILookup$))?true:(((!m__$1.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,m__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,m__$1)))){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__18265 = sentinel;
var G__18266 = m__$2;
var G__18267 = cljs.core.next(ks__$1);
sentinel = G__18265;
m__$1 = G__18266;
ks__$1 = G__18267;
continue;
}
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;
/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__18268,v){
var vec__18273 = p__18268;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18273,(0),null);
var ks = cljs.core.nthnext(vec__18273,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var args18274 = [];
var len__5627__auto___18304 = arguments.length;
var i__5628__auto___18305 = (0);
while(true){
if((i__5628__auto___18305 < len__5627__auto___18304)){
args18274.push((arguments[i__5628__auto___18305]));

var G__18306 = (i__5628__auto___18305 + (1));
i__5628__auto___18305 = G__18306;
continue;
} else {
}
break;
}

var G__18283 = args18274.length;
switch (G__18283) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18274.slice((6)),(0)));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5646__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__18284,f){
var vec__18285 = p__18284;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18285,(0),null);
var ks = cljs.core.nthnext(vec__18285,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18286) : f.call(null,G__18286));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__18287,f,a){
var vec__18288 = p__18287;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18288,(0),null);
var ks = cljs.core.nthnext(vec__18288,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18290 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18289,G__18290) : f.call(null,G__18289,G__18290));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__18291,f,a,b){
var vec__18292 = p__18291;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18292,(0),null);
var ks = cljs.core.nthnext(vec__18292,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18293 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18294 = a;
var G__18295 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18293,G__18294,G__18295) : f.call(null,G__18293,G__18294,G__18295));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__18296,f,a,b,c){
var vec__18297 = p__18296;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18297,(0),null);
var ks = cljs.core.nthnext(vec__18297,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18299 = a;
var G__18300 = b;
var G__18301 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18298,G__18299,G__18300,G__18301) : f.call(null,G__18298,G__18299,G__18300,G__18301));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__18302,f,a,b,c,args){
var vec__18303 = p__18302;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18303,(0),null);
var ks = cljs.core.nthnext(vec__18303,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq18275){
var G__18276 = cljs.core.first(seq18275);
var seq18275__$1 = cljs.core.next(seq18275);
var G__18277 = cljs.core.first(seq18275__$1);
var seq18275__$2 = cljs.core.next(seq18275__$1);
var G__18278 = cljs.core.first(seq18275__$2);
var seq18275__$3 = cljs.core.next(seq18275__$2);
var G__18279 = cljs.core.first(seq18275__$3);
var seq18275__$4 = cljs.core.next(seq18275__$3);
var G__18280 = cljs.core.first(seq18275__$4);
var seq18275__$5 = cljs.core.next(seq18275__$4);
var G__18281 = cljs.core.first(seq18275__$5);
var seq18275__$6 = cljs.core.next(seq18275__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__18276,G__18277,G__18278,G__18279,G__18280,G__18281,seq18275__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);
/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var args18308 = [];
var len__5627__auto___18328 = arguments.length;
var i__5628__auto___18329 = (0);
while(true){
if((i__5628__auto___18329 < len__5627__auto___18328)){
args18308.push((arguments[i__5628__auto___18329]));

var G__18330 = (i__5628__auto___18329 + (1));
i__5628__auto___18329 = G__18330;
continue;
} else {
}
break;
}

var G__18317 = args18308.length;
switch (G__18317) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18308.slice((6)),(0)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__5646__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18318) : f.call(null,G__18318));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18320 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18319,G__18320) : f.call(null,G__18319,G__18320));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18322 = x;
var G__18323 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18321,G__18322,G__18323) : f.call(null,G__18321,G__18322,G__18323));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18324 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18325 = x;
var G__18326 = y;
var G__18327 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18324,G__18325,G__18326,G__18327) : f.call(null,G__18324,G__18325,G__18326,G__18327));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq18309){
var G__18310 = cljs.core.first(seq18309);
var seq18309__$1 = cljs.core.next(seq18309);
var G__18311 = cljs.core.first(seq18309__$1);
var seq18309__$2 = cljs.core.next(seq18309__$1);
var G__18312 = cljs.core.first(seq18309__$2);
var seq18309__$3 = cljs.core.next(seq18309__$2);
var G__18313 = cljs.core.first(seq18309__$3);
var seq18309__$4 = cljs.core.next(seq18309__$3);
var G__18314 = cljs.core.first(seq18309__$4);
var seq18309__$5 = cljs.core.next(seq18309__$4);
var G__18315 = cljs.core.first(seq18309__$5);
var seq18309__$6 = cljs.core.next(seq18309__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__18310,G__18311,G__18312,G__18313,G__18314,G__18315,seq18309__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__18332 = (ll - (5));
var G__18333 = r;
ll = G__18332;
ret = G__18333;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__18338 = cljs.core.pv_aget(node,(0));
var G__18339 = (level - (5));
node = G__18338;
level = G__18339;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__18340 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__18341 = (level - (5));
node = G__18340;
level = G__18341;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"base","base",1825810849,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null)], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.tv_editable_root;

cljs.core.tv_editable_tail;

cljs.core.TransientVector;

cljs.core.deref;

cljs.core.pr_sequential_writer;

cljs.core.pr_writer;

cljs.core.chunked_seq;

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__18351 = init__$2;
var G__18352 = (j + i);
var G__18353 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18351,G__18352,G__18353) : f.call(null,G__18351,G__18352,G__18353));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__18360 = (j + (1));
var G__18361 = init__$3;
j = G__18360;
init__$2 = G__18361;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18362 = (i + len);
var G__18363 = init__$2;
i = G__18362;
init__$1 = G__18363;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null,self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null,self__.tail))));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__18354 = init__$2;
var G__18355 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18354,G__18355) : f.call(null,G__18354,G__18355));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__18364 = (j + (1));
var G__18365 = init__$3;
j = G__18364;
init__$2 = G__18365;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18366 = (i + len);
var G__18367 = init__$2;
i = G__18366;
init__$1 = G__18367;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__18356 = coll__$1;
var G__18357 = cljs.core.first_array_for_longvec(coll__$1);
var G__18358 = (0);
var G__18359 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18356,G__18357,G__18358,G__18359) : cljs.core.chunked_seq.call(null,G__18356,G__18357,G__18358,G__18359));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__5472__auto___18368 = len;
var i_18369 = (0);
while(true){
if((i_18369 < n__5472__auto___18368)){
(new_tail[i_18369] = (self__.tail[i_18369]));

var G__18370 = (i_18369 + (1));
i_18369 = G__18370;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__18371 = null;
var G__18371__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__18371__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__18371 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18371__2.call(this,self__,k);
case 3:
return G__18371__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18371.cljs$core$IFn$_invoke$arity$2 = G__18371__2;
G__18371.cljs$core$IFn$_invoke$arity$3 = G__18371__3;
return G__18371;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args18350){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18350)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.Symbol(null,"tail","tail",494507963,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__18372 = (i + (1));
var G__18373 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__18372;
out = G__18373;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18375 = arguments.length;
var i__5628__auto___18376 = (0);
while(true){
if((i__5628__auto___18376 < len__5627__auto___18375)){
args__5634__auto__.push((arguments[i__5628__auto___18376]));

var G__18377 = (i__5628__auto___18376 + (1));
i__5628__auto___18376 = G__18377;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq18374){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18374));
});
cljs.core.subvec;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__18378 = self__.vec;
var G__18379 = self__.node;
var G__18380 = self__.i;
var G__18381 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18378,G__18379,G__18380,G__18381) : cljs.core.chunked_seq.call(null,G__18378,G__18379,G__18380,G__18381));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__18382 = self__.vec;
var G__18383 = (self__.i + self__.off);
var G__18384 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__18382,G__18383,G__18384) : cljs.core.subvec.call(null,G__18382,G__18383,G__18384));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__18385 = self__.vec;
var G__18386 = (self__.i + self__.off);
var G__18387 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__18385,G__18386,G__18387) : cljs.core.subvec.call(null,G__18385,G__18386,G__18387));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__18388 = self__.vec;
var G__18389 = self__.node;
var G__18390 = self__.i;
var G__18391 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18388,G__18389,G__18390,G__18391) : cljs.core.chunked_seq.call(null,G__18388,G__18389,G__18390,G__18391));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__18392 = self__.vec;
var G__18393 = cljs.core.unchecked_array_for(self__.vec,end);
var G__18394 = end;
var G__18395 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18392,G__18393,G__18394,G__18395) : cljs.core.chunked_seq.call(null,G__18392,G__18393,G__18394,G__18395));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,m) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,m));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__18396 = self__.vec;
var G__18397 = cljs.core.unchecked_array_for(self__.vec,end);
var G__18398 = end;
var G__18399 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18396,G__18397,G__18398,G__18399) : cljs.core.chunked_seq.call(null,G__18396,G__18397,G__18398,G__18399));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vec","vec",982683596,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"off","off",-2047994980,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var args18400 = [];
var len__5627__auto___18403 = arguments.length;
var i__5628__auto___18404 = (0);
while(true){
if((i__5628__auto___18404 < len__5627__auto___18403)){
args18400.push((arguments[i__5628__auto___18404]));

var G__18405 = (i__5628__auto___18404 + (1));
i__5628__auto___18404 = G__18405;
continue;
} else {
}
break;
}

var G__18402 = args18400.length;
switch (G__18402) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18400.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.build_subvec;

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__18408 = init__$1;
var G__18409 = j;
var G__18410 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18408,G__18409,G__18410) : f.call(null,G__18408,G__18409,G__18410));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18427 = (i + (1));
var G__18428 = (j + (1));
var G__18429 = init__$2;
i = G__18427;
j = G__18428;
init__$1 = G__18429;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__18411 = self__.meta;
var G__18412 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__18413 = self__.start;
var G__18414 = (function (){var x__4900__auto__ = self__.end;
var y__4901__auto__ = (v_pos + (1));
return ((x__4900__auto__ > y__4901__auto__) ? x__4900__auto__ : y__4901__auto__);
})();
var G__18415 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18411,G__18412,G__18413,G__18414,G__18415) : cljs.core.build_subvec.call(null,G__18411,G__18412,G__18413,G__18414,G__18415));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__18416 = self__.meta;
var G__18417 = self__.v;
var G__18418 = self__.start;
var G__18419 = (self__.end - (1));
var G__18420 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18416,G__18417,G__18418,G__18419,G__18420) : cljs.core.build_subvec.call(null,G__18416,G__18417,G__18418,G__18419,G__18420));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null,meta__$1,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__18422 = self__.meta;
var G__18423 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__18424 = self__.start;
var G__18425 = (self__.end + (1));
var G__18426 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18422,G__18423,G__18424,G__18425,G__18426) : cljs.core.build_subvec.call(null,G__18422,G__18423,G__18424,G__18425,G__18426));
});

cljs.core.Subvec.prototype.call = (function() {
var G__18430 = null;
var G__18430__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__18430__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__18430 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18430__2.call(this,self__,k);
case 3:
return G__18430__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18430.cljs$core$IFn$_invoke$arity$2 = G__18430__2;
G__18430.cljs$core$IFn$_invoke$arity$3 = G__18430__3;
return G__18430;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args18407){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18407)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__18431 = meta;
var G__18432 = v.v;
var G__18433 = (v.start + start);
var G__18434 = (v.start + end);
var G__18435 = __hash;
meta = G__18431;
v = G__18432;
start = G__18433;
end = G__18434;
__hash = G__18435;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var args18436 = [];
var len__5627__auto___18439 = arguments.length;
var i__5628__auto___18440 = (0);
while(true){
if((i__5628__auto___18440 < len__5627__auto___18439)){
args18436.push((arguments[i__5628__auto___18440]));

var G__18441 = (i__5628__auto___18440 + (1));
i__5628__auto___18440 = G__18441;
continue;
} else {
}
break;
}

var G__18438 = args18436.length;
switch (G__18438) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18436.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode({},cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__18454 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__18455 = (level - (5));
node = G__18454;
level = G__18455;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__18459 = null;
var G__18459__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18459__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18459 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18459__2.call(this,self__,k);
case 3:
return G__18459__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18459.cljs$core$IFn$_invoke$arity$2 = G__18459__2;
G__18459.cljs$core$IFn$_invoke$arity$3 = G__18459__3;
return G__18459;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args18456){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18456)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"shift","shift",-1657295705,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"tail","tail",494507963,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
})
cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__4569__auto__ = (cljs.core.some_QMARK_(self__.fseq)) && (cljs.core.seq(self__.fseq));
if(or__4569__auto__){
return or__4569__auto__;
} else {
var and__4557__auto__ = cljs.core.some_QMARK_(self__.riter);
if(and__4557__auto__){
return self__.riter.hasNext();
} else {
return and__4557__auto__;
}
}
});

cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(cljs.core.some_QMARK_(self__.fseq)){
var ret = cljs.core.first(self__.fseq);
self__.fseq = cljs.core.next(self__.fseq);

return ret;
} else {
if((cljs.core.some_QMARK_(self__.riter)) && (self__.riter.hasNext())){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
});

cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"fseq","fseq",-1466412450,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"riter","riter",-237834262,null)], null);
});

cljs.core.PersistentQueueIter.cljs$lang$type = true;

cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";

cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentQueueIter");
});

cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4423__auto__ = cljs.core.next(self__.front);
if(temp__4423__auto__){
var f1 = temp__4423__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4423__auto__ = cljs.core.next(self__.front);
if(temp__4423__auto__){
var f1 = temp__4423__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__4569__auto__ = self__.front;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4569__auto__ = self__.rear;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"front","front",117022539,null),new cljs.core.Symbol(null,"rear","rear",-900164830,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 *   false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__18460 = (i + incr);
i = G__18460;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__18461 = (i + (1));
var G__18462 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__18461;
out = G__18462;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = {};
var l = ks.length;
var i_18467 = (0);
while(true){
if((i_18467 < l)){
var k_18468 = (ks[i_18467]);
(new_obj[k_18468] = (obj[k_18468]));

var G__18469 = (i_18467 + (1));
i_18467 = G__18469;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__18472 = init__$1;
var G__18473 = k;
var G__18474 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18472,G__18473,G__18474) : f.call(null,G__18472,G__18473,G__18474));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18475 = cljs.core.rest(keys__$1);
var G__18476 = init__$2;
keys__$1 = G__18475;
init__$1 = G__18476;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__18470_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__18470_SHARP_,(self__.strobj[p1__18470_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__18477 = null;
var G__18477__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18477__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18477 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18477__2.call(this,self__,k);
case 3:
return G__18477__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18477.cljs$core$IFn$_invoke$arity$2 = G__18477__2;
G__18477.cljs$core$IFn$_invoke$arity$3 = G__18477__3;
return G__18477;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args18471){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18471)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keys","keys",-1586012071,null),new cljs.core.Symbol(null,"strobj","strobj",1088091283,null),new cljs.core.Symbol(null,"update-count","update-count",-411982269,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],{},(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
})
cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__4569__auto__ = (self__.i < self__.base_count);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
});

cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
self__.i = (self__.i + (1));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k)], null);
} else {
return self__.ext_map_iter.next();
}
});

cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"record","record",861424668,null),new cljs.core.Symbol(null,"base-count","base-count",-1180647182,null),new cljs.core.Symbol(null,"fields","fields",-291534703,null),new cljs.core.Symbol(null,"ext-map-iter","ext-map-iter",-1215982757,null)], null);
});

cljs.core.RecordIter.cljs$lang$type = true;

cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";

cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/RecordIter");
});

cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__18480 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18480,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18480,(1),null);
self__.s = cljs.core.next(self__.s);

return {"value": [k,v], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": [x,x], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__18481 = (i + (2));
i = G__18481;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn))){
return i;
} else {
var G__18482 = (i + (2));
i = G__18482;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str))){
return i;
} else {
var G__18483 = (i + (2));
i = G__18483;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__18484 = (i + (2));
i = G__18484;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__18485 = (i + (2));
i = G__18485;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if((goog.isString(k)) || (typeof k === 'number')){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_18486 = (0);
while(true){
if((i_18486 < l)){
(narr[i_18486] = (arr[i_18486]));

var G__18487 = (i_18486 + (1));
i_18486 = G__18487;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});
cljs.core.TransientArrayMap;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});
cljs.core.keys;

cljs.core.vals;

/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null)], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18489 = cljs.core.seq(coll);
var chunk__18490 = null;
var count__18491 = (0);
var i__18492 = (0);
while(true){
if((i__18492 < count__18491)){
var vec__18493 = chunk__18490.cljs$core$IIndexed$_nth$arity$2(null,i__18492);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18493,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18493,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18502 = seq__18489;
var G__18503 = chunk__18490;
var G__18504 = count__18491;
var G__18505 = (i__18492 + (1));
seq__18489 = G__18502;
chunk__18490 = G__18503;
count__18491 = G__18504;
i__18492 = G__18505;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__18489);
if(temp__4425__auto__){
var seq__18489__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18489__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__18489__$1);
var G__18506 = cljs.core.chunk_rest(seq__18489__$1);
var G__18507 = c__5372__auto__;
var G__18508 = cljs.core.count(c__5372__auto__);
var G__18509 = (0);
seq__18489 = G__18506;
chunk__18490 = G__18507;
count__18491 = G__18508;
i__18492 = G__18509;
continue;
} else {
var vec__18494 = cljs.core.first(seq__18489__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18494,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18494,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18510 = cljs.core.next(seq__18489__$1);
var G__18511 = null;
var G__18512 = (0);
var G__18513 = (0);
seq__18489 = G__18510;
chunk__18490 = G__18511;
count__18491 = G__18512;
i__18492 = G__18513;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__18495 = init__$1;
var G__18496 = (self__.arr[i]);
var G__18497 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18495,G__18496,G__18497) : f.call(null,G__18495,G__18496,G__18497));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18514 = (i + (2));
var G__18515 = init__$2;
i = G__18514;
init__$1 = G__18515;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((!((other == null)))?((((other.cljs$lang$protocol_mask$partition0$ & (1024))) || (other.cljs$core$IMap$))?true:false):false)){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__18516 = (i + (2));
i = G__18516;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap({},self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__18517 = (s + (2));
var G__18518 = d;
s = G__18517;
d = G__18518;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__18519 = (s + (2));
var G__18520 = (d + (2));
s = G__18519;
d = G__18520;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__18501 = cljs.core.aclone(self__.arr);
(G__18501[(idx + (1))] = v);

return G__18501;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__18521 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__18522 = cljs.core.next(es);
ret = G__18521;
es = G__18522;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__18523 = null;
var G__18523__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18523__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18523 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18523__2.call(this,self__,k);
case 3:
return G__18523__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18523.cljs$core$IFn$_invoke$arity$2 = G__18523__2;
G__18523.cljs$core$IFn$_invoke$arity$3 = G__18523__3;
return G__18523;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args18488){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18488)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_18524 = (0);
while(true){
if((i_18524 < arr__$1.length)){
var k_18525 = (arr__$1[i_18524]);
var v_18526 = (arr__$1[(i_18524 + (1))]);
var idx_18527 = cljs.core.array_index_of(ret,k_18525);
if((idx_18527 === (-1))){
ret.push(k_18525);

ret.push(v_18526);
} else {
}

var G__18528 = (i_18524 + (2));
i_18524 = G__18528;
continue;
} else {
}
break;
}

return ret;
})());
var arr__$3 = (function (){var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
})();
return arr__$3;
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.array__GT_transient_hash_map;

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || (o.cljs$core$IMapEntry$))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return cljs.core._assoc_BANG_(tcoll__$1,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4423__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4423__auto__)){
var e = temp__4423__auto__;
var G__18531 = cljs.core.next(es);
var G__18532 = cljs.core._assoc_BANG_(tcoll__$2,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__18531;
tcoll__$2 = G__18532;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__18530_18533 = self__.arr;
G__18530_18533.pop();

G__18530_18533.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"editable?","editable?",-164945806,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"len","len",-1230778691,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"arr","arr",2115492975,null)], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.TransientHashMap;

cljs.core.PersistentHashMap;
cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__18534 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__18535 = (i + (2));
out = G__18534;
i = G__18535;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});

cljs.core.create_inode_seq;

cljs.core.create_array_node_seq;

cljs.core.reset_BANG_;

cljs.core.create_node;

cljs.core.atom;

cljs.core.deref;
cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var args18536 = [];
var len__5627__auto___18541 = arguments.length;
var i__5628__auto___18542 = (0);
while(true){
if((i__5628__auto___18542 < len__5627__auto___18541)){
args18536.push((arguments[i__5628__auto___18542]));

var G__18543 = (i__5628__auto___18542 + (1));
i__5628__auto___18542 = G__18543;
continue;
} else {
}
break;
}

var G__18538 = args18536.length;
switch (G__18538) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18536.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__18539 = cljs.core.aclone(arr);
(G__18539[i] = a);

return G__18539;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__18540 = cljs.core.aclone(arr);
(G__18540[i] = a);

(G__18540[j] = b);

return G__18540;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var args18545 = [];
var len__5627__auto___18548 = arguments.length;
var i__5628__auto___18549 = (0);
while(true){
if((i__5628__auto___18549 < len__5627__auto___18548)){
args18545.push((arguments[i__5628__auto___18549]));

var G__18550 = (i__5628__auto___18549 + (1));
i__5628__auto___18549 = G__18550;
continue;
} else {
}
break;
}

var G__18547 = args18545.length;
switch (G__18547) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18545.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__18555 = init__$1;
var G__18556 = k;
var G__18557 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18555,G__18556,G__18557) : f.call(null,G__18555,G__18556,G__18557));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18558 = (i + (2));
var G__18559 = init__$2;
i = G__18558;
init__$1 = G__18559;
continue;
}
} else {
return init__$1;
}
break;
}
});
cljs.core.ArrayNode;

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
})
cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = ((cljs.core.some_QMARK_(key))?self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,node_or_val], null):((cljs.core.some_QMARK_(node_or_val))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return self__.next_iter = new_iter;
} else {
return false;
}
})():false
));
self__.i = (self__.i + (2));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
});

cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__4569__auto__ = cljs.core.some_QMARK_(self__.next_entry);
if(or__4569__auto__){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
if(or__4569__auto____$1){
return or__4569__auto____$1;
} else {
return this$.advance();
}
}
});

cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.some_QMARK_(self__.next_entry)){
var ret = self__.next_entry;
self__.next_entry = null;

return ret;
} else {
if(cljs.core.some_QMARK_(self__.next_iter)){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
self__.next_iter = null;
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
});

cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-entry","next-entry",1091342476,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.NodeIterator.cljs$lang$type = true;

cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";

cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/NodeIterator");
});

cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_18573 = (0);
var j_18574 = (0);
while(true){
if((i_18573 < (32))){
if((((self__.bitmap >>> i_18573) & (1)) === (0))){
var G__18575 = (i_18573 + (1));
var G__18576 = j_18574;
i_18573 = G__18575;
j_18574 = G__18576;
continue;
} else {
(nodes[i_18573] = ((!(((self__.arr[j_18574]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_18574])),(self__.arr[j_18574]),(self__.arr[(j_18574 + (1))]),added_leaf_QMARK_):(self__.arr[(j_18574 + (1))])));

var G__18577 = (i_18573 + (1));
var G__18578 = (j_18574 + (2));
i_18573 = G__18577;
j_18574 = G__18578;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__18560 = edit__$1;
var G__18561 = (shift + (5));
var G__18562 = key_or_nil;
var G__18563 = val_or_node;
var G__18564 = hash;
var G__18565 = key;
var G__18566 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__18560,G__18561,G__18562,G__18563,G__18564,G__18565,G__18566) : cljs.core.create_node.call(null,G__18560,G__18561,G__18562,G__18563,G__18564,G__18565,G__18566));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_18579 = (0);
var j_18580 = (0);
while(true){
if((i_18579 < (32))){
if((((self__.bitmap >>> i_18579) & (1)) === (0))){
var G__18581 = (i_18579 + (1));
var G__18582 = j_18580;
i_18579 = G__18581;
j_18580 = G__18582;
continue;
} else {
(nodes[i_18579] = ((!(((self__.arr[j_18580]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_18580])),(self__.arr[j_18580]),(self__.arr[(j_18580 + (1))]),added_leaf_QMARK_):(self__.arr[(j_18580 + (1))])));

var G__18583 = (i_18579 + (1));
var G__18584 = (j_18580 + (2));
i_18579 = G__18583;
j_18580 = G__18584;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__18567 = (shift + (5));
var G__18568 = key_or_nil;
var G__18569 = val_or_node;
var G__18570 = hash;
var G__18571 = key;
var G__18572 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__18567,G__18568,G__18569,G__18570,G__18571,G__18572) : cljs.core.create_node.call(null,G__18567,G__18568,G__18569,G__18570,G__18571,G__18572));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = true;

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"bitmap","bitmap",501334601,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__18585 = (i + (1));
var G__18586 = (j + (2));
var G__18587 = (bitmap | ((1) << i));
i = G__18585;
j = G__18586;
bitmap = G__18587;
continue;
} else {
var G__18588 = (i + (1));
var G__18589 = j;
var G__18590 = bitmap;
i = G__18588;
j = G__18589;
bitmap = G__18590;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
})
cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if(!((cljs.core.some_QMARK_(self__.next_iter)) && (self__.next_iter.hasNext()))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

if(cljs.core.some_QMARK_(node)){
self__.next_iter = cljs.core._iterator(node);
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});

cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
});

cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"arr","arr",2115492975,null),cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"next-iter","next-iter",1526626239,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ArrayNodeIterator.cljs$lang$type = true;

cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";

cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ArrayNodeIterator");
});

cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null,self__.arr));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__18591 = (i + (1));
var G__18592 = init__$2;
i = G__18591;
init__$1 = G__18592;
continue;
}
} else {
var G__18593 = (i + (1));
var G__18594 = init__$1;
i = G__18593;
init__$1 = G__18594;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = true;

cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__18595 = (i + (2));
i = G__18595;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = true;

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"edit","edit",-1302639,null),cljs.core.with_meta(new cljs.core.Symbol(null,"collision-hash","collision-hash",-35831342,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var args18596 = [];
var len__5627__auto___18599 = arguments.length;
var i__5628__auto___18600 = (0);
while(true){
if((i__5628__auto___18600 < len__5627__auto___18599)){
args18596.push((arguments[i__5628__auto___18600]));

var G__18601 = (i__5628__auto___18600 + (1));
i__5628__auto___18600 = G__18601;
continue;
} else {
}
break;
}

var G__18598 = args18596.length;
switch (G__18598) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18596.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__18603 = self__.nodes;
var G__18604 = (self__.i + (2));
var G__18605 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18603,G__18604,G__18605) : cljs.core.create_inode_seq.call(null,G__18603,G__18604,G__18605));
} else {
var G__18606 = self__.nodes;
var G__18607 = self__.i;
var G__18608 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18606,G__18607,G__18608) : cljs.core.create_inode_seq.call(null,G__18606,G__18607,G__18608));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var args18609 = [];
var len__5627__auto___18612 = arguments.length;
var i__5628__auto___18613 = (0);
while(true){
if((i__5628__auto___18613 < len__5627__auto___18612)){
args18609.push((arguments[i__5628__auto___18613]));

var G__18614 = (i__5628__auto___18613 + (1));
i__5628__auto___18613 = G__18614;
continue;
} else {
}
break;
}

var G__18611 = args18609.length;
switch (G__18611) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18609.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4423__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4423__auto__)){
var node = temp__4423__auto__;
var temp__4423__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4423__auto____$1)){
var node_seq = temp__4423__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__18616 = (j + (2));
j = G__18616;
continue;
}
} else {
var G__18617 = (j + (2));
j = G__18617;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__18618 = null;
var G__18619 = self__.nodes;
var G__18620 = self__.i;
var G__18621 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__18618,G__18619,G__18620,G__18621) : cljs.core.create_array_node_seq.call(null,G__18618,G__18619,G__18620,G__18621));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"nodes","nodes",-459054278,null),new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"s","s",-948495851,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var args18622 = [];
var len__5627__auto___18625 = arguments.length;
var i__5628__auto___18626 = (0);
while(true){
if((i__5628__auto___18626 < len__5627__auto___18625)){
args18622.push((arguments[i__5628__auto___18626]));

var G__18627 = (i__5628__auto___18626 + (1));
i__5628__auto___18626 = G__18627;
continue;
} else {
}
break;
}

var G__18624 = args18622.length;
switch (G__18624) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18622.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4423__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4423__auto__)){
var nj = temp__4423__auto__;
var temp__4423__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4423__auto____$1)){
var ns = temp__4423__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__18629 = (j + (1));
j = G__18629;
continue;
}
} else {
var G__18630 = (j + (1));
j = G__18630;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.TransientHashMap;

/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
})
cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.seen) && (self__.root_iter.hasNext());
});

cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!(self__.seen)){
self__.seen = true;

return self__.nil_val;
} else {
return self__.root_iter.next();
}
});

cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.Symbol(null,"root-iter","root-iter",1974672108,null),cljs.core.with_meta(new cljs.core.Symbol(null,"seen","seen",1121531738,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.HashMapIter.cljs$lang$type = true;

cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";

cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/HashMapIter");
});

cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18632 = cljs.core.seq(coll);
var chunk__18633 = null;
var count__18634 = (0);
var i__18635 = (0);
while(true){
if((i__18635 < count__18634)){
var vec__18636 = chunk__18633.cljs$core$IIndexed$_nth$arity$2(null,i__18635);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18636,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18636,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18640 = seq__18632;
var G__18641 = chunk__18633;
var G__18642 = count__18634;
var G__18643 = (i__18635 + (1));
seq__18632 = G__18640;
chunk__18633 = G__18641;
count__18634 = G__18642;
i__18635 = G__18643;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__18632);
if(temp__4425__auto__){
var seq__18632__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18632__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__18632__$1);
var G__18644 = cljs.core.chunk_rest(seq__18632__$1);
var G__18645 = c__5372__auto__;
var G__18646 = cljs.core.count(c__5372__auto__);
var G__18647 = (0);
seq__18632 = G__18644;
chunk__18633 = G__18645;
count__18634 = G__18646;
i__18635 = G__18647;
continue;
} else {
var vec__18637 = cljs.core.first(seq__18632__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18637,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18637,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18648 = cljs.core.next(seq__18632__$1);
var G__18649 = null;
var G__18650 = (0);
var G__18651 = (0);
seq__18632 = G__18648;
chunk__18633 = G__18649;
count__18634 = G__18650;
i__18635 = G__18651;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter);
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap({},self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__18652 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__18653 = cljs.core.next(es);
ret = G__18652;
es = G__18653;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__18654 = null;
var G__18654__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18654__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18654 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18654__2.call(this,self__,k);
case 3:
return G__18654__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18654.cljs$core$IFn$_invoke$arity$2 = G__18654__2;
G__18654.cljs$core$IFn$_invoke$arity$3 = G__18654__3;
return G__18654;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args18631){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18631)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"root","root",1191874074,null),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__18655 = (i + (2));
var G__18656 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__18655;
ret = G__18656;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__18657 = (i + (1));
var G__18658 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__18657;
out = G__18658;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || (o.cljs$core$IMapEntry$))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4423__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4423__auto__)){
var e = temp__4423__auto__;
var G__18660 = cljs.core.next(es);
var G__18661 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__18660;
tcoll__$1 = G__18661;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"edit","edit",-1302639,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"root","root",1191874074,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"has-nil?","has-nil?",825886722,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil-val","nil-val",-513933559,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__18662 = ((ascending_QMARK_)?t.left:t.right);
var G__18663 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__18662;
stack__$1 = G__18663;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"stack","stack",847125597,null),cljs.core.with_meta(new cljs.core.Symbol(null,"ascending?","ascending?",-1938452653,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"boolean","boolean",-278886877,null)], null)),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});
cljs.core.RedNode;

cljs.core.BlackNode;
cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
var init__$2 = (function (){var G__18673 = init__$1;
var G__18674 = node.key;
var G__18675 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18673,G__18674,G__18675) : f.call(null,G__18673,G__18674,G__18675));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null,init__$3));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__18677 = null;
var G__18677__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18677__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18677 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18677__2.call(this,self__,k);
case 3:
return G__18677__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18677.cljs$core$IFn$_invoke$arity$2 = G__18677__2;
G__18677.cljs$core$IFn$_invoke$arity$3 = G__18677__3;
return G__18677;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args18676){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18676)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__18679 = null;
var G__18679__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18679__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18679 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18679__2.call(this,self__,k);
case 3:
return G__18679__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18679.cljs$core$IFn$_invoke$arity$2 = G__18679__2;
G__18679.cljs$core$IFn$_invoke$arity$3 = G__18679__3;
return G__18679;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args18678){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18678)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"right","right",1187949694,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__18692 = k;
var G__18693 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18692,G__18693) : comp.call(null,G__18692,G__18693));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__18712 = k;
var G__18713 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18712,G__18713) : comp.call(null,G__18712,G__18713));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});
cljs.core.key;

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18723 = cljs.core.seq(coll);
var chunk__18724 = null;
var count__18725 = (0);
var i__18726 = (0);
while(true){
if((i__18726 < count__18725)){
var vec__18727 = chunk__18724.cljs$core$IIndexed$_nth$arity$2(null,i__18726);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18727,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18727,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18733 = seq__18723;
var G__18734 = chunk__18724;
var G__18735 = count__18725;
var G__18736 = (i__18726 + (1));
seq__18723 = G__18733;
chunk__18724 = G__18734;
count__18725 = G__18735;
i__18726 = G__18736;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__18723);
if(temp__4425__auto__){
var seq__18723__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18723__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__18723__$1);
var G__18737 = cljs.core.chunk_rest(seq__18723__$1);
var G__18738 = c__5372__auto__;
var G__18739 = cljs.core.count(c__5372__auto__);
var G__18740 = (0);
seq__18723 = G__18737;
chunk__18724 = G__18738;
count__18725 = G__18739;
i__18726 = G__18740;
continue;
} else {
var vec__18728 = cljs.core.first(seq__18723__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18728,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18728,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18741 = cljs.core.next(seq__18723__$1);
var G__18742 = null;
var G__18743 = (0);
var G__18744 = (0);
seq__18723 = G__18741;
chunk__18724 = G__18742;
count__18725 = G__18743;
i__18726 = G__18744;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__18729 = k;
var G__18730 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__18729,G__18730) : self__.comp.call(null,G__18729,G__18730));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__18745 = t.left;
t = G__18745;
continue;
} else {
var G__18746 = t.right;
t = G__18746;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__18747 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__18748 = cljs.core.next(es);
ret = G__18747;
es = G__18748;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__18749 = null;
var G__18749__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18749__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18749 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18749__2.call(this,self__,k);
case 3:
return G__18749__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18749.cljs$core$IFn$_invoke$arity$2 = G__18749__2;
G__18749.cljs$core$IFn$_invoke$arity$3 = G__18749__3;
return G__18749;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args18722){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18722)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__18731 = k;
var G__18732 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__18731,G__18732) : self__.comp.call(null,G__18731,G__18732));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__18750 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__18751 = t.left;
stack = G__18750;
t = G__18751;
continue;
} else {
var G__18752 = stack;
var G__18753 = t.right;
stack = G__18752;
t = G__18753;
continue;
}
} else {
if((c > (0))){
var G__18754 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__18755 = t.right;
stack = G__18754;
t = G__18755;
continue;
} else {
var G__18756 = stack;
var G__18757 = t.left;
stack = G__18756;
t = G__18757;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null,entry));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"comp","comp",-1462482139,null),new cljs.core.Symbol(null,"tree","tree",1444219499,null),new cljs.core.Symbol(null,"cnt","cnt",1924510325,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18759 = arguments.length;
var i__5628__auto___18760 = (0);
while(true){
if((i__5628__auto___18760 < len__5627__auto___18759)){
args__5634__auto__.push((arguments[i__5628__auto___18760]));

var G__18761 = (i__5628__auto___18760 + (1));
i__5628__auto___18760 = G__18761;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__18762 = cljs.core.nnext(in$);
var G__18763 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__18762;
out = G__18763;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq18758){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18758));
});
/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18765 = arguments.length;
var i__5628__auto___18766 = (0);
while(true){
if((i__5628__auto___18766 < len__5627__auto___18765)){
args__5634__auto__.push((arguments[i__5628__auto___18766]));

var G__18767 = (i__5628__auto___18766 + (1));
i__5628__auto___18766 = G__18767;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq18764){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18764));
});
/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18771 = arguments.length;
var i__5628__auto___18772 = (0);
while(true){
if((i__5628__auto___18772 < len__5627__auto___18771)){
args__5634__auto__.push((arguments[i__5628__auto___18772]));

var G__18773 = (i__5628__auto___18772 + (1));
i__5628__auto___18772 = G__18773;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = {};
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__18774 = cljs.core.nnext(kvs);
kvs = G__18774;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq18768){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18768));
});
/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18776 = arguments.length;
var i__5628__auto___18777 = (0);
while(true){
if((i__5628__auto___18777 < len__5627__auto___18776)){
args__5634__auto__.push((arguments[i__5628__auto___18777]));

var G__18778 = (i__5628__auto___18777 + (1));
i__5628__auto___18777 = G__18778;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__18779 = cljs.core.nnext(in$);
var G__18780 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__18779;
out = G__18780;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq18775){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18775));
});
/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18783 = arguments.length;
var i__5628__auto___18784 = (0);
while(true){
if((i__5628__auto___18784 < len__5627__auto___18783)){
args__5634__auto__.push((arguments[i__5628__auto___18784]));

var G__18785 = (i__5628__auto___18784 + (1));
i__5628__auto___18784 = G__18785;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__18786 = cljs.core.nnext(in$);
var G__18787 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__18786;
out = G__18787;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq18781){
var G__18782 = cljs.core.first(seq18781);
var seq18781__$1 = cljs.core.next(seq18781);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__18782,seq18781__$1);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4425__auto__ = cljs.core.seq(hash_map);
if(temp__4425__auto__){
var mseq = temp__4425__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mseq","mseq",1602647196,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"not-native","not-native",-236392494,null)], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4425__auto__ = cljs.core.seq(hash_map);
if(temp__4425__auto__){
var mseq = temp__4425__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18795 = arguments.length;
var i__5628__auto___18796 = (0);
while(true){
if((i__5628__auto___18796 < len__5627__auto___18795)){
args__5634__auto__.push((arguments[i__5628__auto___18796]));

var G__18797 = (i__5628__auto___18796 + (1));
i__5628__auto___18796 = G__18797;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__18792_SHARP_,p2__18793_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4569__auto__ = p1__18792_SHARP_;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__18793_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq18794){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18794));
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18802 = arguments.length;
var i__5628__auto___18803 = (0);
while(true){
if((i__5628__auto___18803 < len__5627__auto___18802)){
args__5634__auto__.push((arguments[i__5628__auto___18803]));

var G__18804 = (i__5628__auto___18803 + (1));
i__5628__auto___18803 = G__18804;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__18800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__18801 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18800,G__18801) : f.call(null,G__18800,G__18801));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__4569__auto__ = m1;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq18798){
var G__18799 = cljs.core.first(seq18798);
var seq18798__$1 = cljs.core.next(seq18798);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__18799,seq18798__$1);
});
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__18805 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__18806 = cljs.core.next(keys);
ret = G__18805;
keys = G__18806;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});
cljs.core.TransientHashSet;

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
})
cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
});

cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return (self__.iter.next().tail[(0)]);
} else {
throw (new Error("No such element"));
}
});

cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"iter","iter",-1346195486,null)], null);
});

cljs.core.HashSetIter.cljs$lang$type = true;

cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter";

cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/HashSetIter");
});

cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18809 = cljs.core.seq(coll);
var chunk__18810 = null;
var count__18811 = (0);
var i__18812 = (0);
while(true){
if((i__18812 < count__18811)){
var vec__18813 = chunk__18810.cljs$core$IIndexed$_nth$arity$2(null,i__18812);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18813,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18813,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18815 = seq__18809;
var G__18816 = chunk__18810;
var G__18817 = count__18811;
var G__18818 = (i__18812 + (1));
seq__18809 = G__18815;
chunk__18810 = G__18816;
count__18811 = G__18817;
i__18812 = G__18818;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__18809);
if(temp__4425__auto__){
var seq__18809__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18809__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__18809__$1);
var G__18819 = cljs.core.chunk_rest(seq__18809__$1);
var G__18820 = c__5372__auto__;
var G__18821 = cljs.core.count(c__5372__auto__);
var G__18822 = (0);
seq__18809 = G__18819;
chunk__18810 = G__18820;
count__18811 = G__18821;
i__18812 = G__18822;
continue;
} else {
var vec__18814 = cljs.core.first(seq__18809__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18814,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18814,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18823 = cljs.core.next(seq__18809__$1);
var G__18824 = null;
var G__18825 = (0);
var G__18826 = (0);
seq__18809 = G__18823;
chunk__18810 = G__18824;
count__18811 = G__18825;
i__18812 = G__18826;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__18807_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__18807_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__18827 = null;
var G__18827__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18827__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18827 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18827__2.call(this,self__,k);
case 3:
return G__18827__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18827.cljs$core$IFn$_invoke$arity$2 = G__18827__2;
G__18827.cljs$core$IFn$_invoke$arity$3 = G__18827__3;
return G__18827;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args18808){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18808)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__18828 = (i + (1));
var G__18829 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__18828;
out = G__18829;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__18830 = (i + (1));
var G__18831 = cljs.core._conj_BANG_(out,(items[i]));
i = G__18830;
out = G__18831;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__18833 = null;
var G__18833__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__18833__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__18833 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18833__2.call(this,self__,k);
case 3:
return G__18833__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18833.cljs$core$IFn$_invoke$arity$2 = G__18833__2;
G__18833.cljs$core$IFn$_invoke$arity$3 = G__18833__3;
return G__18833;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args18832){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18832)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"transient-map","transient-map",351764893,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__18836 = cljs.core.seq(coll);
var chunk__18837 = null;
var count__18838 = (0);
var i__18839 = (0);
while(true){
if((i__18839 < count__18838)){
var vec__18840 = chunk__18837.cljs$core$IIndexed$_nth$arity$2(null,i__18839);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18840,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18840,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18842 = seq__18836;
var G__18843 = chunk__18837;
var G__18844 = count__18838;
var G__18845 = (i__18839 + (1));
seq__18836 = G__18842;
chunk__18837 = G__18843;
count__18838 = G__18844;
i__18839 = G__18845;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__18836);
if(temp__4425__auto__){
var seq__18836__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18836__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__18836__$1);
var G__18846 = cljs.core.chunk_rest(seq__18836__$1);
var G__18847 = c__5372__auto__;
var G__18848 = cljs.core.count(c__5372__auto__);
var G__18849 = (0);
seq__18836 = G__18846;
chunk__18837 = G__18847;
count__18838 = G__18848;
i__18839 = G__18849;
continue;
} else {
var vec__18841 = cljs.core.first(seq__18836__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18841,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18841,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__18850 = cljs.core.next(seq__18836__$1);
var G__18851 = null;
var G__18852 = (0);
var G__18853 = (0);
seq__18836 = G__18850;
chunk__18837 = G__18851;
count__18838 = G__18852;
i__18839 = G__18853;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__18834_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__18834_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__18854 = null;
var G__18854__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__18854__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__18854 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__18854__2.call(this,self__,k);
case 3:
return G__18854__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18854.cljs$core$IFn$_invoke$arity$2 = G__18854__2;
G__18854.cljs$core$IFn$_invoke$arity$3 = G__18854__3;
return G__18854;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args18835){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args18835)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"tree-map","tree-map",1373073049,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__5466__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__5466__auto__.length)){
var G__18855 = (i + (1));
var G__18856 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__18855;
res = G__18856;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__18857 = cljs.core.next(in$__$1);
var G__18858 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__18857;
out = G__18858;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var args18859 = [];
var len__5627__auto___18863 = arguments.length;
var i__5628__auto___18864 = (0);
while(true){
if((i__5628__auto___18864 < len__5627__auto___18863)){
args18859.push((arguments[i__5628__auto___18864]));

var G__18865 = (i__5628__auto___18864 + (1));
i__5628__auto___18864 = G__18865;
continue;
} else {
}
break;
}

var G__18862 = args18859.length;
switch (G__18862) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18859.slice((0)),(0)));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5646__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq18860){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18860));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);
/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18868 = arguments.length;
var i__5628__auto___18869 = (0);
while(true){
if((i__5628__auto___18869 < len__5627__auto___18868)){
args__5634__auto__.push((arguments[i__5628__auto___18869]));

var G__18870 = (i__5628__auto___18869 + (1));
i__5628__auto___18869 = G__18870;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq18867){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18867));
});
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__5634__auto__ = [];
var len__5627__auto___18873 = arguments.length;
var i__5628__auto___18874 = (0);
while(true){
if((i__5628__auto___18874 < len__5627__auto___18873)){
args__5634__auto__.push((arguments[i__5628__auto___18874]));

var G__18875 = (i__5628__auto___18874 + (1));
i__5628__auto___18874 = G__18875;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq18871){
var G__18872 = cljs.core.first(seq18871);
var seq18871__$1 = cljs.core.next(seq18871);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__18872,seq18871__$1);
});
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var args18878 = [];
var len__5627__auto___18881 = arguments.length;
var i__5628__auto___18882 = (0);
while(true){
if((i__5628__auto___18882 < len__5627__auto___18881)){
args18878.push((arguments[i__5628__auto___18882]));

var G__18883 = (i__5628__auto___18882 + (1));
i__5628__auto___18882 = G__18883;
continue;
} else {
}
break;
}

var G__18880 = args18878.length;
switch (G__18880) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18878.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__18876_SHARP_){
var temp__4423__auto__ = cljs.core.find(smap,p1__18876_SHARP_);
if(cljs.core.truth_(temp__4423__auto__)){
var e = temp__4423__auto__;
return cljs.core.val(e);
} else {
return p1__18876_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4423__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4423__auto__)){
var e = temp__4423__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18877_SHARP_){
var temp__4423__auto__ = cljs.core.find(smap,p1__18877_SHARP_);
if(cljs.core.truth_(temp__4423__auto__)){
var e = temp__4423__auto__;
return cljs.core.second(e);
} else {
return p1__18877_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var args18885 = [];
var len__5627__auto___18894 = arguments.length;
var i__5628__auto___18895 = (0);
while(true){
if((i__5628__auto___18895 < len__5627__auto___18894)){
args18885.push((arguments[i__5628__auto___18895]));

var G__18896 = (i__5628__auto___18895 + (1));
i__5628__auto___18895 = G__18896;
continue;
} else {
}
break;
}

var G__18887 = args18885.length;
switch (G__18887) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18885.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__18898 = null;
var G__18898__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18898__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18898__2 = (function (result,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen) : cljs.core.deref.call(null,seen)),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__18898 = function(result,input){
switch(arguments.length){
case 0:
return G__18898__0.call(this);
case 1:
return G__18898__1.call(this,result);
case 2:
return G__18898__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18898.cljs$core$IFn$_invoke$arity$0 = G__18898__0;
G__18898.cljs$core$IFn$_invoke$arity$1 = G__18898__1;
G__18898.cljs$core$IFn$_invoke$arity$2 = G__18898__2;
return G__18898;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__18892,seen__$1){
while(true){
var vec__18893 = p__18892;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18893,(0),null);
var xs__$1 = vec__18893;
var temp__4425__auto__ = cljs.core.seq(xs__$1);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__18899 = cljs.core.rest(s);
var G__18900 = seen__$1;
p__18892 = G__18899;
seen__$1 = G__18900;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__18901 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__18902 = cljs.core.next(s__$1);
ret = G__18901;
s__$1 = G__18902;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || (x.cljs$core$INamed$))?true:false):false)){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__18905 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__18906 = cljs.core.next(ks);
var G__18907 = cljs.core.next(vs);
map = G__18905;
ks = G__18906;
vs = G__18907;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var args18910 = [];
var len__5627__auto___18917 = arguments.length;
var i__5628__auto___18918 = (0);
while(true){
if((i__5628__auto___18918 < len__5627__auto___18917)){
args18910.push((arguments[i__5628__auto___18918]));

var G__18919 = (i__5628__auto___18918 + (1));
i__5628__auto___18918 = G__18919;
continue;
} else {
}
break;
}

var G__18916 = args18910.length;
switch (G__18916) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18910.slice((3)),(0)));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) > (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18908_SHARP_,p2__18909_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__18908_SHARP_,p2__18909_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq18911){
var G__18912 = cljs.core.first(seq18911);
var seq18911__$1 = cljs.core.next(seq18911);
var G__18913 = cljs.core.first(seq18911__$1);
var seq18911__$2 = cljs.core.next(seq18911__$1);
var G__18914 = cljs.core.first(seq18911__$2);
var seq18911__$3 = cljs.core.next(seq18911__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__18912,G__18913,G__18914,seq18911__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);
/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var args18923 = [];
var len__5627__auto___18930 = arguments.length;
var i__5628__auto___18931 = (0);
while(true){
if((i__5628__auto___18931 < len__5627__auto___18930)){
args18923.push((arguments[i__5628__auto___18931]));

var G__18932 = (i__5628__auto___18931 + (1));
i__5628__auto___18931 = G__18932;
continue;
} else {
}
break;
}

var G__18929 = args18923.length;
switch (G__18929) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args18923.slice((3)),(0)));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) < (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18921_SHARP_,p2__18922_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__18921_SHARP_,p2__18922_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq18924){
var G__18925 = cljs.core.first(seq18924);
var seq18924__$1 = cljs.core.next(seq18924);
var G__18926 = cljs.core.first(seq18924__$1);
var seq18924__$2 = cljs.core.next(seq18924__$1);
var G__18927 = cljs.core.first(seq18924__$2);
var seq18924__$3 = cljs.core.next(seq18924__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__18925,G__18926,G__18927,seq18924__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"arr","arr",2115492975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var args18934 = [];
var len__5627__auto___18937 = arguments.length;
var i__5628__auto___18938 = (0);
while(true){
if((i__5628__auto___18938 < len__5627__auto___18937)){
args18934.push((arguments[i__5628__auto___18938]));

var G__18939 = (i__5628__auto___18938 + (1));
i__5628__auto___18938 = G__18939;
continue;
} else {
}
break;
}

var G__18936 = args18934.length;
switch (G__18936) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18934.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__18941 = null;
var G__18941__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18941__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__18941__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
} else {
return result;
}
});
G__18941 = function(result,input){
switch(arguments.length){
case 0:
return G__18941__0.call(this);
case 1:
return G__18941__1.call(this,result);
case 2:
return G__18941__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18941.cljs$core$IFn$_invoke$arity$0 = G__18941__0;
G__18941.cljs$core$IFn$_invoke$arity$1 = G__18941__1;
G__18941.cljs$core$IFn$_invoke$arity$2 = G__18941__2;
return G__18941;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var args18942 = [];
var len__5627__auto___18946 = arguments.length;
var i__5628__auto___18947 = (0);
while(true){
if((i__5628__auto___18947 < len__5627__auto___18946)){
args18942.push((arguments[i__5628__auto___18947]));

var G__18948 = (i__5628__auto___18947 + (1));
i__5628__auto___18947 = G__18948;
continue;
} else {
}
break;
}

var G__18944 = args18942.length;
switch (G__18944) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18942.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__18950 = null;
var G__18950__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__18950__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__18950__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return cljs.core.reduced(result);
}
});
G__18950 = function(result,input){
switch(arguments.length){
case 0:
return G__18950__0.call(this);
case 1:
return G__18950__1.call(this,result);
case 2:
return G__18950__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18950.cljs$core$IFn$_invoke$arity$0 = G__18950__0;
G__18950.cljs$core$IFn$_invoke$arity$1 = G__18950__1;
G__18950.cljs$core$IFn$_invoke$arity$2 = G__18950__2;
return G__18950;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
if(cljs.core.truth_((function (){var G__18945 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18945) : pred.call(null,G__18945));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__18959 = (function (){var G__18961 = cljs.core._entry_key(sc,e);
var G__18962 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18961,G__18962) : comp.call(null,G__18961,G__18962));
})();
var G__18960 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__18959,G__18960) : test.call(null,G__18959,G__18960));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var args18963 = [];
var len__5627__auto___18968 = arguments.length;
var i__5628__auto___18969 = (0);
while(true){
if((i__5628__auto___18969 < len__5627__auto___18968)){
args18963.push((arguments[i__5628__auto___18969]));

var G__18970 = (i__5628__auto___18969 + (1));
i__5628__auto___18969 = G__18970;
continue;
} else {
}
break;
}

var G__18965 = args18963.length;
switch (G__18965) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18963.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4425__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__18966 = temp__4425__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18966,(0),null);
var s = vec__18966;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4425__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__18967 = temp__4425__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18967,(0),null);
var s = vec__18967;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a reverse seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(var_args){
var args18972 = [];
var len__5627__auto___18977 = arguments.length;
var i__5628__auto___18978 = (0);
while(true){
if((i__5628__auto___18978 < len__5627__auto___18977)){
args18972.push((arguments[i__5628__auto___18978]));

var G__18979 = (i__5628__auto___18978 + (1));
i__5628__auto___18978 = G__18979;
continue;
} else {
}
break;
}

var G__18974 = args18972.length;
switch (G__18974) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18972.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4425__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__18975 = temp__4425__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18975,(0),null);
var s = vec__18975;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4425__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4425__auto__)){
var vec__18976 = temp__4425__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18976,(0),null);
var s = vec__18976;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null)], null);
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__18981 = ((self__.end - self__.start) / self__.step);
return Math.ceil(G__18981);
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__5004__auto__ = self__.__hash;
if(!((h__5004__auto__ == null))){
return h__5004__auto__;
} else {
var h__5004__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__5004__auto____$1;

return h__5004__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,i) : f.call(null,ret,i));
if(cljs.core.reduced_QMARK_(ret__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret__$1) : cljs.core.deref.call(null,ret__$1));
} else {
var G__18982 = (i + self__.step);
var G__18983 = ret__$1;
i = G__18982;
ret = G__18983;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.step < (0))){
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start === self__.end)){
return null;
} else {
return rng__$1;
}

}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"step","step",-1365547645,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__5563__auto__ = this;
return cljs.core.es6_iterator(this__5563__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(var_args){
var args18984 = [];
var len__5627__auto___18987 = arguments.length;
var i__5628__auto___18988 = (0);
while(true){
if((i__5628__auto___18988 < len__5627__auto___18987)){
args18984.push((arguments[i__5628__auto___18988]));

var G__18989 = (i__5628__auto___18988 + (1));
i__5628__auto___18988 = G__18989;
continue;
} else {
}
break;
}

var G__18986 = args18984.length;
switch (G__18986) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18984.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(var_args){
var args18991 = [];
var len__5627__auto___18996 = arguments.length;
var i__5628__auto___18997 = (0);
while(true){
if((i__5628__auto___18997 < len__5627__auto___18996)){
args18991.push((arguments[i__5628__auto___18997]));

var G__18998 = (i__5628__auto___18997 + (1));
i__5628__auto___18997 = G__18998;
continue;
} else {
}
break;
}

var G__18993 = args18991.length;
switch (G__18993) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18991.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__18994 = cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"n","n",-2092305744,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__18994) : cljs.core.pr_str.call(null,G__18994));
})())].join('')));
}

return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__19000 = null;
var G__19000__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__19000__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__19000__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__19000 = function(result,input){
switch(arguments.length){
case 0:
return G__19000__0.call(this);
case 1:
return G__19000__1.call(this,result);
case 2:
return G__19000__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19000.cljs$core$IFn$_invoke$arity$0 = G__19000__0;
G__19000.cljs$core$IFn$_invoke$arity$1 = G__19000__1;
G__19000.cljs$core$IFn$_invoke$arity$2 = G__19000__2;
return G__19000;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__18995 = cljs.core.list(new cljs.core.Symbol(null,"number?","number?",-1747282210,null),new cljs.core.Symbol(null,"n","n",-2092305744,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__18995) : cljs.core.pr_str.call(null,G__18995));
})())].join('')));
}

return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(var_args){
var args19002 = [];
var len__5627__auto___19005 = arguments.length;
var i__5628__auto___19006 = (0);
while(true){
if((i__5628__auto___19006 < len__5627__auto___19005)){
args19002.push((arguments[i__5628__auto___19006]));

var G__19007 = (i__5628__auto___19006 + (1));
i__5628__auto___19006 = G__19007;
continue;
} else {
}
break;
}

var G__19004 = args19002.length;
switch (G__19004) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19002.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__19009 = null;
var G__19009__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__19009__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__19009__2 = (function (result,input){
var pval = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pa) : cljs.core.deref.call(null,pa));
var val = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__19009 = function(result,input){
switch(arguments.length){
case 0:
return G__19009__0.call(this);
case 1:
return G__19009__1.call(this,result);
case 2:
return G__19009__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19009.cljs$core$IFn$_invoke$arity$0 = G__19009__0;
G__19009.cljs$core$IFn$_invoke$arity$1 = G__19009__1;
G__19009.cljs$core$IFn$_invoke$arity$2 = G__19009__2;
return G__19009;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
var fst = cljs.core.first(s);
var fv = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(fst) : f.call(null,fst));
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4425__auto__){
return (function (p1__19001_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(p1__19001_SHARP_) : f.call(null,p1__19001_SHARP_)));
});})(fst,fv,s,temp__4425__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;
/**
 * Returns a map from distinct items in coll to the number of times
 *   they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 *   per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(var_args){
var args19010 = [];
var len__5627__auto___19015 = arguments.length;
var i__5628__auto___19016 = (0);
while(true){
if((i__5628__auto___19016 < len__5627__auto___19015)){
args19010.push((arguments[i__5628__auto___19016]));

var G__19017 = (i__5628__auto___19016 + (1));
i__5628__auto___19016 = G__19017;
continue;
} else {
}
break;
}

var G__19012 = args19010.length;
switch (G__19012) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19010.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4423__auto__ = cljs.core.seq(coll);
if(temp__4423__auto__){
var s = temp__4423__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.seq(coll);
if(temp__4425__auto__){
var s = temp__4425__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__19013 = init;
var G__19014 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__19013,G__19014) : f.call(null,G__19013,G__19014));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 *   of those fns.  The returned fn takes a variable number of args, and
 *   returns a vector containing the result of applying each fn to the
 *   args (left-to-right).
 *   ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(var_args){
var args19029 = [];
var len__5627__auto___19036 = arguments.length;
var i__5628__auto___19037 = (0);
while(true){
if((i__5628__auto___19037 < len__5627__auto___19036)){
args19029.push((arguments[i__5628__auto___19037]));

var G__19038 = (i__5628__auto___19037 + (1));
i__5628__auto___19037 = G__19038;
continue;
} else {
}
break;
}

var G__19035 = args19029.length;
switch (G__19035) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5646__auto__ = (new cljs.core.IndexedSeq(args19029.slice((3)),(0)));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5646__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__19040 = null;
var G__19040__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))],null));
});
var G__19040__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x))],null));
});
var G__19040__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y))],null));
});
var G__19040__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z))],null));
});
var G__19040__4 = (function() { 
var G__19041__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__19041 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__19042__i = 0, G__19042__a = new Array(arguments.length -  3);
while (G__19042__i < G__19042__a.length) {G__19042__a[G__19042__i] = arguments[G__19042__i + 3]; ++G__19042__i;}
  args = new cljs.core.IndexedSeq(G__19042__a,0);
} 
return G__19041__delegate.call(this,x,y,z,args);};
G__19041.cljs$lang$maxFixedArity = 3;
G__19041.cljs$lang$applyTo = (function (arglist__19043){
var x = cljs.core.first(arglist__19043);
arglist__19043 = cljs.core.next(arglist__19043);
var y = cljs.core.first(arglist__19043);
arglist__19043 = cljs.core.next(arglist__19043);
var z = cljs.core.first(arglist__19043);
var args = cljs.core.rest(arglist__19043);
return G__19041__delegate(x,y,z,args);
});
G__19041.cljs$core$IFn$_invoke$arity$variadic = G__19041__delegate;
return G__19041;
})()
;
G__19040 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__19040__0.call(this);
case 1:
return G__19040__1.call(this,x);
case 2:
return G__19040__2.call(this,x,y);
case 3:
return G__19040__3.call(this,x,y,z);
default:
var G__19044 = null;
if (arguments.length > 3) {
var G__19045__i = 0, G__19045__a = new Array(arguments.length -  3);
while (G__19045__i < G__19045__a.length) {G__19045__a[G__19045__i] = arguments[G__19045__i + 3]; ++G__19045__i;}
G__19044 = new cljs.core.IndexedSeq(G__19045__a,0);
}
return G__19040__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__19044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19040.cljs$lang$maxFixedArity = 3;
G__19040.cljs$lang$applyTo = G__19040__4.cljs$lang$applyTo;
G__19040.cljs$core$IFn$_invoke$arity$0 = G__19040__0;
G__19040.cljs$core$IFn$_invoke$arity$1 = G__19040__1;
G__19040.cljs$core$IFn$_invoke$arity$2 = G__19040__2;
G__19040.cljs$core$IFn$_invoke$arity$3 = G__19040__3;
G__19040.cljs$core$IFn$_invoke$arity$variadic = G__19040__4.cljs$core$IFn$_invoke$arity$variadic;
return G__19040;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__19046 = null;
var G__19046__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null))],null));
});
var G__19046__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x))],null));
});
var G__19046__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y))],null));
});
var G__19046__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z))],null));
});
var G__19046__4 = (function() { 
var G__19047__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__19047 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__19048__i = 0, G__19048__a = new Array(arguments.length -  3);
while (G__19048__i < G__19048__a.length) {G__19048__a[G__19048__i] = arguments[G__19048__i + 3]; ++G__19048__i;}
  args = new cljs.core.IndexedSeq(G__19048__a,0);
} 
return G__19047__delegate.call(this,x,y,z,args);};
G__19047.cljs$lang$maxFixedArity = 3;
G__19047.cljs$lang$applyTo = (function (arglist__19049){
var x = cljs.core.first(arglist__19049);
arglist__19049 = cljs.core.next(arglist__19049);
var y = cljs.core.first(arglist__19049);
arglist__19049 = cljs.core.next(arglist__19049);
var z = cljs.core.first(arglist__19049);
var args = cljs.core.rest(arglist__19049);
return G__19047__delegate(x,y,z,args);
});
G__19047.cljs$core$IFn$_invoke$arity$variadic = G__19047__delegate;
return G__19047;
})()
;
G__19046 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__19046__0.call(this);
case 1:
return G__19046__1.call(this,x);
case 2:
return G__19046__2.call(this,x,y);
case 3:
return G__19046__3.call(this,x,y,z);
default:
var G__19050 = null;
if (arguments.length > 3) {
var G__19051__i = 0, G__19051__a = new Array(arguments.length -  3);
while (G__19051__i < G__19051__a.length) {G__19051__a[G__19051__i] = arguments[G__19051__i + 3]; ++G__19051__i;}
G__19050 = new cljs.core.IndexedSeq(G__19051__a,0);
}
return G__19046__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__19050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19046.cljs$lang$maxFixedArity = 3;
G__19046.cljs$lang$applyTo = G__19046__4.cljs$lang$applyTo;
G__19046.cljs$core$IFn$_invoke$arity$0 = G__19046__0;
G__19046.cljs$core$IFn$_invoke$arity$1 = G__19046__1;
G__19046.cljs$core$IFn$_invoke$arity$2 = G__19046__2;
G__19046.cljs$core$IFn$_invoke$arity$3 = G__19046__3;
G__19046.cljs$core$IFn$_invoke$arity$variadic = G__19046__4.cljs$core$IFn$_invoke$arity$variadic;
return G__19046;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__19052 = null;
var G__19052__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null)),(h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null))],null));
});
var G__19052__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x)),(h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x))],null));
});
var G__19052__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y)),(h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y))],null));
});
var G__19052__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z)),(h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z))],null));
});
var G__19052__4 = (function() { 
var G__19053__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__19053 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__19054__i = 0, G__19054__a = new Array(arguments.length -  3);
while (G__19054__i < G__19054__a.length) {G__19054__a[G__19054__i] = arguments[G__19054__i + 3]; ++G__19054__i;}
  args = new cljs.core.IndexedSeq(G__19054__a,0);
} 
return G__19053__delegate.call(this,x,y,z,args);};
G__19053.cljs$lang$maxFixedArity = 3;
G__19053.cljs$lang$applyTo = (function (arglist__19055){
var x = cljs.core.first(arglist__19055);
arglist__19055 = cljs.core.next(arglist__19055);
var y = cljs.core.first(arglist__19055);
arglist__19055 = cljs.core.next(arglist__19055);
var z = cljs.core.first(arglist__19055);
var args = cljs.core.rest(arglist__19055);
return G__19053__delegate(x,y,z,args);
});
G__19053.cljs$core$IFn$_invoke$arity$variadic = G__19053__delegate;
return G__19053;
})()
;
G__19052 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__19052__0.call(this);
case 1:
return G__19052__1.call(this,x);
case 2:
return G__19052__2.call(this,x,y);
case 3:
return G__19052__3.call(this,x,y,z);
default:
var G__19056 = null;
if (arguments.length > 3) {
var G__19057__i = 0, G__19057__a = new Array(arguments.length -  3);
while (G__19057__i < G__19057__a.length) {G__19057__a[G__19057__i] = arguments[G__19057__i + 3]; ++G__19057__i;}
G__19056 = new cljs.core.IndexedSeq(G__19057__a,0);
}
return G__19052__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__19056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19052.cljs$lang$maxFixedArity = 3;
G__19052.cljs$lang$applyTo = G__19052__4.cljs$lang$applyTo;
G__19052.cljs$core$IFn$_invoke$arity$0 = G__19052__0;
G__19052.cljs$core$IFn$_invoke$arity$1 = G__19052__1;
G__19052.cljs$core$IFn$_invoke$arity$2 = G__19052__2;
G__19052.cljs$core$IFn$_invoke$arity$3 = G__19052__3;
G__19052.cljs$core$IFn$_invoke$arity$variadic = G__19052__4.cljs$core$IFn$_invoke$arity$variadic;
return G__19052;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__19058 = null;
var G__19058__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__19019_SHARP_,p2__19020_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19019_SHARP_,(p2__19020_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__19020_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__19020_SHARP_.call(null)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__19058__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__19021_SHARP_,p2__19022_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19021_SHARP_,(p2__19022_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__19022_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p2__19022_SHARP_.call(null,x)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__19058__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__19023_SHARP_,p2__19024_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19023_SHARP_,(p2__19024_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__19024_SHARP_.cljs$core$IFn$_invoke$arity$2(x,y) : p2__19024_SHARP_.call(null,x,y)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__19058__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__19025_SHARP_,p2__19026_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19025_SHARP_,(p2__19026_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__19026_SHARP_.cljs$core$IFn$_invoke$arity$3(x,y,z) : p2__19026_SHARP_.call(null,x,y,z)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__19058__4 = (function() { 
var G__19059__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__19027_SHARP_,p2__19028_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19027_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__19028_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__19059 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__19060__i = 0, G__19060__a = new Array(arguments.length -  3);
while (G__19060__i < G__19060__a.length) {G__19060__a[G__19060__i] = arguments[G__19060__i + 3]; ++G__19060__i;}
  args = new cljs.core.IndexedSeq(G__19060__a,0);
} 
return G__19059__delegate.call(this,x,y,z,args);};
G__19059.cljs$lang$maxFixedArity = 3;
G__19059.cljs$lang$applyTo = (function (arglist__19061){
var x = cljs.core.first(arglist__19061);
arglist__19061 = cljs.core.next(arglist__19061);
var y = cljs.core.first(arglist__19061);
arglist__19061 = cljs.core.next(arglist__19061);
var z = cljs.core.first(arglist__19061);
var args = cljs.core.rest(arglist__19061);
return G__19059__delegate(x,y,z,args);
});
G__19059.cljs$core$IFn$_invoke$arity$variadic = G__19059__delegate;
return G__19059;
})()
;
G__19058 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__19058__0.call(this);
case 1:
return G__19058__1.call(this,x);
case 2:
return G__19058__2.call(this,x,y);
case 3:
return G__19058__3.call(this,x,y,z);
default:
var G__19062 = null;
if (arguments.length > 3) {
var G__19063__i = 0, G__19063__a = new Array(arguments.length -  3);
while (G__19063__i < G__19063__a.length) {G__19063__a[G__19063__i] = arguments[G__19063__i + 3]; ++G__19063__i;}
G__19062 = new cljs.core.IndexedSeq(G__19063__a,0);
}
return G__19058__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__19062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__19058.cljs$lang$maxFixedArity = 3;
G__19058.cljs$lang$applyTo = G__19058__4.cljs$lang$applyTo;
G__19058.cljs$core$IFn$_invoke$arity$0 = G__19058__0;
G__19058.cljs$core$IFn$_invoke$arity$1 = G__19058__1;
G__19058.cljs$core$IFn$_invoke$arity$2 = G__19058__2;
G__19058.cljs$core$IFn$_invoke$arity$3 = G__19058__3;
G__19058.cljs$core$IFn$_invoke$arity$variadic = G__19058__4.cljs$core$IFn$_invoke$arity$variadic;
return G__19058;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq19030){
var G__19031 = cljs.core.first(seq19030);
var seq19030__$1 = cljs.core.next(seq19030);
var G__19032 = cljs.core.first(seq19030__$1);
var seq19030__$2 = cljs.core.next(seq19030__$1);
var G__19033 = cljs.core.first(seq19030__$2);
var seq19030__$3 = cljs.core.next(seq19030__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__19031,G__19032,G__19033,seq19030__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = (3);
/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. dorun can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(var_args){
var args19064 = [];
var len__5627__auto___19067 = arguments.length;
var i__5628__auto___19068 = (0);
while(true){
if((i__5628__auto___19068 < len__5627__auto___19067)){
args19064.push((arguments[i__5628__auto___19068]));

var G__19069 = (i__5628__auto___19068 + (1));
i__5628__auto___19068 = G__19069;
continue;
} else {
}
break;
}

var G__19066 = args19064.length;
switch (G__19066) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19064.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__19071 = cljs.core.next(coll);
coll = G__19071;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__19072 = (n - (1));
var G__19073 = cljs.core.next(coll);
n = G__19072;
coll = G__19073;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;
/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. doall can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, retains the head and returns it, thus causing the entire
 *   seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(var_args){
var args19074 = [];
var len__5627__auto___19077 = arguments.length;
var i__5628__auto___19078 = (0);
while(true){
if((i__5628__auto___19078 < len__5627__auto___19077)){
args19074.push((arguments[i__5628__auto___19078]));

var G__19079 = (i__5628__auto___19078 + (1));
i__5628__auto___19078 = G__19079;
continue;
} else {
}
break;
}

var G__19076 = args19074.length;
switch (G__19076) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19074.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 *   re.exec(s). Returns a vector, containing first the matching
 *   substring, then any capturing groups if the regular expression contains
 *   capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__19082 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19082,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19082,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__4569__auto__ = flags;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_19090 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__4569__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__19091_19097 = cljs.core.first(coll);
var G__19092_19098 = writer;
var G__19093_19099 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__19091_19097,G__19092_19098,G__19093_19099) : print_one.call(null,G__19091_19097,G__19092_19098,G__19093_19099));
} else {
}

var coll_19100__$1 = cljs.core.next(coll);
var n_19101 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_19100__$1) && (((n_19101 == null)) || (!((n_19101 === (0)))))){
cljs.core._write(writer,sep);

var G__19094_19102 = cljs.core.first(coll_19100__$1);
var G__19095_19103 = writer;
var G__19096_19104 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__19094_19102,G__19095_19103,G__19096_19104) : print_one.call(null,G__19094_19102,G__19095_19103,G__19096_19104));

var G__19105 = cljs.core.next(coll_19100__$1);
var G__19106 = (n_19101 - (1));
coll_19100__$1 = G__19105;
n_19101 = G__19106;
continue;
} else {
if((cljs.core.seq(coll_19100__$1)) && ((n_19101 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__4569__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_19090;
}});
cljs.core.write_all = (function cljs$core$write_all(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19113 = arguments.length;
var i__5628__auto___19114 = (0);
while(true){
if((i__5628__auto___19114 < len__5627__auto___19113)){
args__5634__auto__.push((arguments[i__5628__auto___19114]));

var G__19115 = (i__5628__auto___19114 + (1));
i__5628__auto___19114 = G__19115;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((1) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((1)),(0))):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5635__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__19109 = cljs.core.seq(ss);
var chunk__19110 = null;
var count__19111 = (0);
var i__19112 = (0);
while(true){
if((i__19112 < count__19111)){
var s = chunk__19110.cljs$core$IIndexed$_nth$arity$2(null,i__19112);
cljs.core._write(writer,s);

var G__19116 = seq__19109;
var G__19117 = chunk__19110;
var G__19118 = count__19111;
var G__19119 = (i__19112 + (1));
seq__19109 = G__19116;
chunk__19110 = G__19117;
count__19111 = G__19118;
i__19112 = G__19119;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__19109);
if(temp__4425__auto__){
var seq__19109__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19109__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__19109__$1);
var G__19120 = cljs.core.chunk_rest(seq__19109__$1);
var G__19121 = c__5372__auto__;
var G__19122 = cljs.core.count(c__5372__auto__);
var G__19123 = (0);
seq__19109 = G__19120;
chunk__19110 = G__19121;
count__19111 = G__19122;
i__19112 = G__19123;
continue;
} else {
var s = cljs.core.first(seq__19109__$1);
cljs.core._write(writer,s);

var G__19124 = cljs.core.next(seq__19109__$1);
var G__19125 = null;
var G__19126 = (0);
var G__19127 = (0);
seq__19109 = G__19124;
chunk__19110 = G__19125;
count__19111 = G__19126;
i__19112 = G__19127;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.write_all.cljs$lang$maxFixedArity = (1);

cljs.core.write_all.cljs$lang$applyTo = (function (seq19107){
var G__19108 = cljs.core.first(seq19107);
var seq19107__$1 = cljs.core.next(seq19107);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(G__19108,seq19107__$1);
});
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj19129 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj19129;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace(RegExp("[\\\\\"\b\f\n\r\t]","g"),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.print_map;
cljs.core.print_meta_QMARK_ = (function cljs$core$print_meta_QMARK_(opts,obj){
var and__4557__auto__ = cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964)));
if(and__4557__auto__){
var and__4557__auto____$1 = ((!((obj == null)))?((((obj.cljs$lang$protocol_mask$partition0$ & (131072))) || (obj.cljs$core$IMeta$))?true:false):false);
if(and__4557__auto____$1){
return !((cljs.core.meta(obj) == null));
} else {
return and__4557__auto____$1;
}
} else {
return and__4557__auto__;
}
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(cljs.core.print_meta_QMARK_(opts,obj)){
cljs.core._write(writer,"^");

var G__19145_19154 = cljs.core.meta(obj);
var G__19146_19155 = writer;
var G__19147_19156 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__19145_19154,G__19146_19155,G__19147_19156) : cljs.core.pr_writer.call(null,G__19145_19154,G__19146_19155,G__19147_19156));

cljs.core._write(writer," ");
} else {
}

if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if(((!((obj == null)))?((((obj.cljs$lang$protocol_mask$partition0$ & (2147483648))) || (obj.cljs$core$IPrintWithWriter$))?true:false):false)){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if((obj === true) || (obj === false) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__19149 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__19150 = cljs.core.pr_writer;
var G__19151 = writer;
var G__19152 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__19149,G__19150,G__19151,G__19152) : cljs.core.print_map.call(null,G__19149,G__19150,G__19151,G__19152));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(goog.isString(obj)){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(goog.isFunction(obj)){
var name = obj.name;
var name__$1 = (cljs.core.truth_((function (){var or__4569__auto__ = (name == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return goog.string.isEmpty(name);
}
})())?"Function":name);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#object[",name__$1," \"",[cljs.core.str(obj)].join(''),"\"]"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__19157 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__19157;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if(((!((obj == null)))?((((obj.cljs$lang$protocol_mask$partition0$ & (2147483648))) || (obj.cljs$core$IPrintWithWriter$))?true:false):false)){
return cljs.core._pr_writer(obj,writer,opts);
} else {
if(cljs.core.truth_(obj.constructor.cljs$lang$ctorStr)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#object[",obj.constructor.cljs$lang$ctorStr.replace((new RegExp("/","g")),"."),"]"], 0));
} else {
var name = obj.constructor.name;
var name__$1 = (cljs.core.truth_((function (){var or__4569__auto__ = (name == null);
if(or__4569__auto__){
return or__4569__auto__;
} else {
return goog.string.isEmpty(name);
}
})())?"Object":name);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#object[",name__$1," ",[cljs.core.str(obj)].join(''),"]"], 0));
}

}
}
}
}
}
}
}
}
}
}

}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4423__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4423__auto__)){
var alt_impl = temp__4423__auto__;
var G__19161 = obj;
var G__19162 = writer;
var G__19163 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__19161,G__19162,G__19163) : alt_impl.call(null,G__19161,G__19162,G__19163));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__19168 = cljs.core.seq(cljs.core.next(objs));
var chunk__19169 = null;
var count__19170 = (0);
var i__19171 = (0);
while(true){
if((i__19171 < count__19170)){
var obj = chunk__19169.cljs$core$IIndexed$_nth$arity$2(null,i__19171);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__19172 = seq__19168;
var G__19173 = chunk__19169;
var G__19174 = count__19170;
var G__19175 = (i__19171 + (1));
seq__19168 = G__19172;
chunk__19169 = G__19173;
count__19170 = G__19174;
i__19171 = G__19175;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq(seq__19168);
if(temp__4425__auto__){
var seq__19168__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19168__$1)){
var c__5372__auto__ = cljs.core.chunk_first(seq__19168__$1);
var G__19176 = cljs.core.chunk_rest(seq__19168__$1);
var G__19177 = c__5372__auto__;
var G__19178 = cljs.core.count(c__5372__auto__);
var G__19179 = (0);
seq__19168 = G__19176;
chunk__19169 = G__19177;
count__19170 = G__19178;
i__19171 = G__19179;
continue;
} else {
var obj = cljs.core.first(seq__19168__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__19180 = cljs.core.next(seq__19168__$1);
var G__19181 = null;
var G__19182 = (0);
var G__19183 = (0);
seq__19168 = G__19180;
chunk__19169 = G__19181;
count__19170 = G__19182;
i__19171 = G__19183;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 *   options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 *   the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(var_args){
var args19184 = [];
var len__5627__auto___19187 = arguments.length;
var i__5628__auto___19188 = (0);
while(true){
if((i__5628__auto___19188 < len__5627__auto___19187)){
args19184.push((arguments[i__5628__auto___19188]));

var G__19189 = (i__5628__auto___19188 + (1));
i__5628__auto___19188 = G__19189;
continue;
} else {
}
break;
}

var G__19186 = args19184.length;
switch (G__19186) {
case 0:
return cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19184.length)].join('')));

}
});

cljs.core.newline.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.newline.cljs$core$IFn$_invoke$arity$1 = (function (opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});

cljs.core.newline.cljs$lang$maxFixedArity = 1;
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 */
cljs.core.pr_str = (function cljs$core$pr_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19192 = arguments.length;
var i__5628__auto___19193 = (0);
while(true){
if((i__5628__auto___19193 < len__5627__auto___19192)){
args__5634__auto__.push((arguments[i__5628__auto___19193]));

var G__19194 = (i__5628__auto___19193 + (1));
i__5628__auto___19193 = G__19194;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr_str.cljs$lang$maxFixedArity = (0);

cljs.core.pr_str.cljs$lang$applyTo = (function (seq19191){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19191));
});
/**
 * Same as pr-str followed by (newline)
 */
cljs.core.prn_str = (function cljs$core$prn_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19196 = arguments.length;
var i__5628__auto___19197 = (0);
while(true){
if((i__5628__auto___19197 < len__5627__auto___19196)){
args__5634__auto__.push((arguments[i__5628__auto___19197]));

var G__19198 = (i__5628__auto___19197 + (1));
i__5628__auto___19197 = G__19198;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.prn_str.cljs$lang$maxFixedArity = (0);

cljs.core.prn_str.cljs$lang$applyTo = (function (seq19195){
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19195));
});
/**
 * Prints the object(s) using string-print.  Prints the
 *   object(s), separated by spaces if there is more than one.
 *   By default, pr and prn print in a way that objects can be
 *   read by the reader
 */
cljs.core.pr = (function cljs$core$pr(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19200 = arguments.length;
var i__5628__auto___19201 = (0);
while(true){
if((i__5628__auto___19201 < len__5627__auto___19200)){
args__5634__auto__.push((arguments[i__5628__auto___19201]));

var G__19202 = (i__5628__auto___19201 + (1));
i__5628__auto___19201 = G__19202;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr.cljs$lang$maxFixedArity = (0);

cljs.core.pr.cljs$lang$applyTo = (function (seq19199){
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19199));
});
/**
 * Prints the object(s) using string-print.
 *   print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__19203__i = 0, G__19203__a = new Array(arguments.length -  0);
while (G__19203__i < G__19203__a.length) {G__19203__a[G__19203__i] = arguments[G__19203__i + 0]; ++G__19203__i;}
  objs = new cljs.core.IndexedSeq(G__19203__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__19204){
var objs = cljs.core.seq(arglist__19204);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 */
cljs.core.print_str = (function cljs$core$print_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19206 = arguments.length;
var i__5628__auto___19207 = (0);
while(true){
if((i__5628__auto___19207 < len__5627__auto___19206)){
args__5634__auto__.push((arguments[i__5628__auto___19207]));

var G__19208 = (i__5628__auto___19207 + (1));
i__5628__auto___19207 = G__19208;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.print_str.cljs$lang$maxFixedArity = (0);

cljs.core.print_str.cljs$lang$applyTo = (function (seq19205){
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19205));
});
/**
 * Same as print followed by (newline)
 */
cljs.core.println = (function cljs$core$println(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19210 = arguments.length;
var i__5628__auto___19211 = (0);
while(true){
if((i__5628__auto___19211 < len__5627__auto___19210)){
args__5634__auto__.push((arguments[i__5628__auto___19211]));

var G__19212 = (i__5628__auto___19211 + (1));
i__5628__auto___19211 = G__19212;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.println.cljs$lang$maxFixedArity = (0);

cljs.core.println.cljs$lang$applyTo = (function (seq19209){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19209));
});
/**
 * println to a string, returning it
 */
cljs.core.println_str = (function cljs$core$println_str(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19214 = arguments.length;
var i__5628__auto___19215 = (0);
while(true){
if((i__5628__auto___19215 < len__5627__auto___19214)){
args__5634__auto__.push((arguments[i__5628__auto___19215]));

var G__19216 = (i__5628__auto___19215 + (1));
i__5628__auto___19215 = G__19216;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
});

cljs.core.println_str.cljs$lang$maxFixedArity = (0);

cljs.core.println_str.cljs$lang$applyTo = (function (seq19213){
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19213));
});
/**
 * Same as pr followed by (newline).
 */
cljs.core.prn = (function cljs$core$prn(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19218 = arguments.length;
var i__5628__auto___19219 = (0);
while(true){
if((i__5628__auto___19219 < len__5627__auto___19218)){
args__5634__auto__.push((arguments[i__5628__auto___19219]));

var G__19220 = (i__5628__auto___19219 + (1));
i__5628__auto___19219 = G__19220;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((0) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((0)),(0))):null);
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(argseq__5635__auto__);
});

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.prn.cljs$lang$maxFixedArity = (0);

cljs.core.prn.cljs$lang$applyTo = (function (seq19217){
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19217));
});
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__19227_19233 = cljs.core.key(e);
var G__19228_19234 = w;
var G__19229_19235 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__19227_19233,G__19228_19234,G__19229_19235) : print_one.call(null,G__19227_19233,G__19228_19234,G__19229_19235));

cljs.core._write(w," ");

var G__19230 = cljs.core.val(e);
var G__19231 = w;
var G__19232 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__19230,G__19231,G__19232) : print_one.call(null,G__19230,G__19231,G__19232));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#object [cljs.core.Volatile ");

cljs.core.pr_writer(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"val","val",128701612),a__$1.state], null),writer,opts);

return cljs.core._write(writer,"]");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#object [cljs.core.Atom ");

cljs.core.pr_writer(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"val","val",128701612),a__$1.state], null),writer,opts);

return cljs.core._write(writer,"]");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if((y instanceof cljs.core.Symbol)){
return cljs.core.compare_symbols(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if((y instanceof cljs.core.Keyword)){
return cljs.core.compare_keywords(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.vector_QMARK_(y)){
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.vector_QMARK_(y)){
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 *   (apply f its-current-meta args)
 * 
 *   f must be free of side-effects
 */
cljs.core.alter_meta_BANG_ = (function cljs$core$alter_meta_BANG_(var_args){
var args__5634__auto__ = [];
var len__5627__auto___19239 = arguments.length;
var i__5628__auto___19240 = (0);
while(true){
if((i__5628__auto___19240 < len__5627__auto___19239)){
args__5634__auto__.push((arguments[i__5628__auto___19240]));

var G__19241 = (i__5628__auto___19240 + (1));
i__5628__auto___19240 = G__19241;
continue;
} else {
}
break;
}

var argseq__5635__auto__ = ((((2) < args__5634__auto__.length))?(new cljs.core.IndexedSeq(args__5634__auto__.slice((2)),(0))):null);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5635__auto__);
});

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
});

cljs.core.alter_meta_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.alter_meta_BANG_.cljs$lang$applyTo = (function (seq19236){
var G__19237 = cljs.core.first(seq19236);
var seq19236__$1 = cljs.core.next(seq19236);
var G__19238 = cljs.core.first(seq19236__$1);
var seq19236__$2 = cljs.core.next(seq19236__$1);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19237,G__19238,seq19236__$2);
});
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 *   Adds a watch function to an atom reference. The watch fn must be a
 *   fn of 4 args: a key, the reference, its old-state, its
 *   new-state. Whenever the reference's state might have been changed,
 *   any registered watches will have their functions called. The watch
 *   fn will be called synchronously. Note that an atom's state
 *   may have changed again prior to the fn call, so use old/new-state
 *   rather than derefing the reference. Keys must be unique per
 *   reference, and can be used to remove the watch with remove-watch,
 *   but are otherwise considered opaque by the watch mechanism.  Bear in
 *   mind that regardless of the result or action of the watch fns the
 *   atom's value will change.  Example:
 * 
 *    (def a (atom 0))
 *    (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 *    (swap! a inc)
 *    ;; Assertion Error
 *    (deref a)
 *    ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 *   Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
/**
 * @type {*}
 */
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 *   supplied, the name is prefix# where # is some unique number. If
 *   prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function cljs$core$gensym(var_args){
var args19242 = [];
var len__5627__auto___19245 = arguments.length;
var i__5628__auto___19246 = (0);
while(true){
if((i__5628__auto___19246 < len__5627__auto___19245)){
args19242.push((arguments[i__5628__auto___19246]));

var G__19247 = (i__5628__auto___19246 + (1));
i__5628__auto___19246 = G__19247;
continue;
} else {
}
break;
}

var G__19244 = args19242.length;
switch (G__19244) {
case 0:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19242.length)].join('')));

}
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("G__");
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});

cljs.core.gensym.cljs$lang$maxFixedArity = 1;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"value","value",1946509744,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__5167__auto__,writer__5168__auto__,opt__5169__auto__){
return cljs.core._write(writer__5168__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a delay or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__19249_SHARP_,p2__19250_SHARP_){
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(p1__19249_SHARP_,p2__19250_SHARP_) : rf.call(null,p1__19249_SHARP_,p2__19250_SHARP_));
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 *   collection, into the reduction.
 */
cljs.core.cat = (function cl