// Compiled by ClojureScript 1.7.145 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
c2.dom.select;

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__5224__auto__ = (((x == null))?null:x);
var m__5225__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__5224__auto__)]);
if(!((m__5225__auto__ == null))){
return m__5225__auto__.call(null,x);
} else {
var m__5225__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__5225__auto____$1 == null))){
return m__5225__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args20147 = [];
var len__5627__auto___20150 = arguments.length;
var i__5628__auto___20151 = (0);
while(true){
if((i__5628__auto___20151 < len__5627__auto___20150)){
args20147.push((arguments[i__5628__auto___20151]));

var G__20152 = (i__5628__auto___20151 + (1));
i__5628__auto___20151 = G__20152;
continue;
} else {
}
break;
}

var G__20149 = args20147.length;
switch (G__20149) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20147.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;
/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args20154 = [];
var len__5627__auto___20157 = arguments.length;
var i__5628__auto___20158 = (0);
while(true){
if((i__5628__auto___20158 < len__5627__auto___20157)){
args20154.push((arguments[i__5628__auto___20158]));

var G__20159 = (i__5628__auto___20158 + (1));
i__5628__auto___20158 = G__20159;
continue;
} else {
}
break;
}

var G__20156 = args20154.length;
switch (G__20156) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20154.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;
/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args20161 = [];
var len__5627__auto___20170 = arguments.length;
var i__5628__auto___20171 = (0);
while(true){
if((i__5628__auto___20171 < len__5627__auto___20170)){
args20161.push((arguments[i__5628__auto___20171]));

var G__20172 = (i__5628__auto___20171 + (1));
i__5628__auto___20171 = G__20172;
continue;
} else {
}
break;
}

var G__20163 = args20161.length;
switch (G__20163) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20161.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__20164_20174 = cljs.core.seq.call(null,x);
var chunk__20165_20175 = null;
var count__20166_20176 = (0);
var i__20167_20177 = (0);
while(true){
if((i__20167_20177 < count__20166_20176)){
var vec__20168_20178 = cljs.core._nth.call(null,chunk__20165_20175,i__20167_20177);
var k_20179 = cljs.core.nth.call(null,vec__20168_20178,(0),null);
var v_20180 = cljs.core.nth.call(null,vec__20168_20178,(1),null);
c2.dom.style.call(null,el__$1,k_20179,v_20180);

var G__20181 = seq__20164_20174;
var G__20182 = chunk__20165_20175;
var G__20183 = count__20166_20176;
var G__20184 = (i__20167_20177 + (1));
seq__20164_20174 = G__20181;
chunk__20165_20175 = G__20182;
count__20166_20176 = G__20183;
i__20167_20177 = G__20184;
continue;
} else {
var temp__4425__auto___20185 = cljs.core.seq.call(null,seq__20164_20174);
if(temp__4425__auto___20185){
var seq__20164_20186__$1 = temp__4425__auto___20185;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20164_20186__$1)){
var c__5372__auto___20187 = cljs.core.chunk_first.call(null,seq__20164_20186__$1);
var G__20188 = cljs.core.chunk_rest.call(null,seq__20164_20186__$1);
var G__20189 = c__5372__auto___20187;
var G__20190 = cljs.core.count.call(null,c__5372__auto___20187);
var G__20191 = (0);
seq__20164_20174 = G__20188;
chunk__20165_20175 = G__20189;
count__20166_20176 = G__20190;
i__20167_20177 = G__20191;
continue;
} else {
var vec__20169_20192 = cljs.core.first.call(null,seq__20164_20186__$1);
var k_20193 = cljs.core.nth.call(null,vec__20169_20192,(0),null);
var v_20194 = cljs.core.nth.call(null,vec__20169_20192,(1),null);
c2.dom.style.call(null,el__$1,k_20193,v_20194);

var G__20195 = cljs.core.next.call(null,seq__20164_20186__$1);
var G__20196 = null;
var G__20197 = (0);
var G__20198 = (0);
seq__20164_20174 = G__20195;
chunk__20165_20175 = G__20196;
count__20166_20176 = G__20197;
i__20167_20177 = G__20198;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args20199 = [];
var len__5627__auto___20212 = arguments.length;
var i__5628__auto___20213 = (0);
while(true){
if((i__5628__auto___20213 < len__5627__auto___20212)){
args20199.push((arguments[i__5628__auto___20213]));

var G__20214 = (i__5628__auto___20213 + (1));
i__5628__auto___20213 = G__20214;
continue;
} else {
}
break;
}

var G__20201 = args20199.length;
switch (G__20201) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20199.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__5341__auto__ = ((function (attrs){
return (function c2$dom$iter__20202(s__20203){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__20203__$1 = s__20203;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__20203__$1);
if(temp__4425__auto__){
var s__20203__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20203__$2)){
var c__5339__auto__ = cljs.core.chunk_first.call(null,s__20203__$2);
var size__5340__auto__ = cljs.core.count.call(null,c__5339__auto__);
var b__20205 = cljs.core.chunk_buffer.call(null,size__5340__auto__);
if((function (){var i__20204 = (0);
while(true){
if((i__20204 < size__5340__auto__)){
var i = cljs.core._nth.call(null,c__5339__auto__,i__20204);
cljs.core.chunk_append.call(null,b__20205,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__20216 = (i__20204 + (1));
i__20204 = G__20216;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20205),c2$dom$iter__20202.call(null,cljs.core.chunk_rest.call(null,s__20203__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20205),null);
}
} else {
var i = cljs.core.first.call(null,s__20203__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__20202.call(null,cljs.core.rest.call(null,s__20203__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__5341__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__20206_20217 = cljs.core.seq.call(null,x);
var chunk__20207_20218 = null;
var count__20208_20219 = (0);
var i__20209_20220 = (0);
while(true){
if((i__20209_20220 < count__20208_20219)){
var vec__20210_20221 = cljs.core._nth.call(null,chunk__20207_20218,i__20209_20220);
var k_20222 = cljs.core.nth.call(null,vec__20210_20221,(0),null);
var v_20223 = cljs.core.nth.call(null,vec__20210_20221,(1),null);
c2.dom.attr.call(null,el__$1,k_20222,v_20223);

var G__20224 = seq__20206_20217;
var G__20225 = chunk__20207_20218;
var G__20226 = count__20208_20219;
var G__20227 = (i__20209_20220 + (1));
seq__20206_20217 = G__20224;
chunk__20207_20218 = G__20225;
count__20208_20219 = G__20226;
i__20209_20220 = G__20227;
continue;
} else {
var temp__4425__auto___20228 = cljs.core.seq.call(null,seq__20206_20217);
if(temp__4425__auto___20228){
var seq__20206_20229__$1 = temp__4425__auto___20228;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20206_20229__$1)){
var c__5372__auto___20230 = cljs.core.chunk_first.call(null,seq__20206_20229__$1);
var G__20231 = cljs.core.chunk_rest.call(null,seq__20206_20229__$1);
var G__20232 = c__5372__auto___20230;
var G__20233 = cljs.core.count.call(null,c__5372__auto___20230);
var G__20234 = (0);
seq__20206_20217 = G__20231;
chunk__20207_20218 = G__20232;
count__20208_20219 = G__20233;
i__20209_20220 = G__20234;
continue;
} else {
var vec__20211_20235 = cljs.core.first.call(null,seq__20206_20229__$1);
var k_20236 = cljs.core.nth.call(null,vec__20211_20235,(0),null);
var v_20237 = cljs.core.nth.call(null,vec__20211_20235,(1),null);
c2.dom.attr.call(null,el__$1,k_20236,v_20237);

var G__20238 = cljs.core.next.call(null,seq__20206_20229__$1);
var G__20239 = null;
var G__20240 = (0);
var G__20241 = (0);
seq__20206_20217 = G__20238;
chunk__20207_20218 = G__20239;
count__20208_20219 = G__20240;
i__20209_20220 = G__20241;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;
/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args20242 = [];
var len__5627__auto___20245 = arguments.length;
var i__5628__auto___20246 = (0);
while(true){
if((i__5628__auto___20246 < len__5627__auto___20245)){
args20242.push((arguments[i__5628__auto___20246]));

var G__20247 = (i__5628__auto___20246 + (1));
i__5628__auto___20246 = G__20247;
continue;
} else {
}
break;
}

var G__20244 = args20242.length;
switch (G__20244) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20242.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;
/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args20249 = [];
var len__5627__auto___20252 = arguments.length;
var i__5628__auto___20253 = (0);
while(true){
if((i__5628__auto___20253 < len__5627__auto___20252)){
args20249.push((arguments[i__5628__auto___20253]));

var G__20254 = (i__5628__auto___20253 + (1));
i__5628__auto___20253 = G__20254;
continue;
} else {
}
break;
}

var G__20251 = args20249.length;
switch (G__20251) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20249.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;
/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__4569__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__4569__auto__)){
return or__4569__auto__;
} else {
var or__4569__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__4569__auto____$1)){
return or__4569__auto____$1;
} else {
return ((function (or__4569__auto____$1,or__4569__auto__){
return (function (p1__20256_SHARP_){
return setTimeout(((function (or__4569__auto____$1,or__4569__auto__){
return (function (){
return p1__20256_SHARP_.call(null);
});})(or__4569__auto____$1,or__4569__auto__))
,(10));
});
;})(or__4569__auto____$1,or__4569__auto__))
}
}
})();
